/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.SetUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u000bH\u0007J\u0014\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\u000bH\u0007J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000bJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/signal/core/util/BidiUtil;", "", "<init>", "()V", "ALL_ASCII_PATTERN", "Ljava/util/regex/Pattern;", "hasMixedTextDirection", "", "text", "", "isolateBidi", "", "stripBidiProtection", "stripBidiIndicator", "forceLtr", "Bidi", "core-util-jvm"})
public final class BidiUtil {
    @NotNull
    public static final BidiUtil INSTANCE = new BidiUtil();
    @NotNull
    private static final Pattern ALL_ASCII_PATTERN;

    private BidiUtil() {
    }

    @JvmStatic
    public static final boolean hasMixedTextDirection(@Nullable CharSequence text) {
        if (text == null) {
            return false;
        }
        Boolean isLtr = null;
        int len = Character.codePointCount(text, 0, text.length());
        for (int i = 0; i < len; ++i) {
            int codePoint = Character.codePointAt(text, i);
            byte direction = Character.getDirectionality(codePoint);
            boolean isLetter = Character.isLetter(codePoint);
            if (isLtr != null && isLtr.booleanValue() && direction != 0 && isLetter) {
                return true;
            }
            if (isLtr != null && !isLtr.booleanValue() && direction != 1 && isLetter) {
                return true;
            }
            if (!isLetter) continue;
            isLtr = direction == 0;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final String isolateBidi(@Nullable String text) {
        if (text == null) {
            return "";
        }
        if (((CharSequence)text).length() == 0) {
            return text;
        }
        if (ALL_ASCII_PATTERN.matcher(text).matches()) {
            return text;
        }
        int overrideCount = 0;
        int overrideCloseCount = 0;
        int isolateCount = 0;
        int isolateCloseCount = 0;
        int len = text.codePointCount(0, text.length());
        for (int i = 0; i < len; ++i) {
            int codePoint = text.codePointAt(i);
            if (Bidi.INSTANCE.getOVERRIDES().contains(codePoint)) {
                ++overrideCount;
                continue;
            }
            if (codePoint == Bidi.INSTANCE.getPDF()) {
                ++overrideCloseCount;
                continue;
            }
            if (Bidi.INSTANCE.getISOLATES().contains(codePoint)) {
                ++isolateCount;
                continue;
            }
            if (codePoint != Bidi.INSTANCE.getPDI()) continue;
            ++isolateCloseCount;
        }
        StringBuilder suffix = new StringBuilder();
        while (overrideCount > overrideCloseCount) {
            suffix.appendCodePoint(Bidi.INSTANCE.getPDF());
            ++overrideCloseCount;
        }
        while (isolateCount > isolateCloseCount) {
            suffix.appendCodePoint(Bidi.INSTANCE.getFSI());
            ++isolateCloseCount;
        }
        StringBuilder out = new StringBuilder();
        String string = out.appendCodePoint(Bidi.INSTANCE.getFSI()).append(text).append((CharSequence)suffix).appendCodePoint(Bidi.INSTANCE.getPDI()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String stripBidiProtection(@Nullable String text) {
        if (text == null) {
            return null;
        }
        CharSequence charSequence = text;
        Regex regex = new Regex("[\\u2068\\u2069\\u202c]");
        String string = "";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public final String stripBidiIndicator(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return StringsKt.replace$default((String)text, (String)"\u200f", (String)"", (boolean)false, (int)4, null);
    }

    @JvmStatic
    @NotNull
    public static final String forceLtr(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return "\u202a" + text + "\u202c";
    }

    static {
        Pattern pattern = Pattern.compile("^[\\x00-\\x7F]*$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        ALL_ASCII_PATTERN = pattern;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\f\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/signal/core/util/BidiUtil$Bidi;", "", "<init>", "()V", "OVERRIDES", "", "", "getOVERRIDES", "()Ljava/util/Set;", "ISOLATES", "getISOLATES", "PDF", "getPDF", "()I", "PDI", "getPDI", "FSI", "getFSI", "core-util-jvm"})
    private static final class Bidi {
        @NotNull
        public static final Bidi INSTANCE = new Bidi();
        @NotNull
        private static final Set<Integer> OVERRIDES;
        @NotNull
        private static final Set<Integer> ISOLATES;
        private static final int PDF;
        private static final int PDI;
        private static final int FSI;

        private Bidi() {
        }

        @NotNull
        public final Set<Integer> getOVERRIDES() {
            return OVERRIDES;
        }

        @NotNull
        public final Set<Integer> getISOLATES() {
            return ISOLATES;
        }

        public final int getPDF() {
            return PDF;
        }

        public final int getPDI() {
            return PDI;
        }

        public final int getFSI() {
            return FSI;
        }

        static {
            Integer[] integerArray = new Integer[]{"\u202a".codePointAt(0), "\u202b".codePointAt(0), "\u202d".codePointAt(0), "\u202e".codePointAt(0)};
            HashSet<Integer> hashSet = SetUtil.newHashSet(integerArray);
            Intrinsics.checkNotNullExpressionValue(hashSet, (String)"newHashSet(...)");
            OVERRIDES = hashSet;
            integerArray = new Integer[]{"\u2066".codePointAt(0), "\u2067".codePointAt(0), "\u2068".codePointAt(0)};
            HashSet<Integer> hashSet2 = SetUtil.newHashSet(integerArray);
            Intrinsics.checkNotNullExpressionValue(hashSet2, (String)"newHashSet(...)");
            ISOLATES = hashSet2;
            PDF = "\u202c".codePointAt(0);
            PDI = "\u2069".codePointAt(0);
            FSI = "\u2068".codePointAt(0);
        }
    }
}

