// Code generated by sdkgen-v2. DO NOT EDIT.
package dnssdk

import (
	"context"

	access "github.com/yandex-cloud/go-genproto/yandex/cloud/access"
	dns "github.com/yandex-cloud/go-genproto/yandex/cloud/dns/v1"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	sdkop "github.com/yandex-cloud/go-sdk/v2/pkg/operation"
	"github.com/yandex-cloud/go-sdk/v2/pkg/transport"
	"google.golang.org/grpc"
	proto "google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/reflect/protoreflect"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// DnsZoneClient provides methods for managing DnsZone resources of Yandex.Cloud Dns.
type DnsZoneClient interface {
	Get(context.Context, *dns.GetDnsZoneRequest, ...grpc.CallOption) (*dns.DnsZone, error)
	List(context.Context, *dns.ListDnsZonesRequest, ...grpc.CallOption) (*dns.ListDnsZonesResponse, error)
	Create(context.Context, *dns.CreateDnsZoneRequest, ...grpc.CallOption) (*DnsZoneCreateOperation, error)
	Update(context.Context, *dns.UpdateDnsZoneRequest, ...grpc.CallOption) (*DnsZoneUpdateOperation, error)
	Move(context.Context, *dns.MoveDnsZoneRequest, ...grpc.CallOption) (*DnsZoneMoveOperation, error)
	Delete(context.Context, *dns.DeleteDnsZoneRequest, ...grpc.CallOption) (*DnsZoneDeleteOperation, error)
	GetRecordSet(context.Context, *dns.GetDnsZoneRecordSetRequest, ...grpc.CallOption) (*dns.RecordSet, error)
	ListRecordSets(context.Context, *dns.ListDnsZoneRecordSetsRequest, ...grpc.CallOption) (*dns.ListDnsZoneRecordSetsResponse, error)
	UpdateRecordSets(context.Context, *dns.UpdateRecordSetsRequest, ...grpc.CallOption) (*DnsZoneUpdateRecordSetsOperation, error)
	UpsertRecordSets(context.Context, *dns.UpsertRecordSetsRequest, ...grpc.CallOption) (*DnsZoneUpsertRecordSetsOperation, error)
	ListOperations(context.Context, *dns.ListDnsZoneOperationsRequest, ...grpc.CallOption) (*dns.ListDnsZoneOperationsResponse, error)
	ListAccessBindings(context.Context, *access.ListAccessBindingsRequest, ...grpc.CallOption) (*access.ListAccessBindingsResponse, error)
	SetAccessBindings(context.Context, *access.SetAccessBindingsRequest, ...grpc.CallOption) (*DnsZoneSetAccessBindingsOperation, error)
	UpdateAccessBindings(context.Context, *access.UpdateAccessBindingsRequest, ...grpc.CallOption) (*DnsZoneUpdateAccessBindingsOperation, error)
	UpdatePrivateNetworks(context.Context, *dns.UpdateDnsZonePrivateNetworksRequest, ...grpc.CallOption) (*DnsZoneUpdatePrivateNetworksOperation, error)
}

var _ DnsZoneClient = dnsZoneClient{}

type dnsZoneClient struct {
	connector transport.Connector
}

// NewDnsZoneClient returns DnsZoneClient implementation.
func NewDnsZoneClient(connector transport.Connector) DnsZoneClient {
	return dnsZoneClient{connector}
}

// Get is an operation of Yandex.Cloud Dns DnsZone service.
func (c dnsZoneClient) Get(ctx context.Context, in *dns.GetDnsZoneRequest, opts ...grpc.CallOption) (*dns.DnsZone, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneGet, opts...)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(connection).Get(ctx, in, opts...)
}

// List is an operation of Yandex.Cloud Dns DnsZone service.
func (c dnsZoneClient) List(ctx context.Context, in *dns.ListDnsZonesRequest, opts ...grpc.CallOption) (*dns.ListDnsZonesResponse, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneList, opts...)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(connection).List(ctx, in, opts...)
}

// DnsZoneCreateOperation is used to monitor the state of Create operations.
type DnsZoneCreateOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *DnsZoneCreateOperation) Metadata() *dns.CreateDnsZoneMetadata {
	return o.Operation.Metadata().(*dns.CreateDnsZoneMetadata)
}

// Response retrieves the operation response.
func (o *DnsZoneCreateOperation) Response() *dns.DnsZone {
	return o.Operation.Response().(*dns.DnsZone)
}

// Wait polls the operation until it's done.
func (o *DnsZoneCreateOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*dns.DnsZone, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*dns.DnsZone)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *DnsZoneCreateOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*dns.DnsZone, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*dns.DnsZone)
	return response, err
}

// Create is an operation of Yandex.Cloud Dns DnsZone service.
// It returns an object which should be used to monitor the operation state.
func (c dnsZoneClient) Create(ctx context.Context, in *dns.CreateDnsZoneRequest, opts ...grpc.CallOption) (*DnsZoneCreateOperation, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneCreate, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := dns.NewDnsZoneServiceClient(connection).Create(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll: c.pollOperation,
		GetResourceID: func(metadata proto.Message) string {
			return metadata.(*dns.CreateDnsZoneMetadata).GetDnsZoneId()
		},
		MetadataType: (*dns.CreateDnsZoneMetadata)(nil),
		ResponseType: (*dns.DnsZone)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &DnsZoneCreateOperation{*op}, nil
}

// DnsZoneUpdateOperation is used to monitor the state of Update operations.
type DnsZoneUpdateOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *DnsZoneUpdateOperation) Metadata() *dns.UpdateDnsZoneMetadata {
	return o.Operation.Metadata().(*dns.UpdateDnsZoneMetadata)
}

// Response retrieves the operation response.
func (o *DnsZoneUpdateOperation) Response() *dns.DnsZone {
	return o.Operation.Response().(*dns.DnsZone)
}

// Wait polls the operation until it's done.
func (o *DnsZoneUpdateOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*dns.DnsZone, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*dns.DnsZone)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *DnsZoneUpdateOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*dns.DnsZone, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*dns.DnsZone)
	return response, err
}

// Update is an operation of Yandex.Cloud Dns DnsZone service.
// It returns an object which should be used to monitor the operation state.
func (c dnsZoneClient) Update(ctx context.Context, in *dns.UpdateDnsZoneRequest, opts ...grpc.CallOption) (*DnsZoneUpdateOperation, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneUpdate, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := dns.NewDnsZoneServiceClient(connection).Update(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll: c.pollOperation,
		GetResourceID: func(metadata proto.Message) string {
			return metadata.(*dns.UpdateDnsZoneMetadata).GetDnsZoneId()
		},
		MetadataType: (*dns.UpdateDnsZoneMetadata)(nil),
		ResponseType: (*dns.DnsZone)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &DnsZoneUpdateOperation{*op}, nil
}

// DnsZoneMoveOperation is used to monitor the state of Move operations.
type DnsZoneMoveOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *DnsZoneMoveOperation) Metadata() *dns.MoveDnsZoneMetadata {
	return o.Operation.Metadata().(*dns.MoveDnsZoneMetadata)
}

// Response retrieves the operation response.
func (o *DnsZoneMoveOperation) Response() *dns.DnsZone {
	return o.Operation.Response().(*dns.DnsZone)
}

// Wait polls the operation until it's done.
func (o *DnsZoneMoveOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*dns.DnsZone, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*dns.DnsZone)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *DnsZoneMoveOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*dns.DnsZone, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*dns.DnsZone)
	return response, err
}

// Move is an operation of Yandex.Cloud Dns DnsZone service.
// It returns an object which should be used to monitor the operation state.
func (c dnsZoneClient) Move(ctx context.Context, in *dns.MoveDnsZoneRequest, opts ...grpc.CallOption) (*DnsZoneMoveOperation, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneMove, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := dns.NewDnsZoneServiceClient(connection).Move(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll: c.pollOperation,
		GetResourceID: func(metadata proto.Message) string {
			return metadata.(*dns.MoveDnsZoneMetadata).GetDnsZoneId()
		},
		MetadataType: (*dns.MoveDnsZoneMetadata)(nil),
		ResponseType: (*dns.DnsZone)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &DnsZoneMoveOperation{*op}, nil
}

// DnsZoneDeleteOperation is used to monitor the state of Delete operations.
type DnsZoneDeleteOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *DnsZoneDeleteOperation) Metadata() *dns.DeleteDnsZoneMetadata {
	return o.Operation.Metadata().(*dns.DeleteDnsZoneMetadata)
}

// Response retrieves the operation response.
func (o *DnsZoneDeleteOperation) Response() *emptypb.Empty {
	return o.Operation.Response().(*emptypb.Empty)
}

// Wait polls the operation until it's done.
func (o *DnsZoneDeleteOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *DnsZoneDeleteOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// Delete is an operation of Yandex.Cloud Dns DnsZone service.
// It returns an object which should be used to monitor the operation state.
func (c dnsZoneClient) Delete(ctx context.Context, in *dns.DeleteDnsZoneRequest, opts ...grpc.CallOption) (*DnsZoneDeleteOperation, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneDelete, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := dns.NewDnsZoneServiceClient(connection).Delete(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll: c.pollOperation,
		GetResourceID: func(metadata proto.Message) string {
			return metadata.(*dns.DeleteDnsZoneMetadata).GetDnsZoneId()
		},
		MetadataType: (*dns.DeleteDnsZoneMetadata)(nil),
		ResponseType: (*emptypb.Empty)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &DnsZoneDeleteOperation{*op}, nil
}

// GetRecordSet is an operation of Yandex.Cloud Dns DnsZone service.
func (c dnsZoneClient) GetRecordSet(ctx context.Context, in *dns.GetDnsZoneRecordSetRequest, opts ...grpc.CallOption) (*dns.RecordSet, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneGetRecordSet, opts...)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(connection).GetRecordSet(ctx, in, opts...)
}

// ListRecordSets is an operation of Yandex.Cloud Dns DnsZone service.
func (c dnsZoneClient) ListRecordSets(ctx context.Context, in *dns.ListDnsZoneRecordSetsRequest, opts ...grpc.CallOption) (*dns.ListDnsZoneRecordSetsResponse, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneListRecordSets, opts...)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(connection).ListRecordSets(ctx, in, opts...)
}

// DnsZoneUpdateRecordSetsOperation is used to monitor the state of UpdateRecordSets operations.
type DnsZoneUpdateRecordSetsOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *DnsZoneUpdateRecordSetsOperation) Metadata() *dns.UpdateRecordSetsMetadata {
	return o.Operation.Metadata().(*dns.UpdateRecordSetsMetadata)
}

// Response retrieves the operation response.
func (o *DnsZoneUpdateRecordSetsOperation) Response() *dns.RecordSetDiff {
	return o.Operation.Response().(*dns.RecordSetDiff)
}

// Wait polls the operation until it's done.
func (o *DnsZoneUpdateRecordSetsOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*dns.RecordSetDiff, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*dns.RecordSetDiff)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *DnsZoneUpdateRecordSetsOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*dns.RecordSetDiff, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*dns.RecordSetDiff)
	return response, err
}

// UpdateRecordSets is an operation of Yandex.Cloud Dns DnsZone service.
// It returns an object which should be used to monitor the operation state.
func (c dnsZoneClient) UpdateRecordSets(ctx context.Context, in *dns.UpdateRecordSetsRequest, opts ...grpc.CallOption) (*DnsZoneUpdateRecordSetsOperation, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneUpdateRecordSets, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := dns.NewDnsZoneServiceClient(connection).UpdateRecordSets(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll:         c.pollOperation,
		MetadataType: (*dns.UpdateRecordSetsMetadata)(nil),
		ResponseType: (*dns.RecordSetDiff)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &DnsZoneUpdateRecordSetsOperation{*op}, nil
}

// DnsZoneUpsertRecordSetsOperation is used to monitor the state of UpsertRecordSets operations.
type DnsZoneUpsertRecordSetsOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *DnsZoneUpsertRecordSetsOperation) Metadata() *dns.UpsertRecordSetsMetadata {
	return o.Operation.Metadata().(*dns.UpsertRecordSetsMetadata)
}

// Response retrieves the operation response.
func (o *DnsZoneUpsertRecordSetsOperation) Response() *dns.RecordSetDiff {
	return o.Operation.Response().(*dns.RecordSetDiff)
}

// Wait polls the operation until it's done.
func (o *DnsZoneUpsertRecordSetsOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*dns.RecordSetDiff, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*dns.RecordSetDiff)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *DnsZoneUpsertRecordSetsOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*dns.RecordSetDiff, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*dns.RecordSetDiff)
	return response, err
}

// UpsertRecordSets is an operation of Yandex.Cloud Dns DnsZone service.
// It returns an object which should be used to monitor the operation state.
func (c dnsZoneClient) UpsertRecordSets(ctx context.Context, in *dns.UpsertRecordSetsRequest, opts ...grpc.CallOption) (*DnsZoneUpsertRecordSetsOperation, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneUpsertRecordSets, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := dns.NewDnsZoneServiceClient(connection).UpsertRecordSets(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll:         c.pollOperation,
		MetadataType: (*dns.UpsertRecordSetsMetadata)(nil),
		ResponseType: (*dns.RecordSetDiff)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &DnsZoneUpsertRecordSetsOperation{*op}, nil
}

// ListOperations is an operation of Yandex.Cloud Dns DnsZone service.
func (c dnsZoneClient) ListOperations(ctx context.Context, in *dns.ListDnsZoneOperationsRequest, opts ...grpc.CallOption) (*dns.ListDnsZoneOperationsResponse, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneListOperations, opts...)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(connection).ListOperations(ctx, in, opts...)
}

// ListAccessBindings is an operation of Yandex.Cloud Dns DnsZone service.
func (c dnsZoneClient) ListAccessBindings(ctx context.Context, in *access.ListAccessBindingsRequest, opts ...grpc.CallOption) (*access.ListAccessBindingsResponse, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneListAccessBindings, opts...)
	if err != nil {
		return nil, err
	}
	return dns.NewDnsZoneServiceClient(connection).ListAccessBindings(ctx, in, opts...)
}

// DnsZoneSetAccessBindingsOperation is used to monitor the state of SetAccessBindings operations.
type DnsZoneSetAccessBindingsOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *DnsZoneSetAccessBindingsOperation) Metadata() *access.SetAccessBindingsMetadata {
	return o.Operation.Metadata().(*access.SetAccessBindingsMetadata)
}

// Response retrieves the operation response.
func (o *DnsZoneSetAccessBindingsOperation) Response() *emptypb.Empty {
	return o.Operation.Response().(*emptypb.Empty)
}

// Wait polls the operation until it's done.
func (o *DnsZoneSetAccessBindingsOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *DnsZoneSetAccessBindingsOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// SetAccessBindings is an operation of Yandex.Cloud Dns DnsZone service.
// It returns an object which should be used to monitor the operation state.
func (c dnsZoneClient) SetAccessBindings(ctx context.Context, in *access.SetAccessBindingsRequest, opts ...grpc.CallOption) (*DnsZoneSetAccessBindingsOperation, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneSetAccessBindings, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := dns.NewDnsZoneServiceClient(connection).SetAccessBindings(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll:         c.pollOperation,
		MetadataType: (*access.SetAccessBindingsMetadata)(nil),
		ResponseType: (*emptypb.Empty)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &DnsZoneSetAccessBindingsOperation{*op}, nil
}

// DnsZoneUpdateAccessBindingsOperation is used to monitor the state of UpdateAccessBindings operations.
type DnsZoneUpdateAccessBindingsOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *DnsZoneUpdateAccessBindingsOperation) Metadata() *access.UpdateAccessBindingsMetadata {
	return o.Operation.Metadata().(*access.UpdateAccessBindingsMetadata)
}

// Response retrieves the operation response.
func (o *DnsZoneUpdateAccessBindingsOperation) Response() *emptypb.Empty {
	return o.Operation.Response().(*emptypb.Empty)
}

// Wait polls the operation until it's done.
func (o *DnsZoneUpdateAccessBindingsOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *DnsZoneUpdateAccessBindingsOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*emptypb.Empty)
	return response, err
}

// UpdateAccessBindings is an operation of Yandex.Cloud Dns DnsZone service.
// It returns an object which should be used to monitor the operation state.
func (c dnsZoneClient) UpdateAccessBindings(ctx context.Context, in *access.UpdateAccessBindingsRequest, opts ...grpc.CallOption) (*DnsZoneUpdateAccessBindingsOperation, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneUpdateAccessBindings, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := dns.NewDnsZoneServiceClient(connection).UpdateAccessBindings(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll:         c.pollOperation,
		MetadataType: (*access.UpdateAccessBindingsMetadata)(nil),
		ResponseType: (*emptypb.Empty)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &DnsZoneUpdateAccessBindingsOperation{*op}, nil
}

// DnsZoneUpdatePrivateNetworksOperation is used to monitor the state of UpdatePrivateNetworks operations.
type DnsZoneUpdatePrivateNetworksOperation struct {
	sdkop.Operation
}

// Metadata retrieves the operation metadata.
func (o *DnsZoneUpdatePrivateNetworksOperation) Metadata() *dns.UpdateDnsZonePrivateNetworksMetadata {
	return o.Operation.Metadata().(*dns.UpdateDnsZonePrivateNetworksMetadata)
}

// Response retrieves the operation response.
func (o *DnsZoneUpdatePrivateNetworksOperation) Response() *dns.DnsZone {
	return o.Operation.Response().(*dns.DnsZone)
}

// Wait polls the operation until it's done.
func (o *DnsZoneUpdatePrivateNetworksOperation) Wait(ctx context.Context, opts ...grpc.CallOption) (*dns.DnsZone, error) {
	abstract, err := o.Operation.Wait(ctx, opts...)
	response, _ := abstract.(*dns.DnsZone)
	return response, err
}

// WaitInterval polls the operation until it's done with custom interval.
func (o *DnsZoneUpdatePrivateNetworksOperation) WaitInterval(ctx context.Context, pollInterval sdkop.PollIntervalFunc, opts ...grpc.CallOption) (*dns.DnsZone, error) {
	abstract, err := o.Operation.WaitInterval(ctx, pollInterval, opts...)
	response, _ := abstract.(*dns.DnsZone)
	return response, err
}

// UpdatePrivateNetworks is an operation of Yandex.Cloud Dns DnsZone service.
// It returns an object which should be used to monitor the operation state.
func (c dnsZoneClient) UpdatePrivateNetworks(ctx context.Context, in *dns.UpdateDnsZonePrivateNetworksRequest, opts ...grpc.CallOption) (*DnsZoneUpdatePrivateNetworksOperation, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneUpdatePrivateNetworks, opts...)
	if err != nil {
		return nil, err
	}
	pb, err := dns.NewDnsZoneServiceClient(connection).UpdatePrivateNetworks(ctx, in, opts...)
	if err != nil {
		return nil, err
	}
	op, err := sdkop.NewOperation(pb, &sdkop.Concretization{
		Poll: c.pollOperation,
		GetResourceID: func(metadata proto.Message) string {
			return metadata.(*dns.UpdateDnsZonePrivateNetworksMetadata).GetDnsZoneId()
		},
		MetadataType: (*dns.UpdateDnsZonePrivateNetworksMetadata)(nil),
		ResponseType: (*dns.DnsZone)(nil),
	})
	if err != nil {
		return nil, err
	}
	return &DnsZoneUpdatePrivateNetworksOperation{*op}, nil
}

// pollOperation returns the current state of the polled operation.
func (c dnsZoneClient) pollOperation(ctx context.Context, operationId string, opts ...grpc.CallOption) (sdkop.YCOperation, error) {
	connection, err := c.connector.GetConnection(ctx, DnsZoneOperationPoller, opts...)
	if err != nil {
		return nil, err
	}
	return operation.NewOperationServiceClient(connection).Get(ctx, &operation.GetOperationRequest{OperationId: operationId}, opts...)
}

var (
	DnsZoneGet                   = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.Get")
	DnsZoneList                  = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.List")
	DnsZoneCreate                = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.Create")
	DnsZoneUpdate                = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.Update")
	DnsZoneMove                  = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.Move")
	DnsZoneDelete                = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.Delete")
	DnsZoneGetRecordSet          = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.GetRecordSet")
	DnsZoneListRecordSets        = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.ListRecordSets")
	DnsZoneUpdateRecordSets      = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.UpdateRecordSets")
	DnsZoneUpsertRecordSets      = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.UpsertRecordSets")
	DnsZoneListOperations        = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.ListOperations")
	DnsZoneListAccessBindings    = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.ListAccessBindings")
	DnsZoneSetAccessBindings     = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.SetAccessBindings")
	DnsZoneUpdateAccessBindings  = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.UpdateAccessBindings")
	DnsZoneUpdatePrivateNetworks = protoreflect.FullName("yandex.cloud.dns.v1.DnsZoneService.UpdatePrivateNetworks")
	DnsZoneOperationPoller       = protoreflect.FullName("yandex.cloud.operation.OperationService.Get")
)
