from cairocffi.ffi import ffi as cairocffi_ffi
from cffi import FFI

pango_ffi = FFI()

pango_ffi.include(cairocffi_ffi)

pango_ffi.cdef(
    """
    typedef ... PangoContext;
    typedef ... PangoLayout;
    typedef ... PangoFontDescription;
    typedef ... PangoAttrList;
    typedef enum {
        PANGO_ALIGN_LEFT,
        PANGO_ALIGN_CENTER,
        PANGO_ALIGN_RIGHT
    } PangoAlignment;
    typedef enum {
        PANGO_ELLIPSEIZE_NONE,
        PANGO_ELLIPSIZE_START,
        PANGO_ELLIPSIZE_MIDDLE,
        PANGO_ELLIPSIZE_END
    } PangoEllipsizeMode;

    int
    pango_units_from_double (double d);
    double
    pango_units_to_double (int i);

    typedef void* gpointer;
    typedef int gboolean;
    typedef unsigned int guint32;
    typedef guint32 gunichar;
    typedef char gchar;
    typedef signed long gssize;
    typedef ... GError;
    typedef int gint;

    void
    pango_cairo_show_layout (cairo_t *cr,
                             PangoLayout *layout);

    gboolean
    pango_parse_markup (const char *markup_text,
                        int length,
                        gunichar accel_marker,
                        PangoAttrList **attr_list,
                        char **text,
                        gunichar *accel_char,
                        GError **error);

    // https://developer.gnome.org/pango/stable/pango-Layout-Objects.html
    PangoLayout *pango_cairo_create_layout (cairo_t *cr);
    void g_object_unref(gpointer object);

    void
    pango_layout_set_font_description (PangoLayout *layout,
                                       const PangoFontDescription *desc);
    const PangoFontDescription *
    pango_layout_get_font_description (PangoLayout *layout);

    void
    pango_layout_set_alignment (PangoLayout *layout,
                                PangoAlignment alignment);
    void
    pango_layout_set_attributes (PangoLayout *layout,
                                 PangoAttrList *attrs);
    void
    pango_layout_set_text (PangoLayout *layout,
                           const char *text,
                           int length);
    const char *
    pango_layout_get_text (PangoLayout *layout);

    void
    pango_layout_get_pixel_size (PangoLayout *layout,
                                 int *width,
                                 int *height);

    void
    pango_layout_set_width (PangoLayout *layout,
                            int width);

    void
    pango_layout_set_ellipsize (PangoLayout *layout,
                                PangoEllipsizeMode  ellipsize);

    PangoEllipsizeMode
    pango_layout_get_ellipsize (PangoLayout *layout);

    // https://developer.gnome.org/pango/stable/pango-Fonts.html#PangoFontDescription
    PangoFontDescription *pango_font_description_new (void);
    void pango_font_description_free (PangoFontDescription *desc);

    PangoFontDescription *
    pango_font_description_from_string (const char *str);

    void
    pango_font_description_set_family (PangoFontDescription *desc,
                                       const char *family);
    const char *
    pango_font_description_get_family (const PangoFontDescription *desc);

    void
    pango_font_description_set_absolute_size
                                   (PangoFontDescription *desc,
                                    double size);
    void
    pango_font_description_set_size (PangoFontDescription *desc,
                                     gint size);

    gint
    pango_font_description_get_size (const PangoFontDescription *desc);

    // https://developer.gnome.org/glib/stable/glib-Simple-XML-Subset-Parser.html
    gchar *
    g_markup_escape_text(const gchar *text,
                         gssize length);
"""
)
