/* crc32.h -- tables for rapid CRC calculation
 * Generated automatically by crc32.c
 */

typedef uint32_t crc_t;

static const crc_t crc_table[] = {
    0x00000000, 0x90910101, 0x91210201, 0x01b00300, 0x92410401,
    0x02d00500, 0x03600600, 0x93f10701, 0x94810801, 0x04100900,
    0x05a00a00, 0x95310b01, 0x06c00c00, 0x96510d01, 0x97e10e01,
    0x07700f00, 0x99011001, 0x09901100, 0x08201200, 0x98b11301,
    0x0b401400, 0x9bd11501, 0x9a611601, 0x0af01700, 0x0d801800,
    0x9d111901, 0x9ca11a01, 0x0c301b00, 0x9fc11c01, 0x0f501d00,
    0x0ee01e00, 0x9e711f01, 0x82012001, 0x12902100, 0x13202200,
    0x83b12301, 0x10402400, 0x80d12501, 0x81612601, 0x11f02700,
    0x16802800, 0x86112901, 0x87a12a01, 0x17302b00, 0x84c12c01,
    0x14502d00, 0x15e02e00, 0x85712f01, 0x1b003000, 0x8b913101,
    0x8a213201, 0x1ab03300, 0x89413401, 0x19d03500, 0x18603600,
    0x88f13701, 0x8f813801, 0x1f103900, 0x1ea03a00, 0x8e313b01,
    0x1dc03c00, 0x8d513d01, 0x8ce13e01, 0x1c703f00, 0xb4014001,
    0x24904100, 0x25204200, 0xb5b14301, 0x26404400, 0xb6d14501,
    0xb7614601, 0x27f04700, 0x20804800, 0xb0114901, 0xb1a14a01,
    0x21304b00, 0xb2c14c01, 0x22504d00, 0x23e04e00, 0xb3714f01,
    0x2d005000, 0xbd915101, 0xbc215201, 0x2cb05300, 0xbf415401,
    0x2fd05500, 0x2e605600, 0xbef15701, 0xb9815801, 0x29105900,
    0x28a05a00, 0xb8315b01, 0x2bc05c00, 0xbb515d01, 0xbae15e01,
    0x2a705f00, 0x36006000, 0xa6916101, 0xa7216201, 0x37b06300,
    0xa4416401, 0x34d06500, 0x35606600, 0xa5f16701, 0xa2816801,
    0x32106900, 0x33a06a00, 0xa3316b01, 0x30c06c00, 0xa0516d01,
    0xa1e16e01, 0x31706f00, 0xaf017001, 0x3f907100, 0x3e207200,
    0xaeb17301, 0x3d407400, 0xadd17501, 0xac617601, 0x3cf07700,
    0x3b807800, 0xab117901, 0xaaa17a01, 0x3a307b00, 0xa9c17c01,
    0x39507d00, 0x38e07e00, 0xa8717f01, 0xd8018001, 0x48908100,
    0x49208200, 0xd9b18301, 0x4a408400, 0xdad18501, 0xdb618601,
    0x4bf08700, 0x4c808800, 0xdc118901, 0xdda18a01, 0x4d308b00,
    0xdec18c01, 0x4e508d00, 0x4fe08e00, 0xdf718f01, 0x41009000,
    0xd1919101, 0xd0219201, 0x40b09300, 0xd3419401, 0x43d09500,
    0x42609600, 0xd2f19701, 0xd5819801, 0x45109900, 0x44a09a00,
    0xd4319b01, 0x47c09c00, 0xd7519d01, 0xd6e19e01, 0x46709f00,
    0x5a00a000, 0xca91a101, 0xcb21a201, 0x5bb0a300, 0xc841a401,
    0x58d0a500, 0x5960a600, 0xc9f1a701, 0xce81a801, 0x5e10a900,
    0x5fa0aa00, 0xcf31ab01, 0x5cc0ac00, 0xcc51ad01, 0xcde1ae01,
    0x5d70af00, 0xc301b001, 0x5390b100, 0x5220b200, 0xc2b1b301,
    0x5140b400, 0xc1d1b501, 0xc061b601, 0x50f0b700, 0x5780b800,
    0xc711b901, 0xc6a1ba01, 0x5630bb00, 0xc5c1bc01, 0x5550bd00,
    0x54e0be00, 0xc471bf01, 0x6c00c000, 0xfc91c101, 0xfd21c201,
    0x6db0c300, 0xfe41c401, 0x6ed0c500, 0x6f60c600, 0xfff1c701,
    0xf881c801, 0x6810c900, 0x69a0ca00, 0xf931cb01, 0x6ac0cc00,
    0xfa51cd01, 0xfbe1ce01, 0x6b70cf00, 0xf501d001, 0x6590d100,
    0x6420d200, 0xf4b1d301, 0x6740d400, 0xf7d1d501, 0xf661d601,
    0x66f0d700, 0x6180d800, 0xf111d901, 0xf0a1da01, 0x6030db00,
    0xf3c1dc01, 0x6350dd00, 0x62e0de00, 0xf271df01, 0xee01e001,
    0x7e90e100, 0x7f20e200, 0xefb1e301, 0x7c40e400, 0xecd1e501,
    0xed61e601, 0x7df0e700, 0x7a80e800, 0xea11e901, 0xeba1ea01,
    0x7b30eb00, 0xe8c1ec01, 0x7850ed00, 0x79e0ee00, 0xe971ef01,
    0x7700f000, 0xe791f101, 0xe621f201, 0x76b0f300, 0xe541f401,
    0x75d0f500, 0x7460f600, 0xe4f1f701, 0xe381f801, 0x7310f900,
    0x72a0fa00, 0xe231fb01, 0x71c0fc00, 0xe151fd01, 0xe0e1fe01,
    0x7070ff00};

#ifdef W

#if W == 8

static const word_t crc_big_table[] = {
    0x0000000000000000, 0x0101919000000000, 0x0102219100000000,
    0x0003b00100000000, 0x0104419200000000, 0x0005d00200000000,
    0x0006600300000000, 0x0107f19300000000, 0x0108819400000000,
    0x0009100400000000, 0x000aa00500000000, 0x010b319500000000,
    0x000cc00600000000, 0x010d519600000000, 0x010ee19700000000,
    0x000f700700000000, 0x0110019900000000, 0x0011900900000000,
    0x0012200800000000, 0x0113b19800000000, 0x0014400b00000000,
    0x0115d19b00000000, 0x0116619a00000000, 0x0017f00a00000000,
    0x0018800d00000000, 0x0119119d00000000, 0x011aa19c00000000,
    0x001b300c00000000, 0x011cc19f00000000, 0x001d500f00000000,
    0x001ee00e00000000, 0x011f719e00000000, 0x0120018200000000,
    0x0021901200000000, 0x0022201300000000, 0x0123b18300000000,
    0x0024401000000000, 0x0125d18000000000, 0x0126618100000000,
    0x0027f01100000000, 0x0028801600000000, 0x0129118600000000,
    0x012aa18700000000, 0x002b301700000000, 0x012cc18400000000,
    0x002d501400000000, 0x002ee01500000000, 0x012f718500000000,
    0x0030001b00000000, 0x0131918b00000000, 0x0132218a00000000,
    0x0033b01a00000000, 0x0134418900000000, 0x0035d01900000000,
    0x0036601800000000, 0x0137f18800000000, 0x0138818f00000000,
    0x0039101f00000000, 0x003aa01e00000000, 0x013b318e00000000,
    0x003cc01d00000000, 0x013d518d00000000, 0x013ee18c00000000,
    0x003f701c00000000, 0x014001b400000000, 0x0041902400000000,
    0x0042202500000000, 0x0143b1b500000000, 0x0044402600000000,
    0x0145d1b600000000, 0x014661b700000000, 0x0047f02700000000,
    0x0048802000000000, 0x014911b000000000, 0x014aa1b100000000,
    0x004b302100000000, 0x014cc1b200000000, 0x004d502200000000,
    0x004ee02300000000, 0x014f71b300000000, 0x0050002d00000000,
    0x015191bd00000000, 0x015221bc00000000, 0x0053b02c00000000,
    0x015441bf00000000, 0x0055d02f00000000, 0x0056602e00000000,
    0x0157f1be00000000, 0x015881b900000000, 0x0059102900000000,
    0x005aa02800000000, 0x015b31b800000000, 0x005cc02b00000000,
    0x015d51bb00000000, 0x015ee1ba00000000, 0x005f702a00000000,
    0x0060003600000000, 0x016191a600000000, 0x016221a700000000,
    0x0063b03700000000, 0x016441a400000000, 0x0065d03400000000,
    0x0066603500000000, 0x0167f1a500000000, 0x016881a200000000,
    0x0069103200000000, 0x006aa03300000000, 0x016b31a300000000,
    0x006cc03000000000, 0x016d51a000000000, 0x016ee1a100000000,
    0x006f703100000000, 0x017001af00000000, 0x0071903f00000000,
    0x0072203e00000000, 0x0173b1ae00000000, 0x0074403d00000000,
    0x0175d1ad00000000, 0x017661ac00000000, 0x0077f03c00000000,
    0x0078803b00000000, 0x017911ab00000000, 0x017aa1aa00000000,
    0x007b303a00000000, 0x017cc1a900000000, 0x007d503900000000,
    0x007ee03800000000, 0x017f71a800000000, 0x018001d800000000,
    0x0081904800000000, 0x0082204900000000, 0x0183b1d900000000,
    0x0084404a00000000, 0x0185d1da00000000, 0x018661db00000000,
    0x0087f04b00000000, 0x0088804c00000000, 0x018911dc00000000,
    0x018aa1dd00000000, 0x008b304d00000000, 0x018cc1de00000000,
    0x008d504e00000000, 0x008ee04f00000000, 0x018f71df00000000,
    0x0090004100000000, 0x019191d100000000, 0x019221d000000000,
    0x0093b04000000000, 0x019441d300000000, 0x0095d04300000000,
    0x0096604200000000, 0x0197f1d200000000, 0x019881d500000000,
    0x0099104500000000, 0x009aa04400000000, 0x019b31d400000000,
    0x009cc04700000000, 0x019d51d700000000, 0x019ee1d600000000,
    0x009f704600000000, 0x00a0005a00000000, 0x01a191ca00000000,
    0x01a221cb00000000, 0x00a3b05b00000000, 0x01a441c800000000,
    0x00a5d05800000000, 0x00a6605900000000, 0x01a7f1c900000000,
    0x01a881ce00000000, 0x00a9105e00000000, 0x00aaa05f00000000,
    0x01ab31cf00000000, 0x00acc05c00000000, 0x01ad51cc00000000,
    0x01aee1cd00000000, 0x00af705d00000000, 0x01b001c300000000,
    0x00b1905300000000, 0x00b2205200000000, 0x01b3b1c200000000,
    0x00b4405100000000, 0x01b5d1c100000000, 0x01b661c000000000,
    0x00b7f05000000000, 0x00b8805700000000, 0x01b911c700000000,
    0x01baa1c600000000, 0x00bb305600000000, 0x01bcc1c500000000,
    0x00bd505500000000, 0x00bee05400000000, 0x01bf71c400000000,
    0x00c0006c00000000, 0x01c191fc00000000, 0x01c221fd00000000,
    0x00c3b06d00000000, 0x01c441fe00000000, 0x00c5d06e00000000,
    0x00c6606f00000000, 0x01c7f1ff00000000, 0x01c881f800000000,
    0x00c9106800000000, 0x00caa06900000000, 0x01cb31f900000000,
    0x00ccc06a00000000, 0x01cd51fa00000000, 0x01cee1fb00000000,
    0x00cf706b00000000, 0x01d001f500000000, 0x00d1906500000000,
    0x00d2206400000000, 0x01d3b1f400000000, 0x00d4406700000000,
    0x01d5d1f700000000, 0x01d661f600000000, 0x00d7f06600000000,
    0x00d8806100000000, 0x01d911f100000000, 0x01daa1f000000000,
    0x00db306000000000, 0x01dcc1f300000000, 0x00dd506300000000,
    0x00dee06200000000, 0x01df71f200000000, 0x01e001ee00000000,
    0x00e1907e00000000, 0x00e2207f00000000, 0x01e3b1ef00000000,
    0x00e4407c00000000, 0x01e5d1ec00000000, 0x01e661ed00000000,
    0x00e7f07d00000000, 0x00e8807a00000000, 0x01e911ea00000000,
    0x01eaa1eb00000000, 0x00eb307b00000000, 0x01ecc1e800000000,
    0x00ed507800000000, 0x00eee07900000000, 0x01ef71e900000000,
    0x00f0007700000000, 0x01f191e700000000, 0x01f221e600000000,
    0x00f3b07600000000, 0x01f441e500000000, 0x00f5d07500000000,
    0x00f6607400000000, 0x01f7f1e400000000, 0x01f881e300000000,
    0x00f9107300000000, 0x00faa07200000000, 0x01fb31e200000000,
    0x00fcc07100000000, 0x01fd51e100000000, 0x01fee1e000000000,
    0x00ff707000000000};

#else /* W == 4 */

static const word_t crc_big_table[] = {
    0x00000000, 0x01019190, 0x01022191, 0x0003b001, 0x01044192,
    0x0005d002, 0x00066003, 0x0107f193, 0x01088194, 0x00091004,
    0x000aa005, 0x010b3195, 0x000cc006, 0x010d5196, 0x010ee197,
    0x000f7007, 0x01100199, 0x00119009, 0x00122008, 0x0113b198,
    0x0014400b, 0x0115d19b, 0x0116619a, 0x0017f00a, 0x0018800d,
    0x0119119d, 0x011aa19c, 0x001b300c, 0x011cc19f, 0x001d500f,
    0x001ee00e, 0x011f719e, 0x01200182, 0x00219012, 0x00222013,
    0x0123b183, 0x00244010, 0x0125d180, 0x01266181, 0x0027f011,
    0x00288016, 0x01291186, 0x012aa187, 0x002b3017, 0x012cc184,
    0x002d5014, 0x002ee015, 0x012f7185, 0x0030001b, 0x0131918b,
    0x0132218a, 0x0033b01a, 0x01344189, 0x0035d019, 0x00366018,
    0x0137f188, 0x0138818f, 0x0039101f, 0x003aa01e, 0x013b318e,
    0x003cc01d, 0x013d518d, 0x013ee18c, 0x003f701c, 0x014001b4,
    0x00419024, 0x00422025, 0x0143b1b5, 0x00444026, 0x0145d1b6,
    0x014661b7, 0x0047f027, 0x00488020, 0x014911b0, 0x014aa1b1,
    0x004b3021, 0x014cc1b2, 0x004d5022, 0x004ee023, 0x014f71b3,
    0x0050002d, 0x015191bd, 0x015221bc, 0x0053b02c, 0x015441bf,
    0x0055d02f, 0x0056602e, 0x0157f1be, 0x015881b9, 0x00591029,
    0x005aa028, 0x015b31b8, 0x005cc02b, 0x015d51bb, 0x015ee1ba,
    0x005f702a, 0x00600036, 0x016191a6, 0x016221a7, 0x0063b037,
    0x016441a4, 0x0065d034, 0x00666035, 0x0167f1a5, 0x016881a2,
    0x00691032, 0x006aa033, 0x016b31a3, 0x006cc030, 0x016d51a0,
    0x016ee1a1, 0x006f7031, 0x017001af, 0x0071903f, 0x0072203e,
    0x0173b1ae, 0x0074403d, 0x0175d1ad, 0x017661ac, 0x0077f03c,
    0x0078803b, 0x017911ab, 0x017aa1aa, 0x007b303a, 0x017cc1a9,
    0x007d5039, 0x007ee038, 0x017f71a8, 0x018001d8, 0x00819048,
    0x00822049, 0x0183b1d9, 0x0084404a, 0x0185d1da, 0x018661db,
    0x0087f04b, 0x0088804c, 0x018911dc, 0x018aa1dd, 0x008b304d,
    0x018cc1de, 0x008d504e, 0x008ee04f, 0x018f71df, 0x00900041,
    0x019191d1, 0x019221d0, 0x0093b040, 0x019441d3, 0x0095d043,
    0x00966042, 0x0197f1d2, 0x019881d5, 0x00991045, 0x009aa044,
    0x019b31d4, 0x009cc047, 0x019d51d7, 0x019ee1d6, 0x009f7046,
    0x00a0005a, 0x01a191ca, 0x01a221cb, 0x00a3b05b, 0x01a441c8,
    0x00a5d058, 0x00a66059, 0x01a7f1c9, 0x01a881ce, 0x00a9105e,
    0x00aaa05f, 0x01ab31cf, 0x00acc05c, 0x01ad51cc, 0x01aee1cd,
    0x00af705d, 0x01b001c3, 0x00b19053, 0x00b22052, 0x01b3b1c2,
    0x00b44051, 0x01b5d1c1, 0x01b661c0, 0x00b7f050, 0x00b88057,
    0x01b911c7, 0x01baa1c6, 0x00bb3056, 0x01bcc1c5, 0x00bd5055,
    0x00bee054, 0x01bf71c4, 0x00c0006c, 0x01c191fc, 0x01c221fd,
    0x00c3b06d, 0x01c441fe, 0x00c5d06e, 0x00c6606f, 0x01c7f1ff,
    0x01c881f8, 0x00c91068, 0x00caa069, 0x01cb31f9, 0x00ccc06a,
    0x01cd51fa, 0x01cee1fb, 0x00cf706b, 0x01d001f5, 0x00d19065,
    0x00d22064, 0x01d3b1f4, 0x00d44067, 0x01d5d1f7, 0x01d661f6,
    0x00d7f066, 0x00d88061, 0x01d911f1, 0x01daa1f0, 0x00db3060,
    0x01dcc1f3, 0x00dd5063, 0x00dee062, 0x01df71f2, 0x01e001ee,
    0x00e1907e, 0x00e2207f, 0x01e3b1ef, 0x00e4407c, 0x01e5d1ec,
    0x01e661ed, 0x00e7f07d, 0x00e8807a, 0x01e911ea, 0x01eaa1eb,
    0x00eb307b, 0x01ecc1e8, 0x00ed5078, 0x00eee079, 0x01ef71e9,
    0x00f00077, 0x01f191e7, 0x01f221e6, 0x00f3b076, 0x01f441e5,
    0x00f5d075, 0x00f66074, 0x01f7f1e4, 0x01f881e3, 0x00f91073,
    0x00faa072, 0x01fb31e2, 0x00fcc071, 0x01fd51e1, 0x01fee1e0,
    0x00ff7070};

#endif

#if N == 1

#if W == 8

static const crc_t crc_braid_table[][256] = {
   {0x00000000, 0x65904101, 0xcb208202, 0xaeb0c303, 0x26420407,
    0x43d24506, 0xed628605, 0x88f2c704, 0x4c84080e, 0x2914490f,
    0x87a48a0c, 0xe234cb0d, 0x6ac60c09, 0x0f564d08, 0xa1e68e0b,
    0xc476cf0a, 0x9908101c, 0xfc98511d, 0x5228921e, 0x37b8d31f,
    0xbf4a141b, 0xdada551a, 0x746a9619, 0x11fad718, 0xd58c1812,
    0xb01c5913, 0x1eac9a10, 0x7b3cdb11, 0xf3ce1c15, 0x965e5d14,
    0x38ee9e17, 0x5d7edf16, 0x8213203b, 0xe783613a, 0x4933a239,
    0x2ca3e338, 0xa451243c, 0xc1c1653d, 0x6f71a63e, 0x0ae1e73f,
    0xce972835, 0xab076934, 0x05b7aa37, 0x6027eb36, 0xe8d52c32,
    0x8d456d33, 0x23f5ae30, 0x4665ef31, 0x1b1b3027, 0x7e8b7126,
    0xd03bb225, 0xb5abf324, 0x3d593420, 0x58c97521, 0xf679b622,
    0x93e9f723, 0x579f3829, 0x320f7928, 0x9cbfba2b, 0xf92ffb2a,
    0x71dd3c2e, 0x144d7d2f, 0xbafdbe2c, 0xdf6dff2d, 0xb4254075,
    0xd1b50174, 0x7f05c277, 0x1a958376, 0x92674472, 0xf7f70573,
    0x5947c670, 0x3cd78771, 0xf8a1487b, 0x9d31097a, 0x3381ca79,
    0x56118b78, 0xdee34c7c, 0xbb730d7d, 0x15c3ce7e, 0x70538f7f,
    0x2d2d5069, 0x48bd1168, 0xe60dd26b, 0x839d936a, 0x0b6f546e,
    0x6eff156f, 0xc04fd66c, 0xa5df976d, 0x61a95867, 0x04391966,
    0xaa89da65, 0xcf199b64, 0x47eb5c60, 0x227b1d61, 0x8ccbde62,
    0xe95b9f63, 0x3636604e, 0x53a6214f, 0xfd16e24c, 0x9886a34d,
    0x10746449, 0x75e42548, 0xdb54e64b, 0xbec4a74a, 0x7ab26840,
    0x1f222941, 0xb192ea42, 0xd402ab43, 0x5cf06c47, 0x39602d46,
    0x97d0ee45, 0xf240af44, 0xaf3e7052, 0xcaae3153, 0x641ef250,
    0x018eb351, 0x897c7455, 0xecec3554, 0x425cf657, 0x27ccb756,
    0xe3ba785c, 0x862a395d, 0x289afa5e, 0x4d0abb5f, 0xc5f87c5b,
    0xa0683d5a, 0x0ed8fe59, 0x6b48bf58, 0xd84980e9, 0xbdd9c1e8,
    0x136902eb, 0x76f943ea, 0xfe0b84ee, 0x9b9bc5ef, 0x352b06ec,
    0x50bb47ed, 0x94cd88e7, 0xf15dc9e6, 0x5fed0ae5, 0x3a7d4be4,
    0xb28f8ce0, 0xd71fcde1, 0x79af0ee2, 0x1c3f4fe3, 0x414190f5,
    0x24d1d1f4, 0x8a6112f7, 0xeff153f6, 0x670394f2, 0x0293d5f3,
    0xac2316f0, 0xc9b357f1, 0x0dc598fb, 0x6855d9fa, 0xc6e51af9,
    0xa3755bf8, 0x2b879cfc, 0x4e17ddfd, 0xe0a71efe, 0x85375fff,
    0x5a5aa0d2, 0x3fcae1d3, 0x917a22d0, 0xf4ea63d1, 0x7c18a4d5,
    0x1988e5d4, 0xb73826d7, 0xd2a867d6, 0x16dea8dc, 0x734ee9dd,
    0xddfe2ade, 0xb86e6bdf, 0x309cacdb, 0x550cedda, 0xfbbc2ed9,
    0x9e2c6fd8, 0xc352b0ce, 0xa6c2f1cf, 0x087232cc, 0x6de273cd,
    0xe510b4c9, 0x8080f5c8, 0x2e3036cb, 0x4ba077ca, 0x8fd6b8c0,
    0xea46f9c1, 0x44f63ac2, 0x21667bc3, 0xa994bcc7, 0xcc04fdc6,
    0x62b43ec5, 0x07247fc4, 0x6c6cc09c, 0x09fc819d, 0xa74c429e,
    0xc2dc039f, 0x4a2ec49b, 0x2fbe859a, 0x810e4699, 0xe49e0798,
    0x20e8c892, 0x45788993, 0xebc84a90, 0x8e580b91, 0x06aacc95,
    0x633a8d94, 0xcd8a4e97, 0xa81a0f96, 0xf564d080, 0x90f49181,
    0x3e445282, 0x5bd41383, 0xd326d487, 0xb6b69586, 0x18065685,
    0x7d961784, 0xb9e0d88e, 0xdc70998f, 0x72c05a8c, 0x17501b8d,
    0x9fa2dc89, 0xfa329d88, 0x54825e8b, 0x31121f8a, 0xee7fe0a7,
    0x8befa1a6, 0x255f62a5, 0x40cf23a4, 0xc83de4a0, 0xadada5a1,
    0x031d66a2, 0x668d27a3, 0xa2fbe8a9, 0xc76ba9a8, 0x69db6aab,
    0x0c4b2baa, 0x84b9ecae, 0xe129adaf, 0x4f996eac, 0x2a092fad,
    0x7777f0bb, 0x12e7b1ba, 0xbc5772b9, 0xd9c733b8, 0x5135f4bc,
    0x34a5b5bd, 0x9a1576be, 0xff8537bf, 0x3bf3f8b5, 0x5e63b9b4,
    0xf0d37ab7, 0x95433bb6, 0x1db1fcb2, 0x7821bdb3, 0xd6917eb0,
    0xb3013fb1},
   {0x00000000, 0x009001d1, 0x012003a2, 0x01b00273, 0x02400744,
    0x02d00695, 0x036004e6, 0x03f00537, 0x04800e88, 0x04100f59,
    0x05a00d2a, 0x05300cfb, 0x06c009cc, 0x0650081d, 0x07e00a6e,
    0x07700bbf, 0x09001d10, 0x09901cc1, 0x08201eb2, 0x08b01f63,
    0x0b401a54, 0x0bd01b85, 0x0a6019f6, 0x0af01827, 0x0d801398,
    0x0d101249, 0x0ca0103a, 0x0c3011eb, 0x0fc014dc, 0x0f50150d,
    0x0ee0177e, 0x0e7016af, 0x12003a20, 0x12903bf1, 0x13203982,
    0x13b03853, 0x10403d64, 0x10d03cb5, 0x11603ec6, 0x11f03f17,
    0x168034a8, 0x16103579, 0x17a0370a, 0x173036db, 0x14c033ec,
    0x1450323d, 0x15e0304e, 0x1570319f, 0x1b002730, 0x1b9026e1,
    0x1a202492, 0x1ab02543, 0x19402074, 0x19d021a5, 0x186023d6,
    0x18f02207, 0x1f8029b8, 0x1f102869, 0x1ea02a1a, 0x1e302bcb,
    0x1dc02efc, 0x1d502f2d, 0x1ce02d5e, 0x1c702c8f, 0x24007440,
    0x24907591, 0x252077e2, 0x25b07633, 0x26407304, 0x26d072d5,
    0x276070a6, 0x27f07177, 0x20807ac8, 0x20107b19, 0x21a0796a,
    0x213078bb, 0x22c07d8c, 0x22507c5d, 0x23e07e2e, 0x23707fff,
    0x2d006950, 0x2d906881, 0x2c206af2, 0x2cb06b23, 0x2f406e14,
    0x2fd06fc5, 0x2e606db6, 0x2ef06c67, 0x298067d8, 0x29106609,
    0x28a0647a, 0x283065ab, 0x2bc0609c, 0x2b50614d, 0x2ae0633e,
    0x2a7062ef, 0x36004e60, 0x36904fb1, 0x37204dc2, 0x37b04c13,
    0x34404924, 0x34d048f5, 0x35604a86, 0x35f04b57, 0x328040e8,
    0x32104139, 0x33a0434a, 0x3330429b, 0x30c047ac, 0x3050467d,
    0x31e0440e, 0x317045df, 0x3f005370, 0x3f9052a1, 0x3e2050d2,
    0x3eb05103, 0x3d405434, 0x3dd055e5, 0x3c605796, 0x3cf05647,
    0x3b805df8, 0x3b105c29, 0x3aa05e5a, 0x3a305f8b, 0x39c05abc,
    0x39505b6d, 0x38e0591e, 0x387058cf, 0x4800e880, 0x4890e951,
    0x4920eb22, 0x49b0eaf3, 0x4a40efc4, 0x4ad0ee15, 0x4b60ec66,
    0x4bf0edb7, 0x4c80e608, 0x4c10e7d9, 0x4da0e5aa, 0x4d30e47b,
    0x4ec0e14c, 0x4e50e09d, 0x4fe0e2ee, 0x4f70e33f, 0x4100f590,
    0x4190f441, 0x4020f632, 0x40b0f7e3, 0x4340f2d4, 0x43d0f305,
    0x4260f176, 0x42f0f0a7, 0x4580fb18, 0x4510fac9, 0x44a0f8ba,
    0x4430f96b, 0x47c0fc5c, 0x4750fd8d, 0x46e0fffe, 0x4670fe2f,
    0x5a00d2a0, 0x5a90d371, 0x5b20d102, 0x5bb0d0d3, 0x5840d5e4,
    0x58d0d435, 0x5960d646, 0x59f0d797, 0x5e80dc28, 0x5e10ddf9,
    0x5fa0df8a, 0x5f30de5b, 0x5cc0db6c, 0x5c50dabd, 0x5de0d8ce,
    0x5d70d91f, 0x5300cfb0, 0x5390ce61, 0x5220cc12, 0x52b0cdc3,
    0x5140c8f4, 0x51d0c925, 0x5060cb56, 0x50f0ca87, 0x5780c138,
    0x5710c0e9, 0x56a0c29a, 0x5630c34b, 0x55c0c67c, 0x5550c7ad,
    0x54e0c5de, 0x5470c40f, 0x6c009cc0, 0x6c909d11, 0x6d209f62,
    0x6db09eb3, 0x6e409b84, 0x6ed09a55, 0x6f609826, 0x6ff099f7,
    0x68809248, 0x68109399, 0x69a091ea, 0x6930903b, 0x6ac0950c,
    0x6a5094dd, 0x6be096ae, 0x6b70977f, 0x650081d0, 0x65908001,
    0x64208272, 0x64b083a3, 0x67408694, 0x67d08745, 0x66608536,
    0x66f084e7, 0x61808f58, 0x61108e89, 0x60a08cfa, 0x60308d2b,
    0x63c0881c, 0x635089cd, 0x62e08bbe, 0x62708a6f, 0x7e00a6e0,
    0x7e90a731, 0x7f20a542, 0x7fb0a493, 0x7c40a1a4, 0x7cd0a075,
    0x7d60a206, 0x7df0a3d7, 0x7a80a868, 0x7a10a9b9, 0x7ba0abca,
    0x7b30aa1b, 0x78c0af2c, 0x7850aefd, 0x79e0ac8e, 0x7970ad5f,
    0x7700bbf0, 0x7790ba21, 0x7620b852, 0x76b0b983, 0x7540bcb4,
    0x75d0bd65, 0x7460bf16, 0x74f0bec7, 0x7380b578, 0x7310b4a9,
    0x72a0b6da, 0x7230b70b, 0x71c0b23c, 0x7150b3ed, 0x70e0b19e,
    0x7070b04f},
   {0x00000000, 0x9001d100, 0x9000a203, 0x00017303, 0x90024405,
    0x00039505, 0x0002e606, 0x90033706, 0x90078809, 0x00065909,
    0x00072a0a, 0x9006fb0a, 0x0005cc0c, 0x90041d0c, 0x90056e0f,
    0x0004bf0f, 0x900c1011, 0x000dc111, 0x000cb212, 0x900d6312,
    0x000e5414, 0x900f8514, 0x900ef617, 0x000f2717, 0x000b9818,
    0x900a4918, 0x900b3a1b, 0x000aeb1b, 0x9009dc1d, 0x00080d1d,
    0x00097e1e, 0x9008af1e, 0x901b2021, 0x001af121, 0x001b8222,
    0x901a5322, 0x00196424, 0x9018b524, 0x9019c627, 0x00181727,
    0x001ca828, 0x901d7928, 0x901c0a2b, 0x001ddb2b, 0x901eec2d,
    0x001f3d2d, 0x001e4e2e, 0x901f9f2e, 0x00173030, 0x9016e130,
    0x90179233, 0x00164333, 0x90157435, 0x0014a535, 0x0015d636,
    0x90140736, 0x9010b839, 0x00116939, 0x00101a3a, 0x9011cb3a,
    0x0012fc3c, 0x90132d3c, 0x90125e3f, 0x00138f3f, 0x90354041,
    0x00349141, 0x0035e242, 0x90343342, 0x00370444, 0x9036d544,
    0x9037a647, 0x00367747, 0x0032c848, 0x90331948, 0x90326a4b,
    0x0033bb4b, 0x90308c4d, 0x00315d4d, 0x00302e4e, 0x9031ff4e,
    0x00395050, 0x90388150, 0x9039f253, 0x00382353, 0x903b1455,
    0x003ac555, 0x003bb656, 0x903a6756, 0x903ed859, 0x003f0959,
    0x003e7a5a, 0x903fab5a, 0x003c9c5c, 0x903d4d5c, 0x903c3e5f,
    0x003def5f, 0x002e6060, 0x902fb160, 0x902ec263, 0x002f1363,
    0x902c2465, 0x002df565, 0x002c8666, 0x902d5766, 0x9029e869,
    0x00283969, 0x00294a6a, 0x90289b6a, 0x002bac6c, 0x902a7d6c,
    0x902b0e6f, 0x002adf6f, 0x90227071, 0x0023a171, 0x0022d272,
    0x90230372, 0x00203474, 0x9021e574, 0x90209677, 0x00214777,
    0x0025f878, 0x90242978, 0x90255a7b, 0x00248b7b, 0x9027bc7d,
    0x00266d7d, 0x00271e7e, 0x9026cf7e, 0x90698081, 0x00685181,
    0x00692282, 0x9068f382, 0x006bc484, 0x906a1584, 0x906b6687,
    0x006ab787, 0x006e0888, 0x906fd988, 0x906eaa8b, 0x006f7b8b,
    0x906c4c8d, 0x006d9d8d, 0x006cee8e, 0x906d3f8e, 0x00659090,
    0x90644190, 0x90653293, 0x0064e393, 0x9067d495, 0x00660595,
    0x00677696, 0x9066a796, 0x90621899, 0x0063c999, 0x0062ba9a,
    0x90636b9a, 0x00605c9c, 0x90618d9c, 0x9060fe9f, 0x00612f9f,
    0x0072a0a0, 0x907371a0, 0x907202a3, 0x0073d3a3, 0x9070e4a5,
    0x007135a5, 0x007046a6, 0x907197a6, 0x907528a9, 0x0074f9a9,
    0x00758aaa, 0x90745baa, 0x00776cac, 0x9076bdac, 0x9077ceaf,
    0x00761faf, 0x907eb0b1, 0x007f61b1, 0x007e12b2, 0x907fc3b2,
    0x007cf4b4, 0x907d25b4, 0x907c56b7, 0x007d87b7, 0x007938b8,
    0x9078e9b8, 0x90799abb, 0x00784bbb, 0x907b7cbd, 0x007aadbd,
    0x007bdebe, 0x907a0fbe, 0x005cc0c0, 0x905d11c0, 0x905c62c3,
    0x005db3c3, 0x905e84c5, 0x005f55c5, 0x005e26c6, 0x905ff7c6,
    0x905b48c9, 0x005a99c9, 0x005beaca, 0x905a3bca, 0x00590ccc,
    0x9058ddcc, 0x9059aecf, 0x00587fcf, 0x9050d0d1, 0x005101d1,
    0x005072d2, 0x9051a3d2, 0x005294d4, 0x905345d4, 0x905236d7,
    0x0053e7d7, 0x005758d8, 0x905689d8, 0x9057fadb, 0x00562bdb,
    0x90551cdd, 0x0054cddd, 0x0055bede, 0x90546fde, 0x9047e0e1,
    0x004631e1, 0x004742e2, 0x904693e2, 0x0045a4e4, 0x904475e4,
    0x904506e7, 0x0044d7e7, 0x004068e8, 0x9041b9e8, 0x9040caeb,
    0x00411beb, 0x90422ced, 0x0043fded, 0x00428eee, 0x90435fee,
    0x004bf0f0, 0x904a21f0, 0x904b52f3, 0x004a83f3, 0x9049b4f5,
    0x004865f5, 0x004916f6, 0x9048c7f6, 0x904c78f9, 0x004da9f9,
    0x004cdafa, 0x904d0bfa, 0x004e3cfc, 0x904fedfc, 0x904e9eff,
    0x004f4fff},
   {0x00000000, 0x90d00101, 0x91a30201, 0x01730300, 0x93450401,
    0x03950500, 0x02e60600, 0x92360701, 0x96890801, 0x06590900,
    0x072a0a00, 0x97fa0b01, 0x05cc0c00, 0x951c0d01, 0x946f0e01,
    0x04bf0f00, 0x9d111001, 0x0dc11100, 0x0cb21200, 0x9c621301,
    0x0e541400, 0x9e841501, 0x9ff71601, 0x0f271700, 0x0b981800,
    0x9b481901, 0x9a3b1a01, 0x0aeb1b00, 0x98dd1c01, 0x080d1d00,
    0x097e1e00, 0x99ae1f01, 0x8a212001, 0x1af12100, 0x1b822200,
    0x8b522301, 0x19642400, 0x89b42501, 0x88c72601, 0x18172700,
    0x1ca82800, 0x8c782901, 0x8d0b2a01, 0x1ddb2b00, 0x8fed2c01,
    0x1f3d2d00, 0x1e4e2e00, 0x8e9e2f01, 0x17303000, 0x87e03101,
    0x86933201, 0x16433300, 0x84753401, 0x14a53500, 0x15d63600,
    0x85063701, 0x81b93801, 0x11693900, 0x101a3a00, 0x80ca3b01,
    0x12fc3c00, 0x822c3d01, 0x835f3e01, 0x138f3f00, 0xa4414001,
    0x34914100, 0x35e24200, 0xa5324301, 0x37044400, 0xa7d44501,
    0xa6a74601, 0x36774700, 0x32c84800, 0xa2184901, 0xa36b4a01,
    0x33bb4b00, 0xa18d4c01, 0x315d4d00, 0x302e4e00, 0xa0fe4f01,
    0x39505000, 0xa9805101, 0xa8f35201, 0x38235300, 0xaa155401,
    0x3ac55500, 0x3bb65600, 0xab665701, 0xafd95801, 0x3f095900,
    0x3e7a5a00, 0xaeaa5b01, 0x3c9c5c00, 0xac4c5d01, 0xad3f5e01,
    0x3def5f00, 0x2e606000, 0xbeb06101, 0xbfc36201, 0x2f136300,
    0xbd256401, 0x2df56500, 0x2c866600, 0xbc566701, 0xb8e96801,
    0x28396900, 0x294a6a00, 0xb99a6b01, 0x2bac6c00, 0xbb7c6d01,
    0xba0f6e01, 0x2adf6f00, 0xb3717001, 0x23a17100, 0x22d27200,
    0xb2027301, 0x20347400, 0xb0e47501, 0xb1977601, 0x21477700,
    0x25f87800, 0xb5287901, 0xb45b7a01, 0x248b7b00, 0xb6bd7c01,
    0x266d7d00, 0x271e7e00, 0xb7ce7f01, 0xf8818001, 0x68518100,
    0x69228200, 0xf9f28301, 0x6bc48400, 0xfb148501, 0xfa678601,
    0x6ab78700, 0x6e088800, 0xfed88901, 0xffab8a01, 0x6f7b8b00,
    0xfd4d8c01, 0x6d9d8d00, 0x6cee8e00, 0xfc3e8f01, 0x65909000,
    0xf5409101, 0xf4339201, 0x64e39300, 0xf6d59401, 0x66059500,
    0x67769600, 0xf7a69701, 0xf3199801, 0x63c99900, 0x62ba9a00,
    0xf26a9b01, 0x605c9c00, 0xf08c9d01, 0xf1ff9e01, 0x612f9f00,
    0x72a0a000, 0xe270a101, 0xe303a201, 0x73d3a300, 0xe1e5a401,
    0x7135a500, 0x7046a600, 0xe096a701, 0xe429a801, 0x74f9a900,
    0x758aaa00, 0xe55aab01, 0x776cac00, 0xe7bcad01, 0xe6cfae01,
    0x761faf00, 0xefb1b001, 0x7f61b100, 0x7e12b200, 0xeec2b301,
    0x7cf4b400, 0xec24b501, 0xed57b601, 0x7d87b700, 0x7938b800,
    0xe9e8b901, 0xe89bba01, 0x784bbb00, 0xea7dbc01, 0x7aadbd00,
    0x7bdebe00, 0xeb0ebf01, 0x5cc0c000, 0xcc10c101, 0xcd63c201,
    0x5db3c300, 0xcf85c401, 0x5f55c500, 0x5e26c600, 0xcef6c701,
    0xca49c801, 0x5a99c900, 0x5beaca00, 0xcb3acb01, 0x590ccc00,
    0xc9dccd01, 0xc8afce01, 0x587fcf00, 0xc1d1d001, 0x5101d100,
    0x5072d200, 0xc0a2d301, 0x5294d400, 0xc244d501, 0xc337d601,
    0x53e7d700, 0x5758d800, 0xc788d901, 0xc6fbda01, 0x562bdb00,
    0xc41ddc01, 0x54cddd00, 0x55bede00, 0xc56edf01, 0xd6e1e001,
    0x4631e100, 0x4742e200, 0xd792e301, 0x45a4e400, 0xd574e501,
    0xd407e601, 0x44d7e700, 0x4068e800, 0xd0b8e901, 0xd1cbea01,
    0x411beb00, 0xd32dec01, 0x43fded00, 0x428eee00, 0xd25eef01,
    0x4bf0f000, 0xdb20f101, 0xda53f201, 0x4a83f300, 0xd8b5f401,
    0x4865f500, 0x4916f600, 0xd9c6f701, 0xdd79f801, 0x4da9f900,
    0x4cdafa00, 0xdc0afb01, 0x4e3cfc00, 0xdeecfd01, 0xdf9ffe01,
    0x4f4fff00},
   {0x00000000, 0x41000001, 0x82000002, 0xc3000003, 0xb4030007,
    0xf5030006, 0x36030005, 0x77030004, 0xd805000d, 0x9905000c,
    0x5a05000f, 0x1b05000e, 0x6c06000a, 0x2d06000b, 0xee060008,
    0xaf060009, 0x00090019, 0x41090018, 0x8209001b, 0xc309001a,
    0xb40a001e, 0xf50a001f, 0x360a001c, 0x770a001d, 0xd80c0014,
    0x990c0015, 0x5a0c0016, 0x1b0c0017, 0x6c0f0013, 0x2d0f0012,
    0xee0f0011, 0xaf0f0010, 0x00120032, 0x41120033, 0x82120030,
    0xc3120031, 0xb4110035, 0xf5110034, 0x36110037, 0x77110036,
    0xd817003f, 0x9917003e, 0x5a17003d, 0x1b17003c, 0x6c140038,
    0x2d140039, 0xee14003a, 0xaf14003b, 0x001b002b, 0x411b002a,
    0x821b0029, 0xc31b0028, 0xb418002c, 0xf518002d, 0x3618002e,
    0x7718002f, 0xd81e0026, 0x991e0027, 0x5a1e0024, 0x1b1e0025,
    0x6c1d0021, 0x2d1d0020, 0xee1d0023, 0xaf1d0022, 0x00240064,
    0x41240065, 0x82240066, 0xc3240067, 0xb4270063, 0xf5270062,
    0x36270061, 0x77270060, 0xd8210069, 0x99210068, 0x5a21006b,
    0x1b21006a, 0x6c22006e, 0x2d22006f, 0xee22006c, 0xaf22006d,
    0x002d007d, 0x412d007c, 0x822d007f, 0xc32d007e, 0xb42e007a,
    0xf52e007b, 0x362e0078, 0x772e0079, 0xd8280070, 0x99280071,
    0x5a280072, 0x1b280073, 0x6c2b0077, 0x2d2b0076, 0xee2b0075,
    0xaf2b0074, 0x00360056, 0x41360057, 0x82360054, 0xc3360055,
    0xb4350051, 0xf5350050, 0x36350053, 0x77350052, 0xd833005b,
    0x9933005a, 0x5a330059, 0x1b330058, 0x6c30005c, 0x2d30005d,
    0xee30005e, 0xaf30005f, 0x003f004f, 0x413f004e, 0x823f004d,
    0xc33f004c, 0xb43c0048, 0xf53c0049, 0x363c004a, 0x773c004b,
    0xd83a0042, 0x993a0043, 0x5a3a0040, 0x1b3a0041, 0x6c390045,
    0x2d390044, 0xee390047, 0xaf390046, 0x004800c8, 0x414800c9,
    0x824800ca, 0xc34800cb, 0xb44b00cf, 0xf54b00ce, 0x364b00cd,
    0x774b00cc, 0xd84d00c5, 0x994d00c4, 0x5a4d00c7, 0x1b4d00c6,
    0x6c4e00c2, 0x2d4e00c3, 0xee4e00c0, 0xaf4e00c1, 0x004100d1,
    0x414100d0, 0x824100d3, 0xc34100d2, 0xb44200d6, 0xf54200d7,
    0x364200d4, 0x774200d5, 0xd84400dc, 0x994400dd, 0x5a4400de,
    0x1b4400df, 0x6c4700db, 0x2d4700da, 0xee4700d9, 0xaf4700d8,
    0x005a00fa, 0x415a00fb, 0x825a00f8, 0xc35a00f9, 0xb45900fd,
    0xf55900fc, 0x365900ff, 0x775900fe, 0xd85f00f7, 0x995f00f6,
    0x5a5f00f5, 0x1b5f00f4, 0x6c5c00f0, 0x2d5c00f1, 0xee5c00f2,
    0xaf5c00f3, 0x005300e3, 0x415300e2, 0x825300e1, 0xc35300e0,
    0xb45000e4, 0xf55000e5, 0x365000e6, 0x775000e7, 0xd85600ee,
    0x995600ef, 0x5a5600ec, 0x1b5600ed, 0x6c5500e9, 0x2d5500e8,
    0xee5500eb, 0xaf5500ea, 0x006c00ac, 0x416c00ad, 0x826c00ae,
    0xc36c00af, 0xb46f00ab, 0xf56f00aa, 0x366f00a9, 0x776f00a8,
    0xd86900a1, 0x996900a0, 0x5a6900a3, 0x1b6900a2, 0x6c6a00a6,
    0x2d6a00a7, 0xee6a00a4, 0xaf6a00a5, 0x006500b5, 0x416500b4,
    0x826500b7, 0xc36500b6, 0xb46600b2, 0xf56600b3, 0x366600b0,
    0x776600b1, 0xd86000b8, 0x996000b9, 0x5a6000ba, 0x1b6000bb,
    0x6c6300bf, 0x2d6300be, 0xee6300bd, 0xaf6300bc, 0x007e009e,
    0x417e009f, 0x827e009c, 0xc37e009d, 0xb47d0099, 0xf57d0098,
    0x367d009b, 0x777d009a, 0xd87b0093, 0x997b0092, 0x5a7b0091,
    0x1b7b0090, 0x6c780094, 0x2d780095, 0xee780096, 0xaf780097,
    0x00770087, 0x41770086, 0x82770085, 0xc3770084, 0xb4740080,
    0xf5740081, 0x36740082, 0x77740083, 0xd872008a, 0x9972008b,
    0x5a720088, 0x1b720089, 0x6c71008d, 0x2d71008c, 0xee71008f,
    0xaf71008e},
   {0x00000000, 0x00900190, 0x01200320, 0x01b002b0, 0x02400640,
    0x02d007d0, 0x03600560, 0x03f004f0, 0x04800c80, 0x04100d10,
    0x05a00fa0, 0x05300e30, 0x06c00ac0, 0x06500b50, 0x07e009e0,
    0x07700870, 0x09001900, 0x09901890, 0x08201a20, 0x08b01bb0,
    0x0b401f40, 0x0bd01ed0, 0x0a601c60, 0x0af01df0, 0x0d801580,
    0x0d101410, 0x0ca016a0, 0x0c301730, 0x0fc013c0, 0x0f501250,
    0x0ee010e0, 0x0e701170, 0x12003200, 0x12903390, 0x13203120,
    0x13b030b0, 0x10403440, 0x10d035d0, 0x11603760, 0x11f036f0,
    0x16803e80, 0x16103f10, 0x17a03da0, 0x17303c30, 0x14c038c0,
    0x14503950, 0x15e03be0, 0x15703a70, 0x1b002b00, 0x1b902a90,
    0x1a202820, 0x1ab029b0, 0x19402d40, 0x19d02cd0, 0x18602e60,
    0x18f02ff0, 0x1f802780, 0x1f102610, 0x1ea024a0, 0x1e302530,
    0x1dc021c0, 0x1d502050, 0x1ce022e0, 0x1c702370, 0x24006400,
    0x24906590, 0x25206720, 0x25b066b0, 0x26406240, 0x26d063d0,
    0x27606160, 0x27f060f0, 0x20806880, 0x20106910, 0x21a06ba0,
    0x21306a30, 0x22c06ec0, 0x22506f50, 0x23e06de0, 0x23706c70,
    0x2d007d00, 0x2d907c90, 0x2c207e20, 0x2cb07fb0, 0x2f407b40,
    0x2fd07ad0, 0x2e607860, 0x2ef079f0, 0x29807180, 0x29107010,
    0x28a072a0, 0x28307330, 0x2bc077c0, 0x2b507650, 0x2ae074e0,
    0x2a707570, 0x36005600, 0x36905790, 0x37205520, 0x37b054b0,
    0x34405040, 0x34d051d0, 0x35605360, 0x35f052f0, 0x32805a80,
    0x32105b10, 0x33a059a0, 0x33305830, 0x30c05cc0, 0x30505d50,
    0x31e05fe0, 0x31705e70, 0x3f004f00, 0x3f904e90, 0x3e204c20,
    0x3eb04db0, 0x3d404940, 0x3dd048d0, 0x3c604a60, 0x3cf04bf0,
    0x3b804380, 0x3b104210, 0x3aa040a0, 0x3a304130, 0x39c045c0,
    0x39504450, 0x38e046e0, 0x38704770, 0x4800c800, 0x4890c990,
    0x4920cb20, 0x49b0cab0, 0x4a40ce40, 0x4ad0cfd0, 0x4b60cd60,
    0x4bf0ccf0, 0x4c80c480, 0x4c10c510, 0x4da0c7a0, 0x4d30c630,
    0x4ec0c2c0, 0x4e50c350, 0x4fe0c1e0, 0x4f70c070, 0x4100d100,
    0x4190d090, 0x4020d220, 0x40b0d3b0, 0x4340d740, 0x43d0d6d0,
    0x4260d460, 0x42f0d5f0, 0x4580dd80, 0x4510dc10, 0x44a0dea0,
    0x4430df30, 0x47c0dbc0, 0x4750da50, 0x46e0d8e0, 0x4670d970,
    0x5a00fa00, 0x5a90fb90, 0x5b20f920, 0x5bb0f8b0, 0x5840fc40,
    0x58d0fdd0, 0x5960ff60, 0x59f0fef0, 0x5e80f680, 0x5e10f710,
    0x5fa0f5a0, 0x5f30f430, 0x5cc0f0c0, 0x5c50f150, 0x5de0f3e0,
    0x5d70f270, 0x5300e300, 0x5390e290, 0x5220e020, 0x52b0e1b0,
    0x5140e540, 0x51d0e4d0, 0x5060e660, 0x50f0e7f0, 0x5780ef80,
    0x5710ee10, 0x56a0eca0, 0x5630ed30, 0x55c0e9c0, 0x5550e850,
    0x54e0eae0, 0x5470eb70, 0x6c00ac00, 0x6c90ad90, 0x6d20af20,
    0x6db0aeb0, 0x6e40aa40, 0x6ed0abd0, 0x6f60a960, 0x6ff0a8f0,
    0x6880a080, 0x6810a110, 0x69a0a3a0, 0x6930a230, 0x6ac0a6c0,
    0x6a50a750, 0x6be0a5e0, 0x6b70a470, 0x6500b500, 0x6590b490,
    0x6420b620, 0x64b0b7b0, 0x6740b340, 0x67d0b2d0, 0x6660b060,
    0x66f0b1f0, 0x6180b980, 0x6110b810, 0x60a0baa0, 0x6030bb30,
    0x63c0bfc0, 0x6350be50, 0x62e0bce0, 0x6270bd70, 0x7e009e00,
    0x7e909f90, 0x7f209d20, 0x7fb09cb0, 0x7c409840, 0x7cd099d0,
    0x7d609b60, 0x7df09af0, 0x7a809280, 0x7a109310, 0x7ba091a0,
    0x7b309030, 0x78c094c0, 0x78509550, 0x79e097e0, 0x79709670,
    0x77008700, 0x77908690, 0x76208420, 0x76b085b0, 0x75408140,
    0x75d080d0, 0x74608260, 0x74f083f0, 0x73808b80, 0x73108a10,
    0x72a088a0, 0x72308930, 0x71c08dc0, 0x71508c50, 0x70e08ee0,
    0x70708f70},
   {0x00000000, 0x90019000, 0x90002003, 0x0001b003, 0x90034005,
    0x0002d005, 0x00036006, 0x9002f006, 0x90058009, 0x00041009,
    0x0005a00a, 0x9004300a, 0x0006c00c, 0x9007500c, 0x9006e00f,
    0x0007700f, 0x90080011, 0x00099011, 0x00082012, 0x9009b012,
    0x000b4014, 0x900ad014, 0x900b6017, 0x000af017, 0x000d8018,
    0x900c1018, 0x900da01b, 0x000c301b, 0x900ec01d, 0x000f501d,
    0x000ee01e, 0x900f701e, 0x90130021, 0x00129021, 0x00132022,
    0x9012b022, 0x00104024, 0x9011d024, 0x90106027, 0x0011f027,
    0x00168028, 0x90171028, 0x9016a02b, 0x0017302b, 0x9015c02d,
    0x0014502d, 0x0015e02e, 0x9014702e, 0x001b0030, 0x901a9030,
    0x901b2033, 0x001ab033, 0x90184035, 0x0019d035, 0x00186036,
    0x9019f036, 0x901e8039, 0x001f1039, 0x001ea03a, 0x901f303a,
    0x001dc03c, 0x901c503c, 0x901de03f, 0x001c703f, 0x90250041,
    0x00249041, 0x00252042, 0x9024b042, 0x00264044, 0x9027d044,
    0x90266047, 0x0027f047, 0x00208048, 0x90211048, 0x9020a04b,
    0x0021304b, 0x9023c04d, 0x0022504d, 0x0023e04e, 0x9022704e,
    0x002d0050, 0x902c9050, 0x902d2053, 0x002cb053, 0x902e4055,
    0x002fd055, 0x002e6056, 0x902ff056, 0x90288059, 0x00291059,
    0x0028a05a, 0x9029305a, 0x002bc05c, 0x902a505c, 0x902be05f,
    0x002a705f, 0x00360060, 0x90379060, 0x90362063, 0x0037b063,
    0x90354065, 0x0034d065, 0x00356066, 0x9034f066, 0x90338069,
    0x00321069, 0x0033a06a, 0x9032306a, 0x0030c06c, 0x9031506c,
    0x9030e06f, 0x0031706f, 0x903e0071, 0x003f9071, 0x003e2072,
    0x903fb072, 0x003d4074, 0x903cd074, 0x903d6077, 0x003cf077,
    0x003b8078, 0x903a1078, 0x903ba07b, 0x003a307b, 0x9038c07d,
    0x0039507d, 0x0038e07e, 0x9039707e, 0x90490081, 0x00489081,
    0x00492082, 0x9048b082, 0x004a4084, 0x904bd084, 0x904a6087,
    0x004bf087, 0x004c8088, 0x904d1088, 0x904ca08b, 0x004d308b,
    0x904fc08d, 0x004e508d, 0x004fe08e, 0x904e708e, 0x00410090,
    0x90409090, 0x90412093, 0x0040b093, 0x90424095, 0x0043d095,
    0x00426096, 0x9043f096, 0x90448099, 0x00451099, 0x0044a09a,
    0x9045309a, 0x0047c09c, 0x9046509c, 0x9047e09f, 0x0046709f,
    0x005a00a0, 0x905b90a0, 0x905a20a3, 0x005bb0a3, 0x905940a5,
    0x0058d0a5, 0x005960a6, 0x9058f0a6, 0x905f80a9, 0x005e10a9,
    0x005fa0aa, 0x905e30aa, 0x005cc0ac, 0x905d50ac, 0x905ce0af,
    0x005d70af, 0x905200b1, 0x005390b1, 0x005220b2, 0x9053b0b2,
    0x005140b4, 0x9050d0b4, 0x905160b7, 0x0050f0b7, 0x005780b8,
    0x905610b8, 0x9057a0bb, 0x005630bb, 0x9054c0bd, 0x005550bd,
    0x0054e0be, 0x905570be, 0x006c00c0, 0x906d90c0, 0x906c20c3,
    0x006db0c3, 0x906f40c5, 0x006ed0c5, 0x006f60c6, 0x906ef0c6,
    0x906980c9, 0x006810c9, 0x0069a0ca, 0x906830ca, 0x006ac0cc,
    0x906b50cc, 0x906ae0cf, 0x006b70cf, 0x906400d1, 0x006590d1,
    0x006420d2, 0x9065b0d2, 0x006740d4, 0x9066d0d4, 0x906760d7,
    0x0066f0d7, 0x006180d8, 0x906010d8, 0x9061a0db, 0x006030db,
    0x9062c0dd, 0x006350dd, 0x0062e0de, 0x906370de, 0x907f00e1,
    0x007e90e1, 0x007f20e2, 0x907eb0e2, 0x007c40e4, 0x907dd0e4,
    0x907c60e7, 0x007df0e7, 0x007a80e8, 0x907b10e8, 0x907aa0eb,
    0x007b30eb, 0x9079c0ed, 0x007850ed, 0x0079e0ee, 0x907870ee,
    0x007700f0, 0x907690f0, 0x907720f3, 0x0076b0f3, 0x907440f5,
    0x0075d0f5, 0x007460f6, 0x9075f0f6, 0x907280f9, 0x007310f9,
    0x0072a0fa, 0x907330fa, 0x0071c0fc, 0x907050fc, 0x9071e0ff,
    0x007070ff},
   {0x00000000, 0x90910101, 0x91210201, 0x01b00300, 0x92410401,
    0x02d00500, 0x03600600, 0x93f10701, 0x94810801, 0x04100900,
    0x05a00a00, 0x95310b01, 0x06c00c00, 0x96510d01, 0x97e10e01,
    0x07700f00, 0x99011001, 0x09901100, 0x08201200, 0x98b11301,
    0x0b401400, 0x9bd11501, 0x9a611601, 0x0af01700, 0x0d801800,
    0x9d111901, 0x9ca11a01, 0x0c301b00, 0x9fc11c01, 0x0f501d00,
    0x0ee01e00, 0x9e711f01, 0x82012001, 0x12902100, 0x13202200,
    0x83b12301, 0x10402400, 0x80d12501, 0x81612601, 0x11f02700,
    0x16802800, 0x86112901, 0x87a12a01, 0x17302b00, 0x84c12c01,
    0x14502d00, 0x15e02e00, 0x85712f01, 0x1b003000, 0x8b913101,
    0x8a213201, 0x1ab03300, 0x89413401, 0x19d03500, 0x18603600,
    0x88f13701, 0x8f813801, 0x1f103900, 0x1ea03a00, 0x8e313b01,
    0x1dc03c00, 0x8d513d01, 0x8ce13e01, 0x1c703f00, 0xb4014001,
    0x24904100, 0x25204200, 0xb5b14301, 0x26404400, 0xb6d14501,
    0xb7614601, 0x27f04700, 0x20804800, 0xb0114901, 0xb1a14a01,
    0x21304b00, 0xb2c14c01, 0x22504d00, 0x23e04e00, 0xb3714f01,
    0x2d005000, 0xbd915101, 0xbc215201, 0x2cb05300, 0xbf415401,
    0x2fd05500, 0x2e605600, 0xbef15701, 0xb9815801, 0x29105900,
    0x28a05a00, 0xb8315b01, 0x2bc05c00, 0xbb515d01, 0xbae15e01,
    0x2a705f00, 0x36006000, 0xa6916101, 0xa7216201, 0x37b06300,
    0xa4416401, 0x34d06500, 0x35606600, 0xa5f16701, 0xa2816801,
    0x32106900, 0x33a06a00, 0xa3316b01, 0x30c06c00, 0xa0516d01,
    0xa1e16e01, 0x31706f00, 0xaf017001, 0x3f907100, 0x3e207200,
    0xaeb17301, 0x3d407400, 0xadd17501, 0xac617601, 0x3cf07700,
    0x3b807800, 0xab117901, 0xaaa17a01, 0x3a307b00, 0xa9c17c01,
    0x39507d00, 0x38e07e00, 0xa8717f01, 0xd8018001, 0x48908100,
    0x49208200, 0xd9b18301, 0x4a408400, 0xdad18501, 0xdb618601,
    0x4bf08700, 0x4c808800, 0xdc118901, 0xdda18a01, 0x4d308b00,
    0xdec18c01, 0x4e508d00, 0x4fe08e00, 0xdf718f01, 0x41009000,
    0xd1919101, 0xd0219201, 0x40b09300, 0xd3419401, 0x43d09500,
    0x42609600, 0xd2f19701, 0xd5819801, 0x45109900, 0x44a09a00,
    0xd4319b01, 0x47c09c00, 0xd7519d01, 0xd6e19e01, 0x46709f00,
    0x5a00a000, 0xca91a101, 0xcb21a201, 0x5bb0a300, 0xc841a401,
    0x58d0a500, 0x5960a600, 0xc9f1a701, 0xce81a801, 0x5e10a900,
    0x5fa0aa00, 0xcf31ab01, 0x5cc0ac00, 0xcc51ad01, 0xcde1ae01,
    0x5d70af00, 0xc301b001, 0x5390b100, 0x5220b200, 0xc2b1b301,
    0x5140b400, 0xc1d1b501, 0xc061b601, 0x50f0b700, 0x5780b800,
    0xc711b901, 0xc6a1ba01, 0x5630bb00, 0xc5c1bc01, 0x5550bd00,
    0x54e0be00, 0xc471bf01, 0x6c00c000, 0xfc91c101, 0xfd21c201,
    0x6db0c300, 0xfe41c401, 0x6ed0c500, 0x6f60c600, 0xfff1c701,
    0xf881c801, 0x6810c900, 0x69a0ca00, 0xf931cb01, 0x6ac0cc00,
    0xfa51cd01, 0xfbe1ce01, 0x6b70cf00, 0xf501d001, 0x6590d100,
    0x6420d200, 0xf4b1d301, 0x6740d400, 0xf7d1d501, 0xf661d601,
    0x66f0d700, 0x6180d800, 0xf111d901, 0xf0a1da01, 0x6030db00,
    0xf3c1dc01, 0x6350dd00, 0x62e0de00, 0xf271df01, 0xee01e001,
    0x7e90e100, 0x7f20e200, 0xefb1e301, 0x7c40e400, 0xecd1e501,
    0xed61e601, 0x7df0e700, 0x7a80e800, 0xea11e901, 0xeba1ea01,
    0x7b30eb00, 0xe8c1ec01, 0x7850ed00, 0x79e0ee00, 0xe971ef01,
    0x7700f000, 0xe791f101, 0xe621f201, 0x76b0f300, 0xe541f401,
    0x75d0f500, 0x7460f600, 0xe4f1f701, 0xe381f801, 0x7310f900,
    0x72a0fa00, 0xe231fb01, 0x71c0fc00, 0xe151fd01, 0xe0e1fe01,
    0x7070ff00}};

static const word_t crc_braid_big_table[][256] = {
   {0x0000000000000000, 0x0101919000000000, 0x0102219100000000,
    0x0003b00100000000, 0x0104419200000000, 0x0005d00200000000,
    0x0006600300000000, 0x0107f19300000000, 0x0108819400000000,
    0x0009100400000000, 0x000aa00500000000, 0x010b319500000000,
    0x000cc00600000000, 0x010d519600000000, 0x010ee19700000000,
    0x000f700700000000, 0x0110019900000000, 0x0011900900000000,
    0x0012200800000000, 0x0113b19800000000, 0x0014400b00000000,
    0x0115d19b00000000, 0x0116619a00000000, 0x0017f00a00000000,
    0x0018800d00000000, 0x0119119d00000000, 0x011aa19c00000000,
    0x001b300c00000000, 0x011cc19f00000000, 0x001d500f00000000,
    0x001ee00e00000000, 0x011f719e00000000, 0x0120018200000000,
    0x0021901200000000, 0x0022201300000000, 0x0123b18300000000,
    0x0024401000000000, 0x0125d18000000000, 0x0126618100000000,
    0x0027f01100000000, 0x0028801600000000, 0x0129118600000000,
    0x012aa18700000000, 0x002b301700000000, 0x012cc18400000000,
    0x002d501400000000, 0x002ee01500000000, 0x012f718500000000,
    0x0030001b00000000, 0x0131918b00000000, 0x0132218a00000000,
    0x0033b01a00000000, 0x0134418900000000, 0x0035d01900000000,
    0x0036601800000000, 0x0137f18800000000, 0x0138818f00000000,
    0x0039101f00000000, 0x003aa01e00000000, 0x013b318e00000000,
    0x003cc01d00000000, 0x013d518d00000000, 0x013ee18c00000000,
    0x003f701c00000000, 0x014001b400000000, 0x0041902400000000,
    0x0042202500000000, 0x0143b1b500000000, 0x0044402600000000,
    0x0145d1b600000000, 0x014661b700000000, 0x0047f02700000000,
    0x0048802000000000, 0x014911b000000000, 0x014aa1b100000000,
    0x004b302100000000, 0x014cc1b200000000, 0x004d502200000000,
    0x004ee02300000000, 0x014f71b300000000, 0x0050002d00000000,
    0x015191bd00000000, 0x015221bc00000000, 0x0053b02c00000000,
    0x015441bf00000000, 0x0055d02f00000000, 0x0056602e00000000,
    0x0157f1be00000000, 0x015881b900000000, 0x0059102900000000,
    0x005aa02800000000, 0x015b31b800000000, 0x005cc02b00000000,
    0x015d51bb00000000, 0x015ee1ba00000000, 0x005f702a00000000,
    0x0060003600000000, 0x016191a600000000, 0x016221a700000000,
    0x0063b03700000000, 0x016441a400000000, 0x0065d03400000000,
    0x0066603500000000, 0x0167f1a500000000, 0x016881a200000000,
    0x0069103200000000, 0x006aa03300000000, 0x016b31a300000000,
    0x006cc03000000000, 0x016d51a000000000, 0x016ee1a100000000,
    0x006f703100000000, 0x017001af00000000, 0x0071903f00000000,
    0x0072203e00000000, 0x0173b1ae00000000, 0x0074403d00000000,
    0x0175d1ad00000000, 0x017661ac00000000, 0x0077f03c00000000,
    0x0078803b00000000, 0x017911ab00000000, 0x017aa1aa00000000,
    0x007b303a00000000, 0x017cc1a900000000, 0x007d503900000000,
    0x007ee03800000000, 0x017f71a800000000, 0x018001d800000000,
    0x0081904800000000, 0x0082204900000000, 0x0183b1d900000000,
    0x0084404a00000000, 0x0185d1da00000000, 0x018661db00000000,
    0x0087f04b00000000, 0x0088804c00000000, 0x018911dc00000000,
    0x018aa1dd00000000, 0x008b304d00000000, 0x018cc1de00000000,
    0x008d504e00000000, 0x008ee04f00000000, 0x018f71df00000000,
    0x0090004100000000, 0x019191d100000000, 0x019221d000000000,
    0x0093b04000000000, 0x019441d300000000, 0x0095d04300000000,
    0x0096604200000000, 0x0197f1d200000000, 0x019881d500000000,
    0x0099104500000000, 0x009aa04400000000, 0x019b31d400000000,
    0x009cc04700000000, 0x019d51d700000000, 0x019ee1d600000000,
    0x009f704600000000, 0x00a0005a00000000, 0x01a191ca00000000,
    0x01a221cb00000000, 0x00a3b05b00000000, 0x01a441c800000000,
    0x00a5d05800000000, 0x00a6605900000000, 0x01a7f1c900000000,
    0x01a881ce00000000, 0x00a9105e00000000, 0x00aaa05f00000000,
    0x01ab31cf00000000, 0x00acc05c00000000, 0x01ad51cc00000000,
    0x01aee1cd00000000, 0x00af705d00000000, 0x01b001c300000000,
    0x00b1905300000000, 0x00b2205200000000, 0x01b3b1c200000000,
    0x00b4405100000000, 0x01b5d1c100000000, 0x01b661c000000000,
    0x00b7f05000000000, 0x00b8805700000000, 0x01b911c700000000,
    0x01baa1c600000000, 0x00bb305600000000, 0x01bcc1c500000000,
    0x00bd505500000000, 0x00bee05400000000, 0x01bf71c400000000,
    0x00c0006c00000000, 0x01c191fc00000000, 0x01c221fd00000000,
    0x00c3b06d00000000, 0x01c441fe00000000, 0x00c5d06e00000000,
    0x00c6606f00000000, 0x01c7f1ff00000000, 0x01c881f800000000,
    0x00c9106800000000, 0x00caa06900000000, 0x01cb31f900000000,
    0x00ccc06a00000000, 0x01cd51fa00000000, 0x01cee1fb00000000,
    0x00cf706b00000000, 0x01d001f500000000, 0x00d1906500000000,
    0x00d2206400000000, 0x01d3b1f400000000, 0x00d4406700000000,
    0x01d5d1f700000000, 0x01d661f600000000, 0x00d7f06600000000,
    0x00d8806100000000, 0x01d911f100000000, 0x01daa1f000000000,
    0x00db306000000000, 0x01dcc1f300000000, 0x00dd506300000000,
    0x00dee06200000000, 0x01df71f200000000, 0x01e001ee00000000,
    0x00e1907e00000000, 0x00e2207f00000000, 0x01e3b1ef00000000,
    0x00e4407c00000000, 0x01e5d1ec00000000, 0x01e661ed00000000,
    0x00e7f07d00000000, 0x00e8807a00000000, 0x01e911ea00000000,
    0x01eaa1eb00000000, 0x00eb307b00000000, 0x01ecc1e800000000,
    0x00ed507800000000, 0x00eee07900000000, 0x01ef71e900000000,
    0x00f0007700000000, 0x01f191e700000000, 0x01f221e600000000,
    0x00f3b07600000000, 0x01f441e500000000, 0x00f5d07500000000,
    0x00f6607400000000, 0x01f7f1e400000000, 0x01f881e300000000,
    0x00f9107300000000, 0x00faa07200000000, 0x01fb31e200000000,
    0x00fcc07100000000, 0x01fd51e100000000, 0x01fee1e000000000,
    0x00ff707000000000},
   {0x0000000000000000, 0x0090019000000000, 0x0320009000000000,
    0x03b0010000000000, 0x0540039000000000, 0x05d0020000000000,
    0x0660030000000000, 0x06f0029000000000, 0x0980059000000000,
    0x0910040000000000, 0x0aa0050000000000, 0x0a30049000000000,
    0x0cc0060000000000, 0x0c50079000000000, 0x0fe0069000000000,
    0x0f70070000000000, 0x1100089000000000, 0x1190090000000000,
    0x1220080000000000, 0x12b0099000000000, 0x14400b0000000000,
    0x14d00a9000000000, 0x17600b9000000000, 0x17f00a0000000000,
    0x18800d0000000000, 0x18100c9000000000, 0x1ba00d9000000000,
    0x1b300c0000000000, 0x1dc00e9000000000, 0x1d500f0000000000,
    0x1ee00e0000000000, 0x1e700f9000000000, 0x2100139000000000,
    0x2190120000000000, 0x2220130000000000, 0x22b0129000000000,
    0x2440100000000000, 0x24d0119000000000, 0x2760109000000000,
    0x27f0110000000000, 0x2880160000000000, 0x2810179000000000,
    0x2ba0169000000000, 0x2b30170000000000, 0x2dc0159000000000,
    0x2d50140000000000, 0x2ee0150000000000, 0x2e70149000000000,
    0x30001b0000000000, 0x30901a9000000000, 0x33201b9000000000,
    0x33b01a0000000000, 0x3540189000000000, 0x35d0190000000000,
    0x3660180000000000, 0x36f0199000000000, 0x39801e9000000000,
    0x39101f0000000000, 0x3aa01e0000000000, 0x3a301f9000000000,
    0x3cc01d0000000000, 0x3c501c9000000000, 0x3fe01d9000000000,
    0x3f701c0000000000, 0x4100259000000000, 0x4190240000000000,
    0x4220250000000000, 0x42b0249000000000, 0x4440260000000000,
    0x44d0279000000000, 0x4760269000000000, 0x47f0270000000000,
    0x4880200000000000, 0x4810219000000000, 0x4ba0209000000000,
    0x4b30210000000000, 0x4dc0239000000000, 0x4d50220000000000,
    0x4ee0230000000000, 0x4e70229000000000, 0x50002d0000000000,
    0x50902c9000000000, 0x53202d9000000000, 0x53b02c0000000000,
    0x55402e9000000000, 0x55d02f0000000000, 0x56602e0000000000,
    0x56f02f9000000000, 0x5980289000000000, 0x5910290000000000,
    0x5aa0280000000000, 0x5a30299000000000, 0x5cc02b0000000000,
    0x5c502a9000000000, 0x5fe02b9000000000, 0x5f702a0000000000,
    0x6000360000000000, 0x6090379000000000, 0x6320369000000000,
    0x63b0370000000000, 0x6540359000000000, 0x65d0340000000000,
    0x6660350000000000, 0x66f0349000000000, 0x6980339000000000,
    0x6910320000000000, 0x6aa0330000000000, 0x6a30329000000000,
    0x6cc0300000000000, 0x6c50319000000000, 0x6fe0309000000000,
    0x6f70310000000000, 0x71003e9000000000, 0x71903f0000000000,
    0x72203e0000000000, 0x72b03f9000000000, 0x74403d0000000000,
    0x74d03c9000000000, 0x77603d9000000000, 0x77f03c0000000000,
    0x78803b0000000000, 0x78103a9000000000, 0x7ba03b9000000000,
    0x7b303a0000000000, 0x7dc0389000000000, 0x7d50390000000000,
    0x7ee0380000000000, 0x7e70399000000000, 0x8100499000000000,
    0x8190480000000000, 0x8220490000000000, 0x82b0489000000000,
    0x84404a0000000000, 0x84d04b9000000000, 0x87604a9000000000,
    0x87f04b0000000000, 0x88804c0000000000, 0x88104d9000000000,
    0x8ba04c9000000000, 0x8b304d0000000000, 0x8dc04f9000000000,
    0x8d504e0000000000, 0x8ee04f0000000000, 0x8e704e9000000000,
    0x9000410000000000, 0x9090409000000000, 0x9320419000000000,
    0x93b0400000000000, 0x9540429000000000, 0x95d0430000000000,
    0x9660420000000000, 0x96f0439000000000, 0x9980449000000000,
    0x9910450000000000, 0x9aa0440000000000, 0x9a30459000000000,
    0x9cc0470000000000, 0x9c50469000000000, 0x9fe0479000000000,
    0x9f70460000000000, 0xa0005a0000000000, 0xa0905b9000000000,
    0xa3205a9000000000, 0xa3b05b0000000000, 0xa540599000000000,
    0xa5d0580000000000, 0xa660590000000000, 0xa6f0589000000000,
    0xa9805f9000000000, 0xa9105e0000000000, 0xaaa05f0000000000,
    0xaa305e9000000000, 0xacc05c0000000000, 0xac505d9000000000,
    0xafe05c9000000000, 0xaf705d0000000000, 0xb100529000000000,
    0xb190530000000000, 0xb220520000000000, 0xb2b0539000000000,
    0xb440510000000000, 0xb4d0509000000000, 0xb760519000000000,
    0xb7f0500000000000, 0xb880570000000000, 0xb810569000000000,
    0xbba0579000000000, 0xbb30560000000000, 0xbdc0549000000000,
    0xbd50550000000000, 0xbee0540000000000, 0xbe70559000000000,
    0xc0006c0000000000, 0xc0906d9000000000, 0xc3206c9000000000,
    0xc3b06d0000000000, 0xc5406f9000000000, 0xc5d06e0000000000,
    0xc6606f0000000000, 0xc6f06e9000000000, 0xc980699000000000,
    0xc910680000000000, 0xcaa0690000000000, 0xca30689000000000,
    0xccc06a0000000000, 0xcc506b9000000000, 0xcfe06a9000000000,
    0xcf706b0000000000, 0xd100649000000000, 0xd190650000000000,
    0xd220640000000000, 0xd2b0659000000000, 0xd440670000000000,
    0xd4d0669000000000, 0xd760679000000000, 0xd7f0660000000000,
    0xd880610000000000, 0xd810609000000000, 0xdba0619000000000,
    0xdb30600000000000, 0xddc0629000000000, 0xdd50630000000000,
    0xdee0620000000000, 0xde70639000000000, 0xe1007f9000000000,
    0xe1907e0000000000, 0xe2207f0000000000, 0xe2b07e9000000000,
    0xe4407c0000000000, 0xe4d07d9000000000, 0xe7607c9000000000,
    0xe7f07d0000000000, 0xe8807a0000000000, 0xe8107b9000000000,
    0xeba07a9000000000, 0xeb307b0000000000, 0xedc0799000000000,
    0xed50780000000000, 0xeee0790000000000, 0xee70789000000000,
    0xf000770000000000, 0xf090769000000000, 0xf320779000000000,
    0xf3b0760000000000, 0xf540749000000000, 0xf5d0750000000000,
    0xf660740000000000, 0xf6f0759000000000, 0xf980729000000000,
    0xf910730000000000, 0xfaa0720000000000, 0xfa30739000000000,
    0xfcc0710000000000, 0xfc50709000000000, 0xffe0719000000000,
    0xff70700000000000},
   {0x0000000000000000, 0x9001900000000000, 0x2003200100000000,
    0xb002b00100000000, 0x4006400200000000, 0xd007d00200000000,
    0x6005600300000000, 0xf004f00300000000, 0x800c800400000000,
    0x100d100400000000, 0xa00fa00500000000, 0x300e300500000000,
    0xc00ac00600000000, 0x500b500600000000, 0xe009e00700000000,
    0x7008700700000000, 0x0019000900000000, 0x9018900900000000,
    0x201a200800000000, 0xb01bb00800000000, 0x401f400b00000000,
    0xd01ed00b00000000, 0x601c600a00000000, 0xf01df00a00000000,
    0x8015800d00000000, 0x1014100d00000000, 0xa016a00c00000000,
    0x3017300c00000000, 0xc013c00f00000000, 0x5012500f00000000,
    0xe010e00e00000000, 0x7011700e00000000, 0x0032001200000000,
    0x9033901200000000, 0x2031201300000000, 0xb030b01300000000,
    0x4034401000000000, 0xd035d01000000000, 0x6037601100000000,
    0xf036f01100000000, 0x803e801600000000, 0x103f101600000000,
    0xa03da01700000000, 0x303c301700000000, 0xc038c01400000000,
    0x5039501400000000, 0xe03be01500000000, 0x703a701500000000,
    0x002b001b00000000, 0x902a901b00000000, 0x2028201a00000000,
    0xb029b01a00000000, 0x402d401900000000, 0xd02cd01900000000,
    0x602e601800000000, 0xf02ff01800000000, 0x8027801f00000000,
    0x1026101f00000000, 0xa024a01e00000000, 0x3025301e00000000,
    0xc021c01d00000000, 0x5020501d00000000, 0xe022e01c00000000,
    0x7023701c00000000, 0x0064002400000000, 0x9065902400000000,
    0x2067202500000000, 0xb066b02500000000, 0x4062402600000000,
    0xd063d02600000000, 0x6061602700000000, 0xf060f02700000000,
    0x8068802000000000, 0x1069102000000000, 0xa06ba02100000000,
    0x306a302100000000, 0xc06ec02200000000, 0x506f502200000000,
    0xe06de02300000000, 0x706c702300000000, 0x007d002d00000000,
    0x907c902d00000000, 0x207e202c00000000, 0xb07fb02c00000000,
    0x407b402f00000000, 0xd07ad02f00000000, 0x6078602e00000000,
    0xf079f02e00000000, 0x8071802900000000, 0x1070102900000000,
    0xa072a02800000000, 0x3073302800000000, 0xc077c02b00000000,
    0x5076502b00000000, 0xe074e02a00000000, 0x7075702a00000000,
    0x0056003600000000, 0x9057903600000000, 0x2055203700000000,
    0xb054b03700000000, 0x4050403400000000, 0xd051d03400000000,
    0x6053603500000000, 0xf052f03500000000, 0x805a803200000000,
    0x105b103200000000, 0xa059a03300000000, 0x3058303300000000,
    0xc05cc03000000000, 0x505d503000000000, 0xe05fe03100000000,
    0x705e703100000000, 0x004f003f00000000, 0x904e903f00000000,
    0x204c203e00000000, 0xb04db03e00000000, 0x4049403d00000000,
    0xd048d03d00000000, 0x604a603c00000000, 0xf04bf03c00000000,
    0x8043803b00000000, 0x1042103b00000000, 0xa040a03a00000000,
    0x3041303a00000000, 0xc045c03900000000, 0x5044503900000000,
    0xe046e03800000000, 0x7047703800000000, 0x00c8004800000000,
    0x90c9904800000000, 0x20cb204900000000, 0xb0cab04900000000,
    0x40ce404a00000000, 0xd0cfd04a00000000, 0x60cd604b00000000,
    0xf0ccf04b00000000, 0x80c4804c00000000, 0x10c5104c00000000,
    0xa0c7a04d00000000, 0x30c6304d00000000, 0xc0c2c04e00000000,
    0x50c3504e00000000, 0xe0c1e04f00000000, 0x70c0704f00000000,
    0x00d1004100000000, 0x90d0904100000000, 0x20d2204000000000,
    0xb0d3b04000000000, 0x40d7404300000000, 0xd0d6d04300000000,
    0x60d4604200000000, 0xf0d5f04200000000, 0x80dd804500000000,
    0x10dc104500000000, 0xa0dea04400000000, 0x30df304400000000,
    0xc0dbc04700000000, 0x50da504700000000, 0xe0d8e04600000000,
    0x70d9704600000000, 0x00fa005a00000000, 0x90fb905a00000000,
    0x20f9205b00000000, 0xb0f8b05b00000000, 0x40fc405800000000,
    0xd0fdd05800000000, 0x60ff605900000000, 0xf0fef05900000000,
    0x80f6805e00000000, 0x10f7105e00000000, 0xa0f5a05f00000000,
    0x30f4305f00000000, 0xc0f0c05c00000000, 0x50f1505c00000000,
    0xe0f3e05d00000000, 0x70f2705d00000000, 0x00e3005300000000,
    0x90e2905300000000, 0x20e0205200000000, 0xb0e1b05200000000,
    0x40e5405100000000, 0xd0e4d05100000000, 0x60e6605000000000,
    0xf0e7f05000000000, 0x80ef805700000000, 0x10ee105700000000,
    0xa0eca05600000000, 0x30ed305600000000, 0xc0e9c05500000000,
    0x50e8505500000000, 0xe0eae05400000000, 0x70eb705400000000,
    0x00ac006c00000000, 0x90ad906c00000000, 0x20af206d00000000,
    0xb0aeb06d00000000, 0x40aa406e00000000, 0xd0abd06e00000000,
    0x60a9606f00000000, 0xf0a8f06f00000000, 0x80a0806800000000,
    0x10a1106800000000, 0xa0a3a06900000000, 0x30a2306900000000,
    0xc0a6c06a00000000, 0x50a7506a00000000, 0xe0a5e06b00000000,
    0x70a4706b00000000, 0x00b5006500000000, 0x90b4906500000000,
    0x20b6206400000000, 0xb0b7b06400000000, 0x40b3406700000000,
    0xd0b2d06700000000, 0x60b0606600000000, 0xf0b1f06600000000,
    0x80b9806100000000, 0x10b8106100000000, 0xa0baa06000000000,
    0x30bb306000000000, 0xc0bfc06300000000, 0x50be506300000000,
    0xe0bce06200000000, 0x70bd706200000000, 0x009e007e00000000,
    0x909f907e00000000, 0x209d207f00000000, 0xb09cb07f00000000,
    0x4098407c00000000, 0xd099d07c00000000, 0x609b607d00000000,
    0xf09af07d00000000, 0x8092807a00000000, 0x1093107a00000000,
    0xa091a07b00000000, 0x3090307b00000000, 0xc094c07800000000,
    0x5095507800000000, 0xe097e07900000000, 0x7096707900000000,
    0x0087007700000000, 0x9086907700000000, 0x2084207600000000,
    0xb085b07600000000, 0x4081407500000000, 0xd080d07500000000,
    0x6082607400000000, 0xf083f07400000000, 0x808b807300000000,
    0x108a107300000000, 0xa088a07200000000, 0x3089307200000000,
    0xc08dc07100000000, 0x508c507100000000, 0xe08ee07000000000,
    0x708f707000000000},
   {0x0000000000000000, 0x0100004100000000, 0x0200008200000000,
    0x030000c300000000, 0x070003b400000000, 0x060003f500000000,
    0x0500033600000000, 0x0400037700000000, 0x0d0005d800000000,
    0x0c00059900000000, 0x0f00055a00000000, 0x0e00051b00000000,
    0x0a00066c00000000, 0x0b00062d00000000, 0x080006ee00000000,
    0x090006af00000000, 0x1900090000000000, 0x1800094100000000,
    0x1b00098200000000, 0x1a0009c300000000, 0x1e000ab400000000,
    0x1f000af500000000, 0x1c000a3600000000, 0x1d000a7700000000,
    0x14000cd800000000, 0x15000c9900000000, 0x16000c5a00000000,
    0x17000c1b00000000, 0x13000f6c00000000, 0x12000f2d00000000,
    0x11000fee00000000, 0x10000faf00000000, 0x3200120000000000,
    0x3300124100000000, 0x3000128200000000, 0x310012c300000000,
    0x350011b400000000, 0x340011f500000000, 0x3700113600000000,
    0x3600117700000000, 0x3f0017d800000000, 0x3e00179900000000,
    0x3d00175a00000000, 0x3c00171b00000000, 0x3800146c00000000,
    0x3900142d00000000, 0x3a0014ee00000000, 0x3b0014af00000000,
    0x2b001b0000000000, 0x2a001b4100000000, 0x29001b8200000000,
    0x28001bc300000000, 0x2c0018b400000000, 0x2d0018f500000000,
    0x2e00183600000000, 0x2f00187700000000, 0x26001ed800000000,
    0x27001e9900000000, 0x24001e5a00000000, 0x25001e1b00000000,
    0x21001d6c00000000, 0x20001d2d00000000, 0x23001dee00000000,
    0x22001daf00000000, 0x6400240000000000, 0x6500244100000000,
    0x6600248200000000, 0x670024c300000000, 0x630027b400000000,
    0x620027f500000000, 0x6100273600000000, 0x6000277700000000,
    0x690021d800000000, 0x6800219900000000, 0x6b00215a00000000,
    0x6a00211b00000000, 0x6e00226c00000000, 0x6f00222d00000000,
    0x6c0022ee00000000, 0x6d0022af00000000, 0x7d002d0000000000,
    0x7c002d4100000000, 0x7f002d8200000000, 0x7e002dc300000000,
    0x7a002eb400000000, 0x7b002ef500000000, 0x78002e3600000000,
    0x79002e7700000000, 0x700028d800000000, 0x7100289900000000,
    0x7200285a00000000, 0x7300281b00000000, 0x77002b6c00000000,
    0x76002b2d00000000, 0x75002bee00000000, 0x74002baf00000000,
    0x5600360000000000, 0x5700364100000000, 0x5400368200000000,
    0x550036c300000000, 0x510035b400000000, 0x500035f500000000,
    0x5300353600000000, 0x5200357700000000, 0x5b0033d800000000,
    0x5a00339900000000, 0x5900335a00000000, 0x5800331b00000000,
    0x5c00306c00000000, 0x5d00302d00000000, 0x5e0030ee00000000,
    0x5f0030af00000000, 0x4f003f0000000000, 0x4e003f4100000000,
    0x4d003f8200000000, 0x4c003fc300000000, 0x48003cb400000000,
    0x49003cf500000000, 0x4a003c3600000000, 0x4b003c7700000000,
    0x42003ad800000000, 0x43003a9900000000, 0x40003a5a00000000,
    0x41003a1b00000000, 0x4500396c00000000, 0x4400392d00000000,
    0x470039ee00000000, 0x460039af00000000, 0xc800480000000000,
    0xc900484100000000, 0xca00488200000000, 0xcb0048c300000000,
    0xcf004bb400000000, 0xce004bf500000000, 0xcd004b3600000000,
    0xcc004b7700000000, 0xc5004dd800000000, 0xc4004d9900000000,
    0xc7004d5a00000000, 0xc6004d1b00000000, 0xc2004e6c00000000,
    0xc3004e2d00000000, 0xc0004eee00000000, 0xc1004eaf00000000,
    0xd100410000000000, 0xd000414100000000, 0xd300418200000000,
    0xd20041c300000000, 0xd60042b400000000, 0xd70042f500000000,
    0xd400423600000000, 0xd500427700000000, 0xdc0044d800000000,
    0xdd00449900000000, 0xde00445a00000000, 0xdf00441b00000000,
    0xdb00476c00000000, 0xda00472d00000000, 0xd90047ee00000000,
    0xd80047af00000000, 0xfa005a0000000000, 0xfb005a4100000000,
    0xf8005a8200000000, 0xf9005ac300000000, 0xfd0059b400000000,
    0xfc0059f500000000, 0xff00593600000000, 0xfe00597700000000,
    0xf7005fd800000000, 0xf6005f9900000000, 0xf5005f5a00000000,
    0xf4005f1b00000000, 0xf0005c6c00000000, 0xf1005c2d00000000,
    0xf2005cee00000000, 0xf3005caf00000000, 0xe300530000000000,
    0xe200534100000000, 0xe100538200000000, 0xe00053c300000000,
    0xe40050b400000000, 0xe50050f500000000, 0xe600503600000000,
    0xe700507700000000, 0xee0056d800000000, 0xef00569900000000,
    0xec00565a00000000, 0xed00561b00000000, 0xe900556c00000000,
    0xe800552d00000000, 0xeb0055ee00000000, 0xea0055af00000000,
    0xac006c0000000000, 0xad006c4100000000, 0xae006c8200000000,
    0xaf006cc300000000, 0xab006fb400000000, 0xaa006ff500000000,
    0xa9006f3600000000, 0xa8006f7700000000, 0xa10069d800000000,
    0xa000699900000000, 0xa300695a00000000, 0xa200691b00000000,
    0xa6006a6c00000000, 0xa7006a2d00000000, 0xa4006aee00000000,
    0xa5006aaf00000000, 0xb500650000000000, 0xb400654100000000,
    0xb700658200000000, 0xb60065c300000000, 0xb20066b400000000,
    0xb30066f500000000, 0xb000663600000000, 0xb100667700000000,
    0xb80060d800000000, 0xb900609900000000, 0xba00605a00000000,
    0xbb00601b00000000, 0xbf00636c00000000, 0xbe00632d00000000,
    0xbd0063ee00000000, 0xbc0063af00000000, 0x9e007e0000000000,
    0x9f007e4100000000, 0x9c007e8200000000, 0x9d007ec300000000,
    0x99007db400000000, 0x98007df500000000, 0x9b007d3600000000,
    0x9a007d7700000000, 0x93007bd800000000, 0x92007b9900000000,
    0x91007b5a00000000, 0x90007b1b00000000, 0x9400786c00000000,
    0x9500782d00000000, 0x960078ee00000000, 0x970078af00000000,
    0x8700770000000000, 0x8600774100000000, 0x8500778200000000,
    0x840077c300000000, 0x800074b400000000, 0x810074f500000000,
    0x8200743600000000, 0x8300747700000000, 0x8a0072d800000000,
    0x8b00729900000000, 0x8800725a00000000, 0x8900721b00000000,
    0x8d00716c00000000, 0x8c00712d00000000, 0x8f0071ee00000000,
    0x8e0071af00000000},
   {0x0000000000000000, 0x0101d09000000000, 0x0102a39100000000,
    0x0003730100000000, 0x0104459300000000, 0x0005950300000000,
    0x0006e60200000000, 0x0107369200000000, 0x0108899600000000,
    0x0009590600000000, 0x000a2a0700000000, 0x010bfa9700000000,
    0x000ccc0500000000, 0x010d1c9500000000, 0x010e6f9400000000,
    0x000fbf0400000000, 0x0110119d00000000, 0x0011c10d00000000,
    0x0012b20c00000000, 0x0113629c00000000, 0x0014540e00000000,
    0x0115849e00000000, 0x0116f79f00000000, 0x0017270f00000000,
    0x0018980b00000000, 0x0119489b00000000, 0x011a3b9a00000000,
    0x001beb0a00000000, 0x011cdd9800000000, 0x001d0d0800000000,
    0x001e7e0900000000, 0x011fae9900000000, 0x0120218a00000000,
    0x0021f11a00000000, 0x0022821b00000000, 0x0123528b00000000,
    0x0024641900000000, 0x0125b48900000000, 0x0126c78800000000,
    0x0027171800000000, 0x0028a81c00000000, 0x0129788c00000000,
    0x012a0b8d00000000, 0x002bdb1d00000000, 0x012ced8f00000000,
    0x002d3d1f00000000, 0x002e4e1e00000000, 0x012f9e8e00000000,
    0x0030301700000000, 0x0131e08700000000, 0x0132938600000000,
    0x0033431600000000, 0x0134758400000000, 0x0035a51400000000,
    0x0036d61500000000, 0x0137068500000000, 0x0138b98100000000,
    0x0039691100000000, 0x003a1a1000000000, 0x013bca8000000000,
    0x003cfc1200000000, 0x013d2c8200000000, 0x013e5f8300000000,
    0x003f8f1300000000, 0x014041a400000000, 0x0041913400000000,
    0x0042e23500000000, 0x014332a500000000, 0x0044043700000000,
    0x0145d4a700000000, 0x0146a7a600000000, 0x0047773600000000,
    0x0048c83200000000, 0x014918a200000000, 0x014a6ba300000000,
    0x004bbb3300000000, 0x014c8da100000000, 0x004d5d3100000000,
    0x004e2e3000000000, 0x014ffea000000000, 0x0050503900000000,
    0x015180a900000000, 0x0152f3a800000000, 0x0053233800000000,
    0x015415aa00000000, 0x0055c53a00000000, 0x0056b63b00000000,
    0x015766ab00000000, 0x0158d9af00000000, 0x0059093f00000000,
    0x005a7a3e00000000, 0x015baaae00000000, 0x005c9c3c00000000,
    0x015d4cac00000000, 0x015e3fad00000000, 0x005fef3d00000000,
    0x0060602e00000000, 0x0161b0be00000000, 0x0162c3bf00000000,
    0x0063132f00000000, 0x016425bd00000000, 0x0065f52d00000000,
    0x0066862c00000000, 0x016756bc00000000, 0x0168e9b800000000,
    0x0069392800000000, 0x006a4a2900000000, 0x016b9ab900000000,
    0x006cac2b00000000, 0x016d7cbb00000000, 0x016e0fba00000000,
    0x006fdf2a00000000, 0x017071b300000000, 0x0071a12300000000,
    0x0072d22200000000, 0x017302b200000000, 0x0074342000000000,
    0x0175e4b000000000, 0x017697b100000000, 0x0077472100000000,
    0x0078f82500000000, 0x017928b500000000, 0x017a5bb400000000,
    0x007b8b2400000000, 0x017cbdb600000000, 0x007d6d2600000000,
    0x007e1e2700000000, 0x017fceb700000000, 0x018081f800000000,
    0x0081516800000000, 0x0082226900000000, 0x0183f2f900000000,
    0x0084c46b00000000, 0x018514fb00000000, 0x018667fa00000000,
    0x0087b76a00000000, 0x0088086e00000000, 0x0189d8fe00000000,
    0x018aabff00000000, 0x008b7b6f00000000, 0x018c4dfd00000000,
    0x008d9d6d00000000, 0x008eee6c00000000, 0x018f3efc00000000,
    0x0090906500000000, 0x019140f500000000, 0x019233f400000000,
    0x0093e36400000000, 0x0194d5f600000000, 0x0095056600000000,
    0x0096766700000000, 0x0197a6f700000000, 0x019819f300000000,
    0x0099c96300000000, 0x009aba6200000000, 0x019b6af200000000,
    0x009c5c6000000000, 0x019d8cf000000000, 0x019efff100000000,
    0x009f2f6100000000, 0x00a0a07200000000, 0x01a170e200000000,
    0x01a203e300000000, 0x00a3d37300000000, 0x01a4e5e100000000,
    0x00a5357100000000, 0x00a6467000000000, 0x01a796e000000000,
    0x01a829e400000000, 0x00a9f97400000000, 0x00aa8a7500000000,
    0x01ab5ae500000000, 0x00ac6c7700000000, 0x01adbce700000000,
    0x01aecfe600000000, 0x00af1f7600000000, 0x01b0b1ef00000000,
    0x00b1617f00000000, 0x00b2127e00000000, 0x01b3c2ee00000000,
    0x00b4f47c00000000, 0x01b524ec00000000, 0x01b657ed00000000,
    0x00b7877d00000000, 0x00b8387900000000, 0x01b9e8e900000000,
    0x01ba9be800000000, 0x00bb4b7800000000, 0x01bc7dea00000000,
    0x00bdad7a00000000, 0x00bede7b00000000, 0x01bf0eeb00000000,
    0x00c0c05c00000000, 0x01c110cc00000000, 0x01c263cd00000000,
    0x00c3b35d00000000, 0x01c485cf00000000, 0x00c5555f00000000,
    0x00c6265e00000000, 0x01c7f6ce00000000, 0x01c849ca00000000,
    0x00c9995a00000000, 0x00caea5b00000000, 0x01cb3acb00000000,
    0x00cc0c5900000000, 0x01cddcc900000000, 0x01ceafc800000000,
    0x00cf7f5800000000, 0x01d0d1c100000000, 0x00d1015100000000,
    0x00d2725000000000, 0x01d3a2c000000000, 0x00d4945200000000,
    0x01d544c200000000, 0x01d637c300000000, 0x00d7e75300000000,
    0x00d8585700000000, 0x01d988c700000000, 0x01dafbc600000000,
    0x00db2b5600000000, 0x01dc1dc400000000, 0x00ddcd5400000000,
    0x00debe5500000000, 0x01df6ec500000000, 0x01e0e1d600000000,
    0x00e1314600000000, 0x00e2424700000000, 0x01e392d700000000,
    0x00e4a44500000000, 0x01e574d500000000, 0x01e607d400000000,
    0x00e7d74400000000, 0x00e8684000000000, 0x01e9b8d000000000,
    0x01eacbd100000000, 0x00eb1b4100000000, 0x01ec2dd300000000,
    0x00edfd4300000000, 0x00ee8e4200000000, 0x01ef5ed200000000,
    0x00f0f04b00000000, 0x01f120db00000000, 0x01f253da00000000,
    0x00f3834a00000000, 0x01f4b5d800000000, 0x00f5654800000000,
    0x00f6164900000000, 0x01f7c6d900000000, 0x01f879dd00000000,
    0x00f9a94d00000000, 0x00fada4c00000000, 0x01fb0adc00000000,
    0x00fc3c4e00000000, 0x01fdecde00000000, 0x01fe9fdf00000000,
    0x00ff4f4f00000000},
   {0x0000000000000000, 0x00d1019000000000, 0x03a2009000000000,
    0x0373010000000000, 0x0544029000000000, 0x0595030000000000,
    0x06e6020000000000, 0x0637039000000000, 0x0988079000000000,
    0x0959060000000000, 0x0a2a070000000000, 0x0afb069000000000,
    0x0ccc050000000000, 0x0c1d049000000000, 0x0f6e059000000000,
    0x0fbf040000000000, 0x11100c9000000000, 0x11c10d0000000000,
    0x12b20c0000000000, 0x12630d9000000000, 0x14540e0000000000,
    0x14850f9000000000, 0x17f60e9000000000, 0x17270f0000000000,
    0x18980b0000000000, 0x18490a9000000000, 0x1b3a0b9000000000,
    0x1beb0a0000000000, 0x1ddc099000000000, 0x1d0d080000000000,
    0x1e7e090000000000, 0x1eaf089000000000, 0x21201b9000000000,
    0x21f11a0000000000, 0x22821b0000000000, 0x22531a9000000000,
    0x2464190000000000, 0x24b5189000000000, 0x27c6199000000000,
    0x2717180000000000, 0x28a81c0000000000, 0x28791d9000000000,
    0x2b0a1c9000000000, 0x2bdb1d0000000000, 0x2dec1e9000000000,
    0x2d3d1f0000000000, 0x2e4e1e0000000000, 0x2e9f1f9000000000,
    0x3030170000000000, 0x30e1169000000000, 0x3392179000000000,
    0x3343160000000000, 0x3574159000000000, 0x35a5140000000000,
    0x36d6150000000000, 0x3607149000000000, 0x39b8109000000000,
    0x3969110000000000, 0x3a1a100000000000, 0x3acb119000000000,
    0x3cfc120000000000, 0x3c2d139000000000, 0x3f5e129000000000,
    0x3f8f130000000000, 0x4140359000000000, 0x4191340000000000,
    0x42e2350000000000, 0x4233349000000000, 0x4404370000000000,
    0x44d5369000000000, 0x47a6379000000000, 0x4777360000000000,
    0x48c8320000000000, 0x4819339000000000, 0x4b6a329000000000,
    0x4bbb330000000000, 0x4d8c309000000000, 0x4d5d310000000000,
    0x4e2e300000000000, 0x4eff319000000000, 0x5050390000000000,
    0x5081389000000000, 0x53f2399000000000, 0x5323380000000000,
    0x55143b9000000000, 0x55c53a0000000000, 0x56b63b0000000000,
    0x56673a9000000000, 0x59d83e9000000000, 0x59093f0000000000,
    0x5a7a3e0000000000, 0x5aab3f9000000000, 0x5c9c3c0000000000,
    0x5c4d3d9000000000, 0x5f3e3c9000000000, 0x5fef3d0000000000,
    0x60602e0000000000, 0x60b12f9000000000, 0x63c22e9000000000,
    0x63132f0000000000, 0x65242c9000000000, 0x65f52d0000000000,
    0x66862c0000000000, 0x66572d9000000000, 0x69e8299000000000,
    0x6939280000000000, 0x6a4a290000000000, 0x6a9b289000000000,
    0x6cac2b0000000000, 0x6c7d2a9000000000, 0x6f0e2b9000000000,
    0x6fdf2a0000000000, 0x7170229000000000, 0x71a1230000000000,
    0x72d2220000000000, 0x7203239000000000, 0x7434200000000000,
    0x74e5219000000000, 0x7796209000000000, 0x7747210000000000,
    0x78f8250000000000, 0x7829249000000000, 0x7b5a259000000000,
    0x7b8b240000000000, 0x7dbc279000000000, 0x7d6d260000000000,
    0x7e1e270000000000, 0x7ecf269000000000, 0x8180699000000000,
    0x8151680000000000, 0x8222690000000000, 0x82f3689000000000,
    0x84c46b0000000000, 0x84156a9000000000, 0x87666b9000000000,
    0x87b76a0000000000, 0x88086e0000000000, 0x88d96f9000000000,
    0x8baa6e9000000000, 0x8b7b6f0000000000, 0x8d4c6c9000000000,
    0x8d9d6d0000000000, 0x8eee6c0000000000, 0x8e3f6d9000000000,
    0x9090650000000000, 0x9041649000000000, 0x9332659000000000,
    0x93e3640000000000, 0x95d4679000000000, 0x9505660000000000,
    0x9676670000000000, 0x96a7669000000000, 0x9918629000000000,
    0x99c9630000000000, 0x9aba620000000000, 0x9a6b639000000000,
    0x9c5c600000000000, 0x9c8d619000000000, 0x9ffe609000000000,
    0x9f2f610000000000, 0xa0a0720000000000, 0xa071739000000000,
    0xa302729000000000, 0xa3d3730000000000, 0xa5e4709000000000,
    0xa535710000000000, 0xa646700000000000, 0xa697719000000000,
    0xa928759000000000, 0xa9f9740000000000, 0xaa8a750000000000,
    0xaa5b749000000000, 0xac6c770000000000, 0xacbd769000000000,
    0xafce779000000000, 0xaf1f760000000000, 0xb1b07e9000000000,
    0xb1617f0000000000, 0xb2127e0000000000, 0xb2c37f9000000000,
    0xb4f47c0000000000, 0xb4257d9000000000, 0xb7567c9000000000,
    0xb7877d0000000000, 0xb838790000000000, 0xb8e9789000000000,
    0xbb9a799000000000, 0xbb4b780000000000, 0xbd7c7b9000000000,
    0xbdad7a0000000000, 0xbede7b0000000000, 0xbe0f7a9000000000,
    0xc0c05c0000000000, 0xc0115d9000000000, 0xc3625c9000000000,
    0xc3b35d0000000000, 0xc5845e9000000000, 0xc5555f0000000000,
    0xc6265e0000000000, 0xc6f75f9000000000, 0xc9485b9000000000,
    0xc9995a0000000000, 0xcaea5b0000000000, 0xca3b5a9000000000,
    0xcc0c590000000000, 0xccdd589000000000, 0xcfae599000000000,
    0xcf7f580000000000, 0xd1d0509000000000, 0xd101510000000000,
    0xd272500000000000, 0xd2a3519000000000, 0xd494520000000000,
    0xd445539000000000, 0xd736529000000000, 0xd7e7530000000000,
    0xd858570000000000, 0xd889569000000000, 0xdbfa579000000000,
    0xdb2b560000000000, 0xdd1c559000000000, 0xddcd540000000000,
    0xdebe550000000000, 0xde6f549000000000, 0xe1e0479000000000,
    0xe131460000000000, 0xe242470000000000, 0xe293469000000000,
    0xe4a4450000000000, 0xe475449000000000, 0xe706459000000000,
    0xe7d7440000000000, 0xe868400000000000, 0xe8b9419000000000,
    0xebca409000000000, 0xeb1b410000000000, 0xed2c429000000000,
    0xedfd430000000000, 0xee8e420000000000, 0xee5f439000000000,
    0xf0f04b0000000000, 0xf0214a9000000000, 0xf3524b9000000000,
    0xf3834a0000000000, 0xf5b4499000000000, 0xf565480000000000,
    0xf616490000000000, 0xf6c7489000000000, 0xf9784c9000000000,
    0xf9a94d0000000000, 0xfada4c0000000000, 0xfa0b4d9000000000,
    0xfc3c4e0000000000, 0xfced4f9000000000, 0xff9e4e9000000000,
    0xff4f4f0000000000},
   {0x0000000000000000, 0xd101900000000000, 0xa203200100000000,
    0x7302b00100000000, 0x4407400200000000, 0x9506d00200000000,
    0xe604600300000000, 0x3705f00300000000, 0x880e800400000000,
    0x590f100400000000, 0x2a0da00500000000, 0xfb0c300500000000,
    0xcc09c00600000000, 0x1d08500600000000, 0x6e0ae00700000000,
    0xbf0b700700000000, 0x101d000900000000, 0xc11c900900000000,
    0xb21e200800000000, 0x631fb00800000000, 0x541a400b00000000,
    0x851bd00b00000000, 0xf619600a00000000, 0x2718f00a00000000,
    0x9813800d00000000, 0x4912100d00000000, 0x3a10a00c00000000,
    0xeb11300c00000000, 0xdc14c00f00000000, 0x0d15500f00000000,
    0x7e17e00e00000000, 0xaf16700e00000000, 0x203a001200000000,
    0xf13b901200000000, 0x8239201300000000, 0x5338b01300000000,
    0x643d401000000000, 0xb53cd01000000000, 0xc63e601100000000,
    0x173ff01100000000, 0xa834801600000000, 0x7935101600000000,
    0x0a37a01700000000, 0xdb36301700000000, 0xec33c01400000000,
    0x3d32501400000000, 0x4e30e01500000000, 0x9f31701500000000,
    0x3027001b00000000, 0xe126901b00000000, 0x9224201a00000000,
    0x4325b01a00000000, 0x7420401900000000, 0xa521d01900000000,
    0xd623601800000000, 0x0722f01800000000, 0xb829801f00000000,
    0x6928101f00000000, 0x1a2aa01e00000000, 0xcb2b301e00000000,
    0xfc2ec01d00000000, 0x2d2f501d00000000, 0x5e2de01c00000000,
    0x8f2c701c00000000, 0x4074002400000000, 0x9175902400000000,
    0xe277202500000000, 0x3376b02500000000, 0x0473402600000000,
    0xd572d02600000000, 0xa670602700000000, 0x7771f02700000000,
    0xc87a802000000000, 0x197b102000000000, 0x6a79a02100000000,
    0xbb78302100000000, 0x8c7dc02200000000, 0x5d7c502200000000,
    0x2e7ee02300000000, 0xff7f702300000000, 0x5069002d00000000,
    0x8168902d00000000, 0xf26a202c00000000, 0x236bb02c00000000,
    0x146e402f00000000, 0xc56fd02f00000000, 0xb66d602e00000000,
    0x676cf02e00000000, 0xd867802900000000, 0x0966102900000000,
    0x7a64a02800000000, 0xab65302800000000, 0x9c60c02b00000000,
    0x4d61502b00000000, 0x3e63e02a00000000, 0xef62702a00000000,
    0x604e003600000000, 0xb14f903600000000, 0xc24d203700000000,
    0x134cb03700000000, 0x2449403400000000, 0xf548d03400000000,
    0x864a603500000000, 0x574bf03500000000, 0xe840803200000000,
    0x3941103200000000, 0x4a43a03300000000, 0x9b42303300000000,
    0xac47c03000000000, 0x7d46503000000000, 0x0e44e03100000000,
    0xdf45703100000000, 0x7053003f00000000, 0xa152903f00000000,
    0xd250203e00000000, 0x0351b03e00000000, 0x3454403d00000000,
    0xe555d03d00000000, 0x9657603c00000000, 0x4756f03c00000000,
    0xf85d803b00000000, 0x295c103b00000000, 0x5a5ea03a00000000,
    0x8b5f303a00000000, 0xbc5ac03900000000, 0x6d5b503900000000,
    0x1e59e03800000000, 0xcf58703800000000, 0x80e8004800000000,
    0x51e9904800000000, 0x22eb204900000000, 0xf3eab04900000000,
    0xc4ef404a00000000, 0x15eed04a00000000, 0x66ec604b00000000,
    0xb7edf04b00000000, 0x08e6804c00000000, 0xd9e7104c00000000,
    0xaae5a04d00000000, 0x7be4304d00000000, 0x4ce1c04e00000000,
    0x9de0504e00000000, 0xeee2e04f00000000, 0x3fe3704f00000000,
    0x90f5004100000000, 0x41f4904100000000, 0x32f6204000000000,
    0xe3f7b04000000000, 0xd4f2404300000000, 0x05f3d04300000000,
    0x76f1604200000000, 0xa7f0f04200000000, 0x18fb804500000000,
    0xc9fa104500000000, 0xbaf8a04400000000, 0x6bf9304400000000,
    0x5cfcc04700000000, 0x8dfd504700000000, 0xfeffe04600000000,
    0x2ffe704600000000, 0xa0d2005a00000000, 0x71d3905a00000000,
    0x02d1205b00000000, 0xd3d0b05b00000000, 0xe4d5405800000000,
    0x35d4d05800000000, 0x46d6605900000000, 0x97d7f05900000000,
    0x28dc805e00000000, 0xf9dd105e00000000, 0x8adfa05f00000000,
    0x5bde305f00000000, 0x6cdbc05c00000000, 0xbdda505c00000000,
    0xced8e05d00000000, 0x1fd9705d00000000, 0xb0cf005300000000,
    0x61ce905300000000, 0x12cc205200000000, 0xc3cdb05200000000,
    0xf4c8405100000000, 0x25c9d05100000000, 0x56cb605000000000,
    0x87caf05000000000, 0x38c1805700000000, 0xe9c0105700000000,
    0x9ac2a05600000000, 0x4bc3305600000000, 0x7cc6c05500000000,
    0xadc7505500000000, 0xdec5e05400000000, 0x0fc4705400000000,
    0xc09c006c00000000, 0x119d906c00000000, 0x629f206d00000000,
    0xb39eb06d00000000, 0x849b406e00000000, 0x559ad06e00000000,
    0x2698606f00000000, 0xf799f06f00000000, 0x4892806800000000,
    0x9993106800000000, 0xea91a06900000000, 0x3b90306900000000,
    0x0c95c06a00000000, 0xdd94506a00000000, 0xae96e06b00000000,
    0x7f97706b00000000, 0xd081006500000000, 0x0180906500000000,
    0x7282206400000000, 0xa383b06400000000, 0x9486406700000000,
    0x4587d06700000000, 0x3685606600000000, 0xe784f06600000000,
    0x588f806100000000, 0x898e106100000000, 0xfa8ca06000000000,
    0x2b8d306000000000, 0x1c88c06300000000, 0xcd89506300000000,
    0xbe8be06200000000, 0x6f8a706200000000, 0xe0a6007e00000000,
    0x31a7907e00000000, 0x42a5207f00000000, 0x93a4b07f00000000,
    0xa4a1407c00000000, 0x75a0d07c00000000, 0x06a2607d00000000,
    0xd7a3f07d00000000, 0x68a8807a00000000, 0xb9a9107a00000000,
    0xcaaba07b00000000, 0x1baa307b00000000, 0x2cafc07800000000,
    0xfdae507800000000, 0x8eace07900000000, 0x5fad707900000000,
    0xf0bb007700000000, 0x21ba907700000000, 0x52b8207600000000,
    0x83b9b07600000000, 0xb4bc407500000000, 0x65bdd07500000000,
    0x16bf607400000000, 0xc7bef07400000000, 0x78b5807300000000,
    0xa9b4107300000000, 0xdab6a07200000000, 0x0bb7307200000000,
    0x3cb2c07100000000, 0xedb3507100000000, 0x9eb1e07000000000,
    0x4fb0707000000000},
   {0x0000000000000000, 0x0141906500000000, 0x028220cb00000000,
    0x03c3b0ae00000000, 0x0704422600000000, 0x0645d24300000000,
    0x058662ed00000000, 0x04c7f28800000000, 0x0e08844c00000000,
    0x0f49142900000000, 0x0c8aa48700000000, 0x0dcb34e200000000,
    0x090cc66a00000000, 0x084d560f00000000, 0x0b8ee6a100000000,
    0x0acf76c400000000, 0x1c10089900000000, 0x1d5198fc00000000,
    0x1e92285200000000, 0x1fd3b83700000000, 0x1b144abf00000000,
    0x1a55dada00000000, 0x19966a7400000000, 0x18d7fa1100000000,
    0x12188cd500000000, 0x13591cb000000000, 0x109aac1e00000000,
    0x11db3c7b00000000, 0x151ccef300000000, 0x145d5e9600000000,
    0x179eee3800000000, 0x16df7e5d00000000, 0x3b20138200000000,
    0x3a6183e700000000, 0x39a2334900000000, 0x38e3a32c00000000,
    0x3c2451a400000000, 0x3d65c1c100000000, 0x3ea6716f00000000,
    0x3fe7e10a00000000, 0x352897ce00000000, 0x346907ab00000000,
    0x37aab70500000000, 0x36eb276000000000, 0x322cd5e800000000,
    0x336d458d00000000, 0x30aef52300000000, 0x31ef654600000000,
    0x27301b1b00000000, 0x26718b7e00000000, 0x25b23bd000000000,
    0x24f3abb500000000, 0x2034593d00000000, 0x2175c95800000000,
    0x22b679f600000000, 0x23f7e99300000000, 0x29389f5700000000,
    0x28790f3200000000, 0x2bbabf9c00000000, 0x2afb2ff900000000,
    0x2e3cdd7100000000, 0x2f7d4d1400000000, 0x2cbefdba00000000,
    0x2dff6ddf00000000, 0x754025b400000000, 0x7401b5d100000000,
    0x77c2057f00000000, 0x7683951a00000000, 0x7244679200000000,
    0x7305f7f700000000, 0x70c6475900000000, 0x7187d73c00000000,
    0x7b48a1f800000000, 0x7a09319d00000000, 0x79ca813300000000,
    0x788b115600000000, 0x7c4ce3de00000000, 0x7d0d73bb00000000,
    0x7ecec31500000000, 0x7f8f537000000000, 0x69502d2d00000000,
    0x6811bd4800000000, 0x6bd20de600000000, 0x6a939d8300000000,
    0x6e546f0b00000000, 0x6f15ff6e00000000, 0x6cd64fc000000000,
    0x6d97dfa500000000, 0x6758a96100000000, 0x6619390400000000,
    0x65da89aa00000000, 0x649b19cf00000000, 0x605ceb4700000000,
    0x611d7b2200000000, 0x62decb8c00000000, 0x639f5be900000000,
    0x4e60363600000000, 0x4f21a65300000000, 0x4ce216fd00000000,
    0x4da3869800000000, 0x4964741000000000, 0x4825e47500000000,
    0x4be654db00000000, 0x4aa7c4be00000000, 0x4068b27a00000000,
    0x4129221f00000000, 0x42ea92b100000000, 0x43ab02d400000000,
    0x476cf05c00000000, 0x462d603900000000, 0x45eed09700000000,
    0x44af40f200000000, 0x52703eaf00000000, 0x5331aeca00000000,
    0x50f21e6400000000, 0x51b38e0100000000, 0x55747c8900000000,
    0x5435ecec00000000, 0x57f65c4200000000, 0x56b7cc2700000000,
    0x5c78bae300000000, 0x5d392a8600000000, 0x5efa9a2800000000,
    0x5fbb0a4d00000000, 0x5b7cf8c500000000, 0x5a3d68a000000000,
    0x59fed80e00000000, 0x58bf486b00000000, 0xe98049d800000000,
    0xe8c1d9bd00000000, 0xeb02691300000000, 0xea43f97600000000,
    0xee840bfe00000000, 0xefc59b9b00000000, 0xec062b3500000000,
    0xed47bb5000000000, 0xe788cd9400000000, 0xe6c95df100000000,
    0xe50aed5f00000000, 0xe44b7d3a00000000, 0xe08c8fb200000000,
    0xe1cd1fd700000000, 0xe20eaf7900000000, 0xe34f3f1c00000000,
    0xf590414100000000, 0xf4d1d12400000000, 0xf712618a00000000,
    0xf653f1ef00000000, 0xf294036700000000, 0xf3d5930200000000,
    0xf01623ac00000000, 0xf157b3c900000000, 0xfb98c50d00000000,
    0xfad9556800000000, 0xf91ae5c600000000, 0xf85b75a300000000,
    0xfc9c872b00000000, 0xfddd174e00000000, 0xfe1ea7e000000000,
    0xff5f378500000000, 0xd2a05a5a00000000, 0xd3e1ca3f00000000,
    0xd0227a9100000000, 0xd163eaf400000000, 0xd5a4187c00000000,
    0xd4e5881900000000, 0xd72638b700000000, 0xd667a8d200000000,
    0xdca8de1600000000, 0xdde94e7300000000, 0xde2afedd00000000,
    0xdf6b6eb800000000, 0xdbac9c3000000000, 0xdaed0c5500000000,
    0xd92ebcfb00000000, 0xd86f2c9e00000000, 0xceb052c300000000,
    0xcff1c2a600000000, 0xcc32720800000000, 0xcd73e26d00000000,
    0xc9b410e500000000, 0xc8f5808000000000, 0xcb36302e00000000,
    0xca77a04b00000000, 0xc0b8d68f00000000, 0xc1f946ea00000000,
    0xc23af64400000000, 0xc37b662100000000, 0xc7bc94a900000000,
    0xc6fd04cc00000000, 0xc53eb46200000000, 0xc47f240700000000,
    0x9cc06c6c00000000, 0x9d81fc0900000000, 0x9e424ca700000000,
    0x9f03dcc200000000, 0x9bc42e4a00000000, 0x9a85be2f00000000,
    0x99460e8100000000, 0x98079ee400000000, 0x92c8e82000000000,
    0x9389784500000000, 0x904ac8eb00000000, 0x910b588e00000000,
    0x95ccaa0600000000, 0x948d3a6300000000, 0x974e8acd00000000,
    0x960f1aa800000000, 0x80d064f500000000, 0x8191f49000000000,
    0x8252443e00000000, 0x8313d45b00000000, 0x87d426d300000000,
    0x8695b6b600000000, 0x8556061800000000, 0x8417967d00000000,
    0x8ed8e0b900000000, 0x8f9970dc00000000, 0x8c5ac07200000000,
    0x8d1b501700000000, 0x89dca29f00000000, 0x889d32fa00000000,
    0x8b5e825400000000, 0x8a1f123100000000, 0xa7e07fee00000000,
    0xa6a1ef8b00000000, 0xa5625f2500000000, 0xa423cf4000000000,
    0xa0e43dc800000000, 0xa1a5adad00000000, 0xa2661d0300000000,
    0xa3278d6600000000, 0xa9e8fba200000000, 0xa8a96bc700000000,
    0xab6adb6900000000, 0xaa2b4b0c00000000, 0xaeecb98400000000,
    0xafad29e100000000, 0xac6e994f00000000, 0xad2f092a00000000,
    0xbbf0777700000000, 0xbab1e71200000000, 0xb97257bc00000000,
    0xb833c7d900000000, 0xbcf4355100000000, 0xbdb5a53400000000,
    0xbe76159a00000000, 0xbf3785ff00000000, 0xb5f8f33b00000000,
    0xb4b9635e00000000, 0xb77ad3f000000000, 0xb63b439500000000,
    0xb2fcb11d00000000, 0xb3bd217800000000, 0xb07e91d600000000,
    0xb13f01b300000000}};

#else /* W == 4 */

static const crc_t crc_braid_table[][256] = {
   {0x00000000, 0x41000001, 0x82000002, 0xc3000003, 0xb4030007,
    0xf5030006, 0x36030005, 0x77030004, 0xd805000d, 0x9905000c,
    0x5a05000f, 0x1b05000e, 0x6c06000a, 0x2d06000b, 0xee060008,
    0xaf060009, 0x00090019, 0x41090018, 0x8209001b, 0xc309001a,
    0xb40a001e, 0xf50a001f, 0x360a001c, 0x770a001d, 0xd80c0014,
    0x990c0015, 0x5a0c0016, 0x1b0c0017, 0x6c0f0013, 0x2d0f0012,
    0xee0f0011, 0xaf0f0010, 0x00120032, 0x41120033, 0x82120030,
    0xc3120031, 0xb4110035, 0xf5110034, 0x36110037, 0x77110036,
    0xd817003f, 0x9917003e, 0x5a17003d, 0x1b17003c, 0x6c140038,
    0x2d140039, 0xee14003a, 0xaf14003b, 0x001b002b, 0x411b002a,
    0x821b0029, 0xc31b0028, 0xb418002c, 0xf518002d, 0x3618002e,
    0x7718002f, 0xd81e0026, 0x991e0027, 0x5a1e0024, 0x1b1e0025,
    0x6c1d0021, 0x2d1d0020, 0xee1d0023, 0xaf1d0022, 0x00240064,
    0x41240065, 0x82240066, 0xc3240067, 0xb4270063, 0xf5270062,
    0x36270061, 0x77270060, 0xd8210069, 0x99210068, 0x5a21006b,
    0x1b21006a, 0x6c22006e, 0x2d22006f, 0xee22006c, 0xaf22006d,
    0x002d007d, 0x412d007c, 0x822d007f, 0xc32d007e, 0xb42e007a,
    0xf52e007b, 0x362e0078, 0x772e0079, 0xd8280070, 0x99280071,
    0x5a280072, 0x1b280073, 0x6c2b0077, 0x2d2b0076, 0xee2b0075,
    0xaf2b0074, 0x00360056, 0x41360057, 0x82360054, 0xc3360055,
    0xb4350051, 0xf5350050, 0x36350053, 0x77350052, 0xd833005b,
    0x9933005a, 0x5a330059, 0x1b330058, 0x6c30005c, 0x2d30005d,
    0xee30005e, 0xaf30005f, 0x003f004f, 0x413f004e, 0x823f004d,
    0xc33f004c, 0xb43c0048, 0xf53c0049, 0x363c004a, 0x773c004b,
    0xd83a0042, 0x993a0043, 0x5a3a0040, 0x1b3a0041, 0x6c390045,
    0x2d390044, 0xee390047, 0xaf390046, 0x004800c8, 0x414800c9,
    0x824800ca, 0xc34800cb, 0xb44b00cf, 0xf54b00ce, 0x364b00cd,
    0x774b00cc, 0xd84d00c5, 0x994d00c4, 0x5a4d00c7, 0x1b4d00c6,
    0x6c4e00c2, 0x2d4e00c3, 0xee4e00c0, 0xaf4e00c1, 0x004100d1,
    0x414100d0, 0x824100d3, 0xc34100d2, 0xb44200d6, 0xf54200d7,
    0x364200d4, 0x774200d5, 0xd84400dc, 0x994400dd, 0x5a4400de,
    0x1b4400df, 0x6c4700db, 0x2d4700da, 0xee4700d9, 0xaf4700d8,
    0x005a00fa, 0x415a00fb, 0x825a00f8, 0xc35a00f9, 0xb45900fd,
    0xf55900fc, 0x365900ff, 0x775900fe, 0xd85f00f7, 0x995f00f6,
    0x5a5f00f5, 0x1b5f00f4, 0x6c5c00f0, 0x2d5c00f1, 0xee5c00f2,
    0xaf5c00f3, 0x005300e3, 0x415300e2, 0x825300e1, 0xc35300e0,
    0xb45000e4, 0xf55000e5, 0x365000e6, 0x775000e7, 0xd85600ee,
    0x995600ef, 0x5a5600ec, 0x1b5600ed, 0x6c5500e9, 0x2d5500e8,
    0xee5500eb, 0xaf5500ea, 0x006c00ac, 0x416c00ad, 0x826c00ae,
    0xc36c00af, 0xb46f00ab, 0xf56f00aa, 0x366f00a9, 0x776f00a8,
    0xd86900a1, 0x996900a0, 0x5a6900a3, 0x1b6900a2, 0x6c6a00a6,
    0x2d6a00a7, 0xee6a00a4, 0xaf6a00a5, 0x006500b5, 0x416500b4,
    0x826500b7, 0xc36500b6, 0xb46600b2, 0xf56600b3, 0x366600b0,
    0x776600b1, 0xd86000b8, 0x996000b9, 0x5a6000ba, 0x1b6000bb,
    0x6c6300bf, 0x2d6300be, 0xee6300bd, 0xaf6300bc, 0x007e009e,
    0x417e009f, 0x827e009c, 0xc37e009d, 0xb47d0099, 0xf57d0098,
    0x367d009b, 0x777d009a, 0xd87b0093, 0x997b0092, 0x5a7b0091,
    0x1b7b0090, 0x6c780094, 0x2d780095, 0xee780096, 0xaf780097,
    0x00770087, 0x41770086, 0x82770085, 0xc3770084, 0xb4740080,
    0xf5740081, 0x36740082, 0x77740083, 0xd872008a, 0x9972008b,
    0x5a720088, 0x1b720089, 0x6c71008d, 0x2d71008c, 0xee71008f,
    0xaf71008e},
   {0x00000000, 0x00900190, 0x01200320, 0x01b002b0, 0x02400640,
    0x02d007d0, 0x03600560, 0x03f004f0, 0x04800c80, 0x04100d10,
    0x05a00fa0, 0x05300e30, 0x06c00ac0, 0x06500b50, 0x07e009e0,
    0x07700870, 0x09001900, 0x09901890, 0x08201a20, 0x08b01bb0,
    0x0b401f40, 0x0bd01ed0, 0x0a601c60, 0x0af01df0, 0x0d801580,
    0x0d101410, 0x0ca016a0, 0x0c301730, 0x0fc013c0, 0x0f501250,
    0x0ee010e0, 0x0e701170, 0x12003200, 0x12903390, 0x13203120,
    0x13b030b0, 0x10403440, 0x10d035d0, 0x11603760, 0x11f036f0,
    0x16803e80, 0x16103f10, 0x17a03da0, 0x17303c30, 0x14c038c0,
    0x14503950, 0x15e03be0, 0x15703a70, 0x1b002b00, 0x1b902a90,
    0x1a202820, 0x1ab029b0, 0x19402d40, 0x19d02cd0, 0x18602e60,
    0x18f02ff0, 0x1f802780, 0x1f102610, 0x1ea024a0, 0x1e302530,
    0x1dc021c0, 0x1d502050, 0x1ce022e0, 0x1c702370, 0x24006400,
    0x24906590, 0x25206720, 0x25b066b0, 0x26406240, 0x26d063d0,
    0x27606160, 0x27f060f0, 0x20806880, 0x20106910, 0x21a06ba0,
    0x21306a30, 0x22c06ec0, 0x22506f50, 0x23e06de0, 0x23706c70,
    0x2d007d00, 0x2d907c90, 0x2c207e20, 0x2cb07fb0, 0x2f407b40,
    0x2fd07ad0, 0x2e607860, 0x2ef079f0, 0x29807180, 0x29107010,
    0x28a072a0, 0x28307330, 0x2bc077c0, 0x2b507650, 0x2ae074e0,
    0x2a707570, 0x36005600, 0x36905790, 0x37205520, 0x37b054b0,
    0x34405040, 0x34d051d0, 0x35605360, 0x35f052f0, 0x32805a80,
    0x32105b10, 0x33a059a0, 0x33305830, 0x30c05cc0, 0x30505d50,
    0x31e05fe0, 0x31705e70, 0x3f004f00, 0x3f904e90, 0x3e204c20,
    0x3eb04db0, 0x3d404940, 0x3dd048d0, 0x3c604a60, 0x3cf04bf0,
    0x3b804380, 0x3b104210, 0x3aa040a0, 0x3a304130, 0x39c045c0,
    0x39504450, 0x38e046e0, 0x38704770, 0x4800c800, 0x4890c990,
    0x4920cb20, 0x49b0cab0, 0x4a40ce40, 0x4ad0cfd0, 0x4b60cd60,
    0x4bf0ccf0, 0x4c80c480, 0x4c10c510, 0x4da0c7a0, 0x4d30c630,
    0x4ec0c2c0, 0x4e50c350, 0x4fe0c1e0, 0x4f70c070, 0x4100d100,
    0x4190d090, 0x4020d220, 0x40b0d3b0, 0x4340d740, 0x43d0d6d0,
    0x4260d460, 0x42f0d5f0, 0x4580dd80, 0x4510dc10, 0x44a0dea0,
    0x4430df30, 0x47c0dbc0, 0x4750da50, 0x46e0d8e0, 0x4670d970,
    0x5a00fa00, 0x5a90fb90, 0x5b20f920, 0x5bb0f8b0, 0x5840fc40,
    0x58d0fdd0, 0x5960ff60, 0x59f0fef0, 0x5e80f680, 0x5e10f710,
    0x5fa0f5a0, 0x5f30f430, 0x5cc0f0c0, 0x5c50f150, 0x5de0f3e0,
    0x5d70f270, 0x5300e300, 0x5390e290, 0x5220e020, 0x52b0e1b0,
    0x5140e540, 0x51d0e4d0, 0x5060e660, 0x50f0e7f0, 0x5780ef80,
    0x5710ee10, 0x56a0eca0, 0x5630ed30, 0x55c0e9c0, 0x5550e850,
    0x54e0eae0, 0x5470eb70, 0x6c00ac00, 0x6c90ad90, 0x6d20af20,
    0x6db0aeb0, 0x6e40aa40, 0x6ed0abd0, 0x6f60a960, 0x6ff0a8f0,
    0x6880a080, 0x6810a110, 0x69a0a3a0, 0x6930a230, 0x6ac0a6c0,
    0x6a50a750, 0x6be0a5e0, 0x6b70a470, 0x6500b500, 0x6590b490,
    0x6420b620, 0x64b0b7b0, 0x6740b340, 0x67d0b2d0, 0x6660b060,
    0x66f0b1f0, 0x6180b980, 0x6110b810, 0x60a0baa0, 0x6030bb30,
    0x63c0bfc0, 0x6350be50, 0x62e0bce0, 0x6270bd70, 0x7e009e00,
    0x7e909f90, 0x7f209d20, 0x7fb09cb0, 0x7c409840, 0x7cd099d0,
    0x7d609b60, 0x7df09af0, 0x7a809280, 0x7a109310, 0x7ba091a0,
    0x7b309030, 0x78c094c0, 0x78509550, 0x79e097e0, 0x79709670,
    0x77008700, 0x77908690, 0x76208420, 0x76b085b0, 0x75408140,
    0x75d080d0, 0x74608260, 0x74f083f0, 0x73808b80, 0x73108a10,
    0x72a088a0, 0x72308930, 0x71c08dc0, 0x71508c50, 0x70e08ee0,
    0x70708f70},
   {0x00000000, 0x90019000, 0x90002003, 0x0001b003, 0x90034005,
    0x0002d005, 0x00036006, 0x9002f006, 0x90058009, 0x00041009,
    0x0005a00a, 0x9004300a, 0x0006c00c, 0x9007500c, 0x9006e00f,
    0x0007700f, 0x90080011, 0x00099011, 0x00082012, 0x9009b012,
    0x000b4014, 0x900ad014, 0x900b6017, 0x000af017, 0x000d8018,
    0x900c1018, 0x900da01b, 0x000c301b, 0x900ec01d, 0x000f501d,
    0x000ee01e, 0x900f701e, 0x90130021, 0x00129021, 0x00132022,
    0x9012b022, 0x00104024, 0x9011d024, 0x90106027, 0x0011f027,
    0x00168028, 0x90171028, 0x9016a02b, 0x0017302b, 0x9015c02d,
    0x0014502d, 0x0015e02e, 0x9014702e, 0x001b0030, 0x901a9030,
    0x901b2033, 0x001ab033, 0x90184035, 0x0019d035, 0x00186036,
    0x9019f036, 0x901e8039, 0x001f1039, 0x001ea03a, 0x901f303a,
    0x001dc03c, 0x901c503c, 0x901de03f, 0x001c703f, 0x90250041,
    0x00249041, 0x00252042, 0x9024b042, 0x00264044, 0x9027d044,
    0x90266047, 0x0027f047, 0x00208048, 0x90211048, 0x9020a04b,
    0x0021304b, 0x9023c04d, 0x0022504d, 0x0023e04e, 0x9022704e,
    0x002d0050, 0x902c9050, 0x902d2053, 0x002cb053, 0x902e4055,
    0x002fd055, 0x002e6056, 0x902ff056, 0x90288059, 0x00291059,
    0x0028a05a, 0x9029305a, 0x002bc05c, 0x902a505c, 0x902be05f,
    0x002a705f, 0x00360060, 0x90379060, 0x90362063, 0x0037b063,
    0x90354065, 0x0034d065, 0x00356066, 0x9034f066, 0x90338069,
    0x00321069, 0x0033a06a, 0x9032306a, 0x0030c06c, 0x9031506c,
    0x9030e06f, 0x0031706f, 0x903e0071, 0x003f9071, 0x003e2072,
    0x903fb072, 0x003d4074, 0x903cd074, 0x903d6077, 0x003cf077,
    0x003b8078, 0x903a1078, 0x903ba07b, 0x003a307b, 0x9038c07d,
    0x0039507d, 0x0038e07e, 0x9039707e, 0x90490081, 0x00489081,
    0x00492082, 0x9048b082, 0x004a4084, 0x904bd084, 0x904a6087,
    0x004bf087, 0x004c8088, 0x904d1088, 0x904ca08b, 0x004d308b,
    0x904fc08d, 0x004e508d, 0x004fe08e, 0x904e708e, 0x00410090,
    0x90409090, 0x90412093, 0x0040b093, 0x90424095, 0x0043d095,
    0x00426096, 0x9043f096, 0x90448099, 0x00451099, 0x0044a09a,
    0x9045309a, 0x0047c09c, 0x9046509c, 0x9047e09f, 0x0046709f,
    0x005a00a0, 0x905b90a0, 0x905a20a3, 0x005bb0a3, 0x905940a5,
    0x0058d0a5, 0x005960a6, 0x9058f0a6, 0x905f80a9, 0x005e10a9,
    0x005fa0aa, 0x905e30aa, 0x005cc0ac, 0x905d50ac, 0x905ce0af,
    0x005d70af, 0x905200b1, 0x005390b1, 0x005220b2, 0x9053b0b2,
    0x005140b4, 0x9050d0b4, 0x905160b7, 0x0050f0b7, 0x005780b8,
    0x905610b8, 0x9057a0bb, 0x005630bb, 0x9054c0bd, 0x005550bd,
    0x0054e0be, 0x905570be, 0x006c00c0, 0x906d90c0, 0x906c20c3,
    0x006db0c3, 0x906f40c5, 0x006ed0c5, 0x006f60c6, 0x906ef0c6,
    0x906980c9, 0x006810c9, 0x0069a0ca, 0x906830ca, 0x006ac0cc,
    0x906b50cc, 0x906ae0cf, 0x006b70cf, 0x906400d1, 0x006590d1,
    0x006420d2, 0x9065b0d2, 0x006740d4, 0x9066d0d4, 0x906760d7,
    0x0066f0d7, 0x006180d8, 0x906010d8, 0x9061a0db, 0x006030db,
    0x9062c0dd, 0x006350dd, 0x0062e0de, 0x906370de, 0x907f00e1,
    0x007e90e1, 0x007f20e2, 0x907eb0e2, 0x007c40e4, 0x907dd0e4,
    0x907c60e7, 0x007df0e7, 0x007a80e8, 0x907b10e8, 0x907aa0eb,
    0x007b30eb, 0x9079c0ed, 0x007850ed, 0x0079e0ee, 0x907870ee,
    0x007700f0, 0x907690f0, 0x907720f3, 0x0076b0f3, 0x907440f5,
    0x0075d0f5, 0x007460f6, 0x9075f0f6, 0x907280f9, 0x007310f9,
    0x0072a0fa, 0x907330fa, 0x0071c0fc, 0x907050fc, 0x9071e0ff,
    0x007070ff},
   {0x00000000, 0x90910101, 0x91210201, 0x01b00300, 0x92410401,
    0x02d00500, 0x03600600, 0x93f10701, 0x94810801, 0x04100900,
    0x05a00a00, 0x95310b01, 0x06c00c00, 0x96510d01, 0x97e10e01,
    0x07700f00, 0x99011001, 0x09901100, 0x08201200, 0x98b11301,
    0x0b401400, 0x9bd11501, 0x9a611601, 0x0af01700, 0x0d801800,
    0x9d111901, 0x9ca11a01, 0x0c301b00, 0x9fc11c01, 0x0f501d00,
    0x0ee01e00, 0x9e711f01, 0x82012001, 0x12902100, 0x13202200,
    0x83b12301, 0x10402400, 0x80d12501, 0x81612601, 0x11f02700,
    0x16802800, 0x86112901, 0x87a12a01, 0x17302b00, 0x84c12c01,
    0x14502d00, 0x15e02e00, 0x85712f01, 0x1b003000, 0x8b913101,
    0x8a213201, 0x1ab03300, 0x89413401, 0x19d03500, 0x18603600,
    0x88f13701, 0x8f813801, 0x1f103900, 0x1ea03a00, 0x8e313b01,
    0x1dc03c00, 0x8d513d01, 0x8ce13e01, 0x1c703f00, 0xb4014001,
    0x24904100, 0x25204200, 0xb5b14301, 0x26404400, 0xb6d14501,
    0xb7614601, 0x27f04700, 0x20804800, 0xb0114901, 0xb1a14a01,
    0x21304b00, 0xb2c14c01, 0x22504d00, 0x23e04e00, 0xb3714f01,
    0x2d005000, 0xbd915101, 0xbc215201, 0x2cb05300, 0xbf415401,
    0x2fd05500, 0x2e605600, 0xbef15701, 0xb9815801, 0x29105900,
    0x28a05a00, 0xb8315b01, 0x2bc05c00, 0xbb515d01, 0xbae15e01,
    0x2a705f00, 0x36006000, 0xa6916101, 0xa7216201, 0x37b06300,
    0xa4416401, 0x34d06500, 0x35606600, 0xa5f16701, 0xa2816801,
    0x32106900, 0x33a06a00, 0xa3316b01, 0x30c06c00, 0xa0516d01,
    0xa1e16e01, 0x31706f00, 0xaf017001, 0x3f907100, 0x3e207200,
    0xaeb17301, 0x3d407400, 0xadd17501, 0xac617601, 0x3cf07700,
    0x3b807800, 0xab117901, 0xaaa17a01, 0x3a307b00, 0xa9c17c01,
    0x39507d00, 0x38e07e00, 0xa8717f01, 0xd8018001, 0x48908100,
    0x49208200, 0xd9b18301, 0x4a408400, 0xdad18501, 0xdb618601,
    0x4bf08700, 0x4c808800, 0xdc118901, 0xdda18a01, 0x4d308b00,
    0xdec18c01, 0x4e508d00, 0x4fe08e00, 0xdf718f01, 0x41009000,
    0xd1919101, 0xd0219201, 0x40b09300, 0xd3419401, 0x43d09500,
    0x42609600, 0xd2f19701, 0xd5819801, 0x45109900, 0x44a09a00,
    0xd4319b01, 0x47c09c00, 0xd7519d01, 0xd6e19e01, 0x46709f00,
    0x5a00a000, 0xca91a101, 0xcb21a201, 0x5bb0a300, 0xc841a401,
    0x58d0a500, 0x5960a600, 0xc9f1a701, 0xce81a801, 0x5e10a900,
    0x5fa0aa00, 0xcf31ab01, 0x5cc0ac00, 0xcc51ad01, 0xcde1ae01,
    0x5d70af00, 0xc301b001, 0x5390b100, 0x5220b200, 0xc2b1b301,
    0x5140b400, 0xc1d1b501, 0xc061b601, 0x50f0b700, 0x5780b800,
    0xc711b901, 0xc6a1ba01, 0x5630bb00, 0xc5c1bc01, 0x5550bd00,
    0x54e0be00, 0xc471bf01, 0x6c00c000, 0xfc91c101, 0xfd21c201,
    0x6db0c300, 0xfe41c401, 0x6ed0c500, 0x6f60c600, 0xfff1c701,
    0xf881c801, 0x6810c900, 0x69a0ca00, 0xf931cb01, 0x6ac0cc00,
    0xfa51cd01, 0xfbe1ce01, 0x6b70cf00, 0xf501d001, 0x6590d100,
    0x6420d200, 0xf4b1d301, 0x6740d400, 0xf7d1d501, 0xf661d601,
    0x66f0d700, 0x6180d800, 0xf111d901, 0xf0a1da01, 0x6030db00,
    0xf3c1dc01, 0x6350dd00, 0x62e0de00, 0xf271df01, 0xee01e001,
    0x7e90e100, 0x7f20e200, 0xefb1e301, 0x7c40e400, 0xecd1e501,
    0xed61e601, 0x7df0e700, 0x7a80e800, 0xea11e901, 0xeba1ea01,
    0x7b30eb00, 0xe8c1ec01, 0x7850ed00, 0x79e0ee00, 0xe971ef01,
    0x7700f000, 0xe791f101, 0xe621f201, 0x76b0f300, 0xe541f401,
    0x75d0f500, 0x7460f600, 0xe4f1f701, 0xe381f801, 0x7310f900,
    0x72a0fa00, 0xe231fb01, 0x71c0fc00, 0xe151fd01, 0xe0e1fe01,
    0x7070ff00}};

static const word_t crc_braid_big_table[][256] = {
   {0x00000000, 0x01019190, 0x01022191, 0x0003b001, 0x01044192,
    0x0005d002, 0x00066003, 0x0107f193, 0x01088194, 0x00091004,
    0x000aa005, 0x010b3195, 0x000cc006, 0x010d5196, 0x010ee197,
    0x000f7007, 0x01100199, 0x00119009, 0x00122008, 0x0113b198,
    0x0014400b, 0x0115d19b, 0x0116619a, 0x0017f00a, 0x0018800d,
    0x0119119d, 0x011aa19c, 0x001b300c, 0x011cc19f, 0x001d500f,
    0x001ee00e, 0x011f719e, 0x01200182, 0x00219012, 0x00222013,
    0x0123b183, 0x00244010, 0x0125d180, 0x01266181, 0x0027f011,
    0x00288016, 0x01291186, 0x012aa187, 0x002b3017, 0x012cc184,
    0x002d5014, 0x002ee015, 0x012f7185, 0x0030001b, 0x0131918b,
    0x0132218a, 0x0033b01a, 0x01344189, 0x0035d019, 0x00366018,
    0x0137f188, 0x0138818f, 0x0039101f, 0x003aa01e, 0x013b318e,
    0x003cc01d, 0x013d518d, 0x013ee18c, 0x003f701c, 0x014001b4,
    0x00419024, 0x00422025, 0x0143b1b5, 0x00444026, 0x0145d1b6,
    0x014661b7, 0x0047f027, 0x00488020, 0x014911b0, 0x014aa1b1,
    0x004b3021, 0x014cc1b2, 0x004d5022, 0x004ee023, 0x014f71b3,
    0x0050002d, 0x015191bd, 0x015221bc, 0x0053b02c, 0x015441bf,
    0x0055d02f, 0x0056602e, 0x0157f1be, 0x015881b9, 0x00591029,
    0x005aa028, 0x015b31b8, 0x005cc02b, 0x015d51bb, 0x015ee1ba,
    0x005f702a, 0x00600036, 0x016191a6, 0x016221a7, 0x0063b037,
    0x016441a4, 0x0065d034, 0x00666035, 0x0167f1a5, 0x016881a2,
    0x00691032, 0x006aa033, 0x016b31a3, 0x006cc030, 0x016d51a0,
    0x016ee1a1, 0x006f7031, 0x017001af, 0x0071903f, 0x0072203e,
    0x0173b1ae, 0x0074403d, 0x0175d1ad, 0x017661ac, 0x0077f03c,
    0x0078803b, 0x017911ab, 0x017aa1aa, 0x007b303a, 0x017cc1a9,
    0x007d5039, 0x007ee038, 0x017f71a8, 0x018001d8, 0x00819048,
    0x00822049, 0x0183b1d9, 0x0084404a, 0x0185d1da, 0x018661db,
    0x0087f04b, 0x0088804c, 0x018911dc, 0x018aa1dd, 0x008b304d,
    0x018cc1de, 0x008d504e, 0x008ee04f, 0x018f71df, 0x00900041,
    0x019191d1, 0x019221d0, 0x0093b040, 0x019441d3, 0x0095d043,
    0x00966042, 0x0197f1d2, 0x019881d5, 0x00991045, 0x009aa044,
    0x019b31d4, 0x009cc047, 0x019d51d7, 0x019ee1d6, 0x009f7046,
    0x00a0005a, 0x01a191ca, 0x01a221cb, 0x00a3b05b, 0x01a441c8,
    0x00a5d058, 0x00a66059, 0x01a7f1c9, 0x01a881ce, 0x00a9105e,
    0x00aaa05f, 0x01ab31cf, 0x00acc05c, 0x01ad51cc, 0x01aee1cd,
    0x00af705d, 0x01b001c3, 0x00b19053, 0x00b22052, 0x01b3b1c2,
    0x00b44051, 0x01b5d1c1, 0x01b661c0, 0x00b7f050, 0x00b88057,
    0x01b911c7, 0x01baa1c6, 0x00bb3056, 0x01bcc1c5, 0x00bd5055,
    0x00bee054, 0x01bf71c4, 0x00c0006c, 0x01c191fc, 0x01c221fd,
    0x00c3b06d, 0x01c441fe, 0x00c5d06e, 0x00c6606f, 0x01c7f1ff,
    0x01c881f8, 0x00c91068, 0x00caa069, 0x01cb31f9, 0x00ccc06a,
    0x01cd51fa, 0x01cee1fb, 0x00cf706b, 0x01d001f5, 0x00d19065,
    0x00d22064, 0x01d3b1f4, 0x00d44067, 0x01d5d1f7, 0x01d661f6,
    0x00d7f066, 0x00d88061, 0x01d911f1, 0x01daa1f0, 0x00db3060,
    0x01dcc1f3, 0x00dd5063, 0x00dee062, 0x01df71f2, 0x01e001ee,
    0x00e1907e, 0x00e2207f, 0x01e3b1ef, 0x00e4407c, 0x01e5d1ec,
    0x01e661ed, 0x00e7f07d, 0x00e8807a, 0x01e911ea, 0x01eaa1eb,
    0x00eb307b, 0x01ecc1e8, 0x00ed5078, 0x00eee079, 0x01ef71e9,
    0x00f00077, 0x01f191e7, 0x01f221e6, 0x00f3b076, 0x01f441e5,
    0x00f5d075, 0x00f66074, 0x01f7f1e4, 0x01f881e3, 0x00f91073,
    0x00faa072, 0x01fb31e2, 0x00fcc071, 0x01fd51e1, 0x01fee1e0,
    0x00ff7070},
   {0x00000000, 0x00900190, 0x03200090, 0x03b00100, 0x05400390,
    0x05d00200, 0x06600300, 0x06f00290, 0x09800590, 0x09100400,
    0x0aa00500, 0x0a300490, 0x0cc00600, 0x0c500790, 0x0fe00690,
    0x0f700700, 0x11000890, 0x11900900, 0x12200800, 0x12b00990,
    0x14400b00, 0x14d00a90, 0x17600b90, 0x17f00a00, 0x18800d00,
    0x18100c90, 0x1ba00d90, 0x1b300c00, 0x1dc00e90, 0x1d500f00,
    0x1ee00e00, 0x1e700f90, 0x21001390, 0x21901200, 0x22201300,
    0x22b01290, 0x24401000, 0x24d01190, 0x27601090, 0x27f01100,
    0x28801600, 0x28101790, 0x2ba01690, 0x2b301700, 0x2dc01590,
    0x2d501400, 0x2ee01500, 0x2e701490, 0x30001b00, 0x30901a90,
    0x33201b90, 0x33b01a00, 0x35401890, 0x35d01900, 0x36601800,
    0x36f01990, 0x39801e90, 0x39101f00, 0x3aa01e00, 0x3a301f90,
    0x3cc01d00, 0x3c501c90, 0x3fe01d90, 0x3f701c00, 0x41002590,
    0x41902400, 0x42202500, 0x42b02490, 0x44402600, 0x44d02790,
    0x47602690, 0x47f02700, 0x48802000, 0x48102190, 0x4ba02090,
    0x4b302100, 0x4dc02390, 0x4d502200, 0x4ee02300, 0x4e702290,
    0x50002d00, 0x50902c90, 0x53202d90, 0x53b02c00, 0x55402e90,
    0x55d02f00, 0x56602e00, 0x56f02f90, 0x59802890, 0x59102900,
    0x5aa02800, 0x5a302990, 0x5cc02b00, 0x5c502a90, 0x5fe02b90,
    0x5f702a00, 0x60003600, 0x60903790, 0x63203690, 0x63b03700,
    0x65403590, 0x65d03400, 0x66603500, 0x66f03490, 0x69803390,
    0x69103200, 0x6aa03300, 0x6a303290, 0x6cc03000, 0x6c503190,
    0x6fe03090, 0x6f703100, 0x71003e90, 0x71903f00, 0x72203e00,
    0x72b03f90, 0x74403d00, 0x74d03c90, 0x77603d90, 0x77f03c00,
    0x78803b00, 0x78103a90, 0x7ba03b90, 0x7b303a00, 0x7dc03890,
    0x7d503900, 0x7ee03800, 0x7e703990, 0x81004990, 0x81904800,
    0x82204900, 0x82b04890, 0x84404a00, 0x84d04b90, 0x87604a90,
    0x87f04b00, 0x88804c00, 0x88104d90, 0x8ba04c90, 0x8b304d00,
    0x8dc04f90, 0x8d504e00, 0x8ee04f00, 0x8e704e90, 0x90004100,
    0x90904090, 0x93204190, 0x93b04000, 0x95404290, 0x95d04300,
    0x96604200, 0x96f04390, 0x99804490, 0x99104500, 0x9aa04400,
    0x9a304590, 0x9cc04700, 0x9c504690, 0x9fe04790, 0x9f704600,
    0xa0005a00, 0xa0905b90, 0xa3205a90, 0xa3b05b00, 0xa5405990,
    0xa5d05800, 0xa6605900, 0xa6f05890, 0xa9805f90, 0xa9105e00,
    0xaaa05f00, 0xaa305e90, 0xacc05c00, 0xac505d90, 0xafe05c90,
    0xaf705d00, 0xb1005290, 0xb1905300, 0xb2205200, 0xb2b05390,
    0xb4405100, 0xb4d05090, 0xb7605190, 0xb7f05000, 0xb8805700,
    0xb8105690, 0xbba05790, 0xbb305600, 0xbdc05490, 0xbd505500,
    0xbee05400, 0xbe705590, 0xc0006c00, 0xc0906d90, 0xc3206c90,
    0xc3b06d00, 0xc5406f90, 0xc5d06e00, 0xc6606f00, 0xc6f06e90,
    0xc9806990, 0xc9106800, 0xcaa06900, 0xca306890, 0xccc06a00,
    0xcc506b90, 0xcfe06a90, 0xcf706b00, 0xd1006490, 0xd1906500,
    0xd2206400, 0xd2b06590, 0xd4406700, 0xd4d06690, 0xd7606790,
    0xd7f06600, 0xd8806100, 0xd8106090, 0xdba06190, 0xdb306000,
    0xddc06290, 0xdd506300, 0xdee06200, 0xde706390, 0xe1007f90,
    0xe1907e00, 0xe2207f00, 0xe2b07e90, 0xe4407c00, 0xe4d07d90,
    0xe7607c90, 0xe7f07d00, 0xe8807a00, 0xe8107b90, 0xeba07a90,
    0xeb307b00, 0xedc07990, 0xed507800, 0xeee07900, 0xee707890,
    0xf0007700, 0xf0907690, 0xf3207790, 0xf3b07600, 0xf5407490,
    0xf5d07500, 0xf6607400, 0xf6f07590, 0xf9807290, 0xf9107300,
    0xfaa07200, 0xfa307390, 0xfcc07100, 0xfc507090, 0xffe07190,
    0xff707000},
   {0x00000000, 0x90019000, 0x20032001, 0xb002b001, 0x40064002,
    0xd007d002, 0x60056003, 0xf004f003, 0x800c8004, 0x100d1004,
    0xa00fa005, 0x300e3005, 0xc00ac006, 0x500b5006, 0xe009e007,
    0x70087007, 0x00190009, 0x90189009, 0x201a2008, 0xb01bb008,
    0x401f400b, 0xd01ed00b, 0x601c600a, 0xf01df00a, 0x8015800d,
    0x1014100d, 0xa016a00c, 0x3017300c, 0xc013c00f, 0x5012500f,
    0xe010e00e, 0x7011700e, 0x00320012, 0x90339012, 0x20312013,
    0xb030b013, 0x40344010, 0xd035d010, 0x60376011, 0xf036f011,
    0x803e8016, 0x103f1016, 0xa03da017, 0x303c3017, 0xc038c014,
    0x50395014, 0xe03be015, 0x703a7015, 0x002b001b, 0x902a901b,
    0x2028201a, 0xb029b01a, 0x402d4019, 0xd02cd019, 0x602e6018,
    0xf02ff018, 0x8027801f, 0x1026101f, 0xa024a01e, 0x3025301e,
    0xc021c01d, 0x5020501d, 0xe022e01c, 0x7023701c, 0x00640024,
    0x90659024, 0x20672025, 0xb066b025, 0x40624026, 0xd063d026,
    0x60616027, 0xf060f027, 0x80688020, 0x10691020, 0xa06ba021,
    0x306a3021, 0xc06ec022, 0x506f5022, 0xe06de023, 0x706c7023,
    0x007d002d, 0x907c902d, 0x207e202c, 0xb07fb02c, 0x407b402f,
    0xd07ad02f, 0x6078602e, 0xf079f02e, 0x80718029, 0x10701029,
    0xa072a028, 0x30733028, 0xc077c02b, 0x5076502b, 0xe074e02a,
    0x7075702a, 0x00560036, 0x90579036, 0x20552037, 0xb054b037,
    0x40504034, 0xd051d034, 0x60536035, 0xf052f035, 0x805a8032,
    0x105b1032, 0xa059a033, 0x30583033, 0xc05cc030, 0x505d5030,
    0xe05fe031, 0x705e7031, 0x004f003f, 0x904e903f, 0x204c203e,
    0xb04db03e, 0x4049403d, 0xd048d03d, 0x604a603c, 0xf04bf03c,
    0x8043803b, 0x1042103b, 0xa040a03a, 0x3041303a, 0xc045c039,
    0x50445039, 0xe046e038, 0x70477038, 0x00c80048, 0x90c99048,
    0x20cb2049, 0xb0cab049, 0x40ce404a, 0xd0cfd04a, 0x60cd604b,
    0xf0ccf04b, 0x80c4804c, 0x10c5104c, 0xa0c7a04d, 0x30c6304d,
    0xc0c2c04e, 0x50c3504e, 0xe0c1e04f, 0x70c0704f, 0x00d10041,
    0x90d09041, 0x20d22040, 0xb0d3b040, 0x40d74043, 0xd0d6d043,
    0x60d46042, 0xf0d5f042, 0x80dd8045, 0x10dc1045, 0xa0dea044,
    0x30df3044, 0xc0dbc047, 0x50da5047, 0xe0d8e046, 0x70d97046,
    0x00fa005a, 0x90fb905a, 0x20f9205b, 0xb0f8b05b, 0x40fc4058,
    0xd0fdd058, 0x60ff6059, 0xf0fef059, 0x80f6805e, 0x10f7105e,
    0xa0f5a05f, 0x30f4305f, 0xc0f0c05c, 0x50f1505c, 0xe0f3e05d,
    0x70f2705d, 0x00e30053, 0x90e29053, 0x20e02052, 0xb0e1b052,
    0x40e54051, 0xd0e4d051, 0x60e66050, 0xf0e7f050, 0x80ef8057,
    0x10ee1057, 0xa0eca056, 0x30ed3056, 0xc0e9c055, 0x50e85055,
    0xe0eae054, 0x70eb7054, 0x00ac006c, 0x90ad906c, 0x20af206d,
    0xb0aeb06d, 0x40aa406e, 0xd0abd06e, 0x60a9606f, 0xf0a8f06f,
    0x80a08068, 0x10a11068, 0xa0a3a069, 0x30a23069, 0xc0a6c06a,
    0x50a7506a, 0xe0a5e06b, 0x70a4706b, 0x00b50065, 0x90b49065,
    0x20b62064, 0xb0b7b064, 0x40b34067, 0xd0b2d067, 0x60b06066,
    0xf0b1f066, 0x80b98061, 0x10b81061, 0xa0baa060, 0x30bb3060,
    0xc0bfc063, 0x50be5063, 0xe0bce062, 0x70bd7062, 0x009e007e,
    0x909f907e, 0x209d207f, 0xb09cb07f, 0x4098407c, 0xd099d07c,
    0x609b607d, 0xf09af07d, 0x8092807a, 0x1093107a, 0xa091a07b,
    0x3090307b, 0xc094c078, 0x50955078, 0xe097e079, 0x70967079,
    0x00870077, 0x90869077, 0x20842076, 0xb085b076, 0x40814075,
    0xd080d075, 0x60826074, 0xf083f074, 0x808b8073, 0x108a1073,
    0xa088a072, 0x30893072, 0xc08dc071, 0x508c5071, 0xe08ee070,
    0x708f7070},
   {0x00000000, 0x01000041, 0x02000082, 0x030000c3, 0x070003b4,
    0x060003f5, 0x05000336, 0x04000377, 0x0d0005d8, 0x0c000599,
    0x0f00055a, 0x0e00051b, 0x0a00066c, 0x0b00062d, 0x080006ee,
    0x090006af, 0x19000900, 0x18000941, 0x1b000982, 0x1a0009c3,
    0x1e000ab4, 0x1f000af5, 0x1c000a36, 0x1d000a77, 0x14000cd8,
    0x15000c99, 0x16000c5a, 0x17000c1b, 0x13000f6c, 0x12000f2d,
    0x11000fee, 0x10000faf, 0x32001200, 0x33001241, 0x30001282,
    0x310012c3, 0x350011b4, 0x340011f5, 0x37001136, 0x36001177,
    0x3f0017d8, 0x3e001799, 0x3d00175a, 0x3c00171b, 0x3800146c,
    0x3900142d, 0x3a0014ee, 0x3b0014af, 0x2b001b00, 0x2a001b41,
    0x29001b82, 0x28001bc3, 0x2c0018b4, 0x2d0018f5, 0x2e001836,
    0x2f001877, 0x26001ed8, 0x27001e99, 0x24001e5a, 0x25001e1b,
    0x21001d6c, 0x20001d2d, 0x23001dee, 0x22001daf, 0x64002400,
    0x65002441, 0x66002482, 0x670024c3, 0x630027b4, 0x620027f5,
    0x61002736, 0x60002777, 0x690021d8, 0x68002199, 0x6b00215a,
    0x6a00211b, 0x6e00226c, 0x6f00222d, 0x6c0022ee, 0x6d0022af,
    0x7d002d00, 0x7c002d41, 0x7f002d82, 0x7e002dc3, 0x7a002eb4,
    0x7b002ef5, 0x78002e36, 0x79002e77, 0x700028d8, 0x71002899,
    0x7200285a, 0x7300281b, 0x77002b6c, 0x76002b2d, 0x75002bee,
    0x74002baf, 0x56003600, 0x57003641, 0x54003682, 0x550036c3,
    0x510035b4, 0x500035f5, 0x53003536, 0x52003577, 0x5b0033d8,
    0x5a003399, 0x5900335a, 0x5800331b, 0x5c00306c, 0x5d00302d,
    0x5e0030ee, 0x5f0030af, 0x4f003f00, 0x4e003f41, 0x4d003f82,
    0x4c003fc3, 0x48003cb4, 0x49003cf5, 0x4a003c36, 0x4b003c77,
    0x42003ad8, 0x43003a99, 0x40003a5a, 0x41003a1b, 0x4500396c,
    0x4400392d, 0x470039ee, 0x460039af, 0xc8004800, 0xc9004841,
    0xca004882, 0xcb0048c3, 0xcf004bb4, 0xce004bf5, 0xcd004b36,
    0xcc004b77, 0xc5004dd8, 0xc4004d99, 0xc7004d5a, 0xc6004d1b,
    0xc2004e6c, 0xc3004e2d, 0xc0004eee, 0xc1004eaf, 0xd1004100,
    0xd0004141, 0xd3004182, 0xd20041c3, 0xd60042b4, 0xd70042f5,
    0xd4004236, 0xd5004277, 0xdc0044d8, 0xdd004499, 0xde00445a,
    0xdf00441b, 0xdb00476c, 0xda00472d, 0xd90047ee, 0xd80047af,
    0xfa005a00, 0xfb005a41, 0xf8005a82, 0xf9005ac3, 0xfd0059b4,
    0xfc0059f5, 0xff005936, 0xfe005977, 0xf7005fd8, 0xf6005f99,
    0xf5005f5a, 0xf4005f1b, 0xf0005c6c, 0xf1005c2d, 0xf2005cee,
    0xf3005caf, 0xe3005300, 0xe2005341, 0xe1005382, 0xe00053c3,
    0xe40050b4, 0xe50050f5, 0xe6005036, 0xe7005077, 0xee0056d8,
    0xef005699, 0xec00565a, 0xed00561b, 0xe900556c, 0xe800552d,
    0xeb0055ee, 0xea0055af, 0xac006c00, 0xad006c41, 0xae006c82,
    0xaf006cc3, 0xab006fb4, 0xaa006ff5, 0xa9006f36, 0xa8006f77,
    0xa10069d8, 0xa0006999, 0xa300695a, 0xa200691b, 0xa6006a6c,
    0xa7006a2d, 0xa4006aee, 0xa5006aaf, 0xb5006500, 0xb4006541,
    0xb7006582, 0xb60065c3, 0xb20066b4, 0xb30066f5, 0xb0006636,
    0xb1006677, 0xb80060d8, 0xb9006099, 0xba00605a, 0xbb00601b,
    0xbf00636c, 0xbe00632d, 0xbd0063ee, 0xbc0063af, 0x9e007e00,
    0x9f007e41, 0x9c007e82, 0x9d007ec3, 0x99007db4, 0x98007df5,
    0x9b007d36, 0x9a007d77, 0x93007bd8, 0x92007b99, 0x91007b5a,
    0x90007b1b, 0x9400786c, 0x9500782d, 0x960078ee, 0x970078af,
    0x87007700, 0x86007741, 0x85007782, 0x840077c3, 0x800074b4,
    0x810074f5, 0x82007436, 0x83007477, 0x8a0072d8, 0x8b007299,
    0x8800725a, 0x8900721b, 0x8d00716c, 0x8c00712d, 0x8f0071ee,
    0x8e0071af}};

#endif

#endif

#if N == 2

#if W == 8

static const crc_t crc_braid_table[][256] = {
   {0x00000000, 0x6c90c100, 0xd9218200, 0xb5b14300, 0x02400403,
    0x6ed0c503, 0xdb618603, 0xb7f14703, 0x04800806, 0x6810c906,
    0xdda18a06, 0xb1314b06, 0x06c00c05, 0x6a50cd05, 0xdfe18e05,
    0xb3714f05, 0x0900100c, 0x6590d10c, 0xd021920c, 0xbcb1530c,
    0x0b40140f, 0x67d0d50f, 0xd261960f, 0xbef1570f, 0x0d80180a,
    0x6110d90a, 0xd4a19a0a, 0xb8315b0a, 0x0fc01c09, 0x6350dd09,
    0xd6e19e09, 0xba715f09, 0x12002018, 0x7e90e118, 0xcb21a218,
    0xa7b16318, 0x1040241b, 0x7cd0e51b, 0xc961a61b, 0xa5f1671b,
    0x1680281e, 0x7a10e91e, 0xcfa1aa1e, 0xa3316b1e, 0x14c02c1d,
    0x7850ed1d, 0xcde1ae1d, 0xa1716f1d, 0x1b003014, 0x7790f114,
    0xc221b214, 0xaeb17314, 0x19403417, 0x75d0f517, 0xc061b617,
    0xacf17717, 0x1f803812, 0x7310f912, 0xc6a1ba12, 0xaa317b12,
    0x1dc03c11, 0x7150fd11, 0xc4e1be11, 0xa8717f11, 0x24004030,
    0x48908130, 0xfd21c230, 0x91b10330, 0x26404433, 0x4ad08533,
    0xff61c633, 0x93f10733, 0x20804836, 0x4c108936, 0xf9a1ca36,
    0x95310b36, 0x22c04c35, 0x4e508d35, 0xfbe1ce35, 0x97710f35,
    0x2d00503c, 0x4190913c, 0xf421d23c, 0x98b1133c, 0x2f40543f,
    0x43d0953f, 0xf661d63f, 0x9af1173f, 0x2980583a, 0x4510993a,
    0xf0a1da3a, 0x9c311b3a, 0x2bc05c39, 0x47509d39, 0xf2e1de39,
    0x9e711f39, 0x36006028, 0x5a90a128, 0xef21e228, 0x83b12328,
    0x3440642b, 0x58d0a52b, 0xed61e62b, 0x81f1272b, 0x3280682e,
    0x5e10a92e, 0xeba1ea2e, 0x87312b2e, 0x30c06c2d, 0x5c50ad2d,
    0xe9e1ee2d, 0x85712f2d, 0x3f007024, 0x5390b124, 0xe621f224,
    0x8ab13324, 0x3d407427, 0x51d0b527, 0xe461f627, 0x88f13727,
    0x3b807822, 0x5710b922, 0xe2a1fa22, 0x8e313b22, 0x39c07c21,
    0x5550bd21, 0xe0e1fe21, 0x8c713f21, 0x48008060, 0x24904160,
    0x91210260, 0xfdb1c360, 0x4a408463, 0x26d04563, 0x93610663,
    0xfff1c763, 0x4c808866, 0x20104966, 0x95a10a66, 0xf931cb66,
    0x4ec08c65, 0x22504d65, 0x97e10e65, 0xfb71cf65, 0x4100906c,
    0x2d90516c, 0x9821126c, 0xf4b1d36c, 0x4340946f, 0x2fd0556f,
    0x9a61166f, 0xf6f1d76f, 0x4580986a, 0x2910596a, 0x9ca11a6a,
    0xf031db6a, 0x47c09c69, 0x2b505d69, 0x9ee11e69, 0xf271df69,
    0x5a00a078, 0x36906178, 0x83212278, 0xefb1e378, 0x5840a47b,
    0x34d0657b, 0x8161267b, 0xedf1e77b, 0x5e80a87e, 0x3210697e,
    0x87a12a7e, 0xeb31eb7e, 0x5cc0ac7d, 0x30506d7d, 0x85e12e7d,
    0xe971ef7d, 0x5300b074, 0x3f907174, 0x8a213274, 0xe6b1f374,
    0x5140b477, 0x3dd07577, 0x88613677, 0xe4f1f777, 0x5780b872,
    0x3b107972, 0x8ea13a72, 0xe231fb72, 0x55c0bc71, 0x39507d71,
    0x8ce13e71, 0xe071ff71, 0x6c00c050, 0x00900150, 0xb5214250,
    0xd9b18350, 0x6e40c453, 0x02d00553, 0xb7614653, 0xdbf18753,
    0x6880c856, 0x04100956, 0xb1a14a56, 0xdd318b56, 0x6ac0cc55,
    0x06500d55, 0xb3e14e55, 0xdf718f55, 0x6500d05c, 0x0990115c,
    0xbc21525c, 0xd0b1935c, 0x6740d45f, 0x0bd0155f, 0xbe61565f,
    0xd2f1975f, 0x6180d85a, 0x0d10195a, 0xb8a15a5a, 0xd4319b5a,
    0x63c0dc59, 0x0f501d59, 0xbae15e59, 0xd6719f59, 0x7e00e048,
    0x12902148, 0xa7216248, 0xcbb1a348, 0x7c40e44b, 0x10d0254b,
    0xa561664b, 0xc9f1a74b, 0x7a80e84e, 0x1610294e, 0xa3a16a4e,
    0xcf31ab4e, 0x78c0ec4d, 0x14502d4d, 0xa1e16e4d, 0xcd71af4d,
    0x7700f044, 0x1b903144, 0xae217244, 0xc2b1b344, 0x7540f447,
    0x19d03547, 0xac617647, 0xc0f1b747, 0x7380f842, 0x1f103942,
    0xaaa17a42, 0xc631bb42, 0x71c0fc41, 0x1d503d41, 0xa8e17e41,
    0xc471bf41},
   {0x00000000, 0x900100c0, 0x90010183, 0x00000143, 0x90010305,
    0x000003c5, 0x00000286, 0x90010246, 0x90010609, 0x000006c9,
    0x0000078a, 0x9001074a, 0x0000050c, 0x900105cc, 0x9001048f,
    0x0000044f, 0x90010c11, 0x00000cd1, 0x00000d92, 0x90010d52,
    0x00000f14, 0x90010fd4, 0x90010e97, 0x00000e57, 0x00000a18,
    0x90010ad8, 0x90010b9b, 0x00000b5b, 0x9001091d, 0x000009dd,
    0x0000089e, 0x9001085e, 0x90011821, 0x000018e1, 0x000019a2,
    0x90011962, 0x00001b24, 0x90011be4, 0x90011aa7, 0x00001a67,
    0x00001e28, 0x90011ee8, 0x90011fab, 0x00001f6b, 0x90011d2d,
    0x00001ded, 0x00001cae, 0x90011c6e, 0x00001430, 0x900114f0,
    0x900115b3, 0x00001573, 0x90011735, 0x000017f5, 0x000016b6,
    0x90011676, 0x90011239, 0x000012f9, 0x000013ba, 0x9001137a,
    0x0000113c, 0x900111fc, 0x900110bf, 0x0000107f, 0x90013041,
    0x00003081, 0x000031c2, 0x90013102, 0x00003344, 0x90013384,
    0x900132c7, 0x00003207, 0x00003648, 0x90013688, 0x900137cb,
    0x0000370b, 0x9001354d, 0x0000358d, 0x000034ce, 0x9001340e,
    0x00003c50, 0x90013c90, 0x90013dd3, 0x00003d13, 0x90013f55,
    0x00003f95, 0x00003ed6, 0x90013e16, 0x90013a59, 0x00003a99,
    0x00003bda, 0x90013b1a, 0x0000395c, 0x9001399c, 0x900138df,
    0x0000381f, 0x00002860, 0x900128a0, 0x900129e3, 0x00002923,
    0x90012b65, 0x00002ba5, 0x00002ae6, 0x90012a26, 0x90012e69,
    0x00002ea9, 0x00002fea, 0x90012f2a, 0x00002d6c, 0x90012dac,
    0x90012cef, 0x00002c2f, 0x90012471, 0x000024b1, 0x000025f2,
    0x90012532, 0x00002774, 0x900127b4, 0x900126f7, 0x00002637,
    0x00002278, 0x900122b8, 0x900123fb, 0x0000233b, 0x9001217d,
    0x000021bd, 0x000020fe, 0x9001203e, 0x90016081, 0x00006041,
    0x00006102, 0x900161c2, 0x00006384, 0x90016344, 0x90016207,
    0x000062c7, 0x00006688, 0x90016648, 0x9001670b, 0x000067cb,
    0x9001658d, 0x0000654d, 0x0000640e, 0x900164ce, 0x00006c90,
    0x90016c50, 0x90016d13, 0x00006dd3, 0x90016f95, 0x00006f55,
    0x00006e16, 0x90016ed6, 0x90016a99, 0x00006a59, 0x00006b1a,
    0x90016bda, 0x0000699c, 0x9001695c, 0x9001681f, 0x000068df,
    0x000078a0, 0x90017860, 0x90017923, 0x000079e3, 0x90017ba5,
    0x00007b65, 0x00007a26, 0x90017ae6, 0x90017ea9, 0x00007e69,
    0x00007f2a, 0x90017fea, 0x00007dac, 0x90017d6c, 0x90017c2f,
    0x00007cef, 0x900174b1, 0x00007471, 0x00007532, 0x900175f2,
    0x000077b4, 0x90017774, 0x90017637, 0x000076f7, 0x000072b8,
    0x90017278, 0x9001733b, 0x000073fb, 0x900171bd, 0x0000717d,
    0x0000703e, 0x900170fe, 0x000050c0, 0x90015000, 0x90015143,
    0x00005183, 0x900153c5, 0x00005305, 0x00005246, 0x90015286,
    0x900156c9, 0x00005609, 0x0000574a, 0x9001578a, 0x000055cc,
    0x9001550c, 0x9001544f, 0x0000548f, 0x90015cd1, 0x00005c11,
    0x00005d52, 0x90015d92, 0x00005fd4, 0x90015f14, 0x90015e57,
    0x00005e97, 0x00005ad8, 0x90015a18, 0x90015b5b, 0x00005b9b,
    0x900159dd, 0x0000591d, 0x0000585e, 0x9001589e, 0x900148e1,
    0x00004821, 0x00004962, 0x900149a2, 0x00004be4, 0x90014b24,
    0x90014a67, 0x00004aa7, 0x00004ee8, 0x90014e28, 0x90014f6b,
    0x00004fab, 0x90014ded, 0x00004d2d, 0x00004c6e, 0x90014cae,
    0x000044f0, 0x90014430, 0x90014573, 0x000045b3, 0x900147f5,
    0x00004735, 0x00004676, 0x900146b6, 0x900142f9, 0x00004239,
    0x0000437a, 0x900143ba, 0x000041fc, 0x9001413c, 0x9001407f,
    0x000040bf},
   {0x00000000, 0x9001c101, 0x90008201, 0x00014300, 0x90020401,
    0x0003c500, 0x00028600, 0x90034701, 0x90070801, 0x0006c900,
    0x00078a00, 0x90064b01, 0x00050c00, 0x9004cd01, 0x90058e01,
    0x00044f00, 0x900d1001, 0x000cd100, 0x000d9200, 0x900c5301,
    0x000f1400, 0x900ed501, 0x900f9601, 0x000e5700, 0x000a1800,
    0x900bd901, 0x900a9a01, 0x000b5b00, 0x90081c01, 0x0009dd00,
    0x00089e00, 0x90095f01, 0x90192001, 0x0018e100, 0x0019a200,
    0x90186301, 0x001b2400, 0x901ae501, 0x901ba601, 0x001a6700,
    0x001e2800, 0x901fe901, 0x901eaa01, 0x001f6b00, 0x901c2c01,
    0x001ded00, 0x001cae00, 0x901d6f01, 0x00143000, 0x9015f101,
    0x9014b201, 0x00157300, 0x90163401, 0x0017f500, 0x0016b600,
    0x90177701, 0x90133801, 0x0012f900, 0x0013ba00, 0x90127b01,
    0x00113c00, 0x9010fd01, 0x9011be01, 0x00107f00, 0x90314001,
    0x00308100, 0x0031c200, 0x90300301, 0x00334400, 0x90328501,
    0x9033c601, 0x00320700, 0x00364800, 0x90378901, 0x9036ca01,
    0x00370b00, 0x90344c01, 0x00358d00, 0x0034ce00, 0x90350f01,
    0x003c5000, 0x903d9101, 0x903cd201, 0x003d1300, 0x903e5401,
    0x003f9500, 0x003ed600, 0x903f1701, 0x903b5801, 0x003a9900,
    0x003bda00, 0x903a1b01, 0x00395c00, 0x90389d01, 0x9039de01,
    0x00381f00, 0x00286000, 0x9029a101, 0x9028e201, 0x00292300,
    0x902a6401, 0x002ba500, 0x002ae600, 0x902b2701, 0x902f6801,
    0x002ea900, 0x002fea00, 0x902e2b01, 0x002d6c00, 0x902cad01,
    0x902dee01, 0x002c2f00, 0x90257001, 0x0024b100, 0x0025f200,
    0x90243301, 0x00277400, 0x9026b501, 0x9027f601, 0x00263700,
    0x00227800, 0x9023b901, 0x9022fa01, 0x00233b00, 0x90207c01,
    0x0021bd00, 0x0020fe00, 0x90213f01, 0x90618001, 0x00604100,
    0x00610200, 0x9060c301, 0x00638400, 0x90624501, 0x90630601,
    0x0062c700, 0x00668800, 0x90674901, 0x90660a01, 0x0067cb00,
    0x90648c01, 0x00654d00, 0x00640e00, 0x9065cf01, 0x006c9000,
    0x906d5101, 0x906c1201, 0x006dd300, 0x906e9401, 0x006f5500,
    0x006e1600, 0x906fd701, 0x906b9801, 0x006a5900, 0x006b1a00,
    0x906adb01, 0x00699c00, 0x90685d01, 0x90691e01, 0x0068df00,
    0x0078a000, 0x90796101, 0x90782201, 0x0079e300, 0x907aa401,
    0x007b6500, 0x007a2600, 0x907be701, 0x907fa801, 0x007e6900,
    0x007f2a00, 0x907eeb01, 0x007dac00, 0x907c6d01, 0x907d2e01,
    0x007cef00, 0x9075b001, 0x00747100, 0x00753200, 0x9074f301,
    0x0077b400, 0x90767501, 0x90773601, 0x0076f700, 0x0072b800,
    0x90737901, 0x90723a01, 0x0073fb00, 0x9070bc01, 0x00717d00,
    0x00703e00, 0x9071ff01, 0x0050c000, 0x90510101, 0x90504201,
    0x00518300, 0x9052c401, 0x00530500, 0x00524600, 0x90538701,
    0x9057c801, 0x00560900, 0x00574a00, 0x90568b01, 0x0055cc00,
    0x90540d01, 0x90554e01, 0x00548f00, 0x905dd001, 0x005c1100,
    0x005d5200, 0x905c9301, 0x005fd400, 0x905e1501, 0x905f5601,
    0x005e9700, 0x005ad800, 0x905b1901, 0x905a5a01, 0x005b9b00,
    0x9058dc01, 0x00591d00, 0x00585e00, 0x90599f01, 0x9049e001,
    0x00482100, 0x00496200, 0x9048a301, 0x004be400, 0x904a2501,
    0x904b6601, 0x004aa700, 0x004ee800, 0x904f2901, 0x904e6a01,
    0x004fab00, 0x904cec01, 0x004d2d00, 0x004c6e00, 0x904daf01,
    0x0044f000, 0x90453101, 0x90447201, 0x0045b300, 0x9046f401,
    0x00473500, 0x00467600, 0x9047b701, 0x9043f801, 0x00423900,
    0x00437a00, 0x9042bb01, 0x0041fc00, 0x90403d01, 0x90417e01,
    0x0040bf00},
   {0x00000000, 0x90c00001, 0x91830001, 0x01430000, 0x93050001,
    0x03c50000, 0x02860000, 0x92460001, 0x96090001, 0x06c90000,
    0x078a0000, 0x974a0001, 0x050c0000, 0x95cc0001, 0x948f0001,
    0x044f0000, 0x9c110001, 0x0cd10000, 0x0d920000, 0x9d520001,
    0x0f140000, 0x9fd40001, 0x9e970001, 0x0e570000, 0x0a180000,
    0x9ad80001, 0x9b9b0001, 0x0b5b0000, 0x991d0001, 0x09dd0000,
    0x089e0000, 0x985e0001, 0x88210001, 0x18e10000, 0x19a20000,
    0x89620001, 0x1b240000, 0x8be40001, 0x8aa70001, 0x1a670000,
    0x1e280000, 0x8ee80001, 0x8fab0001, 0x1f6b0000, 0x8d2d0001,
    0x1ded0000, 0x1cae0000, 0x8c6e0001, 0x14300000, 0x84f00001,
    0x85b30001, 0x15730000, 0x87350001, 0x17f50000, 0x16b60000,
    0x86760001, 0x82390001, 0x12f90000, 0x13ba0000, 0x837a0001,
    0x113c0000, 0x81fc0001, 0x80bf0001, 0x107f0000, 0xa0410001,
    0x30810000, 0x31c20000, 0xa1020001, 0x33440000, 0xa3840001,
    0xa2c70001, 0x32070000, 0x36480000, 0xa6880001, 0xa7cb0001,
    0x370b0000, 0xa54d0001, 0x358d0000, 0x34ce0000, 0xa40e0001,
    0x3c500000, 0xac900001, 0xadd30001, 0x3d130000, 0xaf550001,
    0x3f950000, 0x3ed60000, 0xae160001, 0xaa590001, 0x3a990000,
    0x3bda0000, 0xab1a0001, 0x395c0000, 0xa99c0001, 0xa8df0001,
    0x381f0000, 0x28600000, 0xb8a00001, 0xb9e30001, 0x29230000,
    0xbb650001, 0x2ba50000, 0x2ae60000, 0xba260001, 0xbe690001,
    0x2ea90000, 0x2fea0000, 0xbf2a0001, 0x2d6c0000, 0xbdac0001,
    0xbcef0001, 0x2c2f0000, 0xb4710001, 0x24b10000, 0x25f20000,
    0xb5320001, 0x27740000, 0xb7b40001, 0xb6f70001, 0x26370000,
    0x22780000, 0xb2b80001, 0xb3fb0001, 0x233b0000, 0xb17d0001,
    0x21bd0000, 0x20fe0000, 0xb03e0001, 0xf0810001, 0x60410000,
    0x61020000, 0xf1c20001, 0x63840000, 0xf3440001, 0xf2070001,
    0x62c70000, 0x66880000, 0xf6480001, 0xf70b0001, 0x67cb0000,
    0xf58d0001, 0x654d0000, 0x640e0000, 0xf4ce0001, 0x6c900000,
    0xfc500001, 0xfd130001, 0x6dd30000, 0xff950001, 0x6f550000,
    0x6e160000, 0xfed60001, 0xfa990001, 0x6a590000, 0x6b1a0000,
    0xfbda0001, 0x699c0000, 0xf95c0001, 0xf81f0001, 0x68df0000,
    0x78a00000, 0xe8600001, 0xe9230001, 0x79e30000, 0xeba50001,
    0x7b650000, 0x7a260000, 0xeae60001, 0xeea90001, 0x7e690000,
    0x7f2a0000, 0xefea0001, 0x7dac0000, 0xed6c0001, 0xec2f0001,
    0x7cef0000, 0xe4b10001, 0x74710000, 0x75320000, 0xe5f20001,
    0x77b40000, 0xe7740001, 0xe6370001, 0x76f70000, 0x72b80000,
    0xe2780001, 0xe33b0001, 0x73fb0000, 0xe1bd0001, 0x717d0000,
    0x703e0000, 0xe0fe0001, 0x50c00000, 0xc0000001, 0xc1430001,
    0x51830000, 0xc3c50001, 0x53050000, 0x52460000, 0xc2860001,
    0xc6c90001, 0x56090000, 0x574a0000, 0xc78a0001, 0x55cc0000,
    0xc50c0001, 0xc44f0001, 0x548f0000, 0xccd10001, 0x5c110000,
    0x5d520000, 0xcd920001, 0x5fd40000, 0xcf140001, 0xce570001,
    0x5e970000, 0x5ad80000, 0xca180001, 0xcb5b0001, 0x5b9b0000,
    0xc9dd0001, 0x591d0000, 0x585e0000, 0xc89e0001, 0xd8e10001,
    0x48210000, 0x49620000, 0xd9a20001, 0x4be40000, 0xdb240001,
    0xda670001, 0x4aa70000, 0x4ee80000, 0xde280001, 0xdf6b0001,
    0x4fab0000, 0xdded0001, 0x4d2d0000, 0x4c6e0000, 0xdcae0001,
    0x44f00000, 0xd4300001, 0xd5730001, 0x45b30000, 0xd7f50001,
    0x47350000, 0x46760000, 0xd6b60001, 0xd2f90001, 0x42390000,
    0x437a0000, 0xd3ba0001, 0x41fc0000, 0xd13c0001, 0xd07f0001,
    0x40bf0000},
   {0x00000000, 0x51010001, 0xa2020002, 0xf3030003, 0xf4070007,
    0xa5060006, 0x56050005, 0x07040004, 0x580d000d, 0x090c000c,
    0xfa0f000f, 0xab0e000e, 0xac0a000a, 0xfd0b000b, 0x0e080008,
    0x5f090009, 0xb01a001a, 0xe11b001b, 0x12180018, 0x43190019,
    0x441d001d, 0x151c001c, 0xe61f001f, 0xb71e001e, 0xe8170017,
    0xb9160016, 0x4a150015, 0x1b140014, 0x1c100010, 0x4d110011,
    0xbe120012, 0xef130013, 0xd0370037, 0x81360036, 0x72350035,
    0x23340034, 0x24300030, 0x75310031, 0x86320032, 0xd7330033,
    0x883a003a, 0xd93b003b, 0x2a380038, 0x7b390039, 0x7c3d003d,
    0x2d3c003c, 0xde3f003f, 0x8f3e003e, 0x602d002d, 0x312c002c,
    0xc22f002f, 0x932e002e, 0x942a002a, 0xc52b002b, 0x36280028,
    0x67290029, 0x38200020, 0x69210021, 0x9a220022, 0xcb230023,
    0xcc270027, 0x9d260026, 0x6e250025, 0x3f240024, 0x106d006d,
    0x416c006c, 0xb26f006f, 0xe36e006e, 0xe46a006a, 0xb56b006b,
    0x46680068, 0x17690069, 0x48600060, 0x19610061, 0xea620062,
    0xbb630063, 0xbc670067, 0xed660066, 0x1e650065, 0x4f640064,
    0xa0770077, 0xf1760076, 0x02750075, 0x53740074, 0x54700070,
    0x05710071, 0xf6720072, 0xa7730073, 0xf87a007a, 0xa97b007b,
    0x5a780078, 0x0b790079, 0x0c7d007d, 0x5d7c007c, 0xae7f007f,
    0xff7e007e, 0xc05a005a, 0x915b005b, 0x62580058, 0x33590059,
    0x345d005d, 0x655c005c, 0x965f005f, 0xc75e005e, 0x98570057,
    0xc9560056, 0x3a550055, 0x6b540054, 0x6c500050, 0x3d510051,
    0xce520052, 0x9f530053, 0x70400040, 0x21410041, 0xd2420042,
    0x83430043, 0x84470047, 0xd5460046, 0x26450045, 0x77440044,
    0x284d004d, 0x794c004c, 0x8a4f004f, 0xdb4e004e, 0xdc4a004a,
    0x8d4b004b, 0x7e480048, 0x2f490049, 0x20da00da, 0x71db00db,
    0x82d800d8, 0xd3d900d9, 0xd4dd00dd, 0x85dc00dc, 0x76df00df,
    0x27de00de, 0x78d700d7, 0x29d600d6, 0xdad500d5, 0x8bd400d4,
    0x8cd000d0, 0xddd100d1, 0x2ed200d2, 0x7fd300d3, 0x90c000c0,
    0xc1c100c1, 0x32c200c2, 0x63c300c3, 0x64c700c7, 0x35c600c6,
    0xc6c500c5, 0x97c400c4, 0xc8cd00cd, 0x99cc00cc, 0x6acf00cf,
    0x3bce00ce, 0x3cca00ca, 0x6dcb00cb, 0x9ec800c8, 0xcfc900c9,
    0xf0ed00ed, 0xa1ec00ec, 0x52ef00ef, 0x03ee00ee, 0x04ea00ea,
    0x55eb00eb, 0xa6e800e8, 0xf7e900e9, 0xa8e000e0, 0xf9e100e1,
    0x0ae200e2, 0x5be300e3, 0x5ce700e7, 0x0de600e6, 0xfee500e5,
    0xafe400e4, 0x40f700f7, 0x11f600f6, 0xe2f500f5, 0xb3f400f4,
    0xb4f000f0, 0xe5f100f1, 0x16f200f2, 0x47f300f3, 0x18fa00fa,
    0x49fb00fb, 0xbaf800f8, 0xebf900f9, 0xecfd00fd, 0xbdfc00fc,
    0x4eff00ff, 0x1ffe00fe, 0x30b700b7, 0x61b600b6, 0x92b500b5,
    0xc3b400b4, 0xc4b000b0, 0x95b100b1, 0x66b200b2, 0x37b300b3,
    0x68ba00ba, 0x39bb00bb, 0xcab800b8, 0x9bb900b9, 0x9cbd00bd,
    0xcdbc00bc, 0x3ebf00bf, 0x6fbe00be, 0x80ad00ad, 0xd1ac00ac,
    0x22af00af, 0x73ae00ae, 0x74aa00aa, 0x25ab00ab, 0xd6a800a8,
    0x87a900a9, 0xd8a000a0, 0x89a100a1, 0x7aa200a2, 0x2ba300a3,
    0x2ca700a7, 0x7da600a6, 0x8ea500a5, 0xdfa400a4, 0xe0800080,
    0xb1810081, 0x42820082, 0x13830083, 0x14870087, 0x45860086,
    0xb6850085, 0xe7840084, 0xb88d008d, 0xe98c008c, 0x1a8f008f,
    0x4b8e008e, 0x4c8a008a, 0x1d8b008b, 0xee880088, 0xbf890089,
    0x509a009a, 0x019b009b, 0xf2980098, 0xa3990099, 0xa49d009d,
    0xf59c009c, 0x069f009f, 0x579e009e, 0x08970097, 0x59960096,
    0xaa950095, 0xfb940094, 0xfc900090, 0xad910091, 0x5e920092,
    0x0f930093},
   {0x00000000, 0x41b401b4, 0x83680368, 0xc2dc02dc, 0xb6d306d3,
    0xf7670767, 0x35bb05bb, 0x740f040f, 0xdda50da5, 0x9c110c11,
    0x5ecd0ecd, 0x1f790f79, 0x6b760b76, 0x2ac20ac2, 0xe81e081e,
    0xa9aa09aa, 0x0b491b49, 0x4afd1afd, 0x88211821, 0xc9951995,
    0xbd9a1d9a, 0xfc2e1c2e, 0x3ef21ef2, 0x7f461f46, 0xd6ec16ec,
    0x97581758, 0x55841584, 0x14301430, 0x603f103f, 0x218b118b,
    0xe3571357, 0xa2e312e3, 0x16923692, 0x57263726, 0x95fa35fa,
    0xd44e344e, 0xa0413041, 0xe1f531f5, 0x23293329, 0x629d329d,
    0xcb373b37, 0x8a833a83, 0x485f385f, 0x09eb39eb, 0x7de43de4,
    0x3c503c50, 0xfe8c3e8c, 0xbf383f38, 0x1ddb2ddb, 0x5c6f2c6f,
    0x9eb32eb3, 0xdf072f07, 0xab082b08, 0xeabc2abc, 0x28602860,
    0x69d429d4, 0xc07e207e, 0x81ca21ca, 0x43162316, 0x02a222a2,
    0x76ad26ad, 0x37192719, 0xf5c525c5, 0xb4712471, 0x2d246d24,
    0x6c906c90, 0xae4c6e4c, 0xeff86ff8, 0x9bf76bf7, 0xda436a43,
    0x189f689f, 0x592b692b, 0xf0816081, 0xb1356135, 0x73e963e9,
    0x325d625d, 0x46526652, 0x07e667e6, 0xc53a653a, 0x848e648e,
    0x266d766d, 0x67d977d9, 0xa5057505, 0xe4b174b1, 0x90be70be,
    0xd10a710a, 0x13d673d6, 0x52627262, 0xfbc87bc8, 0xba7c7a7c,
    0x78a078a0, 0x39147914, 0x4d1b7d1b, 0x0caf7caf, 0xce737e73,
    0x8fc77fc7, 0x3bb65bb6, 0x7a025a02, 0xb8de58de, 0xf96a596a,
    0x8d655d65, 0xccd15cd1, 0x0e0d5e0d, 0x4fb95fb9, 0xe6135613,
    0xa7a757a7, 0x657b557b, 0x24cf54cf, 0x50c050c0, 0x11745174,
    0xd3a853a8, 0x921c521c, 0x30ff40ff, 0x714b414b, 0xb3974397,
    0xf2234223, 0x862c462c, 0xc7984798, 0x05444544, 0x44f044f0,
    0xed5a4d5a, 0xacee4cee, 0x6e324e32, 0x2f864f86, 0x5b894b89,
    0x1a3d4a3d, 0xd8e148e1, 0x99554955, 0x5a48da48, 0x1bfcdbfc,
    0xd920d920, 0x9894d894, 0xec9bdc9b, 0xad2fdd2f, 0x6ff3dff3,
    0x2e47de47, 0x87edd7ed, 0xc659d659, 0x0485d485, 0x4531d531,
    0x313ed13e, 0x708ad08a, 0xb256d256, 0xf3e2d3e2, 0x5101c101,
    0x10b5c0b5, 0xd269c269, 0x93ddc3dd, 0xe7d2c7d2, 0xa666c666,
    0x64bac4ba, 0x250ec50e, 0x8ca4cca4, 0xcd10cd10, 0x0fcccfcc,
    0x4e78ce78, 0x3a77ca77, 0x7bc3cbc3, 0xb91fc91f, 0xf8abc8ab,
    0x4cdaecda, 0x0d6eed6e, 0xcfb2efb2, 0x8e06ee06, 0xfa09ea09,
    0xbbbdebbd, 0x7961e961, 0x38d5e8d5, 0x917fe17f, 0xd0cbe0cb,
    0x1217e217, 0x53a3e3a3, 0x27ace7ac, 0x6618e618, 0xa4c4e4c4,
    0xe570e570, 0x4793f793, 0x0627f627, 0xc4fbf4fb, 0x854ff54f,
    0xf140f140, 0xb0f4f0f4, 0x7228f228, 0x339cf39c, 0x9a36fa36,
    0xdb82fb82, 0x195ef95e, 0x58eaf8ea, 0x2ce5fce5, 0x6d51fd51,
    0xaf8dff8d, 0xee39fe39, 0x776cb76c, 0x36d8b6d8, 0xf404b404,
    0xb5b0b5b0, 0xc1bfb1bf, 0x800bb00b, 0x42d7b2d7, 0x0363b363,
    0xaac9bac9, 0xeb7dbb7d, 0x29a1b9a1, 0x6815b815, 0x1c1abc1a,
    0x5daebdae, 0x9f72bf72, 0xdec6bec6, 0x7c25ac25, 0x3d91ad91,
    0xff4daf4d, 0xbef9aef9, 0xcaf6aaf6, 0x8b42ab42, 0x499ea99e,
    0x082aa82a, 0xa180a180, 0xe034a034, 0x22e8a2e8, 0x635ca35c,
    0x1753a753, 0x56e7a6e7, 0x943ba43b, 0xd58fa58f, 0x61fe81fe,
    0x204a804a, 0xe2968296, 0xa3228322, 0xd72d872d, 0x96998699,
    0x54458445, 0x15f185f1, 0xbc5b8c5b, 0xfdef8def, 0x3f338f33,
    0x7e878e87, 0x0a888a88, 0x4b3c8b3c, 0x89e089e0, 0xc8548854,
    0x6ab79ab7, 0x2b039b03, 0xe9df99df, 0xa86b986b, 0xdc649c64,
    0x9dd09dd0, 0x5f0c9f0c, 0x1eb89eb8, 0xb7129712, 0xf6a696a6,
    0x347a947a, 0x75ce95ce, 0x01c191c1, 0x40759075, 0x82a992a9,
    0xc31d931d},
   {0x00000000, 0xb491b490, 0xd9206923, 0x6db1ddb3, 0x0243d245,
    0xb6d266d5, 0xdb63bb66, 0x6ff20ff6, 0x0487a48a, 0xb016101a,
    0xdda7cda9, 0x69367939, 0x06c476cf, 0xb255c25f, 0xdfe41fec,
    0x6b75ab7c, 0x090f4914, 0xbd9efd84, 0xd02f2037, 0x64be94a7,
    0x0b4c9b51, 0xbfdd2fc1, 0xd26cf272, 0x66fd46e2, 0x0d88ed9e,
    0xb919590e, 0xd4a884bd, 0x6039302d, 0x0fcb3fdb, 0xbb5a8b4b,
    0xd6eb56f8, 0x627ae268, 0x121e9228, 0xa68f26b8, 0xcb3efb0b,
    0x7faf4f9b, 0x105d406d, 0xa4ccf4fd, 0xc97d294e, 0x7dec9dde,
    0x169936a2, 0xa2088232, 0xcfb95f81, 0x7b28eb11, 0x14dae4e7,
    0xa04b5077, 0xcdfa8dc4, 0x796b3954, 0x1b11db3c, 0xaf806fac,
    0xc231b21f, 0x76a0068f, 0x19520979, 0xadc3bde9, 0xc072605a,
    0x74e3d4ca, 0x1f967fb6, 0xab07cb26, 0xc6b61695, 0x7227a205,
    0x1dd5adf3, 0xa9441963, 0xc4f5c4d0, 0x70647040, 0x243d2450,
    0x90ac90c0, 0xfd1d4d73, 0x498cf9e3, 0x267ef615, 0x92ef4285,
    0xff5e9f36, 0x4bcf2ba6, 0x20ba80da, 0x942b344a, 0xf99ae9f9,
    0x4d0b5d69, 0x22f9529f, 0x9668e60f, 0xfbd93bbc, 0x4f488f2c,
    0x2d326d44, 0x99a3d9d4, 0xf4120467, 0x4083b0f7, 0x2f71bf01,
    0x9be00b91, 0xf651d622, 0x42c062b2, 0x29b5c9ce, 0x9d247d5e,
    0xf095a0ed, 0x4404147d, 0x2bf61b8b, 0x9f67af1b, 0xf2d672a8,
    0x4647c638, 0x3623b678, 0x82b202e8, 0xef03df5b, 0x5b926bcb,
    0x3460643d, 0x80f1d0ad, 0xed400d1e, 0x59d1b98e, 0x32a412f2,
    0x8635a662, 0xeb847bd1, 0x5f15cf41, 0x30e7c0b7, 0x84767427,
    0xe9c7a994, 0x5d561d04, 0x3f2cff6c, 0x8bbd4bfc, 0xe60c964f,
    0x529d22df, 0x3d6f2d29, 0x89fe99b9, 0xe44f440a, 0x50def09a,
    0x3bab5be6, 0x8f3aef76, 0xe28b32c5, 0x561a8655, 0x39e889a3,
    0x8d793d33, 0xe0c8e080, 0x54595410, 0x487a48a0, 0xfcebfc30,
    0x915a2183, 0x25cb9513, 0x4a399ae5, 0xfea82e75, 0x9319f3c6,
    0x27884756, 0x4cfdec2a, 0xf86c58ba, 0x95dd8509, 0x214c3199,
    0x4ebe3e6f, 0xfa2f8aff, 0x979e574c, 0x230fe3dc, 0x417501b4,
    0xf5e4b524, 0x98556897, 0x2cc4dc07, 0x4336d3f1, 0xf7a76761,
    0x9a16bad2, 0x2e870e42, 0x45f2a53e, 0xf16311ae, 0x9cd2cc1d,
    0x2843788d, 0x47b1777b, 0xf320c3eb, 0x9e911e58, 0x2a00aac8,
    0x5a64da88, 0xeef56e18, 0x8344b3ab, 0x37d5073b, 0x582708cd,
    0xecb6bc5d, 0x810761ee, 0x3596d57e, 0x5ee37e02, 0xea72ca92,
    0x87c31721, 0x3352a3b1, 0x5ca0ac47, 0xe83118d7, 0x8580c564,
    0x311171f4, 0x536b939c, 0xe7fa270c, 0x8a4bfabf, 0x3eda4e2f,
    0x512841d9, 0xe5b9f549, 0x880828fa, 0x3c999c6a, 0x57ec3716,
    0xe37d8386, 0x8ecc5e35, 0x3a5deaa5, 0x55afe553, 0xe13e51c3,
    0x8c8f8c70, 0x381e38e0, 0x6c476cf0, 0xd8d6d860, 0xb56705d3,
    0x01f6b143, 0x6e04beb5, 0xda950a25, 0xb724d796, 0x03b56306,
    0x68c0c87a, 0xdc517cea, 0xb1e0a159, 0x057115c9, 0x6a831a3f,
    0xde12aeaf, 0xb3a3731c, 0x0732c78c, 0x654825e4, 0xd1d99174,
    0xbc684cc7, 0x08f9f857, 0x670bf7a1, 0xd39a4331, 0xbe2b9e82,
    0x0aba2a12, 0x61cf816e, 0xd55e35fe, 0xb8efe84d, 0x0c7e5cdd,
    0x638c532b, 0xd71de7bb, 0xbaac3a08, 0x0e3d8e98, 0x7e59fed8,
    0xcac84a48, 0xa77997fb, 0x13e8236b, 0x7c1a2c9d, 0xc88b980d,
    0xa53a45be, 0x11abf12e, 0x7ade5a52, 0xce4feec2, 0xa3fe3371,
    0x176f87e1, 0x789d8817, 0xcc0c3c87, 0xa1bde134, 0x152c55a4,
    0x7756b7cc, 0xc3c7035c, 0xae76deef, 0x1ae76a7f, 0x75156589,
    0xc184d119, 0xac350caa, 0x18a4b83a, 0x73d11346, 0xc740a7d6,
    0xaaf17a65, 0x1e60cef5, 0x7192c103, 0xc5037593, 0xa8b2a820,
    0x1c231cb0},
   {0x00000000, 0x90f49140, 0x91ea2283, 0x011eb3c3, 0x93d74505,
    0x0323d445, 0x023d6786, 0x92c9f6c6, 0x97ad8a09, 0x07591b49,
    0x0647a88a, 0x96b339ca, 0x047acf0c, 0x948e5e4c, 0x9590ed8f,
    0x05647ccf, 0x9f581411, 0x0fac8551, 0x0eb23692, 0x9e46a7d2,
    0x0c8f5114, 0x9c7bc054, 0x9d657397, 0x0d91e2d7, 0x08f59e18,
    0x98010f58, 0x991fbc9b, 0x09eb2ddb, 0x9b22db1d, 0x0bd64a5d,
    0x0ac8f99e, 0x9a3c68de, 0x8eb32821, 0x1e47b961, 0x1f590aa2,
    0x8fad9be2, 0x1d646d24, 0x8d90fc64, 0x8c8e4fa7, 0x1c7adee7,
    0x191ea228, 0x89ea3368, 0x88f480ab, 0x180011eb, 0x8ac9e72d,
    0x1a3d766d, 0x1b23c5ae, 0x8bd754ee, 0x11eb3c30, 0x811fad70,
    0x80011eb3, 0x10f58ff3, 0x823c7935, 0x12c8e875, 0x13d65bb6,
    0x8322caf6, 0x8646b639, 0x16b22779, 0x17ac94ba, 0x875805fa,
    0x1591f33c, 0x8565627c, 0x847bd1bf, 0x148f40ff, 0xad655041,
    0x3d91c101, 0x3c8f72c2, 0xac7be382, 0x3eb21544, 0xae468404,
    0xaf5837c7, 0x3faca687, 0x3ac8da48, 0xaa3c4b08, 0xab22f8cb,
    0x3bd6698b, 0xa91f9f4d, 0x39eb0e0d, 0x38f5bdce, 0xa8012c8e,
    0x323d4450, 0xa2c9d510, 0xa3d766d3, 0x3323f793, 0xa1ea0155,
    0x311e9015, 0x300023d6, 0xa0f4b296, 0xa590ce59, 0x35645f19,
    0x347aecda, 0xa48e7d9a, 0x36478b5c, 0xa6b31a1c, 0xa7ada9df,
    0x3759389f, 0x23d67860, 0xb322e920, 0xb23c5ae3, 0x22c8cba3,
    0xb0013d65, 0x20f5ac25, 0x21eb1fe6, 0xb11f8ea6, 0xb47bf269,
    0x248f6329, 0x2591d0ea, 0xb56541aa, 0x27acb76c, 0xb758262c,
    0xb64695ef, 0x26b204af, 0xbc8e6c71, 0x2c7afd31, 0x2d644ef2,
    0xbd90dfb2, 0x2f592974, 0xbfadb834, 0xbeb30bf7, 0x2e479ab7,
    0x2b23e678, 0xbbd77738, 0xbac9c4fb, 0x2a3d55bb, 0xb8f4a37d,
    0x2800323d, 0x291e81fe, 0xb9ea10be, 0xeac9a081, 0x7a3d31c1,
    0x7b238202, 0xebd71342, 0x791ee584, 0xe9ea74c4, 0xe8f4c707,
    0x78005647, 0x7d642a88, 0xed90bbc8, 0xec8e080b, 0x7c7a994b,
    0xeeb36f8d, 0x7e47fecd, 0x7f594d0e, 0xefaddc4e, 0x7591b490,
    0xe56525d0, 0xe47b9613, 0x748f0753, 0xe646f195, 0x76b260d5,
    0x77acd316, 0xe7584256, 0xe23c3e99, 0x72c8afd9, 0x73d61c1a,
    0xe3228d5a, 0x71eb7b9c, 0xe11feadc, 0xe001591f, 0x70f5c85f,
    0x647a88a0, 0xf48e19e0, 0xf590aa23, 0x65643b63, 0xf7adcda5,
    0x67595ce5, 0x6647ef26, 0xf6b37e66, 0xf3d702a9, 0x632393e9,
    0x623d202a, 0xf2c9b16a, 0x600047ac, 0xf0f4d6ec, 0xf1ea652f,
    0x611ef46f, 0xfb229cb1, 0x6bd60df1, 0x6ac8be32, 0xfa3c2f72,
    0x68f5d9b4, 0xf80148f4, 0xf91ffb37, 0x69eb6a77, 0x6c8f16b8,
    0xfc7b87f8, 0xfd65343b, 0x6d91a57b, 0xff5853bd, 0x6facc2fd,
    0x6eb2713e, 0xfe46e07e, 0x47acf0c0, 0xd7586180, 0xd646d243,
    0x46b24303, 0xd47bb5c5, 0x448f2485, 0x45919746, 0xd5650606,
    0xd0017ac9, 0x40f5eb89, 0x41eb584a, 0xd11fc90a, 0x43d63fcc,
    0xd322ae8c, 0xd23c1d4f, 0x42c88c0f, 0xd8f4e4d1, 0x48007591,
    0x491ec652, 0xd9ea5712, 0x4b23a1d4, 0xdbd73094, 0xdac98357,
    0x4a3d1217, 0x4f596ed8, 0xdfadff98, 0xdeb34c5b, 0x4e47dd1b,
    0xdc8e2bdd, 0x4c7aba9d, 0x4d64095e, 0xdd90981e, 0xc91fd8e1,
    0x59eb49a1, 0x58f5fa62, 0xc8016b22, 0x5ac89de4, 0xca3c0ca4,
    0xcb22bf67, 0x5bd62e27, 0x5eb252e8, 0xce46c3a8, 0xcf58706b,
    0x5face12b, 0xcd6517ed, 0x5d9186ad, 0x5c8f356e, 0xcc7ba42e,
    0x5647ccf0, 0xc6b35db0, 0xc7adee73, 0x57597f33, 0xc59089f5,
    0x556418b5, 0x547aab76, 0xc48e3a36, 0xc1ea46f9, 0x511ed7b9,
    0x5000647a, 0xc0f4f53a, 0x523d03fc, 0xc2c992bc, 0xc3d7217f,
    0x5323b03f}};

static const word_t crc_braid_big_table[][256] = {
   {0x0000000000000000, 0x4091f49000000000, 0x8322ea9100000000,
    0xc3b31e0100000000, 0x0545d79300000000, 0x45d4230300000000,
    0x86673d0200000000, 0xc6f6c99200000000, 0x098aad9700000000,
    0x491b590700000000, 0x8aa8470600000000, 0xca39b39600000000,
    0x0ccf7a0400000000, 0x4c5e8e9400000000, 0x8fed909500000000,
    0xcf7c640500000000, 0x1114589f00000000, 0x5185ac0f00000000,
    0x9236b20e00000000, 0xd2a7469e00000000, 0x14518f0c00000000,
    0x54c07b9c00000000, 0x9773659d00000000, 0xd7e2910d00000000,
    0x189ef50800000000, 0x580f019800000000, 0x9bbc1f9900000000,
    0xdb2deb0900000000, 0x1ddb229b00000000, 0x5d4ad60b00000000,
    0x9ef9c80a00000000, 0xde683c9a00000000, 0x2128b38e00000000,
    0x61b9471e00000000, 0xa20a591f00000000, 0xe29bad8f00000000,
    0x246d641d00000000, 0x64fc908d00000000, 0xa74f8e8c00000000,
    0xe7de7a1c00000000, 0x28a21e1900000000, 0x6833ea8900000000,
    0xab80f48800000000, 0xeb11001800000000, 0x2de7c98a00000000,
    0x6d763d1a00000000, 0xaec5231b00000000, 0xee54d78b00000000,
    0x303ceb1100000000, 0x70ad1f8100000000, 0xb31e018000000000,
    0xf38ff51000000000, 0x35793c8200000000, 0x75e8c81200000000,
    0xb65bd61300000000, 0xf6ca228300000000, 0x39b6468600000000,
    0x7927b21600000000, 0xba94ac1700000000, 0xfa05588700000000,
    0x3cf3911500000000, 0x7c62658500000000, 0xbfd17b8400000000,
    0xff408f1400000000, 0x415065ad00000000, 0x01c1913d00000000,
    0xc2728f3c00000000, 0x82e37bac00000000, 0x4415b23e00000000,
    0x048446ae00000000, 0xc73758af00000000, 0x87a6ac3f00000000,
    0x48dac83a00000000, 0x084b3caa00000000, 0xcbf822ab00000000,
    0x8b69d63b00000000, 0x4d9f1fa900000000, 0x0d0eeb3900000000,
    0xcebdf53800000000, 0x8e2c01a800000000, 0x50443d3200000000,
    0x10d5c9a200000000, 0xd366d7a300000000, 0x93f7233300000000,
    0x5501eaa100000000, 0x15901e3100000000, 0xd623003000000000,
    0x96b2f4a000000000, 0x59ce90a500000000, 0x195f643500000000,
    0xdaec7a3400000000, 0x9a7d8ea400000000, 0x5c8b473600000000,
    0x1c1ab3a600000000, 0xdfa9ada700000000, 0x9f38593700000000,
    0x6078d62300000000, 0x20e922b300000000, 0xe35a3cb200000000,
    0xa3cbc82200000000, 0x653d01b000000000, 0x25acf52000000000,
    0xe61feb2100000000, 0xa68e1fb100000000, 0x69f27bb400000000,
    0x29638f2400000000, 0xead0912500000000, 0xaa4165b500000000,
    0x6cb7ac2700000000, 0x2c2658b700000000, 0xef9546b600000000,
    0xaf04b22600000000, 0x716c8ebc00000000, 0x31fd7a2c00000000,
    0xf24e642d00000000, 0xb2df90bd00000000, 0x7429592f00000000,
    0x34b8adbf00000000, 0xf70bb3be00000000, 0xb79a472e00000000,
    0x78e6232b00000000, 0x3877d7bb00000000, 0xfbc4c9ba00000000,
    0xbb553d2a00000000, 0x7da3f4b800000000, 0x3d32002800000000,
    0xfe811e2900000000, 0xbe10eab900000000, 0x81a0c9ea00000000,
    0xc1313d7a00000000, 0x0282237b00000000, 0x4213d7eb00000000,
    0x84e51e7900000000, 0xc474eae900000000, 0x07c7f4e800000000,
    0x4756007800000000, 0x882a647d00000000, 0xc8bb90ed00000000,
    0x0b088eec00000000, 0x4b997a7c00000000, 0x8d6fb3ee00000000,
    0xcdfe477e00000000, 0x0e4d597f00000000, 0x4edcadef00000000,
    0x90b4917500000000, 0xd02565e500000000, 0x13967be400000000,
    0x53078f7400000000, 0x95f146e600000000, 0xd560b27600000000,
    0x16d3ac7700000000, 0x564258e700000000, 0x993e3ce200000000,
    0xd9afc87200000000, 0x1a1cd67300000000, 0x5a8d22e300000000,
    0x9c7beb7100000000, 0xdcea1fe100000000, 0x1f5901e000000000,
    0x5fc8f57000000000, 0xa0887a6400000000, 0xe0198ef400000000,
    0x23aa90f500000000, 0x633b646500000000, 0xa5cdadf700000000,
    0xe55c596700000000, 0x26ef476600000000, 0x667eb3f600000000,
    0xa902d7f300000000, 0xe993236300000000, 0x2a203d6200000000,
    0x6ab1c9f200000000, 0xac47006000000000, 0xecd6f4f000000000,
    0x2f65eaf100000000, 0x6ff41e6100000000, 0xb19c22fb00000000,
    0xf10dd66b00000000, 0x32bec86a00000000, 0x722f3cfa00000000,
    0xb4d9f56800000000, 0xf44801f800000000, 0x37fb1ff900000000,
    0x776aeb6900000000, 0xb8168f6c00000000, 0xf8877bfc00000000,
    0x3b3465fd00000000, 0x7ba5916d00000000, 0xbd5358ff00000000,
    0xfdc2ac6f00000000, 0x3e71b26e00000000, 0x7ee046fe00000000,
    0xc0f0ac4700000000, 0x806158d700000000, 0x43d246d600000000,
    0x0343b24600000000, 0xc5b57bd400000000, 0x85248f4400000000,
    0x4697914500000000, 0x060665d500000000, 0xc97a01d000000000,
    0x89ebf54000000000, 0x4a58eb4100000000, 0x0ac91fd100000000,
    0xcc3fd64300000000, 0x8cae22d300000000, 0x4f1d3cd200000000,
    0x0f8cc84200000000, 0xd1e4f4d800000000, 0x9175004800000000,
    0x52c61e4900000000, 0x1257ead900000000, 0xd4a1234b00000000,
    0x9430d7db00000000, 0x5783c9da00000000, 0x17123d4a00000000,
    0xd86e594f00000000, 0x98ffaddf00000000, 0x5b4cb3de00000000,
    0x1bdd474e00000000, 0xdd2b8edc00000000, 0x9dba7a4c00000000,
    0x5e09644d00000000, 0x1e9890dd00000000, 0xe1d81fc900000000,
    0xa149eb5900000000, 0x62faf55800000000, 0x226b01c800000000,
    0xe49dc85a00000000, 0xa40c3cca00000000, 0x67bf22cb00000000,
    0x272ed65b00000000, 0xe852b25e00000000, 0xa8c346ce00000000,
    0x6b7058cf00000000, 0x2be1ac5f00000000, 0xed1765cd00000000,
    0xad86915d00000000, 0x6e358f5c00000000, 0x2ea47bcc00000000,
    0xf0cc475600000000, 0xb05db3c600000000, 0x73eeadc700000000,
    0x337f595700000000, 0xf58990c500000000, 0xb518645500000000,
    0x76ab7a5400000000, 0x363a8ec400000000, 0xf946eac100000000,
    0xb9d71e5100000000, 0x7a64005000000000, 0x3af5f4c000000000,
    0xfc033d5200000000, 0xbc92c9c200000000, 0x7f21d7c300000000,
    0x3fb0235300000000},
   {0x0000000000000000, 0x90b491b400000000, 0x236920d900000000,
    0xb3ddb16d00000000, 0x45d2430200000000, 0xd566d2b600000000,
    0x66bb63db00000000, 0xf60ff26f00000000, 0x8aa4870400000000,
    0x1a1016b000000000, 0xa9cda7dd00000000, 0x3979366900000000,
    0xcf76c40600000000, 0x5fc255b200000000, 0xec1fe4df00000000,
    0x7cab756b00000000, 0x14490f0900000000, 0x84fd9ebd00000000,
    0x37202fd000000000, 0xa794be6400000000, 0x519b4c0b00000000,
    0xc12fddbf00000000, 0x72f26cd200000000, 0xe246fd6600000000,
    0x9eed880d00000000, 0x0e5919b900000000, 0xbd84a8d400000000,
    0x2d30396000000000, 0xdb3fcb0f00000000, 0x4b8b5abb00000000,
    0xf856ebd600000000, 0x68e27a6200000000, 0x28921e1200000000,
    0xb8268fa600000000, 0x0bfb3ecb00000000, 0x9b4faf7f00000000,
    0x6d405d1000000000, 0xfdf4cca400000000, 0x4e297dc900000000,
    0xde9dec7d00000000, 0xa236991600000000, 0x328208a200000000,
    0x815fb9cf00000000, 0x11eb287b00000000, 0xe7e4da1400000000,
    0x77504ba000000000, 0xc48dfacd00000000, 0x54396b7900000000,
    0x3cdb111b00000000, 0xac6f80af00000000, 0x1fb231c200000000,
    0x8f06a07600000000, 0x7909521900000000, 0xe9bdc3ad00000000,
    0x5a6072c000000000, 0xcad4e37400000000, 0xb67f961f00000000,
    0x26cb07ab00000000, 0x9516b6c600000000, 0x05a2277200000000,
    0xf3add51d00000000, 0x631944a900000000, 0xd0c4f5c400000000,
    0x4070647000000000, 0x50243d2400000000, 0xc090ac9000000000,
    0x734d1dfd00000000, 0xe3f98c4900000000, 0x15f67e2600000000,
    0x8542ef9200000000, 0x369f5eff00000000, 0xa62bcf4b00000000,
    0xda80ba2000000000, 0x4a342b9400000000, 0xf9e99af900000000,
    0x695d0b4d00000000, 0x9f52f92200000000, 0x0fe6689600000000,
    0xbc3bd9fb00000000, 0x2c8f484f00000000, 0x446d322d00000000,
    0xd4d9a39900000000, 0x670412f400000000, 0xf7b0834000000000,
    0x01bf712f00000000, 0x910be09b00000000, 0x22d651f600000000,
    0xb262c04200000000, 0xcec9b52900000000, 0x5e7d249d00000000,
    0xeda095f000000000, 0x7d14044400000000, 0x8b1bf62b00000000,
    0x1baf679f00000000, 0xa872d6f200000000, 0x38c6474600000000,
    0x78b6233600000000, 0xe802b28200000000, 0x5bdf03ef00000000,
    0xcb6b925b00000000, 0x3d64603400000000, 0xadd0f18000000000,
    0x1e0d40ed00000000, 0x8eb9d15900000000, 0xf212a43200000000,
    0x62a6358600000000, 0xd17b84eb00000000, 0x41cf155f00000000,
    0xb7c0e73000000000, 0x2774768400000000, 0x94a9c7e900000000,
    0x041d565d00000000, 0x6cff2c3f00000000, 0xfc4bbd8b00000000,
    0x4f960ce600000000, 0xdf229d5200000000, 0x292d6f3d00000000,
    0xb999fe8900000000, 0x0a444fe400000000, 0x9af0de5000000000,
    0xe65bab3b00000000, 0x76ef3a8f00000000, 0xc5328be200000000,
    0x55861a5600000000, 0xa389e83900000000, 0x333d798d00000000,
    0x80e0c8e000000000, 0x1054595400000000, 0xa0487a4800000000,
    0x30fcebfc00000000, 0x83215a9100000000, 0x1395cb2500000000,
    0xe59a394a00000000, 0x752ea8fe00000000, 0xc6f3199300000000,
    0x5647882700000000, 0x2aecfd4c00000000, 0xba586cf800000000,
    0x0985dd9500000000, 0x99314c2100000000, 0x6f3ebe4e00000000,
    0xff8a2ffa00000000, 0x4c579e9700000000, 0xdce30f2300000000,
    0xb401754100000000, 0x24b5e4f500000000, 0x9768559800000000,
    0x07dcc42c00000000, 0xf1d3364300000000, 0x6167a7f700000000,
    0xd2ba169a00000000, 0x420e872e00000000, 0x3ea5f24500000000,
    0xae1163f100000000, 0x1dccd29c00000000, 0x8d78432800000000,
    0x7b77b14700000000, 0xebc320f300000000, 0x581e919e00000000,
    0xc8aa002a00000000, 0x88da645a00000000, 0x186ef5ee00000000,
    0xabb3448300000000, 0x3b07d53700000000, 0xcd08275800000000,
    0x5dbcb6ec00000000, 0xee61078100000000, 0x7ed5963500000000,
    0x027ee35e00000000, 0x92ca72ea00000000, 0x2117c38700000000,
    0xb1a3523300000000, 0x47aca05c00000000, 0xd71831e800000000,
    0x64c5808500000000, 0xf471113100000000, 0x9c936b5300000000,
    0x0c27fae700000000, 0xbffa4b8a00000000, 0x2f4eda3e00000000,
    0xd941285100000000, 0x49f5b9e500000000, 0xfa28088800000000,
    0x6a9c993c00000000, 0x1637ec5700000000, 0x86837de300000000,
    0x355ecc8e00000000, 0xa5ea5d3a00000000, 0x53e5af5500000000,
    0xc3513ee100000000, 0x708c8f8c00000000, 0xe0381e3800000000,
    0xf06c476c00000000, 0x60d8d6d800000000, 0xd30567b500000000,
    0x43b1f60100000000, 0xb5be046e00000000, 0x250a95da00000000,
    0x96d724b700000000, 0x0663b50300000000, 0x7ac8c06800000000,
    0xea7c51dc00000000, 0x59a1e0b100000000, 0xc915710500000000,
    0x3f1a836a00000000, 0xafae12de00000000, 0x1c73a3b300000000,
    0x8cc7320700000000, 0xe425486500000000, 0x7491d9d100000000,
    0xc74c68bc00000000, 0x57f8f90800000000, 0xa1f70b6700000000,
    0x31439ad300000000, 0x829e2bbe00000000, 0x122aba0a00000000,
    0x6e81cf6100000000, 0xfe355ed500000000, 0x4de8efb800000000,
    0xdd5c7e0c00000000, 0x2b538c6300000000, 0xbbe71dd700000000,
    0x083aacba00000000, 0x988e3d0e00000000, 0xd8fe597e00000000,
    0x484ac8ca00000000, 0xfb9779a700000000, 0x6b23e81300000000,
    0x9d2c1a7c00000000, 0x0d988bc800000000, 0xbe453aa500000000,
    0x2ef1ab1100000000, 0x525ade7a00000000, 0xc2ee4fce00000000,
    0x7133fea300000000, 0xe1876f1700000000, 0x17889d7800000000,
    0x873c0ccc00000000, 0x34e1bda100000000, 0xa4552c1500000000,
    0xccb7567700000000, 0x5c03c7c300000000, 0xefde76ae00000000,
    0x7f6ae71a00000000, 0x8965157500000000, 0x19d184c100000000,
    0xaa0c35ac00000000, 0x3ab8a41800000000, 0x4613d17300000000,
    0xd6a740c700000000, 0x657af1aa00000000, 0xf5ce601e00000000,
    0x03c1927100000000, 0x937503c500000000, 0x20a8b2a800000000,
    0xb01c231c00000000},
   {0x0000000000000000, 0xb401b44100000000, 0x6803688300000000,
    0xdc02dcc200000000, 0xd306d3b600000000, 0x670767f700000000,
    0xbb05bb3500000000, 0x0f040f7400000000, 0xa50da5dd00000000,
    0x110c119c00000000, 0xcd0ecd5e00000000, 0x790f791f00000000,
    0x760b766b00000000, 0xc20ac22a00000000, 0x1e081ee800000000,
    0xaa09aaa900000000, 0x491b490b00000000, 0xfd1afd4a00000000,
    0x2118218800000000, 0x951995c900000000, 0x9a1d9abd00000000,
    0x2e1c2efc00000000, 0xf21ef23e00000000, 0x461f467f00000000,
    0xec16ecd600000000, 0x5817589700000000, 0x8415845500000000,
    0x3014301400000000, 0x3f103f6000000000, 0x8b118b2100000000,
    0x571357e300000000, 0xe312e3a200000000, 0x9236921600000000,
    0x2637265700000000, 0xfa35fa9500000000, 0x4e344ed400000000,
    0x413041a000000000, 0xf531f5e100000000, 0x2933292300000000,
    0x9d329d6200000000, 0x373b37cb00000000, 0x833a838a00000000,
    0x5f385f4800000000, 0xeb39eb0900000000, 0xe43de47d00000000,
    0x503c503c00000000, 0x8c3e8cfe00000000, 0x383f38bf00000000,
    0xdb2ddb1d00000000, 0x6f2c6f5c00000000, 0xb32eb39e00000000,
    0x072f07df00000000, 0x082b08ab00000000, 0xbc2abcea00000000,
    0x6028602800000000, 0xd429d46900000000, 0x7e207ec000000000,
    0xca21ca8100000000, 0x1623164300000000, 0xa222a20200000000,
    0xad26ad7600000000, 0x1927193700000000, 0xc525c5f500000000,
    0x712471b400000000, 0x246d242d00000000, 0x906c906c00000000,
    0x4c6e4cae00000000, 0xf86ff8ef00000000, 0xf76bf79b00000000,
    0x436a43da00000000, 0x9f689f1800000000, 0x2b692b5900000000,
    0x816081f000000000, 0x356135b100000000, 0xe963e97300000000,
    0x5d625d3200000000, 0x5266524600000000, 0xe667e60700000000,
    0x3a653ac500000000, 0x8e648e8400000000, 0x6d766d2600000000,
    0xd977d96700000000, 0x057505a500000000, 0xb174b1e400000000,
    0xbe70be9000000000, 0x0a710ad100000000, 0xd673d61300000000,
    0x6272625200000000, 0xc87bc8fb00000000, 0x7c7a7cba00000000,
    0xa078a07800000000, 0x1479143900000000, 0x1b7d1b4d00000000,
    0xaf7caf0c00000000, 0x737e73ce00000000, 0xc77fc78f00000000,
    0xb65bb63b00000000, 0x025a027a00000000, 0xde58deb800000000,
    0x6a596af900000000, 0x655d658d00000000, 0xd15cd1cc00000000,
    0x0d5e0d0e00000000, 0xb95fb94f00000000, 0x135613e600000000,
    0xa757a7a700000000, 0x7b557b6500000000, 0xcf54cf2400000000,
    0xc050c05000000000, 0x7451741100000000, 0xa853a8d300000000,
    0x1c521c9200000000, 0xff40ff3000000000, 0x4b414b7100000000,
    0x974397b300000000, 0x234223f200000000, 0x2c462c8600000000,
    0x984798c700000000, 0x4445440500000000, 0xf044f04400000000,
    0x5a4d5aed00000000, 0xee4ceeac00000000, 0x324e326e00000000,
    0x864f862f00000000, 0x894b895b00000000, 0x3d4a3d1a00000000,
    0xe148e1d800000000, 0x5549559900000000, 0x48da485a00000000,
    0xfcdbfc1b00000000, 0x20d920d900000000, 0x94d8949800000000,
    0x9bdc9bec00000000, 0x2fdd2fad00000000, 0xf3dff36f00000000,
    0x47de472e00000000, 0xedd7ed8700000000, 0x59d659c600000000,
    0x85d4850400000000, 0x31d5314500000000, 0x3ed13e3100000000,
    0x8ad08a7000000000, 0x56d256b200000000, 0xe2d3e2f300000000,
    0x01c1015100000000, 0xb5c0b51000000000, 0x69c269d200000000,
    0xddc3dd9300000000, 0xd2c7d2e700000000, 0x66c666a600000000,
    0xbac4ba6400000000, 0x0ec50e2500000000, 0xa4cca48c00000000,
    0x10cd10cd00000000, 0xcccfcc0f00000000, 0x78ce784e00000000,
    0x77ca773a00000000, 0xc3cbc37b00000000, 0x1fc91fb900000000,
    0xabc8abf800000000, 0xdaecda4c00000000, 0x6eed6e0d00000000,
    0xb2efb2cf00000000, 0x06ee068e00000000, 0x09ea09fa00000000,
    0xbdebbdbb00000000, 0x61e9617900000000, 0xd5e8d53800000000,
    0x7fe17f9100000000, 0xcbe0cbd000000000, 0x17e2171200000000,
    0xa3e3a35300000000, 0xace7ac2700000000, 0x18e6186600000000,
    0xc4e4c4a400000000, 0x70e570e500000000, 0x93f7934700000000,
    0x27f6270600000000, 0xfbf4fbc400000000, 0x4ff54f8500000000,
    0x40f140f100000000, 0xf4f0f4b000000000, 0x28f2287200000000,
    0x9cf39c3300000000, 0x36fa369a00000000, 0x82fb82db00000000,
    0x5ef95e1900000000, 0xeaf8ea5800000000, 0xe5fce52c00000000,
    0x51fd516d00000000, 0x8dff8daf00000000, 0x39fe39ee00000000,
    0x6cb76c7700000000, 0xd8b6d83600000000, 0x04b404f400000000,
    0xb0b5b0b500000000, 0xbfb1bfc100000000, 0x0bb00b8000000000,
    0xd7b2d74200000000, 0x63b3630300000000, 0xc9bac9aa00000000,
    0x7dbb7deb00000000, 0xa1b9a12900000000, 0x15b8156800000000,
    0x1abc1a1c00000000, 0xaebdae5d00000000, 0x72bf729f00000000,
    0xc6bec6de00000000, 0x25ac257c00000000, 0x91ad913d00000000,
    0x4daf4dff00000000, 0xf9aef9be00000000, 0xf6aaf6ca00000000,
    0x42ab428b00000000, 0x9ea99e4900000000, 0x2aa82a0800000000,
    0x80a180a100000000, 0x34a034e000000000, 0xe8a2e82200000000,
    0x5ca35c6300000000, 0x53a7531700000000, 0xe7a6e75600000000,
    0x3ba43b9400000000, 0x8fa58fd500000000, 0xfe81fe6100000000,
    0x4a804a2000000000, 0x968296e200000000, 0x228322a300000000,
    0x2d872dd700000000, 0x9986999600000000, 0x4584455400000000,
    0xf185f11500000000, 0x5b8c5bbc00000000, 0xef8deffd00000000,
    0x338f333f00000000, 0x878e877e00000000, 0x888a880a00000000,
    0x3c8b3c4b00000000, 0xe089e08900000000, 0x548854c800000000,
    0xb79ab76a00000000, 0x039b032b00000000, 0xdf99dfe900000000,
    0x6b986ba800000000, 0x649c64dc00000000, 0xd09dd09d00000000,
    0x0c9f0c5f00000000, 0xb89eb81e00000000, 0x129712b700000000,
    0xa696a6f600000000, 0x7a947a3400000000, 0xce95ce7500000000,
    0xc191c10100000000, 0x7590754000000000, 0xa992a98200000000,
    0x1d931dc300000000},
   {0x0000000000000000, 0x0100015100000000, 0x020002a200000000,
    0x030003f300000000, 0x070007f400000000, 0x060006a500000000,
    0x0500055600000000, 0x0400040700000000, 0x0d000d5800000000,
    0x0c000c0900000000, 0x0f000ffa00000000, 0x0e000eab00000000,
    0x0a000aac00000000, 0x0b000bfd00000000, 0x0800080e00000000,
    0x0900095f00000000, 0x1a001ab000000000, 0x1b001be100000000,
    0x1800181200000000, 0x1900194300000000, 0x1d001d4400000000,
    0x1c001c1500000000, 0x1f001fe600000000, 0x1e001eb700000000,
    0x170017e800000000, 0x160016b900000000, 0x1500154a00000000,
    0x1400141b00000000, 0x1000101c00000000, 0x1100114d00000000,
    0x120012be00000000, 0x130013ef00000000, 0x370037d000000000,
    0x3600368100000000, 0x3500357200000000, 0x3400342300000000,
    0x3000302400000000, 0x3100317500000000, 0x3200328600000000,
    0x330033d700000000, 0x3a003a8800000000, 0x3b003bd900000000,
    0x3800382a00000000, 0x3900397b00000000, 0x3d003d7c00000000,
    0x3c003c2d00000000, 0x3f003fde00000000, 0x3e003e8f00000000,
    0x2d002d6000000000, 0x2c002c3100000000, 0x2f002fc200000000,
    0x2e002e9300000000, 0x2a002a9400000000, 0x2b002bc500000000,
    0x2800283600000000, 0x2900296700000000, 0x2000203800000000,
    0x2100216900000000, 0x2200229a00000000, 0x230023cb00000000,
    0x270027cc00000000, 0x2600269d00000000, 0x2500256e00000000,
    0x2400243f00000000, 0x6d006d1000000000, 0x6c006c4100000000,
    0x6f006fb200000000, 0x6e006ee300000000, 0x6a006ae400000000,
    0x6b006bb500000000, 0x6800684600000000, 0x6900691700000000,
    0x6000604800000000, 0x6100611900000000, 0x620062ea00000000,
    0x630063bb00000000, 0x670067bc00000000, 0x660066ed00000000,
    0x6500651e00000000, 0x6400644f00000000, 0x770077a000000000,
    0x760076f100000000, 0x7500750200000000, 0x7400745300000000,
    0x7000705400000000, 0x7100710500000000, 0x720072f600000000,
    0x730073a700000000, 0x7a007af800000000, 0x7b007ba900000000,
    0x7800785a00000000, 0x7900790b00000000, 0x7d007d0c00000000,
    0x7c007c5d00000000, 0x7f007fae00000000, 0x7e007eff00000000,
    0x5a005ac000000000, 0x5b005b9100000000, 0x5800586200000000,
    0x5900593300000000, 0x5d005d3400000000, 0x5c005c6500000000,
    0x5f005f9600000000, 0x5e005ec700000000, 0x5700579800000000,
    0x560056c900000000, 0x5500553a00000000, 0x5400546b00000000,
    0x5000506c00000000, 0x5100513d00000000, 0x520052ce00000000,
    0x5300539f00000000, 0x4000407000000000, 0x4100412100000000,
    0x420042d200000000, 0x4300438300000000, 0x4700478400000000,
    0x460046d500000000, 0x4500452600000000, 0x4400447700000000,
    0x4d004d2800000000, 0x4c004c7900000000, 0x4f004f8a00000000,
    0x4e004edb00000000, 0x4a004adc00000000, 0x4b004b8d00000000,
    0x4800487e00000000, 0x4900492f00000000, 0xda00da2000000000,
    0xdb00db7100000000, 0xd800d88200000000, 0xd900d9d300000000,
    0xdd00ddd400000000, 0xdc00dc8500000000, 0xdf00df7600000000,
    0xde00de2700000000, 0xd700d77800000000, 0xd600d62900000000,
    0xd500d5da00000000, 0xd400d48b00000000, 0xd000d08c00000000,
    0xd100d1dd00000000, 0xd200d22e00000000, 0xd300d37f00000000,
    0xc000c09000000000, 0xc100c1c100000000, 0xc200c23200000000,
    0xc300c36300000000, 0xc700c76400000000, 0xc600c63500000000,
    0xc500c5c600000000, 0xc400c49700000000, 0xcd00cdc800000000,
    0xcc00cc9900000000, 0xcf00cf6a00000000, 0xce00ce3b00000000,
    0xca00ca3c00000000, 0xcb00cb6d00000000, 0xc800c89e00000000,
    0xc900c9cf00000000, 0xed00edf000000000, 0xec00eca100000000,
    0xef00ef5200000000, 0xee00ee0300000000, 0xea00ea0400000000,
    0xeb00eb5500000000, 0xe800e8a600000000, 0xe900e9f700000000,
    0xe000e0a800000000, 0xe100e1f900000000, 0xe200e20a00000000,
    0xe300e35b00000000, 0xe700e75c00000000, 0xe600e60d00000000,
    0xe500e5fe00000000, 0xe400e4af00000000, 0xf700f74000000000,
    0xf600f61100000000, 0xf500f5e200000000, 0xf400f4b300000000,
    0xf000f0b400000000, 0xf100f1e500000000, 0xf200f21600000000,
    0xf300f34700000000, 0xfa00fa1800000000, 0xfb00fb4900000000,
    0xf800f8ba00000000, 0xf900f9eb00000000, 0xfd00fdec00000000,
    0xfc00fcbd00000000, 0xff00ff4e00000000, 0xfe00fe1f00000000,
    0xb700b73000000000, 0xb600b66100000000, 0xb500b59200000000,
    0xb400b4c300000000, 0xb000b0c400000000, 0xb100b19500000000,
    0xb200b26600000000, 0xb300b33700000000, 0xba00ba6800000000,
    0xbb00bb3900000000, 0xb800b8ca00000000, 0xb900b99b00000000,
    0xbd00bd9c00000000, 0xbc00bccd00000000, 0xbf00bf3e00000000,
    0xbe00be6f00000000, 0xad00ad8000000000, 0xac00acd100000000,
    0xaf00af2200000000, 0xae00ae7300000000, 0xaa00aa7400000000,
    0xab00ab2500000000, 0xa800a8d600000000, 0xa900a98700000000,
    0xa000a0d800000000, 0xa100a18900000000, 0xa200a27a00000000,
    0xa300a32b00000000, 0xa700a72c00000000, 0xa600a67d00000000,
    0xa500a58e00000000, 0xa400a4df00000000, 0x800080e000000000,
    0x810081b100000000, 0x8200824200000000, 0x8300831300000000,
    0x8700871400000000, 0x8600864500000000, 0x850085b600000000,
    0x840084e700000000, 0x8d008db800000000, 0x8c008ce900000000,
    0x8f008f1a00000000, 0x8e008e4b00000000, 0x8a008a4c00000000,
    0x8b008b1d00000000, 0x880088ee00000000, 0x890089bf00000000,
    0x9a009a5000000000, 0x9b009b0100000000, 0x980098f200000000,
    0x990099a300000000, 0x9d009da400000000, 0x9c009cf500000000,
    0x9f009f0600000000, 0x9e009e5700000000, 0x9700970800000000,
    0x9600965900000000, 0x950095aa00000000, 0x940094fb00000000,
    0x900090fc00000000, 0x910091ad00000000, 0x9200925e00000000,
    0x9300930f00000000},
   {0x0000000000000000, 0x0100c09000000000, 0x0100839100000000,
    0x0000430100000000, 0x0100059300000000, 0x0000c50300000000,
    0x0000860200000000, 0x0100469200000000, 0x0100099600000000,
    0x0000c90600000000, 0x00008a0700000000, 0x01004a9700000000,
    0x00000c0500000000, 0x0100cc9500000000, 0x01008f9400000000,
    0x00004f0400000000, 0x0100119c00000000, 0x0000d10c00000000,
    0x0000920d00000000, 0x0100529d00000000, 0x0000140f00000000,
    0x0100d49f00000000, 0x0100979e00000000, 0x0000570e00000000,
    0x0000180a00000000, 0x0100d89a00000000, 0x01009b9b00000000,
    0x00005b0b00000000, 0x01001d9900000000, 0x0000dd0900000000,
    0x00009e0800000000, 0x01005e9800000000, 0x0100218800000000,
    0x0000e11800000000, 0x0000a21900000000, 0x0100628900000000,
    0x0000241b00000000, 0x0100e48b00000000, 0x0100a78a00000000,
    0x0000671a00000000, 0x0000281e00000000, 0x0100e88e00000000,
    0x0100ab8f00000000, 0x00006b1f00000000, 0x01002d8d00000000,
    0x0000ed1d00000000, 0x0000ae1c00000000, 0x01006e8c00000000,
    0x0000301400000000, 0x0100f08400000000, 0x0100b38500000000,
    0x0000731500000000, 0x0100358700000000, 0x0000f51700000000,
    0x0000b61600000000, 0x0100768600000000, 0x0100398200000000,
    0x0000f91200000000, 0x0000ba1300000000, 0x01007a8300000000,
    0x00003c1100000000, 0x0100fc8100000000, 0x0100bf8000000000,
    0x00007f1000000000, 0x010041a000000000, 0x0000813000000000,
    0x0000c23100000000, 0x010002a100000000, 0x0000443300000000,
    0x010084a300000000, 0x0100c7a200000000, 0x0000073200000000,
    0x0000483600000000, 0x010088a600000000, 0x0100cba700000000,
    0x00000b3700000000, 0x01004da500000000, 0x00008d3500000000,
    0x0000ce3400000000, 0x01000ea400000000, 0x0000503c00000000,
    0x010090ac00000000, 0x0100d3ad00000000, 0x0000133d00000000,
    0x010055af00000000, 0x0000953f00000000, 0x0000d63e00000000,
    0x010016ae00000000, 0x010059aa00000000, 0x0000993a00000000,
    0x0000da3b00000000, 0x01001aab00000000, 0x00005c3900000000,
    0x01009ca900000000, 0x0100dfa800000000, 0x00001f3800000000,
    0x0000602800000000, 0x0100a0b800000000, 0x0100e3b900000000,
    0x0000232900000000, 0x010065bb00000000, 0x0000a52b00000000,
    0x0000e62a00000000, 0x010026ba00000000, 0x010069be00000000,
    0x0000a92e00000000, 0x0000ea2f00000000, 0x01002abf00000000,
    0x00006c2d00000000, 0x0100acbd00000000, 0x0100efbc00000000,
    0x00002f2c00000000, 0x010071b400000000, 0x0000b12400000000,
    0x0000f22500000000, 0x010032b500000000, 0x0000742700000000,
    0x0100b4b700000000, 0x0100f7b600000000, 0x0000372600000000,
    0x0000782200000000, 0x0100b8b200000000, 0x0100fbb300000000,
    0x00003b2300000000, 0x01007db100000000, 0x0000bd2100000000,
    0x0000fe2000000000, 0x01003eb000000000, 0x010081f000000000,
    0x0000416000000000, 0x0000026100000000, 0x0100c2f100000000,
    0x0000846300000000, 0x010044f300000000, 0x010007f200000000,
    0x0000c76200000000, 0x0000886600000000, 0x010048f600000000,
    0x01000bf700000000, 0x0000cb6700000000, 0x01008df500000000,
    0x00004d6500000000, 0x00000e6400000000, 0x0100cef400000000,
    0x0000906c00000000, 0x010050fc00000000, 0x010013fd00000000,
    0x0000d36d00000000, 0x010095ff00000000, 0x0000556f00000000,
    0x0000166e00000000, 0x0100d6fe00000000, 0x010099fa00000000,
    0x0000596a00000000, 0x00001a6b00000000, 0x0100dafb00000000,
    0x00009c6900000000, 0x01005cf900000000, 0x01001ff800000000,
    0x0000df6800000000, 0x0000a07800000000, 0x010060e800000000,
    0x010023e900000000, 0x0000e37900000000, 0x0100a5eb00000000,
    0x0000657b00000000, 0x0000267a00000000, 0x0100e6ea00000000,
    0x0100a9ee00000000, 0x0000697e00000000, 0x00002a7f00000000,
    0x0100eaef00000000, 0x0000ac7d00000000, 0x01006ced00000000,
    0x01002fec00000000, 0x0000ef7c00000000, 0x0100b1e400000000,
    0x0000717400000000, 0x0000327500000000, 0x0100f2e500000000,
    0x0000b47700000000, 0x010074e700000000, 0x010037e600000000,
    0x0000f77600000000, 0x0000b87200000000, 0x010078e200000000,
    0x01003be300000000, 0x0000fb7300000000, 0x0100bde100000000,
    0x00007d7100000000, 0x00003e7000000000, 0x0100fee000000000,
    0x0000c05000000000, 0x010000c000000000, 0x010043c100000000,
    0x0000835100000000, 0x0100c5c300000000, 0x0000055300000000,
    0x0000465200000000, 0x010086c200000000, 0x0100c9c600000000,
    0x0000095600000000, 0x00004a5700000000, 0x01008ac700000000,
    0x0000cc5500000000, 0x01000cc500000000, 0x01004fc400000000,
    0x00008f5400000000, 0x0100d1cc00000000, 0x0000115c00000000,
    0x0000525d00000000, 0x010092cd00000000, 0x0000d45f00000000,
    0x010014cf00000000, 0x010057ce00000000, 0x0000975e00000000,
    0x0000d85a00000000, 0x010018ca00000000, 0x01005bcb00000000,
    0x00009b5b00000000, 0x0100ddc900000000, 0x00001d5900000000,
    0x00005e5800000000, 0x01009ec800000000, 0x0100e1d800000000,
    0x0000214800000000, 0x0000624900000000, 0x0100a2d900000000,
    0x0000e44b00000000, 0x010024db00000000, 0x010067da00000000,
    0x0000a74a00000000, 0x0000e84e00000000, 0x010028de00000000,
    0x01006bdf00000000, 0x0000ab4f00000000, 0x0100eddd00000000,
    0x00002d4d00000000, 0x00006e4c00000000, 0x0100aedc00000000,
    0x0000f04400000000, 0x010030d400000000, 0x010073d500000000,
    0x0000b34500000000, 0x0100f5d700000000, 0x0000354700000000,
    0x0000764600000000, 0x0100b6d600000000, 0x0100f9d200000000,
    0x0000394200000000, 0x00007a4300000000, 0x0100bad300000000,
    0x0000fc4100000000, 0x01003cd100000000, 0x01007fd000000000,
    0x0000bf4000000000},
   {0x0000000000000000, 0x01c1019000000000, 0x0182009000000000,
    0x0043010000000000, 0x0104029000000000, 0x00c5030000000000,
    0x0086020000000000, 0x0147039000000000, 0x0108079000000000,
    0x00c9060000000000, 0x008a070000000000, 0x014b069000000000,
    0x000c050000000000, 0x01cd049000000000, 0x018e059000000000,
    0x004f040000000000, 0x01100d9000000000, 0x00d10c0000000000,
    0x00920d0000000000, 0x01530c9000000000, 0x00140f0000000000,
    0x01d50e9000000000, 0x01960f9000000000, 0x00570e0000000000,
    0x00180a0000000000, 0x01d90b9000000000, 0x019a0a9000000000,
    0x005b0b0000000000, 0x011c089000000000, 0x00dd090000000000,
    0x009e080000000000, 0x015f099000000000, 0x0120199000000000,
    0x00e1180000000000, 0x00a2190000000000, 0x0163189000000000,
    0x00241b0000000000, 0x01e51a9000000000, 0x01a61b9000000000,
    0x00671a0000000000, 0x00281e0000000000, 0x01e91f9000000000,
    0x01aa1e9000000000, 0x006b1f0000000000, 0x012c1c9000000000,
    0x00ed1d0000000000, 0x00ae1c0000000000, 0x016f1d9000000000,
    0x0030140000000000, 0x01f1159000000000, 0x01b2149000000000,
    0x0073150000000000, 0x0134169000000000, 0x00f5170000000000,
    0x00b6160000000000, 0x0177179000000000, 0x0138139000000000,
    0x00f9120000000000, 0x00ba130000000000, 0x017b129000000000,
    0x003c110000000000, 0x01fd109000000000, 0x01be119000000000,
    0x007f100000000000, 0x0140319000000000, 0x0081300000000000,
    0x00c2310000000000, 0x0103309000000000, 0x0044330000000000,
    0x0185329000000000, 0x01c6339000000000, 0x0007320000000000,
    0x0048360000000000, 0x0189379000000000, 0x01ca369000000000,
    0x000b370000000000, 0x014c349000000000, 0x008d350000000000,
    0x00ce340000000000, 0x010f359000000000, 0x00503c0000000000,
    0x01913d9000000000, 0x01d23c9000000000, 0x00133d0000000000,
    0x01543e9000000000, 0x00953f0000000000, 0x00d63e0000000000,
    0x01173f9000000000, 0x01583b9000000000, 0x00993a0000000000,
    0x00da3b0000000000, 0x011b3a9000000000, 0x005c390000000000,
    0x019d389000000000, 0x01de399000000000, 0x001f380000000000,
    0x0060280000000000, 0x01a1299000000000, 0x01e2289000000000,
    0x0023290000000000, 0x01642a9000000000, 0x00a52b0000000000,
    0x00e62a0000000000, 0x01272b9000000000, 0x01682f9000000000,
    0x00a92e0000000000, 0x00ea2f0000000000, 0x012b2e9000000000,
    0x006c2d0000000000, 0x01ad2c9000000000, 0x01ee2d9000000000,
    0x002f2c0000000000, 0x0170259000000000, 0x00b1240000000000,
    0x00f2250000000000, 0x0133249000000000, 0x0074270000000000,
    0x01b5269000000000, 0x01f6279000000000, 0x0037260000000000,
    0x0078220000000000, 0x01b9239000000000, 0x01fa229000000000,
    0x003b230000000000, 0x017c209000000000, 0x00bd210000000000,
    0x00fe200000000000, 0x013f219000000000, 0x0180619000000000,
    0x0041600000000000, 0x0002610000000000, 0x01c3609000000000,
    0x0084630000000000, 0x0145629000000000, 0x0106639000000000,
    0x00c7620000000000, 0x0088660000000000, 0x0149679000000000,
    0x010a669000000000, 0x00cb670000000000, 0x018c649000000000,
    0x004d650000000000, 0x000e640000000000, 0x01cf659000000000,
    0x00906c0000000000, 0x01516d9000000000, 0x01126c9000000000,
    0x00d36d0000000000, 0x01946e9000000000, 0x00556f0000000000,
    0x00166e0000000000, 0x01d76f9000000000, 0x01986b9000000000,
    0x00596a0000000000, 0x001a6b0000000000, 0x01db6a9000000000,
    0x009c690000000000, 0x015d689000000000, 0x011e699000000000,
    0x00df680000000000, 0x00a0780000000000, 0x0161799000000000,
    0x0122789000000000, 0x00e3790000000000, 0x01a47a9000000000,
    0x00657b0000000000, 0x00267a0000000000, 0x01e77b9000000000,
    0x01a87f9000000000, 0x00697e0000000000, 0x002a7f0000000000,
    0x01eb7e9000000000, 0x00ac7d0000000000, 0x016d7c9000000000,
    0x012e7d9000000000, 0x00ef7c0000000000, 0x01b0759000000000,
    0x0071740000000000, 0x0032750000000000, 0x01f3749000000000,
    0x00b4770000000000, 0x0175769000000000, 0x0136779000000000,
    0x00f7760000000000, 0x00b8720000000000, 0x0179739000000000,
    0x013a729000000000, 0x00fb730000000000, 0x01bc709000000000,
    0x007d710000000000, 0x003e700000000000, 0x01ff719000000000,
    0x00c0500000000000, 0x0101519000000000, 0x0142509000000000,
    0x0083510000000000, 0x01c4529000000000, 0x0005530000000000,
    0x0046520000000000, 0x0187539000000000, 0x01c8579000000000,
    0x0009560000000000, 0x004a570000000000, 0x018b569000000000,
    0x00cc550000000000, 0x010d549000000000, 0x014e559000000000,
    0x008f540000000000, 0x01d05d9000000000, 0x00115c0000000000,
    0x00525d0000000000, 0x01935c9000000000, 0x00d45f0000000000,
    0x01155e9000000000, 0x01565f9000000000, 0x00975e0000000000,
    0x00d85a0000000000, 0x01195b9000000000, 0x015a5a9000000000,
    0x009b5b0000000000, 0x01dc589000000000, 0x001d590000000000,
    0x005e580000000000, 0x019f599000000000, 0x01e0499000000000,
    0x0021480000000000, 0x0062490000000000, 0x01a3489000000000,
    0x00e44b0000000000, 0x01254a9000000000, 0x01664b9000000000,
    0x00a74a0000000000, 0x00e84e0000000000, 0x01294f9000000000,
    0x016a4e9000000000, 0x00ab4f0000000000, 0x01ec4c9000000000,
    0x002d4d0000000000, 0x006e4c0000000000, 0x01af4d9000000000,
    0x00f0440000000000, 0x0131459000000000, 0x0172449000000000,
    0x00b3450000000000, 0x01f4469000000000, 0x0035470000000000,
    0x0076460000000000, 0x01b7479000000000, 0x01f8439000000000,
    0x0039420000000000, 0x007a430000000000, 0x01bb429000000000,
    0x00fc410000000000, 0x013d409000000000, 0x017e419000000000,
    0x00bf400000000000},
   {0x0000000000000000, 0xc000019000000000, 0x8301019000000000,
    0x4301000000000000, 0x0503019000000000, 0xc503000000000000,
    0x8602000000000000, 0x4602019000000000, 0x0906019000000000,
    0xc906000000000000, 0x8a07000000000000, 0x4a07019000000000,
    0x0c05000000000000, 0xcc05019000000000, 0x8f04019000000000,
    0x4f04000000000000, 0x110c019000000000, 0xd10c000000000000,
    0x920d000000000000, 0x520d019000000000, 0x140f000000000000,
    0xd40f019000000000, 0x970e019000000000, 0x570e000000000000,
    0x180a000000000000, 0xd80a019000000000, 0x9b0b019000000000,
    0x5b0b000000000000, 0x1d09019000000000, 0xdd09000000000000,
    0x9e08000000000000, 0x5e08019000000000, 0x2118019000000000,
    0xe118000000000000, 0xa219000000000000, 0x6219019000000000,
    0x241b000000000000, 0xe41b019000000000, 0xa71a019000000000,
    0x671a000000000000, 0x281e000000000000, 0xe81e019000000000,
    0xab1f019000000000, 0x6b1f000000000000, 0x2d1d019000000000,
    0xed1d000000000000, 0xae1c000000000000, 0x6e1c019000000000,
    0x3014000000000000, 0xf014019000000000, 0xb315019000000000,
    0x7315000000000000, 0x3517019000000000, 0xf517000000000000,
    0xb616000000000000, 0x7616019000000000, 0x3912019000000000,
    0xf912000000000000, 0xba13000000000000, 0x7a13019000000000,
    0x3c11000000000000, 0xfc11019000000000, 0xbf10019000000000,
    0x7f10000000000000, 0x4130019000000000, 0x8130000000000000,
    0xc231000000000000, 0x0231019000000000, 0x4433000000000000,
    0x8433019000000000, 0xc732019000000000, 0x0732000000000000,
    0x4836000000000000, 0x8836019000000000, 0xcb37019000000000,
    0x0b37000000000000, 0x4d35019000000000, 0x8d35000000000000,
    0xce34000000000000, 0x0e34019000000000, 0x503c000000000000,
    0x903c019000000000, 0xd33d019000000000, 0x133d000000000000,
    0x553f019000000000, 0x953f000000000000, 0xd63e000000000000,
    0x163e019000000000, 0x593a019000000000, 0x993a000000000000,
    0xda3b000000000000, 0x1a3b019000000000, 0x5c39000000000000,
    0x9c39019000000000, 0xdf38019000000000, 0x1f38000000000000,
    0x6028000000000000, 0xa028019000000000, 0xe329019000000000,
    0x2329000000000000, 0x652b019000000000, 0xa52b000000000000,
    0xe62a000000000000, 0x262a019000000000, 0x692e019000000000,
    0xa92e000000000000, 0xea2f000000000000, 0x2a2f019000000000,
    0x6c2d000000000000, 0xac2d019000000000, 0xef2c019000000000,
    0x2f2c000000000000, 0x7124019000000000, 0xb124000000000000,
    0xf225000000000000, 0x3225019000000000, 0x7427000000000000,
    0xb427019000000000, 0xf726019000000000, 0x3726000000000000,
    0x7822000000000000, 0xb822019000000000, 0xfb23019000000000,
    0x3b23000000000000, 0x7d21019000000000, 0xbd21000000000000,
    0xfe20000000000000, 0x3e20019000000000, 0x8160019000000000,
    0x4160000000000000, 0x0261000000000000, 0xc261019000000000,
    0x8463000000000000, 0x4463019000000000, 0x0762019000000000,
    0xc762000000000000, 0x8866000000000000, 0x4866019000000000,
    0x0b67019000000000, 0xcb67000000000000, 0x8d65019000000000,
    0x4d65000000000000, 0x0e64000000000000, 0xce64019000000000,
    0x906c000000000000, 0x506c019000000000, 0x136d019000000000,
    0xd36d000000000000, 0x956f019000000000, 0x556f000000000000,
    0x166e000000000000, 0xd66e019000000000, 0x996a019000000000,
    0x596a000000000000, 0x1a6b000000000000, 0xda6b019000000000,
    0x9c69000000000000, 0x5c69019000000000, 0x1f68019000000000,
    0xdf68000000000000, 0xa078000000000000, 0x6078019000000000,
    0x2379019000000000, 0xe379000000000000, 0xa57b019000000000,
    0x657b000000000000, 0x267a000000000000, 0xe67a019000000000,
    0xa97e019000000000, 0x697e000000000000, 0x2a7f000000000000,
    0xea7f019000000000, 0xac7d000000000000, 0x6c7d019000000000,
    0x2f7c019000000000, 0xef7c000000000000, 0xb174019000000000,
    0x7174000000000000, 0x3275000000000000, 0xf275019000000000,
    0xb477000000000000, 0x7477019000000000, 0x3776019000000000,
    0xf776000000000000, 0xb872000000000000, 0x7872019000000000,
    0x3b73019000000000, 0xfb73000000000000, 0xbd71019000000000,
    0x7d71000000000000, 0x3e70000000000000, 0xfe70019000000000,
    0xc050000000000000, 0x0050019000000000, 0x4351019000000000,
    0x8351000000000000, 0xc553019000000000, 0x0553000000000000,
    0x4652000000000000, 0x8652019000000000, 0xc956019000000000,
    0x0956000000000000, 0x4a57000000000000, 0x8a57019000000000,
    0xcc55000000000000, 0x0c55019000000000, 0x4f54019000000000,
    0x8f54000000000000, 0xd15c019000000000, 0x115c000000000000,
    0x525d000000000000, 0x925d019000000000, 0xd45f000000000000,
    0x145f019000000000, 0x575e019000000000, 0x975e000000000000,
    0xd85a000000000000, 0x185a019000000000, 0x5b5b019000000000,
    0x9b5b000000000000, 0xdd59019000000000, 0x1d59000000000000,
    0x5e58000000000000, 0x9e58019000000000, 0xe148019000000000,
    0x2148000000000000, 0x6249000000000000, 0xa249019000000000,
    0xe44b000000000000, 0x244b019000000000, 0x674a019000000000,
    0xa74a000000000000, 0xe84e000000000000, 0x284e019000000000,
    0x6b4f019000000000, 0xab4f000000000000, 0xed4d019000000000,
    0x2d4d000000000000, 0x6e4c000000000000, 0xae4c019000000000,
    0xf044000000000000, 0x3044019000000000, 0x7345019000000000,
    0xb345000000000000, 0xf547019000000000, 0x3547000000000000,
    0x7646000000000000, 0xb646019000000000, 0xf942019000000000,
    0x3942000000000000, 0x7a43000000000000, 0xba43019000000000,
    0xfc41000000000000, 0x3c41019000000000, 0x7f40019000000000,
    0xbf40000000000000},
   {0x0000000000000000, 0x00c1906c00000000, 0x008221d900000000,
    0x0043b1b500000000, 0x0304400200000000, 0x03c5d06e00000000,
    0x038661db00000000, 0x0347f1b700000000, 0x0608800400000000,
    0x06c9106800000000, 0x068aa1dd00000000, 0x064b31b100000000,
    0x050cc00600000000, 0x05cd506a00000000, 0x058ee1df00000000,
    0x054f71b300000000, 0x0c10000900000000, 0x0cd1906500000000,
    0x0c9221d000000000, 0x0c53b1bc00000000, 0x0f14400b00000000,
    0x0fd5d06700000000, 0x0f9661d200000000, 0x0f57f1be00000000,
    0x0a18800d00000000, 0x0ad9106100000000, 0x0a9aa1d400000000,
    0x0a5b31b800000000, 0x091cc00f00000000, 0x09dd506300000000,
    0x099ee1d600000000, 0x095f71ba00000000, 0x1820001200000000,
    0x18e1907e00000000, 0x18a221cb00000000, 0x1863b1a700000000,
    0x1b24401000000000, 0x1be5d07c00000000, 0x1ba661c900000000,
    0x1b67f1a500000000, 0x1e28801600000000, 0x1ee9107a00000000,
    0x1eaaa1cf00000000, 0x1e6b31a300000000, 0x1d2cc01400000000,
    0x1ded507800000000, 0x1daee1cd00000000, 0x1d6f71a100000000,
    0x1430001b00000000, 0x14f1907700000000, 0x14b221c200000000,
    0x1473b1ae00000000, 0x1734401900000000, 0x17f5d07500000000,
    0x17b661c000000000, 0x1777f1ac00000000, 0x1238801f00000000,
    0x12f9107300000000, 0x12baa1c600000000, 0x127b31aa00000000,
    0x113cc01d00000000, 0x11fd507100000000, 0x11bee1c400000000,
    0x117f71a800000000, 0x3040002400000000, 0x3081904800000000,
    0x30c221fd00000000, 0x3003b19100000000, 0x3344402600000000,
    0x3385d04a00000000, 0x33c661ff00000000, 0x3307f19300000000,
    0x3648802000000000, 0x3689104c00000000, 0x36caa1f900000000,
    0x360b319500000000, 0x354cc02200000000, 0x358d504e00000000,
    0x35cee1fb00000000, 0x350f719700000000, 0x3c50002d00000000,
    0x3c91904100000000, 0x3cd221f400000000, 0x3c13b19800000000,
    0x3f54402f00000000, 0x3f95d04300000000, 0x3fd661f600000000,
    0x3f17f19a00000000, 0x3a58802900000000, 0x3a99104500000000,
    0x3adaa1f000000000, 0x3a1b319c00000000, 0x395cc02b00000000,
    0x399d504700000000, 0x39dee1f200000000, 0x391f719e00000000,
    0x2860003600000000, 0x28a1905a00000000, 0x28e221ef00000000,
    0x2823b18300000000, 0x2b64403400000000, 0x2ba5d05800000000,
    0x2be661ed00000000, 0x2b27f18100000000, 0x2e68803200000000,
    0x2ea9105e00000000, 0x2eeaa1eb00000000, 0x2e2b318700000000,
    0x2d6cc03000000000, 0x2dad505c00000000, 0x2deee1e900000000,
    0x2d2f718500000000, 0x2470003f00000000, 0x24b1905300000000,
    0x24f221e600000000, 0x2433b18a00000000, 0x2774403d00000000,
    0x27b5d05100000000, 0x27f661e400000000, 0x2737f18800000000,
    0x2278803b00000000, 0x22b9105700000000, 0x22faa1e200000000,
    0x223b318e00000000, 0x217cc03900000000, 0x21bd505500000000,
    0x21fee1e000000000, 0x213f718c00000000, 0x6080004800000000,
    0x6041902400000000, 0x6002219100000000, 0x60c3b1fd00000000,
    0x6384404a00000000, 0x6345d02600000000, 0x6306619300000000,
    0x63c7f1ff00000000, 0x6688804c00000000, 0x6649102000000000,
    0x660aa19500000000, 0x66cb31f900000000, 0x658cc04e00000000,
    0x654d502200000000, 0x650ee19700000000, 0x65cf71fb00000000,
    0x6c90004100000000, 0x6c51902d00000000, 0x6c12219800000000,
    0x6cd3b1f400000000, 0x6f94404300000000, 0x6f55d02f00000000,
    0x6f16619a00000000, 0x6fd7f1f600000000, 0x6a98804500000000,
    0x6a59102900000000, 0x6a1aa19c00000000, 0x6adb31f000000000,
    0x699cc04700000000, 0x695d502b00000000, 0x691ee19e00000000,
    0x69df71f200000000, 0x78a0005a00000000, 0x7861903600000000,
    0x7822218300000000, 0x78e3b1ef00000000, 0x7ba4405800000000,
    0x7b65d03400000000, 0x7b26618100000000, 0x7be7f1ed00000000,
    0x7ea8805e00000000, 0x7e69103200000000, 0x7e2aa18700000000,
    0x7eeb31eb00000000, 0x7dacc05c00000000, 0x7d6d503000000000,
    0x7d2ee18500000000, 0x7def71e900000000, 0x74b0005300000000,
    0x7471903f00000000, 0x7432218a00000000, 0x74f3b1e600000000,
    0x77b4405100000000, 0x7775d03d00000000, 0x7736618800000000,
    0x77f7f1e400000000, 0x72b8805700000000, 0x7279103b00000000,
    0x723aa18e00000000, 0x72fb31e200000000, 0x71bcc05500000000,
    0x717d503900000000, 0x713ee18c00000000, 0x71ff71e000000000,
    0x50c0006c00000000, 0x5001900000000000, 0x504221b500000000,
    0x5083b1d900000000, 0x53c4406e00000000, 0x5305d00200000000,
    0x534661b700000000, 0x5387f1db00000000, 0x56c8806800000000,
    0x5609100400000000, 0x564aa1b100000000, 0x568b31dd00000000,
    0x55ccc06a00000000, 0x550d500600000000, 0x554ee1b300000000,
    0x558f71df00000000, 0x5cd0006500000000, 0x5c11900900000000,
    0x5c5221bc00000000, 0x5c93b1d000000000, 0x5fd4406700000000,
    0x5f15d00b00000000, 0x5f5661be00000000, 0x5f97f1d200000000,
    0x5ad8806100000000, 0x5a19100d00000000, 0x5a5aa1b800000000,
    0x5a9b31d400000000, 0x59dcc06300000000, 0x591d500f00000000,
    0x595ee1ba00000000, 0x599f71d600000000, 0x48e0007e00000000,
    0x4821901200000000, 0x486221a700000000, 0x48a3b1cb00000000,
    0x4be4407c00000000, 0x4b25d01000000000, 0x4b6661a500000000,
    0x4ba7f1c900000000, 0x4ee8807a00000000, 0x4e29101600000000,
    0x4e6aa1a300000000, 0x4eab31cf00000000, 0x4decc07800000000,
    0x4d2d501400000000, 0x4d6ee1a100000000, 0x4daf71cd00000000,
    0x44f0007700000000, 0x4431901b00000000, 0x447221ae00000000,
    0x44b3b1c200000000, 0x47f4407500000000, 0x4735d01900000000,
    0x477661ac00000000, 0x47b7f1c000000000, 0x42f8807300000000,
    0x4239101f00000000, 0x427aa1aa00000000, 0x42bb31c600000000,
    0x41fcc07100000000, 0x413d501d00000000, 0x417ee1a800000000,
    0x41bf71c400000000}};

#else /* W == 4 */

static const crc_t crc_braid_table[][256] = {
   {0x00000000, 0x65904101, 0xcb208202, 0xaeb0c303, 0x26420407,
    0x43d24506, 0xed628605, 0x88f2c704, 0x4c84080e, 0x2914490f,
    0x87a48a0c, 0xe234cb0d, 0x6ac60c09, 0x0f564d08, 0xa1e68e0b,
    0xc476cf0a, 0x9908101c, 0xfc98511d, 0x5228921e, 0x37b8d31f,
    0xbf4a141b, 0xdada551a, 0x746a9619, 0x11fad718, 0xd58c1812,
    0xb01c5913, 0x1eac9a10, 0x7b3cdb11, 0xf3ce1c15, 0x965e5d14,
    0x38ee9e17, 0x5d7edf16, 0x8213203b, 0xe783613a, 0x4933a239,
    0x2ca3e338, 0xa451243c, 0xc1c1653d, 0x6f71a63e, 0x0ae1e73f,
    0xce972835, 0xab076934, 0x05b7aa37, 0x6027eb36, 0xe8d52c32,
    0x8d456d33, 0x23f5ae30, 0x4665ef31, 0x1b1b3027, 0x7e8b7126,
    0xd03bb225, 0xb5abf324, 0x3d593420, 0x58c97521, 0xf679b622,
    0x93e9f723, 0x579f3829, 0x320f7928, 0x9cbfba2b, 0xf92ffb2a,
    0x71dd3c2e, 0x144d7d2f, 0xbafdbe2c, 0xdf6dff2d, 0xb4254075,
    0xd1b50174, 0x7f05c277, 0x1a958376, 0x92674472, 0xf7f70573,
    0x5947c670, 0x3cd78771, 0xf8a1487b, 0x9d31097a, 0x3381ca79,
    0x56118b78, 0xdee34c7c, 0xbb730d7d, 0x15c3ce7e, 0x70538f7f,
    0x2d2d5069, 0x48bd1168, 0xe60dd26b, 0x839d936a, 0x0b6f546e,
    0x6eff156f, 0xc04fd66c, 0xa5df976d, 0x61a95867, 0x04391966,
    0xaa89da65, 0xcf199b64, 0x47eb5c60, 0x227b1d61, 0x8ccbde62,
    0xe95b9f63, 0x3636604e, 0x53a6214f, 0xfd16e24c, 0x9886a34d,
    0x10746449, 0x75e42548, 0xdb54e64b, 0xbec4a74a, 0x7ab26840,
    0x1f222941, 0xb192ea42, 0xd402ab43, 0x5cf06c47, 0x39602d46,
    0x97d0ee45, 0xf240af44, 0xaf3e7052, 0xcaae3153, 0x641ef250,
    0x018eb351, 0x897c7455, 0xecec3554, 0x425cf657, 0x27ccb756,
    0xe3ba785c, 0x862a395d, 0x289afa5e, 0x4d0abb5f, 0xc5f87c5b,
    0xa0683d5a, 0x0ed8fe59, 0x6b48bf58, 0xd84980e9, 0xbdd9c1e8,
    0x136902eb, 0x76f943ea, 0xfe0b84ee, 0x9b9bc5ef, 0x352b06ec,
    0x50bb47ed, 0x94cd88e7, 0xf15dc9e6, 0x5fed0ae5, 0x3a7d4be4,
    0xb28f8ce0, 0xd71fcde1, 0x79af0ee2, 0x1c3f4fe3, 0x414190f5,
    0x24d1d1f4, 0x8a6112f7, 0xeff153f6, 0x670394f2, 0x0293d5f3,
    0xac2316f0, 0xc9b357f1, 0x0dc598fb, 0x6855d9fa, 0xc6e51af9,
    0xa3755bf8, 0x2b879cfc, 0x4e17ddfd, 0xe0a71efe, 0x85375fff,
    0x5a5aa0d2, 0x3fcae1d3, 0x917a22d0, 0xf4ea63d1, 0x7c18a4d5,
    0x1988e5d4, 0xb73826d7, 0xd2a867d6, 0x16dea8dc, 0x734ee9dd,
    0xddfe2ade, 0xb86e6bdf, 0x309cacdb, 0x550cedda, 0xfbbc2ed9,
    0x9e2c6fd8, 0xc352b0ce, 0xa6c2f1cf, 0x087232cc, 0x6de273cd,
    0xe510b4c9, 0x8080f5c8, 0x2e3036cb, 0x4ba077ca, 0x8fd6b8c0,
    0xea46f9c1, 0x44f63ac2, 0x21667bc3, 0xa994bcc7, 0xcc04fdc6,
    0x62b43ec5, 0x07247fc4, 0x6c6cc09c, 0x09fc819d, 0xa74c429e,
    0xc2dc039f, 0x4a2ec49b, 0x2fbe859a, 0x810e4699, 0xe49e0798,
    0x20e8c892, 0x45788993, 0xebc84a90, 0x8e580b91, 0x06aacc95,
    0x633a8d94, 0xcd8a4e97, 0xa81a0f96, 0xf564d080, 0x90f49181,
    0x3e445282, 0x5bd41383, 0xd326d487, 0xb6b69586, 0x18065685,
    0x7d961784, 0xb9e0d88e, 0xdc70998f, 0x72c05a8c, 0x17501b8d,
    0x9fa2dc89, 0xfa329d88, 0x54825e8b, 0x31121f8a, 0xee7fe0a7,
    0x8befa1a6, 0x255f62a5, 0x40cf23a4, 0xc83de4a0, 0xadada5a1,
    0x031d66a2, 0x668d27a3, 0xa2fbe8a9, 0xc76ba9a8, 0x69db6aab,
    0x0c4b2baa, 0x84b9ecae, 0xe129adaf, 0x4f996eac, 0x2a092fad,
    0x7777f0bb, 0x12e7b1ba, 0xbc5772b9, 0xd9c733b8, 0x5135f4bc,
    0x34a5b5bd, 0x9a1576be, 0xff8537bf, 0x3bf3f8b5, 0x5e63b9b4,
    0xf0d37ab7, 0x95433bb6, 0x1db1fcb2, 0x7821bdb3, 0xd6917eb0,
    0xb3013fb1},
   {0x00000000, 0x009001d1, 0x012003a2, 0x01b00273, 0x02400744,
    0x02d00695, 0x036004e6, 0x03f00537, 0x04800e88, 0x04100f59,
    0x05a00d2a, 0x05300cfb, 0x06c009cc, 0x0650081d, 0x07e00a6e,
    0x07700bbf, 0x09001d10, 0x09901cc1, 0x08201eb2, 0x08b01f63,
    0x0b401a54, 0x0bd01b85, 0x0a6019f6, 0x0af01827, 0x0d801398,
    0x0d101249, 0x0ca0103a, 0x0c3011eb, 0x0fc014dc, 0x0f50150d,
    0x0ee0177e, 0x0e7016af, 0x12003a20, 0x12903bf1, 0x13203982,
    0x13b03853, 0x10403d64, 0x10d03cb5, 0x11603ec6, 0x11f03f17,
    0x168034a8, 0x16103579, 0x17a0370a, 0x173036db, 0x14c033ec,
    0x1450323d, 0x15e0304e, 0x1570319f, 0x1b002730, 0x1b9026e1,
    0x1a202492, 0x1ab02543, 0x19402074, 0x19d021a5, 0x186023d6,
    0x18f02207, 0x1f8029b8, 0x1f102869, 0x1ea02a1a, 0x1e302bcb,
    0x1dc02efc, 0x1d502f2d, 0x1ce02d5e, 0x1c702c8f, 0x24007440,
    0x24907591, 0x252077e2, 0x25b07633, 0x26407304, 0x26d072d5,
    0x276070a6, 0x27f07177, 0x20807ac8, 0x20107b19, 0x21a0796a,
    0x213078bb, 0x22c07d8c, 0x22507c5d, 0x23e07e2e, 0x23707fff,
    0x2d006950, 0x2d906881, 0x2c206af2, 0x2cb06b23, 0x2f406e14,
    0x2fd06fc5, 0x2e606db6, 0x2ef06c67, 0x298067d8, 0x29106609,
    0x28a0647a, 0x283065ab, 0x2bc0609c, 0x2b50614d, 0x2ae0633e,
    0x2a7062ef, 0x36004e60, 0x36904fb1, 0x37204dc2, 0x37b04c13,
    0x34404924, 0x34d048f5, 0x35604a86, 0x35f04b57, 0x328040e8,
    0x32104139, 0x33a0434a, 0x3330429b, 0x30c047ac, 0x3050467d,
    0x31e0440e, 0x317045df, 0x3f005370, 0x3f9052a1, 0x3e2050d2,
    0x3eb05103, 0x3d405434, 0x3dd055e5, 0x3c605796, 0x3cf05647,
    0x3b805df8, 0x3b105c29, 0x3aa05e5a, 0x3a305f8b, 0x39c05abc,
    0x39505b6d, 0x38e0591e, 0x387058cf, 0x4800e880, 0x4890e951,
    0x4920eb22, 0x49b0eaf3, 0x4a40efc4, 0x4ad0ee15, 0x4b60ec66,
    0x4bf0edb7, 0x4c80e608, 0x4c10e7d9, 0x4da0e5aa, 0x4d30e47b,
    0x4ec0e14c, 0x4e50e09d, 0x4fe0e2ee, 0x4f70e33f, 0x4100f590,
    0x4190f441, 0x4020f632, 0x40b0f7e3, 0x4340f2d4, 0x43d0f305,
    0x4260f176, 0x42f0f0a7, 0x4580fb18, 0x4510fac9, 0x44a0f8ba,
    0x4430f96b, 0x47c0fc5c, 0x4750fd8d, 0x46e0fffe, 0x4670fe2f,
    0x5a00d2a0, 0x5a90d371, 0x5b20d102, 0x5bb0d0d3, 0x5840d5e4,
    0x58d0d435, 0x5960d646, 0x59f0d797, 0x5e80dc28, 0x5e10ddf9,
    0x5fa0df8a, 0x5f30de5b, 0x5cc0db6c, 0x5c50dabd, 0x5de0d8ce,
    0x5d70d91f, 0x5300cfb0, 0x5390ce61, 0x5220cc12, 0x52b0cdc3,
    0x5140c8f4, 0x51d0c925, 0x5060cb56, 0x50f0ca87, 0x5780c138,
    0x5710c0e9, 0x56a0c29a, 0x5630c34b, 0x55c0c67c, 0x5550c7ad,
    0x54e0c5de, 0x5470c40f, 0x6c009cc0, 0x6c909d11, 0x6d209f62,
    0x6db09eb3, 0x6e409b84, 0x6ed09a55, 0x6f609826, 0x6ff099f7,
    0x68809248, 0x68109399, 0x69a091ea, 0x6930903b, 0x6ac0950c,
    0x6a5094dd, 0x6be096ae, 0x6b70977f, 0x650081d0, 0x65908001,
    0x64208272, 0x64b083a3, 0x67408694, 0x67d08745, 0x66608536,
    0x66f084e7, 0x61808f58, 0x61108e89, 0x60a08cfa, 0x60308d2b,
    0x63c0881c, 0x635089cd, 0x62e08bbe, 0x62708a6f, 0x7e00a6e0,
    0x7e90a731, 0x7f20a542, 0x7fb0a493, 0x7c40a1a4, 0x7cd0a075,
    0x7d60a206, 0x7df0a3d7, 0x7a80a868, 0x7a10a9b9, 0x7ba0abca,
    0x7b30aa1b, 0x78c0af2c, 0x7850aefd, 0x79e0ac8e, 0x7970ad5f,
    0x7700bbf0, 0x7790ba21, 0x7620b852, 0x76b0b983, 0x7540bcb4,
    0x75d0bd65, 0x7460bf16, 0x74f0bec7, 0x7380b578, 0x7310b4a9,
    0x72a0b6da, 0x7230b70b, 0x71c0b23c, 0x7150b3ed, 0x70e0b19e,
    0x7070b04f},
   {0x00000000, 0x9001d100, 0x9000a203, 0x00017303, 0x90024405,
    0x00039505, 0x0002e606, 0x90033706, 0x90078809, 0x00065909,
    0x00072a0a, 0x9006fb0a, 0x0005cc0c, 0x90041d0c, 0x90056e0f,
    0x0004bf0f, 0x900c1011, 0x000dc111, 0x000cb212, 0x900d6312,
    0x000e5414, 0x900f8514, 0x900ef617, 0x000f2717, 0x000b9818,
    0x900a4918, 0x900b3a1b, 0x000aeb1b, 0x9009dc1d, 0x00080d1d,
    0x00097e1e, 0x9008af1e, 0x901b2021, 0x001af121, 0x001b8222,
    0x901a5322, 0x00196424, 0x9018b524, 0x9019c627, 0x00181727,
    0x001ca828, 0x901d7928, 0x901c0a2b, 0x001ddb2b, 0x901eec2d,
    0x001f3d2d, 0x001e4e2e, 0x901f9f2e, 0x00173030, 0x9016e130,
    0x90179233, 0x00164333, 0x90157435, 0x0014a535, 0x0015d636,
    0x90140736, 0x9010b839, 0x00116939, 0x00101a3a, 0x9011cb3a,
    0x0012fc3c, 0x90132d3c, 0x90125e3f, 0x00138f3f, 0x90354041,
    0x00349141, 0x0035e242, 0x90343342, 0x00370444, 0x9036d544,
    0x9037a647, 0x00367747, 0x0032c848, 0x90331948, 0x90326a4b,
    0x0033bb4b, 0x90308c4d, 0x00315d4d, 0x00302e4e, 0x9031ff4e,
    0x00395050, 0x90388150, 0x9039f253, 0x00382353, 0x903b1455,
    0x003ac555, 0x003bb656, 0x903a6756, 0x903ed859, 0x003f0959,
    0x003e7a5a, 0x903fab5a, 0x003c9c5c, 0x903d4d5c, 0x903c3e5f,
    0x003def5f, 0x002e6060, 0x902fb160, 0x902ec263, 0x002f1363,
    0x902c2465, 0x002df565, 0x002c8666, 0x902d5766, 0x9029e869,
    0x00283969, 0x00294a6a, 0x90289b6a, 0x002bac6c, 0x902a7d6c,
    0x902b0e6f, 0x002adf6f, 0x90227071, 0x0023a171, 0x0022d272,
    0x90230372, 0x00203474, 0x9021e574, 0x90209677, 0x00214777,
    0x0025f878, 0x90242978, 0x90255a7b, 0x00248b7b, 0x9027bc7d,
    0x00266d7d, 0x00271e7e, 0x9026cf7e, 0x90698081, 0x00685181,
    0x00692282, 0x9068f382, 0x006bc484, 0x906a1584, 0x906b6687,
    0x006ab787, 0x006e0888, 0x906fd988, 0x906eaa8b, 0x006f7b8b,
    0x906c4c8d, 0x006d9d8d, 0x006cee8e, 0x906d3f8e, 0x00659090,
    0x90644190, 0x90653293, 0x0064e393, 0x9067d495, 0x00660595,
    0x00677696, 0x9066a796, 0x90621899, 0x0063c999, 0x0062ba9a,
    0x90636b9a, 0x00605c9c, 0x90618d9c, 0x9060fe9f, 0x00612f9f,
    0x0072a0a0, 0x907371a0, 0x907202a3, 0x0073d3a3, 0x9070e4a5,
    0x007135a5, 0x007046a6, 0x907197a6, 0x907528a9, 0x0074f9a9,
    0x00758aaa, 0x90745baa, 0x00776cac, 0x9076bdac, 0x9077ceaf,
    0x00761faf, 0x907eb0b1, 0x007f61b1, 0x007e12b2, 0x907fc3b2,
    0x007cf4b4, 0x907d25b4, 0x907c56b7, 0x007d87b7, 0x007938b8,
    0x9078e9b8, 0x90799abb, 0x00784bbb, 0x907b7cbd, 0x007aadbd,
    0x007bdebe, 0x907a0fbe, 0x005cc0c0, 0x905d11c0, 0x905c62c3,
    0x005db3c3, 0x905e84c5, 0x005f55c5, 0x005e26c6, 0x905ff7c6,
    0x905b48c9, 0x005a99c9, 0x005beaca, 0x905a3bca, 0x00590ccc,
    0x9058ddcc, 0x9059aecf, 0x00587fcf, 0x9050d0d1, 0x005101d1,
    0x005072d2, 0x9051a3d2, 0x005294d4, 0x905345d4, 0x905236d7,
    0x0053e7d7, 0x005758d8, 0x905689d8, 0x9057fadb, 0x00562bdb,
    0x90551cdd, 0x0054cddd, 0x0055bede, 0x90546fde, 0x9047e0e1,
    0x004631e1, 0x004742e2, 0x904693e2, 0x0045a4e4, 0x904475e4,
    0x904506e7, 0x0044d7e7, 0x004068e8, 0x9041b9e8, 0x9040caeb,
    0x00411beb, 0x90422ced, 0x0043fded, 0x00428eee, 0x90435fee,
    0x004bf0f0, 0x904a21f0, 0x904b52f3, 0x004a83f3, 0x9049b4f5,
    0x004865f5, 0x004916f6, 0x9048c7f6, 0x904c78f9, 0x004da9f9,
    0x004cdafa, 0x904d0bfa, 0x004e3cfc, 0x904fedfc, 0x904e9eff,
    0x004f4fff},
   {0x00000000, 0x90d00101, 0x91a30201, 0x01730300, 0x93450401,
    0x03950500, 0x02e60600, 0x92360701, 0x96890801, 0x06590900,
    0x072a0a00, 0x97fa0b01, 0x05cc0c00, 0x951c0d01, 0x946f0e01,
    0x04bf0f00, 0x9d111001, 0x0dc11100, 0x0cb21200, 0x9c621301,
    0x0e541400, 0x9e841501, 0x9ff71601, 0x0f271700, 0x0b981800,
    0x9b481901, 0x9a3b1a01, 0x0aeb1b00, 0x98dd1c01, 0x080d1d00,
    0x097e1e00, 0x99ae1f01, 0x8a212001, 0x1af12100, 0x1b822200,
    0x8b522301, 0x19642400, 0x89b42501, 0x88c72601, 0x18172700,
    0x1ca82800, 0x8c782901, 0x8d0b2a01, 0x1ddb2b00, 0x8fed2c01,
    0x1f3d2d00, 0x1e4e2e00, 0x8e9e2f01, 0x17303000, 0x87e03101,
    0x86933201, 0x16433300, 0x84753401, 0x14a53500, 0x15d63600,
    0x85063701, 0x81b93801, 0x11693900, 0x101a3a00, 0x80ca3b01,
    0x12fc3c00, 0x822c3d01, 0x835f3e01, 0x138f3f00, 0xa4414001,
    0x34914100, 0x35e24200, 0xa5324301, 0x37044400, 0xa7d44501,
    0xa6a74601, 0x36774700, 0x32c84800, 0xa2184901, 0xa36b4a01,
    0x33bb4b00, 0xa18d4c01, 0x315d4d00, 0x302e4e00, 0xa0fe4f01,
    0x39505000, 0xa9805101, 0xa8f35201, 0x38235300, 0xaa155401,
    0x3ac55500, 0x3bb65600, 0xab665701, 0xafd95801, 0x3f095900,
    0x3e7a5a00, 0xaeaa5b01, 0x3c9c5c00, 0xac4c5d01, 0xad3f5e01,
    0x3def5f00, 0x2e606000, 0xbeb06101, 0xbfc36201, 0x2f136300,
    0xbd256401, 0x2df56500, 0x2c866600, 0xbc566701, 0xb8e96801,
    0x28396900, 0x294a6a00, 0xb99a6b01, 0x2bac6c00, 0xbb7c6d01,
    0xba0f6e01, 0x2adf6f00, 0xb3717001, 0x23a17100, 0x22d27200,
    0xb2027301, 0x20347400, 0xb0e47501, 0xb1977601, 0x21477700,
    0x25f87800, 0xb5287901, 0xb45b7a01, 0x248b7b00, 0xb6bd7c01,
    0x266d7d00, 0x271e7e00, 0xb7ce7f01, 0xf8818001, 0x68518100,
    0x69228200, 0xf9f28301, 0x6bc48400, 0xfb148501, 0xfa678601,
    0x6ab78700, 0x6e088800, 0xfed88901, 0xffab8a01, 0x6f7b8b00,
    0xfd4d8c01, 0x6d9d8d00, 0x6cee8e00, 0xfc3e8f01, 0x65909000,
    0xf5409101, 0xf4339201, 0x64e39300, 0xf6d59401, 0x66059500,
    0x67769600, 0xf7a69701, 0xf3199801, 0x63c99900, 0x62ba9a00,
    0xf26a9b01, 0x605c9c00, 0xf08c9d01, 0xf1ff9e01, 0x612f9f00,
    0x72a0a000, 0xe270a101, 0xe303a201, 0x73d3a300, 0xe1e5a401,
    0x7135a500, 0x7046a600, 0xe096a701, 0xe429a801, 0x74f9a900,
    0x758aaa00, 0xe55aab01, 0x776cac00, 0xe7bcad01, 0xe6cfae01,
    0x761faf00, 0xefb1b001, 0x7f61b100, 0x7e12b200, 0xeec2b301,
    0x7cf4b400, 0xec24b501, 0xed57b601, 0x7d87b700, 0x7938b800,
    0xe9e8b901, 0xe89bba01, 0x784bbb00, 0xea7dbc01, 0x7aadbd00,
    0x7bdebe00, 0xeb0ebf01, 0x5cc0c000, 0xcc10c101, 0xcd63c201,
    0x5db3c300, 0xcf85c401, 0x5f55c500, 0x5e26c600, 0xcef6c701,
    0xca49c801, 0x5a99c900, 0x5beaca00, 0xcb3acb01, 0x590ccc00,
    0xc9dccd01, 0xc8afce01, 0x587fcf00, 0xc1d1d001, 0x5101d100,
    0x5072d200, 0xc0a2d301, 0x5294d400, 0xc244d501, 0xc337d601,
    0x53e7d700, 0x5758d800, 0xc788d901, 0xc6fbda01, 0x562bdb00,
    0xc41ddc01, 0x54cddd00, 0x55bede00, 0xc56edf01, 0xd6e1e001,
    0x4631e100, 0x4742e200, 0xd792e301, 0x45a4e400, 0xd574e501,
    0xd407e601, 0x44d7e700, 0x4068e800, 0xd0b8e901, 0xd1cbea01,
    0x411beb00, 0xd32dec01, 0x43fded00, 0x428eee00, 0xd25eef01,
    0x4bf0f000, 0xdb20f101, 0xda53f201, 0x4a83f300, 0xd8b5f401,
    0x4865f500, 0x4916f600, 0xd9c6f701, 0xdd79f801, 0x4da9f900,
    0x4cdafa00, 0xdc0afb01, 0x4e3cfc00, 0xdeecfd01, 0xdf9ffe01,
    0x4f4fff00}};

static const word_t crc_braid_big_table[][256] = {
   {0x00000000, 0x0101d090, 0x0102a391, 0x00037301, 0x01044593,
    0x00059503, 0x0006e602, 0x01073692, 0x01088996, 0x00095906,
    0x000a2a07, 0x010bfa97, 0x000ccc05, 0x010d1c95, 0x010e6f94,
    0x000fbf04, 0x0110119d, 0x0011c10d, 0x0012b20c, 0x0113629c,
    0x0014540e, 0x0115849e, 0x0116f79f, 0x0017270f, 0x0018980b,
    0x0119489b, 0x011a3b9a, 0x001beb0a, 0x011cdd98, 0x001d0d08,
    0x001e7e09, 0x011fae99, 0x0120218a, 0x0021f11a, 0x0022821b,
    0x0123528b, 0x00246419, 0x0125b489, 0x0126c788, 0x00271718,
    0x0028a81c, 0x0129788c, 0x012a0b8d, 0x002bdb1d, 0x012ced8f,
    0x002d3d1f, 0x002e4e1e, 0x012f9e8e, 0x00303017, 0x0131e087,
    0x01329386, 0x00334316, 0x01347584, 0x0035a514, 0x0036d615,
    0x01370685, 0x0138b981, 0x00396911, 0x003a1a10, 0x013bca80,
    0x003cfc12, 0x013d2c82, 0x013e5f83, 0x003f8f13, 0x014041a4,
    0x00419134, 0x0042e235, 0x014332a5, 0x00440437, 0x0145d4a7,
    0x0146a7a6, 0x00477736, 0x0048c832, 0x014918a2, 0x014a6ba3,
    0x004bbb33, 0x014c8da1, 0x004d5d31, 0x004e2e30, 0x014ffea0,
    0x00505039, 0x015180a9, 0x0152f3a8, 0x00532338, 0x015415aa,
    0x0055c53a, 0x0056b63b, 0x015766ab, 0x0158d9af, 0x0059093f,
    0x005a7a3e, 0x015baaae, 0x005c9c3c, 0x015d4cac, 0x015e3fad,
    0x005fef3d, 0x0060602e, 0x0161b0be, 0x0162c3bf, 0x0063132f,
    0x016425bd, 0x0065f52d, 0x0066862c, 0x016756bc, 0x0168e9b8,
    0x00693928, 0x006a4a29, 0x016b9ab9, 0x006cac2b, 0x016d7cbb,
    0x016e0fba, 0x006fdf2a, 0x017071b3, 0x0071a123, 0x0072d222,
    0x017302b2, 0x00743420, 0x0175e4b0, 0x017697b1, 0x00774721,
    0x0078f825, 0x017928b5, 0x017a5bb4, 0x007b8b24, 0x017cbdb6,
    0x007d6d26, 0x007e1e27, 0x017fceb7, 0x018081f8, 0x00815168,
    0x00822269, 0x0183f2f9, 0x0084c46b, 0x018514fb, 0x018667fa,
    0x0087b76a, 0x0088086e, 0x0189d8fe, 0x018aabff, 0x008b7b6f,
    0x018c4dfd, 0x008d9d6d, 0x008eee6c, 0x018f3efc, 0x00909065,
    0x019140f5, 0x019233f4, 0x0093e364, 0x0194d5f6, 0x00950566,
    0x00967667, 0x0197a6f7, 0x019819f3, 0x0099c963, 0x009aba62,
    0x019b6af2, 0x009c5c60, 0x019d8cf0, 0x019efff1, 0x009f2f61,
    0x00a0a072, 0x01a170e2, 0x01a203e3, 0x00a3d373, 0x01a4e5e1,
    0x00a53571, 0x00a64670, 0x01a796e0, 0x01a829e4, 0x00a9f974,
    0x00aa8a75, 0x01ab5ae5, 0x00ac6c77, 0x01adbce7, 0x01aecfe6,
    0x00af1f76, 0x01b0b1ef, 0x00b1617f, 0x00b2127e, 0x01b3c2ee,
    0x00b4f47c, 0x01b524ec, 0x01b657ed, 0x00b7877d, 0x00b83879,
    0x01b9e8e9, 0x01ba9be8, 0x00bb4b78, 0x01bc7dea, 0x00bdad7a,
    0x00bede7b, 0x01bf0eeb, 0x00c0c05c, 0x01c110cc, 0x01c263cd,
    0x00c3b35d, 0x01c485cf, 0x00c5555f, 0x00c6265e, 0x01c7f6ce,
    0x01c849ca, 0x00c9995a, 0x00caea5b, 0x01cb3acb, 0x00cc0c59,
    0x01cddcc9, 0x01ceafc8, 0x00cf7f58, 0x01d0d1c1, 0x00d10151,
    0x00d27250, 0x01d3a2c0, 0x00d49452, 0x01d544c2, 0x01d637c3,
    0x00d7e753, 0x00d85857, 0x01d988c7, 0x01dafbc6, 0x00db2b56,
    0x01dc1dc4, 0x00ddcd54, 0x00debe55, 0x01df6ec5, 0x01e0e1d6,
    0x00e13146, 0x00e24247, 0x01e392d7, 0x00e4a445, 0x01e574d5,
    0x01e607d4, 0x00e7d744, 0x00e86840, 0x01e9b8d0, 0x01eacbd1,
    0x00eb1b41, 0x01ec2dd3, 0x00edfd43, 0x00ee8e42, 0x01ef5ed2,
    0x00f0f04b, 0x01f120db, 0x01f253da, 0x00f3834a, 0x01f4b5d8,
    0x00f56548, 0x00f61649, 0x01f7c6d9, 0x01f879dd, 0x00f9a94d,
    0x00fada4c, 0x01fb0adc, 0x00fc3c4e, 0x01fdecde, 0x01fe9fdf,
    0x00ff4f4f},
   {0x00000000, 0x00d10190, 0x03a20090, 0x03730100, 0x05440290,
    0x05950300, 0x06e60200, 0x06370390, 0x09880790, 0x09590600,
    0x0a2a0700, 0x0afb0690, 0x0ccc0500, 0x0c1d0490, 0x0f6e0590,
    0x0fbf0400, 0x11100c90, 0x11c10d00, 0x12b20c00, 0x12630d90,
    0x14540e00, 0x14850f90, 0x17f60e90, 0x17270f00, 0x18980b00,
    0x18490a90, 0x1b3a0b90, 0x1beb0a00, 0x1ddc0990, 0x1d0d0800,
    0x1e7e0900, 0x1eaf0890, 0x21201b90, 0x21f11a00, 0x22821b00,
    0x22531a90, 0x24641900, 0x24b51890, 0x27c61990, 0x27171800,
    0x28a81c00, 0x28791d90, 0x2b0a1c90, 0x2bdb1d00, 0x2dec1e90,
    0x2d3d1f00, 0x2e4e1e00, 0x2e9f1f90, 0x30301700, 0x30e11690,
    0x33921790, 0x33431600, 0x35741590, 0x35a51400, 0x36d61500,
    0x36071490, 0x39b81090, 0x39691100, 0x3a1a1000, 0x3acb1190,
    0x3cfc1200, 0x3c2d1390, 0x3f5e1290, 0x3f8f1300, 0x41403590,
    0x41913400, 0x42e23500, 0x42333490, 0x44043700, 0x44d53690,
    0x47a63790, 0x47773600, 0x48c83200, 0x48193390, 0x4b6a3290,
    0x4bbb3300, 0x4d8c3090, 0x4d5d3100, 0x4e2e3000, 0x4eff3190,
    0x50503900, 0x50813890, 0x53f23990, 0x53233800, 0x55143b90,
    0x55c53a00, 0x56b63b00, 0x56673a90, 0x59d83e90, 0x59093f00,
    0x5a7a3e00, 0x5aab3f90, 0x5c9c3c00, 0x5c4d3d90, 0x5f3e3c90,
    0x5fef3d00, 0x60602e00, 0x60b12f90, 0x63c22e90, 0x63132f00,
    0x65242c90, 0x65f52d00, 0x66862c00, 0x66572d90, 0x69e82990,
    0x69392800, 0x6a4a2900, 0x6a9b2890, 0x6cac2b00, 0x6c7d2a90,
    0x6f0e2b90, 0x6fdf2a00, 0x71702290, 0x71a12300, 0x72d22200,
    0x72032390, 0x74342000, 0x74e52190, 0x77962090, 0x77472100,
    0x78f82500, 0x78292490, 0x7b5a2590, 0x7b8b2400, 0x7dbc2790,
    0x7d6d2600, 0x7e1e2700, 0x7ecf2690, 0x81806990, 0x81516800,
    0x82226900, 0x82f36890, 0x84c46b00, 0x84156a90, 0x87666b90,
    0x87b76a00, 0x88086e00, 0x88d96f90, 0x8baa6e90, 0x8b7b6f00,
    0x8d4c6c90, 0x8d9d6d00, 0x8eee6c00, 0x8e3f6d90, 0x90906500,
    0x90416490, 0x93326590, 0x93e36400, 0x95d46790, 0x95056600,
    0x96766700, 0x96a76690, 0x99186290, 0x99c96300, 0x9aba6200,
    0x9a6b6390, 0x9c5c6000, 0x9c8d6190, 0x9ffe6090, 0x9f2f6100,
    0xa0a07200, 0xa0717390, 0xa3027290, 0xa3d37300, 0xa5e47090,
    0xa5357100, 0xa6467000, 0xa6977190, 0xa9287590, 0xa9f97400,
    0xaa8a7500, 0xaa5b7490, 0xac6c7700, 0xacbd7690, 0xafce7790,
    0xaf1f7600, 0xb1b07e90, 0xb1617f00, 0xb2127e00, 0xb2c37f90,
    0xb4f47c00, 0xb4257d90, 0xb7567c90, 0xb7877d00, 0xb8387900,
    0xb8e97890, 0xbb9a7990, 0xbb4b7800, 0xbd7c7b90, 0xbdad7a00,
    0xbede7b00, 0xbe0f7a90, 0xc0c05c00, 0xc0115d90, 0xc3625c90,
    0xc3b35d00, 0xc5845e90, 0xc5555f00, 0xc6265e00, 0xc6f75f90,
    0xc9485b90, 0xc9995a00, 0xcaea5b00, 0xca3b5a90, 0xcc0c5900,
    0xccdd5890, 0xcfae5990, 0xcf7f5800, 0xd1d05090, 0xd1015100,
    0xd2725000, 0xd2a35190, 0xd4945200, 0xd4455390, 0xd7365290,
    0xd7e75300, 0xd8585700, 0xd8895690, 0xdbfa5790, 0xdb2b5600,
    0xdd1c5590, 0xddcd5400, 0xdebe5500, 0xde6f5490, 0xe1e04790,
    0xe1314600, 0xe2424700, 0xe2934690, 0xe4a44500, 0xe4754490,
    0xe7064590, 0xe7d74400, 0xe8684000, 0xe8b94190, 0xebca4090,
    0xeb1b4100, 0xed2c4290, 0xedfd4300, 0xee8e4200, 0xee5f4390,
    0xf0f04b00, 0xf0214a90, 0xf3524b90, 0xf3834a00, 0xf5b44990,
    0xf5654800, 0xf6164900, 0xf6c74890, 0xf9784c90, 0xf9a94d00,
    0xfada4c00, 0xfa0b4d90, 0xfc3c4e00, 0xfced4f90, 0xff9e4e90,
    0xff4f4f00},
   {0x00000000, 0xd1019000, 0xa2032001, 0x7302b001, 0x44074002,
    0x9506d002, 0xe6046003, 0x3705f003, 0x880e8004, 0x590f1004,
    0x2a0da005, 0xfb0c3005, 0xcc09c006, 0x1d085006, 0x6e0ae007,
    0xbf0b7007, 0x101d0009, 0xc11c9009, 0xb21e2008, 0x631fb008,
    0x541a400b, 0x851bd00b, 0xf619600a, 0x2718f00a, 0x9813800d,
    0x4912100d, 0x3a10a00c, 0xeb11300c, 0xdc14c00f, 0x0d15500f,
    0x7e17e00e, 0xaf16700e, 0x203a0012, 0xf13b9012, 0x82392013,
    0x5338b013, 0x643d4010, 0xb53cd010, 0xc63e6011, 0x173ff011,
    0xa8348016, 0x79351016, 0x0a37a017, 0xdb363017, 0xec33c014,
    0x3d325014, 0x4e30e015, 0x9f317015, 0x3027001b, 0xe126901b,
    0x9224201a, 0x4325b01a, 0x74204019, 0xa521d019, 0xd6236018,
    0x0722f018, 0xb829801f, 0x6928101f, 0x1a2aa01e, 0xcb2b301e,
    0xfc2ec01d, 0x2d2f501d, 0x5e2de01c, 0x8f2c701c, 0x40740024,
    0x91759024, 0xe2772025, 0x3376b025, 0x04734026, 0xd572d026,
    0xa6706027, 0x7771f027, 0xc87a8020, 0x197b1020, 0x6a79a021,
    0xbb783021, 0x8c7dc022, 0x5d7c5022, 0x2e7ee023, 0xff7f7023,
    0x5069002d, 0x8168902d, 0xf26a202c, 0x236bb02c, 0x146e402f,
    0xc56fd02f, 0xb66d602e, 0x676cf02e, 0xd8678029, 0x09661029,
    0x7a64a028, 0xab653028, 0x9c60c02b, 0x4d61502b, 0x3e63e02a,
    0xef62702a, 0x604e0036, 0xb14f9036, 0xc24d2037, 0x134cb037,
    0x24494034, 0xf548d034, 0x864a6035, 0x574bf035, 0xe8408032,
    0x39411032, 0x4a43a033, 0x9b423033, 0xac47c030, 0x7d465030,
    0x0e44e031, 0xdf457031, 0x7053003f, 0xa152903f, 0xd250203e,
    0x0351b03e, 0x3454403d, 0xe555d03d, 0x9657603c, 0x4756f03c,
    0xf85d803b, 0x295c103b, 0x5a5ea03a, 0x8b5f303a, 0xbc5ac039,
    0x6d5b5039, 0x1e59e038, 0xcf587038, 0x80e80048, 0x51e99048,
    0x22eb2049, 0xf3eab049, 0xc4ef404a, 0x15eed04a, 0x66ec604b,
    0xb7edf04b, 0x08e6804c, 0xd9e7104c, 0xaae5a04d, 0x7be4304d,
    0x4ce1c04e, 0x9de0504e, 0xeee2e04f, 0x3fe3704f, 0x90f50041,
    0x41f49041, 0x32f62040, 0xe3f7b040, 0xd4f24043, 0x05f3d043,
    0x76f16042, 0xa7f0f042, 0x18fb8045, 0xc9fa1045, 0xbaf8a044,
    0x6bf93044, 0x5cfcc047, 0x8dfd5047, 0xfeffe046, 0x2ffe7046,
    0xa0d2005a, 0x71d3905a, 0x02d1205b, 0xd3d0b05b, 0xe4d54058,
    0x35d4d058, 0x46d66059, 0x97d7f059, 0x28dc805e, 0xf9dd105e,
    0x8adfa05f, 0x5bde305f, 0x6cdbc05c, 0xbdda505c, 0xced8e05d,
    0x1fd9705d, 0xb0cf0053, 0x61ce9053, 0x12cc2052, 0xc3cdb052,
    0xf4c84051, 0x25c9d051, 0x56cb6050, 0x87caf050, 0x38c18057,
    0xe9c01057, 0x9ac2a056, 0x4bc33056, 0x7cc6c055, 0xadc75055,
    0xdec5e054, 0x0fc47054, 0xc09c006c, 0x119d906c, 0x629f206d,
    0xb39eb06d, 0x849b406e, 0x559ad06e, 0x2698606f, 0xf799f06f,
    0x48928068, 0x99931068, 0xea91a069, 0x3b903069, 0x0c95c06a,
    0xdd94506a, 0xae96e06b, 0x7f97706b, 0xd0810065, 0x01809065,
    0x72822064, 0xa383b064, 0x94864067, 0x4587d067, 0x36856066,
    0xe784f066, 0x588f8061, 0x898e1061, 0xfa8ca060, 0x2b8d3060,
    0x1c88c063, 0xcd895063, 0xbe8be062, 0x6f8a7062, 0xe0a6007e,
    0x31a7907e, 0x42a5207f, 0x93a4b07f, 0xa4a1407c, 0x75a0d07c,
    0x06a2607d, 0xd7a3f07d, 0x68a8807a, 0xb9a9107a, 0xcaaba07b,
    0x1baa307b, 0x2cafc078, 0xfdae5078, 0x8eace079, 0x5fad7079,
    0xf0bb0077, 0x21ba9077, 0x52b82076, 0x83b9b076, 0xb4bc4075,
    0x65bdd075, 0x16bf6074, 0xc7bef074, 0x78b58073, 0xa9b41073,
    0xdab6a072, 0x0bb73072, 0x3cb2c071, 0xedb35071, 0x9eb1e070,
    0x4fb07070},
   {0x00000000, 0x01419065, 0x028220cb, 0x03c3b0ae, 0x07044226,
    0x0645d243, 0x058662ed, 0x04c7f288, 0x0e08844c, 0x0f491429,
    0x0c8aa487, 0x0dcb34e2, 0x090cc66a, 0x084d560f, 0x0b8ee6a1,
    0x0acf76c4, 0x1c100899, 0x1d5198fc, 0x1e922852, 0x1fd3b837,
    0x1b144abf, 0x1a55dada, 0x19966a74, 0x18d7fa11, 0x12188cd5,
    0x13591cb0, 0x109aac1e, 0x11db3c7b, 0x151ccef3, 0x145d5e96,
    0x179eee38, 0x16df7e5d, 0x3b201382, 0x3a6183e7, 0x39a23349,
    0x38e3a32c, 0x3c2451a4, 0x3d65c1c1, 0x3ea6716f, 0x3fe7e10a,
    0x352897ce, 0x346907ab, 0x37aab705, 0x36eb2760, 0x322cd5e8,
    0x336d458d, 0x30aef523, 0x31ef6546, 0x27301b1b, 0x26718b7e,
    0x25b23bd0, 0x24f3abb5, 0x2034593d, 0x2175c958, 0x22b679f6,
    0x23f7e993, 0x29389f57, 0x28790f32, 0x2bbabf9c, 0x2afb2ff9,
    0x2e3cdd71, 0x2f7d4d14, 0x2cbefdba, 0x2dff6ddf, 0x754025b4,
    0x7401b5d1, 0x77c2057f, 0x7683951a, 0x72446792, 0x7305f7f7,
    0x70c64759, 0x7187d73c, 0x7b48a1f8, 0x7a09319d, 0x79ca8133,
    0x788b1156, 0x7c4ce3de, 0x7d0d73bb, 0x7ecec315, 0x7f8f5370,
    0x69502d2d, 0x6811bd48, 0x6bd20de6, 0x6a939d83, 0x6e546f0b,
    0x6f15ff6e, 0x6cd64fc0, 0x6d97dfa5, 0x6758a961, 0x66193904,
    0x65da89aa, 0x649b19cf, 0x605ceb47, 0x611d7b22, 0x62decb8c,
    0x639f5be9, 0x4e603636, 0x4f21a653, 0x4ce216fd, 0x4da38698,
    0x49647410, 0x4825e475, 0x4be654db, 0x4aa7c4be, 0x4068b27a,
    0x4129221f, 0x42ea92b1, 0x43ab02d4, 0x476cf05c, 0x462d6039,
    0x45eed097, 0x44af40f2, 0x52703eaf, 0x5331aeca, 0x50f21e64,
    0x51b38e01, 0x55747c89, 0x5435ecec, 0x57f65c42, 0x56b7cc27,
    0x5c78bae3, 0x5d392a86, 0x5efa9a28, 0x5fbb0a4d, 0x5b7cf8c5,
    0x5a3d68a0, 0x59fed80e, 0x58bf486b, 0xe98049d8, 0xe8c1d9bd,
    0xeb026913, 0xea43f976, 0xee840bfe, 0xefc59b9b, 0xec062b35,
    0xed47bb50, 0xe788cd94, 0xe6c95df1, 0xe50aed5f, 0xe44b7d3a,
    0xe08c8fb2, 0xe1cd1fd7, 0xe20eaf79, 0xe34f3f1c, 0xf5904141,
    0xf4d1d124, 0xf712618a, 0xf653f1ef, 0xf2940367, 0xf3d59302,
    0xf01623ac, 0xf157b3c9, 0xfb98c50d, 0xfad95568, 0xf91ae5c6,
    0xf85b75a3, 0xfc9c872b, 0xfddd174e, 0xfe1ea7e0, 0xff5f3785,
    0xd2a05a5a, 0xd3e1ca3f, 0xd0227a91, 0xd163eaf4, 0xd5a4187c,
    0xd4e58819, 0xd72638b7, 0xd667a8d2, 0xdca8de16, 0xdde94e73,
    0xde2afedd, 0xdf6b6eb8, 0xdbac9c30, 0xdaed0c55, 0xd92ebcfb,
    0xd86f2c9e, 0xceb052c3, 0xcff1c2a6, 0xcc327208, 0xcd73e26d,
    0xc9b410e5, 0xc8f58080, 0xcb36302e, 0xca77a04b, 0xc0b8d68f,
    0xc1f946ea, 0xc23af644, 0xc37b6621, 0xc7bc94a9, 0xc6fd04cc,
    0xc53eb462, 0xc47f2407, 0x9cc06c6c, 0x9d81fc09, 0x9e424ca7,
    0x9f03dcc2, 0x9bc42e4a, 0x9a85be2f, 0x99460e81, 0x98079ee4,
    0x92c8e820, 0x93897845, 0x904ac8eb, 0x910b588e, 0x95ccaa06,
    0x948d3a63, 0x974e8acd, 0x960f1aa8, 0x80d064f5, 0x8191f490,
    0x8252443e, 0x8313d45b, 0x87d426d3, 0x8695b6b6, 0x85560618,
    0x8417967d, 0x8ed8e0b9, 0x8f9970dc, 0x8c5ac072, 0x8d1b5017,
    0x89dca29f, 0x889d32fa, 0x8b5e8254, 0x8a1f1231, 0xa7e07fee,
    0xa6a1ef8b, 0xa5625f25, 0xa423cf40, 0xa0e43dc8, 0xa1a5adad,
    0xa2661d03, 0xa3278d66, 0xa9e8fba2, 0xa8a96bc7, 0xab6adb69,
    0xaa2b4b0c, 0xaeecb984, 0xafad29e1, 0xac6e994f, 0xad2f092a,
    0xbbf07777, 0xbab1e712, 0xb97257bc, 0xb833c7d9, 0xbcf43551,
    0xbdb5a534, 0xbe76159a, 0xbf3785ff, 0xb5f8f33b, 0xb4b9635e,
    0xb77ad3f0, 0xb63b4395, 0xb2fcb11d, 0xb3bd2178, 0xb07e91d6,
    0xb13f01b3}};

#endif

#endif

#if N == 3

#if W == 8

static const crc_t crc_braid_table[][256] = {
   {0x00000000, 0x47596181, 0x8eb2c302, 0xc9eba283, 0xad668607,
    0xea3fe786, 0x23d44505, 0x648d2484, 0xeace0c0d, 0xad976d8c,
    0x647ccf0f, 0x2325ae8e, 0x47a88a0a, 0x00f1eb8b, 0xc91a4908,
    0x8e432889, 0x659f1819, 0x22c67998, 0xeb2ddb1b, 0xac74ba9a,
    0xc8f99e1e, 0x8fa0ff9f, 0x464b5d1c, 0x01123c9d, 0x8f511414,
    0xc8087595, 0x01e3d716, 0x46bab697, 0x22379213, 0x656ef392,
    0xac855111, 0xebdc3090, 0xcb3e3032, 0x8c6751b3, 0x458cf330,
    0x02d592b1, 0x6658b635, 0x2101d7b4, 0xe8ea7537, 0xafb314b6,
    0x21f03c3f, 0x66a95dbe, 0xaf42ff3d, 0xe81b9ebc, 0x8c96ba38,
    0xcbcfdbb9, 0x0224793a, 0x457d18bb, 0xaea1282b, 0xe9f849aa,
    0x2013eb29, 0x674a8aa8, 0x03c7ae2c, 0x449ecfad, 0x8d756d2e,
    0xca2c0caf, 0x446f2426, 0x033645a7, 0xcadde724, 0x8d8486a5,
    0xe909a221, 0xae50c3a0, 0x67bb6123, 0x20e200a2, 0x267f6067,
    0x612601e6, 0xa8cda365, 0xef94c2e4, 0x8b19e660, 0xcc4087e1,
    0x05ab2562, 0x42f244e3, 0xccb16c6a, 0x8be80deb, 0x4203af68,
    0x055acee9, 0x61d7ea6d, 0x268e8bec, 0xef65296f, 0xa83c48ee,
    0x43e0787e, 0x04b919ff, 0xcd52bb7c, 0x8a0bdafd, 0xee86fe79,
    0xa9df9ff8, 0x60343d7b, 0x276d5cfa, 0xa92e7473, 0xee7715f2,
    0x279cb771, 0x60c5d6f0, 0x0448f274, 0x431193f5, 0x8afa3176,
    0xcda350f7, 0xed415055, 0xaa1831d4, 0x63f39357, 0x24aaf2d6,
    0x4027d652, 0x077eb7d3, 0xce951550, 0x89cc74d1, 0x078f5c58,
    0x40d63dd9, 0x893d9f5a, 0xce64fedb, 0xaae9da5f, 0xedb0bbde,
    0x245b195d, 0x630278dc, 0x88de484c, 0xcf8729cd, 0x066c8b4e,
    0x4135eacf, 0x25b8ce4b, 0x62e1afca, 0xab0a0d49, 0xec536cc8,
    0x62104441, 0x254925c0, 0xeca28743, 0xabfbe6c2, 0xcf76c246,
    0x882fa3c7, 0x41c40144, 0x069d60c5, 0x4cfec0ce, 0x0ba7a14f,
    0xc24c03cc, 0x8515624d, 0xe19846c9, 0xa6c12748, 0x6f2a85cb,
    0x2873e44a, 0xa630ccc3, 0xe169ad42, 0x28820fc1, 0x6fdb6e40,
    0x0b564ac4, 0x4c0f2b45, 0x85e489c6, 0xc2bde847, 0x2961d8d7,
    0x6e38b956, 0xa7d31bd5, 0xe08a7a54, 0x84075ed0, 0xc35e3f51,
    0x0ab59dd2, 0x4decfc53, 0xc3afd4da, 0x84f6b55b, 0x4d1d17d8,
    0x0a447659, 0x6ec952dd, 0x2990335c, 0xe07b91df, 0xa722f05e,
    0x87c0f0fc, 0xc099917d, 0x097233fe, 0x4e2b527f, 0x2aa676fb,
    0x6dff177a, 0xa414b5f9, 0xe34dd478, 0x6d0efcf1, 0x2a579d70,
    0xe3bc3ff3, 0xa4e55e72, 0xc0687af6, 0x87311b77, 0x4edab9f4,
    0x0983d875, 0xe25fe8e5, 0xa5068964, 0x6ced2be7, 0x2bb44a66,
    0x4f396ee2, 0x08600f63, 0xc18bade0, 0x86d2cc61, 0x0891e4e8,
    0x4fc88569, 0x862327ea, 0xc17a466b, 0xa5f762ef, 0xe2ae036e,
    0x2b45a1ed, 0x6c1cc06c, 0x6a81a0a9, 0x2dd8c128, 0xe43363ab,
    0xa36a022a, 0xc7e726ae, 0x80be472f, 0x4955e5ac, 0x0e0c842d,
    0x804faca4, 0xc716cd25, 0x0efd6fa6, 0x49a40e27, 0x2d292aa3,
    0x6a704b22, 0xa39be9a1, 0xe4c28820, 0x0f1eb8b0, 0x4847d931,
    0x81ac7bb2, 0xc6f51a33, 0xa2783eb7, 0xe5215f36, 0x2ccafdb5,
    0x6b939c34, 0xe5d0b4bd, 0xa289d53c, 0x6b6277bf, 0x2c3b163e,
    0x48b632ba, 0x0fef533b, 0xc604f1b8, 0x815d9039, 0xa1bf909b,
    0xe6e6f11a, 0x2f0d5399, 0x68543218, 0x0cd9169c, 0x4b80771d,
    0x826bd59e, 0xc532b41f, 0x4b719c96, 0x0c28fd17, 0xc5c35f94,
    0x829a3e15, 0xe6171a91, 0xa14e7b10, 0x68a5d993, 0x2ffcb812,
    0xc4208882, 0x8379e903, 0x4a924b80, 0x0dcb2a01, 0x69460e85,
    0x2e1f6f04, 0xe7f4cd87, 0xa0adac06, 0x2eee848f, 0x69b7e50e,
    0xa05c478d, 0xe705260c, 0x83880288, 0xc4d16309, 0x0d3ac18a,
    0x4a63a00b},
   {0x00000000, 0x99fd819c, 0x83f8033b, 0x1a0582a7, 0xb7f30675,
    0x2e0e87e9, 0x340b054e, 0xadf684d2, 0xdfe50ce9, 0x46188d75,
    0x5c1d0fd2, 0xc5e08e4e, 0x68160a9c, 0xf1eb8b00, 0xebee09a7,
    0x7213883b, 0x0fc919d1, 0x9634984d, 0x8c311aea, 0x15cc9b76,
    0xb83a1fa4, 0x21c79e38, 0x3bc21c9f, 0xa23f9d03, 0xd02c1538,
    0x49d194a4, 0x53d41603, 0xca29979f, 0x67df134d, 0xfe2292d1,
    0xe4271076, 0x7dda91ea, 0x1f9233a2, 0x866fb23e, 0x9c6a3099,
    0x0597b105, 0xa86135d7, 0x319cb44b, 0x2b9936ec, 0xb264b770,
    0xc0773f4b, 0x598abed7, 0x438f3c70, 0xda72bdec, 0x7784393e,
    0xee79b8a2, 0xf47c3a05, 0x6d81bb99, 0x105b2a73, 0x89a6abef,
    0x93a32948, 0x0a5ea8d4, 0xa7a82c06, 0x3e55ad9a, 0x24502f3d,
    0xbdadaea1, 0xcfbe269a, 0x5643a706, 0x4c4625a1, 0xd5bba43d,
    0x784d20ef, 0xe1b0a173, 0xfbb523d4, 0x6248a248, 0x3f246744,
    0xa6d9e6d8, 0xbcdc647f, 0x2521e5e3, 0x88d76131, 0x112ae0ad,
    0x0b2f620a, 0x92d2e396, 0xe0c16bad, 0x793cea31, 0x63396896,
    0xfac4e90a, 0x57326dd8, 0xcecfec44, 0xd4ca6ee3, 0x4d37ef7f,
    0x30ed7e95, 0xa910ff09, 0xb3157dae, 0x2ae8fc32, 0x871e78e0,
    0x1ee3f97c, 0x04e67bdb, 0x9d1bfa47, 0xef08727c, 0x76f5f3e0,
    0x6cf07147, 0xf50df0db, 0x58fb7409, 0xc106f595, 0xdb037732,
    0x42fef6ae, 0x20b654e6, 0xb94bd57a, 0xa34e57dd, 0x3ab3d641,
    0x97455293, 0x0eb8d30f, 0x14bd51a8, 0x8d40d034, 0xff53580f,
    0x66aed993, 0x7cab5b34, 0xe556daa8, 0x48a05e7a, 0xd15ddfe6,
    0xcb585d41, 0x52a5dcdd, 0x2f7f4d37, 0xb682ccab, 0xac874e0c,
    0x357acf90, 0x988c4b42, 0x0171cade, 0x1b744879, 0x8289c9e5,
    0xf09a41de, 0x6967c042, 0x736242e5, 0xea9fc379, 0x476947ab,
    0xde94c637, 0xc4914490, 0x5d6cc50c, 0x7e48ce88, 0xe7b54f14,
    0xfdb0cdb3, 0x644d4c2f, 0xc9bbc8fd, 0x50464961, 0x4a43cbc6,
    0xd3be4a5a, 0xa1adc261, 0x385043fd, 0x2255c15a, 0xbba840c6,
    0x165ec414, 0x8fa34588, 0x95a6c72f, 0x0c5b46b3, 0x7181d759,
    0xe87c56c5, 0xf279d462, 0x6b8455fe, 0xc672d12c, 0x5f8f50b0,
    0x458ad217, 0xdc77538b, 0xae64dbb0, 0x37995a2c, 0x2d9cd88b,
    0xb4615917, 0x1997ddc5, 0x806a5c59, 0x9a6fdefe, 0x03925f62,
    0x61dafd2a, 0xf8277cb6, 0xe222fe11, 0x7bdf7f8d, 0xd629fb5f,
    0x4fd47ac3, 0x55d1f864, 0xcc2c79f8, 0xbe3ff1c3, 0x27c2705f,
    0x3dc7f2f8, 0xa43a7364, 0x09ccf7b6, 0x9031762a, 0x8a34f48d,
    0x13c97511, 0x6e13e4fb, 0xf7ee6567, 0xedebe7c0, 0x7416665c,
    0xd9e0e28e, 0x401d6312, 0x5a18e1b5, 0xc3e56029, 0xb1f6e812,
    0x280b698e, 0x320eeb29, 0xabf36ab5, 0x0605ee67, 0x9ff86ffb,
    0x85fded5c, 0x1c006cc0, 0x416ca9cc, 0xd8912850, 0xc294aaf7,
    0x5b692b6b, 0xf69fafb9, 0x6f622e25, 0x7567ac82, 0xec9a2d1e,
    0x9e89a525, 0x077424b9, 0x1d71a61e, 0x848c2782, 0x297aa350,
    0xb08722cc, 0xaa82a06b, 0x337f21f7, 0x4ea5b01d, 0xd7583181,
    0xcd5db326, 0x54a032ba, 0xf956b668, 0x60ab37f4, 0x7aaeb553,
    0xe35334cf, 0x9140bcf4, 0x08bd3d68, 0x12b8bfcf, 0x8b453e53,
    0x26b3ba81, 0xbf4e3b1d, 0xa54bb9ba, 0x3cb63826, 0x5efe9a6e,
    0xc7031bf2, 0xdd069955, 0x44fb18c9, 0xe90d9c1b, 0x70f01d87,
    0x6af59f20, 0xf3081ebc, 0x811b9687, 0x18e6171b, 0x02e395bc,
    0x9b1e1420, 0x36e890f2, 0xaf15116e, 0xb51093c9, 0x2ced1255,
    0x513783bf, 0xc8ca0223, 0xd2cf8084, 0x4b320118, 0xe6c485ca,
    0x7f390456, 0x653c86f1, 0xfcc1076d, 0x8ed28f56, 0x172f0eca,
    0x0d2a8c6d, 0x94d70df1, 0x39218923, 0xa0dc08bf, 0xbad98a18,
    0x23240b84},
   {0x00000000, 0xfc919d10, 0x49203a23, 0xb5b1a733, 0x92407446,
    0x6ed1e956, 0xdb604e65, 0x27f1d375, 0x9483e88f, 0x6812759f,
    0xdda3d2ac, 0x21324fbc, 0x06c39cc9, 0xfa5201d9, 0x4fe3a6ea,
    0xb3723bfa, 0x9904d11d, 0x65954c0d, 0xd024eb3e, 0x2cb5762e,
    0x0b44a55b, 0xf7d5384b, 0x42649f78, 0xbef50268, 0x0d873992,
    0xf116a482, 0x44a703b1, 0xb8369ea1, 0x9fc74dd4, 0x6356d0c4,
    0xd6e777f7, 0x2a76eae7, 0x820aa239, 0x7e9b3f29, 0xcb2a981a,
    0x37bb050a, 0x104ad67f, 0xecdb4b6f, 0x596aec5c, 0xa5fb714c,
    0x16894ab6, 0xea18d7a6, 0x5fa97095, 0xa338ed85, 0x84c93ef0,
    0x7858a3e0, 0xcde904d3, 0x317899c3, 0x1b0e7324, 0xe79fee34,
    0x522e4907, 0xaebfd417, 0x894e0762, 0x75df9a72, 0xc06e3d41,
    0x3cffa051, 0x8f8d9bab, 0x731c06bb, 0xc6ada188, 0x3a3c3c98,
    0x1dcdefed, 0xe15c72fd, 0x54edd5ce, 0xa87c48de, 0xb4164471,
    0x4887d961, 0xfd367e52, 0x01a7e342, 0x26563037, 0xdac7ad27,
    0x6f760a14, 0x93e79704, 0x2095acfe, 0xdc0431ee, 0x69b596dd,
    0x95240bcd, 0xb2d5d8b8, 0x4e4445a8, 0xfbf5e29b, 0x07647f8b,
    0x2d12956c, 0xd183087c, 0x6432af4f, 0x98a3325f, 0xbf52e12a,
    0x43c37c3a, 0xf672db09, 0x0ae34619, 0xb9917de3, 0x4500e0f3,
    0xf0b147c0, 0x0c20dad0, 0x2bd109a5, 0xd74094b5, 0x62f13386,
    0x9e60ae96, 0x361ce648, 0xca8d7b58, 0x7f3cdc6b, 0x83ad417b,
    0xa45c920e, 0x58cd0f1e, 0xed7ca82d, 0x11ed353d, 0xa29f0ec7,
    0x5e0e93d7, 0xebbf34e4, 0x172ea9f4, 0x30df7a81, 0xcc4ee791,
    0x79ff40a2, 0x856eddb2, 0xaf183755, 0x5389aa45, 0xe6380d76,
    0x1aa99066, 0x3d584313, 0xc1c9de03, 0x74787930, 0x88e9e420,
    0x3b9bdfda, 0xc70a42ca, 0x72bbe5f9, 0x8e2a78e9, 0xa9dbab9c,
    0x554a368c, 0xe0fb91bf, 0x1c6a0caf, 0xd82f88e1, 0x24be15f1,
    0x910fb2c2, 0x6d9e2fd2, 0x4a6ffca7, 0xb6fe61b7, 0x034fc684,
    0xffde5b94, 0x4cac606e, 0xb03dfd7e, 0x058c5a4d, 0xf91dc75d,
    0xdeec1428, 0x227d8938, 0x97cc2e0b, 0x6b5db31b, 0x412b59fc,
    0xbdbac4ec, 0x080b63df, 0xf49afecf, 0xd36b2dba, 0x2ffab0aa,
    0x9a4b1799, 0x66da8a89, 0xd5a8b173, 0x29392c63, 0x9c888b50,
    0x60191640, 0x47e8c535, 0xbb795825, 0x0ec8ff16, 0xf2596206,
    0x5a252ad8, 0xa6b4b7c8, 0x130510fb, 0xef948deb, 0xc8655e9e,
    0x34f4c38e, 0x814564bd, 0x7dd4f9ad, 0xcea6c257, 0x32375f47,
    0x8786f874, 0x7b176564, 0x5ce6b611, 0xa0772b01, 0x15c68c32,
    0xe9571122, 0xc321fbc5, 0x3fb066d5, 0x8a01c1e6, 0x76905cf6,
    0x51618f83, 0xadf01293, 0x1841b5a0, 0xe4d028b0, 0x57a2134a,
    0xab338e5a, 0x1e822969, 0xe213b479, 0xc5e2670c, 0x3973fa1c,
    0x8cc25d2f, 0x7053c03f, 0x6c39cc90, 0x90a85180, 0x2519f6b3,
    0xd9886ba3, 0xfe79b8d6, 0x02e825c6, 0xb75982f5, 0x4bc81fe5,
    0xf8ba241f, 0x042bb90f, 0xb19a1e3c, 0x4d0b832c, 0x6afa5059,
    0x966bcd49, 0x23da6a7a, 0xdf4bf76a, 0xf53d1d8d, 0x09ac809d,
    0xbc1d27ae, 0x408cbabe, 0x677d69cb, 0x9becf4db, 0x2e5d53e8,
    0xd2cccef8, 0x61bef502, 0x9d2f6812, 0x289ecf21, 0xd40f5231,
    0xf3fe8144, 0x0f6f1c54, 0xbadebb67, 0x464f2677, 0xee336ea9,
    0x12a2f3b9, 0xa713548a, 0x5b82c99a, 0x7c731aef, 0x80e287ff,
    0x355320cc, 0xc9c2bddc, 0x7ab08626, 0x86211b36, 0x3390bc05,
    0xcf012115, 0xe8f0f260, 0x14616f70, 0xa1d0c843, 0x5d415553,
    0x7737bfb4, 0x8ba622a4, 0x3e178597, 0xc2861887, 0xe577cbf2,
    0x19e656e2, 0xac57f1d1, 0x50c66cc1, 0xe3b4573b, 0x1f25ca2b,
    0xaa946d18, 0x5605f008, 0x71f4237d, 0x8d65be6d, 0x38d4195e,
    0xc445844e},
   {0x00000000, 0x005c11c1, 0x00b82382, 0x00e43243, 0x01704704,
    0x012c56c5, 0x01c86486, 0x01947547, 0x02e08e08, 0x02bc9fc9,
    0x0258ad8a, 0x0204bc4b, 0x0390c90c, 0x03ccd8cd, 0x0328ea8e,
    0x0374fb4f, 0x05c11c10, 0x059d0dd1, 0x05793f92, 0x05252e53,
    0x04b15b14, 0x04ed4ad5, 0x04097896, 0x04556957, 0x07219218,
    0x077d83d9, 0x0799b19a, 0x07c5a05b, 0x0651d51c, 0x060dc4dd,
    0x06e9f69e, 0x06b5e75f, 0x0b823820, 0x0bde29e1, 0x0b3a1ba2,
    0x0b660a63, 0x0af27f24, 0x0aae6ee5, 0x0a4a5ca6, 0x0a164d67,
    0x0962b628, 0x093ea7e9, 0x09da95aa, 0x0986846b, 0x0812f12c,
    0x084ee0ed, 0x08aad2ae, 0x08f6c36f, 0x0e432430, 0x0e1f35f1,
    0x0efb07b2, 0x0ea71673, 0x0f336334, 0x0f6f72f5, 0x0f8b40b6,
    0x0fd75177, 0x0ca3aa38, 0x0cffbbf9, 0x0c1b89ba, 0x0c47987b,
    0x0dd3ed3c, 0x0d8ffcfd, 0x0d6bcebe, 0x0d37df7f, 0x17047040,
    0x17586181, 0x17bc53c2, 0x17e04203, 0x16743744, 0x16282685,
    0x16cc14c6, 0x16900507, 0x15e4fe48, 0x15b8ef89, 0x155cddca,
    0x1500cc0b, 0x1494b94c, 0x14c8a88d, 0x142c9ace, 0x14708b0f,
    0x12c56c50, 0x12997d91, 0x127d4fd2, 0x12215e13, 0x13b52b54,
    0x13e93a95, 0x130d08d6, 0x13511917, 0x1025e258, 0x1079f399,
    0x109dc1da, 0x10c1d01b, 0x1155a55c, 0x1109b49d, 0x11ed86de,
    0x11b1971f, 0x1c864860, 0x1cda59a1, 0x1c3e6be2, 0x1c627a23,
    0x1df60f64, 0x1daa1ea5, 0x1d4e2ce6, 0x1d123d27, 0x1e66c668,
    0x1e3ad7a9, 0x1edee5ea, 0x1e82f42b, 0x1f16816c, 0x1f4a90ad,
    0x1faea2ee, 0x1ff2b32f, 0x19475470, 0x191b45b1, 0x19ff77f2,
    0x19a36633, 0x18371374, 0x186b02b5, 0x188f30f6, 0x18d32137,
    0x1ba7da78, 0x1bfbcbb9, 0x1b1ff9fa, 0x1b43e83b, 0x1ad79d7c,
    0x1a8b8cbd, 0x1a6fbefe, 0x1a33af3f, 0x2e08e080, 0x2e54f141,
    0x2eb0c302, 0x2eecd2c3, 0x2f78a784, 0x2f24b645, 0x2fc08406,
    0x2f9c95c7, 0x2ce86e88, 0x2cb47f49, 0x2c504d0a, 0x2c0c5ccb,
    0x2d98298c, 0x2dc4384d, 0x2d200a0e, 0x2d7c1bcf, 0x2bc9fc90,
    0x2b95ed51, 0x2b71df12, 0x2b2dced3, 0x2ab9bb94, 0x2ae5aa55,
    0x2a019816, 0x2a5d89d7, 0x29297298, 0x29756359, 0x2991511a,
    0x29cd40db, 0x2859359c, 0x2805245d, 0x28e1161e, 0x28bd07df,
    0x258ad8a0, 0x25d6c961, 0x2532fb22, 0x256eeae3, 0x24fa9fa4,
    0x24a68e65, 0x2442bc26, 0x241eade7, 0x276a56a8, 0x27364769,
    0x27d2752a, 0x278e64eb, 0x261a11ac, 0x2646006d, 0x26a2322e,
    0x26fe23ef, 0x204bc4b0, 0x2017d571, 0x20f3e732, 0x20aff6f3,
    0x213b83b4, 0x21679275, 0x2183a036, 0x21dfb1f7, 0x22ab4ab8,
    0x22f75b79, 0x2213693a, 0x224f78fb, 0x23db0dbc, 0x23871c7d,
    0x23632e3e, 0x233f3fff, 0x390c90c0, 0x39508101, 0x39b4b342,
    0x39e8a283, 0x387cd7c4, 0x3820c605, 0x38c4f446, 0x3898e587,
    0x3bec1ec8, 0x3bb00f09, 0x3b543d4a, 0x3b082c8b, 0x3a9c59cc,
    0x3ac0480d, 0x3a247a4e, 0x3a786b8f, 0x3ccd8cd0, 0x3c919d11,
    0x3c75af52, 0x3c29be93, 0x3dbdcbd4, 0x3de1da15, 0x3d05e856,
    0x3d59f997, 0x3e2d02d8, 0x3e711319, 0x3e95215a, 0x3ec9309b,
    0x3f5d45dc, 0x3f01541d, 0x3fe5665e, 0x3fb9779f, 0x328ea8e0,
    0x32d2b921, 0x32368b62, 0x326a9aa3, 0x33feefe4, 0x33a2fe25,
    0x3346cc66, 0x331adda7, 0x306e26e8, 0x30323729, 0x30d6056a,
    0x308a14ab, 0x311e61ec, 0x3142702d, 0x31a6426e, 0x31fa53af,
    0x374fb4f0, 0x3713a531, 0x37f79772, 0x37ab86b3, 0x363ff3f4,
    0x3663e235, 0x3687d076, 0x36dbc1b7, 0x35af3af8, 0x35f32b39,
    0x3517197a, 0x354b08bb, 0x34df7dfc, 0x34836c3d, 0x34675e7e,
    0x343b4fbf},
   {0x00000000, 0x5c11c100, 0xb8238200, 0xe4324300, 0xc0440403,
    0x9c55c503, 0x78678603, 0x24764703, 0x308b0805, 0x6c9ac905,
    0x88a88a05, 0xd4b94b05, 0xf0cf0c06, 0xacdecd06, 0x48ec8e06,
    0x14fd4f06, 0x6116100a, 0x3d07d10a, 0xd935920a, 0x8524530a,
    0xa1521409, 0xfd43d509, 0x19719609, 0x45605709, 0x519d180f,
    0x0d8cd90f, 0xe9be9a0f, 0xb5af5b0f, 0x91d91c0c, 0xcdc8dd0c,
    0x29fa9e0c, 0x75eb5f0c, 0xc22c2014, 0x9e3de114, 0x7a0fa214,
    0x261e6314, 0x02682417, 0x5e79e517, 0xba4ba617, 0xe65a6717,
    0xf2a72811, 0xaeb6e911, 0x4a84aa11, 0x16956b11, 0x32e32c12,
    0x6ef2ed12, 0x8ac0ae12, 0xd6d16f12, 0xa33a301e, 0xff2bf11e,
    0x1b19b21e, 0x4708731e, 0x637e341d, 0x3f6ff51d, 0xdb5db61d,
    0x874c771d, 0x93b1381b, 0xcfa0f91b, 0x2b92ba1b, 0x77837b1b,
    0x53f53c18, 0x0fe4fd18, 0xebd6be18, 0xb7c77f18, 0x345b402b,
    0x684a812b, 0x8c78c22b, 0xd069032b, 0xf41f4428, 0xa80e8528,
    0x4c3cc628, 0x102d0728, 0x04d0482e, 0x58c1892e, 0xbcf3ca2e,
    0xe0e20b2e, 0xc4944c2d, 0x98858d2d, 0x7cb7ce2d, 0x20a60f2d,
    0x554d5021, 0x095c9121, 0xed6ed221, 0xb17f1321, 0x95095422,
    0xc9189522, 0x2d2ad622, 0x713b1722, 0x65c65824, 0x39d79924,
    0xdde5da24, 0x81f41b24, 0xa5825c27, 0xf9939d27, 0x1da1de27,
    0x41b01f27, 0xf677603f, 0xaa66a13f, 0x4e54e23f, 0x1245233f,
    0x3633643c, 0x6a22a53c, 0x8e10e63c, 0xd201273c, 0xc6fc683a,
    0x9aeda93a, 0x7edfea3a, 0x22ce2b3a, 0x06b86c39, 0x5aa9ad39,
    0xbe9bee39, 0xe28a2f39, 0x97617035, 0xcb70b135, 0x2f42f235,
    0x73533335, 0x57257436, 0x0b34b536, 0xef06f636, 0xb3173736,
    0xa7ea7830, 0xfbfbb930, 0x1fc9fa30, 0x43d83b30, 0x67ae7c33,
    0x3bbfbd33, 0xdf8dfe33, 0x839c3f33, 0x68b68056, 0x34a74156,
    0xd0950256, 0x8c84c356, 0xa8f28455, 0xf4e34555, 0x10d10655,
    0x4cc0c755, 0x583d8853, 0x042c4953, 0xe01e0a53, 0xbc0fcb53,
    0x98798c50, 0xc4684d50, 0x205a0e50, 0x7c4bcf50, 0x09a0905c,
    0x55b1515c, 0xb183125c, 0xed92d35c, 0xc9e4945f, 0x95f5555f,
    0x71c7165f, 0x2dd6d75f, 0x392b9859, 0x653a5959, 0x81081a59,
    0xdd19db59, 0xf96f9c5a, 0xa57e5d5a, 0x414c1e5a, 0x1d5ddf5a,
    0xaa9aa042, 0xf68b6142, 0x12b92242, 0x4ea8e342, 0x6adea441,
    0x36cf6541, 0xd2fd2641, 0x8eece741, 0x9a11a847, 0xc6006947,
    0x22322a47, 0x7e23eb47, 0x5a55ac44, 0x06446d44, 0xe2762e44,
    0xbe67ef44, 0xcb8cb048, 0x979d7148, 0x73af3248, 0x2fbef348,
    0x0bc8b44b, 0x57d9754b, 0xb3eb364b, 0xeffaf74b, 0xfb07b84d,
    0xa716794d, 0x43243a4d, 0x1f35fb4d, 0x3b43bc4e, 0x67527d4e,
    0x83603e4e, 0xdf71ff4e, 0x5cedc07d, 0x00fc017d, 0xe4ce427d,
    0xb8df837d, 0x9ca9c47e, 0xc0b8057e, 0x248a467e, 0x789b877e,
    0x6c66c878, 0x30770978, 0xd4454a78, 0x88548b78, 0xac22cc7b,
    0xf0330d7b, 0x14014e7b, 0x48108f7b, 0x3dfbd077, 0x61ea1177,
    0x85d85277, 0xd9c99377, 0xfdbfd474, 0xa1ae1574, 0x459c5674,
    0x198d9774, 0x0d70d872, 0x51611972, 0xb5535a72, 0xe9429b72,
    0xcd34dc71, 0x91251d71, 0x75175e71, 0x29069f71, 0x9ec1e069,
    0xc2d02169, 0x26e26269, 0x7af3a369, 0x5e85e46a, 0x0294256a,
    0xe6a6666a, 0xbab7a76a, 0xae4ae86c, 0xf25b296c, 0x16696a6c,
    0x4a78ab6c, 0x6e0eec6f, 0x321f2d6f, 0xd62d6e6f, 0x8a3caf6f,
    0xffd7f063, 0xa3c63163, 0x47f47263, 0x1be5b363, 0x3f93f460,
    0x63823560, 0x87b07660, 0xdba1b760, 0xcf5cf866, 0x934d3966,
    0x777f7a66, 0x2b6ebb66, 0x0f18fc65, 0x53093d65, 0xb73b7e65,
    0xeb2abf65},
   {0x00000000, 0xd16d00ac, 0x12d9015b, 0xc3b401f7, 0x25b202b6,
    0xf4df021a, 0x376b03ed, 0xe6060341, 0x4b64056c, 0x9a0905c0,
    0x59bd0437, 0x88d0049b, 0x6ed607da, 0xbfbb0776, 0x7c0f0681,
    0xad62062d, 0x96c80ad8, 0x47a50a74, 0x84110b83, 0x557c0b2f,
    0xb37a086e, 0x621708c2, 0xa1a30935, 0x70ce0999, 0xddac0fb4,
    0x0cc10f18, 0xcf750eef, 0x1e180e43, 0xf81e0d02, 0x29730dae,
    0xeac70c59, 0x3baa0cf5, 0x9d9315b3, 0x4cfe151f, 0x8f4a14e8,
    0x5e271444, 0xb8211705, 0x694c17a9, 0xaaf8165e, 0x7b9516f2,
    0xd6f710df, 0x079a1073, 0xc42e1184, 0x15431128, 0xf3451269,
    0x222812c5, 0xe19c1332, 0x30f1139e, 0x0b5b1f6b, 0xda361fc7,
    0x19821e30, 0xc8ef1e9c, 0x2ee91ddd, 0xff841d71, 0x3c301c86,
    0xed5d1c2a, 0x403f1a07, 0x91521aab, 0x52e61b5c, 0x838b1bf0,
    0x658d18b1, 0xb4e0181d, 0x775419ea, 0xa6391946, 0x8b252b65,
    0x5a482bc9, 0x99fc2a3e, 0x48912a92, 0xae9729d3, 0x7ffa297f,
    0xbc4e2888, 0x6d232824, 0xc0412e09, 0x112c2ea5, 0xd2982f52,
    0x03f52ffe, 0xe5f32cbf, 0x349e2c13, 0xf72a2de4, 0x26472d48,
    0x1ded21bd, 0xcc802111, 0x0f3420e6, 0xde59204a, 0x385f230b,
    0xe93223a7, 0x2a862250, 0xfbeb22fc, 0x568924d1, 0x87e4247d,
    0x4450258a, 0x953d2526, 0x733b2667, 0xa25626cb, 0x61e2273c,
    0xb08f2790, 0x16b63ed6, 0xc7db3e7a, 0x046f3f8d, 0xd5023f21,
    0x33043c60, 0xe2693ccc, 0x21dd3d3b, 0xf0b03d97, 0x5dd23bba,
    0x8cbf3b16, 0x4f0b3ae1, 0x9e663a4d, 0x7860390c, 0xa90d39a0,
    0x6ab93857, 0xbbd438fb, 0x807e340e, 0x511334a2, 0x92a73555,
    0x43ca35f9, 0xa5cc36b8, 0x74a13614, 0xb71537e3, 0x6678374f,
    0xcb1a3162, 0x1a7731ce, 0xd9c33039, 0x08ae3095, 0xeea833d4,
    0x3fc53378, 0xfc71328f, 0x2d1c3223, 0xa64956c9, 0x77245665,
    0xb4905792, 0x65fd573e, 0x83fb547f, 0x529654d3, 0x91225524,
    0x404f5588, 0xed2d53a5, 0x3c405309, 0xfff452fe, 0x2e995252,
    0xc89f5113, 0x19f251bf, 0xda465048, 0x0b2b50e4, 0x30815c11,
    0xe1ec5cbd, 0x22585d4a, 0xf3355de6, 0x15335ea7, 0xc45e5e0b,
    0x07ea5ffc, 0xd6875f50, 0x7be5597d, 0xaa8859d1, 0x693c5826,
    0xb851588a, 0x5e575bcb, 0x8f3a5b67, 0x4c8e5a90, 0x9de35a3c,
    0x3bda437a, 0xeab743d6, 0x29034221, 0xf86e428d, 0x1e6841cc,
    0xcf054160, 0x0cb14097, 0xdddc403b, 0x70be4616, 0xa1d346ba,
    0x6267474d, 0xb30a47e1, 0x550c44a0, 0x8461440c, 0x47d545fb,
    0x96b84557, 0xad1249a2, 0x7c7f490e, 0xbfcb48f9, 0x6ea64855,
    0x88a04b14, 0x59cd4bb8, 0x9a794a4f, 0x4b144ae3, 0xe6764cce,
    0x371b4c62, 0xf4af4d95, 0x25c24d39, 0xc3c44e78, 0x12a94ed4,
    0xd11d4f23, 0x00704f8f, 0x2d6c7dac, 0xfc017d00, 0x3fb57cf7,
    0xeed87c5b, 0x08de7f1a, 0xd9b37fb6, 0x1a077e41, 0xcb6a7eed,
    0x660878c0, 0xb765786c, 0x74d1799b, 0xa5bc7937, 0x43ba7a76,
    0x92d77ada, 0x51637b2d, 0x800e7b81, 0xbba47774, 0x6ac977d8,
    0xa97d762f, 0x78107683, 0x9e1675c2, 0x4f7b756e, 0x8ccf7499,
    0x5da27435, 0xf0c07218, 0x21ad72b4, 0xe2197343, 0x337473ef,
    0xd57270ae, 0x041f7002, 0xc7ab71f5, 0x16c67159, 0xb0ff681f,
    0x619268b3, 0xa2266944, 0x734b69e8, 0x954d6aa9, 0x44206a05,
    0x87946bf2, 0x56f96b5e, 0xfb9b6d73, 0x2af66ddf, 0xe9426c28,
    0x382f6c84, 0xde296fc5, 0x0f446f69, 0xccf06e9e, 0x1d9d6e32,
    0x263762c7, 0xf75a626b, 0x34ee639c, 0xe5836330, 0x03856071,
    0xd2e860dd, 0x115c612a, 0xc0316186, 0x6d5367ab, 0xbc3e6707,
    0x7f8a66f0, 0xaee7665c, 0x48e1651d, 0x998c65b1, 0x5a386446,
    0x8b5564ea},
   {0x00000000, 0xfc91ad91, 0x49205b21, 0xb5b1f6b0, 0x9240b642,
    0x6ed11bd3, 0xdb60ed63, 0x27f140f2, 0x94826c87, 0x6813c116,
    0xdda237a6, 0x21339a37, 0x06c2dac5, 0xfa537754, 0x4fe281e4,
    0xb3732c75, 0x9907d90d, 0x6596749c, 0xd027822c, 0x2cb62fbd,
    0x0b476f4f, 0xf7d6c2de, 0x4267346e, 0xbef699ff, 0x0d85b58a,
    0xf114181b, 0x44a5eeab, 0xb834433a, 0x9fc503c8, 0x6354ae59,
    0xd6e558e9, 0x2a74f578, 0x820cb219, 0x7e9d1f88, 0xcb2ce938,
    0x37bd44a9, 0x104c045b, 0xecdda9ca, 0x596c5f7a, 0xa5fdf2eb,
    0x168ede9e, 0xea1f730f, 0x5fae85bf, 0xa33f282e, 0x84ce68dc,
    0x785fc54d, 0xcdee33fd, 0x317f9e6c, 0x1b0b6b14, 0xe79ac685,
    0x522b3035, 0xaeba9da4, 0x894bdd56, 0x75da70c7, 0xc06b8677,
    0x3cfa2be6, 0x8f890793, 0x7318aa02, 0xc6a95cb2, 0x3a38f123,
    0x1dc9b1d1, 0xe1581c40, 0x54e9eaf0, 0xa8784761, 0xb41a6431,
    0x488bc9a0, 0xfd3a3f10, 0x01ab9281, 0x265ad273, 0xdacb7fe2,
    0x6f7a8952, 0x93eb24c3, 0x209808b6, 0xdc09a527, 0x69b85397,
    0x9529fe06, 0xb2d8bef4, 0x4e491365, 0xfbf8e5d5, 0x07694844,
    0x2d1dbd3c, 0xd18c10ad, 0x643de61d, 0x98ac4b8c, 0xbf5d0b7e,
    0x43cca6ef, 0xf67d505f, 0x0aecfdce, 0xb99fd1bb, 0x450e7c2a,
    0xf0bf8a9a, 0x0c2e270b, 0x2bdf67f9, 0xd74eca68, 0x62ff3cd8,
    0x9e6e9149, 0x3616d628, 0xca877bb9, 0x7f368d09, 0x83a72098,
    0xa456606a, 0x58c7cdfb, 0xed763b4b, 0x11e796da, 0xa294baaf,
    0x5e05173e, 0xebb4e18e, 0x17254c1f, 0x30d40ced, 0xcc45a17c,
    0x79f457cc, 0x8565fa5d, 0xaf110f25, 0x5380a2b4, 0xe6315404,
    0x1aa0f995, 0x3d51b967, 0xc1c014f6, 0x7471e246, 0x88e04fd7,
    0x3b9363a2, 0xc702ce33, 0x72b33883, 0x8e229512, 0xa9d3d5e0,
    0x55427871, 0xe0f38ec1, 0x1c622350, 0xd837c861, 0x24a665f0,
    0x91179340, 0x6d863ed1, 0x4a777e23, 0xb6e6d3b2, 0x03572502,
    0xffc68893, 0x4cb5a4e6, 0xb0240977, 0x0595ffc7, 0xf9045256,
    0xdef512a4, 0x2264bf35, 0x97d54985, 0x6b44e414, 0x4130116c,
    0xbda1bcfd, 0x08104a4d, 0xf481e7dc, 0xd370a72e, 0x2fe10abf,
    0x9a50fc0f, 0x66c1519e, 0xd5b27deb, 0x2923d07a, 0x9c9226ca,
    0x60038b5b, 0x47f2cba9, 0xbb636638, 0x0ed29088, 0xf2433d19,
    0x5a3b7a78, 0xa6aad7e9, 0x131b2159, 0xef8a8cc8, 0xc87bcc3a,
    0x34ea61ab, 0x815b971b, 0x7dca3a8a, 0xceb916ff, 0x3228bb6e,
    0x87994dde, 0x7b08e04f, 0x5cf9a0bd, 0xa0680d2c, 0x15d9fb9c,
    0xe948560d, 0xc33ca375, 0x3fad0ee4, 0x8a1cf854, 0x768d55c5,
    0x517c1537, 0xadedb8a6, 0x185c4e16, 0xe4cde387, 0x57becff2,
    0xab2f6263, 0x1e9e94d3, 0xe20f3942, 0xc5fe79b0, 0x396fd421,
    0x8cde2291, 0x704f8f00, 0x6c2dac50, 0x90bc01c1, 0x250df771,
    0xd99c5ae0, 0xfe6d1a12, 0x02fcb783, 0xb74d4133, 0x4bdceca2,
    0xf8afc0d7, 0x043e6d46, 0xb18f9bf6, 0x4d1e3667, 0x6aef7695,
    0x967edb04, 0x23cf2db4, 0xdf5e8025, 0xf52a755d, 0x09bbd8cc,
    0xbc0a2e7c, 0x409b83ed, 0x676ac31f, 0x9bfb6e8e, 0x2e4a983e,
    0xd2db35af, 0x61a819da, 0x9d39b44b, 0x288842fb, 0xd419ef6a,
    0xf3e8af98, 0x0f790209, 0xbac8f4b9, 0x46595928, 0xee211e49,
    0x12b0b3d8, 0xa7014568, 0x5b90e8f9, 0x7c61a80b, 0x80f0059a,
    0x3541f32a, 0xc9d05ebb, 0x7aa372ce, 0x8632df5f, 0x338329ef,
    0xcf12847e, 0xe8e3c48c, 0x1472691d, 0xa1c39fad, 0x5d52323c,
    0x7726c744, 0x8bb76ad5, 0x3e069c65, 0xc29731f4, 0xe5667106,
    0x19f7dc97, 0xac462a27, 0x50d787b6, 0xe3a4abc3, 0x1f350652,
    0xaa84f0e2, 0x56155d73, 0x71e41d81, 0x8d75b010, 0x38c446a0,
    0xc455eb31},
   {0x00000000, 0x006c90c1, 0x00d92182, 0x00b5b143, 0x01b24304,
    0x01ded3c5, 0x016b6286, 0x0107f247, 0x03648608, 0x030816c9,
    0x03bda78a, 0x03d1374b, 0x02d6c50c, 0x02ba55cd, 0x020fe48e,
    0x0263744f, 0x06c90c10, 0x06a59cd1, 0x06102d92, 0x067cbd53,
    0x077b4f14, 0x0717dfd5, 0x07a26e96, 0x07cefe57, 0x05ad8a18,
    0x05c11ad9, 0x0574ab9a, 0x05183b5b, 0x041fc91c, 0x047359dd,
    0x04c6e89e, 0x04aa785f, 0x0d921820, 0x0dfe88e1, 0x0d4b39a2,
    0x0d27a963, 0x0c205b24, 0x0c4ccbe5, 0x0cf97aa6, 0x0c95ea67,
    0x0ef69e28, 0x0e9a0ee9, 0x0e2fbfaa, 0x0e432f6b, 0x0f44dd2c,
    0x0f284ded, 0x0f9dfcae, 0x0ff16c6f, 0x0b5b1430, 0x0b3784f1,
    0x0b8235b2, 0x0beea573, 0x0ae95734, 0x0a85c7f5, 0x0a3076b6,
    0x0a5ce677, 0x083f9238, 0x085302f9, 0x08e6b3ba, 0x088a237b,
    0x098dd13c, 0x09e141fd, 0x0954f0be, 0x0938607f, 0x1b243040,
    0x1b48a081, 0x1bfd11c2, 0x1b918103, 0x1a967344, 0x1afae385,
    0x1a4f52c6, 0x1a23c207, 0x1840b648, 0x182c2689, 0x189997ca,
    0x18f5070b, 0x19f2f54c, 0x199e658d, 0x192bd4ce, 0x1947440f,
    0x1ded3c50, 0x1d81ac91, 0x1d341dd2, 0x1d588d13, 0x1c5f7f54,
    0x1c33ef95, 0x1c865ed6, 0x1ceace17, 0x1e89ba58, 0x1ee52a99,
    0x1e509bda, 0x1e3c0b1b, 0x1f3bf95c, 0x1f57699d, 0x1fe2d8de,
    0x1f8e481f, 0x16b62860, 0x16dab8a1, 0x166f09e2, 0x16039923,
    0x17046b64, 0x1768fba5, 0x17dd4ae6, 0x17b1da27, 0x15d2ae68,
    0x15be3ea9, 0x150b8fea, 0x15671f2b, 0x1460ed6c, 0x140c7dad,
    0x14b9ccee, 0x14d55c2f, 0x107f2470, 0x1013b4b1, 0x10a605f2,
    0x10ca9533, 0x11cd6774, 0x11a1f7b5, 0x111446f6, 0x1178d637,
    0x131ba278, 0x137732b9, 0x13c283fa, 0x13ae133b, 0x12a9e17c,
    0x12c571bd, 0x1270c0fe, 0x121c503f, 0x36486080, 0x3624f041,
    0x36914102, 0x36fdd1c3, 0x37fa2384, 0x3796b345, 0x37230206,
    0x374f92c7, 0x352ce688, 0x35407649, 0x35f5c70a, 0x359957cb,
    0x349ea58c, 0x34f2354d, 0x3447840e, 0x342b14cf, 0x30816c90,
    0x30edfc51, 0x30584d12, 0x3034ddd3, 0x31332f94, 0x315fbf55,
    0x31ea0e16, 0x31869ed7, 0x33e5ea98, 0x33897a59, 0x333ccb1a,
    0x33505bdb, 0x3257a99c, 0x323b395d, 0x328e881e, 0x32e218df,
    0x3bda78a0, 0x3bb6e861, 0x3b035922, 0x3b6fc9e3, 0x3a683ba4,
    0x3a04ab65, 0x3ab11a26, 0x3add8ae7, 0x38befea8, 0x38d26e69,
    0x3867df2a, 0x380b4feb, 0x390cbdac, 0x39602d6d, 0x39d59c2e,
    0x39b90cef, 0x3d1374b0, 0x3d7fe471, 0x3dca5532, 0x3da6c5f3,
    0x3ca137b4, 0x3ccda775, 0x3c781636, 0x3c1486f7, 0x3e77f2b8,
    0x3e1b6279, 0x3eaed33a, 0x3ec243fb, 0x3fc5b1bc, 0x3fa9217d,
    0x3f1c903e, 0x3f7000ff, 0x2d6c50c0, 0x2d00c001, 0x2db57142,
    0x2dd9e183, 0x2cde13c4, 0x2cb28305, 0x2c073246, 0x2c6ba287,
    0x2e08d6c8, 0x2e644609, 0x2ed1f74a, 0x2ebd678b, 0x2fba95cc,
    0x2fd6050d, 0x2f63b44e, 0x2f0f248f, 0x2ba55cd0, 0x2bc9cc11,
    0x2b7c7d52, 0x2b10ed93, 0x2a171fd4, 0x2a7b8f15, 0x2ace3e56,
    0x2aa2ae97, 0x28c1dad8, 0x28ad4a19, 0x2818fb5a, 0x28746b9b,
    0x297399dc, 0x291f091d, 0x29aab85e, 0x29c6289f, 0x20fe48e0,
    0x2092d821, 0x20276962, 0x204bf9a3, 0x214c0be4, 0x21209b25,
    0x21952a66, 0x21f9baa7, 0x239acee8, 0x23f65e29, 0x2343ef6a,
    0x232f7fab, 0x22288dec, 0x22441d2d, 0x22f1ac6e, 0x229d3caf,
    0x263744f0, 0x265bd431, 0x26ee6572, 0x2682f5b3, 0x278507f4,
    0x27e99735, 0x275c2676, 0x2730b6b7, 0x2553c2f8, 0x253f5239,
    0x258ae37a, 0x25e673bb, 0x24e181fc, 0x248d113d, 0x2438a07e,
    0x245430bf}};

static const word_t crc_braid_big_table[][256] = {
   {0x0000000000000000, 0xc1906c0000000000, 0x8221d90000000000,
    0x43b1b50000000000, 0x0443b20100000000, 0xc5d3de0100000000,
    0x86626b0100000000, 0x47f2070100000000, 0x0886640300000000,
    0xc916080300000000, 0x8aa7bd0300000000, 0x4b37d10300000000,
    0x0cc5d60200000000, 0xcd55ba0200000000, 0x8ee40f0200000000,
    0x4f74630200000000, 0x100cc90600000000, 0xd19ca50600000000,
    0x922d100600000000, 0x53bd7c0600000000, 0x144f7b0700000000,
    0xd5df170700000000, 0x966ea20700000000, 0x57fece0700000000,
    0x188aad0500000000, 0xd91ac10500000000, 0x9aab740500000000,
    0x5b3b180500000000, 0x1cc91f0400000000, 0xdd59730400000000,
    0x9ee8c60400000000, 0x5f78aa0400000000, 0x2018920d00000000,
    0xe188fe0d00000000, 0xa2394b0d00000000, 0x63a9270d00000000,
    0x245b200c00000000, 0xe5cb4c0c00000000, 0xa67af90c00000000,
    0x67ea950c00000000, 0x289ef60e00000000, 0xe90e9a0e00000000,
    0xaabf2f0e00000000, 0x6b2f430e00000000, 0x2cdd440f00000000,
    0xed4d280f00000000, 0xaefc9d0f00000000, 0x6f6cf10f00000000,
    0x30145b0b00000000, 0xf184370b00000000, 0xb235820b00000000,
    0x73a5ee0b00000000, 0x3457e90a00000000, 0xf5c7850a00000000,
    0xb676300a00000000, 0x77e65c0a00000000, 0x38923f0800000000,
    0xf902530800000000, 0xbab3e60800000000, 0x7b238a0800000000,
    0x3cd18d0900000000, 0xfd41e10900000000, 0xbef0540900000000,
    0x7f60380900000000, 0x4030241b00000000, 0x81a0481b00000000,
    0xc211fd1b00000000, 0x0381911b00000000, 0x4473961a00000000,
    0x85e3fa1a00000000, 0xc6524f1a00000000, 0x07c2231a00000000,
    0x48b6401800000000, 0x89262c1800000000, 0xca97991800000000,
    0x0b07f51800000000, 0x4cf5f21900000000, 0x8d659e1900000000,
    0xced42b1900000000, 0x0f44471900000000, 0x503ced1d00000000,
    0x91ac811d00000000, 0xd21d341d00000000, 0x138d581d00000000,
    0x547f5f1c00000000, 0x95ef331c00000000, 0xd65e861c00000000,
    0x17ceea1c00000000, 0x58ba891e00000000, 0x992ae51e00000000,
    0xda9b501e00000000, 0x1b0b3c1e00000000, 0x5cf93b1f00000000,
    0x9d69571f00000000, 0xded8e21f00000000, 0x1f488e1f00000000,
    0x6028b61600000000, 0xa1b8da1600000000, 0xe2096f1600000000,
    0x2399031600000000, 0x646b041700000000, 0xa5fb681700000000,
    0xe64add1700000000, 0x27dab11700000000, 0x68aed21500000000,
    0xa93ebe1500000000, 0xea8f0b1500000000, 0x2b1f671500000000,
    0x6ced601400000000, 0xad7d0c1400000000, 0xeeccb91400000000,
    0x2f5cd51400000000, 0x70247f1000000000, 0xb1b4131000000000,
    0xf205a61000000000, 0x3395ca1000000000, 0x7467cd1100000000,
    0xb5f7a11100000000, 0xf646141100000000, 0x37d6781100000000,
    0x78a21b1300000000, 0xb932771300000000, 0xfa83c21300000000,
    0x3b13ae1300000000, 0x7ce1a91200000000, 0xbd71c51200000000,
    0xfec0701200000000, 0x3f501c1200000000, 0x8060483600000000,
    0x41f0243600000000, 0x0241913600000000, 0xc3d1fd3600000000,
    0x8423fa3700000000, 0x45b3963700000000, 0x0602233700000000,
    0xc7924f3700000000, 0x88e62c3500000000, 0x4976403500000000,
    0x0ac7f53500000000, 0xcb57993500000000, 0x8ca59e3400000000,
    0x4d35f23400000000, 0x0e84473400000000, 0xcf142b3400000000,
    0x906c813000000000, 0x51fced3000000000, 0x124d583000000000,
    0xd3dd343000000000, 0x942f333100000000, 0x55bf5f3100000000,
    0x160eea3100000000, 0xd79e863100000000, 0x98eae53300000000,
    0x597a893300000000, 0x1acb3c3300000000, 0xdb5b503300000000,
    0x9ca9573200000000, 0x5d393b3200000000, 0x1e888e3200000000,
    0xdf18e23200000000, 0xa078da3b00000000, 0x61e8b63b00000000,
    0x2259033b00000000, 0xe3c96f3b00000000, 0xa43b683a00000000,
    0x65ab043a00000000, 0x261ab13a00000000, 0xe78add3a00000000,
    0xa8febe3800000000, 0x696ed23800000000, 0x2adf673800000000,
    0xeb4f0b3800000000, 0xacbd0c3900000000, 0x6d2d603900000000,
    0x2e9cd53900000000, 0xef0cb93900000000, 0xb074133d00000000,
    0x71e47f3d00000000, 0x3255ca3d00000000, 0xf3c5a63d00000000,
    0xb437a13c00000000, 0x75a7cd3c00000000, 0x3616783c00000000,
    0xf786143c00000000, 0xb8f2773e00000000, 0x79621b3e00000000,
    0x3ad3ae3e00000000, 0xfb43c23e00000000, 0xbcb1c53f00000000,
    0x7d21a93f00000000, 0x3e901c3f00000000, 0xff00703f00000000,
    0xc0506c2d00000000, 0x01c0002d00000000, 0x4271b52d00000000,
    0x83e1d92d00000000, 0xc413de2c00000000, 0x0583b22c00000000,
    0x4632072c00000000, 0x87a26b2c00000000, 0xc8d6082e00000000,
    0x0946642e00000000, 0x4af7d12e00000000, 0x8b67bd2e00000000,
    0xcc95ba2f00000000, 0x0d05d62f00000000, 0x4eb4632f00000000,
    0x8f240f2f00000000, 0xd05ca52b00000000, 0x11ccc92b00000000,
    0x527d7c2b00000000, 0x93ed102b00000000, 0xd41f172a00000000,
    0x158f7b2a00000000, 0x563ece2a00000000, 0x97aea22a00000000,
    0xd8dac12800000000, 0x194aad2800000000, 0x5afb182800000000,
    0x9b6b742800000000, 0xdc99732900000000, 0x1d091f2900000000,
    0x5eb8aa2900000000, 0x9f28c62900000000, 0xe048fe2000000000,
    0x21d8922000000000, 0x6269272000000000, 0xa3f94b2000000000,
    0xe40b4c2100000000, 0x259b202100000000, 0x662a952100000000,
    0xa7baf92100000000, 0xe8ce9a2300000000, 0x295ef62300000000,
    0x6aef432300000000, 0xab7f2f2300000000, 0xec8d282200000000,
    0x2d1d442200000000, 0x6eacf12200000000, 0xaf3c9d2200000000,
    0xf044372600000000, 0x31d45b2600000000, 0x7265ee2600000000,
    0xb3f5822600000000, 0xf407852700000000, 0x3597e92700000000,
    0x76265c2700000000, 0xb7b6302700000000, 0xf8c2532500000000,
    0x39523f2500000000, 0x7ae38a2500000000, 0xbb73e62500000000,
    0xfc81e12400000000, 0x3d118d2400000000, 0x7ea0382400000000,
    0xbf30542400000000},
   {0x0000000000000000, 0x91ad91fc00000000, 0x215b204900000000,
    0xb0f6b1b500000000, 0x42b6409200000000, 0xd31bd16e00000000,
    0x63ed60db00000000, 0xf240f12700000000, 0x876c829400000000,
    0x16c1136800000000, 0xa637a2dd00000000, 0x379a332100000000,
    0xc5dac20600000000, 0x547753fa00000000, 0xe481e24f00000000,
    0x752c73b300000000, 0x0dd9079900000000, 0x9c74966500000000,
    0x2c8227d000000000, 0xbd2fb62c00000000, 0x4f6f470b00000000,
    0xdec2d6f700000000, 0x6e34674200000000, 0xff99f6be00000000,
    0x8ab5850d00000000, 0x1b1814f100000000, 0xabeea54400000000,
    0x3a4334b800000000, 0xc803c59f00000000, 0x59ae546300000000,
    0xe958e5d600000000, 0x78f5742a00000000, 0x19b20c8200000000,
    0x881f9d7e00000000, 0x38e92ccb00000000, 0xa944bd3700000000,
    0x5b044c1000000000, 0xcaa9ddec00000000, 0x7a5f6c5900000000,
    0xebf2fda500000000, 0x9ede8e1600000000, 0x0f731fea00000000,
    0xbf85ae5f00000000, 0x2e283fa300000000, 0xdc68ce8400000000,
    0x4dc55f7800000000, 0xfd33eecd00000000, 0x6c9e7f3100000000,
    0x146b0b1b00000000, 0x85c69ae700000000, 0x35302b5200000000,
    0xa49dbaae00000000, 0x56dd4b8900000000, 0xc770da7500000000,
    0x77866bc000000000, 0xe62bfa3c00000000, 0x9307898f00000000,
    0x02aa187300000000, 0xb25ca9c600000000, 0x23f1383a00000000,
    0xd1b1c91d00000000, 0x401c58e100000000, 0xf0eae95400000000,
    0x614778a800000000, 0x31641ab400000000, 0xa0c98b4800000000,
    0x103f3afd00000000, 0x8192ab0100000000, 0x73d25a2600000000,
    0xe27fcbda00000000, 0x52897a6f00000000, 0xc324eb9300000000,
    0xb608982000000000, 0x27a509dc00000000, 0x9753b86900000000,
    0x06fe299500000000, 0xf4bed8b200000000, 0x6513494e00000000,
    0xd5e5f8fb00000000, 0x4448690700000000, 0x3cbd1d2d00000000,
    0xad108cd100000000, 0x1de63d6400000000, 0x8c4bac9800000000,
    0x7e0b5dbf00000000, 0xefa6cc4300000000, 0x5f507df600000000,
    0xcefdec0a00000000, 0xbbd19fb900000000, 0x2a7c0e4500000000,
    0x9a8abff000000000, 0x0b272e0c00000000, 0xf967df2b00000000,
    0x68ca4ed700000000, 0xd83cff6200000000, 0x49916e9e00000000,
    0x28d6163600000000, 0xb97b87ca00000000, 0x098d367f00000000,
    0x9820a78300000000, 0x6a6056a400000000, 0xfbcdc75800000000,
    0x4b3b76ed00000000, 0xda96e71100000000, 0xafba94a200000000,
    0x3e17055e00000000, 0x8ee1b4eb00000000, 0x1f4c251700000000,
    0xed0cd43000000000, 0x7ca145cc00000000, 0xcc57f47900000000,
    0x5dfa658500000000, 0x250f11af00000000, 0xb4a2805300000000,
    0x045431e600000000, 0x95f9a01a00000000, 0x67b9513d00000000,
    0xf614c0c100000000, 0x46e2717400000000, 0xd74fe08800000000,
    0xa263933b00000000, 0x33ce02c700000000, 0x8338b37200000000,
    0x1295228e00000000, 0xe0d5d3a900000000, 0x7178425500000000,
    0xc18ef3e000000000, 0x5023621c00000000, 0x61c837d800000000,
    0xf065a62400000000, 0x4093179100000000, 0xd13e866d00000000,
    0x237e774a00000000, 0xb2d3e6b600000000, 0x0225570300000000,
    0x9388c6ff00000000, 0xe6a4b54c00000000, 0x770924b000000000,
    0xc7ff950500000000, 0x565204f900000000, 0xa412f5de00000000,
    0x35bf642200000000, 0x8549d59700000000, 0x14e4446b00000000,
    0x6c11304100000000, 0xfdbca1bd00000000, 0x4d4a100800000000,
    0xdce781f400000000, 0x2ea770d300000000, 0xbf0ae12f00000000,
    0x0ffc509a00000000, 0x9e51c16600000000, 0xeb7db2d500000000,
    0x7ad0232900000000, 0xca26929c00000000, 0x5b8b036000000000,
    0xa9cbf24700000000, 0x386663bb00000000, 0x8890d20e00000000,
    0x193d43f200000000, 0x787a3b5a00000000, 0xe9d7aaa600000000,
    0x59211b1300000000, 0xc88c8aef00000000, 0x3acc7bc800000000,
    0xab61ea3400000000, 0x1b975b8100000000, 0x8a3aca7d00000000,
    0xff16b9ce00000000, 0x6ebb283200000000, 0xde4d998700000000,
    0x4fe0087b00000000, 0xbda0f95c00000000, 0x2c0d68a000000000,
    0x9cfbd91500000000, 0x0d5648e900000000, 0x75a33cc300000000,
    0xe40ead3f00000000, 0x54f81c8a00000000, 0xc5558d7600000000,
    0x37157c5100000000, 0xa6b8edad00000000, 0x164e5c1800000000,
    0x87e3cde400000000, 0xf2cfbe5700000000, 0x63622fab00000000,
    0xd3949e1e00000000, 0x42390fe200000000, 0xb079fec500000000,
    0x21d46f3900000000, 0x9122de8c00000000, 0x008f4f7000000000,
    0x50ac2d6c00000000, 0xc101bc9000000000, 0x71f70d2500000000,
    0xe05a9cd900000000, 0x121a6dfe00000000, 0x83b7fc0200000000,
    0x33414db700000000, 0xa2ecdc4b00000000, 0xd7c0aff800000000,
    0x466d3e0400000000, 0xf69b8fb100000000, 0x67361e4d00000000,
    0x9576ef6a00000000, 0x04db7e9600000000, 0xb42dcf2300000000,
    0x25805edf00000000, 0x5d752af500000000, 0xccd8bb0900000000,
    0x7c2e0abc00000000, 0xed839b4000000000, 0x1fc36a6700000000,
    0x8e6efb9b00000000, 0x3e984a2e00000000, 0xaf35dbd200000000,
    0xda19a86100000000, 0x4bb4399d00000000, 0xfb42882800000000,
    0x6aef19d400000000, 0x98afe8f300000000, 0x0902790f00000000,
    0xb9f4c8ba00000000, 0x2859594600000000, 0x491e21ee00000000,
    0xd8b3b01200000000, 0x684501a700000000, 0xf9e8905b00000000,
    0x0ba8617c00000000, 0x9a05f08000000000, 0x2af3413500000000,
    0xbb5ed0c900000000, 0xce72a37a00000000, 0x5fdf328600000000,
    0xef29833300000000, 0x7e8412cf00000000, 0x8cc4e3e800000000,
    0x1d69721400000000, 0xad9fc3a100000000, 0x3c32525d00000000,
    0x44c7267700000000, 0xd56ab78b00000000, 0x659c063e00000000,
    0xf43197c200000000, 0x067166e500000000, 0x97dcf71900000000,
    0x272a46ac00000000, 0xb687d75000000000, 0xc3aba4e300000000,
    0x5206351f00000000, 0xe2f084aa00000000, 0x735d155600000000,
    0x811de47100000000, 0x10b0758d00000000, 0xa046c43800000000,
    0x31eb55c400000000},
   {0x0000000000000000, 0xac006dd100000000, 0x5b01d91200000000,
    0xf701b4c300000000, 0xb602b22500000000, 0x1a02dff400000000,
    0xed036b3700000000, 0x410306e600000000, 0x6c05644b00000000,
    0xc005099a00000000, 0x3704bd5900000000, 0x9b04d08800000000,
    0xda07d66e00000000, 0x7607bbbf00000000, 0x81060f7c00000000,
    0x2d0662ad00000000, 0xd80ac89600000000, 0x740aa54700000000,
    0x830b118400000000, 0x2f0b7c5500000000, 0x6e087ab300000000,
    0xc208176200000000, 0x3509a3a100000000, 0x9909ce7000000000,
    0xb40facdd00000000, 0x180fc10c00000000, 0xef0e75cf00000000,
    0x430e181e00000000, 0x020d1ef800000000, 0xae0d732900000000,
    0x590cc7ea00000000, 0xf50caa3b00000000, 0xb315939d00000000,
    0x1f15fe4c00000000, 0xe8144a8f00000000, 0x4414275e00000000,
    0x051721b800000000, 0xa9174c6900000000, 0x5e16f8aa00000000,
    0xf216957b00000000, 0xdf10f7d600000000, 0x73109a0700000000,
    0x84112ec400000000, 0x2811431500000000, 0x691245f300000000,
    0xc512282200000000, 0x32139ce100000000, 0x9e13f13000000000,
    0x6b1f5b0b00000000, 0xc71f36da00000000, 0x301e821900000000,
    0x9c1eefc800000000, 0xdd1de92e00000000, 0x711d84ff00000000,
    0x861c303c00000000, 0x2a1c5ded00000000, 0x071a3f4000000000,
    0xab1a529100000000, 0x5c1be65200000000, 0xf01b8b8300000000,
    0xb1188d6500000000, 0x1d18e0b400000000, 0xea19547700000000,
    0x461939a600000000, 0x652b258b00000000, 0xc92b485a00000000,
    0x3e2afc9900000000, 0x922a914800000000, 0xd32997ae00000000,
    0x7f29fa7f00000000, 0x88284ebc00000000, 0x2428236d00000000,
    0x092e41c000000000, 0xa52e2c1100000000, 0x522f98d200000000,
    0xfe2ff50300000000, 0xbf2cf3e500000000, 0x132c9e3400000000,
    0xe42d2af700000000, 0x482d472600000000, 0xbd21ed1d00000000,
    0x112180cc00000000, 0xe620340f00000000, 0x4a2059de00000000,
    0x0b235f3800000000, 0xa72332e900000000, 0x5022862a00000000,
    0xfc22ebfb00000000, 0xd124895600000000, 0x7d24e48700000000,
    0x8a25504400000000, 0x26253d9500000000, 0x67263b7300000000,
    0xcb2656a200000000, 0x3c27e26100000000, 0x90278fb000000000,
    0xd63eb61600000000, 0x7a3edbc700000000, 0x8d3f6f0400000000,
    0x213f02d500000000, 0x603c043300000000, 0xcc3c69e200000000,
    0x3b3ddd2100000000, 0x973db0f000000000, 0xba3bd25d00000000,
    0x163bbf8c00000000, 0xe13a0b4f00000000, 0x4d3a669e00000000,
    0x0c39607800000000, 0xa0390da900000000, 0x5738b96a00000000,
    0xfb38d4bb00000000, 0x0e347e8000000000, 0xa234135100000000,
    0x5535a79200000000, 0xf935ca4300000000, 0xb836cca500000000,
    0x1436a17400000000, 0xe33715b700000000, 0x4f37786600000000,
    0x62311acb00000000, 0xce31771a00000000, 0x3930c3d900000000,
    0x9530ae0800000000, 0xd433a8ee00000000, 0x7833c53f00000000,
    0x8f3271fc00000000, 0x23321c2d00000000, 0xc95649a600000000,
    0x6556247700000000, 0x925790b400000000, 0x3e57fd6500000000,
    0x7f54fb8300000000, 0xd354965200000000, 0x2455229100000000,
    0x88554f4000000000, 0xa5532ded00000000, 0x0953403c00000000,
    0xfe52f4ff00000000, 0x5252992e00000000, 0x13519fc800000000,
    0xbf51f21900000000, 0x485046da00000000, 0xe4502b0b00000000,
    0x115c813000000000, 0xbd5cece100000000, 0x4a5d582200000000,
    0xe65d35f300000000, 0xa75e331500000000, 0x0b5e5ec400000000,
    0xfc5fea0700000000, 0x505f87d600000000, 0x7d59e57b00000000,
    0xd15988aa00000000, 0x26583c6900000000, 0x8a5851b800000000,
    0xcb5b575e00000000, 0x675b3a8f00000000, 0x905a8e4c00000000,
    0x3c5ae39d00000000, 0x7a43da3b00000000, 0xd643b7ea00000000,
    0x2142032900000000, 0x8d426ef800000000, 0xcc41681e00000000,
    0x604105cf00000000, 0x9740b10c00000000, 0x3b40dcdd00000000,
    0x1646be7000000000, 0xba46d3a100000000, 0x4d47676200000000,
    0xe1470ab300000000, 0xa0440c5500000000, 0x0c44618400000000,
    0xfb45d54700000000, 0x5745b89600000000, 0xa24912ad00000000,
    0x0e497f7c00000000, 0xf948cbbf00000000, 0x5548a66e00000000,
    0x144ba08800000000, 0xb84bcd5900000000, 0x4f4a799a00000000,
    0xe34a144b00000000, 0xce4c76e600000000, 0x624c1b3700000000,
    0x954daff400000000, 0x394dc22500000000, 0x784ec4c300000000,
    0xd44ea91200000000, 0x234f1dd100000000, 0x8f4f700000000000,
    0xac7d6c2d00000000, 0x007d01fc00000000, 0xf77cb53f00000000,
    0x5b7cd8ee00000000, 0x1a7fde0800000000, 0xb67fb3d900000000,
    0x417e071a00000000, 0xed7e6acb00000000, 0xc078086600000000,
    0x6c7865b700000000, 0x9b79d17400000000, 0x3779bca500000000,
    0x767aba4300000000, 0xda7ad79200000000, 0x2d7b635100000000,
    0x817b0e8000000000, 0x7477a4bb00000000, 0xd877c96a00000000,
    0x2f767da900000000, 0x8376107800000000, 0xc275169e00000000,
    0x6e757b4f00000000, 0x9974cf8c00000000, 0x3574a25d00000000,
    0x1872c0f000000000, 0xb472ad2100000000, 0x437319e200000000,
    0xef73743300000000, 0xae7072d500000000, 0x02701f0400000000,
    0xf571abc700000000, 0x5971c61600000000, 0x1f68ffb000000000,
    0xb368926100000000, 0x446926a200000000, 0xe8694b7300000000,
    0xa96a4d9500000000, 0x056a204400000000, 0xf26b948700000000,
    0x5e6bf95600000000, 0x736d9bfb00000000, 0xdf6df62a00000000,
    0x286c42e900000000, 0x846c2f3800000000, 0xc56f29de00000000,
    0x696f440f00000000, 0x9e6ef0cc00000000, 0x326e9d1d00000000,
    0xc762372600000000, 0x6b625af700000000, 0x9c63ee3400000000,
    0x306383e500000000, 0x7160850300000000, 0xdd60e8d200000000,
    0x2a615c1100000000, 0x866131c000000000, 0xab67536d00000000,
    0x07673ebc00000000, 0xf0668a7f00000000, 0x5c66e7ae00000000,
    0x1d65e14800000000, 0xb1658c9900000000, 0x4664385a00000000,
    0xea64558b00000000},
   {0x0000000000000000, 0x00c1115c00000000, 0x008223b800000000,
    0x004332e400000000, 0x030444c000000000, 0x03c5559c00000000,
    0x0386677800000000, 0x0347762400000000, 0x05088b3000000000,
    0x05c99a6c00000000, 0x058aa88800000000, 0x054bb9d400000000,
    0x060ccff000000000, 0x06cddeac00000000, 0x068eec4800000000,
    0x064ffd1400000000, 0x0a10166100000000, 0x0ad1073d00000000,
    0x0a9235d900000000, 0x0a53248500000000, 0x091452a100000000,
    0x09d543fd00000000, 0x0996711900000000, 0x0957604500000000,
    0x0f189d5100000000, 0x0fd98c0d00000000, 0x0f9abee900000000,
    0x0f5bafb500000000, 0x0c1cd99100000000, 0x0cddc8cd00000000,
    0x0c9efa2900000000, 0x0c5feb7500000000, 0x14202cc200000000,
    0x14e13d9e00000000, 0x14a20f7a00000000, 0x14631e2600000000,
    0x1724680200000000, 0x17e5795e00000000, 0x17a64bba00000000,
    0x17675ae600000000, 0x1128a7f200000000, 0x11e9b6ae00000000,
    0x11aa844a00000000, 0x116b951600000000, 0x122ce33200000000,
    0x12edf26e00000000, 0x12aec08a00000000, 0x126fd1d600000000,
    0x1e303aa300000000, 0x1ef12bff00000000, 0x1eb2191b00000000,
    0x1e73084700000000, 0x1d347e6300000000, 0x1df56f3f00000000,
    0x1db65ddb00000000, 0x1d774c8700000000, 0x1b38b19300000000,
    0x1bf9a0cf00000000, 0x1bba922b00000000, 0x1b7b837700000000,
    0x183cf55300000000, 0x18fde40f00000000, 0x18bed6eb00000000,
    0x187fc7b700000000, 0x2b405b3400000000, 0x2b814a6800000000,
    0x2bc2788c00000000, 0x2b0369d000000000, 0x28441ff400000000,
    0x28850ea800000000, 0x28c63c4c00000000, 0x28072d1000000000,
    0x2e48d00400000000, 0x2e89c15800000000, 0x2ecaf3bc00000000,
    0x2e0be2e000000000, 0x2d4c94c400000000, 0x2d8d859800000000,
    0x2dceb77c00000000, 0x2d0fa62000000000, 0x21504d5500000000,
    0x21915c0900000000, 0x21d26eed00000000, 0x21137fb100000000,
    0x2254099500000000, 0x229518c900000000, 0x22d62a2d00000000,
    0x22173b7100000000, 0x2458c66500000000, 0x2499d73900000000,
    0x24dae5dd00000000, 0x241bf48100000000, 0x275c82a500000000,
    0x279d93f900000000, 0x27dea11d00000000, 0x271fb04100000000,
    0x3f6077f600000000, 0x3fa166aa00000000, 0x3fe2544e00000000,
    0x3f23451200000000, 0x3c64333600000000, 0x3ca5226a00000000,
    0x3ce6108e00000000, 0x3c2701d200000000, 0x3a68fcc600000000,
    0x3aa9ed9a00000000, 0x3aeadf7e00000000, 0x3a2bce2200000000,
    0x396cb80600000000, 0x39ada95a00000000, 0x39ee9bbe00000000,
    0x392f8ae200000000, 0x3570619700000000, 0x35b170cb00000000,
    0x35f2422f00000000, 0x3533537300000000, 0x3674255700000000,
    0x36b5340b00000000, 0x36f606ef00000000, 0x363717b300000000,
    0x3078eaa700000000, 0x30b9fbfb00000000, 0x30fac91f00000000,
    0x303bd84300000000, 0x337cae6700000000, 0x33bdbf3b00000000,
    0x33fe8ddf00000000, 0x333f9c8300000000, 0x5680b66800000000,
    0x5641a73400000000, 0x560295d000000000, 0x56c3848c00000000,
    0x5584f2a800000000, 0x5545e3f400000000, 0x5506d11000000000,
    0x55c7c04c00000000, 0x53883d5800000000, 0x53492c0400000000,
    0x530a1ee000000000, 0x53cb0fbc00000000, 0x508c799800000000,
    0x504d68c400000000, 0x500e5a2000000000, 0x50cf4b7c00000000,
    0x5c90a00900000000, 0x5c51b15500000000, 0x5c1283b100000000,
    0x5cd392ed00000000, 0x5f94e4c900000000, 0x5f55f59500000000,
    0x5f16c77100000000, 0x5fd7d62d00000000, 0x59982b3900000000,
    0x59593a6500000000, 0x591a088100000000, 0x59db19dd00000000,
    0x5a9c6ff900000000, 0x5a5d7ea500000000, 0x5a1e4c4100000000,
    0x5adf5d1d00000000, 0x42a09aaa00000000, 0x42618bf600000000,
    0x4222b91200000000, 0x42e3a84e00000000, 0x41a4de6a00000000,
    0x4165cf3600000000, 0x4126fdd200000000, 0x41e7ec8e00000000,
    0x47a8119a00000000, 0x476900c600000000, 0x472a322200000000,
    0x47eb237e00000000, 0x44ac555a00000000, 0x446d440600000000,
    0x442e76e200000000, 0x44ef67be00000000, 0x48b08ccb00000000,
    0x48719d9700000000, 0x4832af7300000000, 0x48f3be2f00000000,
    0x4bb4c80b00000000, 0x4b75d95700000000, 0x4b36ebb300000000,
    0x4bf7faef00000000, 0x4db807fb00000000, 0x4d7916a700000000,
    0x4d3a244300000000, 0x4dfb351f00000000, 0x4ebc433b00000000,
    0x4e7d526700000000, 0x4e3e608300000000, 0x4eff71df00000000,
    0x7dc0ed5c00000000, 0x7d01fc0000000000, 0x7d42cee400000000,
    0x7d83dfb800000000, 0x7ec4a99c00000000, 0x7e05b8c000000000,
    0x7e468a2400000000, 0x7e879b7800000000, 0x78c8666c00000000,
    0x7809773000000000, 0x784a45d400000000, 0x788b548800000000,
    0x7bcc22ac00000000, 0x7b0d33f000000000, 0x7b4e011400000000,
    0x7b8f104800000000, 0x77d0fb3d00000000, 0x7711ea6100000000,
    0x7752d88500000000, 0x7793c9d900000000, 0x74d4bffd00000000,
    0x7415aea100000000, 0x74569c4500000000, 0x74978d1900000000,
    0x72d8700d00000000, 0x7219615100000000, 0x725a53b500000000,
    0x729b42e900000000, 0x71dc34cd00000000, 0x711d259100000000,
    0x715e177500000000, 0x719f062900000000, 0x69e0c19e00000000,
    0x6921d0c200000000, 0x6962e22600000000, 0x69a3f37a00000000,
    0x6ae4855e00000000, 0x6a25940200000000, 0x6a66a6e600000000,
    0x6aa7b7ba00000000, 0x6ce84aae00000000, 0x6c295bf200000000,
    0x6c6a691600000000, 0x6cab784a00000000, 0x6fec0e6e00000000,
    0x6f2d1f3200000000, 0x6f6e2dd600000000, 0x6faf3c8a00000000,
    0x63f0d7ff00000000, 0x6331c6a300000000, 0x6372f44700000000,
    0x63b3e51b00000000, 0x60f4933f00000000, 0x6035826300000000,
    0x6076b08700000000, 0x60b7a1db00000000, 0x66f85ccf00000000,
    0x66394d9300000000, 0x667a7f7700000000, 0x66bb6e2b00000000,
    0x65fc180f00000000, 0x653d095300000000, 0x657e3bb700000000,
    0x65bf2aeb00000000},
   {0x0000000000000000, 0xc1115c0000000000, 0x8223b80000000000,
    0x4332e40000000000, 0x0447700100000000, 0xc5562c0100000000,
    0x8664c80100000000, 0x4775940100000000, 0x088ee00200000000,
    0xc99fbc0200000000, 0x8aad580200000000, 0x4bbc040200000000,
    0x0cc9900300000000, 0xcdd8cc0300000000, 0x8eea280300000000,
    0x4ffb740300000000, 0x101cc10500000000, 0xd10d9d0500000000,
    0x923f790500000000, 0x532e250500000000, 0x145bb10400000000,
    0xd54aed0400000000, 0x9678090400000000, 0x5769550400000000,
    0x1892210700000000, 0xd9837d0700000000, 0x9ab1990700000000,
    0x5ba0c50700000000, 0x1cd5510600000000, 0xddc40d0600000000,
    0x9ef6e90600000000, 0x5fe7b50600000000, 0x2038820b00000000,
    0xe129de0b00000000, 0xa21b3a0b00000000, 0x630a660b00000000,
    0x247ff20a00000000, 0xe56eae0a00000000, 0xa65c4a0a00000000,
    0x674d160a00000000, 0x28b6620900000000, 0xe9a73e0900000000,
    0xaa95da0900000000, 0x6b84860900000000, 0x2cf1120800000000,
    0xede04e0800000000, 0xaed2aa0800000000, 0x6fc3f60800000000,
    0x3024430e00000000, 0xf1351f0e00000000, 0xb207fb0e00000000,
    0x7316a70e00000000, 0x3463330f00000000, 0xf5726f0f00000000,
    0xb6408b0f00000000, 0x7751d70f00000000, 0x38aaa30c00000000,
    0xf9bbff0c00000000, 0xba891b0c00000000, 0x7b98470c00000000,
    0x3cedd30d00000000, 0xfdfc8f0d00000000, 0xbece6b0d00000000,
    0x7fdf370d00000000, 0x4070041700000000, 0x8161581700000000,
    0xc253bc1700000000, 0x0342e01700000000, 0x4437741600000000,
    0x8526281600000000, 0xc614cc1600000000, 0x0705901600000000,
    0x48fee41500000000, 0x89efb81500000000, 0xcadd5c1500000000,
    0x0bcc001500000000, 0x4cb9941400000000, 0x8da8c81400000000,
    0xce9a2c1400000000, 0x0f8b701400000000, 0x506cc51200000000,
    0x917d991200000000, 0xd24f7d1200000000, 0x135e211200000000,
    0x542bb51300000000, 0x953ae91300000000, 0xd6080d1300000000,
    0x1719511300000000, 0x58e2251000000000, 0x99f3791000000000,
    0xdac19d1000000000, 0x1bd0c11000000000, 0x5ca5551100000000,
    0x9db4091100000000, 0xde86ed1100000000, 0x1f97b11100000000,
    0x6048861c00000000, 0xa159da1c00000000, 0xe26b3e1c00000000,
    0x237a621c00000000, 0x640ff61d00000000, 0xa51eaa1d00000000,
    0xe62c4e1d00000000, 0x273d121d00000000, 0x68c6661e00000000,
    0xa9d73a1e00000000, 0xeae5de1e00000000, 0x2bf4821e00000000,
    0x6c81161f00000000, 0xad904a1f00000000, 0xeea2ae1f00000000,
    0x2fb3f21f00000000, 0x7054471900000000, 0xb1451b1900000000,
    0xf277ff1900000000, 0x3366a31900000000, 0x7413371800000000,
    0xb5026b1800000000, 0xf6308f1800000000, 0x3721d31800000000,
    0x78daa71b00000000, 0xb9cbfb1b00000000, 0xfaf91f1b00000000,
    0x3be8431b00000000, 0x7c9dd71a00000000, 0xbd8c8b1a00000000,
    0xfebe6f1a00000000, 0x3faf331a00000000, 0x80e0082e00000000,
    0x41f1542e00000000, 0x02c3b02e00000000, 0xc3d2ec2e00000000,
    0x84a7782f00000000, 0x45b6242f00000000, 0x0684c02f00000000,
    0xc7959c2f00000000, 0x886ee82c00000000, 0x497fb42c00000000,
    0x0a4d502c00000000, 0xcb5c0c2c00000000, 0x8c29982d00000000,
    0x4d38c42d00000000, 0x0e0a202d00000000, 0xcf1b7c2d00000000,
    0x90fcc92b00000000, 0x51ed952b00000000, 0x12df712b00000000,
    0xd3ce2d2b00000000, 0x94bbb92a00000000, 0x55aae52a00000000,
    0x1698012a00000000, 0xd7895d2a00000000, 0x9872292900000000,
    0x5963752900000000, 0x1a51912900000000, 0xdb40cd2900000000,
    0x9c35592800000000, 0x5d24052800000000, 0x1e16e12800000000,
    0xdf07bd2800000000, 0xa0d88a2500000000, 0x61c9d62500000000,
    0x22fb322500000000, 0xe3ea6e2500000000, 0xa49ffa2400000000,
    0x658ea62400000000, 0x26bc422400000000, 0xe7ad1e2400000000,
    0xa8566a2700000000, 0x6947362700000000, 0x2a75d22700000000,
    0xeb648e2700000000, 0xac111a2600000000, 0x6d00462600000000,
    0x2e32a22600000000, 0xef23fe2600000000, 0xb0c44b2000000000,
    0x71d5172000000000, 0x32e7f32000000000, 0xf3f6af2000000000,
    0xb4833b2100000000, 0x7592672100000000, 0x36a0832100000000,
    0xf7b1df2100000000, 0xb84aab2200000000, 0x795bf72200000000,
    0x3a69132200000000, 0xfb784f2200000000, 0xbc0ddb2300000000,
    0x7d1c872300000000, 0x3e2e632300000000, 0xff3f3f2300000000,
    0xc0900c3900000000, 0x0181503900000000, 0x42b3b43900000000,
    0x83a2e83900000000, 0xc4d77c3800000000, 0x05c6203800000000,
    0x46f4c43800000000, 0x87e5983800000000, 0xc81eec3b00000000,
    0x090fb03b00000000, 0x4a3d543b00000000, 0x8b2c083b00000000,
    0xcc599c3a00000000, 0x0d48c03a00000000, 0x4e7a243a00000000,
    0x8f6b783a00000000, 0xd08ccd3c00000000, 0x119d913c00000000,
    0x52af753c00000000, 0x93be293c00000000, 0xd4cbbd3d00000000,
    0x15dae13d00000000, 0x56e8053d00000000, 0x97f9593d00000000,
    0xd8022d3e00000000, 0x1913713e00000000, 0x5a21953e00000000,
    0x9b30c93e00000000, 0xdc455d3f00000000, 0x1d54013f00000000,
    0x5e66e53f00000000, 0x9f77b93f00000000, 0xe0a88e3200000000,
    0x21b9d23200000000, 0x628b363200000000, 0xa39a6a3200000000,
    0xe4effe3300000000, 0x25fea23300000000, 0x66cc463300000000,
    0xa7dd1a3300000000, 0xe8266e3000000000, 0x2937323000000000,
    0x6a05d63000000000, 0xab148a3000000000, 0xec611e3100000000,
    0x2d70423100000000, 0x6e42a63100000000, 0xaf53fa3100000000,
    0xf0b44f3700000000, 0x31a5133700000000, 0x7297f73700000000,
    0xb386ab3700000000, 0xf4f33f3600000000, 0x35e2633600000000,
    0x76d0873600000000, 0xb7c1db3600000000, 0xf83aaf3500000000,
    0x392bf33500000000, 0x7a19173500000000, 0xbb084b3500000000,
    0xfc7ddf3400000000, 0x3d6c833400000000, 0x7e5e673400000000,
    0xbf4f3b3400000000},
   {0x0000000000000000, 0x109d91fc00000000, 0x233a204900000000,
    0x33a7b1b500000000, 0x4674409200000000, 0x56e9d16e00000000,
    0x654e60db00000000, 0x75d3f12700000000, 0x8fe8839400000000,
    0x9f75126800000000, 0xacd2a3dd00000000, 0xbc4f322100000000,
    0xc99cc30600000000, 0xd90152fa00000000, 0xeaa6e34f00000000,
    0xfa3b72b300000000, 0x1dd1049900000000, 0x0d4c956500000000,
    0x3eeb24d000000000, 0x2e76b52c00000000, 0x5ba5440b00000000,
    0x4b38d5f700000000, 0x789f644200000000, 0x6802f5be00000000,
    0x9239870d00000000, 0x82a416f100000000, 0xb103a74400000000,
    0xa19e36b800000000, 0xd44dc79f00000000, 0xc4d0566300000000,
    0xf777e7d600000000, 0xe7ea762a00000000, 0x39a20a8200000000,
    0x293f9b7e00000000, 0x1a982acb00000000, 0x0a05bb3700000000,
    0x7fd64a1000000000, 0x6f4bdbec00000000, 0x5cec6a5900000000,
    0x4c71fba500000000, 0xb64a891600000000, 0xa6d718ea00000000,
    0x9570a95f00000000, 0x85ed38a300000000, 0xf03ec98400000000,
    0xe0a3587800000000, 0xd304e9cd00000000, 0xc399783100000000,
    0x24730e1b00000000, 0x34ee9fe700000000, 0x07492e5200000000,
    0x17d4bfae00000000, 0x62074e8900000000, 0x729adf7500000000,
    0x413d6ec000000000, 0x51a0ff3c00000000, 0xab9b8d8f00000000,
    0xbb061c7300000000, 0x88a1adc600000000, 0x983c3c3a00000000,
    0xedefcd1d00000000, 0xfd725ce100000000, 0xced5ed5400000000,
    0xde487ca800000000, 0x714416b400000000, 0x61d9874800000000,
    0x527e36fd00000000, 0x42e3a70100000000, 0x3730562600000000,
    0x27adc7da00000000, 0x140a766f00000000, 0x0497e79300000000,
    0xfeac952000000000, 0xee3104dc00000000, 0xdd96b56900000000,
    0xcd0b249500000000, 0xb8d8d5b200000000, 0xa845444e00000000,
    0x9be2f5fb00000000, 0x8b7f640700000000, 0x6c95122d00000000,
    0x7c0883d100000000, 0x4faf326400000000, 0x5f32a39800000000,
    0x2ae152bf00000000, 0x3a7cc34300000000, 0x09db72f600000000,
    0x1946e30a00000000, 0xe37d91b900000000, 0xf3e0004500000000,
    0xc047b1f000000000, 0xd0da200c00000000, 0xa509d12b00000000,
    0xb59440d700000000, 0x8633f16200000000, 0x96ae609e00000000,
    0x48e61c3600000000, 0x587b8dca00000000, 0x6bdc3c7f00000000,
    0x7b41ad8300000000, 0x0e925ca400000000, 0x1e0fcd5800000000,
    0x2da87ced00000000, 0x3d35ed1100000000, 0xc70e9fa200000000,
    0xd7930e5e00000000, 0xe434bfeb00000000, 0xf4a92e1700000000,
    0x817adf3000000000, 0x91e74ecc00000000, 0xa240ff7900000000,
    0xb2dd6e8500000000, 0x553718af00000000, 0x45aa895300000000,
    0x760d38e600000000, 0x6690a91a00000000, 0x1343583d00000000,
    0x03dec9c100000000, 0x3079787400000000, 0x20e4e98800000000,
    0xdadf9b3b00000000, 0xca420ac700000000, 0xf9e5bb7200000000,
    0xe9782a8e00000000, 0x9cabdba900000000, 0x8c364a5500000000,
    0xbf91fbe000000000, 0xaf0c6a1c00000000, 0xe1882fd800000000,
    0xf115be2400000000, 0xc2b20f9100000000, 0xd22f9e6d00000000,
    0xa7fc6f4a00000000, 0xb761feb600000000, 0x84c64f0300000000,
    0x945bdeff00000000, 0x6e60ac4c00000000, 0x7efd3db000000000,
    0x4d5a8c0500000000, 0x5dc71df900000000, 0x2814ecde00000000,
    0x38897d2200000000, 0x0b2ecc9700000000, 0x1bb35d6b00000000,
    0xfc592b4100000000, 0xecc4babd00000000, 0xdf630b0800000000,
    0xcffe9af400000000, 0xba2d6bd300000000, 0xaab0fa2f00000000,
    0x99174b9a00000000, 0x898ada6600000000, 0x73b1a8d500000000,
    0x632c392900000000, 0x508b889c00000000, 0x4016196000000000,
    0x35c5e84700000000, 0x255879bb00000000, 0x16ffc80e00000000,
    0x066259f200000000, 0xd82a255a00000000, 0xc8b7b4a600000000,
    0xfb10051300000000, 0xeb8d94ef00000000, 0x9e5e65c800000000,
    0x8ec3f43400000000, 0xbd64458100000000, 0xadf9d47d00000000,
    0x57c2a6ce00000000, 0x475f373200000000, 0x74f8868700000000,
    0x6465177b00000000, 0x11b6e65c00000000, 0x012b77a000000000,
    0x328cc61500000000, 0x221157e900000000, 0xc5fb21c300000000,
    0xd566b03f00000000, 0xe6c1018a00000000, 0xf65c907600000000,
    0x838f615100000000, 0x9312f0ad00000000, 0xa0b5411800000000,
    0xb028d0e400000000, 0x4a13a25700000000, 0x5a8e33ab00000000,
    0x6929821e00000000, 0x79b413e200000000, 0x0c67e2c500000000,
    0x1cfa733900000000, 0x2f5dc28c00000000, 0x3fc0537000000000,
    0x90cc396c00000000, 0x8051a89000000000, 0xb3f6192500000000,
    0xa36b88d900000000, 0xd6b879fe00000000, 0xc625e80200000000,
    0xf58259b700000000, 0xe51fc84b00000000, 0x1f24baf800000000,
    0x0fb92b0400000000, 0x3c1e9ab100000000, 0x2c830b4d00000000,
    0x5950fa6a00000000, 0x49cd6b9600000000, 0x7a6ada2300000000,
    0x6af74bdf00000000, 0x8d1d3df500000000, 0x9d80ac0900000000,
    0xae271dbc00000000, 0xbeba8c4000000000, 0xcb697d6700000000,
    0xdbf4ec9b00000000, 0xe8535d2e00000000, 0xf8ceccd200000000,
    0x02f5be6100000000, 0x12682f9d00000000, 0x21cf9e2800000000,
    0x31520fd400000000, 0x4481fef300000000, 0x541c6f0f00000000,
    0x67bbdeba00000000, 0x77264f4600000000, 0xa96e33ee00000000,
    0xb9f3a21200000000, 0x8a5413a700000000, 0x9ac9825b00000000,
    0xef1a737c00000000, 0xff87e28000000000, 0xcc20533500000000,
    0xdcbdc2c900000000, 0x2686b07a00000000, 0x361b218600000000,
    0x05bc903300000000, 0x152101cf00000000, 0x60f2f0e800000000,
    0x706f611400000000, 0x43c8d0a100000000, 0x5355415d00000000,
    0xb4bf377700000000, 0xa422a68b00000000, 0x9785173e00000000,
    0x871886c200000000, 0xf2cb77e500000000, 0xe256e61900000000,
    0xd1f157ac00000000, 0xc16cc65000000000, 0x3b57b4e300000000,
    0x2bca251f00000000, 0x186d94aa00000000, 0x08f0055600000000,
    0x7d23f47100000000, 0x6dbe658d00000000, 0x5e19d43800000000,
    0x4e8445c400000000},
   {0x0000000000000000, 0x9c81fd9900000000, 0x3b03f88300000000,
    0xa782051a00000000, 0x7506f3b700000000, 0xe9870e2e00000000,
    0x4e050b3400000000, 0xd284f6ad00000000, 0xe90ce5df00000000,
    0x758d184600000000, 0xd20f1d5c00000000, 0x4e8ee0c500000000,
    0x9c0a166800000000, 0x008bebf100000000, 0xa709eeeb00000000,
    0x3b88137200000000, 0xd119c90f00000000, 0x4d98349600000000,
    0xea1a318c00000000, 0x769bcc1500000000, 0xa41f3ab800000000,
    0x389ec72100000000, 0x9f1cc23b00000000, 0x039d3fa200000000,
    0x38152cd000000000, 0xa494d14900000000, 0x0316d45300000000,
    0x9f9729ca00000000, 0x4d13df6700000000, 0xd19222fe00000000,
    0x761027e400000000, 0xea91da7d00000000, 0xa233921f00000000,
    0x3eb26f8600000000, 0x99306a9c00000000, 0x05b1970500000000,
    0xd73561a800000000, 0x4bb49c3100000000, 0xec36992b00000000,
    0x70b764b200000000, 0x4b3f77c000000000, 0xd7be8a5900000000,
    0x703c8f4300000000, 0xecbd72da00000000, 0x3e39847700000000,
    0xa2b879ee00000000, 0x053a7cf400000000, 0x99bb816d00000000,
    0x732a5b1000000000, 0xefaba68900000000, 0x4829a39300000000,
    0xd4a85e0a00000000, 0x062ca8a700000000, 0x9aad553e00000000,
    0x3d2f502400000000, 0xa1aeadbd00000000, 0x9a26becf00000000,
    0x06a7435600000000, 0xa125464c00000000, 0x3da4bbd500000000,
    0xef204d7800000000, 0x73a1b0e100000000, 0xd423b5fb00000000,
    0x48a2486200000000, 0x4467243f00000000, 0xd8e6d9a600000000,
    0x7f64dcbc00000000, 0xe3e5212500000000, 0x3161d78800000000,
    0xade02a1100000000, 0x0a622f0b00000000, 0x96e3d29200000000,
    0xad6bc1e000000000, 0x31ea3c7900000000, 0x9668396300000000,
    0x0ae9c4fa00000000, 0xd86d325700000000, 0x44eccfce00000000,
    0xe36ecad400000000, 0x7fef374d00000000, 0x957eed3000000000,
    0x09ff10a900000000, 0xae7d15b300000000, 0x32fce82a00000000,
    0xe0781e8700000000, 0x7cf9e31e00000000, 0xdb7be60400000000,
    0x47fa1b9d00000000, 0x7c7208ef00000000, 0xe0f3f57600000000,
    0x4771f06c00000000, 0xdbf00df500000000, 0x0974fb5800000000,
    0x95f506c100000000, 0x327703db00000000, 0xaef6fe4200000000,
    0xe654b62000000000, 0x7ad54bb900000000, 0xdd574ea300000000,
    0x41d6b33a00000000, 0x9352459700000000, 0x0fd3b80e00000000,
    0xa851bd1400000000, 0x34d0408d00000000, 0x0f5853ff00000000,
    0x93d9ae6600000000, 0x345bab7c00000000, 0xa8da56e500000000,
    0x7a5ea04800000000, 0xe6df5dd100000000, 0x415d58cb00000000,
    0xdddca55200000000, 0x374d7f2f00000000, 0xabcc82b600000000,
    0x0c4e87ac00000000, 0x90cf7a3500000000, 0x424b8c9800000000,
    0xdeca710100000000, 0x7948741b00000000, 0xe5c9898200000000,
    0xde419af000000000, 0x42c0676900000000, 0xe542627300000000,
    0x79c39fea00000000, 0xab47694700000000, 0x37c694de00000000,
    0x904491c400000000, 0x0cc56c5d00000000, 0x88ce487e00000000,
    0x144fb5e700000000, 0xb3cdb0fd00000000, 0x2f4c4d6400000000,
    0xfdc8bbc900000000, 0x6149465000000000, 0xc6cb434a00000000,
    0x5a4abed300000000, 0x61c2ada100000000, 0xfd43503800000000,
    0x5ac1552200000000, 0xc640a8bb00000000, 0x14c45e1600000000,
    0x8845a38f00000000, 0x2fc7a69500000000, 0xb3465b0c00000000,
    0x59d7817100000000, 0xc5567ce800000000, 0x62d479f200000000,
    0xfe55846b00000000, 0x2cd172c600000000, 0xb0508f5f00000000,
    0x17d28a4500000000, 0x8b5377dc00000000, 0xb0db64ae00000000,
    0x2c5a993700000000, 0x8bd89c2d00000000, 0x175961b400000000,
    0xc5dd971900000000, 0x595c6a8000000000, 0xfede6f9a00000000,
    0x625f920300000000, 0x2afdda6100000000, 0xb67c27f800000000,
    0x11fe22e200000000, 0x8d7fdf7b00000000, 0x5ffb29d600000000,
    0xc37ad44f00000000, 0x64f8d15500000000, 0xf8792ccc00000000,
    0xc3f13fbe00000000, 0x5f70c22700000000, 0xf8f2c73d00000000,
    0x64733aa400000000, 0xb6f7cc0900000000, 0x2a76319000000000,
    0x8df4348a00000000, 0x1175c91300000000, 0xfbe4136e00000000,
    0x6765eef700000000, 0xc0e7ebed00000000, 0x5c66167400000000,
    0x8ee2e0d900000000, 0x12631d4000000000, 0xb5e1185a00000000,
    0x2960e5c300000000, 0x12e8f6b100000000, 0x8e690b2800000000,
    0x29eb0e3200000000, 0xb56af3ab00000000, 0x67ee050600000000,
    0xfb6ff89f00000000, 0x5cedfd8500000000, 0xc06c001c00000000,
    0xcca96c4100000000, 0x502891d800000000, 0xf7aa94c200000000,
    0x6b2b695b00000000, 0xb9af9ff600000000, 0x252e626f00000000,
    0x82ac677500000000, 0x1e2d9aec00000000, 0x25a5899e00000000,
    0xb924740700000000, 0x1ea6711d00000000, 0x82278c8400000000,
    0x50a37a2900000000, 0xcc2287b000000000, 0x6ba082aa00000000,
    0xf7217f3300000000, 0x1db0a54e00000000, 0x813158d700000000,
    0x26b35dcd00000000, 0xba32a05400000000, 0x68b656f900000000,
    0xf437ab6000000000, 0x53b5ae7a00000000, 0xcf3453e300000000,
    0xf4bc409100000000, 0x683dbd0800000000, 0xcfbfb81200000000,
    0x533e458b00000000, 0x81bab32600000000, 0x1d3b4ebf00000000,
    0xbab94ba500000000, 0x2638b63c00000000, 0x6e9afe5e00000000,
    0xf21b03c700000000, 0x559906dd00000000, 0xc918fb4400000000,
    0x1b9c0de900000000, 0x871df07000000000, 0x209ff56a00000000,
    0xbc1e08f300000000, 0x87961b8100000000, 0x1b17e61800000000,
    0xbc95e30200000000, 0x20141e9b00000000, 0xf290e83600000000,
    0x6e1115af00000000, 0xc99310b500000000, 0x5512ed2c00000000,
    0xbf83375100000000, 0x2302cac800000000, 0x8480cfd200000000,
    0x1801324b00000000, 0xca85c4e600000000, 0x5604397f00000000,
    0xf1863c6500000000, 0x6d07c1fc00000000, 0x568fd28e00000000,
    0xca0e2f1700000000, 0x6d8c2a0d00000000, 0xf10dd79400000000,
    0x2389213900000000, 0xbf08dca000000000, 0x188ad9ba00000000,
    0x840b242300000000},
   {0x0000000000000000, 0x8161594700000000, 0x02c3b28e00000000,
    0x83a2ebc900000000, 0x078666ad00000000, 0x86e73fea00000000,
    0x0545d42300000000, 0x84248d6400000000, 0x0d0cceea00000000,
    0x8c6d97ad00000000, 0x0fcf7c6400000000, 0x8eae252300000000,
    0x0a8aa84700000000, 0x8bebf10000000000, 0x08491ac900000000,
    0x8928438e00000000, 0x19189f6500000000, 0x9879c62200000000,
    0x1bdb2deb00000000, 0x9aba74ac00000000, 0x1e9ef9c800000000,
    0x9fffa08f00000000, 0x1c5d4b4600000000, 0x9d3c120100000000,
    0x1414518f00000000, 0x957508c800000000, 0x16d7e30100000000,
    0x97b6ba4600000000, 0x1392372200000000, 0x92f36e6500000000,
    0x115185ac00000000, 0x9030dceb00000000, 0x32303ecb00000000,
    0xb351678c00000000, 0x30f38c4500000000, 0xb192d50200000000,
    0x35b6586600000000, 0xb4d7012100000000, 0x3775eae800000000,
    0xb614b3af00000000, 0x3f3cf02100000000, 0xbe5da96600000000,
    0x3dff42af00000000, 0xbc9e1be800000000, 0x38ba968c00000000,
    0xb9dbcfcb00000000, 0x3a79240200000000, 0xbb187d4500000000,
    0x2b28a1ae00000000, 0xaa49f8e900000000, 0x29eb132000000000,
    0xa88a4a6700000000, 0x2caec70300000000, 0xadcf9e4400000000,
    0x2e6d758d00000000, 0xaf0c2cca00000000, 0x26246f4400000000,
    0xa745360300000000, 0x24e7ddca00000000, 0xa586848d00000000,
    0x21a209e900000000, 0xa0c350ae00000000, 0x2361bb6700000000,
    0xa200e22000000000, 0x67607f2600000000, 0xe601266100000000,
    0x65a3cda800000000, 0xe4c294ef00000000, 0x60e6198b00000000,
    0xe18740cc00000000, 0x6225ab0500000000, 0xe344f24200000000,
    0x6a6cb1cc00000000, 0xeb0de88b00000000, 0x68af034200000000,
    0xe9ce5a0500000000, 0x6dead76100000000, 0xec8b8e2600000000,
    0x6f2965ef00000000, 0xee483ca800000000, 0x7e78e04300000000,
    0xff19b90400000000, 0x7cbb52cd00000000, 0xfdda0b8a00000000,
    0x79fe86ee00000000, 0xf89fdfa900000000, 0x7b3d346000000000,
    0xfa5c6d2700000000, 0x73742ea900000000, 0xf21577ee00000000,
    0x71b79c2700000000, 0xf0d6c56000000000, 0x74f2480400000000,
    0xf593114300000000, 0x7631fa8a00000000, 0xf750a3cd00000000,
    0x555041ed00000000, 0xd43118aa00000000, 0x5793f36300000000,
    0xd6f2aa2400000000, 0x52d6274000000000, 0xd3b77e0700000000,
    0x501595ce00000000, 0xd174cc8900000000, 0x585c8f0700000000,
    0xd93dd64000000000, 0x5a9f3d8900000000, 0xdbfe64ce00000000,
    0x5fdae9aa00000000, 0xdebbb0ed00000000, 0x5d195b2400000000,
    0xdc78026300000000, 0x4c48de8800000000, 0xcd2987cf00000000,
    0x4e8b6c0600000000, 0xcfea354100000000, 0x4bceb82500000000,
    0xcaafe16200000000, 0x490d0aab00000000, 0xc86c53ec00000000,
    0x4144106200000000, 0xc025492500000000, 0x4387a2ec00000000,
    0xc2e6fbab00000000, 0x46c276cf00000000, 0xc7a32f8800000000,
    0x4401c44100000000, 0xc5609d0600000000, 0xcec0fe4c00000000,
    0x4fa1a70b00000000, 0xcc034cc200000000, 0x4d62158500000000,
    0xc94698e100000000, 0x4827c1a600000000, 0xcb852a6f00000000,
    0x4ae4732800000000, 0xc3cc30a600000000, 0x42ad69e100000000,
    0xc10f822800000000, 0x406edb6f00000000, 0xc44a560b00000000,
    0x452b0f4c00000000, 0xc689e48500000000, 0x47e8bdc200000000,
    0xd7d8612900000000, 0x56b9386e00000000, 0xd51bd3a700000000,
    0x547a8ae000000000, 0xd05e078400000000, 0x513f5ec300000000,
    0xd29db50a00000000, 0x53fcec4d00000000, 0xdad4afc300000000,
    0x5bb5f68400000000, 0xd8171d4d00000000, 0x5976440a00000000,
    0xdd52c96e00000000, 0x5c33902900000000, 0xdf917be000000000,
    0x5ef022a700000000, 0xfcf0c08700000000, 0x7d9199c000000000,
    0xfe33720900000000, 0x7f522b4e00000000, 0xfb76a62a00000000,
    0x7a17ff6d00000000, 0xf9b514a400000000, 0x78d44de300000000,
    0xf1fc0e6d00000000, 0x709d572a00000000, 0xf33fbce300000000,
    0x725ee5a400000000, 0xf67a68c000000000, 0x771b318700000000,
    0xf4b9da4e00000000, 0x75d8830900000000, 0xe5e85fe200000000,
    0x648906a500000000, 0xe72bed6c00000000, 0x664ab42b00000000,
    0xe26e394f00000000, 0x630f600800000000, 0xe0ad8bc100000000,
    0x61ccd28600000000, 0xe8e4910800000000, 0x6985c84f00000000,
    0xea27238600000000, 0x6b467ac100000000, 0xef62f7a500000000,
    0x6e03aee200000000, 0xeda1452b00000000, 0x6cc01c6c00000000,
    0xa9a0816a00000000, 0x28c1d82d00000000, 0xab6333e400000000,
    0x2a026aa300000000, 0xae26e7c700000000, 0x2f47be8000000000,
    0xace5554900000000, 0x2d840c0e00000000, 0xa4ac4f8000000000,
    0x25cd16c700000000, 0xa66ffd0e00000000, 0x270ea44900000000,
    0xa32a292d00000000, 0x224b706a00000000, 0xa1e99ba300000000,
    0x2088c2e400000000, 0xb0b81e0f00000000, 0x31d9474800000000,
    0xb27bac8100000000, 0x331af5c600000000, 0xb73e78a200000000,
    0x365f21e500000000, 0xb5fdca2c00000000, 0x349c936b00000000,
    0xbdb4d0e500000000, 0x3cd589a200000000, 0xbf77626b00000000,
    0x3e163b2c00000000, 0xba32b64800000000, 0x3b53ef0f00000000,
    0xb8f104c600000000, 0x39905d8100000000, 0x9b90bfa100000000,
    0x1af1e6e600000000, 0x99530d2f00000000, 0x1832546800000000,
    0x9c16d90c00000000, 0x1d77804b00000000, 0x9ed56b8200000000,
    0x1fb432c500000000, 0x969c714b00000000, 0x17fd280c00000000,
    0x945fc3c500000000, 0x153e9a8200000000, 0x911a17e600000000,
    0x107b4ea100000000, 0x93d9a56800000000, 0x12b8fc2f00000000,
    0x828820c400000000, 0x03e9798300000000, 0x804b924a00000000,
    0x012acb0d00000000, 0x850e466900000000, 0x046f1f2e00000000,
    0x87cdf4e700000000, 0x06acada000000000, 0x8f84ee2e00000000,
    0x0ee5b76900000000, 0x8d475ca000000000, 0x0c2605e700000000,
    0x8802888300000000, 0x0963d1c400000000, 0x8ac13a0d00000000,
    0x0ba0634a00000000}};

#else /* W == 4 */

static const crc_t crc_braid_table[][256] = {
   {0x00000000, 0x51010001, 0xa2020002, 0xf3030003, 0xf4070007,
    0xa5060006, 0x56050005, 0x07040004, 0x580d000d, 0x090c000c,
    0xfa0f000f, 0xab0e000e, 0xac0a000a, 0xfd0b000b, 0x0e080008,
    0x5f090009, 0xb01a001a, 0xe11b001b, 0x12180018, 0x43190019,
    0x441d001d, 0x151c001c, 0xe61f001f, 0xb71e001e, 0xe8170017,
    0xb9160016, 0x4a150015, 0x1b140014, 0x1c100010, 0x4d110011,
    0xbe120012, 0xef130013, 0xd0370037, 0x81360036, 0x72350035,
    0x23340034, 0x24300030, 0x75310031, 0x86320032, 0xd7330033,
    0x883a003a, 0xd93b003b, 0x2a380038, 0x7b390039, 0x7c3d003d,
    0x2d3c003c, 0xde3f003f, 0x8f3e003e, 0x602d002d, 0x312c002c,
    0xc22f002f, 0x932e002e, 0x942a002a, 0xc52b002b, 0x36280028,
    0x67290029, 0x38200020, 0x69210021, 0x9a220022, 0xcb230023,
    0xcc270027, 0x9d260026, 0x6e250025, 0x3f240024, 0x106d006d,
    0x416c006c, 0xb26f006f, 0xe36e006e, 0xe46a006a, 0xb56b006b,
    0x46680068, 0x17690069, 0x48600060, 0x19610061, 0xea620062,
    0xbb630063, 0xbc670067, 0xed660066, 0x1e650065, 0x4f640064,
    0xa0770077, 0xf1760076, 0x02750075, 0x53740074, 0x54700070,
    0x05710071, 0xf6720072, 0xa7730073, 0xf87a007a, 0xa97b007b,
    0x5a780078, 0x0b790079, 0x0c7d007d, 0x5d7c007c, 0xae7f007f,
    0xff7e007e, 0xc05a005a, 0x915b005b, 0x62580058, 0x33590059,
    0x345d005d, 0x655c005c, 0x965f005f, 0xc75e005e, 0x98570057,
    0xc9560056, 0x3a550055, 0x6b540054, 0x6c500050, 0x3d510051,
    0xce520052, 0x9f530053, 0x70400040, 0x21410041, 0xd2420042,
    0x83430043, 0x84470047, 0xd5460046, 0x26450045, 0x77440044,
    0x284d004d, 0x794c004c, 0x8a4f004f, 0xdb4e004e, 0xdc4a004a,
    0x8d4b004b, 0x7e480048, 0x2f490049, 0x20da00da, 0x71db00db,
    0x82d800d8, 0xd3d900d9, 0xd4dd00dd, 0x85dc00dc, 0x76df00df,
    0x27de00de, 0x78d700d7, 0x29d600d6, 0xdad500d5, 0x8bd400d4,
    0x8cd000d0, 0xddd100d1, 0x2ed200d2, 0x7fd300d3, 0x90c000c0,
    0xc1c100c1, 0x32c200c2, 0x63c300c3, 0x64c700c7, 0x35c600c6,
    0xc6c500c5, 0x97c400c4, 0xc8cd00cd, 0x99cc00cc, 0x6acf00cf,
    0x3bce00ce, 0x3cca00ca, 0x6dcb00cb, 0x9ec800c8, 0xcfc900c9,
    0xf0ed00ed, 0xa1ec00ec, 0x52ef00ef, 0x03ee00ee, 0x04ea00ea,
    0x55eb00eb, 0xa6e800e8, 0xf7e900e9, 0xa8e000e0, 0xf9e100e1,
    0x0ae200e2, 0x5be300e3, 0x5ce700e7, 0x0de600e6, 0xfee500e5,
    0xafe400e4, 0x40f700f7, 0x11f600f6, 0xe2f500f5, 0xb3f400f4,
    0xb4f000f0, 0xe5f100f1, 0x16f200f2, 0x47f300f3, 0x18fa00fa,
    0x49fb00fb, 0xbaf800f8, 0xebf900f9, 0xecfd00fd, 0xbdfc00fc,
    0x4eff00ff, 0x1ffe00fe, 0x30b700b7, 0x61b600b6, 0x92b500b5,
    0xc3b400b4, 0xc4b000b0, 0x95b100b1, 0x66b200b2, 0x37b300b3,
    0x68ba00ba, 0x39bb00bb, 0xcab800b8, 0x9bb900b9, 0x9cbd00bd,
    0xcdbc00bc, 0x3ebf00bf, 0x6fbe00be, 0x80ad00ad, 0xd1ac00ac,
    0x22af00af, 0x73ae00ae, 0x74aa00aa, 0x25ab00ab, 0xd6a800a8,
    0x87a900a9, 0xd8a000a0, 0x89a100a1, 0x7aa200a2, 0x2ba300a3,
    0x2ca700a7, 0x7da600a6, 0x8ea500a5, 0xdfa400a4, 0xe0800080,
    0xb1810081, 0x42820082, 0x13830083, 0x14870087, 0x45860086,
    0xb6850085, 0xe7840084, 0xb88d008d, 0xe98c008c, 0x1a8f008f,
    0x4b8e008e, 0x4c8a008a, 0x1d8b008b, 0xee880088, 0xbf890089,
    0x509a009a, 0x019b009b, 0xf2980098, 0xa3990099, 0xa49d009d,
    0xf59c009c, 0x069f009f, 0x579e009e, 0x08970097, 0x59960096,
    0xaa950095, 0xfb940094, 0xfc900090, 0xad910091, 0x5e920092,
    0x0f930093},
   {0x00000000, 0x41b401b4, 0x83680368, 0xc2dc02dc, 0xb6d306d3,
    0xf7670767, 0x35bb05bb, 0x740f040f, 0xdda50da5, 0x9c110c11,
    0x5ecd0ecd, 0x1f790f79, 0x6b760b76, 0x2ac20ac2, 0xe81e081e,
    0xa9aa09aa, 0x0b491b49, 0x4afd1afd, 0x88211821, 0xc9951995,
    0xbd9a1d9a, 0xfc2e1c2e, 0x3ef21ef2, 0x7f461f46, 0xd6ec16ec,
    0x97581758, 0x55841584, 0x14301430, 0x603f103f, 0x218b118b,
    0xe3571357, 0xa2e312e3, 0x16923692, 0x57263726, 0x95fa35fa,
    0xd44e344e, 0xa0413041, 0xe1f531f5, 0x23293329, 0x629d329d,
    0xcb373b37, 0x8a833a83, 0x485f385f, 0x09eb39eb, 0x7de43de4,
    0x3c503c50, 0xfe8c3e8c, 0xbf383f38, 0x1ddb2ddb, 0x5c6f2c6f,
    0x9eb32eb3, 0xdf072f07, 0xab082b08, 0xeabc2abc, 0x28602860,
    0x69d429d4, 0xc07e207e, 0x81ca21ca, 0x43162316, 0x02a222a2,
    0x76ad26ad, 0x37192719, 0xf5c525c5, 0xb4712471, 0x2d246d24,
    0x6c906c90, 0xae4c6e4c, 0xeff86ff8, 0x9bf76bf7, 0xda436a43,
    0x189f689f, 0x592b692b, 0xf0816081, 0xb1356135, 0x73e963e9,
    0x325d625d, 0x46526652, 0x07e667e6, 0xc53a653a, 0x848e648e,
    0x266d766d, 0x67d977d9, 0xa5057505, 0xe4b174b1, 0x90be70be,
    0xd10a710a, 0x13d673d6, 0x52627262, 0xfbc87bc8, 0xba7c7a7c,
    0x78a078a0, 0x39147914, 0x4d1b7d1b, 0x0caf7caf, 0xce737e73,
    0x8fc77fc7, 0x3bb65bb6, 0x7a025a02, 0xb8de58de, 0xf96a596a,
    0x8d655d65, 0xccd15cd1, 0x0e0d5e0d, 0x4fb95fb9, 0xe6135613,
    0xa7a757a7, 0x657b557b, 0x24cf54cf, 0x50c050c0, 0x11745174,
    0xd3a853a8, 0x921c521c, 0x30ff40ff, 0x714b414b, 0xb3974397,
    0xf2234223, 0x862c462c, 0xc7984798, 0x05444544, 0x44f044f0,
    0xed5a4d5a, 0xacee4cee, 0x6e324e32, 0x2f864f86, 0x5b894b89,
    0x1a3d4a3d, 0xd8e148e1, 0x99554955, 0x5a48da48, 0x1bfcdbfc,
    0xd920d920, 0x9894d894, 0xec9bdc9b, 0xad2fdd2f, 0x6ff3dff3,
    0x2e47de47, 0x87edd7ed, 0xc659d659, 0x0485d485, 0x4531d531,
    0x313ed13e, 0x708ad08a, 0xb256d256, 0xf3e2d3e2, 0x5101c101,
    0x10b5c0b5, 0xd269c269, 0x93ddc3dd, 0xe7d2c7d2, 0xa666c666,
    0x64bac4ba, 0x250ec50e, 0x8ca4cca4, 0xcd10cd10, 0x0fcccfcc,
    0x4e78ce78, 0x3a77ca77, 0x7bc3cbc3, 0xb91fc91f, 0xf8abc8ab,
    0x4cdaecda, 0x0d6eed6e, 0xcfb2efb2, 0x8e06ee06, 0xfa09ea09,
    0xbbbdebbd, 0x7961e961, 0x38d5e8d5, 0x917fe17f, 0xd0cbe0cb,
    0x1217e217, 0x53a3e3a3, 0x27ace7ac, 0x6618e618, 0xa4c4e4c4,
    0xe570e570, 0x4793f793, 0x0627f627, 0xc4fbf4fb, 0x854ff54f,
    0xf140f140, 0xb0f4f0f4, 0x7228f228, 0x339cf39c, 0x9a36fa36,
    0xdb82fb82, 0x195ef95e, 0x58eaf8ea, 0x2ce5fce5, 0x6d51fd51,
    0xaf8dff8d, 0xee39fe39, 0x776cb76c, 0x36d8b6d8, 0xf404b404,
    0xb5b0b5b0, 0xc1bfb1bf, 0x800bb00b, 0x42d7b2d7, 0x0363b363,
    0xaac9bac9, 0xeb7dbb7d, 0x29a1b9a1, 0x6815b815, 0x1c1abc1a,
    0x5daebdae, 0x9f72bf72, 0xdec6bec6, 0x7c25ac25, 0x3d91ad91,
    0xff4daf4d, 0xbef9aef9, 0xcaf6aaf6, 0x8b42ab42, 0x499ea99e,
    0x082aa82a, 0xa180a180, 0xe034a034, 0x22e8a2e8, 0x635ca35c,
    0x1753a753, 0x56e7a6e7, 0x943ba43b, 0xd58fa58f, 0x61fe81fe,
    0x204a804a, 0xe2968296, 0xa3228322, 0xd72d872d, 0x96998699,
    0x54458445, 0x15f185f1, 0xbc5b8c5b, 0xfdef8def, 0x3f338f33,
    0x7e878e87, 0x0a888a88, 0x4b3c8b3c, 0x89e089e0, 0xc8548854,
    0x6ab79ab7, 0x2b039b03, 0xe9df99df, 0xa86b986b, 0xdc649c64,
    0x9dd09dd0, 0x5f0c9f0c, 0x1eb89eb8, 0xb7129712, 0xf6a696a6,
    0x347a947a, 0x75ce95ce, 0x01c191c1, 0x40759075, 0x82a992a9,
    0xc31d931d},
   {0x00000000, 0xb491b490, 0xd9206923, 0x6db1ddb3, 0x0243d245,
    0xb6d266d5, 0xdb63bb66, 0x6ff20ff6, 0x0487a48a, 0xb016101a,
    0xdda7cda9, 0x69367939, 0x06c476cf, 0xb255c25f, 0xdfe41fec,
    0x6b75ab7c, 0x090f4914, 0xbd9efd84, 0xd02f2037, 0x64be94a7,
    0x0b4c9b51, 0xbfdd2fc1, 0xd26cf272, 0x66fd46e2, 0x0d88ed9e,
    0xb919590e, 0xd4a884bd, 0x6039302d, 0x0fcb3fdb, 0xbb5a8b4b,
    0xd6eb56f8, 0x627ae268, 0x121e9228, 0xa68f26b8, 0xcb3efb0b,
    0x7faf4f9b, 0x105d406d, 0xa4ccf4fd, 0xc97d294e, 0x7dec9dde,
    0x169936a2, 0xa2088232, 0xcfb95f81, 0x7b28eb11, 0x14dae4e7,
    0xa04b5077, 0xcdfa8dc4, 0x796b3954, 0x1b11db3c, 0xaf806fac,
    0xc231b21f, 0x76a0068f, 0x19520979, 0xadc3bde9, 0xc072605a,
    0x74e3d4ca, 0x1f967fb6, 0xab07cb26, 0xc6b61695, 0x7227a205,
    0x1dd5adf3, 0xa9441963, 0xc4f5c4d0, 0x70647040, 0x243d2450,
    0x90ac90c0, 0xfd1d4d73, 0x498cf9e3, 0x267ef615, 0x92ef4285,
    0xff5e9f36, 0x4bcf2ba6, 0x20ba80da, 0x942b344a, 0xf99ae9f9,
    0x4d0b5d69, 0x22f9529f, 0x9668e60f, 0xfbd93bbc, 0x4f488f2c,
    0x2d326d44, 0x99a3d9d4, 0xf4120467, 0x4083b0f7, 0x2f71bf01,
    0x9be00b91, 0xf651d622, 0x42c062b2, 0x29b5c9ce, 0x9d247d5e,
    0xf095a0ed, 0x4404147d, 0x2bf61b8b, 0x9f67af1b, 0xf2d672a8,
    0x4647c638, 0x3623b678, 0x82b202e8, 0xef03df5b, 0x5b926bcb,
    0x3460643d, 0x80f1d0ad, 0xed400d1e, 0x59d1b98e, 0x32a412f2,
    0x8635a662, 0xeb847bd1, 0x5f15cf41, 0x30e7c0b7, 0x84767427,
    0xe9c7a994, 0x5d561d04, 0x3f2cff6c, 0x8bbd4bfc, 0xe60c964f,
    0x529d22df, 0x3d6f2d29, 0x89fe99b9, 0xe44f440a, 0x50def09a,
    0x3bab5be6, 0x8f3aef76, 0xe28b32c5, 0x561a8655, 0x39e889a3,
    0x8d793d33, 0xe0c8e080, 0x54595410, 0x487a48a0, 0xfcebfc30,
    0x915a2183, 0x25cb9513, 0x4a399ae5, 0xfea82e75, 0x9319f3c6,
    0x27884756, 0x4cfdec2a, 0xf86c58ba, 0x95dd8509, 0x214c3199,
    0x4ebe3e6f, 0xfa2f8aff, 0x979e574c, 0x230fe3dc, 0x417501b4,
    0xf5e4b524, 0x98556897, 0x2cc4dc07, 0x4336d3f1, 0xf7a76761,
    0x9a16bad2, 0x2e870e42, 0x45f2a53e, 0xf16311ae, 0x9cd2cc1d,
    0x2843788d, 0x47b1777b, 0xf320c3eb, 0x9e911e58, 0x2a00aac8,
    0x5a64da88, 0xeef56e18, 0x8344b3ab, 0x37d5073b, 0x582708cd,
    0xecb6bc5d, 0x810761ee, 0x3596d57e, 0x5ee37e02, 0xea72ca92,
    0x87c31721, 0x3352a3b1, 0x5ca0ac47, 0xe83118d7, 0x8580c564,
    0x311171f4, 0x536b939c, 0xe7fa270c, 0x8a4bfabf, 0x3eda4e2f,
    0x512841d9, 0xe5b9f549, 0x880828fa, 0x3c999c6a, 0x57ec3716,
    0xe37d8386, 0x8ecc5e35, 0x3a5deaa5, 0x55afe553, 0xe13e51c3,
    0x8c8f8c70, 0x381e38e0, 0x6c476cf0, 0xd8d6d860, 0xb56705d3,
    0x01f6b143, 0x6e04beb5, 0xda950a25, 0xb724d796, 0x03b56306,
    0x68c0c87a, 0xdc517cea, 0xb1e0a159, 0x057115c9, 0x6a831a3f,
    0xde12aeaf, 0xb3a3731c, 0x0732c78c, 0x654825e4, 0xd1d99174,
    0xbc684cc7, 0x08f9f857, 0x670bf7a1, 0xd39a4331, 0xbe2b9e82,
    0x0aba2a12, 0x61cf816e, 0xd55e35fe, 0xb8efe84d, 0x0c7e5cdd,
    0x638c532b, 0xd71de7bb, 0xbaac3a08, 0x0e3d8e98, 0x7e59fed8,
    0xcac84a48, 0xa77997fb, 0x13e8236b, 0x7c1a2c9d, 0xc88b980d,
    0xa53a45be, 0x11abf12e, 0x7ade5a52, 0xce4feec2, 0xa3fe3371,
    0x176f87e1, 0x789d8817, 0xcc0c3c87, 0xa1bde134, 0x152c55a4,
    0x7756b7cc, 0xc3c7035c, 0xae76deef, 0x1ae76a7f, 0x75156589,
    0xc184d119, 0xac350caa, 0x18a4b83a, 0x73d11346, 0xc740a7d6,
    0xaaf17a65, 0x1e60cef5, 0x7192c103, 0xc5037593, 0xa8b2a820,
    0x1c231cb0},
   {0x00000000, 0x90f49140, 0x91ea2283, 0x011eb3c3, 0x93d74505,
    0x0323d445, 0x023d6786, 0x92c9f6c6, 0x97ad8a09, 0x07591b49,
    0x0647a88a, 0x96b339ca, 0x047acf0c, 0x948e5e4c, 0x9590ed8f,
    0x05647ccf, 0x9f581411, 0x0fac8551, 0x0eb23692, 0x9e46a7d2,
    0x0c8f5114, 0x9c7bc054, 0x9d657397, 0x0d91e2d7, 0x08f59e18,
    0x98010f58, 0x991fbc9b, 0x09eb2ddb, 0x9b22db1d, 0x0bd64a5d,
    0x0ac8f99e, 0x9a3c68de, 0x8eb32821, 0x1e47b961, 0x1f590aa2,
    0x8fad9be2, 0x1d646d24, 0x8d90fc64, 0x8c8e4fa7, 0x1c7adee7,
    0x191ea228, 0x89ea3368, 0x88f480ab, 0x180011eb, 0x8ac9e72d,
    0x1a3d766d, 0x1b23c5ae, 0x8bd754ee, 0x11eb3c30, 0x811fad70,
    0x80011eb3, 0x10f58ff3, 0x823c7935, 0x12c8e875, 0x13d65bb6,
    0x8322caf6, 0x8646b639, 0x16b22779, 0x17ac94ba, 0x875805fa,
    0x1591f33c, 0x8565627c, 0x847bd1bf, 0x148f40ff, 0xad655041,
    0x3d91c101, 0x3c8f72c2, 0xac7be382, 0x3eb21544, 0xae468404,
    0xaf5837c7, 0x3faca687, 0x3ac8da48, 0xaa3c4b08, 0xab22f8cb,
    0x3bd6698b, 0xa91f9f4d, 0x39eb0e0d, 0x38f5bdce, 0xa8012c8e,
    0x323d4450, 0xa2c9d510, 0xa3d766d3, 0x3323f793, 0xa1ea0155,
    0x311e9015, 0x300023d6, 0xa0f4b296, 0xa590ce59, 0x35645f19,
    0x347aecda, 0xa48e7d9a, 0x36478b5c, 0xa6b31a1c, 0xa7ada9df,
    0x3759389f, 0x23d67860, 0xb322e920, 0xb23c5ae3, 0x22c8cba3,
    0xb0013d65, 0x20f5ac25, 0x21eb1fe6, 0xb11f8ea6, 0xb47bf269,
    0x248f6329, 0x2591d0ea, 0xb56541aa, 0x27acb76c, 0xb758262c,
    0xb64695ef, 0x26b204af, 0xbc8e6c71, 0x2c7afd31, 0x2d644ef2,
    0xbd90dfb2, 0x2f592974, 0xbfadb834, 0xbeb30bf7, 0x2e479ab7,
    0x2b23e678, 0xbbd77738, 0xbac9c4fb, 0x2a3d55bb, 0xb8f4a37d,
    0x2800323d, 0x291e81fe, 0xb9ea10be, 0xeac9a081, 0x7a3d31c1,
    0x7b238202, 0xebd71342, 0x791ee584, 0xe9ea74c4, 0xe8f4c707,
    0x78005647, 0x7d642a88, 0xed90bbc8, 0xec8e080b, 0x7c7a994b,
    0xeeb36f8d, 0x7e47fecd, 0x7f594d0e, 0xefaddc4e, 0x7591b490,
    0xe56525d0, 0xe47b9613, 0x748f0753, 0xe646f195, 0x76b260d5,
    0x77acd316, 0xe7584256, 0xe23c3e99, 0x72c8afd9, 0x73d61c1a,
    0xe3228d5a, 0x71eb7b9c, 0xe11feadc, 0xe001591f, 0x70f5c85f,
    0x647a88a0, 0xf48e19e0, 0xf590aa23, 0x65643b63, 0xf7adcda5,
    0x67595ce5, 0x6647ef26, 0xf6b37e66, 0xf3d702a9, 0x632393e9,
    0x623d202a, 0xf2c9b16a, 0x600047ac, 0xf0f4d6ec, 0xf1ea652f,
    0x611ef46f, 0xfb229cb1, 0x6bd60df1, 0x6ac8be32, 0xfa3c2f72,
    0x68f5d9b4, 0xf80148f4, 0xf91ffb37, 0x69eb6a77, 0x6c8f16b8,
    0xfc7b87f8, 0xfd65343b, 0x6d91a57b, 0xff5853bd, 0x6facc2fd,
    0x6eb2713e, 0xfe46e07e, 0x47acf0c0, 0xd7586180, 0xd646d243,
    0x46b24303, 0xd47bb5c5, 0x448f2485, 0x45919746, 0xd5650606,
    0xd0017ac9, 0x40f5eb89, 0x41eb584a, 0xd11fc90a, 0x43d63fcc,
    0xd322ae8c, 0xd23c1d4f, 0x42c88c0f, 0xd8f4e4d1, 0x48007591,
    0x491ec652, 0xd9ea5712, 0x4b23a1d4, 0xdbd73094, 0xdac98357,
    0x4a3d1217, 0x4f596ed8, 0xdfadff98, 0xdeb34c5b, 0x4e47dd1b,
    0xdc8e2bdd, 0x4c7aba9d, 0x4d64095e, 0xdd90981e, 0xc91fd8e1,
    0x59eb49a1, 0x58f5fa62, 0xc8016b22, 0x5ac89de4, 0xca3c0ca4,
    0xcb22bf67, 0x5bd62e27, 0x5eb252e8, 0xce46c3a8, 0xcf58706b,
    0x5face12b, 0xcd6517ed, 0x5d9186ad, 0x5c8f356e, 0xcc7ba42e,
    0x5647ccf0, 0xc6b35db0, 0xc7adee73, 0x57597f33, 0xc59089f5,
    0x556418b5, 0x547aab76, 0xc48e3a36, 0xc1ea46f9, 0x511ed7b9,
    0x5000647a, 0xc0f4f53a, 0x523d03fc, 0xc2c992bc, 0xc3d7217f,
    0x5323b03f}};

static const word_t crc_braid_big_table[][256] = {
   {0x00000000, 0x4091f490, 0x8322ea91, 0xc3b31e01, 0x0545d793,
    0x45d42303, 0x86673d02, 0xc6f6c992, 0x098aad97, 0x491b5907,
    0x8aa84706, 0xca39b396, 0x0ccf7a04, 0x4c5e8e94, 0x8fed9095,
    0xcf7c6405, 0x1114589f, 0x5185ac0f, 0x9236b20e, 0xd2a7469e,
    0x14518f0c, 0x54c07b9c, 0x9773659d, 0xd7e2910d, 0x189ef508,
    0x580f0198, 0x9bbc1f99, 0xdb2deb09, 0x1ddb229b, 0x5d4ad60b,
    0x9ef9c80a, 0xde683c9a, 0x2128b38e, 0x61b9471e, 0xa20a591f,
    0xe29bad8f, 0x246d641d, 0x64fc908d, 0xa74f8e8c, 0xe7de7a1c,
    0x28a21e19, 0x6833ea89, 0xab80f488, 0xeb110018, 0x2de7c98a,
    0x6d763d1a, 0xaec5231b, 0xee54d78b, 0x303ceb11, 0x70ad1f81,
    0xb31e0180, 0xf38ff510, 0x35793c82, 0x75e8c812, 0xb65bd613,
    0xf6ca2283, 0x39b64686, 0x7927b216, 0xba94ac17, 0xfa055887,
    0x3cf39115, 0x7c626585, 0xbfd17b84, 0xff408f14, 0x415065ad,
    0x01c1913d, 0xc2728f3c, 0x82e37bac, 0x4415b23e, 0x048446ae,
    0xc73758af, 0x87a6ac3f, 0x48dac83a, 0x084b3caa, 0xcbf822ab,
    0x8b69d63b, 0x4d9f1fa9, 0x0d0eeb39, 0xcebdf538, 0x8e2c01a8,
    0x50443d32, 0x10d5c9a2, 0xd366d7a3, 0x93f72333, 0x5501eaa1,
    0x15901e31, 0xd6230030, 0x96b2f4a0, 0x59ce90a5, 0x195f6435,
    0xdaec7a34, 0x9a7d8ea4, 0x5c8b4736, 0x1c1ab3a6, 0xdfa9ada7,
    0x9f385937, 0x6078d623, 0x20e922b3, 0xe35a3cb2, 0xa3cbc822,
    0x653d01b0, 0x25acf520, 0xe61feb21, 0xa68e1fb1, 0x69f27bb4,
    0x29638f24, 0xead09125, 0xaa4165b5, 0x6cb7ac27, 0x2c2658b7,
    0xef9546b6, 0xaf04b226, 0x716c8ebc, 0x31fd7a2c, 0xf24e642d,
    0xb2df90bd, 0x7429592f, 0x34b8adbf, 0xf70bb3be, 0xb79a472e,
    0x78e6232b, 0x3877d7bb, 0xfbc4c9ba, 0xbb553d2a, 0x7da3f4b8,
    0x3d320028, 0xfe811e29, 0xbe10eab9, 0x81a0c9ea, 0xc1313d7a,
    0x0282237b, 0x4213d7eb, 0x84e51e79, 0xc474eae9, 0x07c7f4e8,
    0x47560078, 0x882a647d, 0xc8bb90ed, 0x0b088eec, 0x4b997a7c,
    0x8d6fb3ee, 0xcdfe477e, 0x0e4d597f, 0x4edcadef, 0x90b49175,
    0xd02565e5, 0x13967be4, 0x53078f74, 0x95f146e6, 0xd560b276,
    0x16d3ac77, 0x564258e7, 0x993e3ce2, 0xd9afc872, 0x1a1cd673,
    0x5a8d22e3, 0x9c7beb71, 0xdcea1fe1, 0x1f5901e0, 0x5fc8f570,
    0xa0887a64, 0xe0198ef4, 0x23aa90f5, 0x633b6465, 0xa5cdadf7,
    0xe55c5967, 0x26ef4766, 0x667eb3f6, 0xa902d7f3, 0xe9932363,
    0x2a203d62, 0x6ab1c9f2, 0xac470060, 0xecd6f4f0, 0x2f65eaf1,
    0x6ff41e61, 0xb19c22fb, 0xf10dd66b, 0x32bec86a, 0x722f3cfa,
    0xb4d9f568, 0xf44801f8, 0x37fb1ff9, 0x776aeb69, 0xb8168f6c,
    0xf8877bfc, 0x3b3465fd, 0x7ba5916d, 0xbd5358ff, 0xfdc2ac6f,
    0x3e71b26e, 0x7ee046fe, 0xc0f0ac47, 0x806158d7, 0x43d246d6,
    0x0343b246, 0xc5b57bd4, 0x85248f44, 0x46979145, 0x060665d5,
    0xc97a01d0, 0x89ebf540, 0x4a58eb41, 0x0ac91fd1, 0xcc3fd643,
    0x8cae22d3, 0x4f1d3cd2, 0x0f8cc842, 0xd1e4f4d8, 0x91750048,
    0x52c61e49, 0x1257ead9, 0xd4a1234b, 0x9430d7db, 0x5783c9da,
    0x17123d4a, 0xd86e594f, 0x98ffaddf, 0x5b4cb3de, 0x1bdd474e,
    0xdd2b8edc, 0x9dba7a4c, 0x5e09644d, 0x1e9890dd, 0xe1d81fc9,
    0xa149eb59, 0x62faf558, 0x226b01c8, 0xe49dc85a, 0xa40c3cca,
    0x67bf22cb, 0x272ed65b, 0xe852b25e, 0xa8c346ce, 0x6b7058cf,
    0x2be1ac5f, 0xed1765cd, 0xad86915d, 0x6e358f5c, 0x2ea47bcc,
    0xf0cc4756, 0xb05db3c6, 0x73eeadc7, 0x337f5957, 0xf58990c5,
    0xb5186455, 0x76ab7a54, 0x363a8ec4, 0xf946eac1, 0xb9d71e51,
    0x7a640050, 0x3af5f4c0, 0xfc033d52, 0xbc92c9c2, 0x7f21d7c3,
    0x3fb02353},
   {0x00000000, 0x90b491b4, 0x236920d9, 0xb3ddb16d, 0x45d24302,
    0xd566d2b6, 0x66bb63db, 0xf60ff26f, 0x8aa48704, 0x1a1016b0,
    0xa9cda7dd, 0x39793669, 0xcf76c406, 0x5fc255b2, 0xec1fe4df,
    0x7cab756b, 0x14490f09, 0x84fd9ebd, 0x37202fd0, 0xa794be64,
    0x519b4c0b, 0xc12fddbf, 0x72f26cd2, 0xe246fd66, 0x9eed880d,
    0x0e5919b9, 0xbd84a8d4, 0x2d303960, 0xdb3fcb0f, 0x4b8b5abb,
    0xf856ebd6, 0x68e27a62, 0x28921e12, 0xb8268fa6, 0x0bfb3ecb,
    0x9b4faf7f, 0x6d405d10, 0xfdf4cca4, 0x4e297dc9, 0xde9dec7d,
    0xa2369916, 0x328208a2, 0x815fb9cf, 0x11eb287b, 0xe7e4da14,
    0x77504ba0, 0xc48dfacd, 0x54396b79, 0x3cdb111b, 0xac6f80af,
    0x1fb231c2, 0x8f06a076, 0x79095219, 0xe9bdc3ad, 0x5a6072c0,
    0xcad4e374, 0xb67f961f, 0x26cb07ab, 0x9516b6c6, 0x05a22772,
    0xf3add51d, 0x631944a9, 0xd0c4f5c4, 0x40706470, 0x50243d24,
    0xc090ac90, 0x734d1dfd, 0xe3f98c49, 0x15f67e26, 0x8542ef92,
    0x369f5eff, 0xa62bcf4b, 0xda80ba20, 0x4a342b94, 0xf9e99af9,
    0x695d0b4d, 0x9f52f922, 0x0fe66896, 0xbc3bd9fb, 0x2c8f484f,
    0x446d322d, 0xd4d9a399, 0x670412f4, 0xf7b08340, 0x01bf712f,
    0x910be09b, 0x22d651f6, 0xb262c042, 0xcec9b529, 0x5e7d249d,
    0xeda095f0, 0x7d140444, 0x8b1bf62b, 0x1baf679f, 0xa872d6f2,
    0x38c64746, 0x78b62336, 0xe802b282, 0x5bdf03ef, 0xcb6b925b,
    0x3d646034, 0xadd0f180, 0x1e0d40ed, 0x8eb9d159, 0xf212a432,
    0x62a63586, 0xd17b84eb, 0x41cf155f, 0xb7c0e730, 0x27747684,
    0x94a9c7e9, 0x041d565d, 0x6cff2c3f, 0xfc4bbd8b, 0x4f960ce6,
    0xdf229d52, 0x292d6f3d, 0xb999fe89, 0x0a444fe4, 0x9af0de50,
    0xe65bab3b, 0x76ef3a8f, 0xc5328be2, 0x55861a56, 0xa389e839,
    0x333d798d, 0x80e0c8e0, 0x10545954, 0xa0487a48, 0x30fcebfc,
    0x83215a91, 0x1395cb25, 0xe59a394a, 0x752ea8fe, 0xc6f31993,
    0x56478827, 0x2aecfd4c, 0xba586cf8, 0x0985dd95, 0x99314c21,
    0x6f3ebe4e, 0xff8a2ffa, 0x4c579e97, 0xdce30f23, 0xb4017541,
    0x24b5e4f5, 0x97685598, 0x07dcc42c, 0xf1d33643, 0x6167a7f7,
    0xd2ba169a, 0x420e872e, 0x3ea5f245, 0xae1163f1, 0x1dccd29c,
    0x8d784328, 0x7b77b147, 0xebc320f3, 0x581e919e, 0xc8aa002a,
    0x88da645a, 0x186ef5ee, 0xabb34483, 0x3b07d537, 0xcd082758,
    0x5dbcb6ec, 0xee610781, 0x7ed59635, 0x027ee35e, 0x92ca72ea,
    0x2117c387, 0xb1a35233, 0x47aca05c, 0xd71831e8, 0x64c58085,
    0xf4711131, 0x9c936b53, 0x0c27fae7, 0xbffa4b8a, 0x2f4eda3e,
    0xd9412851, 0x49f5b9e5, 0xfa280888, 0x6a9c993c, 0x1637ec57,
    0x86837de3, 0x355ecc8e, 0xa5ea5d3a, 0x53e5af55, 0xc3513ee1,
    0x708c8f8c, 0xe0381e38, 0xf06c476c, 0x60d8d6d8, 0xd30567b5,
    0x43b1f601, 0xb5be046e, 0x250a95da, 0x96d724b7, 0x0663b503,
    0x7ac8c068, 0xea7c51dc, 0x59a1e0b1, 0xc9157105, 0x3f1a836a,
    0xafae12de, 0x1c73a3b3, 0x8cc73207, 0xe4254865, 0x7491d9d1,
    0xc74c68bc, 0x57f8f908, 0xa1f70b67, 0x31439ad3, 0x829e2bbe,
    0x122aba0a, 0x6e81cf61, 0xfe355ed5, 0x4de8efb8, 0xdd5c7e0c,
    0x2b538c63, 0xbbe71dd7, 0x083aacba, 0x988e3d0e, 0xd8fe597e,
    0x484ac8ca, 0xfb9779a7, 0x6b23e813, 0x9d2c1a7c, 0x0d988bc8,
    0xbe453aa5, 0x2ef1ab11, 0x525ade7a, 0xc2ee4fce, 0x7133fea3,
    0xe1876f17, 0x17889d78, 0x873c0ccc, 0x34e1bda1, 0xa4552c15,
    0xccb75677, 0x5c03c7c3, 0xefde76ae, 0x7f6ae71a, 0x89651575,
    0x19d184c1, 0xaa0c35ac, 0x3ab8a418, 0x4613d173, 0xd6a740c7,
    0x657af1aa, 0xf5ce601e, 0x03c19271, 0x937503c5, 0x20a8b2a8,
    0xb01c231c},
   {0x00000000, 0xb401b441, 0x68036883, 0xdc02dcc2, 0xd306d3b6,
    0x670767f7, 0xbb05bb35, 0x0f040f74, 0xa50da5dd, 0x110c119c,
    0xcd0ecd5e, 0x790f791f, 0x760b766b, 0xc20ac22a, 0x1e081ee8,
    0xaa09aaa9, 0x491b490b, 0xfd1afd4a, 0x21182188, 0x951995c9,
    0x9a1d9abd, 0x2e1c2efc, 0xf21ef23e, 0x461f467f, 0xec16ecd6,
    0x58175897, 0x84158455, 0x30143014, 0x3f103f60, 0x8b118b21,
    0x571357e3, 0xe312e3a2, 0x92369216, 0x26372657, 0xfa35fa95,
    0x4e344ed4, 0x413041a0, 0xf531f5e1, 0x29332923, 0x9d329d62,
    0x373b37cb, 0x833a838a, 0x5f385f48, 0xeb39eb09, 0xe43de47d,
    0x503c503c, 0x8c3e8cfe, 0x383f38bf, 0xdb2ddb1d, 0x6f2c6f5c,
    0xb32eb39e, 0x072f07df, 0x082b08ab, 0xbc2abcea, 0x60286028,
    0xd429d469, 0x7e207ec0, 0xca21ca81, 0x16231643, 0xa222a202,
    0xad26ad76, 0x19271937, 0xc525c5f5, 0x712471b4, 0x246d242d,
    0x906c906c, 0x4c6e4cae, 0xf86ff8ef, 0xf76bf79b, 0x436a43da,
    0x9f689f18, 0x2b692b59, 0x816081f0, 0x356135b1, 0xe963e973,
    0x5d625d32, 0x52665246, 0xe667e607, 0x3a653ac5, 0x8e648e84,
    0x6d766d26, 0xd977d967, 0x057505a5, 0xb174b1e4, 0xbe70be90,
    0x0a710ad1, 0xd673d613, 0x62726252, 0xc87bc8fb, 0x7c7a7cba,
    0xa078a078, 0x14791439, 0x1b7d1b4d, 0xaf7caf0c, 0x737e73ce,
    0xc77fc78f, 0xb65bb63b, 0x025a027a, 0xde58deb8, 0x6a596af9,
    0x655d658d, 0xd15cd1cc, 0x0d5e0d0e, 0xb95fb94f, 0x135613e6,
    0xa757a7a7, 0x7b557b65, 0xcf54cf24, 0xc050c050, 0x74517411,
    0xa853a8d3, 0x1c521c92, 0xff40ff30, 0x4b414b71, 0x974397b3,
    0x234223f2, 0x2c462c86, 0x984798c7, 0x44454405, 0xf044f044,
    0x5a4d5aed, 0xee4ceeac, 0x324e326e, 0x864f862f, 0x894b895b,
    0x3d4a3d1a, 0xe148e1d8, 0x55495599, 0x48da485a, 0xfcdbfc1b,
    0x20d920d9, 0x94d89498, 0x9bdc9bec, 0x2fdd2fad, 0xf3dff36f,
    0x47de472e, 0xedd7ed87, 0x59d659c6, 0x85d48504, 0x31d53145,
    0x3ed13e31, 0x8ad08a70, 0x56d256b2, 0xe2d3e2f3, 0x01c10151,
    0xb5c0b510, 0x69c269d2, 0xddc3dd93, 0xd2c7d2e7, 0x66c666a6,
    0xbac4ba64, 0x0ec50e25, 0xa4cca48c, 0x10cd10cd, 0xcccfcc0f,
    0x78ce784e, 0x77ca773a, 0xc3cbc37b, 0x1fc91fb9, 0xabc8abf8,
    0xdaecda4c, 0x6eed6e0d, 0xb2efb2cf, 0x06ee068e, 0x09ea09fa,
    0xbdebbdbb, 0x61e96179, 0xd5e8d538, 0x7fe17f91, 0xcbe0cbd0,
    0x17e21712, 0xa3e3a353, 0xace7ac27, 0x18e61866, 0xc4e4c4a4,
    0x70e570e5, 0x93f79347, 0x27f62706, 0xfbf4fbc4, 0x4ff54f85,
    0x40f140f1, 0xf4f0f4b0, 0x28f22872, 0x9cf39c33, 0x36fa369a,
    0x82fb82db, 0x5ef95e19, 0xeaf8ea58, 0xe5fce52c, 0x51fd516d,
    0x8dff8daf, 0x39fe39ee, 0x6cb76c77, 0xd8b6d836, 0x04b404f4,
    0xb0b5b0b5, 0xbfb1bfc1, 0x0bb00b80, 0xd7b2d742, 0x63b36303,
    0xc9bac9aa, 0x7dbb7deb, 0xa1b9a129, 0x15b81568, 0x1abc1a1c,
    0xaebdae5d, 0x72bf729f, 0xc6bec6de, 0x25ac257c, 0x91ad913d,
    0x4daf4dff, 0xf9aef9be, 0xf6aaf6ca, 0x42ab428b, 0x9ea99e49,
    0x2aa82a08, 0x80a180a1, 0x34a034e0, 0xe8a2e822, 0x5ca35c63,
    0x53a75317, 0xe7a6e756, 0x3ba43b94, 0x8fa58fd5, 0xfe81fe61,
    0x4a804a20, 0x968296e2, 0x228322a3, 0x2d872dd7, 0x99869996,
    0x45844554, 0xf185f115, 0x5b8c5bbc, 0xef8deffd, 0x338f333f,
    0x878e877e, 0x888a880a, 0x3c8b3c4b, 0xe089e089, 0x548854c8,
    0xb79ab76a, 0x039b032b, 0xdf99dfe9, 0x6b986ba8, 0x649c64dc,
    0xd09dd09d, 0x0c9f0c5f, 0xb89eb81e, 0x129712b7, 0xa696a6f6,
    0x7a947a34, 0xce95ce75, 0xc191c101, 0x75907540, 0xa992a982,
    0x1d931dc3},
   {0x00000000, 0x01000151, 0x020002a2, 0x030003f3, 0x070007f4,
    0x060006a5, 0x05000556, 0x04000407, 0x0d000d58, 0x0c000c09,
    0x0f000ffa, 0x0e000eab, 0x0a000aac, 0x0b000bfd, 0x0800080e,
    0x0900095f, 0x1a001ab0, 0x1b001be1, 0x18001812, 0x19001943,
    0x1d001d44, 0x1c001c15, 0x1f001fe6, 0x1e001eb7, 0x170017e8,
    0x160016b9, 0x1500154a, 0x1400141b, 0x1000101c, 0x1100114d,
    0x120012be, 0x130013ef, 0x370037d0, 0x36003681, 0x35003572,
    0x34003423, 0x30003024, 0x31003175, 0x32003286, 0x330033d7,
    0x3a003a88, 0x3b003bd9, 0x3800382a, 0x3900397b, 0x3d003d7c,
    0x3c003c2d, 0x3f003fde, 0x3e003e8f, 0x2d002d60, 0x2c002c31,
    0x2f002fc2, 0x2e002e93, 0x2a002a94, 0x2b002bc5, 0x28002836,
    0x29002967, 0x20002038, 0x21002169, 0x2200229a, 0x230023cb,
    0x270027cc, 0x2600269d, 0x2500256e, 0x2400243f, 0x6d006d10,
    0x6c006c41, 0x6f006fb2, 0x6e006ee3, 0x6a006ae4, 0x6b006bb5,
    0x68006846, 0x69006917, 0x60006048, 0x61006119, 0x620062ea,
    0x630063bb, 0x670067bc, 0x660066ed, 0x6500651e, 0x6400644f,
    0x770077a0, 0x760076f1, 0x75007502, 0x74007453, 0x70007054,
    0x71007105, 0x720072f6, 0x730073a7, 0x7a007af8, 0x7b007ba9,
    0x7800785a, 0x7900790b, 0x7d007d0c, 0x7c007c5d, 0x7f007fae,
    0x7e007eff, 0x5a005ac0, 0x5b005b91, 0x58005862, 0x59005933,
    0x5d005d34, 0x5c005c65, 0x5f005f96, 0x5e005ec7, 0x57005798,
    0x560056c9, 0x5500553a, 0x5400546b, 0x5000506c, 0x5100513d,
    0x520052ce, 0x5300539f, 0x40004070, 0x41004121, 0x420042d2,
    0x43004383, 0x47004784, 0x460046d5, 0x45004526, 0x44004477,
    0x4d004d28, 0x4c004c79, 0x4f004f8a, 0x4e004edb, 0x4a004adc,
    0x4b004b8d, 0x4800487e, 0x4900492f, 0xda00da20, 0xdb00db71,
    0xd800d882, 0xd900d9d3, 0xdd00ddd4, 0xdc00dc85, 0xdf00df76,
    0xde00de27, 0xd700d778, 0xd600d629, 0xd500d5da, 0xd400d48b,
    0xd000d08c, 0xd100d1dd, 0xd200d22e, 0xd300d37f, 0xc000c090,
    0xc100c1c1, 0xc200c232, 0xc300c363, 0xc700c764, 0xc600c635,
    0xc500c5c6, 0xc400c497, 0xcd00cdc8, 0xcc00cc99, 0xcf00cf6a,
    0xce00ce3b, 0xca00ca3c, 0xcb00cb6d, 0xc800c89e, 0xc900c9cf,
    0xed00edf0, 0xec00eca1, 0xef00ef52, 0xee00ee03, 0xea00ea04,
    0xeb00eb55, 0xe800e8a6, 0xe900e9f7, 0xe000e0a8, 0xe100e1f9,
    0xe200e20a, 0xe300e35b, 0xe700e75c, 0xe600e60d, 0xe500e5fe,
    0xe400e4af, 0xf700f740, 0xf600f611, 0xf500f5e2, 0xf400f4b3,
    0xf000f0b4, 0xf100f1e5, 0xf200f216, 0xf300f347, 0xfa00fa18,
    0xfb00fb49, 0xf800f8ba, 0xf900f9eb, 0xfd00fdec, 0xfc00fcbd,
    0xff00ff4e, 0xfe00fe1f, 0xb700b730, 0xb600b661, 0xb500b592,
    0xb400b4c3, 0xb000b0c4, 0xb100b195, 0xb200b266, 0xb300b337,
    0xba00ba68, 0xbb00bb39, 0xb800b8ca, 0xb900b99b, 0xbd00bd9c,
    0xbc00bccd, 0xbf00bf3e, 0xbe00be6f, 0xad00ad80, 0xac00acd1,
    0xaf00af22, 0xae00ae73, 0xaa00aa74, 0xab00ab25, 0xa800a8d6,
    0xa900a987, 0xa000a0d8, 0xa100a189, 0xa200a27a, 0xa300a32b,
    0xa700a72c, 0xa600a67d, 0xa500a58e, 0xa400a4df, 0x800080e0,
    0x810081b1, 0x82008242, 0x83008313, 0x87008714, 0x86008645,
    0x850085b6, 0x840084e7, 0x8d008db8, 0x8c008ce9, 0x8f008f1a,
    0x8e008e4b, 0x8a008a4c, 0x8b008b1d, 0x880088ee, 0x890089bf,
    0x9a009a50, 0x9b009b01, 0x980098f2, 0x990099a3, 0x9d009da4,
    0x9c009cf5, 0x9f009f06, 0x9e009e57, 0x97009708, 0x96009659,
    0x950095aa, 0x940094fb, 0x900090fc, 0x910091ad, 0x9200925e,
    0x9300930f}};

#endif

#endif

#if N == 4

#if W == 8

static const crc_t crc_braid_table[][256] = {
   {0x00000000, 0xbd01c000, 0xca008003, 0x77014003, 0x24020005,
    0x9903c005, 0xee028006, 0x53034006, 0x4804000a, 0xf505c00a,
    0x82048009, 0x3f054009, 0x6c06000f, 0xd107c00f, 0xa606800c,
    0x1b07400c, 0x90080014, 0x2d09c014, 0x5a088017, 0xe7094017,
    0xb40a0011, 0x090bc011, 0x7e0a8012, 0xc30b4012, 0xd80c001e,
    0x650dc01e, 0x120c801d, 0xaf0d401d, 0xfc0e001b, 0x410fc01b,
    0x360e8018, 0x8b0f4018, 0x9013002b, 0x2d12c02b, 0x5a138028,
    0xe7124028, 0xb411002e, 0x0910c02e, 0x7e11802d, 0xc310402d,
    0xd8170021, 0x6516c021, 0x12178022, 0xaf164022, 0xfc150024,
    0x4114c024, 0x36158027, 0x8b144027, 0x001b003f, 0xbd1ac03f,
    0xca1b803c, 0x771a403c, 0x2419003a, 0x9918c03a, 0xee198039,
    0x53184039, 0x481f0035, 0xf51ec035, 0x821f8036, 0x3f1e4036,
    0x6c1d0030, 0xd11cc030, 0xa61d8033, 0x1b1c4033, 0x90250055,
    0x2d24c055, 0x5a258056, 0xe7244056, 0xb4270050, 0x0926c050,
    0x7e278053, 0xc3264053, 0xd821005f, 0x6520c05f, 0x1221805c,
    0xaf20405c, 0xfc23005a, 0x4122c05a, 0x36238059, 0x8b224059,
    0x002d0041, 0xbd2cc041, 0xca2d8042, 0x772c4042, 0x242f0044,
    0x992ec044, 0xee2f8047, 0x532e4047, 0x4829004b, 0xf528c04b,
    0x82298048, 0x3f284048, 0x6c2b004e, 0xd12ac04e, 0xa62b804d,
    0x1b2a404d, 0x0036007e, 0xbd37c07e, 0xca36807d, 0x7737407d,
    0x2434007b, 0x9935c07b, 0xee348078, 0x53354078, 0x48320074,
    0xf533c074, 0x82328077, 0x3f334077, 0x6c300071, 0xd131c071,
    0xa6308072, 0x1b314072, 0x903e006a, 0x2d3fc06a, 0x5a3e8069,
    0xe73f4069, 0xb43c006f, 0x093dc06f, 0x7e3c806c, 0xc33d406c,
    0xd83a0060, 0x653bc060, 0x123a8063, 0xaf3b4063, 0xfc380065,
    0x4139c065, 0x36388066, 0x8b394066, 0x904900a9, 0x2d48c0a9,
    0x5a4980aa, 0xe74840aa, 0xb44b00ac, 0x094ac0ac, 0x7e4b80af,
    0xc34a40af, 0xd84d00a3, 0x654cc0a3, 0x124d80a0, 0xaf4c40a0,
    0xfc4f00a6, 0x414ec0a6, 0x364f80a5, 0x8b4e40a5, 0x004100bd,
    0xbd40c0bd, 0xca4180be, 0x774040be, 0x244300b8, 0x9942c0b8,
    0xee4380bb, 0x534240bb, 0x484500b7, 0xf544c0b7, 0x824580b4,
    0x3f4440b4, 0x6c4700b2, 0xd146c0b2, 0xa64780b1, 0x1b4640b1,
    0x005a0082, 0xbd5bc082, 0xca5a8081, 0x775b4081, 0x24580087,
    0x9959c087, 0xee588084, 0x53594084, 0x485e0088, 0xf55fc088,
    0x825e808b, 0x3f5f408b, 0x6c5c008d, 0xd15dc08d, 0xa65c808e,
    0x1b5d408e, 0x90520096, 0x2d53c096, 0x5a528095, 0xe7534095,
    0xb4500093, 0x0951c093, 0x7e508090, 0xc3514090, 0xd856009c,
    0x6557c09c, 0x1256809f, 0xaf57409f, 0xfc540099, 0x4155c099,
    0x3654809a, 0x8b55409a, 0x006c00fc, 0xbd6dc0fc, 0xca6c80ff,
    0x776d40ff, 0x246e00f9, 0x996fc0f9, 0xee6e80fa, 0x536f40fa,
    0x486800f6, 0xf569c0f6, 0x826880f5, 0x3f6940f5, 0x6c6a00f3,
    0xd16bc0f3, 0xa66a80f0, 0x1b6b40f0, 0x906400e8, 0x2d65c0e8,
    0x5a6480eb, 0xe76540eb, 0xb46600ed, 0x0967c0ed, 0x7e6680ee,
    0xc36740ee, 0xd86000e2, 0x6561c0e2, 0x126080e1, 0xaf6140e1,
    0xfc6200e7, 0x4163c0e7, 0x366280e4, 0x8b6340e4, 0x907f00d7,
    0x2d7ec0d7, 0x5a7f80d4, 0xe77e40d4, 0xb47d00d2, 0x097cc0d2,
    0x7e7d80d1, 0xc37c40d1, 0xd87b00dd, 0x657ac0dd, 0x127b80de,
    0xaf7a40de, 0xfc7900d8, 0x4178c0d8, 0x367980db, 0x8b7840db,
    0x007700c3, 0xbd76c0c3, 0xca7780c0, 0x777640c0, 0x247500c6,
    0x9974c0c6, 0xee7580c5, 0x537440c5, 0x487300c9, 0xf572c0c9,
    0x827380ca, 0x3f7240ca, 0x6c7100cc, 0xd170c0cc, 0xa67180cf,
    0x1b7040cf},
   {0x00000000, 0x90910151, 0x912102a1, 0x01b003f0, 0x92410541,
    0x02d00410, 0x036007e0, 0x93f106b1, 0x94810a81, 0x04100bd0,
    0x05a00820, 0x95310971, 0x06c00fc0, 0x96510e91, 0x97e10d61,
    0x07700c30, 0x99011501, 0x09901450, 0x082017a0, 0x98b116f1,
    0x0b401040, 0x9bd11111, 0x9a6112e1, 0x0af013b0, 0x0d801f80,
    0x9d111ed1, 0x9ca11d21, 0x0c301c70, 0x9fc11ac1, 0x0f501b90,
    0x0ee01860, 0x9e711931, 0x82012a01, 0x12902b50, 0x132028a0,
    0x83b129f1, 0x10402f40, 0x80d12e11, 0x81612de1, 0x11f02cb0,
    0x16802080, 0x861121d1, 0x87a12221, 0x17302370, 0x84c125c1,
    0x14502490, 0x15e02760, 0x85712631, 0x1b003f00, 0x8b913e51,
    0x8a213da1, 0x1ab03cf0, 0x89413a41, 0x19d03b10, 0x186038e0,
    0x88f139b1, 0x8f813581, 0x1f1034d0, 0x1ea03720, 0x8e313671,
    0x1dc030c0, 0x8d513191, 0x8ce13261, 0x1c703330, 0xb4015401,
    0x24905550, 0x252056a0, 0xb5b157f1, 0x26405140, 0xb6d15011,
    0xb76153e1, 0x27f052b0, 0x20805e80, 0xb0115fd1, 0xb1a15c21,
    0x21305d70, 0xb2c15bc1, 0x22505a90, 0x23e05960, 0xb3715831,
    0x2d004100, 0xbd914051, 0xbc2143a1, 0x2cb042f0, 0xbf414441,
    0x2fd04510, 0x2e6046e0, 0xbef147b1, 0xb9814b81, 0x29104ad0,
    0x28a04920, 0xb8314871, 0x2bc04ec0, 0xbb514f91, 0xbae14c61,
    0x2a704d30, 0x36007e00, 0xa6917f51, 0xa7217ca1, 0x37b07df0,
    0xa4417b41, 0x34d07a10, 0x356079e0, 0xa5f178b1, 0xa2817481,
    0x321075d0, 0x33a07620, 0xa3317771, 0x30c071c0, 0xa0517091,
    0xa1e17361, 0x31707230, 0xaf016b01, 0x3f906a50, 0x3e2069a0,
    0xaeb168f1, 0x3d406e40, 0xadd16f11, 0xac616ce1, 0x3cf06db0,
    0x3b806180, 0xab1160d1, 0xaaa16321, 0x3a306270, 0xa9c164c1,
    0x39506590, 0x38e06660, 0xa8716731, 0xd801a801, 0x4890a950,
    0x4920aaa0, 0xd9b1abf1, 0x4a40ad40, 0xdad1ac11, 0xdb61afe1,
    0x4bf0aeb0, 0x4c80a280, 0xdc11a3d1, 0xdda1a021, 0x4d30a170,
    0xdec1a7c1, 0x4e50a690, 0x4fe0a560, 0xdf71a431, 0x4100bd00,
    0xd191bc51, 0xd021bfa1, 0x40b0bef0, 0xd341b841, 0x43d0b910,
    0x4260bae0, 0xd2f1bbb1, 0xd581b781, 0x4510b6d0, 0x44a0b520,
    0xd431b471, 0x47c0b2c0, 0xd751b391, 0xd6e1b061, 0x4670b130,
    0x5a008200, 0xca918351, 0xcb2180a1, 0x5bb081f0, 0xc8418741,
    0x58d08610, 0x596085e0, 0xc9f184b1, 0xce818881, 0x5e1089d0,
    0x5fa08a20, 0xcf318b71, 0x5cc08dc0, 0xcc518c91, 0xcde18f61,
    0x5d708e30, 0xc3019701, 0x53909650, 0x522095a0, 0xc2b194f1,
    0x51409240, 0xc1d19311, 0xc06190e1, 0x50f091b0, 0x57809d80,
    0xc7119cd1, 0xc6a19f21, 0x56309e70, 0xc5c198c1, 0x55509990,
    0x54e09a60, 0xc4719b31, 0x6c00fc00, 0xfc91fd51, 0xfd21fea1,
    0x6db0fff0, 0xfe41f941, 0x6ed0f810, 0x6f60fbe0, 0xfff1fab1,
    0xf881f681, 0x6810f7d0, 0x69a0f420, 0xf931f571, 0x6ac0f3c0,
    0xfa51f291, 0xfbe1f161, 0x6b70f030, 0xf501e901, 0x6590e850,
    0x6420eba0, 0xf4b1eaf1, 0x6740ec40, 0xf7d1ed11, 0xf661eee1,
    0x66f0efb0, 0x6180e380, 0xf111e2d1, 0xf0a1e121, 0x6030e070,
    0xf3c1e6c1, 0x6350e790, 0x62e0e460, 0xf271e531, 0xee01d601,
    0x7e90d750, 0x7f20d4a0, 0xefb1d5f1, 0x7c40d340, 0xecd1d211,
    0xed61d1e1, 0x7df0d0b0, 0x7a80dc80, 0xea11ddd1, 0xeba1de21,
    0x7b30df70, 0xe8c1d9c1, 0x7850d890, 0x79e0db60, 0xe971da31,
    0x7700c300, 0xe791c251, 0xe621c1a1, 0x76b0c0f0, 0xe541c641,
    0x75d0c710, 0x7460c4e0, 0xe4f1c5b1, 0xe381c981, 0x7310c8d0,
    0x72a0cb20, 0xe231ca71, 0x71c0ccc0, 0xe151cd91, 0xe0e1ce61,
    0x7070cf30},
   {0x00000000, 0x00005001, 0x0000a002, 0x0000f003, 0x00014004,
    0x00011005, 0x0001e006, 0x0001b007, 0x00028008, 0x0002d009,
    0x0002200a, 0x0002700b, 0x0003c00c, 0x0003900d, 0x0003600e,
    0x0003300f, 0x00050010, 0x00055011, 0x0005a012, 0x0005f013,
    0x00044014, 0x00041015, 0x0004e016, 0x0004b017, 0x00078018,
    0x0007d019, 0x0007201a, 0x0007701b, 0x0006c01c, 0x0006901d,
    0x0006601e, 0x0006301f, 0x000a0020, 0x000a5021, 0x000aa022,
    0x000af023, 0x000b4024, 0x000b1025, 0x000be026, 0x000bb027,
    0x00088028, 0x0008d029, 0x0008202a, 0x0008702b, 0x0009c02c,
    0x0009902d, 0x0009602e, 0x0009302f, 0x000f0030, 0x000f5031,
    0x000fa032, 0x000ff033, 0x000e4034, 0x000e1035, 0x000ee036,
    0x000eb037, 0x000d8038, 0x000dd039, 0x000d203a, 0x000d703b,
    0x000cc03c, 0x000c903d, 0x000c603e, 0x000c303f, 0x00140040,
    0x00145041, 0x0014a042, 0x0014f043, 0x00154044, 0x00151045,
    0x0015e046, 0x0015b047, 0x00168048, 0x0016d049, 0x0016204a,
    0x0016704b, 0x0017c04c, 0x0017904d, 0x0017604e, 0x0017304f,
    0x00110050, 0x00115051, 0x0011a052, 0x0011f053, 0x00104054,
    0x00101055, 0x0010e056, 0x0010b057, 0x00138058, 0x0013d059,
    0x0013205a, 0x0013705b, 0x0012c05c, 0x0012905d, 0x0012605e,
    0x0012305f, 0x001e0060, 0x001e5061, 0x001ea062, 0x001ef063,
    0x001f4064, 0x001f1065, 0x001fe066, 0x001fb067, 0x001c8068,
    0x001cd069, 0x001c206a, 0x001c706b, 0x001dc06c, 0x001d906d,
    0x001d606e, 0x001d306f, 0x001b0070, 0x001b5071, 0x001ba072,
    0x001bf073, 0x001a4074, 0x001a1075, 0x001ae076, 0x001ab077,
    0x00198078, 0x0019d079, 0x0019207a, 0x0019707b, 0x0018c07c,
    0x0018907d, 0x0018607e, 0x0018307f, 0x00280080, 0x00285081,
    0x0028a082, 0x0028f083, 0x00294084, 0x00291085, 0x0029e086,
    0x0029b087, 0x002a8088, 0x002ad089, 0x002a208a, 0x002a708b,
    0x002bc08c, 0x002b908d, 0x002b608e, 0x002b308f, 0x002d0090,
    0x002d5091, 0x002da092, 0x002df093, 0x002c4094, 0x002c1095,
    0x002ce096, 0x002cb097, 0x002f8098, 0x002fd099, 0x002f209a,
    0x002f709b, 0x002ec09c, 0x002e909d, 0x002e609e, 0x002e309f,
    0x002200a0, 0x002250a1, 0x0022a0a2, 0x0022f0a3, 0x002340a4,
    0x002310a5, 0x0023e0a6, 0x0023b0a7, 0x002080a8, 0x0020d0a9,
    0x002020aa, 0x002070ab, 0x0021c0ac, 0x002190ad, 0x002160ae,
    0x002130af, 0x002700b0, 0x002750b1, 0x0027a0b2, 0x0027f0b3,
    0x002640b4, 0x002610b5, 0x0026e0b6, 0x0026b0b7, 0x002580b8,
    0x0025d0b9, 0x002520ba, 0x002570bb, 0x0024c0bc, 0x002490bd,
    0x002460be, 0x002430bf, 0x003c00c0, 0x003c50c1, 0x003ca0c2,
    0x003cf0c3, 0x003d40c4, 0x003d10c5, 0x003de0c6, 0x003db0c7,
    0x003e80c8, 0x003ed0c9, 0x003e20ca, 0x003e70cb, 0x003fc0cc,
    0x003f90cd, 0x003f60ce, 0x003f30cf, 0x003900d0, 0x003950d1,
    0x0039a0d2, 0x0039f0d3, 0x003840d4, 0x003810d5, 0x0038e0d6,
    0x0038b0d7, 0x003b80d8, 0x003bd0d9, 0x003b20da, 0x003b70db,
    0x003ac0dc, 0x003a90dd, 0x003a60de, 0x003a30df, 0x003600e0,
    0x003650e1, 0x0036a0e2, 0x0036f0e3, 0x003740e4, 0x003710e5,
    0x0037e0e6, 0x0037b0e7, 0x003480e8, 0x0034d0e9, 0x003420ea,
    0x003470eb, 0x0035c0ec, 0x003590ed, 0x003560ee, 0x003530ef,
    0x003300f0, 0x003350f1, 0x0033a0f2, 0x0033f0f3, 0x003240f4,
    0x003210f5, 0x0032e0f6, 0x0032b0f7, 0x003180f8, 0x0031d0f9,
    0x003120fa, 0x003170fb, 0x0030c0fc, 0x003090fd, 0x003060fe,
    0x003030ff},
   {0x00000000, 0x00500100, 0x00a00200, 0x00f00300, 0x01400400,
    0x01100500, 0x01e00600, 0x01b00700, 0x02800800, 0x02d00900,
    0x02200a00, 0x02700b00, 0x03c00c00, 0x03900d00, 0x03600e00,
    0x03300f00, 0x05001000, 0x05501100, 0x05a01200, 0x05f01300,
    0x04401400, 0x04101500, 0x04e01600, 0x04b01700, 0x07801800,
    0x07d01900, 0x07201a00, 0x07701b00, 0x06c01c00, 0x06901d00,
    0x06601e00, 0x06301f00, 0x0a002000, 0x0a502100, 0x0aa02200,
    0x0af02300, 0x0b402400, 0x0b102500, 0x0be02600, 0x0bb02700,
    0x08802800, 0x08d02900, 0x08202a00, 0x08702b00, 0x09c02c00,
    0x09902d00, 0x09602e00, 0x09302f00, 0x0f003000, 0x0f503100,
    0x0fa03200, 0x0ff03300, 0x0e403400, 0x0e103500, 0x0ee03600,
    0x0eb03700, 0x0d803800, 0x0dd03900, 0x0d203a00, 0x0d703b00,
    0x0cc03c00, 0x0c903d00, 0x0c603e00, 0x0c303f00, 0x14004000,
    0x14504100, 0x14a04200, 0x14f04300, 0x15404400, 0x15104500,
    0x15e04600, 0x15b04700, 0x16804800, 0x16d04900, 0x16204a00,
    0x16704b00, 0x17c04c00, 0x17904d00, 0x17604e00, 0x17304f00,
    0x11005000, 0x11505100, 0x11a05200, 0x11f05300, 0x10405400,
    0x10105500, 0x10e05600, 0x10b05700, 0x13805800, 0x13d05900,
    0x13205a00, 0x13705b00, 0x12c05c00, 0x12905d00, 0x12605e00,
    0x12305f00, 0x1e006000, 0x1e506100, 0x1ea06200, 0x1ef06300,
    0x1f406400, 0x1f106500, 0x1fe06600, 0x1fb06700, 0x1c806800,
    0x1cd06900, 0x1c206a00, 0x1c706b00, 0x1dc06c00, 0x1d906d00,
    0x1d606e00, 0x1d306f00, 0x1b007000, 0x1b507100, 0x1ba07200,
    0x1bf07300, 0x1a407400, 0x1a107500, 0x1ae07600, 0x1ab07700,
    0x19807800, 0x19d07900, 0x19207a00, 0x19707b00, 0x18c07c00,
    0x18907d00, 0x18607e00, 0x18307f00, 0x28008000, 0x28508100,
    0x28a08200, 0x28f08300, 0x29408400, 0x29108500, 0x29e08600,
    0x29b08700, 0x2a808800, 0x2ad08900, 0x2a208a00, 0x2a708b00,
    0x2bc08c00, 0x2b908d00, 0x2b608e00, 0x2b308f00, 0x2d009000,
    0x2d509100, 0x2da09200, 0x2df09300, 0x2c409400, 0x2c109500,
    0x2ce09600, 0x2cb09700, 0x2f809800, 0x2fd09900, 0x2f209a00,
    0x2f709b00, 0x2ec09c00, 0x2e909d00, 0x2e609e00, 0x2e309f00,
    0x2200a000, 0x2250a100, 0x22a0a200, 0x22f0a300, 0x2340a400,
    0x2310a500, 0x23e0a600, 0x23b0a700, 0x2080a800, 0x20d0a900,
    0x2020aa00, 0x2070ab00, 0x21c0ac00, 0x2190ad00, 0x2160ae00,
    0x2130af00, 0x2700b000, 0x2750b100, 0x27a0b200, 0x27f0b300,
    0x2640b400, 0x2610b500, 0x26e0b600, 0x26b0b700, 0x2580b800,
    0x25d0b900, 0x2520ba00, 0x2570bb00, 0x24c0bc00, 0x2490bd00,
    0x2460be00, 0x2430bf00, 0x3c00c000, 0x3c50c100, 0x3ca0c200,
    0x3cf0c300, 0x3d40c400, 0x3d10c500, 0x3de0c600, 0x3db0c700,
    0x3e80c800, 0x3ed0c900, 0x3e20ca00, 0x3e70cb00, 0x3fc0cc00,
    0x3f90cd00, 0x3f60ce00, 0x3f30cf00, 0x3900d000, 0x3950d100,
    0x39a0d200, 0x39f0d300, 0x3840d400, 0x3810d500, 0x38e0d600,
    0x38b0d700, 0x3b80d800, 0x3bd0d900, 0x3b20da00, 0x3b70db00,
    0x3ac0dc00, 0x3a90dd00, 0x3a60de00, 0x3a30df00, 0x3600e000,
    0x3650e100, 0x36a0e200, 0x36f0e300, 0x3740e400, 0x3710e500,
    0x37e0e600, 0x37b0e700, 0x3480e800, 0x34d0e900, 0x3420ea00,
    0x3470eb00, 0x35c0ec00, 0x3590ed00, 0x3560ee00, 0x3530ef00,
    0x3300f000, 0x3350f100, 0x33a0f200, 0x33f0f300, 0x3240f400,
    0x3210f500, 0x32e0f600, 0x32b0f700, 0x3180f800, 0x31d0f900,
    0x3120fa00, 0x3170fb00, 0x30c0fc00, 0x3090fd00, 0x3060fe00,
    0x3030ff00},
   {0x00000000, 0x50010000, 0xa0020000, 0xf0030000, 0xf0070003,
    0xa0060003, 0x50050003, 0x00040003, 0x500d0005, 0x000c0005,
    0xf00f0005, 0xa00e0005, 0xa00a0006, 0xf00b0006, 0x00080006,
    0x50090006, 0xa01a000a, 0xf01b000a, 0x0018000a, 0x5019000a,
    0x501d0009, 0x001c0009, 0xf01f0009, 0xa01e0009, 0xf017000f,
    0xa016000f, 0x5015000f, 0x0014000f, 0x0010000c, 0x5011000c,
    0xa012000c, 0xf013000c, 0xf0370017, 0xa0360017, 0x50350017,
    0x00340017, 0x00300014, 0x50310014, 0xa0320014, 0xf0330014,
    0xa03a0012, 0xf03b0012, 0x00380012, 0x50390012, 0x503d0011,
    0x003c0011, 0xf03f0011, 0xa03e0011, 0x502d001d, 0x002c001d,
    0xf02f001d, 0xa02e001d, 0xa02a001e, 0xf02b001e, 0x0028001e,
    0x5029001e, 0x00200018, 0x50210018, 0xa0220018, 0xf0230018,
    0xf027001b, 0xa026001b, 0x5025001b, 0x0024001b, 0x506d002d,
    0x006c002d, 0xf06f002d, 0xa06e002d, 0xa06a002e, 0xf06b002e,
    0x0068002e, 0x5069002e, 0x00600028, 0x50610028, 0xa0620028,
    0xf0630028, 0xf067002b, 0xa066002b, 0x5065002b, 0x0064002b,
    0xf0770027, 0xa0760027, 0x50750027, 0x00740027, 0x00700024,
    0x50710024, 0xa0720024, 0xf0730024, 0xa07a0022, 0xf07b0022,
    0x00780022, 0x50790022, 0x507d0021, 0x007c0021, 0xf07f0021,
    0xa07e0021, 0xa05a003a, 0xf05b003a, 0x0058003a, 0x5059003a,
    0x505d0039, 0x005c0039, 0xf05f0039, 0xa05e0039, 0xf057003f,
    0xa056003f, 0x5055003f, 0x0054003f, 0x0050003c, 0x5051003c,
    0xa052003c, 0xf053003c, 0x00400030, 0x50410030, 0xa0420030,
    0xf0430030, 0xf0470033, 0xa0460033, 0x50450033, 0x00440033,
    0x504d0035, 0x004c0035, 0xf04f0035, 0xa04e0035, 0xa04a0036,
    0xf04b0036, 0x00480036, 0x50490036, 0xa0da005a, 0xf0db005a,
    0x00d8005a, 0x50d9005a, 0x50dd0059, 0x00dc0059, 0xf0df0059,
    0xa0de0059, 0xf0d7005f, 0xa0d6005f, 0x50d5005f, 0x00d4005f,
    0x00d0005c, 0x50d1005c, 0xa0d2005c, 0xf0d3005c, 0x00c00050,
    0x50c10050, 0xa0c20050, 0xf0c30050, 0xf0c70053, 0xa0c60053,
    0x50c50053, 0x00c40053, 0x50cd0055, 0x00cc0055, 0xf0cf0055,
    0xa0ce0055, 0xa0ca0056, 0xf0cb0056, 0x00c80056, 0x50c90056,
    0x50ed004d, 0x00ec004d, 0xf0ef004d, 0xa0ee004d, 0xa0ea004e,
    0xf0eb004e, 0x00e8004e, 0x50e9004e, 0x00e00048, 0x50e10048,
    0xa0e20048, 0xf0e30048, 0xf0e7004b, 0xa0e6004b, 0x50e5004b,
    0x00e4004b, 0xf0f70047, 0xa0f60047, 0x50f50047, 0x00f40047,
    0x00f00044, 0x50f10044, 0xa0f20044, 0xf0f30044, 0xa0fa0042,
    0xf0fb0042, 0x00f80042, 0x50f90042, 0x50fd0041, 0x00fc0041,
    0xf0ff0041, 0xa0fe0041, 0xf0b70077, 0xa0b60077, 0x50b50077,
    0x00b40077, 0x00b00074, 0x50b10074, 0xa0b20074, 0xf0b30074,
    0xa0ba0072, 0xf0bb0072, 0x00b80072, 0x50b90072, 0x50bd0071,
    0x00bc0071, 0xf0bf0071, 0xa0be0071, 0x50ad007d, 0x00ac007d,
    0xf0af007d, 0xa0ae007d, 0xa0aa007e, 0xf0ab007e, 0x00a8007e,
    0x50a9007e, 0x00a00078, 0x50a10078, 0xa0a20078, 0xf0a30078,
    0xf0a7007b, 0xa0a6007b, 0x50a5007b, 0x00a4007b, 0x00800060,
    0x50810060, 0xa0820060, 0xf0830060, 0xf0870063, 0xa0860063,
    0x50850063, 0x00840063, 0x508d0065, 0x008c0065, 0xf08f0065,
    0xa08e0065, 0xa08a0066, 0xf08b0066, 0x00880066, 0x50890066,
    0xa09a006a, 0xf09b006a, 0x0098006a, 0x5099006a, 0x509d0069,
    0x009c0069, 0xf09f0069, 0xa09e0069, 0xf097006f, 0xa096006f,
    0x5095006f, 0x0094006f, 0x0090006c, 0x5091006c, 0xa092006c,
    0xf093006c},
   {0x00000000, 0xf1b700b7, 0x536d016d, 0xa2da01da, 0xa6da02da,
    0x576d026d, 0xf5b703b7, 0x04000300, 0xfdb705b7, 0x0c000500,
    0xaeda04da, 0x5f6d046d, 0x5b6d076d, 0xaada07da, 0x08000600,
    0xf9b706b7, 0x4b6d0b6d, 0xbada0bda, 0x18000a00, 0xe9b70ab7,
    0xedb709b7, 0x1c000900, 0xbeda08da, 0x4f6d086d, 0xb6da0eda,
    0x476d0e6d, 0xe5b70fb7, 0x14000f00, 0x10000c00, 0xe1b70cb7,
    0x436d0d6d, 0xb2da0dda, 0x96da16da, 0x676d166d, 0xc5b717b7,
    0x34001700, 0x30001400, 0xc1b714b7, 0x636d156d, 0x92da15da,
    0x6b6d136d, 0x9ada13da, 0x38001200, 0xc9b712b7, 0xcdb711b7,
    0x3c001100, 0x9eda10da, 0x6f6d106d, 0xddb71db7, 0x2c001d00,
    0x8eda1cda, 0x7f6d1c6d, 0x7b6d1f6d, 0x8ada1fda, 0x28001e00,
    0xd9b71eb7, 0x20001800, 0xd1b718b7, 0x736d196d, 0x82da19da,
    0x86da1ada, 0x776d1a6d, 0xd5b71bb7, 0x24001b00, 0x9db72db7,
    0x6c002d00, 0xceda2cda, 0x3f6d2c6d, 0x3b6d2f6d, 0xcada2fda,
    0x68002e00, 0x99b72eb7, 0x60002800, 0x91b728b7, 0x336d296d,
    0xc2da29da, 0xc6da2ada, 0x376d2a6d, 0x95b72bb7, 0x64002b00,
    0xd6da26da, 0x276d266d, 0x85b727b7, 0x74002700, 0x70002400,
    0x81b724b7, 0x236d256d, 0xd2da25da, 0x2b6d236d, 0xdada23da,
    0x78002200, 0x89b722b7, 0x8db721b7, 0x7c002100, 0xdeda20da,
    0x2f6d206d, 0x0b6d3b6d, 0xfada3bda, 0x58003a00, 0xa9b73ab7,
    0xadb739b7, 0x5c003900, 0xfeda38da, 0x0f6d386d, 0xf6da3eda,
    0x076d3e6d, 0xa5b73fb7, 0x54003f00, 0x50003c00, 0xa1b73cb7,
    0x036d3d6d, 0xf2da3dda, 0x40003000, 0xb1b730b7, 0x136d316d,
    0xe2da31da, 0xe6da32da, 0x176d326d, 0xb5b733b7, 0x44003300,
    0xbdb735b7, 0x4c003500, 0xeeda34da, 0x1f6d346d, 0x1b6d376d,
    0xeada37da, 0x48003600, 0xb9b736b7, 0x8b6d5b6d, 0x7ada5bda,
    0xd8005a00, 0x29b75ab7, 0x2db759b7, 0xdc005900, 0x7eda58da,
    0x8f6d586d, 0x76da5eda, 0x876d5e6d, 0x25b75fb7, 0xd4005f00,
    0xd0005c00, 0x21b75cb7, 0x836d5d6d, 0x72da5dda, 0xc0005000,
    0x31b750b7, 0x936d516d, 0x62da51da, 0x66da52da, 0x976d526d,
    0x35b753b7, 0xc4005300, 0x3db755b7, 0xcc005500, 0x6eda54da,
    0x9f6d546d, 0x9b6d576d, 0x6ada57da, 0xc8005600, 0x39b756b7,
    0x1db74db7, 0xec004d00, 0x4eda4cda, 0xbf6d4c6d, 0xbb6d4f6d,
    0x4ada4fda, 0xe8004e00, 0x19b74eb7, 0xe0004800, 0x11b748b7,
    0xb36d496d, 0x42da49da, 0x46da4ada, 0xb76d4a6d, 0x15b74bb7,
    0xe4004b00, 0x56da46da, 0xa76d466d, 0x05b747b7, 0xf4004700,
    0xf0004400, 0x01b744b7, 0xa36d456d, 0x52da45da, 0xab6d436d,
    0x5ada43da, 0xf8004200, 0x09b742b7, 0x0db741b7, 0xfc004100,
    0x5eda40da, 0xaf6d406d, 0x16da76da, 0xe76d766d, 0x45b777b7,
    0xb4007700, 0xb0007400, 0x41b774b7, 0xe36d756d, 0x12da75da,
    0xeb6d736d, 0x1ada73da, 0xb8007200, 0x49b772b7, 0x4db771b7,
    0xbc007100, 0x1eda70da, 0xef6d706d, 0x5db77db7, 0xac007d00,
    0x0eda7cda, 0xff6d7c6d, 0xfb6d7f6d, 0x0ada7fda, 0xa8007e00,
    0x59b77eb7, 0xa0007800, 0x51b778b7, 0xf36d796d, 0x02da79da,
    0x06da7ada, 0xf76d7a6d, 0x55b77bb7, 0xa4007b00, 0x80006000,
    0x71b760b7, 0xd36d616d, 0x22da61da, 0x26da62da, 0xd76d626d,
    0x75b763b7, 0x84006300, 0x7db765b7, 0x8c006500, 0x2eda64da,
    0xdf6d646d, 0xdb6d676d, 0x2ada67da, 0x88006600, 0x79b766b7,
    0xcb6d6b6d, 0x3ada6bda, 0x98006a00, 0x69b76ab7, 0x6db769b7,
    0x9c006900, 0x3eda68da, 0xcf6d686d, 0x36da6eda, 0xc76d6e6d,
    0x65b76fb7, 0x94006f00, 0x90006c00, 0x61b76cb7, 0xc36d6d6d,
    0x32da6dda},
   {0x00000000, 0xa6d9b6d9, 0xfdb06db1, 0x5b69db68, 0x4b63db61,
    0xedba6db8, 0xb6d3b6d0, 0x100a0009, 0x96c7b6c2, 0x301e001b,
    0x6b77db73, 0xcdae6daa, 0xdda46da3, 0x7b7ddb7a, 0x20140012,
    0x86cdb6cb, 0x9d8c6d87, 0x3b55db5e, 0x603c0036, 0xc6e5b6ef,
    0xd6efb6e6, 0x7036003f, 0x2b5fdb57, 0x8d866d8e, 0x0b4bdb45,
    0xad926d9c, 0xf6fbb6f4, 0x5022002d, 0x40280024, 0xe6f1b6fd,
    0xbd986d95, 0x1b41db4c, 0x8b1bdb0d, 0x2dc26dd4, 0x76abb6bc,
    0xd0720065, 0xc078006c, 0x66a1b6b5, 0x3dc86ddd, 0x9b11db04,
    0x1ddc6dcf, 0xbb05db16, 0xe06c007e, 0x46b5b6a7, 0x56bfb6ae,
    0xf0660077, 0xab0fdb1f, 0x0dd66dc6, 0x1697b68a, 0xb04e0053,
    0xeb27db3b, 0x4dfe6de2, 0x5df46deb, 0xfb2ddb32, 0xa044005a,
    0x069db683, 0x80500048, 0x2689b691, 0x7de06df9, 0xdb39db20,
    0xcb33db29, 0x6dea6df0, 0x3683b698, 0x905a0041, 0xa634b619,
    0x00ed00c0, 0x5b84dba8, 0xfd5d6d71, 0xed576d78, 0x4b8edba1,
    0x10e700c9, 0xb63eb610, 0x30f300db, 0x962ab602, 0xcd436d6a,
    0x6b9adbb3, 0x7b90dbba, 0xdd496d63, 0x8620b60b, 0x20f900d2,
    0x3bb8db9e, 0x9d616d47, 0xc608b62f, 0x60d100f6, 0x70db00ff,
    0xd602b626, 0x8d6b6d4e, 0x2bb2db97, 0xad7f6d5c, 0x0ba6db85,
    0x50cf00ed, 0xf616b634, 0xe61cb63d, 0x40c500e4, 0x1bacdb8c,
    0xbd756d55, 0x2d2f6d14, 0x8bf6dbcd, 0xd09f00a5, 0x7646b67c,
    0x664cb675, 0xc09500ac, 0x9bfcdbc4, 0x3d256d1d, 0xbbe8dbd6,
    0x1d316d0f, 0x4658b667, 0xe08100be, 0xf08b00b7, 0x5652b66e,
    0x0d3b6d06, 0xabe2dbdf, 0xb0a30093, 0x167ab64a, 0x4d136d22,
    0xebcadbfb, 0xfbc0dbf2, 0x5d196d2b, 0x0670b643, 0xa0a9009a,
    0x2664b651, 0x80bd0088, 0xdbd4dbe0, 0x7d0d6d39, 0x6d076d30,
    0xcbdedbe9, 0x90b70081, 0x366eb658, 0xfc6a6c31, 0x5ab3dae8,
    0x01da0180, 0xa703b759, 0xb709b750, 0x11d00189, 0x4ab9dae1,
    0xec606c38, 0x6aaddaf3, 0xcc746c2a, 0x971db742, 0x31c4019b,
    0x21ce0192, 0x8717b74b, 0xdc7e6c23, 0x7aa7dafa, 0x61e601b6,
    0xc73fb76f, 0x9c566c07, 0x3a8fdade, 0x2a85dad7, 0x8c5c6c0e,
    0xd735b766, 0x71ec01bf, 0xf721b774, 0x51f801ad, 0x0a91dac5,
    0xac486c1c, 0xbc426c15, 0x1a9bdacc, 0x41f201a4, 0xe72bb77d,
    0x7771b73c, 0xd1a801e5, 0x8ac1da8d, 0x2c186c54, 0x3c126c5d,
    0x9acbda84, 0xc1a201ec, 0x677bb735, 0xe1b601fe, 0x476fb727,
    0x1c066c4f, 0xbadfda96, 0xaad5da9f, 0x0c0c6c46, 0x5765b72e,
    0xf1bc01f7, 0xeafddabb, 0x4c246c62, 0x174db70a, 0xb19401d3,
    0xa19e01da, 0x0747b703, 0x5c2e6c6b, 0xfaf7dab2, 0x7c3a6c79,
    0xdae3daa0, 0x818a01c8, 0x2753b711, 0x3759b718, 0x918001c1,
    0xcae9daa9, 0x6c306c70, 0x5a5eda28, 0xfc876cf1, 0xa7eeb799,
    0x01370140, 0x113d0149, 0xb7e4b790, 0xec8d6cf8, 0x4a54da21,
    0xcc996cea, 0x6a40da33, 0x3129015b, 0x97f0b782, 0x87fab78b,
    0x21230152, 0x7a4ada3a, 0xdc936ce3, 0xc7d2b7af, 0x610b0176,
    0x3a62da1e, 0x9cbb6cc7, 0x8cb16cce, 0x2a68da17, 0x7101017f,
    0xd7d8b7a6, 0x5115016d, 0xf7ccb7b4, 0xaca56cdc, 0x0a7cda05,
    0x1a76da0c, 0xbcaf6cd5, 0xe7c6b7bd, 0x411f0164, 0xd1450125,
    0x779cb7fc, 0x2cf56c94, 0x8a2cda4d, 0x9a26da44, 0x3cff6c9d,
    0x6796b7f5, 0xc14f012c, 0x4782b7e7, 0xe15b013e, 0xba32da56,
    0x1ceb6c8f, 0x0ce16c86, 0xaa38da5f, 0xf1510137, 0x5788b7ee,
    0x4cc96ca2, 0xea10da7b, 0xb1790113, 0x17a0b7ca, 0x07aab7c3,
    0xa173011a, 0xfa1ada72, 0x5cc36cab, 0xda0eda60, 0x7cd76cb9,
    0x27beb7d1, 0x81670108, 0x916d0101, 0x37b4b7d8, 0x6cdd6cb0,
    0xca04da69},
   {0x00000000, 0x48d7d861, 0x91afb0c2, 0xd97868a3, 0x935c6187,
    0xdb8bb9e6, 0x02f3d145, 0x4a240924, 0x96bbc30d, 0xde6c1b6c,
    0x071473cf, 0x4fc3abae, 0x05e7a28a, 0x4d307aeb, 0x94481248,
    0xdc9fca29, 0x9d748619, 0xd5a35e78, 0x0cdb36db, 0x440ceeba,
    0x0e28e79e, 0x46ff3fff, 0x9f87575c, 0xd7508f3d, 0x0bcf4514,
    0x43189d75, 0x9a60f5d6, 0xd2b72db7, 0x98932493, 0xd044fcf2,
    0x093c9451, 0x41eb4c30, 0x8aea0c31, 0xc23dd450, 0x1b45bcf3,
    0x53926492, 0x19b66db6, 0x5161b5d7, 0x8819dd74, 0xc0ce0515,
    0x1c51cf3c, 0x5486175d, 0x8dfe7ffe, 0xc529a79f, 0x8f0daebb,
    0xc7da76da, 0x1ea21e79, 0x5675c618, 0x179e8a28, 0x5f495249,
    0x86313aea, 0xcee6e28b, 0x84c2ebaf, 0xcc1533ce, 0x156d5b6d,
    0x5dba830c, 0x81254925, 0xc9f29144, 0x108af9e7, 0x585d2186,
    0x127928a2, 0x5aaef0c3, 0x83d69860, 0xcb014001, 0xa5d71861,
    0xed00c000, 0x3478a8a3, 0x7caf70c2, 0x368b79e6, 0x7e5ca187,
    0xa724c924, 0xeff31145, 0x336cdb6c, 0x7bbb030d, 0xa2c36bae,
    0xea14b3cf, 0xa030baeb, 0xe8e7628a, 0x319f0a29, 0x7948d248,
    0x38a39e78, 0x70744619, 0xa90c2eba, 0xe1dbf6db, 0xabffffff,
    0xe328279e, 0x3a504f3d, 0x7287975c, 0xae185d75, 0xe6cf8514,
    0x3fb7edb7, 0x776035d6, 0x3d443cf2, 0x7593e493, 0xaceb8c30,
    0xe43c5451, 0x2f3d1450, 0x67eacc31, 0xbe92a492, 0xf6457cf3,
    0xbc6175d7, 0xf4b6adb6, 0x2dcec515, 0x65191d74, 0xb986d75d,
    0xf1510f3c, 0x2829679f, 0x60febffe, 0x2adab6da, 0x620d6ebb,
    0xbb750618, 0xf3a2de79, 0xb2499249, 0xfa9e4a28, 0x23e6228b,
    0x6b31faea, 0x2115f3ce, 0x69c22baf, 0xb0ba430c, 0xf86d9b6d,
    0x24f25144, 0x6c258925, 0xb55de186, 0xfd8a39e7, 0xb7ae30c3,
    0xff79e8a2, 0x26018001, 0x6ed65860, 0xfbad30c1, 0xb37ae8a0,
    0x6a028003, 0x22d55862, 0x68f15146, 0x20268927, 0xf95ee184,
    0xb18939e5, 0x6d16f3cc, 0x25c12bad, 0xfcb9430e, 0xb46e9b6f,
    0xfe4a924b, 0xb69d4a2a, 0x6fe52289, 0x2732fae8, 0x66d9b6d8,
    0x2e0e6eb9, 0xf776061a, 0xbfa1de7b, 0xf585d75f, 0xbd520f3e,
    0x642a679d, 0x2cfdbffc, 0xf06275d5, 0xb8b5adb4, 0x61cdc517,
    0x291a1d76, 0x633e1452, 0x2be9cc33, 0xf291a490, 0xba467cf1,
    0x71473cf0, 0x3990e491, 0xe0e88c32, 0xa83f5453, 0xe21b5d77,
    0xaacc8516, 0x73b4edb5, 0x3b6335d4, 0xe7fcfffd, 0xaf2b279c,
    0x76534f3f, 0x3e84975e, 0x74a09e7a, 0x3c77461b, 0xe50f2eb8,
    0xadd8f6d9, 0xec33bae9, 0xa4e46288, 0x7d9c0a2b, 0x354bd24a,
    0x7f6fdb6e, 0x37b8030f, 0xeec06bac, 0xa617b3cd, 0x7a8879e4,
    0x325fa185, 0xeb27c926, 0xa3f01147, 0xe9d41863, 0xa103c002,
    0x787ba8a1, 0x30ac70c0, 0x5e7a28a0, 0x16adf0c1, 0xcfd59862,
    0x87024003, 0xcd264927, 0x85f19146, 0x5c89f9e5, 0x145e2184,
    0xc8c1ebad, 0x801633cc, 0x596e5b6f, 0x11b9830e, 0x5b9d8a2a,
    0x134a524b, 0xca323ae8, 0x82e5e289, 0xc30eaeb9, 0x8bd976d8,
    0x52a11e7b, 0x1a76c61a, 0x5052cf3e, 0x1885175f, 0xc1fd7ffc,
    0x892aa79d, 0x55b56db4, 0x1d62b5d5, 0xc41add76, 0x8ccd0517,
    0xc6e90c33, 0x8e3ed452, 0x5746bcf1, 0x1f916490, 0xd4902491,
    0x9c47fcf0, 0x453f9453, 0x0de84c32, 0x47cc4516, 0x0f1b9d77,
    0xd663f5d4, 0x9eb42db5, 0x422be79c, 0x0afc3ffd, 0xd384575e,
    0x9b538f3f, 0xd177861b, 0x99a05e7a, 0x40d836d9, 0x080feeb8,
    0x49e4a288, 0x01337ae9, 0xd84b124a, 0x909cca2b, 0xdab8c30f,
    0x926f1b6e, 0x4b1773cd, 0x03c0abac, 0xdf5f6185, 0x9788b9e4,
    0x4ef0d147, 0x06270926, 0x4c030002, 0x04d4d863, 0xddacb0c0,
    0x957b68a1}};

static const word_t crc_braid_big_table[][256] = {
   {0x0000000000000000, 0x61d8d74800000000, 0xc2b0af9100000000,
    0xa36878d900000000, 0x87615c9300000000, 0xe6b98bdb00000000,
    0x45d1f30200000000, 0x2409244a00000000, 0x0dc3bb9600000000,
    0x6c1b6cde00000000, 0xcf73140700000000, 0xaeabc34f00000000,
    0x8aa2e70500000000, 0xeb7a304d00000000, 0x4812489400000000,
    0x29ca9fdc00000000, 0x1986749d00000000, 0x785ea3d500000000,
    0xdb36db0c00000000, 0xbaee0c4400000000, 0x9ee7280e00000000,
    0xff3fff4600000000, 0x5c57879f00000000, 0x3d8f50d700000000,
    0x1445cf0b00000000, 0x759d184300000000, 0xd6f5609a00000000,
    0xb72db7d200000000, 0x9324939800000000, 0xf2fc44d000000000,
    0x51943c0900000000, 0x304ceb4100000000, 0x310cea8a00000000,
    0x50d43dc200000000, 0xf3bc451b00000000, 0x9264925300000000,
    0xb66db61900000000, 0xd7b5615100000000, 0x74dd198800000000,
    0x1505cec000000000, 0x3ccf511c00000000, 0x5d17865400000000,
    0xfe7ffe8d00000000, 0x9fa729c500000000, 0xbbae0d8f00000000,
    0xda76dac700000000, 0x791ea21e00000000, 0x18c6755600000000,
    0x288a9e1700000000, 0x4952495f00000000, 0xea3a318600000000,
    0x8be2e6ce00000000, 0xafebc28400000000, 0xce3315cc00000000,
    0x6d5b6d1500000000, 0x0c83ba5d00000000, 0x2549258100000000,
    0x4491f2c900000000, 0xe7f98a1000000000, 0x86215d5800000000,
    0xa228791200000000, 0xc3f0ae5a00000000, 0x6098d68300000000,
    0x014001cb00000000, 0x6118d7a500000000, 0x00c000ed00000000,
    0xa3a8783400000000, 0xc270af7c00000000, 0xe6798b3600000000,
    0x87a15c7e00000000, 0x24c924a700000000, 0x4511f3ef00000000,
    0x6cdb6c3300000000, 0x0d03bb7b00000000, 0xae6bc3a200000000,
    0xcfb314ea00000000, 0xebba30a000000000, 0x8a62e7e800000000,
    0x290a9f3100000000, 0x48d2487900000000, 0x789ea33800000000,
    0x1946747000000000, 0xba2e0ca900000000, 0xdbf6dbe100000000,
    0xffffffab00000000, 0x9e2728e300000000, 0x3d4f503a00000000,
    0x5c97877200000000, 0x755d18ae00000000, 0x1485cfe600000000,
    0xb7edb73f00000000, 0xd635607700000000, 0xf23c443d00000000,
    0x93e4937500000000, 0x308cebac00000000, 0x51543ce400000000,
    0x50143d2f00000000, 0x31ccea6700000000, 0x92a492be00000000,
    0xf37c45f600000000, 0xd77561bc00000000, 0xb6adb6f400000000,
    0x15c5ce2d00000000, 0x741d196500000000, 0x5dd786b900000000,
    0x3c0f51f100000000, 0x9f67292800000000, 0xfebffe6000000000,
    0xdab6da2a00000000, 0xbb6e0d6200000000, 0x180675bb00000000,
    0x79dea2f300000000, 0x499249b200000000, 0x284a9efa00000000,
    0x8b22e62300000000, 0xeafa316b00000000, 0xcef3152100000000,
    0xaf2bc26900000000, 0x0c43bab000000000, 0x6d9b6df800000000,
    0x4451f22400000000, 0x2589256c00000000, 0x86e15db500000000,
    0xe7398afd00000000, 0xc330aeb700000000, 0xa2e879ff00000000,
    0x0180012600000000, 0x6058d66e00000000, 0xc130adfb00000000,
    0xa0e87ab300000000, 0x0380026a00000000, 0x6258d52200000000,
    0x4651f16800000000, 0x2789262000000000, 0x84e15ef900000000,
    0xe53989b100000000, 0xccf3166d00000000, 0xad2bc12500000000,
    0x0e43b9fc00000000, 0x6f9b6eb400000000, 0x4b924afe00000000,
    0x2a4a9db600000000, 0x8922e56f00000000, 0xe8fa322700000000,
    0xd8b6d96600000000, 0xb96e0e2e00000000, 0x1a0676f700000000,
    0x7bdea1bf00000000, 0x5fd785f500000000, 0x3e0f52bd00000000,
    0x9d672a6400000000, 0xfcbffd2c00000000, 0xd57562f000000000,
    0xb4adb5b800000000, 0x17c5cd6100000000, 0x761d1a2900000000,
    0x52143e6300000000, 0x33cce92b00000000, 0x90a491f200000000,
    0xf17c46ba00000000, 0xf03c477100000000, 0x91e4903900000000,
    0x328ce8e000000000, 0x53543fa800000000, 0x775d1be200000000,
    0x1685ccaa00000000, 0xb5edb47300000000, 0xd435633b00000000,
    0xfdfffce700000000, 0x9c272baf00000000, 0x3f4f537600000000,
    0x5e97843e00000000, 0x7a9ea07400000000, 0x1b46773c00000000,
    0xb82e0fe500000000, 0xd9f6d8ad00000000, 0xe9ba33ec00000000,
    0x8862e4a400000000, 0x2b0a9c7d00000000, 0x4ad24b3500000000,
    0x6edb6f7f00000000, 0x0f03b83700000000, 0xac6bc0ee00000000,
    0xcdb317a600000000, 0xe479887a00000000, 0x85a15f3200000000,
    0x26c927eb00000000, 0x4711f0a300000000, 0x6318d4e900000000,
    0x02c003a100000000, 0xa1a87b7800000000, 0xc070ac3000000000,
    0xa0287a5e00000000, 0xc1f0ad1600000000, 0x6298d5cf00000000,
    0x0340028700000000, 0x274926cd00000000, 0x4691f18500000000,
    0xe5f9895c00000000, 0x84215e1400000000, 0xadebc1c800000000,
    0xcc33168000000000, 0x6f5b6e5900000000, 0x0e83b91100000000,
    0x2a8a9d5b00000000, 0x4b524a1300000000, 0xe83a32ca00000000,
    0x89e2e58200000000, 0xb9ae0ec300000000, 0xd876d98b00000000,
    0x7b1ea15200000000, 0x1ac6761a00000000, 0x3ecf525000000000,
    0x5f17851800000000, 0xfc7ffdc100000000, 0x9da72a8900000000,
    0xb46db55500000000, 0xd5b5621d00000000, 0x76dd1ac400000000,
    0x1705cd8c00000000, 0x330ce9c600000000, 0x52d43e8e00000000,
    0xf1bc465700000000, 0x9064911f00000000, 0x912490d400000000,
    0xf0fc479c00000000, 0x53943f4500000000, 0x324ce80d00000000,
    0x1645cc4700000000, 0x779d1b0f00000000, 0xd4f563d600000000,
    0xb52db49e00000000, 0x9ce72b4200000000, 0xfd3ffc0a00000000,
    0x5e5784d300000000, 0x3f8f539b00000000, 0x1b8677d100000000,
    0x7a5ea09900000000, 0xd936d84000000000, 0xb8ee0f0800000000,
    0x88a2e44900000000, 0xe97a330100000000, 0x4a124bd800000000,
    0x2bca9c9000000000, 0x0fc3b8da00000000, 0x6e1b6f9200000000,
    0xcd73174b00000000, 0xacabc00300000000, 0x85615fdf00000000,
    0xe4b9889700000000, 0x47d1f04e00000000, 0x2609270600000000,
    0x0200034c00000000, 0x63d8d40400000000, 0xc0b0acdd00000000,
    0xa1687b9500000000},
   {0x0000000000000000, 0xd9b6d9a600000000, 0xb16db0fd00000000,
    0x68db695b00000000, 0x61db634b00000000, 0xb86dbaed00000000,
    0xd0b6d3b600000000, 0x09000a1000000000, 0xc2b6c79600000000,
    0x1b001e3000000000, 0x73db776b00000000, 0xaa6daecd00000000,
    0xa36da4dd00000000, 0x7adb7d7b00000000, 0x1200142000000000,
    0xcbb6cd8600000000, 0x876d8c9d00000000, 0x5edb553b00000000,
    0x36003c6000000000, 0xefb6e5c600000000, 0xe6b6efd600000000,
    0x3f00367000000000, 0x57db5f2b00000000, 0x8e6d868d00000000,
    0x45db4b0b00000000, 0x9c6d92ad00000000, 0xf4b6fbf600000000,
    0x2d00225000000000, 0x2400284000000000, 0xfdb6f1e600000000,
    0x956d98bd00000000, 0x4cdb411b00000000, 0x0ddb1b8b00000000,
    0xd46dc22d00000000, 0xbcb6ab7600000000, 0x650072d000000000,
    0x6c0078c000000000, 0xb5b6a16600000000, 0xdd6dc83d00000000,
    0x04db119b00000000, 0xcf6ddc1d00000000, 0x16db05bb00000000,
    0x7e006ce000000000, 0xa7b6b54600000000, 0xaeb6bf5600000000,
    0x770066f000000000, 0x1fdb0fab00000000, 0xc66dd60d00000000,
    0x8ab6971600000000, 0x53004eb000000000, 0x3bdb27eb00000000,
    0xe26dfe4d00000000, 0xeb6df45d00000000, 0x32db2dfb00000000,
    0x5a0044a000000000, 0x83b69d0600000000, 0x4800508000000000,
    0x91b6892600000000, 0xf96de07d00000000, 0x20db39db00000000,
    0x29db33cb00000000, 0xf06dea6d00000000, 0x98b6833600000000,
    0x41005a9000000000, 0x19b634a600000000, 0xc000ed0000000000,
    0xa8db845b00000000, 0x716d5dfd00000000, 0x786d57ed00000000,
    0xa1db8e4b00000000, 0xc900e71000000000, 0x10b63eb600000000,
    0xdb00f33000000000, 0x02b62a9600000000, 0x6a6d43cd00000000,
    0xb3db9a6b00000000, 0xbadb907b00000000, 0x636d49dd00000000,
    0x0bb6208600000000, 0xd200f92000000000, 0x9edbb83b00000000,
    0x476d619d00000000, 0x2fb608c600000000, 0xf600d16000000000,
    0xff00db7000000000, 0x26b602d600000000, 0x4e6d6b8d00000000,
    0x97dbb22b00000000, 0x5c6d7fad00000000, 0x85dba60b00000000,
    0xed00cf5000000000, 0x34b616f600000000, 0x3db61ce600000000,
    0xe400c54000000000, 0x8cdbac1b00000000, 0x556d75bd00000000,
    0x146d2f2d00000000, 0xcddbf68b00000000, 0xa5009fd000000000,
    0x7cb6467600000000, 0x75b64c6600000000, 0xac0095c000000000,
    0xc4dbfc9b00000000, 0x1d6d253d00000000, 0xd6dbe8bb00000000,
    0x0f6d311d00000000, 0x67b6584600000000, 0xbe0081e000000000,
    0xb7008bf000000000, 0x6eb6525600000000, 0x066d3b0d00000000,
    0xdfdbe2ab00000000, 0x9300a3b000000000, 0x4ab67a1600000000,
    0x226d134d00000000, 0xfbdbcaeb00000000, 0xf2dbc0fb00000000,
    0x2b6d195d00000000, 0x43b6700600000000, 0x9a00a9a000000000,
    0x51b6642600000000, 0x8800bd8000000000, 0xe0dbd4db00000000,
    0x396d0d7d00000000, 0x306d076d00000000, 0xe9dbdecb00000000,
    0x8100b79000000000, 0x58b66e3600000000, 0x316c6afc00000000,
    0xe8dab35a00000000, 0x8001da0100000000, 0x59b703a700000000,
    0x50b709b700000000, 0x8901d01100000000, 0xe1dab94a00000000,
    0x386c60ec00000000, 0xf3daad6a00000000, 0x2a6c74cc00000000,
    0x42b71d9700000000, 0x9b01c43100000000, 0x9201ce2100000000,
    0x4bb7178700000000, 0x236c7edc00000000, 0xfadaa77a00000000,
    0xb601e66100000000, 0x6fb73fc700000000, 0x076c569c00000000,
    0xdeda8f3a00000000, 0xd7da852a00000000, 0x0e6c5c8c00000000,
    0x66b735d700000000, 0xbf01ec7100000000, 0x74b721f700000000,
    0xad01f85100000000, 0xc5da910a00000000, 0x1c6c48ac00000000,
    0x156c42bc00000000, 0xccda9b1a00000000, 0xa401f24100000000,
    0x7db72be700000000, 0x3cb7717700000000, 0xe501a8d100000000,
    0x8ddac18a00000000, 0x546c182c00000000, 0x5d6c123c00000000,
    0x84dacb9a00000000, 0xec01a2c100000000, 0x35b77b6700000000,
    0xfe01b6e100000000, 0x27b76f4700000000, 0x4f6c061c00000000,
    0x96dadfba00000000, 0x9fdad5aa00000000, 0x466c0c0c00000000,
    0x2eb7655700000000, 0xf701bcf100000000, 0xbbdafdea00000000,
    0x626c244c00000000, 0x0ab74d1700000000, 0xd30194b100000000,
    0xda019ea100000000, 0x03b7470700000000, 0x6b6c2e5c00000000,
    0xb2daf7fa00000000, 0x796c3a7c00000000, 0xa0dae3da00000000,
    0xc8018a8100000000, 0x11b7532700000000, 0x18b7593700000000,
    0xc101809100000000, 0xa9dae9ca00000000, 0x706c306c00000000,
    0x28da5e5a00000000, 0xf16c87fc00000000, 0x99b7eea700000000,
    0x4001370100000000, 0x49013d1100000000, 0x90b7e4b700000000,
    0xf86c8dec00000000, 0x21da544a00000000, 0xea6c99cc00000000,
    0x33da406a00000000, 0x5b01293100000000, 0x82b7f09700000000,
    0x8bb7fa8700000000, 0x5201232100000000, 0x3ada4a7a00000000,
    0xe36c93dc00000000, 0xafb7d2c700000000, 0x76010b6100000000,
    0x1eda623a00000000, 0xc76cbb9c00000000, 0xce6cb18c00000000,
    0x17da682a00000000, 0x7f01017100000000, 0xa6b7d8d700000000,
    0x6d01155100000000, 0xb4b7ccf700000000, 0xdc6ca5ac00000000,
    0x05da7c0a00000000, 0x0cda761a00000000, 0xd56cafbc00000000,
    0xbdb7c6e700000000, 0x64011f4100000000, 0x250145d100000000,
    0xfcb79c7700000000, 0x946cf52c00000000, 0x4dda2c8a00000000,
    0x44da269a00000000, 0x9d6cff3c00000000, 0xf5b7966700000000,
    0x2c014fc100000000, 0xe7b7824700000000, 0x3e015be100000000,
    0x56da32ba00000000, 0x8f6ceb1c00000000, 0x866ce10c00000000,
    0x5fda38aa00000000, 0x370151f100000000, 0xeeb7885700000000,
    0xa26cc94c00000000, 0x7bda10ea00000000, 0x130179b100000000,
    0xcab7a01700000000, 0xc3b7aa0700000000, 0x1a0173a100000000,
    0x72da1afa00000000, 0xab6cc35c00000000, 0x60da0eda00000000,
    0xb96cd77c00000000, 0xd1b7be2700000000, 0x0801678100000000,
    0x01016d9100000000, 0xd8b7b43700000000, 0xb06cdd6c00000000,
    0x69da04ca00000000},
   {0x0000000000000000, 0xb700b7f100000000, 0x6d016d5300000000,
    0xda01daa200000000, 0xda02daa600000000, 0x6d026d5700000000,
    0xb703b7f500000000, 0x0003000400000000, 0xb705b7fd00000000,
    0x0005000c00000000, 0xda04daae00000000, 0x6d046d5f00000000,
    0x6d076d5b00000000, 0xda07daaa00000000, 0x0006000800000000,
    0xb706b7f900000000, 0x6d0b6d4b00000000, 0xda0bdaba00000000,
    0x000a001800000000, 0xb70ab7e900000000, 0xb709b7ed00000000,
    0x0009001c00000000, 0xda08dabe00000000, 0x6d086d4f00000000,
    0xda0edab600000000, 0x6d0e6d4700000000, 0xb70fb7e500000000,
    0x000f001400000000, 0x000c001000000000, 0xb70cb7e100000000,
    0x6d0d6d4300000000, 0xda0ddab200000000, 0xda16da9600000000,
    0x6d166d6700000000, 0xb717b7c500000000, 0x0017003400000000,
    0x0014003000000000, 0xb714b7c100000000, 0x6d156d6300000000,
    0xda15da9200000000, 0x6d136d6b00000000, 0xda13da9a00000000,
    0x0012003800000000, 0xb712b7c900000000, 0xb711b7cd00000000,
    0x0011003c00000000, 0xda10da9e00000000, 0x6d106d6f00000000,
    0xb71db7dd00000000, 0x001d002c00000000, 0xda1cda8e00000000,
    0x6d1c6d7f00000000, 0x6d1f6d7b00000000, 0xda1fda8a00000000,
    0x001e002800000000, 0xb71eb7d900000000, 0x0018002000000000,
    0xb718b7d100000000, 0x6d196d7300000000, 0xda19da8200000000,
    0xda1ada8600000000, 0x6d1a6d7700000000, 0xb71bb7d500000000,
    0x001b002400000000, 0xb72db79d00000000, 0x002d006c00000000,
    0xda2cdace00000000, 0x6d2c6d3f00000000, 0x6d2f6d3b00000000,
    0xda2fdaca00000000, 0x002e006800000000, 0xb72eb79900000000,
    0x0028006000000000, 0xb728b79100000000, 0x6d296d3300000000,
    0xda29dac200000000, 0xda2adac600000000, 0x6d2a6d3700000000,
    0xb72bb79500000000, 0x002b006400000000, 0xda26dad600000000,
    0x6d266d2700000000, 0xb727b78500000000, 0x0027007400000000,
    0x0024007000000000, 0xb724b78100000000, 0x6d256d2300000000,
    0xda25dad200000000, 0x6d236d2b00000000, 0xda23dada00000000,
    0x0022007800000000, 0xb722b78900000000, 0xb721b78d00000000,
    0x0021007c00000000, 0xda20dade00000000, 0x6d206d2f00000000,
    0x6d3b6d0b00000000, 0xda3bdafa00000000, 0x003a005800000000,
    0xb73ab7a900000000, 0xb739b7ad00000000, 0x0039005c00000000,
    0xda38dafe00000000, 0x6d386d0f00000000, 0xda3edaf600000000,
    0x6d3e6d0700000000, 0xb73fb7a500000000, 0x003f005400000000,
    0x003c005000000000, 0xb73cb7a100000000, 0x6d3d6d0300000000,
    0xda3ddaf200000000, 0x0030004000000000, 0xb730b7b100000000,
    0x6d316d1300000000, 0xda31dae200000000, 0xda32dae600000000,
    0x6d326d1700000000, 0xb733b7b500000000, 0x0033004400000000,
    0xb735b7bd00000000, 0x0035004c00000000, 0xda34daee00000000,
    0x6d346d1f00000000, 0x6d376d1b00000000, 0xda37daea00000000,
    0x0036004800000000, 0xb736b7b900000000, 0x6d5b6d8b00000000,
    0xda5bda7a00000000, 0x005a00d800000000, 0xb75ab72900000000,
    0xb759b72d00000000, 0x005900dc00000000, 0xda58da7e00000000,
    0x6d586d8f00000000, 0xda5eda7600000000, 0x6d5e6d8700000000,
    0xb75fb72500000000, 0x005f00d400000000, 0x005c00d000000000,
    0xb75cb72100000000, 0x6d5d6d8300000000, 0xda5dda7200000000,
    0x005000c000000000, 0xb750b73100000000, 0x6d516d9300000000,
    0xda51da6200000000, 0xda52da6600000000, 0x6d526d9700000000,
    0xb753b73500000000, 0x005300c400000000, 0xb755b73d00000000,
    0x005500cc00000000, 0xda54da6e00000000, 0x6d546d9f00000000,
    0x6d576d9b00000000, 0xda57da6a00000000, 0x005600c800000000,
    0xb756b73900000000, 0xb74db71d00000000, 0x004d00ec00000000,
    0xda4cda4e00000000, 0x6d4c6dbf00000000, 0x6d4f6dbb00000000,
    0xda4fda4a00000000, 0x004e00e800000000, 0xb74eb71900000000,
    0x004800e000000000, 0xb748b71100000000, 0x6d496db300000000,
    0xda49da4200000000, 0xda4ada4600000000, 0x6d4a6db700000000,
    0xb74bb71500000000, 0x004b00e400000000, 0xda46da5600000000,
    0x6d466da700000000, 0xb747b70500000000, 0x004700f400000000,
    0x004400f000000000, 0xb744b70100000000, 0x6d456da300000000,
    0xda45da5200000000, 0x6d436dab00000000, 0xda43da5a00000000,
    0x004200f800000000, 0xb742b70900000000, 0xb741b70d00000000,
    0x004100fc00000000, 0xda40da5e00000000, 0x6d406daf00000000,
    0xda76da1600000000, 0x6d766de700000000, 0xb777b74500000000,
    0x007700b400000000, 0x007400b000000000, 0xb774b74100000000,
    0x6d756de300000000, 0xda75da1200000000, 0x6d736deb00000000,
    0xda73da1a00000000, 0x007200b800000000, 0xb772b74900000000,
    0xb771b74d00000000, 0x007100bc00000000, 0xda70da1e00000000,
    0x6d706def00000000, 0xb77db75d00000000, 0x007d00ac00000000,
    0xda7cda0e00000000, 0x6d7c6dff00000000, 0x6d7f6dfb00000000,
    0xda7fda0a00000000, 0x007e00a800000000, 0xb77eb75900000000,
    0x007800a000000000, 0xb778b75100000000, 0x6d796df300000000,
    0xda79da0200000000, 0xda7ada0600000000, 0x6d7a6df700000000,
    0xb77bb75500000000, 0x007b00a400000000, 0x0060008000000000,
    0xb760b77100000000, 0x6d616dd300000000, 0xda61da2200000000,
    0xda62da2600000000, 0x6d626dd700000000, 0xb763b77500000000,
    0x0063008400000000, 0xb765b77d00000000, 0x0065008c00000000,
    0xda64da2e00000000, 0x6d646ddf00000000, 0x6d676ddb00000000,
    0xda67da2a00000000, 0x0066008800000000, 0xb766b77900000000,
    0x6d6b6dcb00000000, 0xda6bda3a00000000, 0x006a009800000000,
    0xb76ab76900000000, 0xb769b76d00000000, 0x0069009c00000000,
    0xda68da3e00000000, 0x6d686dcf00000000, 0xda6eda3600000000,
    0x6d6e6dc700000000, 0xb76fb76500000000, 0x006f009400000000,
    0x006c009000000000, 0xb76cb76100000000, 0x6d6d6dc300000000,
    0xda6dda3200000000},
   {0x0000000000000000, 0x0000015000000000, 0x000002a000000000,
    0x000003f000000000, 0x030007f000000000, 0x030006a000000000,
    0x0300055000000000, 0x0300040000000000, 0x05000d5000000000,
    0x05000c0000000000, 0x05000ff000000000, 0x05000ea000000000,
    0x06000aa000000000, 0x06000bf000000000, 0x0600080000000000,
    0x0600095000000000, 0x0a001aa000000000, 0x0a001bf000000000,
    0x0a00180000000000, 0x0a00195000000000, 0x09001d5000000000,
    0x09001c0000000000, 0x09001ff000000000, 0x09001ea000000000,
    0x0f0017f000000000, 0x0f0016a000000000, 0x0f00155000000000,
    0x0f00140000000000, 0x0c00100000000000, 0x0c00115000000000,
    0x0c0012a000000000, 0x0c0013f000000000, 0x170037f000000000,
    0x170036a000000000, 0x1700355000000000, 0x1700340000000000,
    0x1400300000000000, 0x1400315000000000, 0x140032a000000000,
    0x140033f000000000, 0x12003aa000000000, 0x12003bf000000000,
    0x1200380000000000, 0x1200395000000000, 0x11003d5000000000,
    0x11003c0000000000, 0x11003ff000000000, 0x11003ea000000000,
    0x1d002d5000000000, 0x1d002c0000000000, 0x1d002ff000000000,
    0x1d002ea000000000, 0x1e002aa000000000, 0x1e002bf000000000,
    0x1e00280000000000, 0x1e00295000000000, 0x1800200000000000,
    0x1800215000000000, 0x180022a000000000, 0x180023f000000000,
    0x1b0027f000000000, 0x1b0026a000000000, 0x1b00255000000000,
    0x1b00240000000000, 0x2d006d5000000000, 0x2d006c0000000000,
    0x2d006ff000000000, 0x2d006ea000000000, 0x2e006aa000000000,
    0x2e006bf000000000, 0x2e00680000000000, 0x2e00695000000000,
    0x2800600000000000, 0x2800615000000000, 0x280062a000000000,
    0x280063f000000000, 0x2b0067f000000000, 0x2b0066a000000000,
    0x2b00655000000000, 0x2b00640000000000, 0x270077f000000000,
    0x270076a000000000, 0x2700755000000000, 0x2700740000000000,
    0x2400700000000000, 0x2400715000000000, 0x240072a000000000,
    0x240073f000000000, 0x22007aa000000000, 0x22007bf000000000,
    0x2200780000000000, 0x2200795000000000, 0x21007d5000000000,
    0x21007c0000000000, 0x21007ff000000000, 0x21007ea000000000,
    0x3a005aa000000000, 0x3a005bf000000000, 0x3a00580000000000,
    0x3a00595000000000, 0x39005d5000000000, 0x39005c0000000000,
    0x39005ff000000000, 0x39005ea000000000, 0x3f0057f000000000,
    0x3f0056a000000000, 0x3f00555000000000, 0x3f00540000000000,
    0x3c00500000000000, 0x3c00515000000000, 0x3c0052a000000000,
    0x3c0053f000000000, 0x3000400000000000, 0x3000415000000000,
    0x300042a000000000, 0x300043f000000000, 0x330047f000000000,
    0x330046a000000000, 0x3300455000000000, 0x3300440000000000,
    0x35004d5000000000, 0x35004c0000000000, 0x35004ff000000000,
    0x35004ea000000000, 0x36004aa000000000, 0x36004bf000000000,
    0x3600480000000000, 0x3600495000000000, 0x5a00daa000000000,
    0x5a00dbf000000000, 0x5a00d80000000000, 0x5a00d95000000000,
    0x5900dd5000000000, 0x5900dc0000000000, 0x5900dff000000000,
    0x5900dea000000000, 0x5f00d7f000000000, 0x5f00d6a000000000,
    0x5f00d55000000000, 0x5f00d40000000000, 0x5c00d00000000000,
    0x5c00d15000000000, 0x5c00d2a000000000, 0x5c00d3f000000000,
    0x5000c00000000000, 0x5000c15000000000, 0x5000c2a000000000,
    0x5000c3f000000000, 0x5300c7f000000000, 0x5300c6a000000000,
    0x5300c55000000000, 0x5300c40000000000, 0x5500cd5000000000,
    0x5500cc0000000000, 0x5500cff000000000, 0x5500cea000000000,
    0x5600caa000000000, 0x5600cbf000000000, 0x5600c80000000000,
    0x5600c95000000000, 0x4d00ed5000000000, 0x4d00ec0000000000,
    0x4d00eff000000000, 0x4d00eea000000000, 0x4e00eaa000000000,
    0x4e00ebf000000000, 0x4e00e80000000000, 0x4e00e95000000000,
    0x4800e00000000000, 0x4800e15000000000, 0x4800e2a000000000,
    0x4800e3f000000000, 0x4b00e7f000000000, 0x4b00e6a000000000,
    0x4b00e55000000000, 0x4b00e40000000000, 0x4700f7f000000000,
    0x4700f6a000000000, 0x4700f55000000000, 0x4700f40000000000,
    0x4400f00000000000, 0x4400f15000000000, 0x4400f2a000000000,
    0x4400f3f000000000, 0x4200faa000000000, 0x4200fbf000000000,
    0x4200f80000000000, 0x4200f95000000000, 0x4100fd5000000000,
    0x4100fc0000000000, 0x4100fff000000000, 0x4100fea000000000,
    0x7700b7f000000000, 0x7700b6a000000000, 0x7700b55000000000,
    0x7700b40000000000, 0x7400b00000000000, 0x7400b15000000000,
    0x7400b2a000000000, 0x7400b3f000000000, 0x7200baa000000000,
    0x7200bbf000000000, 0x7200b80000000000, 0x7200b95000000000,
    0x7100bd5000000000, 0x7100bc0000000000, 0x7100bff000000000,
    0x7100bea000000000, 0x7d00ad5000000000, 0x7d00ac0000000000,
    0x7d00aff000000000, 0x7d00aea000000000, 0x7e00aaa000000000,
    0x7e00abf000000000, 0x7e00a80000000000, 0x7e00a95000000000,
    0x7800a00000000000, 0x7800a15000000000, 0x7800a2a000000000,
    0x7800a3f000000000, 0x7b00a7f000000000, 0x7b00a6a000000000,
    0x7b00a55000000000, 0x7b00a40000000000, 0x6000800000000000,
    0x6000815000000000, 0x600082a000000000, 0x600083f000000000,
    0x630087f000000000, 0x630086a000000000, 0x6300855000000000,
    0x6300840000000000, 0x65008d5000000000, 0x65008c0000000000,
    0x65008ff000000000, 0x65008ea000000000, 0x66008aa000000000,
    0x66008bf000000000, 0x6600880000000000, 0x6600895000000000,
    0x6a009aa000000000, 0x6a009bf000000000, 0x6a00980000000000,
    0x6a00995000000000, 0x69009d5000000000, 0x69009c0000000000,
    0x69009ff000000000, 0x69009ea000000000, 0x6f0097f000000000,
    0x6f0096a000000000, 0x6f00955000000000, 0x6f00940000000000,
    0x6c00900000000000, 0x6c00915000000000, 0x6c0092a000000000,
    0x6c0093f000000000},
   {0x0000000000000000, 0x0001500000000000, 0x0002a00000000000,
    0x0003f00000000000, 0x0004400100000000, 0x0005100100000000,
    0x0006e00100000000, 0x0007b00100000000, 0x0008800200000000,
    0x0009d00200000000, 0x000a200200000000, 0x000b700200000000,
    0x000cc00300000000, 0x000d900300000000, 0x000e600300000000,
    0x000f300300000000, 0x0010000500000000, 0x0011500500000000,
    0x0012a00500000000, 0x0013f00500000000, 0x0014400400000000,
    0x0015100400000000, 0x0016e00400000000, 0x0017b00400000000,
    0x0018800700000000, 0x0019d00700000000, 0x001a200700000000,
    0x001b700700000000, 0x001cc00600000000, 0x001d900600000000,
    0x001e600600000000, 0x001f300600000000, 0x0020000a00000000,
    0x0021500a00000000, 0x0022a00a00000000, 0x0023f00a00000000,
    0x0024400b00000000, 0x0025100b00000000, 0x0026e00b00000000,
    0x0027b00b00000000, 0x0028800800000000, 0x0029d00800000000,
    0x002a200800000000, 0x002b700800000000, 0x002cc00900000000,
    0x002d900900000000, 0x002e600900000000, 0x002f300900000000,
    0x0030000f00000000, 0x0031500f00000000, 0x0032a00f00000000,
    0x0033f00f00000000, 0x0034400e00000000, 0x0035100e00000000,
    0x0036e00e00000000, 0x0037b00e00000000, 0x0038800d00000000,
    0x0039d00d00000000, 0x003a200d00000000, 0x003b700d00000000,
    0x003cc00c00000000, 0x003d900c00000000, 0x003e600c00000000,
    0x003f300c00000000, 0x0040001400000000, 0x0041501400000000,
    0x0042a01400000000, 0x0043f01400000000, 0x0044401500000000,
    0x0045101500000000, 0x0046e01500000000, 0x0047b01500000000,
    0x0048801600000000, 0x0049d01600000000, 0x004a201600000000,
    0x004b701600000000, 0x004cc01700000000, 0x004d901700000000,
    0x004e601700000000, 0x004f301700000000, 0x0050001100000000,
    0x0051501100000000, 0x0052a01100000000, 0x0053f01100000000,
    0x0054401000000000, 0x0055101000000000, 0x0056e01000000000,
    0x0057b01000000000, 0x0058801300000000, 0x0059d01300000000,
    0x005a201300000000, 0x005b701300000000, 0x005cc01200000000,
    0x005d901200000000, 0x005e601200000000, 0x005f301200000000,
    0x0060001e00000000, 0x0061501e00000000, 0x0062a01e00000000,
    0x0063f01e00000000, 0x0064401f00000000, 0x0065101f00000000,
    0x0066e01f00000000, 0x0067b01f00000000, 0x0068801c00000000,
    0x0069d01c00000000, 0x006a201c00000000, 0x006b701c00000000,
    0x006cc01d00000000, 0x006d901d00000000, 0x006e601d00000000,
    0x006f301d00000000, 0x0070001b00000000, 0x0071501b00000000,
    0x0072a01b00000000, 0x0073f01b00000000, 0x0074401a00000000,
    0x0075101a00000000, 0x0076e01a00000000, 0x0077b01a00000000,
    0x0078801900000000, 0x0079d01900000000, 0x007a201900000000,
    0x007b701900000000, 0x007cc01800000000, 0x007d901800000000,
    0x007e601800000000, 0x007f301800000000, 0x0080002800000000,
    0x0081502800000000, 0x0082a02800000000, 0x0083f02800000000,
    0x0084402900000000, 0x0085102900000000, 0x0086e02900000000,
    0x0087b02900000000, 0x0088802a00000000, 0x0089d02a00000000,
    0x008a202a00000000, 0x008b702a00000000, 0x008cc02b00000000,
    0x008d902b00000000, 0x008e602b00000000, 0x008f302b00000000,
    0x0090002d00000000, 0x0091502d00000000, 0x0092a02d00000000,
    0x0093f02d00000000, 0x0094402c00000000, 0x0095102c00000000,
    0x0096e02c00000000, 0x0097b02c00000000, 0x0098802f00000000,
    0x0099d02f00000000, 0x009a202f00000000, 0x009b702f00000000,
    0x009cc02e00000000, 0x009d902e00000000, 0x009e602e00000000,
    0x009f302e00000000, 0x00a0002200000000, 0x00a1502200000000,
    0x00a2a02200000000, 0x00a3f02200000000, 0x00a4402300000000,
    0x00a5102300000000, 0x00a6e02300000000, 0x00a7b02300000000,
    0x00a8802000000000, 0x00a9d02000000000, 0x00aa202000000000,
    0x00ab702000000000, 0x00acc02100000000, 0x00ad902100000000,
    0x00ae602100000000, 0x00af302100000000, 0x00b0002700000000,
    0x00b1502700000000, 0x00b2a02700000000, 0x00b3f02700000000,
    0x00b4402600000000, 0x00b5102600000000, 0x00b6e02600000000,
    0x00b7b02600000000, 0x00b8802500000000, 0x00b9d02500000000,
    0x00ba202500000000, 0x00bb702500000000, 0x00bcc02400000000,
    0x00bd902400000000, 0x00be602400000000, 0x00bf302400000000,
    0x00c0003c00000000, 0x00c1503c00000000, 0x00c2a03c00000000,
    0x00c3f03c00000000, 0x00c4403d00000000, 0x00c5103d00000000,
    0x00c6e03d00000000, 0x00c7b03d00000000, 0x00c8803e00000000,
    0x00c9d03e00000000, 0x00ca203e00000000, 0x00cb703e00000000,
    0x00ccc03f00000000, 0x00cd903f00000000, 0x00ce603f00000000,
    0x00cf303f00000000, 0x00d0003900000000, 0x00d1503900000000,
    0x00d2a03900000000, 0x00d3f03900000000, 0x00d4403800000000,
    0x00d5103800000000, 0x00d6e03800000000, 0x00d7b03800000000,
    0x00d8803b00000000, 0x00d9d03b00000000, 0x00da203b00000000,
    0x00db703b00000000, 0x00dcc03a00000000, 0x00dd903a00000000,
    0x00de603a00000000, 0x00df303a00000000, 0x00e0003600000000,
    0x00e1503600000000, 0x00e2a03600000000, 0x00e3f03600000000,
    0x00e4403700000000, 0x00e5103700000000, 0x00e6e03700000000,
    0x00e7b03700000000, 0x00e8803400000000, 0x00e9d03400000000,
    0x00ea203400000000, 0x00eb703400000000, 0x00ecc03500000000,
    0x00ed903500000000, 0x00ee603500000000, 0x00ef303500000000,
    0x00f0003300000000, 0x00f1503300000000, 0x00f2a03300000000,
    0x00f3f03300000000, 0x00f4403200000000, 0x00f5103200000000,
    0x00f6e03200000000, 0x00f7b03200000000, 0x00f8803100000000,
    0x00f9d03100000000, 0x00fa203100000000, 0x00fb703100000000,
    0x00fcc03000000000, 0x00fd903000000000, 0x00fe603000000000,
    0x00ff303000000000},
   {0x0000000000000000, 0x0150000000000000, 0x02a0000000000000,
    0x03f0000000000000, 0x0440010000000000, 0x0510010000000000,
    0x06e0010000000000, 0x07b0010000000000, 0x0880020000000000,
    0x09d0020000000000, 0x0a20020000000000, 0x0b70020000000000,
    0x0cc0030000000000, 0x0d90030000000000, 0x0e60030000000000,
    0x0f30030000000000, 0x1000050000000000, 0x1150050000000000,
    0x12a0050000000000, 0x13f0050000000000, 0x1440040000000000,
    0x1510040000000000, 0x16e0040000000000, 0x17b0040000000000,
    0x1880070000000000, 0x19d0070000000000, 0x1a20070000000000,
    0x1b70070000000000, 0x1cc0060000000000, 0x1d90060000000000,
    0x1e60060000000000, 0x1f30060000000000, 0x20000a0000000000,
    0x21500a0000000000, 0x22a00a0000000000, 0x23f00a0000000000,
    0x24400b0000000000, 0x25100b0000000000, 0x26e00b0000000000,
    0x27b00b0000000000, 0x2880080000000000, 0x29d0080000000000,
    0x2a20080000000000, 0x2b70080000000000, 0x2cc0090000000000,
    0x2d90090000000000, 0x2e60090000000000, 0x2f30090000000000,
    0x30000f0000000000, 0x31500f0000000000, 0x32a00f0000000000,
    0x33f00f0000000000, 0x34400e0000000000, 0x35100e0000000000,
    0x36e00e0000000000, 0x37b00e0000000000, 0x38800d0000000000,
    0x39d00d0000000000, 0x3a200d0000000000, 0x3b700d0000000000,
    0x3cc00c0000000000, 0x3d900c0000000000, 0x3e600c0000000000,
    0x3f300c0000000000, 0x4000140000000000, 0x4150140000000000,
    0x42a0140000000000, 0x43f0140000000000, 0x4440150000000000,
    0x4510150000000000, 0x46e0150000000000, 0x47b0150000000000,
    0x4880160000000000, 0x49d0160000000000, 0x4a20160000000000,
    0x4b70160000000000, 0x4cc0170000000000, 0x4d90170000000000,
    0x4e60170000000000, 0x4f30170000000000, 0x5000110000000000,
    0x5150110000000000, 0x52a0110000000000, 0x53f0110000000000,
    0x5440100000000000, 0x5510100000000000, 0x56e0100000000000,
    0x57b0100000000000, 0x5880130000000000, 0x59d0130000000000,
    0x5a20130000000000, 0x5b70130000000000, 0x5cc0120000000000,
    0x5d90120000000000, 0x5e60120000000000, 0x5f30120000000000,
    0x60001e0000000000, 0x61501e0000000000, 0x62a01e0000000000,
    0x63f01e0000000000, 0x64401f0000000000, 0x65101f0000000000,
    0x66e01f0000000000, 0x67b01f0000000000, 0x68801c0000000000,
    0x69d01c0000000000, 0x6a201c0000000000, 0x6b701c0000000000,
    0x6cc01d0000000000, 0x6d901d0000000000, 0x6e601d0000000000,
    0x6f301d0000000000, 0x70001b0000000000, 0x71501b0000000000,
    0x72a01b0000000000, 0x73f01b0000000000, 0x74401a0000000000,
    0x75101a0000000000, 0x76e01a0000000000, 0x77b01a0000000000,
    0x7880190000000000, 0x79d0190000000000, 0x7a20190000000000,
    0x7b70190000000000, 0x7cc0180000000000, 0x7d90180000000000,
    0x7e60180000000000, 0x7f30180000000000, 0x8000280000000000,
    0x8150280000000000, 0x82a0280000000000, 0x83f0280000000000,
    0x8440290000000000, 0x8510290000000000, 0x86e0290000000000,
    0x87b0290000000000, 0x88802a0000000000, 0x89d02a0000000000,
    0x8a202a0000000000, 0x8b702a0000000000, 0x8cc02b0000000000,
    0x8d902b0000000000, 0x8e602b0000000000, 0x8f302b0000000000,
    0x90002d0000000000, 0x91502d0000000000, 0x92a02d0000000000,
    0x93f02d0000000000, 0x94402c0000000000, 0x95102c0000000000,
    0x96e02c0000000000, 0x97b02c0000000000, 0x98802f0000000000,
    0x99d02f0000000000, 0x9a202f0000000000, 0x9b702f0000000000,
    0x9cc02e0000000000, 0x9d902e0000000000, 0x9e602e0000000000,
    0x9f302e0000000000, 0xa000220000000000, 0xa150220000000000,
    0xa2a0220000000000, 0xa3f0220000000000, 0xa440230000000000,
    0xa510230000000000, 0xa6e0230000000000, 0xa7b0230000000000,
    0xa880200000000000, 0xa9d0200000000000, 0xaa20200000000000,
    0xab70200000000000, 0xacc0210000000000, 0xad90210000000000,
    0xae60210000000000, 0xaf30210000000000, 0xb000270000000000,
    0xb150270000000000, 0xb2a0270000000000, 0xb3f0270000000000,
    0xb440260000000000, 0xb510260000000000, 0xb6e0260000000000,
    0xb7b0260000000000, 0xb880250000000000, 0xb9d0250000000000,
    0xba20250000000000, 0xbb70250000000000, 0xbcc0240000000000,
    0xbd90240000000000, 0xbe60240000000000, 0xbf30240000000000,
    0xc0003c0000000000, 0xc1503c0000000000, 0xc2a03c0000000000,
    0xc3f03c0000000000, 0xc4403d0000000000, 0xc5103d0000000000,
    0xc6e03d0000000000, 0xc7b03d0000000000, 0xc8803e0000000000,
    0xc9d03e0000000000, 0xca203e0000000000, 0xcb703e0000000000,
    0xccc03f0000000000, 0xcd903f0000000000, 0xce603f0000000000,
    0xcf303f0000000000, 0xd000390000000000, 0xd150390000000000,
    0xd2a0390000000000, 0xd3f0390000000000, 0xd440380000000000,
    0xd510380000000000, 0xd6e0380000000000, 0xd7b0380000000000,
    0xd8803b0000000000, 0xd9d03b0000000000, 0xda203b0000000000,
    0xdb703b0000000000, 0xdcc03a0000000000, 0xdd903a0000000000,
    0xde603a0000000000, 0xdf303a0000000000, 0xe000360000000000,
    0xe150360000000000, 0xe2a0360000000000, 0xe3f0360000000000,
    0xe440370000000000, 0xe510370000000000, 0xe6e0370000000000,
    0xe7b0370000000000, 0xe880340000000000, 0xe9d0340000000000,
    0xea20340000000000, 0xeb70340000000000, 0xecc0350000000000,
    0xed90350000000000, 0xee60350000000000, 0xef30350000000000,
    0xf000330000000000, 0xf150330000000000, 0xf2a0330000000000,
    0xf3f0330000000000, 0xf440320000000000, 0xf510320000000000,
    0xf6e0320000000000, 0xf7b0320000000000, 0xf880310000000000,
    0xf9d0310000000000, 0xfa20310000000000, 0xfb70310000000000,
    0xfcc0300000000000, 0xfd90300000000000, 0xfe60300000000000,
    0xff30300000000000},
   {0x0000000000000000, 0x5101919000000000, 0xa102219100000000,
    0xf003b00100000000, 0x4105419200000000, 0x1004d00200000000,
    0xe007600300000000, 0xb106f19300000000, 0x810a819400000000,
    0xd00b100400000000, 0x2008a00500000000, 0x7109319500000000,
    0xc00fc00600000000, 0x910e519600000000, 0x610de19700000000,
    0x300c700700000000, 0x0115019900000000, 0x5014900900000000,
    0xa017200800000000, 0xf116b19800000000, 0x4010400b00000000,
    0x1111d19b00000000, 0xe112619a00000000, 0xb013f00a00000000,
    0x801f800d00000000, 0xd11e119d00000000, 0x211da19c00000000,
    0x701c300c00000000, 0xc11ac19f00000000, 0x901b500f00000000,
    0x6018e00e00000000, 0x3119719e00000000, 0x012a018200000000,
    0x502b901200000000, 0xa028201300000000, 0xf129b18300000000,
    0x402f401000000000, 0x112ed18000000000, 0xe12d618100000000,
    0xb02cf01100000000, 0x8020801600000000, 0xd121118600000000,
    0x2122a18700000000, 0x7023301700000000, 0xc125c18400000000,
    0x9024501400000000, 0x6027e01500000000, 0x3126718500000000,
    0x003f001b00000000, 0x513e918b00000000, 0xa13d218a00000000,
    0xf03cb01a00000000, 0x413a418900000000, 0x103bd01900000000,
    0xe038601800000000, 0xb139f18800000000, 0x8135818f00000000,
    0xd034101f00000000, 0x2037a01e00000000, 0x7136318e00000000,
    0xc030c01d00000000, 0x9131518d00000000, 0x6132e18c00000000,
    0x3033701c00000000, 0x015401b400000000, 0x5055902400000000,
    0xa056202500000000, 0xf157b1b500000000, 0x4051402600000000,
    0x1150d1b600000000, 0xe15361b700000000, 0xb052f02700000000,
    0x805e802000000000, 0xd15f11b000000000, 0x215ca1b100000000,
    0x705d302100000000, 0xc15bc1b200000000, 0x905a502200000000,
    0x6059e02300000000, 0x315871b300000000, 0x0041002d00000000,
    0x514091bd00000000, 0xa14321bc00000000, 0xf042b02c00000000,
    0x414441bf00000000, 0x1045d02f00000000, 0xe046602e00000000,
    0xb147f1be00000000, 0x814b81b900000000, 0xd04a102900000000,
    0x2049a02800000000, 0x714831b800000000, 0xc04ec02b00000000,
    0x914f51bb00000000, 0x614ce1ba00000000, 0x304d702a00000000,
    0x007e003600000000, 0x517f91a600000000, 0xa17c21a700000000,
    0xf07db03700000000, 0x417b41a400000000, 0x107ad03400000000,
    0xe079603500000000, 0xb178f1a500000000, 0x817481a200000000,
    0xd075103200000000, 0x2076a03300000000, 0x717731a300000000,
    0xc071c03000000000, 0x917051a000000000, 0x6173e1a100000000,
    0x3072703100000000, 0x016b01af00000000, 0x506a903f00000000,
    0xa069203e00000000, 0xf168b1ae00000000, 0x406e403d00000000,
    0x116fd1ad00000000, 0xe16c61ac00000000, 0xb06df03c00000000,
    0x8061803b00000000, 0xd16011ab00000000, 0x2163a1aa00000000,
    0x7062303a00000000, 0xc164c1a900000000, 0x9065503900000000,
    0x6066e03800000000, 0x316771a800000000, 0x01a801d800000000,
    0x50a9904800000000, 0xa0aa204900000000, 0xf1abb1d900000000,
    0x40ad404a00000000, 0x11acd1da00000000, 0xe1af61db00000000,
    0xb0aef04b00000000, 0x80a2804c00000000, 0xd1a311dc00000000,
    0x21a0a1dd00000000, 0x70a1304d00000000, 0xc1a7c1de00000000,
    0x90a6504e00000000, 0x60a5e04f00000000, 0x31a471df00000000,
    0x00bd004100000000, 0x51bc91d100000000, 0xa1bf21d000000000,
    0xf0beb04000000000, 0x41b841d300000000, 0x10b9d04300000000,
    0xe0ba604200000000, 0xb1bbf1d200000000, 0x81b781d500000000,
    0xd0b6104500000000, 0x20b5a04400000000, 0x71b431d400000000,
    0xc0b2c04700000000, 0x91b351d700000000, 0x61b0e1d600000000,
    0x30b1704600000000, 0x0082005a00000000, 0x518391ca00000000,
    0xa18021cb00000000, 0xf081b05b00000000, 0x418741c800000000,
    0x1086d05800000000, 0xe085605900000000, 0xb184f1c900000000,
    0x818881ce00000000, 0xd089105e00000000, 0x208aa05f00000000,
    0x718b31cf00000000, 0xc08dc05c00000000, 0x918c51cc00000000,
    0x618fe1cd00000000, 0x308e705d00000000, 0x019701c300000000,
    0x5096905300000000, 0xa095205200000000, 0xf194b1c200000000,
    0x4092405100000000, 0x1193d1c100000000, 0xe19061c000000000,
    0xb091f05000000000, 0x809d805700000000, 0xd19c11c700000000,
    0x219fa1c600000000, 0x709e305600000000, 0xc198c1c500000000,
    0x9099505500000000, 0x609ae05400000000, 0x319b71c400000000,
    0x00fc006c00000000, 0x51fd91fc00000000, 0xa1fe21fd00000000,
    0xf0ffb06d00000000, 0x41f941fe00000000, 0x10f8d06e00000000,
    0xe0fb606f00000000, 0xb1faf1ff00000000, 0x81f681f800000000,
    0xd0f7106800000000, 0x20f4a06900000000, 0x71f531f900000000,
    0xc0f3c06a00000000, 0x91f251fa00000000, 0x61f1e1fb00000000,
    0x30f0706b00000000, 0x01e901f500000000, 0x50e8906500000000,
    0xa0eb206400000000, 0xf1eab1f400000000, 0x40ec406700000000,
    0x11edd1f700000000, 0xe1ee61f600000000, 0xb0eff06600000000,
    0x80e3806100000000, 0xd1e211f100000000, 0x21e1a1f000000000,
    0x70e0306000000000, 0xc1e6c1f300000000, 0x90e7506300000000,
    0x60e4e06200000000, 0x31e571f200000000, 0x01d601ee00000000,
    0x50d7907e00000000, 0xa0d4207f00000000, 0xf1d5b1ef00000000,
    0x40d3407c00000000, 0x11d2d1ec00000000, 0xe1d161ed00000000,
    0xb0d0f07d00000000, 0x80dc807a00000000, 0xd1dd11ea00000000,
    0x21dea1eb00000000, 0x70df307b00000000, 0xc1d9c1e800000000,
    0x90d8507800000000, 0x60dbe07900000000, 0x31da71e900000000,
    0x00c3007700000000, 0x51c291e700000000, 0xa1c121e600000000,
    0xf0c0b07600000000, 0x41c641e500000000, 0x10c7d07500000000,
    0xe0c4607400000000, 0xb1c5f1e400000000, 0x81c981e300000000,
    0xd0c8107300000000, 0x20cba07200000000, 0x71ca31e200000000,
    0xc0ccc07100000000, 0x91cd51e100000000, 0x61cee1e000000000,
    0x30cf707000000000},
   {0x0000000000000000, 0x00c001bd00000000, 0x038000ca00000000,
    0x0340017700000000, 0x0500022400000000, 0x05c0039900000000,
    0x068002ee00000000, 0x0640035300000000, 0x0a00044800000000,
    0x0ac005f500000000, 0x0980048200000000, 0x0940053f00000000,
    0x0f00066c00000000, 0x0fc007d100000000, 0x0c8006a600000000,
    0x0c40071b00000000, 0x1400089000000000, 0x14c0092d00000000,
    0x1780085a00000000, 0x174009e700000000, 0x11000ab400000000,
    0x11c00b0900000000, 0x12800a7e00000000, 0x12400bc300000000,
    0x1e000cd800000000, 0x1ec00d6500000000, 0x1d800c1200000000,
    0x1d400daf00000000, 0x1b000efc00000000, 0x1bc00f4100000000,
    0x18800e3600000000, 0x18400f8b00000000, 0x2b00139000000000,
    0x2bc0122d00000000, 0x2880135a00000000, 0x284012e700000000,
    0x2e0011b400000000, 0x2ec0100900000000, 0x2d80117e00000000,
    0x2d4010c300000000, 0x210017d800000000, 0x21c0166500000000,
    0x2280171200000000, 0x224016af00000000, 0x240015fc00000000,
    0x24c0144100000000, 0x2780153600000000, 0x2740148b00000000,
    0x3f001b0000000000, 0x3fc01abd00000000, 0x3c801bca00000000,
    0x3c401a7700000000, 0x3a00192400000000, 0x3ac0189900000000,
    0x398019ee00000000, 0x3940185300000000, 0x35001f4800000000,
    0x35c01ef500000000, 0x36801f8200000000, 0x36401e3f00000000,
    0x30001d6c00000000, 0x30c01cd100000000, 0x33801da600000000,
    0x33401c1b00000000, 0x5500259000000000, 0x55c0242d00000000,
    0x5680255a00000000, 0x564024e700000000, 0x500027b400000000,
    0x50c0260900000000, 0x5380277e00000000, 0x534026c300000000,
    0x5f0021d800000000, 0x5fc0206500000000, 0x5c80211200000000,
    0x5c4020af00000000, 0x5a0023fc00000000, 0x5ac0224100000000,
    0x5980233600000000, 0x5940228b00000000, 0x41002d0000000000,
    0x41c02cbd00000000, 0x42802dca00000000, 0x42402c7700000000,
    0x44002f2400000000, 0x44c02e9900000000, 0x47802fee00000000,
    0x47402e5300000000, 0x4b00294800000000, 0x4bc028f500000000,
    0x4880298200000000, 0x4840283f00000000, 0x4e002b6c00000000,
    0x4ec02ad100000000, 0x4d802ba600000000, 0x4d402a1b00000000,
    0x7e00360000000000, 0x7ec037bd00000000, 0x7d8036ca00000000,
    0x7d40377700000000, 0x7b00342400000000, 0x7bc0359900000000,
    0x788034ee00000000, 0x7840355300000000, 0x7400324800000000,
    0x74c033f500000000, 0x7780328200000000, 0x7740333f00000000,
    0x7100306c00000000, 0x71c031d100000000, 0x728030a600000000,
    0x7240311b00000000, 0x6a003e9000000000, 0x6ac03f2d00000000,
    0x69803e5a00000000, 0x69403fe700000000, 0x6f003cb400000000,
    0x6fc03d0900000000, 0x6c803c7e00000000, 0x6c403dc300000000,
    0x60003ad800000000, 0x60c03b6500000000, 0x63803a1200000000,
    0x63403baf00000000, 0x650038fc00000000, 0x65c0394100000000,
    0x6680383600000000, 0x6640398b00000000, 0xa900499000000000,
    0xa9c0482d00000000, 0xaa80495a00000000, 0xaa4048e700000000,
    0xac004bb400000000, 0xacc04a0900000000, 0xaf804b7e00000000,
    0xaf404ac300000000, 0xa3004dd800000000, 0xa3c04c6500000000,
    0xa0804d1200000000, 0xa0404caf00000000, 0xa6004ffc00000000,
    0xa6c04e4100000000, 0xa5804f3600000000, 0xa5404e8b00000000,
    0xbd00410000000000, 0xbdc040bd00000000, 0xbe8041ca00000000,
    0xbe40407700000000, 0xb800432400000000, 0xb8c0429900000000,
    0xbb8043ee00000000, 0xbb40425300000000, 0xb700454800000000,
    0xb7c044f500000000, 0xb480458200000000, 0xb440443f00000000,
    0xb200476c00000000, 0xb2c046d100000000, 0xb18047a600000000,
    0xb140461b00000000, 0x82005a0000000000, 0x82c05bbd00000000,
    0x81805aca00000000, 0x81405b7700000000, 0x8700582400000000,
    0x87c0599900000000, 0x848058ee00000000, 0x8440595300000000,
    0x88005e4800000000, 0x88c05ff500000000, 0x8b805e8200000000,
    0x8b405f3f00000000, 0x8d005c6c00000000, 0x8dc05dd100000000,
    0x8e805ca600000000, 0x8e405d1b00000000, 0x9600529000000000,
    0x96c0532d00000000, 0x9580525a00000000, 0x954053e700000000,
    0x930050b400000000, 0x93c0510900000000, 0x9080507e00000000,
    0x904051c300000000, 0x9c0056d800000000, 0x9cc0576500000000,
    0x9f80561200000000, 0x9f4057af00000000, 0x990054fc00000000,
    0x99c0554100000000, 0x9a80543600000000, 0x9a40558b00000000,
    0xfc006c0000000000, 0xfcc06dbd00000000, 0xff806cca00000000,
    0xff406d7700000000, 0xf9006e2400000000, 0xf9c06f9900000000,
    0xfa806eee00000000, 0xfa406f5300000000, 0xf600684800000000,
    0xf6c069f500000000, 0xf580688200000000, 0xf540693f00000000,
    0xf3006a6c00000000, 0xf3c06bd100000000, 0xf0806aa600000000,
    0xf0406b1b00000000, 0xe800649000000000, 0xe8c0652d00000000,
    0xeb80645a00000000, 0xeb4065e700000000, 0xed0066b400000000,
    0xedc0670900000000, 0xee80667e00000000, 0xee4067c300000000,
    0xe20060d800000000, 0xe2c0616500000000, 0xe180601200000000,
    0xe14061af00000000, 0xe70062fc00000000, 0xe7c0634100000000,
    0xe480623600000000, 0xe440638b00000000, 0xd7007f9000000000,
    0xd7c07e2d00000000, 0xd4807f5a00000000, 0xd4407ee700000000,
    0xd2007db400000000, 0xd2c07c0900000000, 0xd1807d7e00000000,
    0xd1407cc300000000, 0xdd007bd800000000, 0xddc07a6500000000,
    0xde807b1200000000, 0xde407aaf00000000, 0xd80079fc00000000,
    0xd8c0784100000000, 0xdb80793600000000, 0xdb40788b00000000,
    0xc300770000000000, 0xc3c076bd00000000, 0xc08077ca00000000,
    0xc040767700000000, 0xc600752400000000, 0xc6c0749900000000,
    0xc58075ee00000000, 0xc540745300000000, 0xc900734800000000,
    0xc9c072f500000000, 0xca80738200000000, 0xca40723f00000000,
    0xcc00716c00000000, 0xccc070d100000000, 0xcf8071a600000000,
    0xcf40701b00000000}};

#else /* W == 4 */

static const crc_t crc_braid_table[][256] = {
   {0x00000000, 0x6c90c100, 0xd9218200, 0xb5b14300, 0x02400403,
    0x6ed0c503, 0xdb618603, 0xb7f14703, 0x04800806, 0x6810c906,
    0xdda18a06, 0xb1314b06, 0x06c00c05, 0x6a50cd05, 0xdfe18e05,
    0xb3714f05, 0x0900100c, 0x6590d10c, 0xd021920c, 0xbcb1530c,
    0x0b40140f, 0x67d0d50f, 0xd261960f, 0xbef1570f, 0x0d80180a,
    0x6110d90a, 0xd4a19a0a, 0xb8315b0a, 0x0fc01c09, 0x6350dd09,
    0xd6e19e09, 0xba715f09, 0x12002018, 0x7e90e118, 0xcb21a218,
    0xa7b16318, 0x1040241b, 0x7cd0e51b, 0xc961a61b, 0xa5f1671b,
    0x1680281e, 0x7a10e91e, 0xcfa1aa1e, 0xa3316b1e, 0x14c02c1d,
    0x7850ed1d, 0xcde1ae1d, 0xa1716f1d, 0x1b003014, 0x7790f114,
    0xc221b214, 0xaeb17314, 0x19403417, 0x75d0f517, 0xc061b617,
    0xacf17717, 0x1f803812, 0x7310f912, 0xc6a1ba12, 0xaa317b12,
    0x1dc03c11, 0x7150fd11, 0xc4e1be11, 0xa8717f11, 0x24004030,
    0x48908130, 0xfd21c230, 0x91b10330, 0x26404433, 0x4ad08533,
    0xff61c633, 0x93f10733, 0x20804836, 0x4c108936, 0xf9a1ca36,
    0x95310b36, 0x22c04c35, 0x4e508d35, 0xfbe1ce35, 0x97710f35,
    0x2d00503c, 0x4190913c, 0xf421d23c, 0x98b1133c, 0x2f40543f,
    0x43d0953f, 0xf661d63f, 0x9af1173f, 0x2980583a, 0x4510993a,
    0xf0a1da3a, 0x9c311b3a, 0x2bc05c39, 0x47509d39, 0xf2e1de39,
    0x9e711f39, 0x36006028, 0x5a90a128, 0xef21e228, 0x83b12328,
    0x3440642b, 0x58d0a52b, 0xed61e62b, 0x81f1272b, 0x3280682e,
    0x5e10a92e, 0xeba1ea2e, 0x87312b2e, 0x30c06c2d, 0x5c50ad2d,
    0xe9e1ee2d, 0x85712f2d, 0x3f007024, 0x5390b124, 0xe621f224,
    0x8ab13324, 0x3d407427, 0x51d0b527, 0xe461f627, 0x88f13727,
    0x3b807822, 0x5710b922, 0xe2a1fa22, 0x8e313b22, 0x39c07c21,
    0x5550bd21, 0xe0e1fe21, 0x8c713f21, 0x48008060, 0x24904160,
    0x91210260, 0xfdb1c360, 0x4a408463, 0x26d04563, 0x93610663,
    0xfff1c763, 0x4c808866, 0x20104966, 0x95a10a66, 0xf931cb66,
    0x4ec08c65, 0x22504d65, 0x97e10e65, 0xfb71cf65, 0x4100906c,
    0x2d90516c, 0x9821126c, 0xf4b1d36c, 0x4340946f, 0x2fd0556f,
    0x9a61166f, 0xf6f1d76f, 0x4580986a, 0x2910596a, 0x9ca11a6a,
    0xf031db6a, 0x47c09c69, 0x2b505d69, 0x9ee11e69, 0xf271df69,
    0x5a00a078, 0x36906178, 0x83212278, 0xefb1e378, 0x5840a47b,
    0x34d0657b, 0x8161267b, 0xedf1e77b, 0x5e80a87e, 0x3210697e,
    0x87a12a7e, 0xeb31eb7e, 0x5cc0ac7d, 0x30506d7d, 0x85e12e7d,
    0xe971ef7d, 0x5300b074, 0x3f907174, 0x8a213274, 0xe6b1f374,
    0x5140b477, 0x3dd07577, 0x88613677, 0xe4f1f777, 0x5780b872,
    0x3b107972, 0x8ea13a72, 0xe231fb72, 0x55c0bc71, 0x39507d71,
    0x8ce13e71, 0xe071ff71, 0x6c00c050, 0x00900150, 0xb5214250,
    0xd9b18350, 0x6e40c453, 0x02d00553, 0xb7614653, 0xdbf18753,
    0x6880c856, 0x04100956, 0xb1a14a56, 0xdd318b56, 0x6ac0cc55,
    0x06500d55, 0xb3e14e55, 0xdf718f55, 0x6500d05c, 0x0990115c,
    0xbc21525c, 0xd0b1935c, 0x6740d45f, 0x0bd0155f, 0xbe61565f,
    0xd2f1975f, 0x6180d85a, 0x0d10195a, 0xb8a15a5a, 0xd4319b5a,
    0x63c0dc59, 0x0f501d59, 0xbae15e59, 0xd6719f59, 0x7e00e048,
    0x12902148, 0xa7216248, 0xcbb1a348, 0x7c40e44b, 0x10d0254b,
    0xa561664b, 0xc9f1a74b, 0x7a80e84e, 0x1610294e, 0xa3a16a4e,
    0xcf31ab4e, 0x78c0ec4d, 0x14502d4d, 0xa1e16e4d, 0xcd71af4d,
    0x7700f044, 0x1b903144, 0xae217244, 0xc2b1b344, 0x7540f447,
    0x19d03547, 0xac617647, 0xc0f1b747, 0x7380f842, 0x1f103942,
    0xaaa17a42, 0xc631bb42, 0x71c0fc41, 0x1d503d41, 0xa8e17e41,
    0xc471bf41},
   {0x00000000, 0x900100c0, 0x90010183, 0x00000143, 0x90010305,
    0x000003c5, 0x00000286, 0x90010246, 0x90010609, 0x000006c9,
    0x0000078a, 0x9001074a, 0x0000050c, 0x900105cc, 0x9001048f,
    0x0000044f, 0x90010c11, 0x00000cd1, 0x00000d92, 0x90010d52,
    0x00000f14, 0x90010fd4, 0x90010e97, 0x00000e57, 0x00000a18,
    0x90010ad8, 0x90010b9b, 0x00000b5b, 0x9001091d, 0x000009dd,
    0x0000089e, 0x9001085e, 0x90011821, 0x000018e1, 0x000019a2,
    0x90011962, 0x00001b24, 0x90011be4, 0x90011aa7, 0x00001a67,
    0x00001e28, 0x90011ee8, 0x90011fab, 0x00001f6b, 0x90011d2d,
    0x00001ded, 0x00001cae, 0x90011c6e, 0x00001430, 0x900114f0,
    0x900115b3, 0x00001573, 0x90011735, 0x000017f5, 0x000016b6,
    0x90011676, 0x90011239, 0x000012f9, 0x000013ba, 0x9001137a,
    0x0000113c, 0x900111fc, 0x900110bf, 0x0000107f, 0x90013041,
    0x00003081, 0x000031c2, 0x90013102, 0x00003344, 0x90013384,
    0x900132c7, 0x00003207, 0x00003648, 0x90013688, 0x900137cb,
    0x0000370b, 0x9001354d, 0x0000358d, 0x000034ce, 0x9001340e,
    0x00003c50, 0x90013c90, 0x90013dd3, 0x00003d13, 0x90013f55,
    0x00003f95, 0x00003ed6, 0x90013e16, 0x90013a59, 0x00003a99,
    0x00003bda, 0x90013b1a, 0x0000395c, 0x9001399c, 0x900138df,
    0x0000381f, 0x00002860, 0x900128a0, 0x900129e3, 0x00002923,
    0x90012b65, 0x00002ba5, 0x00002ae6, 0x90012a26, 0x90012e69,
    0x00002ea9, 0x00002fea, 0x90012f2a, 0x00002d6c, 0x90012dac,
    0x90012cef, 0x00002c2f, 0x90012471, 0x000024b1, 0x000025f2,
    0x90012532, 0x00002774, 0x900127b4, 0x900126f7, 0x00002637,
    0x00002278, 0x900122b8, 0x900123fb, 0x0000233b, 0x9001217d,
    0x000021bd, 0x000020fe, 0x9001203e, 0x90016081, 0x00006041,
    0x00006102, 0x900161c2, 0x00006384, 0x90016344, 0x90016207,
    0x000062c7, 0x00006688, 0x90016648, 0x9001670b, 0x000067cb,
    0x9001658d, 0x0000654d, 0x0000640e, 0x900164ce, 0x00006c90,
    0x90016c50, 0x90016d13, 0x00006dd3, 0x90016f95, 0x00006f55,
    0x00006e16, 0x90016ed6, 0x90016a99, 0x00006a59, 0x00006b1a,
    0x90016bda, 0x0000699c, 0x9001695c, 0x9001681f, 0x000068df,
    0x000078a0, 0x90017860, 0x90017923, 0x000079e3, 0x90017ba5,
    0x00007b65, 0x00007a26, 0x90017ae6, 0x90017ea9, 0x00007e69,
    0x00007f2a, 0x90017fea, 0x00007dac, 0x90017d6c, 0x90017c2f,
    0x00007cef, 0x900174b1, 0x00007471, 0x00007532, 0x900175f2,
    0x000077b4, 0x90017774, 0x90017637, 0x000076f7, 0x000072b8,
    0x90017278, 0x9001733b, 0x000073fb, 0x900171bd, 0x0000717d,
    0x0000703e, 0x900170fe, 0x000050c0, 0x90015000, 0x90015143,
    0x00005183, 0x900153c5, 0x00005305, 0x00005246, 0x90015286,
    0x900156c9, 0x00005609, 0x0000574a, 0x9001578a, 0x000055cc,
    0x9001550c, 0x9001544f, 0x0000548f, 0x90015cd1, 0x00005c11,
    0x00005d52, 0x90015d92, 0x00005fd4, 0x90015f14, 0x90015e57,
    0x00005e97, 0x00005ad8, 0x90015a18, 0x90015b5b, 0x00005b9b,
    0x900159dd, 0x0000591d, 0x0000585e, 0x9001589e, 0x900148e1,
    0x00004821, 0x00004962, 0x900149a2, 0x00004be4, 0x90014b24,
    0x90014a67, 0x00004aa7, 0x00004ee8, 0x90014e28, 0x90014f6b,
    0x00004fab, 0x90014ded, 0x00004d2d, 0x00004c6e, 0x90014cae,
    0x000044f0, 0x90014430, 0x90014573, 0x000045b3, 0x900147f5,
    0x00004735, 0x00004676, 0x900146b6, 0x900142f9, 0x00004239,
    0x0000437a, 0x900143ba, 0x000041fc, 0x9001413c, 0x9001407f,
    0x000040bf},
   {0x00000000, 0x9001c101, 0x90008201, 0x00014300, 0x90020401,
    0x0003c500, 0x00028600, 0x90034701, 0x90070801, 0x0006c900,
    0x00078a00, 0x90064b01, 0x00050c00, 0x9004cd01, 0x90058e01,
    0x00044f00, 0x900d1001, 0x000cd100, 0x000d9200, 0x900c5301,
    0x000f1400, 0x900ed501, 0x900f9601, 0x000e5700, 0x000a1800,
    0x900bd901, 0x900a9a01, 0x000b5b00, 0x90081c01, 0x0009dd00,
    0x00089e00, 0x90095f01, 0x90192001, 0x0018e100, 0x0019a200,
    0x90186301, 0x001b2400, 0x901ae501, 0x901ba601, 0x001a6700,
    0x001e2800, 0x901fe901, 0x901eaa01, 0x001f6b00, 0x901c2c01,
    0x001ded00, 0x001cae00, 0x901d6f01, 0x00143000, 0x9015f101,
    0x9014b201, 0x00157300, 0x90163401, 0x0017f500, 0x0016b600,
    0x90177701, 0x90133801, 0x0012f900, 0x0013ba00, 0x90127b01,
    0x00113c00, 0x9010fd01, 0x9011be01, 0x00107f00, 0x90314001,
    0x00308100, 0x0031c200, 0x90300301, 0x00334400, 0x90328501,
    0x9033c601, 0x00320700, 0x00364800, 0x90378901, 0x9036ca01,
    0x00370b00, 0x90344c01, 0x00358d00, 0x0034ce00, 0x90350f01,
    0x003c5000, 0x903d9101, 0x903cd201, 0x003d1300, 0x903e5401,
    0x003f9500, 0x003ed600, 0x903f1701, 0x903b5801, 0x003a9900,
    0x003bda00, 0x903a1b01, 0x00395c00, 0x90389d01, 0x9039de01,
    0x00381f00, 0x00286000, 0x9029a101, 0x9028e201, 0x00292300,
    0x902a6401, 0x002ba500, 0x002ae600, 0x902b2701, 0x902f6801,
    0x002ea900, 0x002fea00, 0x902e2b01, 0x002d6c00, 0x902cad01,
    0x902dee01, 0x002c2f00, 0x90257001, 0x0024b100, 0x0025f200,
    0x90243301, 0x00277400, 0x9026b501, 0x9027f601, 0x00263700,
    0x00227800, 0x9023b901, 0x9022fa01, 0x00233b00, 0x90207c01,
    0x0021bd00, 0x0020fe00, 0x90213f01, 0x90618001, 0x00604100,
    0x00610200, 0x9060c301, 0x00638400, 0x90624501, 0x90630601,
    0x0062c700, 0x00668800, 0x90674901, 0x90660a01, 0x0067cb00,
    0x90648c01, 0x00654d00, 0x00640e00, 0x9065cf01, 0x006c9000,
    0x906d5101, 0x906c1201, 0x006dd300, 0x906e9401, 0x006f5500,
    0x006e1600, 0x906fd701, 0x906b9801, 0x006a5900, 0x006b1a00,
    0x906adb01, 0x00699c00, 0x90685d01, 0x90691e01, 0x0068df00,
    0x0078a000, 0x90796101, 0x90782201, 0x0079e300, 0x907aa401,
    0x007b6500, 0x007a2600, 0x907be701, 0x907fa801, 0x007e6900,
    0x007f2a00, 0x907eeb01, 0x007dac00, 0x907c6d01, 0x907d2e01,
    0x007cef00, 0x9075b001, 0x00747100, 0x00753200, 0x9074f301,
    0x0077b400, 0x90767501, 0x90773601, 0x0076f700, 0x0072b800,
    0x90737901, 0x90723a01, 0x0073fb00, 0x9070bc01, 0x00717d00,
    0x00703e00, 0x9071ff01, 0x0050c000, 0x90510101, 0x90504201,
    0x00518300, 0x9052c401, 0x00530500, 0x00524600, 0x90538701,
    0x9057c801, 0x00560900, 0x00574a00, 0x90568b01, 0x0055cc00,
    0x90540d01, 0x90554e01, 0x00548f00, 0x905dd001, 0x005c1100,
    0x005d5200, 0x905c9301, 0x005fd400, 0x905e1501, 0x905f5601,
    0x005e9700, 0x005ad800, 0x905b1901, 0x905a5a01, 0x005b9b00,
    0x9058dc01, 0x00591d00, 0x00585e00, 0x90599f01, 0x9049e001,
    0x00482100, 0x00496200, 0x9048a301, 0x004be400, 0x904a2501,
    0x904b6601, 0x004aa700, 0x004ee800, 0x904f2901, 0x904e6a01,
    0x004fab00, 0x904cec01, 0x004d2d00, 0x004c6e00, 0x904daf01,
    0x0044f000, 0x90453101, 0x90447201, 0x0045b300, 0x9046f401,
    0x00473500, 0x00467600, 0x9047b701, 0x9043f801, 0x00423900,
    0x00437a00, 0x9042bb01, 0x0041fc00, 0x90403d01, 0x90417e01,
    0x0040bf00},
   {0x00000000, 0x90c00001, 0x91830001, 0x01430000, 0x93050001,
    0x03c50000, 0x02860000, 0x92460001, 0x96090001, 0x06c90000,
    0x078a0000, 0x974a0001, 0x050c0000, 0x95cc0001, 0x948f0001,
    0x044f0000, 0x9c110001, 0x0cd10000, 0x0d920000, 0x9d520001,
    0x0f140000, 0x9fd40001, 0x9e970001, 0x0e570000, 0x0a180000,
    0x9ad80001, 0x9b9b0001, 0x0b5b0000, 0x991d0001, 0x09dd0000,
    0x089e0000, 0x985e0001, 0x88210001, 0x18e10000, 0x19a20000,
    0x89620001, 0x1b240000, 0x8be40001, 0x8aa70001, 0x1a670000,
    0x1e280000, 0x8ee80001, 0x8fab0001, 0x1f6b0000, 0x8d2d0001,
    0x1ded0000, 0x1cae0000, 0x8c6e0001, 0x14300000, 0x84f00001,
    0x85b30001, 0x15730000, 0x87350001, 0x17f50000, 0x16b60000,
    0x86760001, 0x82390001, 0x12f90000, 0x13ba0000, 0x837a0001,
    0x113c0000, 0x81fc0001, 0x80bf0001, 0x107f0000, 0xa0410001,
    0x30810000, 0x31c20000, 0xa1020001, 0x33440000, 0xa3840001,
    0xa2c70001, 0x32070000, 0x36480000, 0xa6880001, 0xa7cb0001,
    0x370b0000, 0xa54d0001, 0x358d0000, 0x34ce0000, 0xa40e0001,
    0x3c500000, 0xac900001, 0xadd30001, 0x3d130000, 0xaf550001,
    0x3f950000, 0x3ed60000, 0xae160001, 0xaa590001, 0x3a990000,
    0x3bda0000, 0xab1a0001, 0x395c0000, 0xa99c0001, 0xa8df0001,
    0x381f0000, 0x28600000, 0xb8a00001, 0xb9e30001, 0x29230000,
    0xbb650001, 0x2ba50000, 0x2ae60000, 0xba260001, 0xbe690001,
    0x2ea90000, 0x2fea0000, 0xbf2a0001, 0x2d6c0000, 0xbdac0001,
    0xbcef0001, 0x2c2f0000, 0xb4710001, 0x24b10000, 0x25f20000,
    0xb5320001, 0x27740000, 0xb7b40001, 0xb6f70001, 0x26370000,
    0x22780000, 0xb2b80001, 0xb3fb0001, 0x233b0000, 0xb17d0001,
    0x21bd0000, 0x20fe0000, 0xb03e0001, 0xf0810001, 0x60410000,
    0x61020000, 0xf1c20001, 0x63840000, 0xf3440001, 0xf2070001,
    0x62c70000, 0x66880000, 0xf6480001, 0xf70b0001, 0x67cb0000,
    0xf58d0001, 0x654d0000, 0x640e0000, 0xf4ce0001, 0x6c900000,
    0xfc500001, 0xfd130001, 0x6dd30000, 0xff950001, 0x6f550000,
    0x6e160000, 0xfed60001, 0xfa990001, 0x6a590000, 0x6b1a0000,
    0xfbda0001, 0x699c0000, 0xf95c0001, 0xf81f0001, 0x68df0000,
    0x78a00000, 0xe8600001, 0xe9230001, 0x79e30000, 0xeba50001,
    0x7b650000, 0x7a260000, 0xeae60001, 0xeea90001, 0x7e690000,
    0x7f2a0000, 0xefea0001, 0x7dac0000, 0xed6c0001, 0xec2f0001,
    0x7cef0000, 0xe4b10001, 0x74710000, 0x75320000, 0xe5f20001,
    0x77b40000, 0xe7740001, 0xe6370001, 0x76f70000, 0x72b80000,
    0xe2780001, 0xe33b0001, 0x73fb0000, 0xe1bd0001, 0x717d0000,
    0x703e0000, 0xe0fe0001, 0x50c00000, 0xc0000001, 0xc1430001,
    0x51830000, 0xc3c50001, 0x53050000, 0x52460000, 0xc2860001,
    0xc6c90001, 0x56090000, 0x574a0000, 0xc78a0001, 0x55cc0000,
    0xc50c0001, 0xc44f0001, 0x548f0000, 0xccd10001, 0x5c110000,
    0x5d520000, 0xcd920001, 0x5fd40000, 0xcf140001, 0xce570001,
    0x5e970000, 0x5ad80000, 0xca180001, 0xcb5b0001, 0x5b9b0000,
    0xc9dd0001, 0x591d0000, 0x585e0000, 0xc89e0001, 0xd8e10001,
    0x48210000, 0x49620000, 0xd9a20001, 0x4be40000, 0xdb240001,
    0xda670001, 0x4aa70000, 0x4ee80000, 0xde280001, 0xdf6b0001,
    0x4fab0000, 0xdded0001, 0x4d2d0000, 0x4c6e0000, 0xdcae0001,
    0x44f00000, 0xd4300001, 0xd5730001, 0x45b30000, 0xd7f50001,
    0x47350000, 0x46760000, 0xd6b60001, 0xd2f90001, 0x42390000,
    0x437a0000, 0xd3ba0001, 0x41fc0000, 0xd13c0001, 0xd07f0001,
    0x40bf0000}};

static const word_t crc_braid_big_table[][256] = {
   {0x00000000, 0x0100c090, 0x01008391, 0x00004301, 0x01000593,
    0x0000c503, 0x00008602, 0x01004692, 0x01000996, 0x0000c906,
    0x00008a07, 0x01004a97, 0x00000c05, 0x0100cc95, 0x01008f94,
    0x00004f04, 0x0100119c, 0x0000d10c, 0x0000920d, 0x0100529d,
    0x0000140f, 0x0100d49f, 0x0100979e, 0x0000570e, 0x0000180a,
    0x0100d89a, 0x01009b9b, 0x00005b0b, 0x01001d99, 0x0000dd09,
    0x00009e08, 0x01005e98, 0x01002188, 0x0000e118, 0x0000a219,
    0x01006289, 0x0000241b, 0x0100e48b, 0x0100a78a, 0x0000671a,
    0x0000281e, 0x0100e88e, 0x0100ab8f, 0x00006b1f, 0x01002d8d,
    0x0000ed1d, 0x0000ae1c, 0x01006e8c, 0x00003014, 0x0100f084,
    0x0100b385, 0x00007315, 0x01003587, 0x0000f517, 0x0000b616,
    0x01007686, 0x01003982, 0x0000f912, 0x0000ba13, 0x01007a83,
    0x00003c11, 0x0100fc81, 0x0100bf80, 0x00007f10, 0x010041a0,
    0x00008130, 0x0000c231, 0x010002a1, 0x00004433, 0x010084a3,
    0x0100c7a2, 0x00000732, 0x00004836, 0x010088a6, 0x0100cba7,
    0x00000b37, 0x01004da5, 0x00008d35, 0x0000ce34, 0x01000ea4,
    0x0000503c, 0x010090ac, 0x0100d3ad, 0x0000133d, 0x010055af,
    0x0000953f, 0x0000d63e, 0x010016ae, 0x010059aa, 0x0000993a,
    0x0000da3b, 0x01001aab, 0x00005c39, 0x01009ca9, 0x0100dfa8,
    0x00001f38, 0x00006028, 0x0100a0b8, 0x0100e3b9, 0x00002329,
    0x010065bb, 0x0000a52b, 0x0000e62a, 0x010026ba, 0x010069be,
    0x0000a92e, 0x0000ea2f, 0x01002abf, 0x00006c2d, 0x0100acbd,
    0x0100efbc, 0x00002f2c, 0x010071b4, 0x0000b124, 0x0000f225,
    0x010032b5, 0x00007427, 0x0100b4b7, 0x0100f7b6, 0x00003726,
    0x00007822, 0x0100b8b2, 0x0100fbb3, 0x00003b23, 0x01007db1,
    0x0000bd21, 0x0000fe20, 0x01003eb0, 0x010081f0, 0x00004160,
    0x00000261, 0x0100c2f1, 0x00008463, 0x010044f3, 0x010007f2,
    0x0000c762, 0x00008866, 0x010048f6, 0x01000bf7, 0x0000cb67,
    0x01008df5, 0x00004d65, 0x00000e64, 0x0100cef4, 0x0000906c,
    0x010050fc, 0x010013fd, 0x0000d36d, 0x010095ff, 0x0000556f,
    0x0000166e, 0x0100d6fe, 0x010099fa, 0x0000596a, 0x00001a6b,
    0x0100dafb, 0x00009c69, 0x01005cf9, 0x01001ff8, 0x0000df68,
    0x0000a078, 0x010060e8, 0x010023e9, 0x0000e379, 0x0100a5eb,
    0x0000657b, 0x0000267a, 0x0100e6ea, 0x0100a9ee, 0x0000697e,
    0x00002a7f, 0x0100eaef, 0x0000ac7d, 0x01006ced, 0x01002fec,
    0x0000ef7c, 0x0100b1e4, 0x00007174, 0x00003275, 0x0100f2e5,
    0x0000b477, 0x010074e7, 0x010037e6, 0x0000f776, 0x0000b872,
    0x010078e2, 0x01003be3, 0x0000fb73, 0x0100bde1, 0x00007d71,
    0x00003e70, 0x0100fee0, 0x0000c050, 0x010000c0, 0x010043c1,
    0x00008351, 0x0100c5c3, 0x00000553, 0x00004652, 0x010086c2,
    0x0100c9c6, 0x00000956, 0x00004a57, 0x01008ac7, 0x0000cc55,
    0x01000cc5, 0x01004fc4, 0x00008f54, 0x0100d1cc, 0x0000115c,
    0x0000525d, 0x010092cd, 0x0000d45f, 0x010014cf, 0x010057ce,
    0x0000975e, 0x0000d85a, 0x010018ca, 0x01005bcb, 0x00009b5b,
    0x0100ddc9, 0x00001d59, 0x00005e58, 0x01009ec8, 0x0100e1d8,
    0x00002148, 0x00006249, 0x0100a2d9, 0x0000e44b, 0x010024db,
    0x010067da, 0x0000a74a, 0x0000e84e, 0x010028de, 0x01006bdf,
    0x0000ab4f, 0x0100eddd, 0x00002d4d, 0x00006e4c, 0x0100aedc,
    0x0000f044, 0x010030d4, 0x010073d5, 0x0000b345, 0x0100f5d7,
    0x00003547, 0x00007646, 0x0100b6d6, 0x0100f9d2, 0x00003942,
    0x00007a43, 0x0100bad3, 0x0000fc41, 0x01003cd1, 0x01007fd0,
    0x0000bf40},
   {0x00000000, 0x01c10190, 0x01820090, 0x00430100, 0x01040290,
    0x00c50300, 0x00860200, 0x01470390, 0x01080790, 0x00c90600,
    0x008a0700, 0x014b0690, 0x000c0500, 0x01cd0490, 0x018e0590,
    0x004f0400, 0x01100d90, 0x00d10c00, 0x00920d00, 0x01530c90,
    0x00140f00, 0x01d50e90, 0x01960f90, 0x00570e00, 0x00180a00,
    0x01d90b90, 0x019a0a90, 0x005b0b00, 0x011c0890, 0x00dd0900,
    0x009e0800, 0x015f0990, 0x01201990, 0x00e11800, 0x00a21900,
    0x01631890, 0x00241b00, 0x01e51a90, 0x01a61b90, 0x00671a00,
    0x00281e00, 0x01e91f90, 0x01aa1e90, 0x006b1f00, 0x012c1c90,
    0x00ed1d00, 0x00ae1c00, 0x016f1d90, 0x00301400, 0x01f11590,
    0x01b21490, 0x00731500, 0x01341690, 0x00f51700, 0x00b61600,
    0x01771790, 0x01381390, 0x00f91200, 0x00ba1300, 0x017b1290,
    0x003c1100, 0x01fd1090, 0x01be1190, 0x007f1000, 0x01403190,
    0x00813000, 0x00c23100, 0x01033090, 0x00443300, 0x01853290,
    0x01c63390, 0x00073200, 0x00483600, 0x01893790, 0x01ca3690,
    0x000b3700, 0x014c3490, 0x008d3500, 0x00ce3400, 0x010f3590,
    0x00503c00, 0x01913d90, 0x01d23c90, 0x00133d00, 0x01543e90,
    0x00953f00, 0x00d63e00, 0x01173f90, 0x01583b90, 0x00993a00,
    0x00da3b00, 0x011b3a90, 0x005c3900, 0x019d3890, 0x01de3990,
    0x001f3800, 0x00602800, 0x01a12990, 0x01e22890, 0x00232900,
    0x01642a90, 0x00a52b00, 0x00e62a00, 0x01272b90, 0x01682f90,
    0x00a92e00, 0x00ea2f00, 0x012b2e90, 0x006c2d00, 0x01ad2c90,
    0x01ee2d90, 0x002f2c00, 0x01702590, 0x00b12400, 0x00f22500,
    0x01332490, 0x00742700, 0x01b52690, 0x01f62790, 0x00372600,
    0x00782200, 0x01b92390, 0x01fa2290, 0x003b2300, 0x017c2090,
    0x00bd2100, 0x00fe2000, 0x013f2190, 0x01806190, 0x00416000,
    0x00026100, 0x01c36090, 0x00846300, 0x01456290, 0x01066390,
    0x00c76200, 0x00886600, 0x01496790, 0x010a6690, 0x00cb6700,
    0x018c6490, 0x004d6500, 0x000e6400, 0x01cf6590, 0x00906c00,
    0x01516d90, 0x01126c90, 0x00d36d00, 0x01946e90, 0x00556f00,
    0x00166e00, 0x01d76f90, 0x01986b90, 0x00596a00, 0x001a6b00,
    0x01db6a90, 0x009c6900, 0x015d6890, 0x011e6990, 0x00df6800,
    0x00a07800, 0x01617990, 0x01227890, 0x00e37900, 0x01a47a90,
    0x00657b00, 0x00267a00, 0x01e77b90, 0x01a87f90, 0x00697e00,
    0x002a7f00, 0x01eb7e90, 0x00ac7d00, 0x016d7c90, 0x012e7d90,
    0x00ef7c00, 0x01b07590, 0x00717400, 0x00327500, 0x01f37490,
    0x00b47700, 0x01757690, 0x01367790, 0x00f77600, 0x00b87200,
    0x01797390, 0x013a7290, 0x00fb7300, 0x01bc7090, 0x007d7100,
    0x003e7000, 0x01ff7190, 0x00c05000, 0x01015190, 0x01425090,
    0x00835100, 0x01c45290, 0x00055300, 0x00465200, 0x01875390,
    0x01c85790, 0x00095600, 0x004a5700, 0x018b5690, 0x00cc5500,
    0x010d5490, 0x014e5590, 0x008f5400, 0x01d05d90, 0x00115c00,
    0x00525d00, 0x01935c90, 0x00d45f00, 0x01155e90, 0x01565f90,
    0x00975e00, 0x00d85a00, 0x01195b90, 0x015a5a90, 0x009b5b00,
    0x01dc5890, 0x001d5900, 0x005e5800, 0x019f5990, 0x01e04990,
    0x00214800, 0x00624900, 0x01a34890, 0x00e44b00, 0x01254a90,
    0x01664b90, 0x00a74a00, 0x00e84e00, 0x01294f90, 0x016a4e90,
    0x00ab4f00, 0x01ec4c90, 0x002d4d00, 0x006e4c00, 0x01af4d90,
    0x00f04400, 0x01314590, 0x01724490, 0x00b34500, 0x01f44690,
    0x00354700, 0x00764600, 0x01b74790, 0x01f84390, 0x00394200,
    0x007a4300, 0x01bb4290, 0x00fc4100, 0x013d4090, 0x017e4190,
    0x00bf4000},
   {0x00000000, 0xc0000190, 0x83010190, 0x43010000, 0x05030190,
    0xc5030000, 0x86020000, 0x46020190, 0x09060190, 0xc9060000,
    0x8a070000, 0x4a070190, 0x0c050000, 0xcc050190, 0x8f040190,
    0x4f040000, 0x110c0190, 0xd10c0000, 0x920d0000, 0x520d0190,
    0x140f0000, 0xd40f0190, 0x970e0190, 0x570e0000, 0x180a0000,
    0xd80a0190, 0x9b0b0190, 0x5b0b0000, 0x1d090190, 0xdd090000,
    0x9e080000, 0x5e080190, 0x21180190, 0xe1180000, 0xa2190000,
    0x62190190, 0x241b0000, 0xe41b0190, 0xa71a0190, 0x671a0000,
    0x281e0000, 0xe81e0190, 0xab1f0190, 0x6b1f0000, 0x2d1d0190,
    0xed1d0000, 0xae1c0000, 0x6e1c0190, 0x30140000, 0xf0140190,
    0xb3150190, 0x73150000, 0x35170190, 0xf5170000, 0xb6160000,
    0x76160190, 0x39120190, 0xf9120000, 0xba130000, 0x7a130190,
    0x3c110000, 0xfc110190, 0xbf100190, 0x7f100000, 0x41300190,
    0x81300000, 0xc2310000, 0x02310190, 0x44330000, 0x84330190,
    0xc7320190, 0x07320000, 0x48360000, 0x88360190, 0xcb370190,
    0x0b370000, 0x4d350190, 0x8d350000, 0xce340000, 0x0e340190,
    0x503c0000, 0x903c0190, 0xd33d0190, 0x133d0000, 0x553f0190,
    0x953f0000, 0xd63e0000, 0x163e0190, 0x593a0190, 0x993a0000,
    0xda3b0000, 0x1a3b0190, 0x5c390000, 0x9c390190, 0xdf380190,
    0x1f380000, 0x60280000, 0xa0280190, 0xe3290190, 0x23290000,
    0x652b0190, 0xa52b0000, 0xe62a0000, 0x262a0190, 0x692e0190,
    0xa92e0000, 0xea2f0000, 0x2a2f0190, 0x6c2d0000, 0xac2d0190,
    0xef2c0190, 0x2f2c0000, 0x71240190, 0xb1240000, 0xf2250000,
    0x32250190, 0x74270000, 0xb4270190, 0xf7260190, 0x37260000,
    0x78220000, 0xb8220190, 0xfb230190, 0x3b230000, 0x7d210190,
    0xbd210000, 0xfe200000, 0x3e200190, 0x81600190, 0x41600000,
    0x02610000, 0xc2610190, 0x84630000, 0x44630190, 0x07620190,
    0xc7620000, 0x88660000, 0x48660190, 0x0b670190, 0xcb670000,
    0x8d650190, 0x4d650000, 0x0e640000, 0xce640190, 0x906c0000,
    0x506c0190, 0x136d0190, 0xd36d0000, 0x956f0190, 0x556f0000,
    0x166e0000, 0xd66e0190, 0x996a0190, 0x596a0000, 0x1a6b0000,
    0xda6b0190, 0x9c690000, 0x5c690190, 0x1f680190, 0xdf680000,
    0xa0780000, 0x60780190, 0x23790190, 0xe3790000, 0xa57b0190,
    0x657b0000, 0x267a0000, 0xe67a0190, 0xa97e0190, 0x697e0000,
    0x2a7f0000, 0xea7f0190, 0xac7d0000, 0x6c7d0190, 0x2f7c0190,
    0xef7c0000, 0xb1740190, 0x71740000, 0x32750000, 0xf2750190,
    0xb4770000, 0x74770190, 0x37760190, 0xf7760000, 0xb8720000,
    0x78720190, 0x3b730190, 0xfb730000, 0xbd710190, 0x7d710000,
    0x3e700000, 0xfe700190, 0xc0500000, 0x00500190, 0x43510190,
    0x83510000, 0xc5530190, 0x05530000, 0x46520000, 0x86520190,
    0xc9560190, 0x09560000, 0x4a570000, 0x8a570190, 0xcc550000,
    0x0c550190, 0x4f540190, 0x8f540000, 0xd15c0190, 0x115c0000,
    0x525d0000, 0x925d0190, 0xd45f0000, 0x145f0190, 0x575e0190,
    0x975e0000, 0xd85a0000, 0x185a0190, 0x5b5b0190, 0x9b5b0000,
    0xdd590190, 0x1d590000, 0x5e580000, 0x9e580190, 0xe1480190,
    0x21480000, 0x62490000, 0xa2490190, 0xe44b0000, 0x244b0190,
    0x674a0190, 0xa74a0000, 0xe84e0000, 0x284e0190, 0x6b4f0190,
    0xab4f0000, 0xed4d0190, 0x2d4d0000, 0x6e4c0000, 0xae4c0190,
    0xf0440000, 0x30440190, 0x73450190, 0xb3450000, 0xf5470190,
    0x35470000, 0x76460000, 0xb6460190, 0xf9420190, 0x39420000,
    0x7a430000, 0xba430190, 0xfc410000, 0x3c410190, 0x7f400190,
    0xbf400000},
   {0x00000000, 0x00c1906c, 0x008221d9, 0x0043b1b5, 0x03044002,
    0x03c5d06e, 0x038661db, 0x0347f1b7, 0x06088004, 0x06c91068,
    0x068aa1dd, 0x064b31b1, 0x050cc006, 0x05cd506a, 0x058ee1df,
    0x054f71b3, 0x0c100009, 0x0cd19065, 0x0c9221d0, 0x0c53b1bc,
    0x0f14400b, 0x0fd5d067, 0x0f9661d2, 0x0f57f1be, 0x0a18800d,
    0x0ad91061, 0x0a9aa1d4, 0x0a5b31b8, 0x091cc00f, 0x09dd5063,
    0x099ee1d6, 0x095f71ba, 0x18200012, 0x18e1907e, 0x18a221cb,
    0x1863b1a7, 0x1b244010, 0x1be5d07c, 0x1ba661c9, 0x1b67f1a5,
    0x1e288016, 0x1ee9107a, 0x1eaaa1cf, 0x1e6b31a3, 0x1d2cc014,
    0x1ded5078, 0x1daee1cd, 0x1d6f71a1, 0x1430001b, 0x14f19077,
    0x14b221c2, 0x1473b1ae, 0x17344019, 0x17f5d075, 0x17b661c0,
    0x1777f1ac, 0x1238801f, 0x12f91073, 0x12baa1c6, 0x127b31aa,
    0x113cc01d, 0x11fd5071, 0x11bee1c4, 0x117f71a8, 0x30400024,
    0x30819048, 0x30c221fd, 0x3003b191, 0x33444026, 0x3385d04a,
    0x33c661ff, 0x3307f193, 0x36488020, 0x3689104c, 0x36caa1f9,
    0x360b3195, 0x354cc022, 0x358d504e, 0x35cee1fb, 0x350f7197,
    0x3c50002d, 0x3c919041, 0x3cd221f4, 0x3c13b198, 0x3f54402f,
    0x3f95d043, 0x3fd661f6, 0x3f17f19a, 0x3a588029, 0x3a991045,
    0x3adaa1f0, 0x3a1b319c, 0x395cc02b, 0x399d5047, 0x39dee1f2,
    0x391f719e, 0x28600036, 0x28a1905a, 0x28e221ef, 0x2823b183,
    0x2b644034, 0x2ba5d058, 0x2be661ed, 0x2b27f181, 0x2e688032,
    0x2ea9105e, 0x2eeaa1eb, 0x2e2b3187, 0x2d6cc030, 0x2dad505c,
    0x2deee1e9, 0x2d2f7185, 0x2470003f, 0x24b19053, 0x24f221e6,
    0x2433b18a, 0x2774403d, 0x27b5d051, 0x27f661e4, 0x2737f188,
    0x2278803b, 0x22b91057, 0x22faa1e2, 0x223b318e, 0x217cc039,
    0x21bd5055, 0x21fee1e0, 0x213f718c, 0x60800048, 0x60419024,
    0x60022191, 0x60c3b1fd, 0x6384404a, 0x6345d026, 0x63066193,
    0x63c7f1ff, 0x6688804c, 0x66491020, 0x660aa195, 0x66cb31f9,
    0x658cc04e, 0x654d5022, 0x650ee197, 0x65cf71fb, 0x6c900041,
    0x6c51902d, 0x6c122198, 0x6cd3b1f4, 0x6f944043, 0x6f55d02f,
    0x6f16619a, 0x6fd7f1f6, 0x6a988045, 0x6a591029, 0x6a1aa19c,
    0x6adb31f0, 0x699cc047, 0x695d502b, 0x691ee19e, 0x69df71f2,
    0x78a0005a, 0x78619036, 0x78222183, 0x78e3b1ef, 0x7ba44058,
    0x7b65d034, 0x7b266181, 0x7be7f1ed, 0x7ea8805e, 0x7e691032,
    0x7e2aa187, 0x7eeb31eb, 0x7dacc05c, 0x7d6d5030, 0x7d2ee185,
    0x7def71e9, 0x74b00053, 0x7471903f, 0x7432218a, 0x74f3b1e6,
    0x77b44051, 0x7775d03d, 0x77366188, 0x77f7f1e4, 0x72b88057,
    0x7279103b, 0x723aa18e, 0x72fb31e2, 0x71bcc055, 0x717d5039,
    0x713ee18c, 0x71ff71e0, 0x50c0006c, 0x50019000, 0x504221b5,
    0x5083b1d9, 0x53c4406e, 0x5305d002, 0x534661b7, 0x5387f1db,
    0x56c88068, 0x56091004, 0x564aa1b1, 0x568b31dd, 0x55ccc06a,
    0x550d5006, 0x554ee1b3, 0x558f71df, 0x5cd00065, 0x5c119009,
    0x5c5221bc, 0x5c93b1d0, 0x5fd44067, 0x5f15d00b, 0x5f5661be,
    0x5f97f1d2, 0x5ad88061, 0x5a19100d, 0x5a5aa1b8, 0x5a9b31d4,
    0x59dcc063, 0x591d500f, 0x595ee1ba, 0x599f71d6, 0x48e0007e,
    0x48219012, 0x486221a7, 0x48a3b1cb, 0x4be4407c, 0x4b25d010,
    0x4b6661a5, 0x4ba7f1c9, 0x4ee8807a, 0x4e291016, 0x4e6aa1a3,
    0x4eab31cf, 0x4decc078, 0x4d2d5014, 0x4d6ee1a1, 0x4daf71cd,
    0x44f00077, 0x4431901b, 0x447221ae, 0x44b3b1c2, 0x47f44075,
    0x4735d019, 0x477661ac, 0x47b7f1c0, 0x42f88073, 0x4239101f,
    0x427aa1aa, 0x42bb31c6, 0x41fcc071, 0x413d501d, 0x417ee1a8,
    0x41bf71c4}};

#endif

#endif

#if N == 5

#if W == 8

static const crc_t crc_braid_table[][256] = {
   {0x00000000, 0x86acf0c0, 0xbd5ae183, 0x3bf61143, 0xcab6c305,
    0x4c1a33c5, 0x77ec2286, 0xf140d246, 0x256e8609, 0xa3c276c9,
    0x9834678a, 0x1e98974a, 0xefd8450c, 0x6974b5cc, 0x5282a48f,
    0xd42e544f, 0x4add0c12, 0xcc71fcd2, 0xf787ed91, 0x712b1d51,
    0x806bcf17, 0x06c73fd7, 0x3d312e94, 0xbb9dde54, 0x6fb38a1b,
    0xe91f7adb, 0xd2e96b98, 0x54459b58, 0xa505491e, 0x23a9b9de,
    0x185fa89d, 0x9ef3585d, 0x95ba1824, 0x1316e8e4, 0x28e0f9a7,
    0xae4c0967, 0x5f0cdb21, 0xd9a02be1, 0xe2563aa2, 0x64faca62,
    0xb0d49e2d, 0x36786eed, 0x0d8e7fae, 0x8b228f6e, 0x7a625d28,
    0xfcceade8, 0xc738bcab, 0x41944c6b, 0xdf671436, 0x59cbe4f6,
    0x623df5b5, 0xe4910575, 0x15d1d733, 0x937d27f3, 0xa88b36b0,
    0x2e27c670, 0xfa09923f, 0x7ca562ff, 0x475373bc, 0xc1ff837c,
    0x30bf513a, 0xb613a1fa, 0x8de5b0b9, 0x0b494079, 0x9b77304b,
    0x1ddbc08b, 0x262dd1c8, 0xa0812108, 0x51c1f34e, 0xd76d038e,
    0xec9b12cd, 0x6a37e20d, 0xbe19b642, 0x38b54682, 0x034357c1,
    0x85efa701, 0x74af7547, 0xf2038587, 0xc9f594c4, 0x4f596404,
    0xd1aa3c59, 0x5706cc99, 0x6cf0ddda, 0xea5c2d1a, 0x1b1cff5c,
    0x9db00f9c, 0xa6461edf, 0x20eaee1f, 0xf4c4ba50, 0x72684a90,
    0x499e5bd3, 0xcf32ab13, 0x3e727955, 0xb8de8995, 0x832898d6,
    0x05846816, 0x0ecd286f, 0x8861d8af, 0xb397c9ec, 0x353b392c,
    0xc47beb6a, 0x42d71baa, 0x79210ae9, 0xff8dfa29, 0x2ba3ae66,
    0xad0f5ea6, 0x96f94fe5, 0x1055bf25, 0xe1156d63, 0x67b99da3,
    0x5c4f8ce0, 0xdae37c20, 0x4410247d, 0xc2bcd4bd, 0xf94ac5fe,
    0x7fe6353e, 0x8ea6e778, 0x080a17b8, 0x33fc06fb, 0xb550f63b,
    0x617ea274, 0xe7d252b4, 0xdc2443f7, 0x5a88b337, 0xabc86171,
    0x2d6491b1, 0x169280f2, 0x903e7032, 0x86ed6095, 0x00419055,
    0x3bb78116, 0xbd1b71d6, 0x4c5ba390, 0xcaf75350, 0xf1014213,
    0x77adb2d3, 0xa383e69c, 0x252f165c, 0x1ed9071f, 0x9875f7df,
    0x69352599, 0xef99d559, 0xd46fc41a, 0x52c334da, 0xcc306c87,
    0x4a9c9c47, 0x716a8d04, 0xf7c67dc4, 0x0686af82, 0x802a5f42,
    0xbbdc4e01, 0x3d70bec1, 0xe95eea8e, 0x6ff21a4e, 0x54040b0d,
    0xd2a8fbcd, 0x23e8298b, 0xa544d94b, 0x9eb2c808, 0x181e38c8,
    0x135778b1, 0x95fb8871, 0xae0d9932, 0x28a169f2, 0xd9e1bbb4,
    0x5f4d4b74, 0x64bb5a37, 0xe217aaf7, 0x3639feb8, 0xb0950e78,
    0x8b631f3b, 0x0dcfeffb, 0xfc8f3dbd, 0x7a23cd7d, 0x41d5dc3e,
    0xc7792cfe, 0x598a74a3, 0xdf268463, 0xe4d09520, 0x627c65e0,
    0x933cb7a6, 0x15904766, 0x2e665625, 0xa8caa6e5, 0x7ce4f2aa,
    0xfa48026a, 0xc1be1329, 0x4712e3e9, 0xb65231af, 0x30fec16f,
    0x0b08d02c, 0x8da420ec, 0x1d9a50de, 0x9b36a01e, 0xa0c0b15d,
    0x266c419d, 0xd72c93db, 0x5180631b, 0x6a767258, 0xecda8298,
    0x38f4d6d7, 0xbe582617, 0x85ae3754, 0x0302c794, 0xf24215d2,
    0x74eee512, 0x4f18f451, 0xc9b40491, 0x57475ccc, 0xd1ebac0c,
    0xea1dbd4f, 0x6cb14d8f, 0x9df19fc9, 0x1b5d6f09, 0x20ab7e4a,
    0xa6078e8a, 0x7229dac5, 0xf4852a05, 0xcf733b46, 0x49dfcb86,
    0xb89f19c0, 0x3e33e900, 0x05c5f843, 0x83690883, 0x882048fa,
    0x0e8cb83a, 0x357aa979, 0xb3d659b9, 0x42968bff, 0xc43a7b3f,
    0xffcc6a7c, 0x79609abc, 0xad4ecef3, 0x2be23e33, 0x10142f70,
    0x96b8dfb0, 0x67f80df6, 0xe154fd36, 0xdaa2ec75, 0x5c0e1cb5,
    0xc2fd44e8, 0x4451b428, 0x7fa7a56b, 0xf90b55ab, 0x084b87ed,
    0x8ee7772d, 0xb511666e, 0x33bd96ae, 0xe793c2e1, 0x613f3221,
    0x5ac92362, 0xdc65d3a2, 0x2d2501e4, 0xab89f124, 0x907fe067,
    0x16d310a7},
   {0x00000000, 0xbdd9c129, 0xcbb08251, 0x76694378, 0x276204a1,
    0x9abbc588, 0xecd286f0, 0x510b47d9, 0x4ec40942, 0xf31dc86b,
    0x85748b13, 0x38ad4a3a, 0x69a60de3, 0xd47fccca, 0xa2168fb2,
    0x1fcf4e9b, 0x9d881284, 0x2051d3ad, 0x563890d5, 0xebe151fc,
    0xbaea1625, 0x0733d70c, 0x715a9474, 0xcc83555d, 0xd34c1bc6,
    0x6e95daef, 0x18fc9997, 0xa52558be, 0xf42e1f67, 0x49f7de4e,
    0x3f9e9d36, 0x82475c1f, 0x8b13250b, 0x36cae422, 0x40a3a75a,
    0xfd7a6673, 0xac7121aa, 0x11a8e083, 0x67c1a3fb, 0xda1862d2,
    0xc5d72c49, 0x780eed60, 0x0e67ae18, 0xb3be6f31, 0xe2b528e8,
    0x5f6ce9c1, 0x2905aab9, 0x94dc6b90, 0x169b378f, 0xab42f6a6,
    0xdd2bb5de, 0x60f274f7, 0x31f9332e, 0x8c20f207, 0xfa49b17f,
    0x47907056, 0x585f3ecd, 0xe586ffe4, 0x93efbc9c, 0x2e367db5,
    0x7f3d3a6c, 0xc2e4fb45, 0xb48db83d, 0x09547914, 0xa6254a15,
    0x1bfc8b3c, 0x6d95c844, 0xd04c096d, 0x81474eb4, 0x3c9e8f9d,
    0x4af7cce5, 0xf72e0dcc, 0xe8e14357, 0x5538827e, 0x2351c106,
    0x9e88002f, 0xcf8347f6, 0x725a86df, 0x0433c5a7, 0xb9ea048e,
    0x3bad5891, 0x867499b8, 0xf01ddac0, 0x4dc41be9, 0x1ccf5c30,
    0xa1169d19, 0xd77fde61, 0x6aa61f48, 0x756951d3, 0xc8b090fa,
    0xbed9d382, 0x030012ab, 0x520b5572, 0xefd2945b, 0x99bbd723,
    0x2462160a, 0x2d366f1e, 0x90efae37, 0xe686ed4f, 0x5b5f2c66,
    0x0a546bbf, 0xb78daa96, 0xc1e4e9ee, 0x7c3d28c7, 0x63f2665c,
    0xde2ba775, 0xa842e40d, 0x159b2524, 0x449062fd, 0xf949a3d4,
    0x8f20e0ac, 0x32f92185, 0xb0be7d9a, 0x0d67bcb3, 0x7b0effcb,
    0xc6d73ee2, 0x97dc793b, 0x2a05b812, 0x5c6cfb6a, 0xe1b53a43,
    0xfe7a74d8, 0x43a3b5f1, 0x35caf689, 0x881337a0, 0xd9187079,
    0x64c1b150, 0x12a8f228, 0xaf713301, 0xfc499429, 0x41905500,
    0x37f91678, 0x8a20d751, 0xdb2b9088, 0x66f251a1, 0x109b12d9,
    0xad42d3f0, 0xb28d9d6b, 0x0f545c42, 0x793d1f3a, 0xc4e4de13,
    0x95ef99ca, 0x283658e3, 0x5e5f1b9b, 0xe386dab2, 0x61c186ad,
    0xdc184784, 0xaa7104fc, 0x17a8c5d5, 0x46a3820c, 0xfb7a4325,
    0x8d13005d, 0x30cac174, 0x2f058fef, 0x92dc4ec6, 0xe4b50dbe,
    0x596ccc97, 0x08678b4e, 0xb5be4a67, 0xc3d7091f, 0x7e0ec836,
    0x775ab122, 0xca83700b, 0xbcea3373, 0x0133f25a, 0x5038b583,
    0xede174aa, 0x9b8837d2, 0x2651f6fb, 0x399eb860, 0x84477949,
    0xf22e3a31, 0x4ff7fb18, 0x1efcbcc1, 0xa3257de8, 0xd54c3e90,
    0x6895ffb9, 0xead2a3a6, 0x570b628f, 0x216221f7, 0x9cbbe0de,
    0xcdb0a707, 0x7069662e, 0x06002556, 0xbbd9e47f, 0xa416aae4,
    0x19cf6bcd, 0x6fa628b5, 0xd27fe99c, 0x8374ae45, 0x3ead6f6c,
    0x48c42c14, 0xf51ded3d, 0x5a6cde3c, 0xe7b51f15, 0x91dc5c6d,
    0x2c059d44, 0x7d0eda9d, 0xc0d71bb4, 0xb6be58cc, 0x0b6799e5,
    0x14a8d77e, 0xa9711657, 0xdf18552f, 0x62c19406, 0x33cad3df,
    0x8e1312f6, 0xf87a518e, 0x45a390a7, 0xc7e4ccb8, 0x7a3d0d91,
    0x0c544ee9, 0xb18d8fc0, 0xe086c819, 0x5d5f0930, 0x2b364a48,
    0x96ef8b61, 0x8920c5fa, 0x34f904d3, 0x429047ab, 0xff498682,
    0xae42c15b, 0x139b0072, 0x65f2430a, 0xd82b8223, 0xd17ffb37,
    0x6ca63a1e, 0x1acf7966, 0xa716b84f, 0xf61dff96, 0x4bc43ebf,
    0x3dad7dc7, 0x8074bcee, 0x9fbbf275, 0x2262335c, 0x540b7024,
    0xe9d2b10d, 0xb8d9f6d4, 0x050037fd, 0x73697485, 0xceb0b5ac,
    0x4cf7e9b3, 0xf12e289a, 0x87476be2, 0x3a9eaacb, 0x6b95ed12,
    0xd64c2c3b, 0xa0256f43, 0x1dfcae6a, 0x0233e0f1, 0xbfea21d8,
    0xc98362a0, 0x745aa389, 0x2551e450, 0x98882579, 0xeee16601,
    0x5338a728},
   {0x00000000, 0x48902851, 0x912050a2, 0xd9b078f3, 0x9243a147,
    0xdad38916, 0x0363f1e5, 0x4bf3d9b4, 0x9484428d, 0xdc146adc,
    0x05a4122f, 0x4d343a7e, 0x06c7e3ca, 0x4e57cb9b, 0x97e7b368,
    0xdf779b39, 0x990b8519, 0xd19bad48, 0x082bd5bb, 0x40bbfdea,
    0x0b48245e, 0x43d80c0f, 0x9a6874fc, 0xd2f85cad, 0x0d8fc794,
    0x451fefc5, 0x9caf9736, 0xd43fbf67, 0x9fcc66d3, 0xd75c4e82,
    0x0eec3671, 0x467c1e20, 0x82140a31, 0xca842260, 0x13345a93,
    0x5ba472c2, 0x1057ab76, 0x58c78327, 0x8177fbd4, 0xc9e7d385,
    0x169048bc, 0x5e0060ed, 0x87b0181e, 0xcf20304f, 0x84d3e9fb,
    0xcc43c1aa, 0x15f3b959, 0x5d639108, 0x1b1f8f28, 0x538fa779,
    0x8a3fdf8a, 0xc2aff7db, 0x895c2e6f, 0xc1cc063e, 0x187c7ecd,
    0x50ec569c, 0x8f9bcda5, 0xc70be5f4, 0x1ebb9d07, 0x562bb556,
    0x1dd86ce2, 0x554844b3, 0x8cf83c40, 0xc4681411, 0xb42b1461,
    0xfcbb3c30, 0x250b44c3, 0x6d9b6c92, 0x2668b526, 0x6ef89d77,
    0xb748e584, 0xffd8cdd5, 0x20af56ec, 0x683f7ebd, 0xb18f064e,
    0xf91f2e1f, 0xb2ecf7ab, 0xfa7cdffa, 0x23cca709, 0x6b5c8f58,
    0x2d209178, 0x65b0b929, 0xbc00c1da, 0xf490e98b, 0xbf63303f,
    0xf7f3186e, 0x2e43609d, 0x66d348cc, 0xb9a4d3f5, 0xf134fba4,
    0x28848357, 0x6014ab06, 0x2be772b2, 0x63775ae3, 0xbac72210,
    0xf2570a41, 0x363f1e50, 0x7eaf3601, 0xa71f4ef2, 0xef8f66a3,
    0xa47cbf17, 0xecec9746, 0x355cefb5, 0x7dccc7e4, 0xa2bb5cdd,
    0xea2b748c, 0x339b0c7f, 0x7b0b242e, 0x30f8fd9a, 0x7868d5cb,
    0xa1d8ad38, 0xe9488569, 0xaf349b49, 0xe7a4b318, 0x3e14cbeb,
    0x7684e3ba, 0x3d773a0e, 0x75e7125f, 0xac576aac, 0xe4c742fd,
    0x3bb0d9c4, 0x7320f195, 0xaa908966, 0xe200a137, 0xa9f37883,
    0xe16350d2, 0x38d32821, 0x70430070, 0xd85528c1, 0x90c50090,
    0x49757863, 0x01e55032, 0x4a168986, 0x0286a1d7, 0xdb36d924,
    0x93a6f175, 0x4cd16a4c, 0x0441421d, 0xddf13aee, 0x956112bf,
    0xde92cb0b, 0x9602e35a, 0x4fb29ba9, 0x0722b3f8, 0x415eadd8,
    0x09ce8589, 0xd07efd7a, 0x98eed52b, 0xd31d0c9f, 0x9b8d24ce,
    0x423d5c3d, 0x0aad746c, 0xd5daef55, 0x9d4ac704, 0x44fabff7,
    0x0c6a97a6, 0x47994e12, 0x0f096643, 0xd6b91eb0, 0x9e2936e1,
    0x5a4122f0, 0x12d10aa1, 0xcb617252, 0x83f15a03, 0xc80283b7,
    0x8092abe6, 0x5922d315, 0x11b2fb44, 0xcec5607d, 0x8655482c,
    0x5fe530df, 0x1775188e, 0x5c86c13a, 0x1416e96b, 0xcda69198,
    0x8536b9c9, 0xc34aa7e9, 0x8bda8fb8, 0x526af74b, 0x1afadf1a,
    0x510906ae, 0x19992eff, 0xc029560c, 0x88b97e5d, 0x57cee564,
    0x1f5ecd35, 0xc6eeb5c6, 0x8e7e9d97, 0xc58d4423, 0x8d1d6c72,
    0x54ad1481, 0x1c3d3cd0, 0x6c7e3ca0, 0x24ee14f1, 0xfd5e6c02,
    0xb5ce4453, 0xfe3d9de7, 0xb6adb5b6, 0x6f1dcd45, 0x278de514,
    0xf8fa7e2d, 0xb06a567c, 0x69da2e8f, 0x214a06de, 0x6ab9df6a,
    0x2229f73b, 0xfb998fc8, 0xb309a799, 0xf575b9b9, 0xbde591e8,
    0x6455e91b, 0x2cc5c14a, 0x673618fe, 0x2fa630af, 0xf616485c,
    0xbe86600d, 0x61f1fb34, 0x2961d365, 0xf0d1ab96, 0xb84183c7,
    0xf3b25a73, 0xbb227222, 0x62920ad1, 0x2a022280, 0xee6a3691,
    0xa6fa1ec0, 0x7f4a6633, 0x37da4e62, 0x7c2997d6, 0x34b9bf87,
    0xed09c774, 0xa599ef25, 0x7aee741c, 0x327e5c4d, 0xebce24be,
    0xa35e0cef, 0xe8add55b, 0xa03dfd0a, 0x798d85f9, 0x311dada8,
    0x7761b388, 0x3ff19bd9, 0xe641e32a, 0xaed1cb7b, 0xe52212cf,
    0xadb23a9e, 0x7402426d, 0x3c926a3c, 0xe3e5f105, 0xab75d954,
    0x72c5a1a7, 0x3a5589f6, 0x71a65042, 0x39367813, 0xe08600e0,
    0xa81628b1},
   {0x00000000, 0x00a95181, 0x0152a302, 0x01fbf283, 0x02a54604,
    0x020c1785, 0x03f7e506, 0x035eb487, 0x054a8c08, 0x05e3dd89,
    0x04182f0a, 0x04b17e8b, 0x07efca0c, 0x07469b8d, 0x06bd690e,
    0x0614388f, 0x0a951810, 0x0a3c4991, 0x0bc7bb12, 0x0b6eea93,
    0x08305e14, 0x08990f95, 0x0962fd16, 0x09cbac97, 0x0fdf9418,
    0x0f76c599, 0x0e8d371a, 0x0e24669b, 0x0d7ad21c, 0x0dd3839d,
    0x0c28711e, 0x0c81209f, 0x152a3020, 0x158361a1, 0x14789322,
    0x14d1c2a3, 0x178f7624, 0x172627a5, 0x16ddd526, 0x167484a7,
    0x1060bc28, 0x10c9eda9, 0x11321f2a, 0x119b4eab, 0x12c5fa2c,
    0x126cabad, 0x1397592e, 0x133e08af, 0x1fbf2830, 0x1f1679b1,
    0x1eed8b32, 0x1e44dab3, 0x1d1a6e34, 0x1db33fb5, 0x1c48cd36,
    0x1ce19cb7, 0x1af5a438, 0x1a5cf5b9, 0x1ba7073a, 0x1b0e56bb,
    0x1850e23c, 0x18f9b3bd, 0x1902413e, 0x19ab10bf, 0x2a546040,
    0x2afd31c1, 0x2b06c342, 0x2baf92c3, 0x28f12644, 0x285877c5,
    0x29a38546, 0x290ad4c7, 0x2f1eec48, 0x2fb7bdc9, 0x2e4c4f4a,
    0x2ee51ecb, 0x2dbbaa4c, 0x2d12fbcd, 0x2ce9094e, 0x2c4058cf,
    0x20c17850, 0x206829d1, 0x2193db52, 0x213a8ad3, 0x22643e54,
    0x22cd6fd5, 0x23369d56, 0x239fccd7, 0x258bf458, 0x2522a5d9,
    0x24d9575a, 0x247006db, 0x272eb25c, 0x2787e3dd, 0x267c115e,
    0x26d540df, 0x3f7e5060, 0x3fd701e1, 0x3e2cf362, 0x3e85a2e3,
    0x3ddb1664, 0x3d7247e5, 0x3c89b566, 0x3c20e4e7, 0x3a34dc68,
    0x3a9d8de9, 0x3b667f6a, 0x3bcf2eeb, 0x38919a6c, 0x3838cbed,
    0x39c3396e, 0x396a68ef, 0x35eb4870, 0x354219f1, 0x34b9eb72,
    0x3410baf3, 0x374e0e74, 0x37e75ff5, 0x361cad76, 0x36b5fcf7,
    0x30a1c478, 0x300895f9, 0x31f3677a, 0x315a36fb, 0x3204827c,
    0x32add3fd, 0x3356217e, 0x33ff70ff, 0x54a8c080, 0x54019101,
    0x55fa6382, 0x55533203, 0x560d8684, 0x56a4d705, 0x575f2586,
    0x57f67407, 0x51e24c88, 0x514b1d09, 0x50b0ef8a, 0x5019be0b,
    0x53470a8c, 0x53ee5b0d, 0x5215a98e, 0x52bcf80f, 0x5e3dd890,
    0x5e948911, 0x5f6f7b92, 0x5fc62a13, 0x5c989e94, 0x5c31cf15,
    0x5dca3d96, 0x5d636c17, 0x5b775498, 0x5bde0519, 0x5a25f79a,
    0x5a8ca61b, 0x59d2129c, 0x597b431d, 0x5880b19e, 0x5829e01f,
    0x4182f0a0, 0x412ba121, 0x40d053a2, 0x40790223, 0x4327b6a4,
    0x438ee725, 0x427515a6, 0x42dc4427, 0x44c87ca8, 0x44612d29,
    0x459adfaa, 0x45338e2b, 0x466d3aac, 0x46c46b2d, 0x473f99ae,
    0x4796c82f, 0x4b17e8b0, 0x4bbeb931, 0x4a454bb2, 0x4aec1a33,
    0x49b2aeb4, 0x491bff35, 0x48e00db6, 0x48495c37, 0x4e5d64b8,
    0x4ef43539, 0x4f0fc7ba, 0x4fa6963b, 0x4cf822bc, 0x4c51733d,
    0x4daa81be, 0x4d03d03f, 0x7efca0c0, 0x7e55f141, 0x7fae03c2,
    0x7f075243, 0x7c59e6c4, 0x7cf0b745, 0x7d0b45c6, 0x7da21447,
    0x7bb62cc8, 0x7b1f7d49, 0x7ae48fca, 0x7a4dde4b, 0x79136acc,
    0x79ba3b4d, 0x7841c9ce, 0x78e8984f, 0x7469b8d0, 0x74c0e951,
    0x753b1bd2, 0x75924a53, 0x76ccfed4, 0x7665af55, 0x779e5dd6,
    0x77370c57, 0x712334d8, 0x718a6559, 0x707197da, 0x70d8c65b,
    0x738672dc, 0x732f235d, 0x72d4d1de, 0x727d805f, 0x6bd690e0,
    0x6b7fc161, 0x6a8433e2, 0x6a2d6263, 0x6973d6e4, 0x69da8765,
    0x682175e6, 0x68882467, 0x6e9c1ce8, 0x6e354d69, 0x6fcebfea,
    0x6f67ee6b, 0x6c395aec, 0x6c900b6d, 0x6d6bf9ee, 0x6dc2a86f,
    0x614388f0, 0x61ead971, 0x60112bf2, 0x60b87a73, 0x63e6cef4,
    0x634f9f75, 0x62b46df6, 0x621d3c77, 0x640904f8, 0x64a05579,
    0x655ba7fa, 0x65f2f67b, 0x66ac42fc, 0x6605137d, 0x67fee1fe,
    0x6757b07f},
   {0x00000000, 0xa9518100, 0xe2a00203, 0x4bf18303, 0x75430405,
    0xdc128505, 0x97e30606, 0x3eb28706, 0xea86080a, 0x43d7890a,
    0x08260a09, 0xa1778b09, 0x9fc50c0f, 0x36948d0f, 0x7d650e0c,
    0xd4348f0c, 0x650f1017, 0xcc5e9117, 0x87af1214, 0x2efe9314,
    0x104c1412, 0xb91d9512, 0xf2ec1611, 0x5bbd9711, 0x8f89181d,
    0x26d8991d, 0x6d291a1e, 0xc4789b1e, 0xfaca1c18, 0x539b9d18,
    0x186a1e1b, 0xb13b9f1b, 0xca1e202e, 0x634fa12e, 0x28be222d,
    0x81efa32d, 0xbf5d242b, 0x160ca52b, 0x5dfd2628, 0xf4aca728,
    0x20982824, 0x89c9a924, 0xc2382a27, 0x6b69ab27, 0x55db2c21,
    0xfc8aad21, 0xb77b2e22, 0x1e2aaf22, 0xaf113039, 0x0640b139,
    0x4db1323a, 0xe4e0b33a, 0xda52343c, 0x7303b53c, 0x38f2363f,
    0x91a3b73f, 0x45973833, 0xecc6b933, 0xa7373a30, 0x0e66bb30,
    0x30d43c36, 0x9985bd36, 0xd2743e35, 0x7b25bf35, 0x243f405f,
    0x8d6ec15f, 0xc69f425c, 0x6fcec35c, 0x517c445a, 0xf82dc55a,
    0xb3dc4659, 0x1a8dc759, 0xceb94855, 0x67e8c955, 0x2c194a56,
    0x8548cb56, 0xbbfa4c50, 0x12abcd50, 0x595a4e53, 0xf00bcf53,
    0x41305048, 0xe861d148, 0xa390524b, 0x0ac1d34b, 0x3473544d,
    0x9d22d54d, 0xd6d3564e, 0x7f82d74e, 0xabb65842, 0x02e7d942,
    0x49165a41, 0xe047db41, 0xdef55c47, 0x77a4dd47, 0x3c555e44,
    0x9504df44, 0xee216071, 0x4770e171, 0x0c816272, 0xa5d0e372,
    0x9b626474, 0x3233e574, 0x79c26677, 0xd093e777, 0x04a7687b,
    0xadf6e97b, 0xe6076a78, 0x4f56eb78, 0x71e46c7e, 0xd8b5ed7e,
    0x93446e7d, 0x3a15ef7d, 0x8b2e7066, 0x227ff166, 0x698e7265,
    0xc0dff365, 0xfe6d7463, 0x573cf563, 0x1ccd7660, 0xb59cf760,
    0x61a8786c, 0xc8f9f96c, 0x83087a6f, 0x2a59fb6f, 0x14eb7c69,
    0xbdbafd69, 0xf64b7e6a, 0x5f1aff6a, 0x487e80be, 0xe12f01be,
    0xaade82bd, 0x038f03bd, 0x3d3d84bb, 0x946c05bb, 0xdf9d86b8,
    0x76cc07b8, 0xa2f888b4, 0x0ba909b4, 0x40588ab7, 0xe9090bb7,
    0xd7bb8cb1, 0x7eea0db1, 0x351b8eb2, 0x9c4a0fb2, 0x2d7190a9,
    0x842011a9, 0xcfd192aa, 0x668013aa, 0x583294ac, 0xf16315ac,
    0xba9296af, 0x13c317af, 0xc7f798a3, 0x6ea619a3, 0x25579aa0,
    0x8c061ba0, 0xb2b49ca6, 0x1be51da6, 0x50149ea5, 0xf9451fa5,
    0x8260a090, 0x2b312190, 0x60c0a293, 0xc9912393, 0xf723a495,
    0x5e722595, 0x1583a696, 0xbcd22796, 0x68e6a89a, 0xc1b7299a,
    0x8a46aa99, 0x23172b99, 0x1da5ac9f, 0xb4f42d9f, 0xff05ae9c,
    0x56542f9c, 0xe76fb087, 0x4e3e3187, 0x05cfb284, 0xac9e3384,
    0x922cb482, 0x3b7d3582, 0x708cb681, 0xd9dd3781, 0x0de9b88d,
    0xa4b8398d, 0xef49ba8e, 0x46183b8e, 0x78aabc88, 0xd1fb3d88,
    0x9a0abe8b, 0x335b3f8b, 0x6c41c0e1, 0xc51041e1, 0x8ee1c2e2,
    0x27b043e2, 0x1902c4e4, 0xb05345e4, 0xfba2c6e7, 0x52f347e7,
    0x86c7c8eb, 0x2f9649eb, 0x6467cae8, 0xcd364be8, 0xf384ccee,
    0x5ad54dee, 0x1124ceed, 0xb8754fed, 0x094ed0f6, 0xa01f51f6,
    0xebeed2f5, 0x42bf53f5, 0x7c0dd4f3, 0xd55c55f3, 0x9eadd6f0,
    0x37fc57f0, 0xe3c8d8fc, 0x4a9959fc, 0x0168daff, 0xa8395bff,
    0x968bdcf9, 0x3fda5df9, 0x742bdefa, 0xdd7a5ffa, 0xa65fe0cf,
    0x0f0e61cf, 0x44ffe2cc, 0xedae63cc, 0xd31ce4ca, 0x7a4d65ca,
    0x31bce6c9, 0x98ed67c9, 0x4cd9e8c5, 0xe58869c5, 0xae79eac6,
    0x07286bc6, 0x399aecc0, 0x90cb6dc0, 0xdb3aeec3, 0x726b6fc3,
    0xc350f0d8, 0x6a0171d8, 0x21f0f2db, 0x88a173db, 0xb613f4dd,
    0x1f4275dd, 0x54b3f6de, 0xfde277de, 0x29d6f8d2, 0x808779d2,
    0xcb76fad1, 0x62277bd1, 0x5c95fcd7, 0xf5c47dd7, 0xbe35fed4,
    0x17647fd4},
   {0x00000000, 0x90fd017c, 0x91f902fb, 0x01040387, 0x93f105f5,
    0x030c0489, 0x0208070e, 0x92f50672, 0x97e10be9, 0x071c0a95,
    0x06180912, 0x96e5086e, 0x04100e1c, 0x94ed0f60, 0x95e90ce7,
    0x05140d9b, 0x9fc117d1, 0x0f3c16ad, 0x0e38152a, 0x9ec51456,
    0x0c301224, 0x9ccd1358, 0x9dc910df, 0x0d3411a3, 0x08201c38,
    0x98dd1d44, 0x99d91ec3, 0x09241fbf, 0x9bd119cd, 0x0b2c18b1,
    0x0a281b36, 0x9ad51a4a, 0x8f812fa1, 0x1f7c2edd, 0x1e782d5a,
    0x8e852c26, 0x1c702a54, 0x8c8d2b28, 0x8d8928af, 0x1d7429d3,
    0x18602448, 0x889d2534, 0x899926b3, 0x196427cf, 0x8b9121bd,
    0x1b6c20c1, 0x1a682346, 0x8a95223a, 0x10403870, 0x80bd390c,
    0x81b93a8b, 0x11443bf7, 0x83b13d85, 0x134c3cf9, 0x12483f7e,
    0x82b53e02, 0x87a13399, 0x175c32e5, 0x16583162, 0x86a5301e,
    0x1450366c, 0x84ad3710, 0x85a93497, 0x155435eb, 0xaf015f41,
    0x3ffc5e3d, 0x3ef85dba, 0xae055cc6, 0x3cf05ab4, 0xac0d5bc8,
    0xad09584f, 0x3df45933, 0x38e054a8, 0xa81d55d4, 0xa9195653,
    0x39e4572f, 0xab11515d, 0x3bec5021, 0x3ae853a6, 0xaa1552da,
    0x30c04890, 0xa03d49ec, 0xa1394a6b, 0x31c44b17, 0xa3314d65,
    0x33cc4c19, 0x32c84f9e, 0xa2354ee2, 0xa7214379, 0x37dc4205,
    0x36d84182, 0xa62540fe, 0x34d0468c, 0xa42d47f0, 0xa5294477,
    0x35d4450b, 0x208070e0, 0xb07d719c, 0xb179721b, 0x21847367,
    0xb3717515, 0x238c7469, 0x228877ee, 0xb2757692, 0xb7617b09,
    0x279c7a75, 0x269879f2, 0xb665788e, 0x24907efc, 0xb46d7f80,
    0xb5697c07, 0x25947d7b, 0xbf416731, 0x2fbc664d, 0x2eb865ca,
    0xbe4564b6, 0x2cb062c4, 0xbc4d63b8, 0xbd49603f, 0x2db46143,
    0x28a06cd8, 0xb85d6da4, 0xb9596e23, 0x29a46f5f, 0xbb51692d,
    0x2bac6851, 0x2aa86bd6, 0xba556aaa, 0xee01be81, 0x7efcbffd,
    0x7ff8bc7a, 0xef05bd06, 0x7df0bb74, 0xed0dba08, 0xec09b98f,
    0x7cf4b8f3, 0x79e0b568, 0xe91db414, 0xe819b793, 0x78e4b6ef,
    0xea11b09d, 0x7aecb1e1, 0x7be8b266, 0xeb15b31a, 0x71c0a950,
    0xe13da82c, 0xe039abab, 0x70c4aad7, 0xe231aca5, 0x72ccadd9,
    0x73c8ae5e, 0xe335af22, 0xe621a2b9, 0x76dca3c5, 0x77d8a042,
    0xe725a13e, 0x75d0a74c, 0xe52da630, 0xe429a5b7, 0x74d4a4cb,
    0x61809120, 0xf17d905c, 0xf07993db, 0x608492a7, 0xf27194d5,
    0x628c95a9, 0x6388962e, 0xf3759752, 0xf6619ac9, 0x669c9bb5,
    0x67989832, 0xf765994e, 0x65909f3c, 0xf56d9e40, 0xf4699dc7,
    0x64949cbb, 0xfe4186f1, 0x6ebc878d, 0x6fb8840a, 0xff458576,
    0x6db08304, 0xfd4d8278, 0xfc4981ff, 0x6cb48083, 0x69a08d18,
    0xf95d8c64, 0xf8598fe3, 0x68a48e9f, 0xfa5188ed, 0x6aac8991,
    0x6ba88a16, 0xfb558b6a, 0x4100e1c0, 0xd1fde0bc, 0xd0f9e33b,
    0x4004e247, 0xd2f1e435, 0x420ce549, 0x4308e6ce, 0xd3f5e7b2,
    0xd6e1ea29, 0x461ceb55, 0x4718e8d2, 0xd7e5e9ae, 0x4510efdc,
    0xd5edeea0, 0xd4e9ed27, 0x4414ec5b, 0xdec1f611, 0x4e3cf76d,
    0x4f38f4ea, 0xdfc5f596, 0x4d30f3e4, 0xddcdf298, 0xdcc9f11f,
    0x4c34f063, 0x4920fdf8, 0xd9ddfc84, 0xd8d9ff03, 0x4824fe7f,
    0xdad1f80d, 0x4a2cf971, 0x4b28faf6, 0xdbd5fb8a, 0xce81ce61,
    0x5e7ccf1d, 0x5f78cc9a, 0xcf85cde6, 0x5d70cb94, 0xcd8dcae8,
    0xcc89c96f, 0x5c74c813, 0x5960c588, 0xc99dc4f4, 0xc899c773,
    0x5864c60f, 0xca91c07d, 0x5a6cc101, 0x5b68c286, 0xcb95c3fa,
    0x5140d9b0, 0xc1bdd8cc, 0xc0b9db4b, 0x5044da37, 0xc2b1dc45,
    0x524cdd39, 0x5348debe, 0xc3b5dfc2, 0xc6a1d259, 0x565cd325,
    0x5758d0a2, 0xc7a5d1de, 0x5550d7ac, 0xc5add6d0, 0xc4a9d557,
    0x5454d42b},
   {0x00000000, 0x6c007d01, 0xd800fa02, 0xb4008703, 0x0002f407,
    0x6c028906, 0xd8020e05, 0xb4027304, 0x0005e80e, 0x6c05950f,
    0xd805120c, 0xb4056f0d, 0x00071c09, 0x6c076108, 0xd807e60b,
    0xb4079b0a, 0x000bd01c, 0x6c0bad1d, 0xd80b2a1e, 0xb40b571f,
    0x0009241b, 0x6c09591a, 0xd809de19, 0xb409a318, 0x000e3812,
    0x6c0e4513, 0xd80ec210, 0xb40ebf11, 0x000ccc15, 0x6c0cb114,
    0xd80c3617, 0xb40c4b16, 0x0017a038, 0x6c17dd39, 0xd8175a3a,
    0xb417273b, 0x0015543f, 0x6c15293e, 0xd815ae3d, 0xb415d33c,
    0x00124836, 0x6c123537, 0xd812b234, 0xb412cf35, 0x0010bc31,
    0x6c10c130, 0xd8104633, 0xb4103b32, 0x001c7024, 0x6c1c0d25,
    0xd81c8a26, 0xb41cf727, 0x001e8423, 0x6c1ef922, 0xd81e7e21,
    0xb41e0320, 0x0019982a, 0x6c19e52b, 0xd8196228, 0xb4191f29,
    0x001b6c2d, 0x6c1b112c, 0xd81b962f, 0xb41beb2e, 0x002f4070,
    0x6c2f3d71, 0xd82fba72, 0xb42fc773, 0x002db477, 0x6c2dc976,
    0xd82d4e75, 0xb42d3374, 0x002aa87e, 0x6c2ad57f, 0xd82a527c,
    0xb42a2f7d, 0x00285c79, 0x6c282178, 0xd828a67b, 0xb428db7a,
    0x0024906c, 0x6c24ed6d, 0xd8246a6e, 0xb424176f, 0x0026646b,
    0x6c26196a, 0xd8269e69, 0xb426e368, 0x00217862, 0x6c210563,
    0xd8218260, 0xb421ff61, 0x00238c65, 0x6c23f164, 0xd8237667,
    0xb4230b66, 0x0038e048, 0x6c389d49, 0xd8381a4a, 0xb438674b,
    0x003a144f, 0x6c3a694e, 0xd83aee4d, 0xb43a934c, 0x003d0846,
    0x6c3d7547, 0xd83df244, 0xb43d8f45, 0x003ffc41, 0x6c3f8140,
    0xd83f0643, 0xb43f7b42, 0x00333054, 0x6c334d55, 0xd833ca56,
    0xb433b757, 0x0031c453, 0x6c31b952, 0xd8313e51, 0xb4314350,
    0x0036d85a, 0x6c36a55b, 0xd8362258, 0xb4365f59, 0x00342c5d,
    0x6c34515c, 0xd834d65f, 0xb434ab5e, 0x005e80e0, 0x6c5efde1,
    0xd85e7ae2, 0xb45e07e3, 0x005c74e7, 0x6c5c09e6, 0xd85c8ee5,
    0xb45cf3e4, 0x005b68ee, 0x6c5b15ef, 0xd85b92ec, 0xb45befed,
    0x00599ce9, 0x6c59e1e8, 0xd85966eb, 0xb4591bea, 0x005550fc,
    0x6c552dfd, 0xd855aafe, 0xb455d7ff, 0x0057a4fb, 0x6c57d9fa,
    0xd8575ef9, 0xb45723f8, 0x0050b8f2, 0x6c50c5f3, 0xd85042f0,
    0xb4503ff1, 0x00524cf5, 0x6c5231f4, 0xd852b6f7, 0xb452cbf6,
    0x004920d8, 0x6c495dd9, 0xd849dada, 0xb449a7db, 0x004bd4df,
    0x6c4ba9de, 0xd84b2edd, 0xb44b53dc, 0x004cc8d6, 0x6c4cb5d7,
    0xd84c32d4, 0xb44c4fd5, 0x004e3cd1, 0x6c4e41d0, 0xd84ec6d3,
    0xb44ebbd2, 0x0042f0c4, 0x6c428dc5, 0xd8420ac6, 0xb44277c7,
    0x004004c3, 0x6c4079c2, 0xd840fec1, 0xb44083c0, 0x004718ca,
    0x6c4765cb, 0xd847e2c8, 0xb4479fc9, 0x0045eccd, 0x6c4591cc,
    0xd84516cf, 0xb4456bce, 0x0071c090, 0x6c71bd91, 0xd8713a92,
    0xb4714793, 0x00733497, 0x6c734996, 0xd873ce95, 0xb473b394,
    0x0074289e, 0x6c74559f, 0xd874d29c, 0xb474af9d, 0x0076dc99,
    0x6c76a198, 0xd876269b, 0xb4765b9a, 0x007a108c, 0x6c7a6d8d,
    0xd87aea8e, 0xb47a978f, 0x0078e48b, 0x6c78998a, 0xd8781e89,
    0xb4786388, 0x007ff882, 0x6c7f8583, 0xd87f0280, 0xb47f7f81,
    0x007d0c85, 0x6c7d7184, 0xd87df687, 0xb47d8b86, 0x006660a8,
    0x6c661da9, 0xd8669aaa, 0xb466e7ab, 0x006494af, 0x6c64e9ae,
    0xd8646ead, 0xb46413ac, 0x006388a6, 0x6c63f5a7, 0xd86372a4,
    0xb4630fa5, 0x00617ca1, 0x6c6101a0, 0xd86186a3, 0xb461fba2,
    0x006db0b4, 0x6c6dcdb5, 0xd86d4ab6, 0xb46d37b7, 0x006f44b3,
    0x6c6f39b2, 0xd86fbeb1, 0xb46fc3b0, 0x006858ba, 0x6c6825bb,
    0xd868a2b8, 0xb468dfb9, 0x006aacbd, 0x6c6ad1bc, 0xd86a56bf,
    0xb46a2bbe},
   {0x00000000, 0x00bd01c0, 0x017a0380, 0x01c70240, 0x02f40700,
    0x024906c0, 0x038e0480, 0x03330540, 0x05e80e00, 0x05550fc0,
    0x04920d80, 0x042f0c40, 0x071c0900, 0x07a108c0, 0x06660a80,
    0x06db0b40, 0x0bd01c00, 0x0b6d1dc0, 0x0aaa1f80, 0x0a171e40,
    0x09241b00, 0x09991ac0, 0x085e1880, 0x08e31940, 0x0e381200,
    0x0e8513c0, 0x0f421180, 0x0fff1040, 0x0ccc1500, 0x0c7114c0,
    0x0db61680, 0x0d0b1740, 0x17a03800, 0x171d39c0, 0x16da3b80,
    0x16673a40, 0x15543f00, 0x15e93ec0, 0x142e3c80, 0x14933d40,
    0x12483600, 0x12f537c0, 0x13323580, 0x138f3440, 0x10bc3100,
    0x100130c0, 0x11c63280, 0x117b3340, 0x1c702400, 0x1ccd25c0,
    0x1d0a2780, 0x1db72640, 0x1e842300, 0x1e3922c0, 0x1ffe2080,
    0x1f432140, 0x19982a00, 0x19252bc0, 0x18e22980, 0x185f2840,
    0x1b6c2d00, 0x1bd12cc0, 0x1a162e80, 0x1aab2f40, 0x2f407000,
    0x2ffd71c0, 0x2e3a7380, 0x2e877240, 0x2db47700, 0x2d0976c0,
    0x2cce7480, 0x2c737540, 0x2aa87e00, 0x2a157fc0, 0x2bd27d80,
    0x2b6f7c40, 0x285c7900, 0x28e178c0, 0x29267a80, 0x299b7b40,
    0x24906c00, 0x242d6dc0, 0x25ea6f80, 0x25576e40, 0x26646b00,
    0x26d96ac0, 0x271e6880, 0x27a36940, 0x21786200, 0x21c563c0,
    0x20026180, 0x20bf6040, 0x238c6500, 0x233164c0, 0x22f66680,
    0x224b6740, 0x38e04800, 0x385d49c0, 0x399a4b80, 0x39274a40,
    0x3a144f00, 0x3aa94ec0, 0x3b6e4c80, 0x3bd34d40, 0x3d084600,
    0x3db547c0, 0x3c724580, 0x3ccf4440, 0x3ffc4100, 0x3f4140c0,
    0x3e864280, 0x3e3b4340, 0x33305400, 0x338d55c0, 0x324a5780,
    0x32f75640, 0x31c45300, 0x317952c0, 0x30be5080, 0x30035140,
    0x36d85a00, 0x36655bc0, 0x37a25980, 0x371f5840, 0x342c5d00,
    0x34915cc0, 0x35565e80, 0x35eb5f40, 0x5e80e000, 0x5e3de1c0,
    0x5ffae380, 0x5f47e240, 0x5c74e700, 0x5cc9e6c0, 0x5d0ee480,
    0x5db3e540, 0x5b68ee00, 0x5bd5efc0, 0x5a12ed80, 0x5aafec40,
    0x599ce900, 0x5921e8c0, 0x58e6ea80, 0x585beb40, 0x5550fc00,
    0x55edfdc0, 0x542aff80, 0x5497fe40, 0x57a4fb00, 0x5719fac0,
    0x56def880, 0x5663f940, 0x50b8f200, 0x5005f3c0, 0x51c2f180,
    0x517ff040, 0x524cf500, 0x52f1f4c0, 0x5336f680, 0x538bf740,
    0x4920d800, 0x499dd9c0, 0x485adb80, 0x48e7da40, 0x4bd4df00,
    0x4b69dec0, 0x4aaedc80, 0x4a13dd40, 0x4cc8d600, 0x4c75d7c0,
    0x4db2d580, 0x4d0fd440, 0x4e3cd100, 0x4e81d0c0, 0x4f46d280,
    0x4ffbd340, 0x42f0c400, 0x424dc5c0, 0x438ac780, 0x4337c640,
    0x4004c300, 0x40b9c2c0, 0x417ec080, 0x41c3c140, 0x4718ca00,
    0x47a5cbc0, 0x4662c980, 0x46dfc840, 0x45eccd00, 0x4551ccc0,
    0x4496ce80, 0x442bcf40, 0x71c09000, 0x717d91c0, 0x70ba9380,
    0x70079240, 0x73349700, 0x738996c0, 0x724e9480, 0x72f39540,
    0x74289e00, 0x74959fc0, 0x75529d80, 0x75ef9c40, 0x76dc9900,
    0x766198c0, 0x77a69a80, 0x771b9b40, 0x7a108c00, 0x7aad8dc0,
    0x7b6a8f80, 0x7bd78e40, 0x78e48b00, 0x78598ac0, 0x799e8880,
    0x79238940, 0x7ff88200, 0x7f4583c0, 0x7e828180, 0x7e3f8040,
    0x7d0c8500, 0x7db184c0, 0x7c768680, 0x7ccb8740, 0x6660a800,
    0x66dda9c0, 0x671aab80, 0x67a7aa40, 0x6494af00, 0x6429aec0,
    0x65eeac80, 0x6553ad40, 0x6388a600, 0x6335a7c0, 0x62f2a580,
    0x624fa440, 0x617ca100, 0x61c1a0c0, 0x6006a280, 0x60bba340,
    0x6db0b400, 0x6d0db5c0, 0x6ccab780, 0x6c77b640, 0x6f44b300,
    0x6ff9b2c0, 0x6e3eb080, 0x6e83b140, 0x6858ba00, 0x68e5bbc0,
    0x6922b980, 0x699fb840, 0x6aacbd00, 0x6a11bcc0, 0x6bd6be80,
    0x6b6bbf40}};

static const word_t crc_braid_big_table[][256] = {
   {0x0000000000000000, 0xc001bd0000000000, 0x80037a0100000000,
    0x4002c70100000000, 0x0007f40200000000, 0xc006490200000000,
    0x80048e0300000000, 0x4005330300000000, 0x000ee80500000000,
    0xc00f550500000000, 0x800d920400000000, 0x400c2f0400000000,
    0x00091c0700000000, 0xc008a10700000000, 0x800a660600000000,
    0x400bdb0600000000, 0x001cd00b00000000, 0xc01d6d0b00000000,
    0x801faa0a00000000, 0x401e170a00000000, 0x001b240900000000,
    0xc01a990900000000, 0x80185e0800000000, 0x4019e30800000000,
    0x0012380e00000000, 0xc013850e00000000, 0x8011420f00000000,
    0x4010ff0f00000000, 0x0015cc0c00000000, 0xc014710c00000000,
    0x8016b60d00000000, 0x40170b0d00000000, 0x0038a01700000000,
    0xc0391d1700000000, 0x803bda1600000000, 0x403a671600000000,
    0x003f541500000000, 0xc03ee91500000000, 0x803c2e1400000000,
    0x403d931400000000, 0x0036481200000000, 0xc037f51200000000,
    0x8035321300000000, 0x40348f1300000000, 0x0031bc1000000000,
    0xc030011000000000, 0x8032c61100000000, 0x40337b1100000000,
    0x0024701c00000000, 0xc025cd1c00000000, 0x80270a1d00000000,
    0x4026b71d00000000, 0x0023841e00000000, 0xc022391e00000000,
    0x8020fe1f00000000, 0x4021431f00000000, 0x002a981900000000,
    0xc02b251900000000, 0x8029e21800000000, 0x40285f1800000000,
    0x002d6c1b00000000, 0xc02cd11b00000000, 0x802e161a00000000,
    0x402fab1a00000000, 0x0070402f00000000, 0xc071fd2f00000000,
    0x80733a2e00000000, 0x4072872e00000000, 0x0077b42d00000000,
    0xc076092d00000000, 0x8074ce2c00000000, 0x4075732c00000000,
    0x007ea82a00000000, 0xc07f152a00000000, 0x807dd22b00000000,
    0x407c6f2b00000000, 0x00795c2800000000, 0xc078e12800000000,
    0x807a262900000000, 0x407b9b2900000000, 0x006c902400000000,
    0xc06d2d2400000000, 0x806fea2500000000, 0x406e572500000000,
    0x006b642600000000, 0xc06ad92600000000, 0x80681e2700000000,
    0x4069a32700000000, 0x0062782100000000, 0xc063c52100000000,
    0x8061022000000000, 0x4060bf2000000000, 0x00658c2300000000,
    0xc064312300000000, 0x8066f62200000000, 0x40674b2200000000,
    0x0048e03800000000, 0xc0495d3800000000, 0x804b9a3900000000,
    0x404a273900000000, 0x004f143a00000000, 0xc04ea93a00000000,
    0x804c6e3b00000000, 0x404dd33b00000000, 0x0046083d00000000,
    0xc047b53d00000000, 0x8045723c00000000, 0x4044cf3c00000000,
    0x0041fc3f00000000, 0xc040413f00000000, 0x8042863e00000000,
    0x40433b3e00000000, 0x0054303300000000, 0xc0558d3300000000,
    0x80574a3200000000, 0x4056f73200000000, 0x0053c43100000000,
    0xc052793100000000, 0x8050be3000000000, 0x4051033000000000,
    0x005ad83600000000, 0xc05b653600000000, 0x8059a23700000000,
    0x40581f3700000000, 0x005d2c3400000000, 0xc05c913400000000,
    0x805e563500000000, 0x405feb3500000000, 0x00e0805e00000000,
    0xc0e13d5e00000000, 0x80e3fa5f00000000, 0x40e2475f00000000,
    0x00e7745c00000000, 0xc0e6c95c00000000, 0x80e40e5d00000000,
    0x40e5b35d00000000, 0x00ee685b00000000, 0xc0efd55b00000000,
    0x80ed125a00000000, 0x40ecaf5a00000000, 0x00e99c5900000000,
    0xc0e8215900000000, 0x80eae65800000000, 0x40eb5b5800000000,
    0x00fc505500000000, 0xc0fded5500000000, 0x80ff2a5400000000,
    0x40fe975400000000, 0x00fba45700000000, 0xc0fa195700000000,
    0x80f8de5600000000, 0x40f9635600000000, 0x00f2b85000000000,
    0xc0f3055000000000, 0x80f1c25100000000, 0x40f07f5100000000,
    0x00f54c5200000000, 0xc0f4f15200000000, 0x80f6365300000000,
    0x40f78b5300000000, 0x00d8204900000000, 0xc0d99d4900000000,
    0x80db5a4800000000, 0x40dae74800000000, 0x00dfd44b00000000,
    0xc0de694b00000000, 0x80dcae4a00000000, 0x40dd134a00000000,
    0x00d6c84c00000000, 0xc0d7754c00000000, 0x80d5b24d00000000,
    0x40d40f4d00000000, 0x00d13c4e00000000, 0xc0d0814e00000000,
    0x80d2464f00000000, 0x40d3fb4f00000000, 0x00c4f04200000000,
    0xc0c54d4200000000, 0x80c78a4300000000, 0x40c6374300000000,
    0x00c3044000000000, 0xc0c2b94000000000, 0x80c07e4100000000,
    0x40c1c34100000000, 0x00ca184700000000, 0xc0cba54700000000,
    0x80c9624600000000, 0x40c8df4600000000, 0x00cdec4500000000,
    0xc0cc514500000000, 0x80ce964400000000, 0x40cf2b4400000000,
    0x0090c07100000000, 0xc0917d7100000000, 0x8093ba7000000000,
    0x4092077000000000, 0x0097347300000000, 0xc096897300000000,
    0x80944e7200000000, 0x4095f37200000000, 0x009e287400000000,
    0xc09f957400000000, 0x809d527500000000, 0x409cef7500000000,
    0x0099dc7600000000, 0xc098617600000000, 0x809aa67700000000,
    0x409b1b7700000000, 0x008c107a00000000, 0xc08dad7a00000000,
    0x808f6a7b00000000, 0x408ed77b00000000, 0x008be47800000000,
    0xc08a597800000000, 0x80889e7900000000, 0x4089237900000000,
    0x0082f87f00000000, 0xc083457f00000000, 0x8081827e00000000,
    0x40803f7e00000000, 0x00850c7d00000000, 0xc084b17d00000000,
    0x8086767c00000000, 0x4087cb7c00000000, 0x00a8606600000000,
    0xc0a9dd6600000000, 0x80ab1a6700000000, 0x40aaa76700000000,
    0x00af946400000000, 0xc0ae296400000000, 0x80acee6500000000,
    0x40ad536500000000, 0x00a6886300000000, 0xc0a7356300000000,
    0x80a5f26200000000, 0x40a44f6200000000, 0x00a17c6100000000,
    0xc0a0c16100000000, 0x80a2066000000000, 0x40a3bb6000000000,
    0x00b4b06d00000000, 0xc0b50d6d00000000, 0x80b7ca6c00000000,
    0x40b6776c00000000, 0x00b3446f00000000, 0xc0b2f96f00000000,
    0x80b03e6e00000000, 0x40b1836e00000000, 0x00ba586800000000,
    0xc0bbe56800000000, 0x80b9226900000000, 0x40b89f6900000000,
    0x00bdac6a00000000, 0xc0bc116a00000000, 0x80bed66b00000000,
    0x40bf6b6b00000000},
   {0x0000000000000000, 0x017d006c00000000, 0x02fa00d800000000,
    0x038700b400000000, 0x07f4020000000000, 0x0689026c00000000,
    0x050e02d800000000, 0x047302b400000000, 0x0ee8050000000000,
    0x0f95056c00000000, 0x0c1205d800000000, 0x0d6f05b400000000,
    0x091c070000000000, 0x0861076c00000000, 0x0be607d800000000,
    0x0a9b07b400000000, 0x1cd00b0000000000, 0x1dad0b6c00000000,
    0x1e2a0bd800000000, 0x1f570bb400000000, 0x1b24090000000000,
    0x1a59096c00000000, 0x19de09d800000000, 0x18a309b400000000,
    0x12380e0000000000, 0x13450e6c00000000, 0x10c20ed800000000,
    0x11bf0eb400000000, 0x15cc0c0000000000, 0x14b10c6c00000000,
    0x17360cd800000000, 0x164b0cb400000000, 0x38a0170000000000,
    0x39dd176c00000000, 0x3a5a17d800000000, 0x3b2717b400000000,
    0x3f54150000000000, 0x3e29156c00000000, 0x3dae15d800000000,
    0x3cd315b400000000, 0x3648120000000000, 0x3735126c00000000,
    0x34b212d800000000, 0x35cf12b400000000, 0x31bc100000000000,
    0x30c1106c00000000, 0x334610d800000000, 0x323b10b400000000,
    0x24701c0000000000, 0x250d1c6c00000000, 0x268a1cd800000000,
    0x27f71cb400000000, 0x23841e0000000000, 0x22f91e6c00000000,
    0x217e1ed800000000, 0x20031eb400000000, 0x2a98190000000000,
    0x2be5196c00000000, 0x286219d800000000, 0x291f19b400000000,
    0x2d6c1b0000000000, 0x2c111b6c00000000, 0x2f961bd800000000,
    0x2eeb1bb400000000, 0x70402f0000000000, 0x713d2f6c00000000,
    0x72ba2fd800000000, 0x73c72fb400000000, 0x77b42d0000000000,
    0x76c92d6c00000000, 0x754e2dd800000000, 0x74332db400000000,
    0x7ea82a0000000000, 0x7fd52a6c00000000, 0x7c522ad800000000,
    0x7d2f2ab400000000, 0x795c280000000000, 0x7821286c00000000,
    0x7ba628d800000000, 0x7adb28b400000000, 0x6c90240000000000,
    0x6ded246c00000000, 0x6e6a24d800000000, 0x6f1724b400000000,
    0x6b64260000000000, 0x6a19266c00000000, 0x699e26d800000000,
    0x68e326b400000000, 0x6278210000000000, 0x6305216c00000000,
    0x608221d800000000, 0x61ff21b400000000, 0x658c230000000000,
    0x64f1236c00000000, 0x677623d800000000, 0x660b23b400000000,
    0x48e0380000000000, 0x499d386c00000000, 0x4a1a38d800000000,
    0x4b6738b400000000, 0x4f143a0000000000, 0x4e693a6c00000000,
    0x4dee3ad800000000, 0x4c933ab400000000, 0x46083d0000000000,
    0x47753d6c00000000, 0x44f23dd800000000, 0x458f3db400000000,
    0x41fc3f0000000000, 0x40813f6c00000000, 0x43063fd800000000,
    0x427b3fb400000000, 0x5430330000000000, 0x554d336c00000000,
    0x56ca33d800000000, 0x57b733b400000000, 0x53c4310000000000,
    0x52b9316c00000000, 0x513e31d800000000, 0x504331b400000000,
    0x5ad8360000000000, 0x5ba5366c00000000, 0x582236d800000000,
    0x595f36b400000000, 0x5d2c340000000000, 0x5c51346c00000000,
    0x5fd634d800000000, 0x5eab34b400000000, 0xe0805e0000000000,
    0xe1fd5e6c00000000, 0xe27a5ed800000000, 0xe3075eb400000000,
    0xe7745c0000000000, 0xe6095c6c00000000, 0xe58e5cd800000000,
    0xe4f35cb400000000, 0xee685b0000000000, 0xef155b6c00000000,
    0xec925bd800000000, 0xedef5bb400000000, 0xe99c590000000000,
    0xe8e1596c00000000, 0xeb6659d800000000, 0xea1b59b400000000,
    0xfc50550000000000, 0xfd2d556c00000000, 0xfeaa55d800000000,
    0xffd755b400000000, 0xfba4570000000000, 0xfad9576c00000000,
    0xf95e57d800000000, 0xf82357b400000000, 0xf2b8500000000000,
    0xf3c5506c00000000, 0xf04250d800000000, 0xf13f50b400000000,
    0xf54c520000000000, 0xf431526c00000000, 0xf7b652d800000000,
    0xf6cb52b400000000, 0xd820490000000000, 0xd95d496c00000000,
    0xdada49d800000000, 0xdba749b400000000, 0xdfd44b0000000000,
    0xdea94b6c00000000, 0xdd2e4bd800000000, 0xdc534bb400000000,
    0xd6c84c0000000000, 0xd7b54c6c00000000, 0xd4324cd800000000,
    0xd54f4cb400000000, 0xd13c4e0000000000, 0xd0414e6c00000000,
    0xd3c64ed800000000, 0xd2bb4eb400000000, 0xc4f0420000000000,
    0xc58d426c00000000, 0xc60a42d800000000, 0xc77742b400000000,
    0xc304400000000000, 0xc279406c00000000, 0xc1fe40d800000000,
    0xc08340b400000000, 0xca18470000000000, 0xcb65476c00000000,
    0xc8e247d800000000, 0xc99f47b400000000, 0xcdec450000000000,
    0xcc91456c00000000, 0xcf1645d800000000, 0xce6b45b400000000,
    0x90c0710000000000, 0x91bd716c00000000, 0x923a71d800000000,
    0x934771b400000000, 0x9734730000000000, 0x9649736c00000000,
    0x95ce73d800000000, 0x94b373b400000000, 0x9e28740000000000,
    0x9f55746c00000000, 0x9cd274d800000000, 0x9daf74b400000000,
    0x99dc760000000000, 0x98a1766c00000000, 0x9b2676d800000000,
    0x9a5b76b400000000, 0x8c107a0000000000, 0x8d6d7a6c00000000,
    0x8eea7ad800000000, 0x8f977ab400000000, 0x8be4780000000000,
    0x8a99786c00000000, 0x891e78d800000000, 0x886378b400000000,
    0x82f87f0000000000, 0x83857f6c00000000, 0x80027fd800000000,
    0x817f7fb400000000, 0x850c7d0000000000, 0x84717d6c00000000,
    0x87f67dd800000000, 0x868b7db400000000, 0xa860660000000000,
    0xa91d666c00000000, 0xaa9a66d800000000, 0xabe766b400000000,
    0xaf94640000000000, 0xaee9646c00000000, 0xad6e64d800000000,
    0xac1364b400000000, 0xa688630000000000, 0xa7f5636c00000000,
    0xa47263d800000000, 0xa50f63b400000000, 0xa17c610000000000,
    0xa001616c00000000, 0xa38661d800000000, 0xa2fb61b400000000,
    0xb4b06d0000000000, 0xb5cd6d6c00000000, 0xb64a6dd800000000,
    0xb7376db400000000, 0xb3446f0000000000, 0xb2396f6c00000000,
    0xb1be6fd800000000, 0xb0c36fb400000000, 0xba58680000000000,
    0xbb25686c00000000, 0xb8a268d800000000, 0xb9df68b400000000,
    0xbdac6a0000000000, 0xbcd16a6c00000000, 0xbf566ad800000000,
    0xbe2b6ab400000000},
   {0x0000000000000000, 0x7c01fd9000000000, 0xfb02f99100000000,
    0x8703040100000000, 0xf505f19300000000, 0x89040c0300000000,
    0x0e07080200000000, 0x7206f59200000000, 0xe90be19700000000,
    0x950a1c0700000000, 0x1209180600000000, 0x6e08e59600000000,
    0x1c0e100400000000, 0x600fed9400000000, 0xe70ce99500000000,
    0x9b0d140500000000, 0xd117c19f00000000, 0xad163c0f00000000,
    0x2a15380e00000000, 0x5614c59e00000000, 0x2412300c00000000,
    0x5813cd9c00000000, 0xdf10c99d00000000, 0xa311340d00000000,
    0x381c200800000000, 0x441ddd9800000000, 0xc31ed99900000000,
    0xbf1f240900000000, 0xcd19d19b00000000, 0xb1182c0b00000000,
    0x361b280a00000000, 0x4a1ad59a00000000, 0xa12f818f00000000,
    0xdd2e7c1f00000000, 0x5a2d781e00000000, 0x262c858e00000000,
    0x542a701c00000000, 0x282b8d8c00000000, 0xaf28898d00000000,
    0xd329741d00000000, 0x4824601800000000, 0x34259d8800000000,
    0xb326998900000000, 0xcf27641900000000, 0xbd21918b00000000,
    0xc1206c1b00000000, 0x4623681a00000000, 0x3a22958a00000000,
    0x7038401000000000, 0x0c39bd8000000000, 0x8b3ab98100000000,
    0xf73b441100000000, 0x853db18300000000, 0xf93c4c1300000000,
    0x7e3f481200000000, 0x023eb58200000000, 0x9933a18700000000,
    0xe5325c1700000000, 0x6231581600000000, 0x1e30a58600000000,
    0x6c36501400000000, 0x1037ad8400000000, 0x9734a98500000000,
    0xeb35541500000000, 0x415f01af00000000, 0x3d5efc3f00000000,
    0xba5df83e00000000, 0xc65c05ae00000000, 0xb45af03c00000000,
    0xc85b0dac00000000, 0x4f5809ad00000000, 0x3359f43d00000000,
    0xa854e03800000000, 0xd4551da800000000, 0x535619a900000000,
    0x2f57e43900000000, 0x5d5111ab00000000, 0x2150ec3b00000000,
    0xa653e83a00000000, 0xda5215aa00000000, 0x9048c03000000000,
    0xec493da000000000, 0x6b4a39a100000000, 0x174bc43100000000,
    0x654d31a300000000, 0x194ccc3300000000, 0x9e4fc83200000000,
    0xe24e35a200000000, 0x794321a700000000, 0x0542dc3700000000,
    0x8241d83600000000, 0xfe4025a600000000, 0x8c46d03400000000,
    0xf0472da400000000, 0x774429a500000000, 0x0b45d43500000000,
    0xe070802000000000, 0x9c717db000000000, 0x1b7279b100000000,
    0x6773842100000000, 0x157571b300000000, 0x69748c2300000000,
    0xee77882200000000, 0x927675b200000000, 0x097b61b700000000,
    0x757a9c2700000000, 0xf279982600000000, 0x8e7865b600000000,
    0xfc7e902400000000, 0x807f6db400000000, 0x077c69b500000000,
    0x7b7d942500000000, 0x316741bf00000000, 0x4d66bc2f00000000,
    0xca65b82e00000000, 0xb66445be00000000, 0xc462b02c00000000,
    0xb8634dbc00000000, 0x3f6049bd00000000, 0x4361b42d00000000,
    0xd86ca02800000000, 0xa46d5db800000000, 0x236e59b900000000,
    0x5f6fa42900000000, 0x2d6951bb00000000, 0x5168ac2b00000000,
    0xd66ba82a00000000, 0xaa6a55ba00000000, 0x81be01ee00000000,
    0xfdbffc7e00000000, 0x7abcf87f00000000, 0x06bd05ef00000000,
    0x74bbf07d00000000, 0x08ba0ded00000000, 0x8fb909ec00000000,
    0xf3b8f47c00000000, 0x68b5e07900000000, 0x14b41de900000000,
    0x93b719e800000000, 0xefb6e47800000000, 0x9db011ea00000000,
    0xe1b1ec7a00000000, 0x66b2e87b00000000, 0x1ab315eb00000000,
    0x50a9c07100000000, 0x2ca83de100000000, 0xabab39e000000000,
    0xd7aac47000000000, 0xa5ac31e200000000, 0xd9adcc7200000000,
    0x5eaec87300000000, 0x22af35e300000000, 0xb9a221e600000000,
    0xc5a3dc7600000000, 0x42a0d87700000000, 0x3ea125e700000000,
    0x4ca7d07500000000, 0x30a62de500000000, 0xb7a529e400000000,
    0xcba4d47400000000, 0x2091806100000000, 0x5c907df100000000,
    0xdb9379f000000000, 0xa792846000000000, 0xd59471f200000000,
    0xa9958c6200000000, 0x2e96886300000000, 0x529775f300000000,
    0xc99a61f600000000, 0xb59b9c6600000000, 0x3298986700000000,
    0x4e9965f700000000, 0x3c9f906500000000, 0x409e6df500000000,
    0xc79d69f400000000, 0xbb9c946400000000, 0xf18641fe00000000,
    0x8d87bc6e00000000, 0x0a84b86f00000000, 0x768545ff00000000,
    0x0483b06d00000000, 0x78824dfd00000000, 0xff8149fc00000000,
    0x8380b46c00000000, 0x188da06900000000, 0x648c5df900000000,
    0xe38f59f800000000, 0x9f8ea46800000000, 0xed8851fa00000000,
    0x9189ac6a00000000, 0x168aa86b00000000, 0x6a8b55fb00000000,
    0xc0e1004100000000, 0xbce0fdd100000000, 0x3be3f9d000000000,
    0x47e2044000000000, 0x35e4f1d200000000, 0x49e50c4200000000,
    0xcee6084300000000, 0xb2e7f5d300000000, 0x29eae1d600000000,
    0x55eb1c4600000000, 0xd2e8184700000000, 0xaee9e5d700000000,
    0xdcef104500000000, 0xa0eeedd500000000, 0x27ede9d400000000,
    0x5bec144400000000, 0x11f6c1de00000000, 0x6df73c4e00000000,
    0xeaf4384f00000000, 0x96f5c5df00000000, 0xe4f3304d00000000,
    0x98f2cddd00000000, 0x1ff1c9dc00000000, 0x63f0344c00000000,
    0xf8fd204900000000, 0x84fcddd900000000, 0x03ffd9d800000000,
    0x7ffe244800000000, 0x0df8d1da00000000, 0x71f92c4a00000000,
    0xf6fa284b00000000, 0x8afbd5db00000000, 0x61ce81ce00000000,
    0x1dcf7c5e00000000, 0x9acc785f00000000, 0xe6cd85cf00000000,
    0x94cb705d00000000, 0xe8ca8dcd00000000, 0x6fc989cc00000000,
    0x13c8745c00000000, 0x88c5605900000000, 0xf4c49dc900000000,
    0x73c799c800000000, 0x0fc6645800000000, 0x7dc091ca00000000,
    0x01c16c5a00000000, 0x86c2685b00000000, 0xfac395cb00000000,
    0xb0d9405100000000, 0xccd8bdc100000000, 0x4bdbb9c000000000,
    0x37da445000000000, 0x45dcb1c200000000, 0x39dd4c5200000000,
    0xbede485300000000, 0xc2dfb5c300000000, 0x59d2a1c600000000,
    0x25d35c5600000000, 0xa2d0585700000000, 0xded1a5c700000000,
    0xacd7505500000000, 0xd0d6adc500000000, 0x57d5a9c400000000,
    0x2bd4545400000000},
   {0x0000000000000000, 0x008151a900000000, 0x0302a0e200000000,
    0x0383f14b00000000, 0x0504437500000000, 0x058512dc00000000,
    0x0606e39700000000, 0x0687b23e00000000, 0x0a0886ea00000000,
    0x0a89d74300000000, 0x090a260800000000, 0x098b77a100000000,
    0x0f0cc59f00000000, 0x0f8d943600000000, 0x0c0e657d00000000,
    0x0c8f34d400000000, 0x17100f6500000000, 0x17915ecc00000000,
    0x1412af8700000000, 0x1493fe2e00000000, 0x12144c1000000000,
    0x12951db900000000, 0x1116ecf200000000, 0x1197bd5b00000000,
    0x1d18898f00000000, 0x1d99d82600000000, 0x1e1a296d00000000,
    0x1e9b78c400000000, 0x181ccafa00000000, 0x189d9b5300000000,
    0x1b1e6a1800000000, 0x1b9f3bb100000000, 0x2e201eca00000000,
    0x2ea14f6300000000, 0x2d22be2800000000, 0x2da3ef8100000000,
    0x2b245dbf00000000, 0x2ba50c1600000000, 0x2826fd5d00000000,
    0x28a7acf400000000, 0x2428982000000000, 0x24a9c98900000000,
    0x272a38c200000000, 0x27ab696b00000000, 0x212cdb5500000000,
    0x21ad8afc00000000, 0x222e7bb700000000, 0x22af2a1e00000000,
    0x393011af00000000, 0x39b1400600000000, 0x3a32b14d00000000,
    0x3ab3e0e400000000, 0x3c3452da00000000, 0x3cb5037300000000,
    0x3f36f23800000000, 0x3fb7a39100000000, 0x3338974500000000,
    0x33b9c6ec00000000, 0x303a37a700000000, 0x30bb660e00000000,
    0x363cd43000000000, 0x36bd859900000000, 0x353e74d200000000,
    0x35bf257b00000000, 0x5f403f2400000000, 0x5fc16e8d00000000,
    0x5c429fc600000000, 0x5cc3ce6f00000000, 0x5a447c5100000000,
    0x5ac52df800000000, 0x5946dcb300000000, 0x59c78d1a00000000,
    0x5548b9ce00000000, 0x55c9e86700000000, 0x564a192c00000000,
    0x56cb488500000000, 0x504cfabb00000000, 0x50cdab1200000000,
    0x534e5a5900000000, 0x53cf0bf000000000, 0x4850304100000000,
    0x48d161e800000000, 0x4b5290a300000000, 0x4bd3c10a00000000,
    0x4d54733400000000, 0x4dd5229d00000000, 0x4e56d3d600000000,
    0x4ed7827f00000000, 0x4258b6ab00000000, 0x42d9e70200000000,
    0x415a164900000000, 0x41db47e000000000, 0x475cf5de00000000,
    0x47dda47700000000, 0x445e553c00000000, 0x44df049500000000,
    0x716021ee00000000, 0x71e1704700000000, 0x7262810c00000000,
    0x72e3d0a500000000, 0x7464629b00000000, 0x74e5333200000000,
    0x7766c27900000000, 0x77e793d000000000, 0x7b68a70400000000,
    0x7be9f6ad00000000, 0x786a07e600000000, 0x78eb564f00000000,
    0x7e6ce47100000000, 0x7eedb5d800000000, 0x7d6e449300000000,
    0x7def153a00000000, 0x66702e8b00000000, 0x66f17f2200000000,
    0x65728e6900000000, 0x65f3dfc000000000, 0x63746dfe00000000,
    0x63f53c5700000000, 0x6076cd1c00000000, 0x60f79cb500000000,
    0x6c78a86100000000, 0x6cf9f9c800000000, 0x6f7a088300000000,
    0x6ffb592a00000000, 0x697ceb1400000000, 0x69fdbabd00000000,
    0x6a7e4bf600000000, 0x6aff1a5f00000000, 0xbe807e4800000000,
    0xbe012fe100000000, 0xbd82deaa00000000, 0xbd038f0300000000,
    0xbb843d3d00000000, 0xbb056c9400000000, 0xb8869ddf00000000,
    0xb807cc7600000000, 0xb488f8a200000000, 0xb409a90b00000000,
    0xb78a584000000000, 0xb70b09e900000000, 0xb18cbbd700000000,
    0xb10dea7e00000000, 0xb28e1b3500000000, 0xb20f4a9c00000000,
    0xa990712d00000000, 0xa911208400000000, 0xaa92d1cf00000000,
    0xaa13806600000000, 0xac94325800000000, 0xac1563f100000000,
    0xaf9692ba00000000, 0xaf17c31300000000, 0xa398f7c700000000,
    0xa319a66e00000000, 0xa09a572500000000, 0xa01b068c00000000,
    0xa69cb4b200000000, 0xa61de51b00000000, 0xa59e145000000000,
    0xa51f45f900000000, 0x90a0608200000000, 0x9021312b00000000,
    0x93a2c06000000000, 0x932391c900000000, 0x95a423f700000000,
    0x9525725e00000000, 0x96a6831500000000, 0x9627d2bc00000000,
    0x9aa8e66800000000, 0x9a29b7c100000000, 0x99aa468a00000000,
    0x992b172300000000, 0x9faca51d00000000, 0x9f2df4b400000000,
    0x9cae05ff00000000, 0x9c2f545600000000, 0x87b06fe700000000,
    0x87313e4e00000000, 0x84b2cf0500000000, 0x84339eac00000000,
    0x82b42c9200000000, 0x82357d3b00000000, 0x81b68c7000000000,
    0x8137ddd900000000, 0x8db8e90d00000000, 0x8d39b8a400000000,
    0x8eba49ef00000000, 0x8e3b184600000000, 0x88bcaa7800000000,
    0x883dfbd100000000, 0x8bbe0a9a00000000, 0x8b3f5b3300000000,
    0xe1c0416c00000000, 0xe14110c500000000, 0xe2c2e18e00000000,
    0xe243b02700000000, 0xe4c4021900000000, 0xe44553b000000000,
    0xe7c6a2fb00000000, 0xe747f35200000000, 0xebc8c78600000000,
    0xeb49962f00000000, 0xe8ca676400000000, 0xe84b36cd00000000,
    0xeecc84f300000000, 0xee4dd55a00000000, 0xedce241100000000,
    0xed4f75b800000000, 0xf6d04e0900000000, 0xf6511fa000000000,
    0xf5d2eeeb00000000, 0xf553bf4200000000, 0xf3d40d7c00000000,
    0xf3555cd500000000, 0xf0d6ad9e00000000, 0xf057fc3700000000,
    0xfcd8c8e300000000, 0xfc59994a00000000, 0xffda680100000000,
    0xff5b39a800000000, 0xf9dc8b9600000000, 0xf95dda3f00000000,
    0xfade2b7400000000, 0xfa5f7add00000000, 0xcfe05fa600000000,
    0xcf610e0f00000000, 0xcce2ff4400000000, 0xcc63aeed00000000,
    0xcae41cd300000000, 0xca654d7a00000000, 0xc9e6bc3100000000,
    0xc967ed9800000000, 0xc5e8d94c00000000, 0xc56988e500000000,
    0xc6ea79ae00000000, 0xc66b280700000000, 0xc0ec9a3900000000,
    0xc06dcb9000000000, 0xc3ee3adb00000000, 0xc36f6b7200000000,
    0xd8f050c300000000, 0xd871016a00000000, 0xdbf2f02100000000,
    0xdb73a18800000000, 0xddf413b600000000, 0xdd75421f00000000,
    0xdef6b35400000000, 0xde77e2fd00000000, 0xd2f8d62900000000,
    0xd279878000000000, 0xd1fa76cb00000000, 0xd17b276200000000,
    0xd7fc955c00000000, 0xd77dc4f500000000, 0xd4fe35be00000000,
    0xd47f641700000000},
   {0x0000000000000000, 0x8151a90000000000, 0x02a3520100000000,
    0x83f2fb0100000000, 0x0446a50200000000, 0x85170c0200000000,
    0x06e5f70300000000, 0x87b45e0300000000, 0x088c4a0500000000,
    0x89dde30500000000, 0x0a2f180400000000, 0x8b7eb10400000000,
    0x0ccaef0700000000, 0x8d9b460700000000, 0x0e69bd0600000000,
    0x8f38140600000000, 0x1018950a00000000, 0x91493c0a00000000,
    0x12bbc70b00000000, 0x93ea6e0b00000000, 0x145e300800000000,
    0x950f990800000000, 0x16fd620900000000, 0x97accb0900000000,
    0x1894df0f00000000, 0x99c5760f00000000, 0x1a378d0e00000000,
    0x9b66240e00000000, 0x1cd27a0d00000000, 0x9d83d30d00000000,
    0x1e71280c00000000, 0x9f20810c00000000, 0x20302a1500000000,
    0xa161831500000000, 0x2293781400000000, 0xa3c2d11400000000,
    0x24768f1700000000, 0xa527261700000000, 0x26d5dd1600000000,
    0xa784741600000000, 0x28bc601000000000, 0xa9edc91000000000,
    0x2a1f321100000000, 0xab4e9b1100000000, 0x2cfac51200000000,
    0xadab6c1200000000, 0x2e59971300000000, 0xaf083e1300000000,
    0x3028bf1f00000000, 0xb179161f00000000, 0x328bed1e00000000,
    0xb3da441e00000000, 0x346e1a1d00000000, 0xb53fb31d00000000,
    0x36cd481c00000000, 0xb79ce11c00000000, 0x38a4f51a00000000,
    0xb9f55c1a00000000, 0x3a07a71b00000000, 0xbb560e1b00000000,
    0x3ce2501800000000, 0xbdb3f91800000000, 0x3e41021900000000,
    0xbf10ab1900000000, 0x4060542a00000000, 0xc131fd2a00000000,
    0x42c3062b00000000, 0xc392af2b00000000, 0x4426f12800000000,
    0xc577582800000000, 0x4685a32900000000, 0xc7d40a2900000000,
    0x48ec1e2f00000000, 0xc9bdb72f00000000, 0x4a4f4c2e00000000,
    0xcb1ee52e00000000, 0x4caabb2d00000000, 0xcdfb122d00000000,
    0x4e09e92c00000000, 0xcf58402c00000000, 0x5078c12000000000,
    0xd129682000000000, 0x52db932100000000, 0xd38a3a2100000000,
    0x543e642200000000, 0xd56fcd2200000000, 0x569d362300000000,
    0xd7cc9f2300000000, 0x58f48b2500000000, 0xd9a5222500000000,
    0x5a57d92400000000, 0xdb06702400000000, 0x5cb22e2700000000,
    0xdde3872700000000, 0x5e117c2600000000, 0xdf40d52600000000,
    0x60507e3f00000000, 0xe101d73f00000000, 0x62f32c3e00000000,
    0xe3a2853e00000000, 0x6416db3d00000000, 0xe547723d00000000,
    0x66b5893c00000000, 0xe7e4203c00000000, 0x68dc343a00000000,
    0xe98d9d3a00000000, 0x6a7f663b00000000, 0xeb2ecf3b00000000,
    0x6c9a913800000000, 0xedcb383800000000, 0x6e39c33900000000,
    0xef686a3900000000, 0x7048eb3500000000, 0xf119423500000000,
    0x72ebb93400000000, 0xf3ba103400000000, 0x740e4e3700000000,
    0xf55fe73700000000, 0x76ad1c3600000000, 0xf7fcb53600000000,
    0x78c4a13000000000, 0xf995083000000000, 0x7a67f33100000000,
    0xfb365a3100000000, 0x7c82043200000000, 0xfdd3ad3200000000,
    0x7e21563300000000, 0xff70ff3300000000, 0x80c0a85400000000,
    0x0191015400000000, 0x8263fa5500000000, 0x0332535500000000,
    0x84860d5600000000, 0x05d7a45600000000, 0x86255f5700000000,
    0x0774f65700000000, 0x884ce25100000000, 0x091d4b5100000000,
    0x8aefb05000000000, 0x0bbe195000000000, 0x8c0a475300000000,
    0x0d5bee5300000000, 0x8ea9155200000000, 0x0ff8bc5200000000,
    0x90d83d5e00000000, 0x1189945e00000000, 0x927b6f5f00000000,
    0x132ac65f00000000, 0x949e985c00000000, 0x15cf315c00000000,
    0x963dca5d00000000, 0x176c635d00000000, 0x9854775b00000000,
    0x1905de5b00000000, 0x9af7255a00000000, 0x1ba68c5a00000000,
    0x9c12d25900000000, 0x1d437b5900000000, 0x9eb1805800000000,
    0x1fe0295800000000, 0xa0f0824100000000, 0x21a12b4100000000,
    0xa253d04000000000, 0x2302794000000000, 0xa4b6274300000000,
    0x25e78e4300000000, 0xa615754200000000, 0x2744dc4200000000,
    0xa87cc84400000000, 0x292d614400000000, 0xaadf9a4500000000,
    0x2b8e334500000000, 0xac3a6d4600000000, 0x2d6bc44600000000,
    0xae993f4700000000, 0x2fc8964700000000, 0xb0e8174b00000000,
    0x31b9be4b00000000, 0xb24b454a00000000, 0x331aec4a00000000,
    0xb4aeb24900000000, 0x35ff1b4900000000, 0xb60de04800000000,
    0x375c494800000000, 0xb8645d4e00000000, 0x3935f44e00000000,
    0xbac70f4f00000000, 0x3b96a64f00000000, 0xbc22f84c00000000,
    0x3d73514c00000000, 0xbe81aa4d00000000, 0x3fd0034d00000000,
    0xc0a0fc7e00000000, 0x41f1557e00000000, 0xc203ae7f00000000,
    0x4352077f00000000, 0xc4e6597c00000000, 0x45b7f07c00000000,
    0xc6450b7d00000000, 0x4714a27d00000000, 0xc82cb67b00000000,
    0x497d1f7b00000000, 0xca8fe47a00000000, 0x4bde4d7a00000000,
    0xcc6a137900000000, 0x4d3bba7900000000, 0xcec9417800000000,
    0x4f98e87800000000, 0xd0b8697400000000, 0x51e9c07400000000,
    0xd21b3b7500000000, 0x534a927500000000, 0xd4fecc7600000000,
    0x55af657600000000, 0xd65d9e7700000000, 0x570c377700000000,
    0xd834237100000000, 0x59658a7100000000, 0xda97717000000000,
    0x5bc6d87000000000, 0xdc72867300000000, 0x5d232f7300000000,
    0xded1d47200000000, 0x5f807d7200000000, 0xe090d66b00000000,
    0x61c17f6b00000000, 0xe233846a00000000, 0x63622d6a00000000,
    0xe4d6736900000000, 0x6587da6900000000, 0xe675216800000000,
    0x6724886800000000, 0xe81c9c6e00000000, 0x694d356e00000000,
    0xeabfce6f00000000, 0x6bee676f00000000, 0xec5a396c00000000,
    0x6d0b906c00000000, 0xeef96b6d00000000, 0x6fa8c26d00000000,
    0xf088436100000000, 0x71d9ea6100000000, 0xf22b116000000000,
    0x737ab86000000000, 0xf4cee66300000000, 0x759f4f6300000000,
    0xf66db46200000000, 0x773c1d6200000000, 0xf804096400000000,
    0x7955a06400000000, 0xfaa75b6500000000, 0x7bf6f26500000000,
    0xfc42ac6600000000, 0x7d13056600000000, 0xfee1fe6700000000,
    0x7fb0576700000000},
   {0x0000000000000000, 0x5128904800000000, 0xa250209100000000,
    0xf378b0d900000000, 0x47a1439200000000, 0x1689d3da00000000,
    0xe5f1630300000000, 0xb4d9f34b00000000, 0x8d42849400000000,
    0xdc6a14dc00000000, 0x2f12a40500000000, 0x7e3a344d00000000,
    0xcae3c70600000000, 0x9bcb574e00000000, 0x68b3e79700000000,
    0x399b77df00000000, 0x19850b9900000000, 0x48ad9bd100000000,
    0xbbd52b0800000000, 0xeafdbb4000000000, 0x5e24480b00000000,
    0x0f0cd84300000000, 0xfc74689a00000000, 0xad5cf8d200000000,
    0x94c78f0d00000000, 0xc5ef1f4500000000, 0x3697af9c00000000,
    0x67bf3fd400000000, 0xd366cc9f00000000, 0x824e5cd700000000,
    0x7136ec0e00000000, 0x201e7c4600000000, 0x310a148200000000,
    0x602284ca00000000, 0x935a341300000000, 0xc272a45b00000000,
    0x76ab571000000000, 0x2783c75800000000, 0xd4fb778100000000,
    0x85d3e7c900000000, 0xbc48901600000000, 0xed60005e00000000,
    0x1e18b08700000000, 0x4f3020cf00000000, 0xfbe9d38400000000,
    0xaac143cc00000000, 0x59b9f31500000000, 0x0891635d00000000,
    0x288f1f1b00000000, 0x79a78f5300000000, 0x8adf3f8a00000000,
    0xdbf7afc200000000, 0x6f2e5c8900000000, 0x3e06ccc100000000,
    0xcd7e7c1800000000, 0x9c56ec5000000000, 0xa5cd9b8f00000000,
    0xf4e50bc700000000, 0x079dbb1e00000000, 0x56b52b5600000000,
    0xe26cd81d00000000, 0xb344485500000000, 0x403cf88c00000000,
    0x111468c400000000, 0x61142bb400000000, 0x303cbbfc00000000,
    0xc3440b2500000000, 0x926c9b6d00000000, 0x26b5682600000000,
    0x779df86e00000000, 0x84e548b700000000, 0xd5cdd8ff00000000,
    0xec56af2000000000, 0xbd7e3f6800000000, 0x4e068fb100000000,
    0x1f2e1ff900000000, 0xabf7ecb200000000, 0xfadf7cfa00000000,
    0x09a7cc2300000000, 0x588f5c6b00000000, 0x7891202d00000000,
    0x29b9b06500000000, 0xdac100bc00000000, 0x8be990f400000000,
    0x3f3063bf00000000, 0x6e18f3f700000000, 0x9d60432e00000000,
    0xcc48d36600000000, 0xf5d3a4b900000000, 0xa4fb34f100000000,
    0x5783842800000000, 0x06ab146000000000, 0xb272e72b00000000,
    0xe35a776300000000, 0x1022c7ba00000000, 0x410a57f200000000,
    0x501e3f3600000000, 0x0136af7e00000000, 0xf24e1fa700000000,
    0xa3668fef00000000, 0x17bf7ca400000000, 0x4697ecec00000000,
    0xb5ef5c3500000000, 0xe4c7cc7d00000000, 0xdd5cbba200000000,
    0x8c742bea00000000, 0x7f0c9b3300000000, 0x2e240b7b00000000,
    0x9afdf83000000000, 0xcbd5687800000000, 0x38add8a100000000,
    0x698548e900000000, 0x499b34af00000000, 0x18b3a4e700000000,
    0xebcb143e00000000, 0xbae3847600000000, 0x0e3a773d00000000,
    0x5f12e77500000000, 0xac6a57ac00000000, 0xfd42c7e400000000,
    0xc4d9b03b00000000, 0x95f1207300000000, 0x668990aa00000000,
    0x37a100e200000000, 0x8378f3a900000000, 0xd25063e100000000,
    0x2128d33800000000, 0x7000437000000000, 0xc12855d800000000,
    0x9000c59000000000, 0x6378754900000000, 0x3250e50100000000,
    0x8689164a00000000, 0xd7a1860200000000, 0x24d936db00000000,
    0x75f1a69300000000, 0x4c6ad14c00000000, 0x1d42410400000000,
    0xee3af1dd00000000, 0xbf12619500000000, 0x0bcb92de00000000,
    0x5ae3029600000000, 0xa99bb24f00000000, 0xf8b3220700000000,
    0xd8ad5e4100000000, 0x8985ce0900000000, 0x7afd7ed000000000,
    0x2bd5ee9800000000, 0x9f0c1dd300000000, 0xce248d9b00000000,
    0x3d5c3d4200000000, 0x6c74ad0a00000000, 0x55efdad500000000,
    0x04c74a9d00000000, 0xf7bffa4400000000, 0xa6976a0c00000000,
    0x124e994700000000, 0x4366090f00000000, 0xb01eb9d600000000,
    0xe136299e00000000, 0xf022415a00000000, 0xa10ad11200000000,
    0x527261cb00000000, 0x035af18300000000, 0xb78302c800000000,
    0xe6ab928000000000, 0x15d3225900000000, 0x44fbb21100000000,
    0x7d60c5ce00000000, 0x2c48558600000000, 0xdf30e55f00000000,
    0x8e18751700000000, 0x3ac1865c00000000, 0x6be9161400000000,
    0x9891a6cd00000000, 0xc9b9368500000000, 0xe9a74ac300000000,
    0xb88fda8b00000000, 0x4bf76a5200000000, 0x1adffa1a00000000,
    0xae06095100000000, 0xff2e991900000000, 0x0c5629c000000000,
    0x5d7eb98800000000, 0x64e5ce5700000000, 0x35cd5e1f00000000,
    0xc6b5eec600000000, 0x979d7e8e00000000, 0x23448dc500000000,
    0x726c1d8d00000000, 0x8114ad5400000000, 0xd03c3d1c00000000,
    0xa03c7e6c00000000, 0xf114ee2400000000, 0x026c5efd00000000,
    0x5344ceb500000000, 0xe79d3dfe00000000, 0xb6b5adb600000000,
    0x45cd1d6f00000000, 0x14e58d2700000000, 0x2d7efaf800000000,
    0x7c566ab000000000, 0x8f2eda6900000000, 0xde064a2100000000,
    0x6adfb96a00000000, 0x3bf7292200000000, 0xc88f99fb00000000,
    0x99a709b300000000, 0xb9b975f500000000, 0xe891e5bd00000000,
    0x1be9556400000000, 0x4ac1c52c00000000, 0xfe18366700000000,
    0xaf30a62f00000000, 0x5c4816f600000000, 0x0d6086be00000000,
    0x34fbf16100000000, 0x65d3612900000000, 0x96abd1f000000000,
    0xc78341b800000000, 0x735ab2f300000000, 0x227222bb00000000,
    0xd10a926200000000, 0x8022022a00000000, 0x91366aee00000000,
    0xc01efaa600000000, 0x33664a7f00000000, 0x624eda3700000000,
    0xd697297c00000000, 0x87bfb93400000000, 0x74c709ed00000000,
    0x25ef99a500000000, 0x1c74ee7a00000000, 0x4d5c7e3200000000,
    0xbe24ceeb00000000, 0xef0c5ea300000000, 0x5bd5ade800000000,
    0x0afd3da000000000, 0xf9858d7900000000, 0xa8ad1d3100000000,
    0x88b3617700000000, 0xd99bf13f00000000, 0x2ae341e600000000,
    0x7bcbd1ae00000000, 0xcf1222e500000000, 0x9e3ab2ad00000000,
    0x6d42027400000000, 0x3c6a923c00000000, 0x05f1e5e300000000,
    0x54d975ab00000000, 0xa7a1c57200000000, 0xf689553a00000000,
    0x4250a67100000000, 0x1378363900000000, 0xe00086e000000000,
    0xb12816a800000000},
   {0x0000000000000000, 0x29c1d9bd00000000, 0x5182b0cb00000000,
    0x7843697600000000, 0xa104622700000000, 0x88c5bb9a00000000,
    0xf086d2ec00000000, 0xd9470b5100000000, 0x4209c44e00000000,
    0x6bc81df300000000, 0x138b748500000000, 0x3a4aad3800000000,
    0xe30da66900000000, 0xcacc7fd400000000, 0xb28f16a200000000,
    0x9b4ecf1f00000000, 0x8412889d00000000, 0xadd3512000000000,
    0xd590385600000000, 0xfc51e1eb00000000, 0x2516eaba00000000,
    0x0cd7330700000000, 0x74945a7100000000, 0x5d5583cc00000000,
    0xc61b4cd300000000, 0xefda956e00000000, 0x9799fc1800000000,
    0xbe5825a500000000, 0x671f2ef400000000, 0x4edef74900000000,
    0x369d9e3f00000000, 0x1f5c478200000000, 0x0b25138b00000000,
    0x22e4ca3600000000, 0x5aa7a34000000000, 0x73667afd00000000,
    0xaa2171ac00000000, 0x83e0a81100000000, 0xfba3c16700000000,
    0xd26218da00000000, 0x492cd7c500000000, 0x60ed0e7800000000,
    0x18ae670e00000000, 0x316fbeb300000000, 0xe828b5e200000000,
    0xc1e96c5f00000000, 0xb9aa052900000000, 0x906bdc9400000000,
    0x8f379b1600000000, 0xa6f642ab00000000, 0xdeb52bdd00000000,
    0xf774f26000000000, 0x2e33f93100000000, 0x07f2208c00000000,
    0x7fb149fa00000000, 0x5670904700000000, 0xcd3e5f5800000000,
    0xe4ff86e500000000, 0x9cbcef9300000000, 0xb57d362e00000000,
    0x6c3a3d7f00000000, 0x45fbe4c200000000, 0x3db88db400000000,
    0x1479540900000000, 0x154a25a600000000, 0x3c8bfc1b00000000,
    0x44c8956d00000000, 0x6d094cd000000000, 0xb44e478100000000,
    0x9d8f9e3c00000000, 0xe5ccf74a00000000, 0xcc0d2ef700000000,
    0x5743e1e800000000, 0x7e82385500000000, 0x06c1512300000000,
    0x2f00889e00000000, 0xf64783cf00000000, 0xdf865a7200000000,
    0xa7c5330400000000, 0x8e04eab900000000, 0x9158ad3b00000000,
    0xb899748600000000, 0xc0da1df000000000, 0xe91bc44d00000000,
    0x305ccf1c00000000, 0x199d16a100000000, 0x61de7fd700000000,
    0x481fa66a00000000, 0xd351697500000000, 0xfa90b0c800000000,
    0x82d3d9be00000000, 0xab12000300000000, 0x72550b5200000000,
    0x5b94d2ef00000000, 0x23d7bb9900000000, 0x0a16622400000000,
    0x1e6f362d00000000, 0x37aeef9000000000, 0x4fed86e600000000,
    0x662c5f5b00000000, 0xbf6b540a00000000, 0x96aa8db700000000,
    0xeee9e4c100000000, 0xc7283d7c00000000, 0x5c66f26300000000,
    0x75a72bde00000000, 0x0de442a800000000, 0x24259b1500000000,
    0xfd62904400000000, 0xd4a349f900000000, 0xace0208f00000000,
    0x8521f93200000000, 0x9a7dbeb000000000, 0xb3bc670d00000000,
    0xcbff0e7b00000000, 0xe23ed7c600000000, 0x3b79dc9700000000,
    0x12b8052a00000000, 0x6afb6c5c00000000, 0x433ab5e100000000,
    0xd8747afe00000000, 0xf1b5a34300000000, 0x89f6ca3500000000,
    0xa037138800000000, 0x797018d900000000, 0x50b1c16400000000,
    0x28f2a81200000000, 0x013371af00000000, 0x299449fc00000000,
    0x0055904100000000, 0x7816f93700000000, 0x51d7208a00000000,
    0x88902bdb00000000, 0xa151f26600000000, 0xd9129b1000000000,
    0xf0d342ad00000000, 0x6b9d8db200000000, 0x425c540f00000000,
    0x3a1f3d7900000000, 0x13dee4c400000000, 0xca99ef9500000000,
    0xe358362800000000, 0x9b1b5f5e00000000, 0xb2da86e300000000,
    0xad86c16100000000, 0x844718dc00000000, 0xfc0471aa00000000,
    0xd5c5a81700000000, 0x0c82a34600000000, 0x25437afb00000000,
    0x5d00138d00000000, 0x74c1ca3000000000, 0xef8f052f00000000,
    0xc64edc9200000000, 0xbe0db5e400000000, 0x97cc6c5900000000,
    0x4e8b670800000000, 0x674abeb500000000, 0x1f09d7c300000000,
    0x36c80e7e00000000, 0x22b15a7700000000, 0x0b7083ca00000000,
    0x7333eabc00000000, 0x5af2330100000000, 0x83b5385000000000,
    0xaa74e1ed00000000, 0xd237889b00000000, 0xfbf6512600000000,
    0x60b89e3900000000, 0x4979478400000000, 0x313a2ef200000000,
    0x18fbf74f00000000, 0xc1bcfc1e00000000, 0xe87d25a300000000,
    0x903e4cd500000000, 0xb9ff956800000000, 0xa6a3d2ea00000000,
    0x8f620b5700000000, 0xf721622100000000, 0xdee0bb9c00000000,
    0x07a7b0cd00000000, 0x2e66697000000000, 0x5625000600000000,
    0x7fe4d9bb00000000, 0xe4aa16a400000000, 0xcd6bcf1900000000,
    0xb528a66f00000000, 0x9ce97fd200000000, 0x45ae748300000000,
    0x6c6fad3e00000000, 0x142cc44800000000, 0x3ded1df500000000,
    0x3cde6c5a00000000, 0x151fb5e700000000, 0x6d5cdc9100000000,
    0x449d052c00000000, 0x9dda0e7d00000000, 0xb41bd7c000000000,
    0xcc58beb600000000, 0xe599670b00000000, 0x7ed7a81400000000,
    0x571671a900000000, 0x2f5518df00000000, 0x0694c16200000000,
    0xdfd3ca3300000000, 0xf612138e00000000, 0x8e517af800000000,
    0xa790a34500000000, 0xb8cce4c700000000, 0x910d3d7a00000000,
    0xe94e540c00000000, 0xc08f8db100000000, 0x19c886e000000000,
    0x30095f5d00000000, 0x484a362b00000000, 0x618bef9600000000,
    0xfac5208900000000, 0xd304f93400000000, 0xab47904200000000,
    0x828649ff00000000, 0x5bc142ae00000000, 0x72009b1300000000,
    0x0a43f26500000000, 0x23822bd800000000, 0x37fb7fd100000000,
    0x1e3aa66c00000000, 0x6679cf1a00000000, 0x4fb816a700000000,
    0x96ff1df600000000, 0xbf3ec44b00000000, 0xc77dad3d00000000,
    0xeebc748000000000, 0x75f2bb9f00000000, 0x5c33622200000000,
    0x24700b5400000000, 0x0db1d2e900000000, 0xd4f6d9b800000000,
    0xfd37000500000000, 0x8574697300000000, 0xacb5b0ce00000000,
    0xb3e9f74c00000000, 0x9a282ef100000000, 0xe26b478700000000,
    0xcbaa9e3a00000000, 0x12ed956b00000000, 0x3b2c4cd600000000,
    0x436f25a000000000, 0x6aaefc1d00000000, 0xf1e0330200000000,
    0xd821eabf00000000, 0xa06283c900000000, 0x89a35a7400000000,
    0x50e4512500000000, 0x7925889800000000, 0x0166e1ee00000000,
    0x28a7385300000000},
   {0x0000000000000000, 0xc0f0ac8600000000, 0x83e15abd00000000,
    0x4311f63b00000000, 0x05c3b6ca00000000, 0xc5331a4c00000000,
    0x8622ec7700000000, 0x46d240f100000000, 0x09866e2500000000,
    0xc976c2a300000000, 0x8a67349800000000, 0x4a97981e00000000,
    0x0c45d8ef00000000, 0xccb5746900000000, 0x8fa4825200000000,
    0x4f542ed400000000, 0x120cdd4a00000000, 0xd2fc71cc00000000,
    0x91ed87f700000000, 0x511d2b7100000000, 0x17cf6b8000000000,
    0xd73fc70600000000, 0x942e313d00000000, 0x54de9dbb00000000,
    0x1b8ab36f00000000, 0xdb7a1fe900000000, 0x986be9d200000000,
    0x589b455400000000, 0x1e4905a500000000, 0xdeb9a92300000000,
    0x9da85f1800000000, 0x5d58f39e00000000, 0x2418ba9500000000,
    0xe4e8161300000000, 0xa7f9e02800000000, 0x67094cae00000000,
    0x21db0c5f00000000, 0xe12ba0d900000000, 0xa23a56e200000000,
    0x62cafa6400000000, 0x2d9ed4b000000000, 0xed6e783600000000,
    0xae7f8e0d00000000, 0x6e8f228b00000000, 0x285d627a00000000,
    0xe8adcefc00000000, 0xabbc38c700000000, 0x6b4c944100000000,
    0x361467df00000000, 0xf6e4cb5900000000, 0xb5f53d6200000000,
    0x750591e400000000, 0x33d7d11500000000, 0xf3277d9300000000,
    0xb0368ba800000000, 0x70c6272e00000000, 0x3f9209fa00000000,
    0xff62a57c00000000, 0xbc73534700000000, 0x7c83ffc100000000,
    0x3a51bf3000000000, 0xfaa113b600000000, 0xb9b0e58d00000000,
    0x7940490b00000000, 0x4b30779b00000000, 0x8bc0db1d00000000,
    0xc8d12d2600000000, 0x082181a000000000, 0x4ef3c15100000000,
    0x8e036dd700000000, 0xcd129bec00000000, 0x0de2376a00000000,
    0x42b619be00000000, 0x8246b53800000000, 0xc157430300000000,
    0x01a7ef8500000000, 0x4775af7400000000, 0x878503f200000000,
    0xc494f5c900000000, 0x0464594f00000000, 0x593caad100000000,
    0x99cc065700000000, 0xdaddf06c00000000, 0x1a2d5cea00000000,
    0x5cff1c1b00000000, 0x9c0fb09d00000000, 0xdf1e46a600000000,
    0x1feeea2000000000, 0x50bac4f400000000, 0x904a687200000000,
    0xd35b9e4900000000, 0x13ab32cf00000000, 0x5579723e00000000,
    0x9589deb800000000, 0xd698288300000000, 0x1668840500000000,
    0x6f28cd0e00000000, 0xafd8618800000000, 0xecc997b300000000,
    0x2c393b3500000000, 0x6aeb7bc400000000, 0xaa1bd74200000000,
    0xe90a217900000000, 0x29fa8dff00000000, 0x66aea32b00000000,
    0xa65e0fad00000000, 0xe54ff99600000000, 0x25bf551000000000,
    0x636d15e100000000, 0xa39db96700000000, 0xe08c4f5c00000000,
    0x207ce3da00000000, 0x7d24104400000000, 0xbdd4bcc200000000,
    0xfec54af900000000, 0x3e35e67f00000000, 0x78e7a68e00000000,
    0xb8170a0800000000, 0xfb06fc3300000000, 0x3bf650b500000000,
    0x74a27e6100000000, 0xb452d2e700000000, 0xf74324dc00000000,
    0x37b3885a00000000, 0x7161c8ab00000000, 0xb191642d00000000,
    0xf280921600000000, 0x32703e9000000000, 0x9560ed8600000000,
    0x5590410000000000, 0x1681b73b00000000, 0xd6711bbd00000000,
    0x90a35b4c00000000, 0x5053f7ca00000000, 0x134201f100000000,
    0xd3b2ad7700000000, 0x9ce683a300000000, 0x5c162f2500000000,
    0x1f07d91e00000000, 0xdff7759800000000, 0x9925356900000000,
    0x59d599ef00000000, 0x1ac46fd400000000, 0xda34c35200000000,
    0x876c30cc00000000, 0x479c9c4a00000000, 0x048d6a7100000000,
    0xc47dc6f700000000, 0x82af860600000000, 0x425f2a8000000000,
    0x014edcbb00000000, 0xc1be703d00000000, 0x8eea5ee900000000,
    0x4e1af26f00000000, 0x0d0b045400000000, 0xcdfba8d200000000,
    0x8b29e82300000000, 0x4bd944a500000000, 0x08c8b29e00000000,
    0xc8381e1800000000, 0xb178571300000000, 0x7188fb9500000000,
    0x32990dae00000000, 0xf269a12800000000, 0xb4bbe1d900000000,
    0x744b4d5f00000000, 0x375abb6400000000, 0xf7aa17e200000000,
    0xb8fe393600000000, 0x780e95b000000000, 0x3b1f638b00000000,
    0xfbefcf0d00000000, 0xbd3d8ffc00000000, 0x7dcd237a00000000,
    0x3edcd54100000000, 0xfe2c79c700000000, 0xa3748a5900000000,
    0x638426df00000000, 0x2095d0e400000000, 0xe0657c6200000000,
    0xa6b73c9300000000, 0x6647901500000000, 0x2556662e00000000,
    0xe5a6caa800000000, 0xaaf2e47c00000000, 0x6a0248fa00000000,
    0x2913bec100000000, 0xe9e3124700000000, 0xaf3152b600000000,
    0x6fc1fe3000000000, 0x2cd0080b00000000, 0xec20a48d00000000,
    0xde509a1d00000000, 0x1ea0369b00000000, 0x5db1c0a000000000,
    0x9d416c2600000000, 0xdb932cd700000000, 0x1b63805100000000,
    0x5872766a00000000, 0x9882daec00000000, 0xd7d6f43800000000,
    0x172658be00000000, 0x5437ae8500000000, 0x94c7020300000000,
    0xd21542f200000000, 0x12e5ee7400000000, 0x51f4184f00000000,
    0x9104b4c900000000, 0xcc5c475700000000, 0x0cacebd100000000,
    0x4fbd1dea00000000, 0x8f4db16c00000000, 0xc99ff19d00000000,
    0x096f5d1b00000000, 0x4a7eab2000000000, 0x8a8e07a600000000,
    0xc5da297200000000, 0x052a85f400000000, 0x463b73cf00000000,
    0x86cbdf4900000000, 0xc0199fb800000000, 0x00e9333e00000000,
    0x43f8c50500000000, 0x8308698300000000, 0xfa48208800000000,
    0x3ab88c0e00000000, 0x79a97a3500000000, 0xb959d6b300000000,
    0xff8b964200000000, 0x3f7b3ac400000000, 0x7c6accff00000000,
    0xbc9a607900000000, 0xf3ce4ead00000000, 0x333ee22b00000000,
    0x702f141000000000, 0xb0dfb89600000000, 0xf60df86700000000,
    0x36fd54e100000000, 0x75eca2da00000000, 0xb51c0e5c00000000,
    0xe844fdc200000000, 0x28b4514400000000, 0x6ba5a77f00000000,
    0xab550bf900000000, 0xed874b0800000000, 0x2d77e78e00000000,
    0x6e6611b500000000, 0xae96bd3300000000, 0xe1c293e700000000,
    0x21323f6100000000, 0x6223c95a00000000, 0xa2d365dc00000000,
    0xe401252d00000000, 0x24f189ab00000000, 0x67e07f9000000000,
    0xa710d31600000000}};

#else /* W == 4 */

static const crc_t crc_braid_table[][256] = {
   {0x00000000, 0x5c11c100, 0xb8238200, 0xe4324300, 0xc0440403,
    0x9c55c503, 0x78678603, 0x24764703, 0x308b0805, 0x6c9ac905,
    0x88a88a05, 0xd4b94b05, 0xf0cf0c06, 0xacdecd06, 0x48ec8e06,
    0x14fd4f06, 0x6116100a, 0x3d07d10a, 0xd935920a, 0x8524530a,
    0xa1521409, 0xfd43d509, 0x19719609, 0x45605709, 0x519d180f,
    0x0d8cd90f, 0xe9be9a0f, 0xb5af5b0f, 0x91d91c0c, 0xcdc8dd0c,
    0x29fa9e0c, 0x75eb5f0c, 0xc22c2014, 0x9e3de114, 0x7a0fa214,
    0x261e6314, 0x02682417, 0x5e79e517, 0xba4ba617, 0xe65a6717,
    0xf2a72811, 0xaeb6e911, 0x4a84aa11, 0x16956b11, 0x32e32c12,
    0x6ef2ed12, 0x8ac0ae12, 0xd6d16f12, 0xa33a301e, 0xff2bf11e,
    0x1b19b21e, 0x4708731e, 0x637e341d, 0x3f6ff51d, 0xdb5db61d,
    0x874c771d, 0x93b1381b, 0xcfa0f91b, 0x2b92ba1b, 0x77837b1b,
    0x53f53c18, 0x0fe4fd18, 0xebd6be18, 0xb7c77f18, 0x345b402b,
    0x684a812b, 0x8c78c22b, 0xd069032b, 0xf41f4428, 0xa80e8528,
    0x4c3cc628, 0x102d0728, 0x04d0482e, 0x58c1892e, 0xbcf3ca2e,
    0xe0e20b2e, 0xc4944c2d, 0x98858d2d, 0x7cb7ce2d, 0x20a60f2d,
    0x554d5021, 0x095c9121, 0xed6ed221, 0xb17f1321, 0x95095422,
    0xc9189522, 0x2d2ad622, 0x713b1722, 0x65c65824, 0x39d79924,
    0xdde5da24, 0x81f41b24, 0xa5825c27, 0xf9939d27, 0x1da1de27,
    0x41b01f27, 0xf677603f, 0xaa66a13f, 0x4e54e23f, 0x1245233f,
    0x3633643c, 0x6a22a53c, 0x8e10e63c, 0xd201273c, 0xc6fc683a,
    0x9aeda93a, 0x7edfea3a, 0x22ce2b3a, 0x06b86c39, 0x5aa9ad39,
    0xbe9bee39, 0xe28a2f39, 0x97617035, 0xcb70b135, 0x2f42f235,
    0x73533335, 0x57257436, 0x0b34b536, 0xef06f636, 0xb3173736,
    0xa7ea7830, 0xfbfbb930, 0x1fc9fa30, 0x43d83b30, 0x67ae7c33,
    0x3bbfbd33, 0xdf8dfe33, 0x839c3f33, 0x68b68056, 0x34a74156,
    0xd0950256, 0x8c84c356, 0xa8f28455, 0xf4e34555, 0x10d10655,
    0x4cc0c755, 0x583d8853, 0x042c4953, 0xe01e0a53, 0xbc0fcb53,
    0x98798c50, 0xc4684d50, 0x205a0e50, 0x7c4bcf50, 0x09a0905c,
    0x55b1515c, 0xb183125c, 0xed92d35c, 0xc9e4945f, 0x95f5555f,
    0x71c7165f, 0x2dd6d75f, 0x392b9859, 0x653a5959, 0x81081a59,
    0xdd19db59, 0xf96f9c5a, 0xa57e5d5a, 0x414c1e5a, 0x1d5ddf5a,
    0xaa9aa042, 0xf68b6142, 0x12b92242, 0x4ea8e342, 0x6adea441,
    0x36cf6541, 0xd2fd2641, 0x8eece741, 0x9a11a847, 0xc6006947,
    0x22322a47, 0x7e23eb47, 0x5a55ac44, 0x06446d44, 0xe2762e44,
    0xbe67ef44, 0xcb8cb048, 0x979d7148, 0x73af3248, 0x2fbef348,
    0x0bc8b44b, 0x57d9754b, 0xb3eb364b, 0xeffaf74b, 0xfb07b84d,
    0xa716794d, 0x43243a4d, 0x1f35fb4d, 0x3b43bc4e, 0x67527d4e,
    0x83603e4e, 0xdf71ff4e, 0x5cedc07d, 0x00fc017d, 0xe4ce427d,
    0xb8df837d, 0x9ca9c47e, 0xc0b8057e, 0x248a467e, 0x789b877e,
    0x6c66c878, 0x30770978, 0xd4454a78, 0x88548b78, 0xac22cc7b,
    0xf0330d7b, 0x14014e7b, 0x48108f7b, 0x3dfbd077, 0x61ea1177,
    0x85d85277, 0xd9c99377, 0xfdbfd474, 0xa1ae1574, 0x459c5674,
    0x198d9774, 0x0d70d872, 0x51611972, 0xb5535a72, 0xe9429b72,
    0xcd34dc71, 0x91251d71, 0x75175e71, 0x29069f71, 0x9ec1e069,
    0xc2d02169, 0x26e26269, 0x7af3a369, 0x5e85e46a, 0x0294256a,
    0xe6a6666a, 0xbab7a76a, 0xae4ae86c, 0xf25b296c, 0x16696a6c,
    0x4a78ab6c, 0x6e0eec6f, 0x321f2d6f, 0xd62d6e6f, 0x8a3caf6f,
    0xffd7f063, 0xa3c63163, 0x47f47263, 0x1be5b363, 0x3f93f460,
    0x63823560, 0x87b07660, 0xdba1b760, 0xcf5cf866, 0x934d3966,
    0x777f7a66, 0x2b6ebb66, 0x0f18fc65, 0x53093d65, 0xb73b7e65,
    0xeb2abf65},
   {0x00000000, 0xd16d00ac, 0x12d9015b, 0xc3b401f7, 0x25b202b6,
    0xf4df021a, 0x376b03ed, 0xe6060341, 0x4b64056c, 0x9a0905c0,
    0x59bd0437, 0x88d0049b, 0x6ed607da, 0xbfbb0776, 0x7c0f0681,
    0xad62062d, 0x96c80ad8, 0x47a50a74, 0x84110b83, 0x557c0b2f,
    0xb37a086e, 0x621708c2, 0xa1a30935, 0x70ce0999, 0xddac0fb4,
    0x0cc10f18, 0xcf750eef, 0x1e180e43, 0xf81e0d02, 0x29730dae,
    0xeac70c59, 0x3baa0cf5, 0x9d9315b3, 0x4cfe151f, 0x8f4a14e8,
    0x5e271444, 0xb8211705, 0x694c17a9, 0xaaf8165e, 0x7b9516f2,
    0xd6f710df, 0x079a1073, 0xc42e1184, 0x15431128, 0xf3451269,
    0x222812c5, 0xe19c1332, 0x30f1139e, 0x0b5b1f6b, 0xda361fc7,
    0x19821e30, 0xc8ef1e9c, 0x2ee91ddd, 0xff841d71, 0x3c301c86,
    0xed5d1c2a, 0x403f1a07, 0x91521aab, 0x52e61b5c, 0x838b1bf0,
    0x658d18b1, 0xb4e0181d, 0x775419ea, 0xa6391946, 0x8b252b65,
    0x5a482bc9, 0x99fc2a3e, 0x48912a92, 0xae9729d3, 0x7ffa297f,
    0xbc4e2888, 0x6d232824, 0xc0412e09, 0x112c2ea5, 0xd2982f52,
    0x03f52ffe, 0xe5f32cbf, 0x349e2c13, 0xf72a2de4, 0x26472d48,
    0x1ded21bd, 0xcc802111, 0x0f3420e6, 0xde59204a, 0x385f230b,
    0xe93223a7, 0x2a862250, 0xfbeb22fc, 0x568924d1, 0x87e4247d,
    0x4450258a, 0x953d2526, 0x733b2667, 0xa25626cb, 0x61e2273c,
    0xb08f2790, 0x16b63ed6, 0xc7db3e7a, 0x046f3f8d, 0xd5023f21,
    0x33043c60, 0xe2693ccc, 0x21dd3d3b, 0xf0b03d97, 0x5dd23bba,
    0x8cbf3b16, 0x4f0b3ae1, 0x9e663a4d, 0x7860390c, 0xa90d39a0,
    0x6ab93857, 0xbbd438fb, 0x807e340e, 0x511334a2, 0x92a73555,
    0x43ca35f9, 0xa5cc36b8, 0x74a13614, 0xb71537e3, 0x6678374f,
    0xcb1a3162, 0x1a7731ce, 0xd9c33039, 0x08ae3095, 0xeea833d4,
    0x3fc53378, 0xfc71328f, 0x2d1c3223, 0xa64956c9, 0x77245665,
    0xb4905792, 0x65fd573e, 0x83fb547f, 0x529654d3, 0x91225524,
    0x404f5588, 0xed2d53a5, 0x3c405309, 0xfff452fe, 0x2e995252,
    0xc89f5113, 0x19f251bf, 0xda465048, 0x0b2b50e4, 0x30815c11,
    0xe1ec5cbd, 0x22585d4a, 0xf3355de6, 0x15335ea7, 0xc45e5e0b,
    0x07ea5ffc, 0xd6875f50, 0x7be5597d, 0xaa8859d1, 0x693c5826,
    0xb851588a, 0x5e575bcb, 0x8f3a5b67, 0x4c8e5a90, 0x9de35a3c,
    0x3bda437a, 0xeab743d6, 0x29034221, 0xf86e428d, 0x1e6841cc,
    0xcf054160, 0x0cb14097, 0xdddc403b, 0x70be4616, 0xa1d346ba,
    0x6267474d, 0xb30a47e1, 0x550c44a0, 0x8461440c, 0x47d545fb,
    0x96b84557, 0xad1249a2, 0x7c7f490e, 0xbfcb48f9, 0x6ea64855,
    0x88a04b14, 0x59cd4bb8, 0x9a794a4f, 0x4b144ae3, 0xe6764cce,
    0x371b4c62, 0xf4af4d95, 0x25c24d39, 0xc3c44e78, 0x12a94ed4,
    0xd11d4f23, 0x00704f8f, 0x2d6c7dac, 0xfc017d00, 0x3fb57cf7,
    0xeed87c5b, 0x08de7f1a, 0xd9b37fb6, 0x1a077e41, 0xcb6a7eed,
    0x660878c0, 0xb765786c, 0x74d1799b, 0xa5bc7937, 0x43ba7a76,
    0x92d77ada, 0x51637b2d, 0x800e7b81, 0xbba47774, 0x6ac977d8,
    0xa97d762f, 0x78107683, 0x9e1675c2, 0x4f7b756e, 0x8ccf7499,
    0x5da27435, 0xf0c07218, 0x21ad72b4, 0xe2197343, 0x337473ef,
    0xd57270ae, 0x041f7002, 0xc7ab71f5, 0x16c67159, 0xb0ff681f,
    0x619268b3, 0xa2266944, 0x734b69e8, 0x954d6aa9, 0x44206a05,
    0x87946bf2, 0x56f96b5e, 0xfb9b6d73, 0x2af66ddf, 0xe9426c28,
    0x382f6c84, 0xde296fc5, 0x0f446f69, 0xccf06e9e, 0x1d9d6e32,
    0x263762c7, 0xf75a626b, 0x34ee639c, 0xe5836330, 0x03856071,
    0xd2e860dd, 0x115c612a, 0xc0316186, 0x6d5367ab, 0xbc3e6707,
    0x7f8a66f0, 0xaee7665c, 0x48e1651d, 0x998c65b1, 0x5a386446,
    0x8b5564ea},
   {0x00000000, 0xfc91ad91, 0x49205b21, 0xb5b1f6b0, 0x9240b642,
    0x6ed11bd3, 0xdb60ed63, 0x27f140f2, 0x94826c87, 0x6813c116,
    0xdda237a6, 0x21339a37, 0x06c2dac5, 0xfa537754, 0x4fe281e4,
    0xb3732c75, 0x9907d90d, 0x6596749c, 0xd027822c, 0x2cb62fbd,
    0x0b476f4f, 0xf7d6c2de, 0x4267346e, 0xbef699ff, 0x0d85b58a,
    0xf114181b, 0x44a5eeab, 0xb834433a, 0x9fc503c8, 0x6354ae59,
    0xd6e558e9, 0x2a74f578, 0x820cb219, 0x7e9d1f88, 0xcb2ce938,
    0x37bd44a9, 0x104c045b, 0xecdda9ca, 0x596c5f7a, 0xa5fdf2eb,
    0x168ede9e, 0xea1f730f, 0x5fae85bf, 0xa33f282e, 0x84ce68dc,
    0x785fc54d, 0xcdee33fd, 0x317f9e6c, 0x1b0b6b14, 0xe79ac685,
    0x522b3035, 0xaeba9da4, 0x894bdd56, 0x75da70c7, 0xc06b8677,
    0x3cfa2be6, 0x8f890793, 0x7318aa02, 0xc6a95cb2, 0x3a38f123,
    0x1dc9b1d1, 0xe1581c40, 0x54e9eaf0, 0xa8784761, 0xb41a6431,
    0x488bc9a0, 0xfd3a3f10, 0x01ab9281, 0x265ad273, 0xdacb7fe2,
    0x6f7a8952, 0x93eb24c3, 0x209808b6, 0xdc09a527, 0x69b85397,
    0x9529fe06, 0xb2d8bef4, 0x4e491365, 0xfbf8e5d5, 0x07694844,
    0x2d1dbd3c, 0xd18c10ad, 0x643de61d, 0x98ac4b8c, 0xbf5d0b7e,
    0x43cca6ef, 0xf67d505f, 0x0aecfdce, 0xb99fd1bb, 0x450e7c2a,
    0xf0bf8a9a, 0x0c2e270b, 0x2bdf67f9, 0xd74eca68, 0x62ff3cd8,
    0x9e6e9149, 0x3616d628, 0xca877bb9, 0x7f368d09, 0x83a72098,
    0xa456606a, 0x58c7cdfb, 0xed763b4b, 0x11e796da, 0xa294baaf,
    0x5e05173e, 0xebb4e18e, 0x17254c1f, 0x30d40ced, 0xcc45a17c,
    0x79f457cc, 0x8565fa5d, 0xaf110f25, 0x5380a2b4, 0xe6315404,
    0x1aa0f995, 0x3d51b967, 0xc1c014f6, 0x7471e246, 0x88e04fd7,
    0x3b9363a2, 0xc702ce33, 0x72b33883, 0x8e229512, 0xa9d3d5e0,
    0x55427871, 0xe0f38ec1, 0x1c622350, 0xd837c861, 0x24a665f0,
    0x91179340, 0x6d863ed1, 0x4a777e23, 0xb6e6d3b2, 0x03572502,
    0xffc68893, 0x4cb5a4e6, 0xb0240977, 0x0595ffc7, 0xf9045256,
    0xdef512a4, 0x2264bf35, 0x97d54985, 0x6b44e414, 0x4130116c,
    0xbda1bcfd, 0x08104a4d, 0xf481e7dc, 0xd370a72e, 0x2fe10abf,
    0x9a50fc0f, 0x66c1519e, 0xd5b27deb, 0x2923d07a, 0x9c9226ca,
    0x60038b5b, 0x47f2cba9, 0xbb636638, 0x0ed29088, 0xf2433d19,
    0x5a3b7a78, 0xa6aad7e9, 0x131b2159, 0xef8a8cc8, 0xc87bcc3a,
    0x34ea61ab, 0x815b971b, 0x7dca3a8a, 0xceb916ff, 0x3228bb6e,
    0x87994dde, 0x7b08e04f, 0x5cf9a0bd, 0xa0680d2c, 0x15d9fb9c,
    0xe948560d, 0xc33ca375, 0x3fad0ee4, 0x8a1cf854, 0x768d55c5,
    0x517c1537, 0xadedb8a6, 0x185c4e16, 0xe4cde387, 0x57becff2,
    0xab2f6263, 0x1e9e94d3, 0xe20f3942, 0xc5fe79b0, 0x396fd421,
    0x8cde2291, 0x704f8f00, 0x6c2dac50, 0x90bc01c1, 0x250df771,
    0xd99c5ae0, 0xfe6d1a12, 0x02fcb783, 0xb74d4133, 0x4bdceca2,
    0xf8afc0d7, 0x043e6d46, 0xb18f9bf6, 0x4d1e3667, 0x6aef7695,
    0x967edb04, 0x23cf2db4, 0xdf5e8025, 0xf52a755d, 0x09bbd8cc,
    0xbc0a2e7c, 0x409b83ed, 0x676ac31f, 0x9bfb6e8e, 0x2e4a983e,
    0xd2db35af, 0x61a819da, 0x9d39b44b, 0x288842fb, 0xd419ef6a,
    0xf3e8af98, 0x0f790209, 0xbac8f4b9, 0x46595928, 0xee211e49,
    0x12b0b3d8, 0xa7014568, 0x5b90e8f9, 0x7c61a80b, 0x80f0059a,
    0x3541f32a, 0xc9d05ebb, 0x7aa372ce, 0x8632df5f, 0x338329ef,
    0xcf12847e, 0xe8e3c48c, 0x1472691d, 0xa1c39fad, 0x5d52323c,
    0x7726c744, 0x8bb76ad5, 0x3e069c65, 0xc29731f4, 0xe5667106,
    0x19f7dc97, 0xac462a27, 0x50d787b6, 0xe3a4abc3, 0x1f350652,
    0xaa84f0e2, 0x56155d73, 0x71e41d81, 0x8d75b010, 0x38c446a0,
    0xc455eb31},
   {0x00000000, 0x006c90c1, 0x00d92182, 0x00b5b143, 0x01b24304,
    0x01ded3c5, 0x016b6286, 0x0107f247, 0x03648608, 0x030816c9,
    0x03bda78a, 0x03d1374b, 0x02d6c50c, 0x02ba55cd, 0x020fe48e,
    0x0263744f, 0x06c90c10, 0x06a59cd1, 0x06102d92, 0x067cbd53,
    0x077b4f14, 0x0717dfd5, 0x07a26e96, 0x07cefe57, 0x05ad8a18,
    0x05c11ad9, 0x0574ab9a, 0x05183b5b, 0x041fc91c, 0x047359dd,
    0x04c6e89e, 0x04aa785f, 0x0d921820, 0x0dfe88e1, 0x0d4b39a2,
    0x0d27a963, 0x0c205b24, 0x0c4ccbe5, 0x0cf97aa6, 0x0c95ea67,
    0x0ef69e28, 0x0e9a0ee9, 0x0e2fbfaa, 0x0e432f6b, 0x0f44dd2c,
    0x0f284ded, 0x0f9dfcae, 0x0ff16c6f, 0x0b5b1430, 0x0b3784f1,
    0x0b8235b2, 0x0beea573, 0x0ae95734, 0x0a85c7f5, 0x0a3076b6,
    0x0a5ce677, 0x083f9238, 0x085302f9, 0x08e6b3ba, 0x088a237b,
    0x098dd13c, 0x09e141fd, 0x0954f0be, 0x0938607f, 0x1b243040,
    0x1b48a081, 0x1bfd11c2, 0x1b918103, 0x1a967344, 0x1afae385,
    0x1a4f52c6, 0x1a23c207, 0x1840b648, 0x182c2689, 0x189997ca,
    0x18f5070b, 0x19f2f54c, 0x199e658d, 0x192bd4ce, 0x1947440f,
    0x1ded3c50, 0x1d81ac91, 0x1d341dd2, 0x1d588d13, 0x1c5f7f54,
    0x1c33ef95, 0x1c865ed6, 0x1ceace17, 0x1e89ba58, 0x1ee52a99,
    0x1e509bda, 0x1e3c0b1b, 0x1f3bf95c, 0x1f57699d, 0x1fe2d8de,
    0x1f8e481f, 0x16b62860, 0x16dab8a1, 0x166f09e2, 0x16039923,
    0x17046b64, 0x1768fba5, 0x17dd4ae6, 0x17b1da27, 0x15d2ae68,
    0x15be3ea9, 0x150b8fea, 0x15671f2b, 0x1460ed6c, 0x140c7dad,
    0x14b9ccee, 0x14d55c2f, 0x107f2470, 0x1013b4b1, 0x10a605f2,
    0x10ca9533, 0x11cd6774, 0x11a1f7b5, 0x111446f6, 0x1178d637,
    0x131ba278, 0x137732b9, 0x13c283fa, 0x13ae133b, 0x12a9e17c,
    0x12c571bd, 0x1270c0fe, 0x121c503f, 0x36486080, 0x3624f041,
    0x36914102, 0x36fdd1c3, 0x37fa2384, 0x3796b345, 0x37230206,
    0x374f92c7, 0x352ce688, 0x35407649, 0x35f5c70a, 0x359957cb,
    0x349ea58c, 0x34f2354d, 0x3447840e, 0x342b14cf, 0x30816c90,
    0x30edfc51, 0x30584d12, 0x3034ddd3, 0x31332f94, 0x315fbf55,
    0x31ea0e16, 0x31869ed7, 0x33e5ea98, 0x33897a59, 0x333ccb1a,
    0x33505bdb, 0x3257a99c, 0x323b395d, 0x328e881e, 0x32e218df,
    0x3bda78a0, 0x3bb6e861, 0x3b035922, 0x3b6fc9e3, 0x3a683ba4,
    0x3a04ab65, 0x3ab11a26, 0x3add8ae7, 0x38befea8, 0x38d26e69,
    0x3867df2a, 0x380b4feb, 0x390cbdac, 0x39602d6d, 0x39d59c2e,
    0x39b90cef, 0x3d1374b0, 0x3d7fe471, 0x3dca5532, 0x3da6c5f3,
    0x3ca137b4, 0x3ccda775, 0x3c781636, 0x3c1486f7, 0x3e77f2b8,
    0x3e1b6279, 0x3eaed33a, 0x3ec243fb, 0x3fc5b1bc, 0x3fa9217d,
    0x3f1c903e, 0x3f7000ff, 0x2d6c50c0, 0x2d00c001, 0x2db57142,
    0x2dd9e183, 0x2cde13c4, 0x2cb28305, 0x2c073246, 0x2c6ba287,
    0x2e08d6c8, 0x2e644609, 0x2ed1f74a, 0x2ebd678b, 0x2fba95cc,
    0x2fd6050d, 0x2f63b44e, 0x2f0f248f, 0x2ba55cd0, 0x2bc9cc11,
    0x2b7c7d52, 0x2b10ed93, 0x2a171fd4, 0x2a7b8f15, 0x2ace3e56,
    0x2aa2ae97, 0x28c1dad8, 0x28ad4a19, 0x2818fb5a, 0x28746b9b,
    0x297399dc, 0x291f091d, 0x29aab85e, 0x29c6289f, 0x20fe48e0,
    0x2092d821, 0x20276962, 0x204bf9a3, 0x214c0be4, 0x21209b25,
    0x21952a66, 0x21f9baa7, 0x239acee8, 0x23f65e29, 0x2343ef6a,
    0x232f7fab, 0x22288dec, 0x22441d2d, 0x22f1ac6e, 0x229d3caf,
    0x263744f0, 0x265bd431, 0x26ee6572, 0x2682f5b3, 0x278507f4,
    0x27e99735, 0x275c2676, 0x2730b6b7, 0x2553c2f8, 0x253f5239,
    0x258ae37a, 0x25e673bb, 0x24e181fc, 0x248d113d, 0x2438a07e,
    0x245430bf}};

static const word_t crc_braid_big_table[][256] = {
   {0x00000000, 0xc1906c00, 0x8221d900, 0x43b1b500, 0x0443b201,
    0xc5d3de01, 0x86626b01, 0x47f20701, 0x08866403, 0xc9160803,
    0x8aa7bd03, 0x4b37d103, 0x0cc5d602, 0xcd55ba02, 0x8ee40f02,
    0x4f746302, 0x100cc906, 0xd19ca506, 0x922d1006, 0x53bd7c06,
    0x144f7b07, 0xd5df1707, 0x966ea207, 0x57fece07, 0x188aad05,
    0xd91ac105, 0x9aab7405, 0x5b3b1805, 0x1cc91f04, 0xdd597304,
    0x9ee8c604, 0x5f78aa04, 0x2018920d, 0xe188fe0d, 0xa2394b0d,
    0x63a9270d, 0x245b200c, 0xe5cb4c0c, 0xa67af90c, 0x67ea950c,
    0x289ef60e, 0xe90e9a0e, 0xaabf2f0e, 0x6b2f430e, 0x2cdd440f,
    0xed4d280f, 0xaefc9d0f, 0x6f6cf10f, 0x30145b0b, 0xf184370b,
    0xb235820b, 0x73a5ee0b, 0x3457e90a, 0xf5c7850a, 0xb676300a,
    0x77e65c0a, 0x38923f08, 0xf9025308, 0xbab3e608, 0x7b238a08,
    0x3cd18d09, 0xfd41e109, 0xbef05409, 0x7f603809, 0x4030241b,
    0x81a0481b, 0xc211fd1b, 0x0381911b, 0x4473961a, 0x85e3fa1a,
    0xc6524f1a, 0x07c2231a, 0x48b64018, 0x89262c18, 0xca979918,
    0x0b07f518, 0x4cf5f219, 0x8d659e19, 0xced42b19, 0x0f444719,
    0x503ced1d, 0x91ac811d, 0xd21d341d, 0x138d581d, 0x547f5f1c,
    0x95ef331c, 0xd65e861c, 0x17ceea1c, 0x58ba891e, 0x992ae51e,
    0xda9b501e, 0x1b0b3c1e, 0x5cf93b1f, 0x9d69571f, 0xded8e21f,
    0x1f488e1f, 0x6028b616, 0xa1b8da16, 0xe2096f16, 0x23990316,
    0x646b0417, 0xa5fb6817, 0xe64add17, 0x27dab117, 0x68aed215,
    0xa93ebe15, 0xea8f0b15, 0x2b1f6715, 0x6ced6014, 0xad7d0c14,
    0xeeccb914, 0x2f5cd514, 0x70247f10, 0xb1b41310, 0xf205a610,
    0x3395ca10, 0x7467cd11, 0xb5f7a111, 0xf6461411, 0x37d67811,
    0x78a21b13, 0xb9327713, 0xfa83c213, 0x3b13ae13, 0x7ce1a912,
    0xbd71c512, 0xfec07012, 0x3f501c12, 0x80604836, 0x41f02436,
    0x02419136, 0xc3d1fd36, 0x8423fa37, 0x45b39637, 0x06022337,
    0xc7924f37, 0x88e62c35, 0x49764035, 0x0ac7f535, 0xcb579935,
    0x8ca59e34, 0x4d35f234, 0x0e844734, 0xcf142b34, 0x906c8130,
    0x51fced30, 0x124d5830, 0xd3dd3430, 0x942f3331, 0x55bf5f31,
    0x160eea31, 0xd79e8631, 0x98eae533, 0x597a8933, 0x1acb3c33,
    0xdb5b5033, 0x9ca95732, 0x5d393b32, 0x1e888e32, 0xdf18e232,
    0xa078da3b, 0x61e8b63b, 0x2259033b, 0xe3c96f3b, 0xa43b683a,
    0x65ab043a, 0x261ab13a, 0xe78add3a, 0xa8febe38, 0x696ed238,
    0x2adf6738, 0xeb4f0b38, 0xacbd0c39, 0x6d2d6039, 0x2e9cd539,
    0xef0cb939, 0xb074133d, 0x71e47f3d, 0x3255ca3d, 0xf3c5a63d,
    0xb437a13c, 0x75a7cd3c, 0x3616783c, 0xf786143c, 0xb8f2773e,
    0x79621b3e, 0x3ad3ae3e, 0xfb43c23e, 0xbcb1c53f, 0x7d21a93f,
    0x3e901c3f, 0xff00703f, 0xc0506c2d, 0x01c0002d, 0x4271b52d,
    0x83e1d92d, 0xc413de2c, 0x0583b22c, 0x4632072c, 0x87a26b2c,
    0xc8d6082e, 0x0946642e, 0x4af7d12e, 0x8b67bd2e, 0xcc95ba2f,
    0x0d05d62f, 0x4eb4632f, 0x8f240f2f, 0xd05ca52b, 0x11ccc92b,
    0x527d7c2b, 0x93ed102b, 0xd41f172a, 0x158f7b2a, 0x563ece2a,
    0x97aea22a, 0xd8dac128, 0x194aad28, 0x5afb1828, 0x9b6b7428,
    0xdc997329, 0x1d091f29, 0x5eb8aa29, 0x9f28c629, 0xe048fe20,
    0x21d89220, 0x62692720, 0xa3f94b20, 0xe40b4c21, 0x259b2021,
    0x662a9521, 0xa7baf921, 0xe8ce9a23, 0x295ef623, 0x6aef4323,
    0xab7f2f23, 0xec8d2822, 0x2d1d4422, 0x6eacf122, 0xaf3c9d22,
    0xf0443726, 0x31d45b26, 0x7265ee26, 0xb3f58226, 0xf4078527,
    0x3597e927, 0x76265c27, 0xb7b63027, 0xf8c25325, 0x39523f25,
    0x7ae38a25, 0xbb73e625, 0xfc81e124, 0x3d118d24, 0x7ea03824,
    0xbf305424},
   {0x00000000, 0x91ad91fc, 0x215b2049, 0xb0f6b1b5, 0x42b64092,
    0xd31bd16e, 0x63ed60db, 0xf240f127, 0x876c8294, 0x16c11368,
    0xa637a2dd, 0x379a3321, 0xc5dac206, 0x547753fa, 0xe481e24f,
    0x752c73b3, 0x0dd90799, 0x9c749665, 0x2c8227d0, 0xbd2fb62c,
    0x4f6f470b, 0xdec2d6f7, 0x6e346742, 0xff99f6be, 0x8ab5850d,
    0x1b1814f1, 0xabeea544, 0x3a4334b8, 0xc803c59f, 0x59ae5463,
    0xe958e5d6, 0x78f5742a, 0x19b20c82, 0x881f9d7e, 0x38e92ccb,
    0xa944bd37, 0x5b044c10, 0xcaa9ddec, 0x7a5f6c59, 0xebf2fda5,
    0x9ede8e16, 0x0f731fea, 0xbf85ae5f, 0x2e283fa3, 0xdc68ce84,
    0x4dc55f78, 0xfd33eecd, 0x6c9e7f31, 0x146b0b1b, 0x85c69ae7,
    0x35302b52, 0xa49dbaae, 0x56dd4b89, 0xc770da75, 0x77866bc0,
    0xe62bfa3c, 0x9307898f, 0x02aa1873, 0xb25ca9c6, 0x23f1383a,
    0xd1b1c91d, 0x401c58e1, 0xf0eae954, 0x614778a8, 0x31641ab4,
    0xa0c98b48, 0x103f3afd, 0x8192ab01, 0x73d25a26, 0xe27fcbda,
    0x52897a6f, 0xc324eb93, 0xb6089820, 0x27a509dc, 0x9753b869,
    0x06fe2995, 0xf4bed8b2, 0x6513494e, 0xd5e5f8fb, 0x44486907,
    0x3cbd1d2d, 0xad108cd1, 0x1de63d64, 0x8c4bac98, 0x7e0b5dbf,
    0xefa6cc43, 0x5f507df6, 0xcefdec0a, 0xbbd19fb9, 0x2a7c0e45,
    0x9a8abff0, 0x0b272e0c, 0xf967df2b, 0x68ca4ed7, 0xd83cff62,
    0x49916e9e, 0x28d61636, 0xb97b87ca, 0x098d367f, 0x9820a783,
    0x6a6056a4, 0xfbcdc758, 0x4b3b76ed, 0xda96e711, 0xafba94a2,
    0x3e17055e, 0x8ee1b4eb, 0x1f4c2517, 0xed0cd430, 0x7ca145cc,
    0xcc57f479, 0x5dfa6585, 0x250f11af, 0xb4a28053, 0x045431e6,
    0x95f9a01a, 0x67b9513d, 0xf614c0c1, 0x46e27174, 0xd74fe088,
    0xa263933b, 0x33ce02c7, 0x8338b372, 0x1295228e, 0xe0d5d3a9,
    0x71784255, 0xc18ef3e0, 0x5023621c, 0x61c837d8, 0xf065a624,
    0x40931791, 0xd13e866d, 0x237e774a, 0xb2d3e6b6, 0x02255703,
    0x9388c6ff, 0xe6a4b54c, 0x770924b0, 0xc7ff9505, 0x565204f9,
    0xa412f5de, 0x35bf6422, 0x8549d597, 0x14e4446b, 0x6c113041,
    0xfdbca1bd, 0x4d4a1008, 0xdce781f4, 0x2ea770d3, 0xbf0ae12f,
    0x0ffc509a, 0x9e51c166, 0xeb7db2d5, 0x7ad02329, 0xca26929c,
    0x5b8b0360, 0xa9cbf247, 0x386663bb, 0x8890d20e, 0x193d43f2,
    0x787a3b5a, 0xe9d7aaa6, 0x59211b13, 0xc88c8aef, 0x3acc7bc8,
    0xab61ea34, 0x1b975b81, 0x8a3aca7d, 0xff16b9ce, 0x6ebb2832,
    0xde4d9987, 0x4fe0087b, 0xbda0f95c, 0x2c0d68a0, 0x9cfbd915,
    0x0d5648e9, 0x75a33cc3, 0xe40ead3f, 0x54f81c8a, 0xc5558d76,
    0x37157c51, 0xa6b8edad, 0x164e5c18, 0x87e3cde4, 0xf2cfbe57,
    0x63622fab, 0xd3949e1e, 0x42390fe2, 0xb079fec5, 0x21d46f39,
    0x9122de8c, 0x008f4f70, 0x50ac2d6c, 0xc101bc90, 0x71f70d25,
    0xe05a9cd9, 0x121a6dfe, 0x83b7fc02, 0x33414db7, 0xa2ecdc4b,
    0xd7c0aff8, 0x466d3e04, 0xf69b8fb1, 0x67361e4d, 0x9576ef6a,
    0x04db7e96, 0xb42dcf23, 0x25805edf, 0x5d752af5, 0xccd8bb09,
    0x7c2e0abc, 0xed839b40, 0x1fc36a67, 0x8e6efb9b, 0x3e984a2e,
    0xaf35dbd2, 0xda19a861, 0x4bb4399d, 0xfb428828, 0x6aef19d4,
    0x98afe8f3, 0x0902790f, 0xb9f4c8ba, 0x28595946, 0x491e21ee,
    0xd8b3b012, 0x684501a7, 0xf9e8905b, 0x0ba8617c, 0x9a05f080,
    0x2af34135, 0xbb5ed0c9, 0xce72a37a, 0x5fdf3286, 0xef298333,
    0x7e8412cf, 0x8cc4e3e8, 0x1d697214, 0xad9fc3a1, 0x3c32525d,
    0x44c72677, 0xd56ab78b, 0x659c063e, 0xf43197c2, 0x067166e5,
    0x97dcf719, 0x272a46ac, 0xb687d750, 0xc3aba4e3, 0x5206351f,
    0xe2f084aa, 0x735d1556, 0x811de471, 0x10b0758d, 0xa046c438,
    0x31eb55c4},
   {0x00000000, 0xac006dd1, 0x5b01d912, 0xf701b4c3, 0xb602b225,
    0x1a02dff4, 0xed036b37, 0x410306e6, 0x6c05644b, 0xc005099a,
    0x3704bd59, 0x9b04d088, 0xda07d66e, 0x7607bbbf, 0x81060f7c,
    0x2d0662ad, 0xd80ac896, 0x740aa547, 0x830b1184, 0x2f0b7c55,
    0x6e087ab3, 0xc2081762, 0x3509a3a1, 0x9909ce70, 0xb40facdd,
    0x180fc10c, 0xef0e75cf, 0x430e181e, 0x020d1ef8, 0xae0d7329,
    0x590cc7ea, 0xf50caa3b, 0xb315939d, 0x1f15fe4c, 0xe8144a8f,
    0x4414275e, 0x051721b8, 0xa9174c69, 0x5e16f8aa, 0xf216957b,
    0xdf10f7d6, 0x73109a07, 0x84112ec4, 0x28114315, 0x691245f3,
    0xc5122822, 0x32139ce1, 0x9e13f130, 0x6b1f5b0b, 0xc71f36da,
    0x301e8219, 0x9c1eefc8, 0xdd1de92e, 0x711d84ff, 0x861c303c,
    0x2a1c5ded, 0x071a3f40, 0xab1a5291, 0x5c1be652, 0xf01b8b83,
    0xb1188d65, 0x1d18e0b4, 0xea195477, 0x461939a6, 0x652b258b,
    0xc92b485a, 0x3e2afc99, 0x922a9148, 0xd32997ae, 0x7f29fa7f,
    0x88284ebc, 0x2428236d, 0x092e41c0, 0xa52e2c11, 0x522f98d2,
    0xfe2ff503, 0xbf2cf3e5, 0x132c9e34, 0xe42d2af7, 0x482d4726,
    0xbd21ed1d, 0x112180cc, 0xe620340f, 0x4a2059de, 0x0b235f38,
    0xa72332e9, 0x5022862a, 0xfc22ebfb, 0xd1248956, 0x7d24e487,
    0x8a255044, 0x26253d95, 0x67263b73, 0xcb2656a2, 0x3c27e261,
    0x90278fb0, 0xd63eb616, 0x7a3edbc7, 0x8d3f6f04, 0x213f02d5,
    0x603c0433, 0xcc3c69e2, 0x3b3ddd21, 0x973db0f0, 0xba3bd25d,
    0x163bbf8c, 0xe13a0b4f, 0x4d3a669e, 0x0c396078, 0xa0390da9,
    0x5738b96a, 0xfb38d4bb, 0x0e347e80, 0xa2341351, 0x5535a792,
    0xf935ca43, 0xb836cca5, 0x1436a174, 0xe33715b7, 0x4f377866,
    0x62311acb, 0xce31771a, 0x3930c3d9, 0x9530ae08, 0xd433a8ee,
    0x7833c53f, 0x8f3271fc, 0x23321c2d, 0xc95649a6, 0x65562477,
    0x925790b4, 0x3e57fd65, 0x7f54fb83, 0xd3549652, 0x24552291,
    0x88554f40, 0xa5532ded, 0x0953403c, 0xfe52f4ff, 0x5252992e,
    0x13519fc8, 0xbf51f219, 0x485046da, 0xe4502b0b, 0x115c8130,
    0xbd5cece1, 0x4a5d5822, 0xe65d35f3, 0xa75e3315, 0x0b5e5ec4,
    0xfc5fea07, 0x505f87d6, 0x7d59e57b, 0xd15988aa, 0x26583c69,
    0x8a5851b8, 0xcb5b575e, 0x675b3a8f, 0x905a8e4c, 0x3c5ae39d,
    0x7a43da3b, 0xd643b7ea, 0x21420329, 0x8d426ef8, 0xcc41681e,
    0x604105cf, 0x9740b10c, 0x3b40dcdd, 0x1646be70, 0xba46d3a1,
    0x4d476762, 0xe1470ab3, 0xa0440c55, 0x0c446184, 0xfb45d547,
    0x5745b896, 0xa24912ad, 0x0e497f7c, 0xf948cbbf, 0x5548a66e,
    0x144ba088, 0xb84bcd59, 0x4f4a799a, 0xe34a144b, 0xce4c76e6,
    0x624c1b37, 0x954daff4, 0x394dc225, 0x784ec4c3, 0xd44ea912,
    0x234f1dd1, 0x8f4f7000, 0xac7d6c2d, 0x007d01fc, 0xf77cb53f,
    0x5b7cd8ee, 0x1a7fde08, 0xb67fb3d9, 0x417e071a, 0xed7e6acb,
    0xc0780866, 0x6c7865b7, 0x9b79d174, 0x3779bca5, 0x767aba43,
    0xda7ad792, 0x2d7b6351, 0x817b0e80, 0x7477a4bb, 0xd877c96a,
    0x2f767da9, 0x83761078, 0xc275169e, 0x6e757b4f, 0x9974cf8c,
    0x3574a25d, 0x1872c0f0, 0xb472ad21, 0x437319e2, 0xef737433,
    0xae7072d5, 0x02701f04, 0xf571abc7, 0x5971c616, 0x1f68ffb0,
    0xb3689261, 0x446926a2, 0xe8694b73, 0xa96a4d95, 0x056a2044,
    0xf26b9487, 0x5e6bf956, 0x736d9bfb, 0xdf6df62a, 0x286c42e9,
    0x846c2f38, 0xc56f29de, 0x696f440f, 0x9e6ef0cc, 0x326e9d1d,
    0xc7623726, 0x6b625af7, 0x9c63ee34, 0x306383e5, 0x71608503,
    0xdd60e8d2, 0x2a615c11, 0x866131c0, 0xab67536d, 0x07673ebc,
    0xf0668a7f, 0x5c66e7ae, 0x1d65e148, 0xb1658c99, 0x4664385a,
    0xea64558b},
   {0x00000000, 0x00c1115c, 0x008223b8, 0x004332e4, 0x030444c0,
    0x03c5559c, 0x03866778, 0x03477624, 0x05088b30, 0x05c99a6c,
    0x058aa888, 0x054bb9d4, 0x060ccff0, 0x06cddeac, 0x068eec48,
    0x064ffd14, 0x0a101661, 0x0ad1073d, 0x0a9235d9, 0x0a532485,
    0x091452a1, 0x09d543fd, 0x09967119, 0x09576045, 0x0f189d51,
    0x0fd98c0d, 0x0f9abee9, 0x0f5bafb5, 0x0c1cd991, 0x0cddc8cd,
    0x0c9efa29, 0x0c5feb75, 0x14202cc2, 0x14e13d9e, 0x14a20f7a,
    0x14631e26, 0x17246802, 0x17e5795e, 0x17a64bba, 0x17675ae6,
    0x1128a7f2, 0x11e9b6ae, 0x11aa844a, 0x116b9516, 0x122ce332,
    0x12edf26e, 0x12aec08a, 0x126fd1d6, 0x1e303aa3, 0x1ef12bff,
    0x1eb2191b, 0x1e730847, 0x1d347e63, 0x1df56f3f, 0x1db65ddb,
    0x1d774c87, 0x1b38b193, 0x1bf9a0cf, 0x1bba922b, 0x1b7b8377,
    0x183cf553, 0x18fde40f, 0x18bed6eb, 0x187fc7b7, 0x2b405b34,
    0x2b814a68, 0x2bc2788c, 0x2b0369d0, 0x28441ff4, 0x28850ea8,
    0x28c63c4c, 0x28072d10, 0x2e48d004, 0x2e89c158, 0x2ecaf3bc,
    0x2e0be2e0, 0x2d4c94c4, 0x2d8d8598, 0x2dceb77c, 0x2d0fa620,
    0x21504d55, 0x21915c09, 0x21d26eed, 0x21137fb1, 0x22540995,
    0x229518c9, 0x22d62a2d, 0x22173b71, 0x2458c665, 0x2499d739,
    0x24dae5dd, 0x241bf481, 0x275c82a5, 0x279d93f9, 0x27dea11d,
    0x271fb041, 0x3f6077f6, 0x3fa166aa, 0x3fe2544e, 0x3f234512,
    0x3c643336, 0x3ca5226a, 0x3ce6108e, 0x3c2701d2, 0x3a68fcc6,
    0x3aa9ed9a, 0x3aeadf7e, 0x3a2bce22, 0x396cb806, 0x39ada95a,
    0x39ee9bbe, 0x392f8ae2, 0x35706197, 0x35b170cb, 0x35f2422f,
    0x35335373, 0x36742557, 0x36b5340b, 0x36f606ef, 0x363717b3,
    0x3078eaa7, 0x30b9fbfb, 0x30fac91f, 0x303bd843, 0x337cae67,
    0x33bdbf3b, 0x33fe8ddf, 0x333f9c83, 0x5680b668, 0x5641a734,
    0x560295d0, 0x56c3848c, 0x5584f2a8, 0x5545e3f4, 0x5506d110,
    0x55c7c04c, 0x53883d58, 0x53492c04, 0x530a1ee0, 0x53cb0fbc,
    0x508c7998, 0x504d68c4, 0x500e5a20, 0x50cf4b7c, 0x5c90a009,
    0x5c51b155, 0x5c1283b1, 0x5cd392ed, 0x5f94e4c9, 0x5f55f595,
    0x5f16c771, 0x5fd7d62d, 0x59982b39, 0x59593a65, 0x591a0881,
    0x59db19dd, 0x5a9c6ff9, 0x5a5d7ea5, 0x5a1e4c41, 0x5adf5d1d,
    0x42a09aaa, 0x42618bf6, 0x4222b912, 0x42e3a84e, 0x41a4de6a,
    0x4165cf36, 0x4126fdd2, 0x41e7ec8e, 0x47a8119a, 0x476900c6,
    0x472a3222, 0x47eb237e, 0x44ac555a, 0x446d4406, 0x442e76e2,
    0x44ef67be, 0x48b08ccb, 0x48719d97, 0x4832af73, 0x48f3be2f,
    0x4bb4c80b, 0x4b75d957, 0x4b36ebb3, 0x4bf7faef, 0x4db807fb,
    0x4d7916a7, 0x4d3a2443, 0x4dfb351f, 0x4ebc433b, 0x4e7d5267,
    0x4e3e6083, 0x4eff71df, 0x7dc0ed5c, 0x7d01fc00, 0x7d42cee4,
    0x7d83dfb8, 0x7ec4a99c, 0x7e05b8c0, 0x7e468a24, 0x7e879b78,
    0x78c8666c, 0x78097730, 0x784a45d4, 0x788b5488, 0x7bcc22ac,
    0x7b0d33f0, 0x7b4e0114, 0x7b8f1048, 0x77d0fb3d, 0x7711ea61,
    0x7752d885, 0x7793c9d9, 0x74d4bffd, 0x7415aea1, 0x74569c45,
    0x74978d19, 0x72d8700d, 0x72196151, 0x725a53b5, 0x729b42e9,
    0x71dc34cd, 0x711d2591, 0x715e1775, 0x719f0629, 0x69e0c19e,
    0x6921d0c2, 0x6962e226, 0x69a3f37a, 0x6ae4855e, 0x6a259402,
    0x6a66a6e6, 0x6aa7b7ba, 0x6ce84aae, 0x6c295bf2, 0x6c6a6916,
    0x6cab784a, 0x6fec0e6e, 0x6f2d1f32, 0x6f6e2dd6, 0x6faf3c8a,
    0x63f0d7ff, 0x6331c6a3, 0x6372f447, 0x63b3e51b, 0x60f4933f,
    0x60358263, 0x6076b087, 0x60b7a1db, 0x66f85ccf, 0x66394d93,
    0x667a7f77, 0x66bb6e2b, 0x65fc180f, 0x653d0953, 0x657e3bb7,
    0x65bf2aeb}};

#endif

#endif

#if N == 6

#if W == 8

static const crc_t crc_braid_table[][256] = {
   {0x00000000, 0xe17c91c1, 0x72fa2381, 0x9386b240, 0xe5f44702,
    0x0488d6c3, 0x970e6483, 0x7672f542, 0x7beb8e07, 0x9a971fc6,
    0x0911ad86, 0xe86d3c47, 0x9e1fc905, 0x7f6358c4, 0xece5ea84,
    0x0d997b45, 0xf7d71c0e, 0x16ab8dcf, 0x852d3f8f, 0x6451ae4e,
    0x12235b0c, 0xf35fcacd, 0x60d9788d, 0x81a5e94c, 0x8c3c9209,
    0x6d4003c8, 0xfec6b188, 0x1fba2049, 0x69c8d50b, 0x88b444ca,
    0x1b32f68a, 0xfa4e674b, 0x5fad381f, 0xbed1a9de, 0x2d571b9e,
    0xcc2b8a5f, 0xba597f1d, 0x5b25eedc, 0xc8a35c9c, 0x29dfcd5d,
    0x2446b618, 0xc53a27d9, 0x56bc9599, 0xb7c00458, 0xc1b2f11a,
    0x20ce60db, 0xb348d29b, 0x5234435a, 0xa87a2411, 0x4906b5d0,
    0xda800790, 0x3bfc9651, 0x4d8e6313, 0xacf2f2d2, 0x3f744092,
    0xde08d153, 0xd391aa16, 0x32ed3bd7, 0xa16b8997, 0x40171856,
    0x3665ed14, 0xd7197cd5, 0x449fce95, 0xa5e35f54, 0xbf5a703e,
    0x5e26e1ff, 0xcda053bf, 0x2cdcc27e, 0x5aae373c, 0xbbd2a6fd,
    0x285414bd, 0xc928857c, 0xc4b1fe39, 0x25cd6ff8, 0xb64bddb8,
    0x57374c79, 0x2145b93b, 0xc03928fa, 0x53bf9aba, 0xb2c30b7b,
    0x488d6c30, 0xa9f1fdf1, 0x3a774fb1, 0xdb0bde70, 0xad792b32,
    0x4c05baf3, 0xdf8308b3, 0x3eff9972, 0x3366e237, 0xd21a73f6,
    0x419cc1b6, 0xa0e05077, 0xd692a535, 0x37ee34f4, 0xa46886b4,
    0x45141775, 0xe0f74821, 0x018bd9e0, 0x920d6ba0, 0x7371fa61,
    0x05030f23, 0xe47f9ee2, 0x77f92ca2, 0x9685bd63, 0x9b1cc626,
    0x7a6057e7, 0xe9e6e5a7, 0x089a7466, 0x7ee88124, 0x9f9410e5,
    0x0c12a2a5, 0xed6e3364, 0x1720542f, 0xf65cc5ee, 0x65da77ae,
    0x84a6e66f, 0xf2d4132d, 0x13a882ec, 0x802e30ac, 0x6152a16d,
    0x6ccbda28, 0x8db74be9, 0x1e31f9a9, 0xff4d6868, 0x893f9d2a,
    0x68430ceb, 0xfbc5beab, 0x1ab92f6a, 0xceb7e07f, 0x2fcb71be,
    0xbc4dc3fe, 0x5d31523f, 0x2b43a77d, 0xca3f36bc, 0x59b984fc,
    0xb8c5153d, 0xb55c6e78, 0x5420ffb9, 0xc7a64df9, 0x26dadc38,
    0x50a8297a, 0xb1d4b8bb, 0x22520afb, 0xc32e9b3a, 0x3960fc71,
    0xd81c6db0, 0x4b9adff0, 0xaae64e31, 0xdc94bb73, 0x3de82ab2,
    0xae6e98f2, 0x4f120933, 0x428b7276, 0xa3f7e3b7, 0x307151f7,
    0xd10dc036, 0xa77f3574, 0x4603a4b5, 0xd58516f5, 0x34f98734,
    0x911ad860, 0x706649a1, 0xe3e0fbe1, 0x029c6a20, 0x74ee9f62,
    0x95920ea3, 0x0614bce3, 0xe7682d22, 0xeaf15667, 0x0b8dc7a6,
    0x980b75e6, 0x7977e427, 0x0f051165, 0xee7980a4, 0x7dff32e4,
    0x9c83a325, 0x66cdc46e, 0x87b155af, 0x1437e7ef, 0xf54b762e,
    0x8339836c, 0x624512ad, 0xf1c3a0ed, 0x10bf312c, 0x1d264a69,
    0xfc5adba8, 0x6fdc69e8, 0x8ea0f829, 0xf8d20d6b, 0x19ae9caa,
    0x8a282eea, 0x6b54bf2b, 0x71ed9041, 0x90910180, 0x0317b3c0,
    0xe26b2201, 0x9419d743, 0x75654682, 0xe6e3f4c2, 0x079f6503,
    0x0a061e46, 0xeb7a8f87, 0x78fc3dc7, 0x9980ac06, 0xeff25944,
    0x0e8ec885, 0x9d087ac5, 0x7c74eb04, 0x863a8c4f, 0x67461d8e,
    0xf4c0afce, 0x15bc3e0f, 0x63cecb4d, 0x82b25a8c, 0x1134e8cc,
    0xf048790d, 0xfdd10248, 0x1cad9389, 0x8f2b21c9, 0x6e57b008,
    0x1825454a, 0xf959d48b, 0x6adf66cb, 0x8ba3f70a, 0x2e40a85e,
    0xcf3c399f, 0x5cba8bdf, 0xbdc61a1e, 0xcbb4ef5c, 0x2ac87e9d,
    0xb94eccdd, 0x58325d1c, 0x55ab2659, 0xb4d7b798, 0x275105d8,
    0xc62d9419, 0xb05f615b, 0x5123f09a, 0xc2a542da, 0x23d9d31b,
    0xd997b450, 0x38eb2591, 0xab6d97d1, 0x4a110610, 0x3c63f352,
    0xdd1f6293, 0x4e99d0d3, 0xafe54112, 0xa27c3a57, 0x4300ab96,
    0xd08619d6, 0x31fa8817, 0x47887d55, 0xa6f4ec94, 0x35725ed4,
    0xd40ecf15},
   {0x00000000, 0x2d6cc0fd, 0x5ad981fa, 0x77b54107, 0xb5b303f4,
    0x98dfc309, 0xef6a820e, 0xc20642f3, 0xdb6507eb, 0xf609c716,
    0x81bc8611, 0xacd046ec, 0x6ed6041f, 0x43bac4e2, 0x340f85e5,
    0x19634518, 0x06c90fd5, 0x2ba5cf28, 0x5c108e2f, 0x717c4ed2,
    0xb37a0c21, 0x9e16ccdc, 0xe9a38ddb, 0xc4cf4d26, 0xddac083e,
    0xf0c0c8c3, 0x877589c4, 0xaa194939, 0x681f0bca, 0x4573cb37,
    0x32c68a30, 0x1faa4acd, 0x0d921faa, 0x20fedf57, 0x574b9e50,
    0x7a275ead, 0xb8211c5e, 0x954ddca3, 0xe2f89da4, 0xcf945d59,
    0xd6f71841, 0xfb9bd8bc, 0x8c2e99bb, 0xa1425946, 0x63441bb5,
    0x4e28db48, 0x399d9a4f, 0x14f15ab2, 0x0b5b107f, 0x2637d082,
    0x51829185, 0x7cee5178, 0xbee8138b, 0x9384d376, 0xe4319271,
    0xc95d528c, 0xd03e1794, 0xfd52d769, 0x8ae7966e, 0xa78b5693,
    0x658d1460, 0x48e1d49d, 0x3f54959a, 0x12385567, 0x1b243f54,
    0x3648ffa9, 0x41fdbeae, 0x6c917e53, 0xae973ca0, 0x83fbfc5d,
    0xf44ebd5a, 0xd9227da7, 0xc04138bf, 0xed2df842, 0x9a98b945,
    0xb7f479b8, 0x75f23b4b, 0x589efbb6, 0x2f2bbab1, 0x02477a4c,
    0x1ded3081, 0x3081f07c, 0x4734b17b, 0x6a587186, 0xa85e3375,
    0x8532f388, 0xf287b28f, 0xdfeb7272, 0xc688376a, 0xebe4f797,
    0x9c51b690, 0xb13d766d, 0x733b349e, 0x5e57f463, 0x29e2b564,
    0x048e7599, 0x16b620fe, 0x3bdae003, 0x4c6fa104, 0x610361f9,
    0xa305230a, 0x8e69e3f7, 0xf9dca2f0, 0xd4b0620d, 0xcdd32715,
    0xe0bfe7e8, 0x970aa6ef, 0xba666612, 0x786024e1, 0x550ce41c,
    0x22b9a51b, 0x0fd565e6, 0x107f2f2b, 0x3d13efd6, 0x4aa6aed1,
    0x67ca6e2c, 0xa5cc2cdf, 0x88a0ec22, 0xff15ad25, 0xd2796dd8,
    0xcb1a28c0, 0xe676e83d, 0x91c3a93a, 0xbcaf69c7, 0x7ea92b34,
    0x53c5ebc9, 0x2470aace, 0x091c6a33, 0x36487ea8, 0x1b24be55,
    0x6c91ff52, 0x41fd3faf, 0x83fb7d5c, 0xae97bda1, 0xd922fca6,
    0xf44e3c5b, 0xed2d7943, 0xc041b9be, 0xb7f4f8b9, 0x9a983844,
    0x589e7ab7, 0x75f2ba4a, 0x0247fb4d, 0x2f2b3bb0, 0x3081717d,
    0x1dedb180, 0x6a58f087, 0x4734307a, 0x85327289, 0xa85eb274,
    0xdfebf373, 0xf287338e, 0xebe47696, 0xc688b66b, 0xb13df76c,
    0x9c513791, 0x5e577562, 0x733bb59f, 0x048ef498, 0x29e23465,
    0x3bda6102, 0x16b6a1ff, 0x6103e0f8, 0x4c6f2005, 0x8e6962f6,
    0xa305a20b, 0xd4b0e30c, 0xf9dc23f1, 0xe0bf66e9, 0xcdd3a614,
    0xba66e713, 0x970a27ee, 0x550c651d, 0x7860a5e0, 0x0fd5e4e7,
    0x22b9241a, 0x3d136ed7, 0x107fae2a, 0x67caef2d, 0x4aa62fd0,
    0x88a06d23, 0xa5ccadde, 0xd279ecd9, 0xff152c24, 0xe676693c,
    0xcb1aa9c1, 0xbcafe8c6, 0x91c3283b, 0x53c56ac8, 0x7ea9aa35,
    0x091ceb32, 0x24702bcf, 0x2d6c41fc, 0x00008101, 0x77b5c006,
    0x5ad900fb, 0x98df4208, 0xb5b382f5, 0xc206c3f2, 0xef6a030f,
    0xf6094617, 0xdb6586ea, 0xacd0c7ed, 0x81bc0710, 0x43ba45e3,
    0x6ed6851e, 0x1963c419, 0x340f04e4, 0x2ba54e29, 0x06c98ed4,
    0x717ccfd3, 0x5c100f2e, 0x9e164ddd, 0xb37a8d20, 0xc4cfcc27,
    0xe9a30cda, 0xf0c049c2, 0xddac893f, 0xaa19c838, 0x877508c5,
    0x45734a36, 0x681f8acb, 0x1faacbcc, 0x32c60b31, 0x20fe5e56,
    0x0d929eab, 0x7a27dfac, 0x574b1f51, 0x954d5da2, 0xb8219d5f,
    0xcf94dc58, 0xe2f81ca5, 0xfb9b59bd, 0xd6f79940, 0xa142d847,
    0x8c2e18ba, 0x4e285a49, 0x63449ab4, 0x14f1dbb3, 0x399d1b4e,
    0x26375183, 0x0b5b917e, 0x7ceed079, 0x51821084, 0x93845277,
    0xbee8928a, 0xc95dd38d, 0xe4311370, 0xfd525668, 0xd03e9695,
    0xa78bd792, 0x8ae7176f, 0x48e1559c, 0x658d9561, 0x1238d466,
    0x3f54149b},
   {0x00000000, 0x6c90fd50, 0xd921faa0, 0xb5b107f0, 0x0240f543,
    0x6ed00813, 0xdb610fe3, 0xb7f1f2b3, 0x0481ea86, 0x681117d6,
    0xdda01026, 0xb130ed76, 0x06c11fc5, 0x6a51e295, 0xdfe0e565,
    0xb3701835, 0x0903d50c, 0x6593285c, 0xd0222fac, 0xbcb2d2fc,
    0x0b43204f, 0x67d3dd1f, 0xd262daef, 0xbef227bf, 0x0d823f8a,
    0x6112c2da, 0xd4a3c52a, 0xb833387a, 0x0fc2cac9, 0x63523799,
    0xd6e33069, 0xba73cd39, 0x1207aa18, 0x7e975748, 0xcb2650b8,
    0xa7b6ade8, 0x10475f5b, 0x7cd7a20b, 0xc966a5fb, 0xa5f658ab,
    0x1686409e, 0x7a16bdce, 0xcfa7ba3e, 0xa337476e, 0x14c6b5dd,
    0x7856488d, 0xcde74f7d, 0xa177b22d, 0x1b047f14, 0x77948244,
    0xc22585b4, 0xaeb578e4, 0x19448a57, 0x75d47707, 0xc06570f7,
    0xacf58da7, 0x1f859592, 0x731568c2, 0xc6a46f32, 0xaa349262,
    0x1dc560d1, 0x71559d81, 0xc4e49a71, 0xa8746721, 0x240f5430,
    0x489fa960, 0xfd2eae90, 0x91be53c0, 0x264fa173, 0x4adf5c23,
    0xff6e5bd3, 0x93fea683, 0x208ebeb6, 0x4c1e43e6, 0xf9af4416,
    0x953fb946, 0x22ce4bf5, 0x4e5eb6a5, 0xfbefb155, 0x977f4c05,
    0x2d0c813c, 0x419c7c6c, 0xf42d7b9c, 0x98bd86cc, 0x2f4c747f,
    0x43dc892f, 0xf66d8edf, 0x9afd738f, 0x298d6bba, 0x451d96ea,
    0xf0ac911a, 0x9c3c6c4a, 0x2bcd9ef9, 0x475d63a9, 0xf2ec6459,
    0x9e7c9909, 0x3608fe28, 0x5a980378, 0xef290488, 0x83b9f9d8,
    0x34480b6b, 0x58d8f63b, 0xed69f1cb, 0x81f90c9b, 0x328914ae,
    0x5e19e9fe, 0xeba8ee0e, 0x8738135e, 0x30c9e1ed, 0x5c591cbd,
    0xe9e81b4d, 0x8578e61d, 0x3f0b2b24, 0x539bd674, 0xe62ad184,
    0x8aba2cd4, 0x3d4bde67, 0x51db2337, 0xe46a24c7, 0x88fad997,
    0x3b8ac1a2, 0x571a3cf2, 0xe2ab3b02, 0x8e3bc652, 0x39ca34e1,
    0x555ac9b1, 0xe0ebce41, 0x8c7b3311, 0x481ea860, 0x248e5530,
    0x913f52c0, 0xfdafaf90, 0x4a5e5d23, 0x26cea073, 0x937fa783,
    0xffef5ad3, 0x4c9f42e6, 0x200fbfb6, 0x95beb846, 0xf92e4516,
    0x4edfb7a5, 0x224f4af5, 0x97fe4d05, 0xfb6eb055, 0x411d7d6c,
    0x2d8d803c, 0x983c87cc, 0xf4ac7a9c, 0x435d882f, 0x2fcd757f,
    0x9a7c728f, 0xf6ec8fdf, 0x459c97ea, 0x290c6aba, 0x9cbd6d4a,
    0xf02d901a, 0x47dc62a9, 0x2b4c9ff9, 0x9efd9809, 0xf26d6559,
    0x5a190278, 0x3689ff28, 0x8338f8d8, 0xefa80588, 0x5859f73b,
    0x34c90a6b, 0x81780d9b, 0xede8f0cb, 0x5e98e8fe, 0x320815ae,
    0x87b9125e, 0xeb29ef0e, 0x5cd81dbd, 0x3048e0ed, 0x85f9e71d,
    0xe9691a4d, 0x531ad774, 0x3f8a2a24, 0x8a3b2dd4, 0xe6abd084,
    0x515a2237, 0x3dcadf67, 0x887bd897, 0xe4eb25c7, 0x579b3df2,
    0x3b0bc0a2, 0x8ebac752, 0xe22a3a02, 0x55dbc8b1, 0x394b35e1,
    0x8cfa3211, 0xe06acf41, 0x6c11fc50, 0x00810100, 0xb53006f0,
    0xd9a0fba0, 0x6e510913, 0x02c1f443, 0xb770f3b3, 0xdbe00ee3,
    0x689016d6, 0x0400eb86, 0xb1b1ec76, 0xdd211126, 0x6ad0e395,
    0x06401ec5, 0xb3f11935, 0xdf61e465, 0x6512295c, 0x0982d40c,
    0xbc33d3fc, 0xd0a32eac, 0x6752dc1f, 0x0bc2214f, 0xbe7326bf,
    0xd2e3dbef, 0x6193c3da, 0x0d033e8a, 0xb8b2397a, 0xd422c42a,
    0x63d33699, 0x0f43cbc9, 0xbaf2cc39, 0xd6623169, 0x7e165648,
    0x1286ab18, 0xa737ace8, 0xcba751b8, 0x7c56a30b, 0x10c65e5b,
    0xa57759ab, 0xc9e7a4fb, 0x7a97bcce, 0x1607419e, 0xa3b6466e,
    0xcf26bb3e, 0x78d7498d, 0x1447b4dd, 0xa1f6b32d, 0xcd664e7d,
    0x77158344, 0x1b857e14, 0xae3479e4, 0xc2a484b4, 0x75557607,
    0x19c58b57, 0xac748ca7, 0xc0e471f7, 0x739469c2, 0x1f049492,
    0xaab59362, 0xc6256e32, 0x71d49c81, 0x1d4461d1, 0xa8f56621,
    0xc4659b71},
   {0x00000000, 0x903d50c0, 0x9079a183, 0x0044f143, 0x90f04305,
    0x00cd13c5, 0x0089e286, 0x90b4b246, 0x91e38609, 0x01ded6c9,
    0x019a278a, 0x91a7774a, 0x0113c50c, 0x912e95cc, 0x916a648f,
    0x0157344f, 0x93c40c11, 0x03f95cd1, 0x03bdad92, 0x9380fd52,
    0x03344f14, 0x93091fd4, 0x934dee97, 0x0370be57, 0x02278a18,
    0x921adad8, 0x925e2b9b, 0x02637b5b, 0x92d7c91d, 0x02ea99dd,
    0x02ae689e, 0x9293385e, 0x978b1821, 0x07b648e1, 0x07f2b9a2,
    0x97cfe962, 0x077b5b24, 0x97460be4, 0x9702faa7, 0x073faa67,
    0x06689e28, 0x9655cee8, 0x96113fab, 0x062c6f6b, 0x9698dd2d,
    0x06a58ded, 0x06e17cae, 0x96dc2c6e, 0x044f1430, 0x947244f0,
    0x9436b5b3, 0x040be573, 0x94bf5735, 0x048207f5, 0x04c6f6b6,
    0x94fba676, 0x95ac9239, 0x0591c2f9, 0x05d533ba, 0x95e8637a,
    0x055cd13c, 0x956181fc, 0x952570bf, 0x0518207f, 0x9f153041,
    0x0f286081, 0x0f6c91c2, 0x9f51c102, 0x0fe57344, 0x9fd82384,
    0x9f9cd2c7, 0x0fa18207, 0x0ef6b648, 0x9ecbe688, 0x9e8f17cb,
    0x0eb2470b, 0x9e06f54d, 0x0e3ba58d, 0x0e7f54ce, 0x9e42040e,
    0x0cd13c50, 0x9cec6c90, 0x9ca89dd3, 0x0c95cd13, 0x9c217f55,
    0x0c1c2f95, 0x0c58ded6, 0x9c658e16, 0x9d32ba59, 0x0d0fea99,
    0x0d4b1bda, 0x9d764b1a, 0x0dc2f95c, 0x9dffa99c, 0x9dbb58df,
    0x0d86081f, 0x089e2860, 0x98a378a0, 0x98e789e3, 0x08dad923,
    0x986e6b65, 0x08533ba5, 0x0817cae6, 0x982a9a26, 0x997dae69,
    0x0940fea9, 0x09040fea, 0x99395f2a, 0x098ded6c, 0x99b0bdac,
    0x99f44cef, 0x09c91c2f, 0x9b5a2471, 0x0b6774b1, 0x0b2385f2,
    0x9b1ed532, 0x0baa6774, 0x9b9737b4, 0x9bd3c6f7, 0x0bee9637,
    0x0ab9a278, 0x9a84f2b8, 0x9ac003fb, 0x0afd533b, 0x9a49e17d,
    0x0a74b1bd, 0x0a3040fe, 0x9a0d103e, 0x8e296081, 0x1e143041,
    0x1e50c102, 0x8e6d91c2, 0x1ed92384, 0x8ee47344, 0x8ea08207,
    0x1e9dd2c7, 0x1fcae688, 0x8ff7b648, 0x8fb3470b, 0x1f8e17cb,
    0x8f3aa58d, 0x1f07f54d, 0x1f43040e, 0x8f7e54ce, 0x1ded6c90,
    0x8dd03c50, 0x8d94cd13, 0x1da99dd3, 0x8d1d2f95, 0x1d207f55,
    0x1d648e16, 0x8d59ded6, 0x8c0eea99, 0x1c33ba59, 0x1c774b1a,
    0x8c4a1bda, 0x1cfea99c, 0x8cc3f95c, 0x8c87081f, 0x1cba58df,
    0x19a278a0, 0x899f2860, 0x89dbd923, 0x19e689e3, 0x89523ba5,
    0x196f6b65, 0x192b9a26, 0x8916cae6, 0x8841fea9, 0x187cae69,
    0x18385f2a, 0x88050fea, 0x18b1bdac, 0x888ced6c, 0x88c81c2f,
    0x18f54cef, 0x8a6674b1, 0x1a5b2471, 0x1a1fd532, 0x8a2285f2,
    0x1a9637b4, 0x8aab6774, 0x8aef9637, 0x1ad2c6f7, 0x1b85f2b8,
    0x8bb8a278, 0x8bfc533b, 0x1bc103fb, 0x8b75b1bd, 0x1b48e17d,
    0x1b0c103e, 0x8b3140fe, 0x113c50c0, 0x81010000, 0x8145f143,
    0x1178a183, 0x81cc13c5, 0x11f14305, 0x11b5b246, 0x8188e286,
    0x80dfd6c9, 0x10e28609, 0x10a6774a, 0x809b278a, 0x102f95cc,
    0x8012c50c, 0x8056344f, 0x106b648f, 0x82f85cd1, 0x12c50c11,
    0x1281fd52, 0x82bcad92, 0x12081fd4, 0x82354f14, 0x8271be57,
    0x124cee97, 0x131bdad8, 0x83268a18, 0x83627b5b, 0x135f2b9b,
    0x83eb99dd, 0x13d6c91d, 0x1392385e, 0x83af689e, 0x86b748e1,
    0x168a1821, 0x16cee962, 0x86f3b9a2, 0x16470be4, 0x867a5b24,
    0x863eaa67, 0x1603faa7, 0x1754cee8, 0x87699e28, 0x872d6f6b,
    0x17103fab, 0x87a48ded, 0x1799dd2d, 0x17dd2c6e, 0x87e07cae,
    0x157344f0, 0x854e1430, 0x850ae573, 0x1537b5b3, 0x858307f5,
    0x15be5735, 0x15faa676, 0x85c7f6b6, 0x8490c2f9, 0x14ad9239,
    0x14e9637a, 0x84d433ba, 0x146081fc, 0x845dd13c, 0x8419207f,
    0x142470bf},
   {0x00000000, 0xac51c101, 0xe8a08201, 0x44f14300, 0x61420401,
    0xcd13c500, 0x89e28600, 0x25b34701, 0xc2840802, 0x6ed5c903,
    0x2a248a03, 0x86754b02, 0xa3c60c03, 0x0f97cd02, 0x4b668e02,
    0xe7374f03, 0x350b1007, 0x995ad106, 0xddab9206, 0x71fa5307,
    0x54491406, 0xf818d507, 0xbce99607, 0x10b85706, 0xf78f1805,
    0x5bded904, 0x1f2f9a04, 0xb37e5b05, 0x96cd1c04, 0x3a9cdd05,
    0x7e6d9e05, 0xd23c5f04, 0x6a16200e, 0xc647e10f, 0x82b6a20f,
    0x2ee7630e, 0x0b54240f, 0xa705e50e, 0xe3f4a60e, 0x4fa5670f,
    0xa892280c, 0x04c3e90d, 0x4032aa0d, 0xec636b0c, 0xc9d02c0d,
    0x6581ed0c, 0x2170ae0c, 0x8d216f0d, 0x5f1d3009, 0xf34cf108,
    0xb7bdb208, 0x1bec7309, 0x3e5f3408, 0x920ef509, 0xd6ffb609,
    0x7aae7708, 0x9d99380b, 0x31c8f90a, 0x7539ba0a, 0xd9687b0b,
    0xfcdb3c0a, 0x508afd0b, 0x147bbe0b, 0xb82a7f0a, 0xd42c401c,
    0x787d811d, 0x3c8cc21d, 0x90dd031c, 0xb56e441d, 0x193f851c,
    0x5dcec61c, 0xf19f071d, 0x16a8481e, 0xbaf9891f, 0xfe08ca1f,
    0x52590b1e, 0x77ea4c1f, 0xdbbb8d1e, 0x9f4ace1e, 0x331b0f1f,
    0xe127501b, 0x4d76911a, 0x0987d21a, 0xa5d6131b, 0x8065541a,
    0x2c34951b, 0x68c5d61b, 0xc494171a, 0x23a35819, 0x8ff29918,
    0xcb03da18, 0x67521b19, 0x42e15c18, 0xeeb09d19, 0xaa41de19,
    0x06101f18, 0xbe3a6012, 0x126ba113, 0x569ae213, 0xfacb2312,
    0xdf786413, 0x7329a512, 0x37d8e612, 0x9b892713, 0x7cbe6810,
    0xd0efa911, 0x941eea11, 0x384f2b10, 0x1dfc6c11, 0xb1adad10,
    0xf55cee10, 0x590d2f11, 0x8b317015, 0x2760b114, 0x6391f214,
    0xcfc03315, 0xea737414, 0x4622b515, 0x02d3f615, 0xae823714,
    0x49b57817, 0xe5e4b916, 0xa115fa16, 0x0d443b17, 0x28f77c16,
    0x84a6bd17, 0xc057fe17, 0x6c063f16, 0x185b803b, 0xb40a413a,
    0xf0fb023a, 0x5caac33b, 0x7919843a, 0xd548453b, 0x91b9063b,
    0x3de8c73a, 0xdadf8839, 0x768e4938, 0x327f0a38, 0x9e2ecb39,
    0xbb9d8c38, 0x17cc4d39, 0x533d0e39, 0xff6ccf38, 0x2d50903c,
    0x8101513d, 0xc5f0123d, 0x69a1d33c, 0x4c12943d, 0xe043553c,
    0xa4b2163c, 0x08e3d73d, 0xefd4983e, 0x4385593f, 0x07741a3f,
    0xab25db3e, 0x8e969c3f, 0x22c75d3e, 0x66361e3e, 0xca67df3f,
    0x724da035, 0xde1c6134, 0x9aed2234, 0x36bce335, 0x130fa434,
    0xbf5e6535, 0xfbaf2635, 0x57fee734, 0xb0c9a837, 0x1c986936,
    0x58692a36, 0xf438eb37, 0xd18bac36, 0x7dda6d37, 0x392b2e37,
    0x957aef36, 0x4746b032, 0xeb177133, 0xafe63233, 0x03b7f332,
    0x2604b433, 0x8a557532, 0xcea43632, 0x62f5f733, 0x85c2b830,
    0x29937931, 0x6d623a31, 0xc133fb30, 0xe480bc31, 0x48d17d30,
    0x0c203e30, 0xa071ff31, 0xcc77c027, 0x60260126, 0x24d74226,
    0x88868327, 0xad35c426, 0x01640527, 0x45954627, 0xe9c48726,
    0x0ef3c825, 0xa2a20924, 0xe6534a24, 0x4a028b25, 0x6fb1cc24,
    0xc3e00d25, 0x87114e25, 0x2b408f24, 0xf97cd020, 0x552d1121,
    0x11dc5221, 0xbd8d9320, 0x983ed421, 0x346f1520, 0x709e5620,
    0xdccf9721, 0x3bf8d822, 0x97a91923, 0xd3585a23, 0x7f099b22,
    0x5abadc23, 0xf6eb1d22, 0xb21a5e22, 0x1e4b9f23, 0xa661e029,
    0x0a302128, 0x4ec16228, 0xe290a329, 0xc723e428, 0x6b722529,
    0x2f836629, 0x83d2a728, 0x64e5e82b, 0xc8b4292a, 0x8c456a2a,
    0x2014ab2b, 0x05a7ec2a, 0xa9f62d2b, 0xed076e2b, 0x4156af2a,
    0x936af02e, 0x3f3b312f, 0x7bca722f, 0xd79bb32e, 0xf228f42f,
    0x5e79352e, 0x1a88762e, 0xb6d9b72f, 0x51eef82c, 0xfdbf392d,
    0xb94e7a2d, 0x151fbb2c, 0x30acfc2d, 0x9cfd3d2c, 0xd80c7e2c,
    0x745dbf2d},
   {0x00000000, 0x30b70076, 0x616e00ec, 0x51d9009a, 0xc2dc01d8,
    0xf26b01ae, 0xa3b20134, 0x93050142, 0x35bb03b3, 0x050c03c5,
    0x54d5035f, 0x64620329, 0xf767026b, 0xc7d0021d, 0x96090287,
    0xa6be02f1, 0x6b760766, 0x5bc10710, 0x0a18078a, 0x3aaf07fc,
    0xa9aa06be, 0x991d06c8, 0xc8c40652, 0xf8730624, 0x5ecd04d5,
    0x6e7a04a3, 0x3fa30439, 0x0f14044f, 0x9c11050d, 0xaca6057b,
    0xfd7f05e1, 0xcdc80597, 0xd6ec0ecc, 0xe65b0eba, 0xb7820e20,
    0x87350e56, 0x14300f14, 0x24870f62, 0x755e0ff8, 0x45e90f8e,
    0xe3570d7f, 0xd3e00d09, 0x82390d93, 0xb28e0de5, 0x218b0ca7,
    0x113c0cd1, 0x40e50c4b, 0x70520c3d, 0xbd9a09aa, 0x8d2d09dc,
    0xdcf40946, 0xec430930, 0x7f460872, 0x4ff10804, 0x1e28089e,
    0x2e9f08e8, 0x88210a19, 0xb8960a6f, 0xe94f0af5, 0xd9f80a83,
    0x4afd0bc1, 0x7a4a0bb7, 0x2b930b2d, 0x1b240b5b, 0x1ddb1d9b,
    0x2d6c1ded, 0x7cb51d77, 0x4c021d01, 0xdf071c43, 0xefb01c35,
    0xbe691caf, 0x8ede1cd9, 0x28601e28, 0x18d71e5e, 0x490e1ec4,
    0x79b91eb2, 0xeabc1ff0, 0xda0b1f86, 0x8bd21f1c, 0xbb651f6a,
    0x76ad1afd, 0x461a1a8b, 0x17c31a11, 0x27741a67, 0xb4711b25,
    0x84c61b53, 0xd51f1bc9, 0xe5a81bbf, 0x4316194e, 0x73a11938,
    0x227819a2, 0x12cf19d4, 0x81ca1896, 0xb17d18e0, 0xe0a4187a,
    0xd013180c, 0xcb371357, 0xfb801321, 0xaa5913bb, 0x9aee13cd,
    0x09eb128f, 0x395c12f9, 0x68851263, 0x58321215, 0xfe8c10e4,
    0xce3b1092, 0x9fe21008, 0xaf55107e, 0x3c50113c, 0x0ce7114a,
    0x5d3e11d0, 0x6d8911a6, 0xa0411431, 0x90f61447, 0xc12f14dd,
    0xf19814ab, 0x629d15e9, 0x522a159f, 0x03f31505, 0x33441573,
    0x95fa1782, 0xa54d17f4, 0xf494176e, 0xc4231718, 0x5726165a,
    0x6791162c, 0x364816b6, 0x06ff16c0, 0x3bb63b36, 0x0b013b40,
    0x5ad83bda, 0x6a6f3bac, 0xf96a3aee, 0xc9dd3a98, 0x98043a02,
    0xa8b33a74, 0x0e0d3885, 0x3eba38f3, 0x6f633869, 0x5fd4381f,
    0xccd1395d, 0xfc66392b, 0xadbf39b1, 0x9d0839c7, 0x50c03c50,
    0x60773c26, 0x31ae3cbc, 0x01193cca, 0x921c3d88, 0xa2ab3dfe,
    0xf3723d64, 0xc3c53d12, 0x657b3fe3, 0x55cc3f95, 0x04153f0f,
    0x34a23f79, 0xa7a73e3b, 0x97103e4d, 0xc6c93ed7, 0xf67e3ea1,
    0xed5a35fa, 0xdded358c, 0x8c343516, 0xbc833560, 0x2f863422,
    0x1f313454, 0x4ee834ce, 0x7e5f34b8, 0xd8e13649, 0xe856363f,
    0xb98f36a5, 0x893836d3, 0x1a3d3791, 0x2a8a37e7, 0x7b53377d,
    0x4be4370b, 0x862c329c, 0xb69b32ea, 0xe7423270, 0xd7f53206,
    0x44f03344, 0x74473332, 0x259e33a8, 0x152933de, 0xb397312f,
    0x83203159, 0xd2f931c3, 0xe24e31b5, 0x714b30f7, 0x41fc3081,
    0x1025301b, 0x2092306d, 0x266d26ad, 0x16da26db, 0x47032641,
    0x77b42637, 0xe4b12775, 0xd4062703, 0x85df2799, 0xb56827ef,
    0x13d6251e, 0x23612568, 0x72b825f2, 0x420f2584, 0xd10a24c6,
    0xe1bd24b0, 0xb064242a, 0x80d3245c, 0x4d1b21cb, 0x7dac21bd,
    0x2c752127, 0x1cc22151, 0x8fc72013, 0xbf702065, 0xeea920ff,
    0xde1e2089, 0x78a02278, 0x4817220e, 0x19ce2294, 0x297922e2,
    0xba7c23a0, 0x8acb23d6, 0xdb12234c, 0xeba5233a, 0xf0812861,
    0xc0362817, 0x91ef288d, 0xa15828fb, 0x325d29b9, 0x02ea29cf,
    0x53332955, 0x63842923, 0xc53a2bd2, 0xf58d2ba4, 0xa4542b3e,
    0x94e32b48, 0x07e62a0a, 0x37512a7c, 0x66882ae6, 0x563f2a90,
    0x9bf72f07, 0xab402f71, 0xfa992feb, 0xca2e2f9d, 0x592b2edf,
    0x699c2ea9, 0x38452e33, 0x08f22e45, 0xae4c2cb4, 0x9efb2cc2,
    0xcf222c58, 0xff952c2e, 0x6c902d6c, 0x5c272d1a, 0x0dfe2d80,
    0x3d492df6},
   {0x00000000, 0x776c766c, 0xeed8ecd8, 0x99b49ab4, 0x6db2d9b3,
    0x1adeafdf, 0x836a356b, 0xf4064307, 0xdb65b366, 0xac09c50a,
    0x35bd5fbe, 0x42d129d2, 0xb6d76ad5, 0xc1bb1cb9, 0x580f860d,
    0x2f63f061, 0x06c866cf, 0x71a410a3, 0xe8108a17, 0x9f7cfc7b,
    0x6b7abf7c, 0x1c16c910, 0x85a253a4, 0xf2ce25c8, 0xddadd5a9,
    0xaac1a3c5, 0x33753971, 0x44194f1d, 0xb01f0c1a, 0xc7737a76,
    0x5ec7e0c2, 0x29ab96ae, 0x0d90cd9e, 0x7afcbbf2, 0xe3482146,
    0x9424572a, 0x6022142d, 0x174e6241, 0x8efaf8f5, 0xf9968e99,
    0xd6f57ef8, 0xa1990894, 0x382d9220, 0x4f41e44c, 0xbb47a74b,
    0xcc2bd127, 0x559f4b93, 0x22f33dff, 0x0b58ab51, 0x7c34dd3d,
    0xe5804789, 0x92ec31e5, 0x66ea72e2, 0x1186048e, 0x88329e3a,
    0xff5ee856, 0xd03d1837, 0xa7516e5b, 0x3ee5f4ef, 0x49898283,
    0xbd8fc184, 0xcae3b7e8, 0x53572d5c, 0x243b5b30, 0x1b219b3c,
    0x6c4ded50, 0xf5f977e4, 0x82950188, 0x7693428f, 0x01ff34e3,
    0x984bae57, 0xef27d83b, 0xc044285a, 0xb7285e36, 0x2e9cc482,
    0x59f0b2ee, 0xadf6f1e9, 0xda9a8785, 0x432e1d31, 0x34426b5d,
    0x1de9fdf3, 0x6a858b9f, 0xf331112b, 0x845d6747, 0x705b2440,
    0x0737522c, 0x9e83c898, 0xe9efbef4, 0xc68c4e95, 0xb1e038f9,
    0x2854a24d, 0x5f38d421, 0xab3e9726, 0xdc52e14a, 0x45e67bfe,
    0x328a0d92, 0x16b156a2, 0x61dd20ce, 0xf869ba7a, 0x8f05cc16,
    0x7b038f11, 0x0c6ff97d, 0x95db63c9, 0xe2b715a5, 0xcdd4e5c4,
    0xbab893a8, 0x230c091c, 0x54607f70, 0xa0663c77, 0xd70a4a1b,
    0x4ebed0af, 0x39d2a6c3, 0x1079306d, 0x67154601, 0xfea1dcb5,
    0x89cdaad9, 0x7dcbe9de, 0x0aa79fb2, 0x93130506, 0xe47f736a,
    0xcb1c830b, 0xbc70f567, 0x25c46fd3, 0x52a819bf, 0xa6ae5ab8,
    0xd1c22cd4, 0x4876b660, 0x3f1ac00c, 0x36433678, 0x412f4014,
    0xd89bdaa0, 0xaff7accc, 0x5bf1efcb, 0x2c9d99a7, 0xb5290313,
    0xc245757f, 0xed26851e, 0x9a4af372, 0x03fe69c6, 0x74921faa,
    0x80945cad, 0xf7f82ac1, 0x6e4cb075, 0x1920c619, 0x308b50b7,
    0x47e726db, 0xde53bc6f, 0xa93fca03, 0x5d398904, 0x2a55ff68,
    0xb3e165dc, 0xc48d13b0, 0xebeee3d1, 0x9c8295bd, 0x05360f09,
    0x725a7965, 0x865c3a62, 0xf1304c0e, 0x6884d6ba, 0x1fe8a0d6,
    0x3bd3fbe6, 0x4cbf8d8a, 0xd50b173e, 0xa2676152, 0x56612255,
    0x210d5439, 0xb8b9ce8d, 0xcfd5b8e1, 0xe0b64880, 0x97da3eec,
    0x0e6ea458, 0x7902d234, 0x8d049133, 0xfa68e75f, 0x63dc7deb,
    0x14b00b87, 0x3d1b9d29, 0x4a77eb45, 0xd3c371f1, 0xa4af079d,
    0x50a9449a, 0x27c532f6, 0xbe71a842, 0xc91dde2e, 0xe67e2e4f,
    0x91125823, 0x08a6c297, 0x7fcab4fb, 0x8bccf7fc, 0xfca08190,
    0x65141b24, 0x12786d48, 0x2d62ad44, 0x5a0edb28, 0xc3ba419c,
    0xb4d637f0, 0x40d074f7, 0x37bc029b, 0xae08982f, 0xd964ee43,
    0xf6071e22, 0x816b684e, 0x18dff2fa, 0x6fb38496, 0x9bb5c791,
    0xecd9b1fd, 0x756d2b49, 0x02015d25, 0x2baacb8b, 0x5cc6bde7,
    0xc5722753, 0xb21e513f, 0x46181238, 0x31746454, 0xa8c0fee0,
    0xdfac888c, 0xf0cf78ed, 0x87a30e81, 0x1e179435, 0x697be259,
    0x9d7da15e, 0xea11d732, 0x73a54d86, 0x04c93bea, 0x20f260da,
    0x579e16b6, 0xce2a8c02, 0xb946fa6e, 0x4d40b969, 0x3a2ccf05,
    0xa39855b1, 0xd4f423dd, 0xfb97d3bc, 0x8cfba5d0, 0x154f3f64,
    0x62234908, 0x96250a0f, 0xe1497c63, 0x78fde6d7, 0x0f9190bb,
    0x263a0615, 0x51567079, 0xc8e2eacd, 0xbf8e9ca1, 0x4b88dfa6,
    0x3ce4a9ca, 0xa550337e, 0xd23c4512, 0xfd5fb573, 0x8a33c31f,
    0x138759ab, 0x64eb2fc7, 0x90ed6cc0, 0xe7811aac, 0x7e358018,
    0x0959f674},
   {0x00000000, 0x6c866cf0, 0xd90cd9e0, 0xb58ab510, 0x021ab3c3,
    0x6e9cdf33, 0xdb166a23, 0xb79006d3, 0x04356786, 0x68b30b76,
    0xdd39be66, 0xb1bfd296, 0x062fd445, 0x6aa9b8b5, 0xdf230da5,
    0xb3a56155, 0x086acf0c, 0x64eca3fc, 0xd16616ec, 0xbde07a1c,
    0x0a707ccf, 0x66f6103f, 0xd37ca52f, 0xbffac9df, 0x0c5fa88a,
    0x60d9c47a, 0xd553716a, 0xb9d51d9a, 0x0e451b49, 0x62c377b9,
    0xd749c2a9, 0xbbcfae59, 0x10d59e18, 0x7c53f2e8, 0xc9d947f8,
    0xa55f2b08, 0x12cf2ddb, 0x7e49412b, 0xcbc3f43b, 0xa74598cb,
    0x14e0f99e, 0x7866956e, 0xcdec207e, 0xa16a4c8e, 0x16fa4a5d,
    0x7a7c26ad, 0xcff693bd, 0xa370ff4d, 0x18bf5114, 0x74393de4,
    0xc1b388f4, 0xad35e404, 0x1aa5e2d7, 0x76238e27, 0xc3a93b37,
    0xaf2f57c7, 0x1c8a3692, 0x700c5a62, 0xc586ef72, 0xa9008382,
    0x1e908551, 0x7216e9a1, 0xc79c5cb1, 0xab1a3041, 0x21ab3c30,
    0x4d2d50c0, 0xf8a7e5d0, 0x94218920, 0x23b18ff3, 0x4f37e303,
    0xfabd5613, 0x963b3ae3, 0x259e5bb6, 0x49183746, 0xfc928256,
    0x9014eea6, 0x2784e875, 0x4b028485, 0xfe883195, 0x920e5d65,
    0x29c1f33c, 0x45479fcc, 0xf0cd2adc, 0x9c4b462c, 0x2bdb40ff,
    0x475d2c0f, 0xf2d7991f, 0x9e51f5ef, 0x2df494ba, 0x4172f84a,
    0xf4f84d5a, 0x987e21aa, 0x2fee2779, 0x43684b89, 0xf6e2fe99,
    0x9a649269, 0x317ea228, 0x5df8ced8, 0xe8727bc8, 0x84f41738,
    0x336411eb, 0x5fe27d1b, 0xea68c80b, 0x86eea4fb, 0x354bc5ae,
    0x59cda95e, 0xec471c4e, 0x80c170be, 0x3751766d, 0x5bd71a9d,
    0xee5daf8d, 0x82dbc37d, 0x39146d24, 0x559201d4, 0xe018b4c4,
    0x8c9ed834, 0x3b0edee7, 0x5788b217, 0xe2020707, 0x8e846bf7,
    0x3d210aa2, 0x51a76652, 0xe42dd342, 0x88abbfb2, 0x3f3bb961,
    0x53bdd591, 0xe6376081, 0x8ab10c71, 0x43567860, 0x2fd01490,
    0x9a5aa180, 0xf6dccd70, 0x414ccba3, 0x2dcaa753, 0x98401243,
    0xf4c67eb3, 0x47631fe6, 0x2be57316, 0x9e6fc606, 0xf2e9aaf6,
    0x4579ac25, 0x29ffc0d5, 0x9c7575c5, 0xf0f31935, 0x4b3cb76c,
    0x27badb9c, 0x92306e8c, 0xfeb6027c, 0x492604af, 0x25a0685f,
    0x902add4f, 0xfcacb1bf, 0x4f09d0ea, 0x238fbc1a, 0x9605090a,
    0xfa8365fa, 0x4d136329, 0x21950fd9, 0x941fbac9, 0xf899d639,
    0x5383e678, 0x3f058a88, 0x8a8f3f98, 0xe6095368, 0x519955bb,
    0x3d1f394b, 0x88958c5b, 0xe413e0ab, 0x57b681fe, 0x3b30ed0e,
    0x8eba581e, 0xe23c34ee, 0x55ac323d, 0x392a5ecd, 0x8ca0ebdd,
    0xe026872d, 0x5be92974, 0x376f4584, 0x82e5f094, 0xee639c64,
    0x59f39ab7, 0x3575f647, 0x80ff4357, 0xec792fa7, 0x5fdc4ef2,
    0x335a2202, 0x86d09712, 0xea56fbe2, 0x5dc6fd31, 0x314091c1,
    0x84ca24d1, 0xe84c4821, 0x62fd4450, 0x0e7b28a0, 0xbbf19db0,
    0xd777f140, 0x60e7f793, 0x0c619b63, 0xb9eb2e73, 0xd56d4283,
    0x66c823d6, 0x0a4e4f26, 0xbfc4fa36, 0xd34296c6, 0x64d29015,
    0x0854fce5, 0xbdde49f5, 0xd1582505, 0x6a978b5c, 0x0611e7ac,
    0xb39b52bc, 0xdf1d3e4c, 0x688d389f, 0x040b546f, 0xb181e17f,
    0xdd078d8f, 0x6ea2ecda, 0x0224802a, 0xb7ae353a, 0xdb2859ca,
    0x6cb85f19, 0x003e33e9, 0xb5b486f9, 0xd932ea09, 0x7228da48,
    0x1eaeb6b8, 0xab2403a8, 0xc7a26f58, 0x7032698b, 0x1cb4057b,
    0xa93eb06b, 0xc5b8dc9b, 0x761dbdce, 0x1a9bd13e, 0xaf11642e,
    0xc39708de, 0x74070e0d, 0x188162fd, 0xad0bd7ed, 0xc18dbb1d,
    0x7a421544, 0x16c479b4, 0xa34ecca4, 0xcfc8a054, 0x7858a687,
    0x14deca77, 0xa1547f67, 0xcdd21397, 0x7e7772c2, 0x12f11e32,
    0xa77bab22, 0xcbfdc7d2, 0x7c6dc101, 0x10ebadf1, 0xa56118e1,
    0xc9e77411}};

static const word_t crc_braid_big_table[][256] = {
   {0x0000000000000000, 0xf06c866c00000000, 0xe0d90cd900000000,
    0x10b58ab500000000, 0xc3b31a0200000000, 0x33df9c6e00000000,
    0x236a16db00000000, 0xd30690b700000000, 0x8667350400000000,
    0x760bb36800000000, 0x66be39dd00000000, 0x96d2bfb100000000,
    0x45d42f0600000000, 0xb5b8a96a00000000, 0xa50d23df00000000,
    0x5561a5b300000000, 0x0ccf6a0800000000, 0xfca3ec6400000000,
    0xec1666d100000000, 0x1c7ae0bd00000000, 0xcf7c700a00000000,
    0x3f10f66600000000, 0x2fa57cd300000000, 0xdfc9fabf00000000,
    0x8aa85f0c00000000, 0x7ac4d96000000000, 0x6a7153d500000000,
    0x9a1dd5b900000000, 0x491b450e00000000, 0xb977c36200000000,
    0xa9c249d700000000, 0x59aecfbb00000000, 0x189ed51000000000,
    0xe8f2537c00000000, 0xf847d9c900000000, 0x082b5fa500000000,
    0xdb2dcf1200000000, 0x2b41497e00000000, 0x3bf4c3cb00000000,
    0xcb9845a700000000, 0x9ef9e01400000000, 0x6e95667800000000,
    0x7e20eccd00000000, 0x8e4c6aa100000000, 0x5d4afa1600000000,
    0xad267c7a00000000, 0xbd93f6cf00000000, 0x4dff70a300000000,
    0x1451bf1800000000, 0xe43d397400000000, 0xf488b3c100000000,
    0x04e435ad00000000, 0xd7e2a51a00000000, 0x278e237600000000,
    0x373ba9c300000000, 0xc7572faf00000000, 0x92368a1c00000000,
    0x625a0c7000000000, 0x72ef86c500000000, 0x828300a900000000,
    0x5185901e00000000, 0xa1e9167200000000, 0xb15c9cc700000000,
    0x41301aab00000000, 0x303cab2100000000, 0xc0502d4d00000000,
    0xd0e5a7f800000000, 0x2089219400000000, 0xf38fb12300000000,
    0x03e3374f00000000, 0x1356bdfa00000000, 0xe33a3b9600000000,
    0xb65b9e2500000000, 0x4637184900000000, 0x568292fc00000000,
    0xa6ee149000000000, 0x75e8842700000000, 0x8584024b00000000,
    0x953188fe00000000, 0x655d0e9200000000, 0x3cf3c12900000000,
    0xcc9f474500000000, 0xdc2acdf000000000, 0x2c464b9c00000000,
    0xff40db2b00000000, 0x0f2c5d4700000000, 0x1f99d7f200000000,
    0xeff5519e00000000, 0xba94f42d00000000, 0x4af8724100000000,
    0x5a4df8f400000000, 0xaa217e9800000000, 0x7927ee2f00000000,
    0x894b684300000000, 0x99fee2f600000000, 0x6992649a00000000,
    0x28a27e3100000000, 0xd8cef85d00000000, 0xc87b72e800000000,
    0x3817f48400000000, 0xeb11643300000000, 0x1b7de25f00000000,
    0x0bc868ea00000000, 0xfba4ee8600000000, 0xaec54b3500000000,
    0x5ea9cd5900000000, 0x4e1c47ec00000000, 0xbe70c18000000000,
    0x6d76513700000000, 0x9d1ad75b00000000, 0x8daf5dee00000000,
    0x7dc3db8200000000, 0x246d143900000000, 0xd401925500000000,
    0xc4b418e000000000, 0x34d89e8c00000000, 0xe7de0e3b00000000,
    0x17b2885700000000, 0x070702e200000000, 0xf76b848e00000000,
    0xa20a213d00000000, 0x5266a75100000000, 0x42d32de400000000,
    0xb2bfab8800000000, 0x61b93b3f00000000, 0x91d5bd5300000000,
    0x816037e600000000, 0x710cb18a00000000, 0x6078564300000000,
    0x9014d02f00000000, 0x80a15a9a00000000, 0x70cddcf600000000,
    0xa3cb4c4100000000, 0x53a7ca2d00000000, 0x4312409800000000,
    0xb37ec6f400000000, 0xe61f634700000000, 0x1673e52b00000000,
    0x06c66f9e00000000, 0xf6aae9f200000000, 0x25ac794500000000,
    0xd5c0ff2900000000, 0xc575759c00000000, 0x3519f3f000000000,
    0x6cb73c4b00000000, 0x9cdbba2700000000, 0x8c6e309200000000,
    0x7c02b6fe00000000, 0xaf04264900000000, 0x5f68a02500000000,
    0x4fdd2a9000000000, 0xbfb1acfc00000000, 0xead0094f00000000,
    0x1abc8f2300000000, 0x0a09059600000000, 0xfa6583fa00000000,
    0x2963134d00000000, 0xd90f952100000000, 0xc9ba1f9400000000,
    0x39d699f800000000, 0x78e6835300000000, 0x888a053f00000000,
    0x983f8f8a00000000, 0x685309e600000000, 0xbb55995100000000,
    0x4b391f3d00000000, 0x5b8c958800000000, 0xabe013e400000000,
    0xfe81b65700000000, 0x0eed303b00000000, 0x1e58ba8e00000000,
    0xee343ce200000000, 0x3d32ac5500000000, 0xcd5e2a3900000000,
    0xddeba08c00000000, 0x2d8726e000000000, 0x7429e95b00000000,
    0x84456f3700000000, 0x94f0e58200000000, 0x649c63ee00000000,
    0xb79af35900000000, 0x47f6753500000000, 0x5743ff8000000000,
    0xa72f79ec00000000, 0xf24edc5f00000000, 0x02225a3300000000,
    0x1297d08600000000, 0xe2fb56ea00000000, 0x31fdc65d00000000,
    0xc191403100000000, 0xd124ca8400000000, 0x21484ce800000000,
    0x5044fd6200000000, 0xa0287b0e00000000, 0xb09df1bb00000000,
    0x40f177d700000000, 0x93f7e76000000000, 0x639b610c00000000,
    0x732eebb900000000, 0x83426dd500000000, 0xd623c86600000000,
    0x264f4e0a00000000, 0x36fac4bf00000000, 0xc69642d300000000,
    0x1590d26400000000, 0xe5fc540800000000, 0xf549debd00000000,
    0x052558d100000000, 0x5c8b976a00000000, 0xace7110600000000,
    0xbc529bb300000000, 0x4c3e1ddf00000000, 0x9f388d6800000000,
    0x6f540b0400000000, 0x7fe181b100000000, 0x8f8d07dd00000000,
    0xdaeca26e00000000, 0x2a80240200000000, 0x3a35aeb700000000,
    0xca5928db00000000, 0x195fb86c00000000, 0xe9333e0000000000,
    0xf986b4b500000000, 0x09ea32d900000000, 0x48da287200000000,
    0xb8b6ae1e00000000, 0xa80324ab00000000, 0x586fa2c700000000,
    0x8b69327000000000, 0x7b05b41c00000000, 0x6bb03ea900000000,
    0x9bdcb8c500000000, 0xcebd1d7600000000, 0x3ed19b1a00000000,
    0x2e6411af00000000, 0xde0897c300000000, 0x0d0e077400000000,
    0xfd62811800000000, 0xedd70bad00000000, 0x1dbb8dc100000000,
    0x4415427a00000000, 0xb479c41600000000, 0xa4cc4ea300000000,
    0x54a0c8cf00000000, 0x87a6587800000000, 0x77cade1400000000,
    0x677f54a100000000, 0x9713d2cd00000000, 0xc272777e00000000,
    0x321ef11200000000, 0x22ab7ba700000000, 0xd2c7fdcb00000000,
    0x01c16d7c00000000, 0xf1adeb1000000000, 0xe11861a500000000,
    0x1174e7c900000000},
   {0x0000000000000000, 0x6c766c7700000000, 0xd8ecd8ee00000000,
    0xb49ab49900000000, 0xb3d9b26d00000000, 0xdfafde1a00000000,
    0x6b356a8300000000, 0x074306f400000000, 0x66b365db00000000,
    0x0ac509ac00000000, 0xbe5fbd3500000000, 0xd229d14200000000,
    0xd56ad7b600000000, 0xb91cbbc100000000, 0x0d860f5800000000,
    0x61f0632f00000000, 0xcf66c80600000000, 0xa310a47100000000,
    0x178a10e800000000, 0x7bfc7c9f00000000, 0x7cbf7a6b00000000,
    0x10c9161c00000000, 0xa453a28500000000, 0xc825cef200000000,
    0xa9d5addd00000000, 0xc5a3c1aa00000000, 0x7139753300000000,
    0x1d4f194400000000, 0x1a0c1fb000000000, 0x767a73c700000000,
    0xc2e0c75e00000000, 0xae96ab2900000000, 0x9ecd900d00000000,
    0xf2bbfc7a00000000, 0x462148e300000000, 0x2a57249400000000,
    0x2d14226000000000, 0x41624e1700000000, 0xf5f8fa8e00000000,
    0x998e96f900000000, 0xf87ef5d600000000, 0x940899a100000000,
    0x20922d3800000000, 0x4ce4414f00000000, 0x4ba747bb00000000,
    0x27d12bcc00000000, 0x934b9f5500000000, 0xff3df32200000000,
    0x51ab580b00000000, 0x3ddd347c00000000, 0x894780e500000000,
    0xe531ec9200000000, 0xe272ea6600000000, 0x8e04861100000000,
    0x3a9e328800000000, 0x56e85eff00000000, 0x37183dd000000000,
    0x5b6e51a700000000, 0xeff4e53e00000000, 0x8382894900000000,
    0x84c18fbd00000000, 0xe8b7e3ca00000000, 0x5c2d575300000000,
    0x305b3b2400000000, 0x3c9b211b00000000, 0x50ed4d6c00000000,
    0xe477f9f500000000, 0x8801958200000000, 0x8f42937600000000,
    0xe334ff0100000000, 0x57ae4b9800000000, 0x3bd827ef00000000,
    0x5a2844c000000000, 0x365e28b700000000, 0x82c49c2e00000000,
    0xeeb2f05900000000, 0xe9f1f6ad00000000, 0x85879ada00000000,
    0x311d2e4300000000, 0x5d6b423400000000, 0xf3fde91d00000000,
    0x9f8b856a00000000, 0x2b1131f300000000, 0x47675d8400000000,
    0x40245b7000000000, 0x2c52370700000000, 0x98c8839e00000000,
    0xf4beefe900000000, 0x954e8cc600000000, 0xf938e0b100000000,
    0x4da2542800000000, 0x21d4385f00000000, 0x26973eab00000000,
    0x4ae152dc00000000, 0xfe7be64500000000, 0x920d8a3200000000,
    0xa256b11600000000, 0xce20dd6100000000, 0x7aba69f800000000,
    0x16cc058f00000000, 0x118f037b00000000, 0x7df96f0c00000000,
    0xc963db9500000000, 0xa515b7e200000000, 0xc4e5d4cd00000000,
    0xa893b8ba00000000, 0x1c090c2300000000, 0x707f605400000000,
    0x773c66a000000000, 0x1b4a0ad700000000, 0xafd0be4e00000000,
    0xc3a6d23900000000, 0x6d30791000000000, 0x0146156700000000,
    0xb5dca1fe00000000, 0xd9aacd8900000000, 0xdee9cb7d00000000,
    0xb29fa70a00000000, 0x0605139300000000, 0x6a737fe400000000,
    0x0b831ccb00000000, 0x67f570bc00000000, 0xd36fc42500000000,
    0xbf19a85200000000, 0xb85aaea600000000, 0xd42cc2d100000000,
    0x60b6764800000000, 0x0cc01a3f00000000, 0x7836433600000000,
    0x14402f4100000000, 0xa0da9bd800000000, 0xccacf7af00000000,
    0xcbeff15b00000000, 0xa7999d2c00000000, 0x130329b500000000,
    0x7f7545c200000000, 0x1e8526ed00000000, 0x72f34a9a00000000,
    0xc669fe0300000000, 0xaa1f927400000000, 0xad5c948000000000,
    0xc12af8f700000000, 0x75b04c6e00000000, 0x19c6201900000000,
    0xb7508b3000000000, 0xdb26e74700000000, 0x6fbc53de00000000,
    0x03ca3fa900000000, 0x0489395d00000000, 0x68ff552a00000000,
    0xdc65e1b300000000, 0xb0138dc400000000, 0xd1e3eeeb00000000,
    0xbd95829c00000000, 0x090f360500000000, 0x65795a7200000000,
    0x623a5c8600000000, 0x0e4c30f100000000, 0xbad6846800000000,
    0xd6a0e81f00000000, 0xe6fbd33b00000000, 0x8a8dbf4c00000000,
    0x3e170bd500000000, 0x526167a200000000, 0x5522615600000000,
    0x39540d2100000000, 0x8dceb9b800000000, 0xe1b8d5cf00000000,
    0x8048b6e000000000, 0xec3eda9700000000, 0x58a46e0e00000000,
    0x34d2027900000000, 0x3391048d00000000, 0x5fe768fa00000000,
    0xeb7ddc6300000000, 0x870bb01400000000, 0x299d1b3d00000000,
    0x45eb774a00000000, 0xf171c3d300000000, 0x9d07afa400000000,
    0x9a44a95000000000, 0xf632c52700000000, 0x42a871be00000000,
    0x2ede1dc900000000, 0x4f2e7ee600000000, 0x2358129100000000,
    0x97c2a60800000000, 0xfbb4ca7f00000000, 0xfcf7cc8b00000000,
    0x9081a0fc00000000, 0x241b146500000000, 0x486d781200000000,
    0x44ad622d00000000, 0x28db0e5a00000000, 0x9c41bac300000000,
    0xf037d6b400000000, 0xf774d04000000000, 0x9b02bc3700000000,
    0x2f9808ae00000000, 0x43ee64d900000000, 0x221e07f600000000,
    0x4e686b8100000000, 0xfaf2df1800000000, 0x9684b36f00000000,
    0x91c7b59b00000000, 0xfdb1d9ec00000000, 0x492b6d7500000000,
    0x255d010200000000, 0x8bcbaa2b00000000, 0xe7bdc65c00000000,
    0x532772c500000000, 0x3f511eb200000000, 0x3812184600000000,
    0x5464743100000000, 0xe0fec0a800000000, 0x8c88acdf00000000,
    0xed78cff000000000, 0x810ea38700000000, 0x3594171e00000000,
    0x59e27b6900000000, 0x5ea17d9d00000000, 0x32d711ea00000000,
    0x864da57300000000, 0xea3bc90400000000, 0xda60f22000000000,
    0xb6169e5700000000, 0x028c2ace00000000, 0x6efa46b900000000,
    0x69b9404d00000000, 0x05cf2c3a00000000, 0xb15598a300000000,
    0xdd23f4d400000000, 0xbcd397fb00000000, 0xd0a5fb8c00000000,
    0x643f4f1500000000, 0x0849236200000000, 0x0f0a259600000000,
    0x637c49e100000000, 0xd7e6fd7800000000, 0xbb90910f00000000,
    0x15063a2600000000, 0x7970565100000000, 0xcdeae2c800000000,
    0xa19c8ebf00000000, 0xa6df884b00000000, 0xcaa9e43c00000000,
    0x7e3350a500000000, 0x12453cd200000000, 0x73b55ffd00000000,
    0x1fc3338a00000000, 0xab59871300000000, 0xc72feb6400000000,
    0xc06ced9000000000, 0xac1a81e700000000, 0x1880357e00000000,
    0x74f6590900000000},
   {0x0000000000000000, 0x7600b73000000000, 0xec006e6100000000,
    0x9a00d95100000000, 0xd801dcc200000000, 0xae016bf200000000,
    0x3401b2a300000000, 0x4201059300000000, 0xb303bb3500000000,
    0xc5030c0500000000, 0x5f03d55400000000, 0x2903626400000000,
    0x6b0267f700000000, 0x1d02d0c700000000, 0x8702099600000000,
    0xf102bea600000000, 0x6607766b00000000, 0x1007c15b00000000,
    0x8a07180a00000000, 0xfc07af3a00000000, 0xbe06aaa900000000,
    0xc8061d9900000000, 0x5206c4c800000000, 0x240673f800000000,
    0xd504cd5e00000000, 0xa3047a6e00000000, 0x3904a33f00000000,
    0x4f04140f00000000, 0x0d05119c00000000, 0x7b05a6ac00000000,
    0xe1057ffd00000000, 0x9705c8cd00000000, 0xcc0eecd600000000,
    0xba0e5be600000000, 0x200e82b700000000, 0x560e358700000000,
    0x140f301400000000, 0x620f872400000000, 0xf80f5e7500000000,
    0x8e0fe94500000000, 0x7f0d57e300000000, 0x090de0d300000000,
    0x930d398200000000, 0xe50d8eb200000000, 0xa70c8b2100000000,
    0xd10c3c1100000000, 0x4b0ce54000000000, 0x3d0c527000000000,
    0xaa099abd00000000, 0xdc092d8d00000000, 0x4609f4dc00000000,
    0x300943ec00000000, 0x7208467f00000000, 0x0408f14f00000000,
    0x9e08281e00000000, 0xe8089f2e00000000, 0x190a218800000000,
    0x6f0a96b800000000, 0xf50a4fe900000000, 0x830af8d900000000,
    0xc10bfd4a00000000, 0xb70b4a7a00000000, 0x2d0b932b00000000,
    0x5b0b241b00000000, 0x9b1ddb1d00000000, 0xed1d6c2d00000000,
    0x771db57c00000000, 0x011d024c00000000, 0x431c07df00000000,
    0x351cb0ef00000000, 0xaf1c69be00000000, 0xd91cde8e00000000,
    0x281e602800000000, 0x5e1ed71800000000, 0xc41e0e4900000000,
    0xb21eb97900000000, 0xf01fbcea00000000, 0x861f0bda00000000,
    0x1c1fd28b00000000, 0x6a1f65bb00000000, 0xfd1aad7600000000,
    0x8b1a1a4600000000, 0x111ac31700000000, 0x671a742700000000,
    0x251b71b400000000, 0x531bc68400000000, 0xc91b1fd500000000,
    0xbf1ba8e500000000, 0x4e19164300000000, 0x3819a17300000000,
    0xa219782200000000, 0xd419cf1200000000, 0x9618ca8100000000,
    0xe0187db100000000, 0x7a18a4e000000000, 0x0c1813d000000000,
    0x571337cb00000000, 0x211380fb00000000, 0xbb1359aa00000000,
    0xcd13ee9a00000000, 0x8f12eb0900000000, 0xf9125c3900000000,
    0x6312856800000000, 0x1512325800000000, 0xe4108cfe00000000,
    0x92103bce00000000, 0x0810e29f00000000, 0x7e1055af00000000,
    0x3c11503c00000000, 0x4a11e70c00000000, 0xd0113e5d00000000,
    0xa611896d00000000, 0x311441a000000000, 0x4714f69000000000,
    0xdd142fc100000000, 0xab1498f100000000, 0xe9159d6200000000,
    0x9f152a5200000000, 0x0515f30300000000, 0x7315443300000000,
    0x8217fa9500000000, 0xf4174da500000000, 0x6e1794f400000000,
    0x181723c400000000, 0x5a16265700000000, 0x2c16916700000000,
    0xb616483600000000, 0xc016ff0600000000, 0x363bb63b00000000,
    0x403b010b00000000, 0xda3bd85a00000000, 0xac3b6f6a00000000,
    0xee3a6af900000000, 0x983addc900000000, 0x023a049800000000,
    0x743ab3a800000000, 0x85380d0e00000000, 0xf338ba3e00000000,
    0x6938636f00000000, 0x1f38d45f00000000, 0x5d39d1cc00000000,
    0x2b3966fc00000000, 0xb139bfad00000000, 0xc739089d00000000,
    0x503cc05000000000, 0x263c776000000000, 0xbc3cae3100000000,
    0xca3c190100000000, 0x883d1c9200000000, 0xfe3daba200000000,
    0x643d72f300000000, 0x123dc5c300000000, 0xe33f7b6500000000,
    0x953fcc5500000000, 0x0f3f150400000000, 0x793fa23400000000,
    0x3b3ea7a700000000, 0x4d3e109700000000, 0xd73ec9c600000000,
    0xa13e7ef600000000, 0xfa355aed00000000, 0x8c35eddd00000000,
    0x1635348c00000000, 0x603583bc00000000, 0x2234862f00000000,
    0x5434311f00000000, 0xce34e84e00000000, 0xb8345f7e00000000,
    0x4936e1d800000000, 0x3f3656e800000000, 0xa5368fb900000000,
    0xd336388900000000, 0x91373d1a00000000, 0xe7378a2a00000000,
    0x7d37537b00000000, 0x0b37e44b00000000, 0x9c322c8600000000,
    0xea329bb600000000, 0x703242e700000000, 0x0632f5d700000000,
    0x4433f04400000000, 0x3233477400000000, 0xa8339e2500000000,
    0xde33291500000000, 0x2f3197b300000000, 0x5931208300000000,
    0xc331f9d200000000, 0xb5314ee200000000, 0xf7304b7100000000,
    0x8130fc4100000000, 0x1b30251000000000, 0x6d30922000000000,
    0xad266d2600000000, 0xdb26da1600000000, 0x4126034700000000,
    0x3726b47700000000, 0x7527b1e400000000, 0x032706d400000000,
    0x9927df8500000000, 0xef2768b500000000, 0x1e25d61300000000,
    0x6825612300000000, 0xf225b87200000000, 0x84250f4200000000,
    0xc6240ad100000000, 0xb024bde100000000, 0x2a2464b000000000,
    0x5c24d38000000000, 0xcb211b4d00000000, 0xbd21ac7d00000000,
    0x2721752c00000000, 0x5121c21c00000000, 0x1320c78f00000000,
    0x652070bf00000000, 0xff20a9ee00000000, 0x89201ede00000000,
    0x7822a07800000000, 0x0e22174800000000, 0x9422ce1900000000,
    0xe222792900000000, 0xa0237cba00000000, 0xd623cb8a00000000,
    0x4c2312db00000000, 0x3a23a5eb00000000, 0x612881f000000000,
    0x172836c000000000, 0x8d28ef9100000000, 0xfb2858a100000000,
    0xb9295d3200000000, 0xcf29ea0200000000, 0x5529335300000000,
    0x2329846300000000, 0xd22b3ac500000000, 0xa42b8df500000000,
    0x3e2b54a400000000, 0x482be39400000000, 0x0a2ae60700000000,
    0x7c2a513700000000, 0xe62a886600000000, 0x902a3f5600000000,
    0x072ff79b00000000, 0x712f40ab00000000, 0xeb2f99fa00000000,
    0x9d2f2eca00000000, 0xdf2e2b5900000000, 0xa92e9c6900000000,
    0x332e453800000000, 0x452ef20800000000, 0xb42c4cae00000000,
    0xc22cfb9e00000000, 0x582c22cf00000000, 0x2e2c95ff00000000,
    0x6c2d906c00000000, 0x1a2d275c00000000, 0x802dfe0d00000000,
    0xf62d493d00000000},
   {0x0000000000000000, 0x01c151ac00000000, 0x0182a0e800000000,
    0x0043f14400000000, 0x0104426100000000, 0x00c513cd00000000,
    0x0086e28900000000, 0x0147b32500000000, 0x020884c200000000,
    0x03c9d56e00000000, 0x038a242a00000000, 0x024b758600000000,
    0x030cc6a300000000, 0x02cd970f00000000, 0x028e664b00000000,
    0x034f37e700000000, 0x07100b3500000000, 0x06d15a9900000000,
    0x0692abdd00000000, 0x0753fa7100000000, 0x0614495400000000,
    0x07d518f800000000, 0x0796e9bc00000000, 0x0657b81000000000,
    0x05188ff700000000, 0x04d9de5b00000000, 0x049a2f1f00000000,
    0x055b7eb300000000, 0x041ccd9600000000, 0x05dd9c3a00000000,
    0x059e6d7e00000000, 0x045f3cd200000000, 0x0e20166a00000000,
    0x0fe147c600000000, 0x0fa2b68200000000, 0x0e63e72e00000000,
    0x0f24540b00000000, 0x0ee505a700000000, 0x0ea6f4e300000000,
    0x0f67a54f00000000, 0x0c2892a800000000, 0x0de9c30400000000,
    0x0daa324000000000, 0x0c6b63ec00000000, 0x0d2cd0c900000000,
    0x0ced816500000000, 0x0cae702100000000, 0x0d6f218d00000000,
    0x09301d5f00000000, 0x08f14cf300000000, 0x08b2bdb700000000,
    0x0973ec1b00000000, 0x08345f3e00000000, 0x09f50e9200000000,
    0x09b6ffd600000000, 0x0877ae7a00000000, 0x0b38999d00000000,
    0x0af9c83100000000, 0x0aba397500000000, 0x0b7b68d900000000,
    0x0a3cdbfc00000000, 0x0bfd8a5000000000, 0x0bbe7b1400000000,
    0x0a7f2ab800000000, 0x1c402cd400000000, 0x1d817d7800000000,
    0x1dc28c3c00000000, 0x1c03dd9000000000, 0x1d446eb500000000,
    0x1c853f1900000000, 0x1cc6ce5d00000000, 0x1d079ff100000000,
    0x1e48a81600000000, 0x1f89f9ba00000000, 0x1fca08fe00000000,
    0x1e0b595200000000, 0x1f4cea7700000000, 0x1e8dbbdb00000000,
    0x1ece4a9f00000000, 0x1f0f1b3300000000, 0x1b5027e100000000,
    0x1a91764d00000000, 0x1ad2870900000000, 0x1b13d6a500000000,
    0x1a54658000000000, 0x1b95342c00000000, 0x1bd6c56800000000,
    0x1a1794c400000000, 0x1958a32300000000, 0x1899f28f00000000,
    0x18da03cb00000000, 0x191b526700000000, 0x185ce14200000000,
    0x199db0ee00000000, 0x19de41aa00000000, 0x181f100600000000,
    0x12603abe00000000, 0x13a16b1200000000, 0x13e29a5600000000,
    0x1223cbfa00000000, 0x136478df00000000, 0x12a5297300000000,
    0x12e6d83700000000, 0x1327899b00000000, 0x1068be7c00000000,
    0x11a9efd000000000, 0x11ea1e9400000000, 0x102b4f3800000000,
    0x116cfc1d00000000, 0x10adadb100000000, 0x10ee5cf500000000,
    0x112f0d5900000000, 0x1570318b00000000, 0x14b1602700000000,
    0x14f2916300000000, 0x1533c0cf00000000, 0x147473ea00000000,
    0x15b5224600000000, 0x15f6d30200000000, 0x143782ae00000000,
    0x1778b54900000000, 0x16b9e4e500000000, 0x16fa15a100000000,
    0x173b440d00000000, 0x167cf72800000000, 0x17bda68400000000,
    0x17fe57c000000000, 0x163f066c00000000, 0x3b805b1800000000,
    0x3a410ab400000000, 0x3a02fbf000000000, 0x3bc3aa5c00000000,
    0x3a84197900000000, 0x3b4548d500000000, 0x3b06b99100000000,
    0x3ac7e83d00000000, 0x3988dfda00000000, 0x38498e7600000000,
    0x380a7f3200000000, 0x39cb2e9e00000000, 0x388c9dbb00000000,
    0x394dcc1700000000, 0x390e3d5300000000, 0x38cf6cff00000000,
    0x3c90502d00000000, 0x3d51018100000000, 0x3d12f0c500000000,
    0x3cd3a16900000000, 0x3d94124c00000000, 0x3c5543e000000000,
    0x3c16b2a400000000, 0x3dd7e30800000000, 0x3e98d4ef00000000,
    0x3f59854300000000, 0x3f1a740700000000, 0x3edb25ab00000000,
    0x3f9c968e00000000, 0x3e5dc72200000000, 0x3e1e366600000000,
    0x3fdf67ca00000000, 0x35a04d7200000000, 0x34611cde00000000,
    0x3422ed9a00000000, 0x35e3bc3600000000, 0x34a40f1300000000,
    0x35655ebf00000000, 0x3526affb00000000, 0x34e7fe5700000000,
    0x37a8c9b000000000, 0x3669981c00000000, 0x362a695800000000,
    0x37eb38f400000000, 0x36ac8bd100000000, 0x376dda7d00000000,
    0x372e2b3900000000, 0x36ef7a9500000000, 0x32b0464700000000,
    0x337117eb00000000, 0x3332e6af00000000, 0x32f3b70300000000,
    0x33b4042600000000, 0x3275558a00000000, 0x3236a4ce00000000,
    0x33f7f56200000000, 0x30b8c28500000000, 0x3179932900000000,
    0x313a626d00000000, 0x30fb33c100000000, 0x31bc80e400000000,
    0x307dd14800000000, 0x303e200c00000000, 0x31ff71a000000000,
    0x27c077cc00000000, 0x2601266000000000, 0x2642d72400000000,
    0x2783868800000000, 0x26c435ad00000000, 0x2705640100000000,
    0x2746954500000000, 0x2687c4e900000000, 0x25c8f30e00000000,
    0x2409a2a200000000, 0x244a53e600000000, 0x258b024a00000000,
    0x24ccb16f00000000, 0x250de0c300000000, 0x254e118700000000,
    0x248f402b00000000, 0x20d07cf900000000, 0x21112d5500000000,
    0x2152dc1100000000, 0x20938dbd00000000, 0x21d43e9800000000,
    0x20156f3400000000, 0x20569e7000000000, 0x2197cfdc00000000,
    0x22d8f83b00000000, 0x2319a99700000000, 0x235a58d300000000,
    0x229b097f00000000, 0x23dcba5a00000000, 0x221debf600000000,
    0x225e1ab200000000, 0x239f4b1e00000000, 0x29e061a600000000,
    0x2821300a00000000, 0x2862c14e00000000, 0x29a390e200000000,
    0x28e423c700000000, 0x2925726b00000000, 0x2966832f00000000,
    0x28a7d28300000000, 0x2be8e56400000000, 0x2a29b4c800000000,
    0x2a6a458c00000000, 0x2bab142000000000, 0x2aeca70500000000,
    0x2b2df6a900000000, 0x2b6e07ed00000000, 0x2aaf564100000000,
    0x2ef06a9300000000, 0x2f313b3f00000000, 0x2f72ca7b00000000,
    0x2eb39bd700000000, 0x2ff428f200000000, 0x2e35795e00000000,
    0x2e76881a00000000, 0x2fb7d9b600000000, 0x2cf8ee5100000000,
    0x2d39bffd00000000, 0x2d7a4eb900000000, 0x2cbb1f1500000000,
    0x2dfcac3000000000, 0x2c3dfd9c00000000, 0x2c7e0cd800000000,
    0x2dbf5d7400000000},
   {0x0000000000000000, 0xc0503d9000000000, 0x83a1799000000000,
    0x43f1440000000000, 0x0543f09000000000, 0xc513cd0000000000,
    0x86e2890000000000, 0x46b2b49000000000, 0x0986e39100000000,
    0xc9d6de0100000000, 0x8a279a0100000000, 0x4a77a79100000000,
    0x0cc5130100000000, 0xcc952e9100000000, 0x8f646a9100000000,
    0x4f34570100000000, 0x110cc49300000000, 0xd15cf90300000000,
    0x92adbd0300000000, 0x52fd809300000000, 0x144f340300000000,
    0xd41f099300000000, 0x97ee4d9300000000, 0x57be700300000000,
    0x188a270200000000, 0xd8da1a9200000000, 0x9b2b5e9200000000,
    0x5b7b630200000000, 0x1dc9d79200000000, 0xdd99ea0200000000,
    0x9e68ae0200000000, 0x5e38939200000000, 0x21188b9700000000,
    0xe148b60700000000, 0xa2b9f20700000000, 0x62e9cf9700000000,
    0x245b7b0700000000, 0xe40b469700000000, 0xa7fa029700000000,
    0x67aa3f0700000000, 0x289e680600000000, 0xe8ce559600000000,
    0xab3f119600000000, 0x6b6f2c0600000000, 0x2ddd989600000000,
    0xed8da50600000000, 0xae7ce10600000000, 0x6e2cdc9600000000,
    0x30144f0400000000, 0xf044729400000000, 0xb3b5369400000000,
    0x73e50b0400000000, 0x3557bf9400000000, 0xf507820400000000,
    0xb6f6c60400000000, 0x76a6fb9400000000, 0x3992ac9500000000,
    0xf9c2910500000000, 0xba33d50500000000, 0x7a63e89500000000,
    0x3cd15c0500000000, 0xfc81619500000000, 0xbf70259500000000,
    0x7f20180500000000, 0x4130159f00000000, 0x8160280f00000000,
    0xc2916c0f00000000, 0x02c1519f00000000, 0x4473e50f00000000,
    0x8423d89f00000000, 0xc7d29c9f00000000, 0x0782a10f00000000,
    0x48b6f60e00000000, 0x88e6cb9e00000000, 0xcb178f9e00000000,
    0x0b47b20e00000000, 0x4df5069e00000000, 0x8da53b0e00000000,
    0xce547f0e00000000, 0x0e04429e00000000, 0x503cd10c00000000,
    0x906cec9c00000000, 0xd39da89c00000000, 0x13cd950c00000000,
    0x557f219c00000000, 0x952f1c0c00000000, 0xd6de580c00000000,
    0x168e659c00000000, 0x59ba329d00000000, 0x99ea0f0d00000000,
    0xda1b4b0d00000000, 0x1a4b769d00000000, 0x5cf9c20d00000000,
    0x9ca9ff9d00000000, 0xdf58bb9d00000000, 0x1f08860d00000000,
    0x60289e0800000000, 0xa078a39800000000, 0xe389e79800000000,
    0x23d9da0800000000, 0x656b6e9800000000, 0xa53b530800000000,
    0xe6ca170800000000, 0x269a2a9800000000, 0x69ae7d9900000000,
    0xa9fe400900000000, 0xea0f040900000000, 0x2a5f399900000000,
    0x6ced8d0900000000, 0xacbdb09900000000, 0xef4cf49900000000,
    0x2f1cc90900000000, 0x71245a9b00000000, 0xb174670b00000000,
    0xf285230b00000000, 0x32d51e9b00000000, 0x7467aa0b00000000,
    0xb437979b00000000, 0xf7c6d39b00000000, 0x3796ee0b00000000,
    0x78a2b90a00000000, 0xb8f2849a00000000, 0xfb03c09a00000000,
    0x3b53fd0a00000000, 0x7de1499a00000000, 0xbdb1740a00000000,
    0xfe40300a00000000, 0x3e100d9a00000000, 0x8160298e00000000,
    0x4130141e00000000, 0x02c1501e00000000, 0xc2916d8e00000000,
    0x8423d91e00000000, 0x4473e48e00000000, 0x0782a08e00000000,
    0xc7d29d1e00000000, 0x88e6ca1f00000000, 0x48b6f78f00000000,
    0x0b47b38f00000000, 0xcb178e1f00000000, 0x8da53a8f00000000,
    0x4df5071f00000000, 0x0e04431f00000000, 0xce547e8f00000000,
    0x906ced1d00000000, 0x503cd08d00000000, 0x13cd948d00000000,
    0xd39da91d00000000, 0x952f1d8d00000000, 0x557f201d00000000,
    0x168e641d00000000, 0xd6de598d00000000, 0x99ea0e8c00000000,
    0x59ba331c00000000, 0x1a4b771c00000000, 0xda1b4a8c00000000,
    0x9ca9fe1c00000000, 0x5cf9c38c00000000, 0x1f08878c00000000,
    0xdf58ba1c00000000, 0xa078a21900000000, 0x60289f8900000000,
    0x23d9db8900000000, 0xe389e61900000000, 0xa53b528900000000,
    0x656b6f1900000000, 0x269a2b1900000000, 0xe6ca168900000000,
    0xa9fe418800000000, 0x69ae7c1800000000, 0x2a5f381800000000,
    0xea0f058800000000, 0xacbdb11800000000, 0x6ced8c8800000000,
    0x2f1cc88800000000, 0xef4cf51800000000, 0xb174668a00000000,
    0x71245b1a00000000, 0x32d51f1a00000000, 0xf285228a00000000,
    0xb437961a00000000, 0x7467ab8a00000000, 0x3796ef8a00000000,
    0xf7c6d21a00000000, 0xb8f2851b00000000, 0x78a2b88b00000000,
    0x3b53fc8b00000000, 0xfb03c11b00000000, 0xbdb1758b00000000,
    0x7de1481b00000000, 0x3e100c1b00000000, 0xfe40318b00000000,
    0xc0503c1100000000, 0x0000018100000000, 0x43f1458100000000,
    0x83a1781100000000, 0xc513cc8100000000, 0x0543f11100000000,
    0x46b2b51100000000, 0x86e2888100000000, 0xc9d6df8000000000,
    0x0986e21000000000, 0x4a77a61000000000, 0x8a279b8000000000,
    0xcc952f1000000000, 0x0cc5128000000000, 0x4f34568000000000,
    0x8f646b1000000000, 0xd15cf88200000000, 0x110cc51200000000,
    0x52fd811200000000, 0x92adbc8200000000, 0xd41f081200000000,
    0x144f358200000000, 0x57be718200000000, 0x97ee4c1200000000,
    0xd8da1b1300000000, 0x188a268300000000, 0x5b7b628300000000,
    0x9b2b5f1300000000, 0xdd99eb8300000000, 0x1dc9d61300000000,
    0x5e38921300000000, 0x9e68af8300000000, 0xe148b78600000000,
    0x21188a1600000000, 0x62e9ce1600000000, 0xa2b9f38600000000,
    0xe40b471600000000, 0x245b7a8600000000, 0x67aa3e8600000000,
    0xa7fa031600000000, 0xe8ce541700000000, 0x289e698700000000,
    0x6b6f2d8700000000, 0xab3f101700000000, 0xed8da48700000000,
    0x2ddd991700000000, 0x6e2cdd1700000000, 0xae7ce08700000000,
    0xf044731500000000, 0x30144e8500000000, 0x73e50a8500000000,
    0xb3b5371500000000, 0xf507838500000000, 0x3557be1500000000,
    0x76a6fa1500000000, 0xb6f6c78500000000, 0xf9c2908400000000,
    0x3992ad1400000000, 0x7a63e91400000000, 0xba33d48400000000,
    0xfc81601400000000, 0x3cd15d8400000000, 0x7f20198400000000,
    0xbf70241400000000},
   {0x0000000000000000, 0x50fd906c00000000, 0xa0fa21d900000000,
    0xf007b1b500000000, 0x43f5400200000000, 0x1308d06e00000000,
    0xe30f61db00000000, 0xb3f2f1b700000000, 0x86ea810400000000,
    0xd617116800000000, 0x2610a0dd00000000, 0x76ed30b100000000,
    0xc51fc10600000000, 0x95e2516a00000000, 0x65e5e0df00000000,
    0x351870b300000000, 0x0cd5030900000000, 0x5c28936500000000,
    0xac2f22d000000000, 0xfcd2b2bc00000000, 0x4f20430b00000000,
    0x1fddd36700000000, 0xefda62d200000000, 0xbf27f2be00000000,
    0x8a3f820d00000000, 0xdac2126100000000, 0x2ac5a3d400000000,
    0x7a3833b800000000, 0xc9cac20f00000000, 0x9937526300000000,
    0x6930e3d600000000, 0x39cd73ba00000000, 0x18aa071200000000,
    0x4857977e00000000, 0xb85026cb00000000, 0xe8adb6a700000000,
    0x5b5f471000000000, 0x0ba2d77c00000000, 0xfba566c900000000,
    0xab58f6a500000000, 0x9e40861600000000, 0xcebd167a00000000,
    0x3ebaa7cf00000000, 0x6e4737a300000000, 0xddb5c61400000000,
    0x8d48567800000000, 0x7d4fe7cd00000000, 0x2db277a100000000,
    0x147f041b00000000, 0x4482947700000000, 0xb48525c200000000,
    0xe478b5ae00000000, 0x578a441900000000, 0x0777d47500000000,
    0xf77065c000000000, 0xa78df5ac00000000, 0x9295851f00000000,
    0xc268157300000000, 0x326fa4c600000000, 0x629234aa00000000,
    0xd160c51d00000000, 0x819d557100000000, 0x719ae4c400000000,
    0x216774a800000000, 0x30540f2400000000, 0x60a99f4800000000,
    0x90ae2efd00000000, 0xc053be9100000000, 0x73a14f2600000000,
    0x235cdf4a00000000, 0xd35b6eff00000000, 0x83a6fe9300000000,
    0xb6be8e2000000000, 0xe6431e4c00000000, 0x1644aff900000000,
    0x46b93f9500000000, 0xf54bce2200000000, 0xa5b65e4e00000000,
    0x55b1effb00000000, 0x054c7f9700000000, 0x3c810c2d00000000,
    0x6c7c9c4100000000, 0x9c7b2df400000000, 0xcc86bd9800000000,
    0x7f744c2f00000000, 0x2f89dc4300000000, 0xdf8e6df600000000,
    0x8f73fd9a00000000, 0xba6b8d2900000000, 0xea961d4500000000,
    0x1a91acf000000000, 0x4a6c3c9c00000000, 0xf99ecd2b00000000,
    0xa9635d4700000000, 0x5964ecf200000000, 0x09997c9e00000000,
    0x28fe083600000000, 0x7803985a00000000, 0x880429ef00000000,
    0xd8f9b98300000000, 0x6b0b483400000000, 0x3bf6d85800000000,
    0xcbf169ed00000000, 0x9b0cf98100000000, 0xae14893200000000,
    0xfee9195e00000000, 0x0eeea8eb00000000, 0x5e13388700000000,
    0xede1c93000000000, 0xbd1c595c00000000, 0x4d1be8e900000000,
    0x1de6788500000000, 0x242b0b3f00000000, 0x74d69b5300000000,
    0x84d12ae600000000, 0xd42cba8a00000000, 0x67de4b3d00000000,
    0x3723db5100000000, 0xc7246ae400000000, 0x97d9fa8800000000,
    0xa2c18a3b00000000, 0xf23c1a5700000000, 0x023babe200000000,
    0x52c63b8e00000000, 0xe134ca3900000000, 0xb1c95a5500000000,
    0x41ceebe000000000, 0x11337b8c00000000, 0x60a81e4800000000,
    0x30558e2400000000, 0xc0523f9100000000, 0x90afaffd00000000,
    0x235d5e4a00000000, 0x73a0ce2600000000, 0x83a77f9300000000,
    0xd35aefff00000000, 0xe6429f4c00000000, 0xb6bf0f2000000000,
    0x46b8be9500000000, 0x16452ef900000000, 0xa5b7df4e00000000,
    0xf54a4f2200000000, 0x054dfe9700000000, 0x55b06efb00000000,
    0x6c7d1d4100000000, 0x3c808d2d00000000, 0xcc873c9800000000,
    0x9c7aacf400000000, 0x2f885d4300000000, 0x7f75cd2f00000000,
    0x8f727c9a00000000, 0xdf8fecf600000000, 0xea979c4500000000,
    0xba6a0c2900000000, 0x4a6dbd9c00000000, 0x1a902df000000000,
    0xa962dc4700000000, 0xf99f4c2b00000000, 0x0998fd9e00000000,
    0x59656df200000000, 0x7802195a00000000, 0x28ff893600000000,
    0xd8f8388300000000, 0x8805a8ef00000000, 0x3bf7595800000000,
    0x6b0ac93400000000, 0x9b0d788100000000, 0xcbf0e8ed00000000,
    0xfee8985e00000000, 0xae15083200000000, 0x5e12b98700000000,
    0x0eef29eb00000000, 0xbd1dd85c00000000, 0xede0483000000000,
    0x1de7f98500000000, 0x4d1a69e900000000, 0x74d71a5300000000,
    0x242a8a3f00000000, 0xd42d3b8a00000000, 0x84d0abe600000000,
    0x37225a5100000000, 0x67dfca3d00000000, 0x97d87b8800000000,
    0xc725ebe400000000, 0xf23d9b5700000000, 0xa2c00b3b00000000,
    0x52c7ba8e00000000, 0x023a2ae200000000, 0xb1c8db5500000000,
    0xe1354b3900000000, 0x1132fa8c00000000, 0x41cf6ae000000000,
    0x50fc116c00000000, 0x0001810000000000, 0xf00630b500000000,
    0xa0fba0d900000000, 0x1309516e00000000, 0x43f4c10200000000,
    0xb3f370b700000000, 0xe30ee0db00000000, 0xd616906800000000,
    0x86eb000400000000, 0x76ecb1b100000000, 0x261121dd00000000,
    0x95e3d06a00000000, 0xc51e400600000000, 0x3519f1b300000000,
    0x65e461df00000000, 0x5c29126500000000, 0x0cd4820900000000,
    0xfcd333bc00000000, 0xac2ea3d000000000, 0x1fdc526700000000,
    0x4f21c20b00000000, 0xbf2673be00000000, 0xefdbe3d200000000,
    0xdac3936100000000, 0x8a3e030d00000000, 0x7a39b2b800000000,
    0x2ac422d400000000, 0x9936d36300000000, 0xc9cb430f00000000,
    0x39ccf2ba00000000, 0x693162d600000000, 0x4856167e00000000,
    0x18ab861200000000, 0xe8ac37a700000000, 0xb851a7cb00000000,
    0x0ba3567c00000000, 0x5b5ec61000000000, 0xab5977a500000000,
    0xfba4e7c900000000, 0xcebc977a00000000, 0x9e41071600000000,
    0x6e46b6a300000000, 0x3ebb26cf00000000, 0x8d49d77800000000,
    0xddb4471400000000, 0x2db3f6a100000000, 0x7d4e66cd00000000,
    0x4483157700000000, 0x147e851b00000000, 0xe47934ae00000000,
    0xb484a4c200000000, 0x0776557500000000, 0x578bc51900000000,
    0xa78c74ac00000000, 0xf771e4c000000000, 0xc269947300000000,
    0x9294041f00000000, 0x6293b5aa00000000, 0x326e25c600000000,
    0x819cd47100000000, 0xd161441d00000000, 0x2166f5a800000000,
    0x719b65c400000000},
   {0x0000000000000000, 0xfdc06c2d00000000, 0xfa81d95a00000000,
    0x0741b57700000000, 0xf403b3b500000000, 0x09c3df9800000000,
    0x0e826aef00000000, 0xf34206c200000000, 0xeb0765db00000000,
    0x16c709f600000000, 0x1186bc8100000000, 0xec46d0ac00000000,
    0x1f04d66e00000000, 0xe2c4ba4300000000, 0xe5850f3400000000,
    0x1845631900000000, 0xd50fc90600000000, 0x28cfa52b00000000,
    0x2f8e105c00000000, 0xd24e7c7100000000, 0x210c7ab300000000,
    0xdccc169e00000000, 0xdb8da3e900000000, 0x264dcfc400000000,
    0x3e08acdd00000000, 0xc3c8c0f000000000, 0xc489758700000000,
    0x394919aa00000000, 0xca0b1f6800000000, 0x37cb734500000000,
    0x308ac63200000000, 0xcd4aaa1f00000000, 0xaa1f920d00000000,
    0x57dffe2000000000, 0x509e4b5700000000, 0xad5e277a00000000,
    0x5e1c21b800000000, 0xa3dc4d9500000000, 0xa49df8e200000000,
    0x595d94cf00000000, 0x4118f7d600000000, 0xbcd89bfb00000000,
    0xbb992e8c00000000, 0x465942a100000000, 0xb51b446300000000,
    0x48db284e00000000, 0x4f9a9d3900000000, 0xb25af11400000000,
    0x7f105b0b00000000, 0x82d0372600000000, 0x8591825100000000,
    0x7851ee7c00000000, 0x8b13e8be00000000, 0x76d3849300000000,
    0x719231e400000000, 0x8c525dc900000000, 0x94173ed000000000,
    0x69d752fd00000000, 0x6e96e78a00000000, 0x93568ba700000000,
    0x60148d6500000000, 0x9dd4e14800000000, 0x9a95543f00000000,
    0x6755381200000000, 0x543f241b00000000, 0xa9ff483600000000,
    0xaebefd4100000000, 0x537e916c00000000, 0xa03c97ae00000000,
    0x5dfcfb8300000000, 0x5abd4ef400000000, 0xa77d22d900000000,
    0xbf3841c000000000, 0x42f82ded00000000, 0x45b9989a00000000,
    0xb879f4b700000000, 0x4b3bf27500000000, 0xb6fb9e5800000000,
    0xb1ba2b2f00000000, 0x4c7a470200000000, 0x8130ed1d00000000,
    0x7cf0813000000000, 0x7bb1344700000000, 0x8671586a00000000,
    0x75335ea800000000, 0x88f3328500000000, 0x8fb287f200000000,
    0x7272ebdf00000000, 0x6a3788c600000000, 0x97f7e4eb00000000,
    0x90b6519c00000000, 0x6d763db100000000, 0x9e343b7300000000,
    0x63f4575e00000000, 0x64b5e22900000000, 0x99758e0400000000,
    0xfe20b61600000000, 0x03e0da3b00000000, 0x04a16f4c00000000,
    0xf961036100000000, 0x0a2305a300000000, 0xf7e3698e00000000,
    0xf0a2dcf900000000, 0x0d62b0d400000000, 0x1527d3cd00000000,
    0xe8e7bfe000000000, 0xefa60a9700000000, 0x126666ba00000000,
    0xe124607800000000, 0x1ce40c5500000000, 0x1ba5b92200000000,
    0xe665d50f00000000, 0x2b2f7f1000000000, 0xd6ef133d00000000,
    0xd1aea64a00000000, 0x2c6eca6700000000, 0xdf2ccca500000000,
    0x22eca08800000000, 0x25ad15ff00000000, 0xd86d79d200000000,
    0xc0281acb00000000, 0x3de876e600000000, 0x3aa9c39100000000,
    0xc769afbc00000000, 0x342ba97e00000000, 0xc9ebc55300000000,
    0xceaa702400000000, 0x336a1c0900000000, 0xa87e483600000000,
    0x55be241b00000000, 0x52ff916c00000000, 0xaf3ffd4100000000,
    0x5c7dfb8300000000, 0xa1bd97ae00000000, 0xa6fc22d900000000,
    0x5b3c4ef400000000, 0x43792ded00000000, 0xbeb941c000000000,
    0xb9f8f4b700000000, 0x4438989a00000000, 0xb77a9e5800000000,
    0x4abaf27500000000, 0x4dfb470200000000, 0xb03b2b2f00000000,
    0x7d71813000000000, 0x80b1ed1d00000000, 0x87f0586a00000000,
    0x7a30344700000000, 0x8972328500000000, 0x74b25ea800000000,
    0x73f3ebdf00000000, 0x8e3387f200000000, 0x9676e4eb00000000,
    0x6bb688c600000000, 0x6cf73db100000000, 0x9137519c00000000,
    0x6275575e00000000, 0x9fb53b7300000000, 0x98f48e0400000000,
    0x6534e22900000000, 0x0261da3b00000000, 0xffa1b61600000000,
    0xf8e0036100000000, 0x05206f4c00000000, 0xf662698e00000000,
    0x0ba205a300000000, 0x0ce3b0d400000000, 0xf123dcf900000000,
    0xe966bfe000000000, 0x14a6d3cd00000000, 0x13e766ba00000000,
    0xee270a9700000000, 0x1d650c5500000000, 0xe0a5607800000000,
    0xe7e4d50f00000000, 0x1a24b92200000000, 0xd76e133d00000000,
    0x2aae7f1000000000, 0x2defca6700000000, 0xd02fa64a00000000,
    0x236da08800000000, 0xdeadcca500000000, 0xd9ec79d200000000,
    0x242c15ff00000000, 0x3c6976e600000000, 0xc1a91acb00000000,
    0xc6e8afbc00000000, 0x3b28c39100000000, 0xc86ac55300000000,
    0x35aaa97e00000000, 0x32eb1c0900000000, 0xcf2b702400000000,
    0xfc416c2d00000000, 0x0181000000000000, 0x06c0b57700000000,
    0xfb00d95a00000000, 0x0842df9800000000, 0xf582b3b500000000,
    0xf2c306c200000000, 0x0f036aef00000000, 0x174609f600000000,
    0xea8665db00000000, 0xedc7d0ac00000000, 0x1007bc8100000000,
    0xe345ba4300000000, 0x1e85d66e00000000, 0x19c4631900000000,
    0xe4040f3400000000, 0x294ea52b00000000, 0xd48ec90600000000,
    0xd3cf7c7100000000, 0x2e0f105c00000000, 0xdd4d169e00000000,
    0x208d7ab300000000, 0x27cccfc400000000, 0xda0ca3e900000000,
    0xc249c0f000000000, 0x3f89acdd00000000, 0x38c819aa00000000,
    0xc508758700000000, 0x364a734500000000, 0xcb8a1f6800000000,
    0xcccbaa1f00000000, 0x310bc63200000000, 0x565efe2000000000,
    0xab9e920d00000000, 0xacdf277a00000000, 0x511f4b5700000000,
    0xa25d4d9500000000, 0x5f9d21b800000000, 0x58dc94cf00000000,
    0xa51cf8e200000000, 0xbd599bfb00000000, 0x4099f7d600000000,
    0x47d842a100000000, 0xba182e8c00000000, 0x495a284e00000000,
    0xb49a446300000000, 0xb3dbf11400000000, 0x4e1b9d3900000000,
    0x8351372600000000, 0x7e915b0b00000000, 0x79d0ee7c00000000,
    0x8410825100000000, 0x7752849300000000, 0x8a92e8be00000000,
    0x8dd35dc900000000, 0x701331e400000000, 0x685652fd00000000,
    0x95963ed000000000, 0x92d78ba700000000, 0x6f17e78a00000000,
    0x9c55e14800000000, 0x61958d6500000000, 0x66d4381200000000,
    0x9b14543f00000000},
   {0x0000000000000000, 0xc1917ce100000000, 0x8123fa7200000000,
    0x40b2869300000000, 0x0247f4e500000000, 0xc3d6880400000000,
    0x83640e9700000000, 0x42f5727600000000, 0x078eeb7b00000000,
    0xc61f979a00000000, 0x86ad110900000000, 0x473c6de800000000,
    0x05c91f9e00000000, 0xc458637f00000000, 0x84eae5ec00000000,
    0x457b990d00000000, 0x0e1cd7f700000000, 0xcf8dab1600000000,
    0x8f3f2d8500000000, 0x4eae516400000000, 0x0c5b231200000000,
    0xcdca5ff300000000, 0x8d78d96000000000, 0x4ce9a58100000000,
    0x09923c8c00000000, 0xc803406d00000000, 0x88b1c6fe00000000,
    0x4920ba1f00000000, 0x0bd5c86900000000, 0xca44b48800000000,
    0x8af6321b00000000, 0x4b674efa00000000, 0x1f38ad5f00000000,
    0xdea9d1be00000000, 0x9e1b572d00000000, 0x5f8a2bcc00000000,
    0x1d7f59ba00000000, 0xdcee255b00000000, 0x9c5ca3c800000000,
    0x5dcddf2900000000, 0x18b6462400000000, 0xd9273ac500000000,
    0x9995bc5600000000, 0x5804c0b700000000, 0x1af1b2c100000000,
    0xdb60ce2000000000, 0x9bd248b300000000, 0x5a43345200000000,
    0x11247aa800000000, 0xd0b5064900000000, 0x900780da00000000,
    0x5196fc3b00000000, 0x13638e4d00000000, 0xd2f2f2ac00000000,
    0x9240743f00000000, 0x53d108de00000000, 0x16aa91d300000000,
    0xd73bed3200000000, 0x97896ba100000000, 0x5618174000000000,
    0x14ed653600000000, 0xd57c19d700000000, 0x95ce9f4400000000,
    0x545fe3a500000000, 0x3e705abf00000000, 0xffe1265e00000000,
    0xbf53a0cd00000000, 0x7ec2dc2c00000000, 0x3c37ae5a00000000,
    0xfda6d2bb00000000, 0xbd14542800000000, 0x7c8528c900000000,
    0x39feb1c400000000, 0xf86fcd2500000000, 0xb8dd4bb600000000,
    0x794c375700000000, 0x3bb9452100000000, 0xfa2839c000000000,
    0xba9abf5300000000, 0x7b0bc3b200000000, 0x306c8d4800000000,
    0xf1fdf1a900000000, 0xb14f773a00000000, 0x70de0bdb00000000,
    0x322b79ad00000000, 0xf3ba054c00000000, 0xb30883df00000000,
    0x7299ff3e00000000, 0x37e2663300000000, 0xf6731ad200000000,
    0xb6c19c4100000000, 0x7750e0a000000000, 0x35a592d600000000,
    0xf434ee3700000000, 0xb48668a400000000, 0x7517144500000000,
    0x2148f7e000000000, 0xe0d98b0100000000, 0xa06b0d9200000000,
    0x61fa717300000000, 0x230f030500000000, 0xe29e7fe400000000,
    0xa22cf97700000000, 0x63bd859600000000, 0x26c61c9b00000000,
    0xe757607a00000000, 0xa7e5e6e900000000, 0x66749a0800000000,
    0x2481e87e00000000, 0xe510949f00000000, 0xa5a2120c00000000,
    0x64336eed00000000, 0x2f54201700000000, 0xeec55cf600000000,
    0xae77da6500000000, 0x6fe6a68400000000, 0x2d13d4f200000000,
    0xec82a81300000000, 0xac302e8000000000, 0x6da1526100000000,
    0x28dacb6c00000000, 0xe94bb78d00000000, 0xa9f9311e00000000,
    0x68684dff00000000, 0x2a9d3f8900000000, 0xeb0c436800000000,
    0xabbec5fb00000000, 0x6a2fb91a00000000, 0x7fe0b7ce00000000,
    0xbe71cb2f00000000, 0xfec34dbc00000000, 0x3f52315d00000000,
    0x7da7432b00000000, 0xbc363fca00000000, 0xfc84b95900000000,
    0x3d15c5b800000000, 0x786e5cb500000000, 0xb9ff205400000000,
    0xf94da6c700000000, 0x38dcda2600000000, 0x7a29a85000000000,
    0xbbb8d4b100000000, 0xfb0a522200000000, 0x3a9b2ec300000000,
    0x71fc603900000000, 0xb06d1cd800000000, 0xf0df9a4b00000000,
    0x314ee6aa00000000, 0x73bb94dc00000000, 0xb22ae83d00000000,
    0xf2986eae00000000, 0x3309124f00000000, 0x76728b4200000000,
    0xb7e3f7a300000000, 0xf751713000000000, 0x36c00dd100000000,
    0x74357fa700000000, 0xb5a4034600000000, 0xf51685d500000000,
    0x3487f93400000000, 0x60d81a9100000000, 0xa149667000000000,
    0xe1fbe0e300000000, 0x206a9c0200000000, 0x629fee7400000000,
    0xa30e929500000000, 0xe3bc140600000000, 0x222d68e700000000,
    0x6756f1ea00000000, 0xa6c78d0b00000000, 0xe6750b9800000000,
    0x27e4777900000000, 0x6511050f00000000, 0xa48079ee00000000,
    0xe432ff7d00000000, 0x25a3839c00000000, 0x6ec4cd6600000000,
    0xaf55b18700000000, 0xefe7371400000000, 0x2e764bf500000000,
    0x6c83398300000000, 0xad12456200000000, 0xeda0c3f100000000,
    0x2c31bf1000000000, 0x694a261d00000000, 0xa8db5afc00000000,
    0xe869dc6f00000000, 0x29f8a08e00000000, 0x6b0dd2f800000000,
    0xaa9cae1900000000, 0xea2e288a00000000, 0x2bbf546b00000000,
    0x4190ed7100000000, 0x8001919000000000, 0xc0b3170300000000,
    0x01226be200000000, 0x43d7199400000000, 0x8246657500000000,
    0xc2f4e3e600000000, 0x03659f0700000000, 0x461e060a00000000,
    0x878f7aeb00000000, 0xc73dfc7800000000, 0x06ac809900000000,
    0x4459f2ef00000000, 0x85c88e0e00000000, 0xc57a089d00000000,
    0x04eb747c00000000, 0x4f8c3a8600000000, 0x8e1d466700000000,
    0xceafc0f400000000, 0x0f3ebc1500000000, 0x4dcbce6300000000,
    0x8c5ab28200000000, 0xcce8341100000000, 0x0d7948f000000000,
    0x4802d1fd00000000, 0x8993ad1c00000000, 0xc9212b8f00000000,
    0x08b0576e00000000, 0x4a45251800000000, 0x8bd459f900000000,
    0xcb66df6a00000000, 0x0af7a38b00000000, 0x5ea8402e00000000,
    0x9f393ccf00000000, 0xdf8bba5c00000000, 0x1e1ac6bd00000000,
    0x5cefb4cb00000000, 0x9d7ec82a00000000, 0xddcc4eb900000000,
    0x1c5d325800000000, 0x5926ab5500000000, 0x98b7d7b400000000,
    0xd805512700000000, 0x19942dc600000000, 0x5b615fb000000000,
    0x9af0235100000000, 0xda42a5c200000000, 0x1bd3d92300000000,
    0x50b497d900000000, 0x9125eb3800000000, 0xd1976dab00000000,
    0x1006114a00000000, 0x52f3633c00000000, 0x93621fdd00000000,
    0xd3d0994e00000000, 0x1241e5af00000000, 0x573a7ca200000000,
    0x96ab004300000000, 0xd61986d000000000, 0x1788fa3100000000,
    0x557d884700000000, 0x94ecf4a600000000, 0xd45e723500000000,
    0x15cf0ed400000000}};

#else /* W == 4 */

static const crc_t crc_braid_table[][256] = {
   {0x00000000, 0x47596181, 0x8eb2c302, 0xc9eba283, 0xad668607,
    0xea3fe786, 0x23d44505, 0x648d2484, 0xeace0c0d, 0xad976d8c,
    0x647ccf0f, 0x2325ae8e, 0x47a88a0a, 0x00f1eb8b, 0xc91a4908,
    0x8e432889, 0x659f1819, 0x22c67998, 0xeb2ddb1b, 0xac74ba9a,
    0xc8f99e1e, 0x8fa0ff9f, 0x464b5d1c, 0x01123c9d, 0x8f511414,
    0xc8087595, 0x01e3d716, 0x46bab697, 0x22379213, 0x656ef392,
    0xac855111, 0xebdc3090, 0xcb3e3032, 0x8c6751b3, 0x458cf330,
    0x02d592b1, 0x6658b635, 0x2101d7b4, 0xe8ea7537, 0xafb314b6,
    0x21f03c3f, 0x66a95dbe, 0xaf42ff3d, 0xe81b9ebc, 0x8c96ba38,
    0xcbcfdbb9, 0x0224793a, 0x457d18bb, 0xaea1282b, 0xe9f849aa,
    0x2013eb29, 0x674a8aa8, 0x03c7ae2c, 0x449ecfad, 0x8d756d2e,
    0xca2c0caf, 0x446f2426, 0x033645a7, 0xcadde724, 0x8d8486a5,
    0xe909a221, 0xae50c3a0, 0x67bb6123, 0x20e200a2, 0x267f6067,
    0x612601e6, 0xa8cda365, 0xef94c2e4, 0x8b19e660, 0xcc4087e1,
    0x05ab2562, 0x42f244e3, 0xccb16c6a, 0x8be80deb, 0x4203af68,
    0x055acee9, 0x61d7ea6d, 0x268e8bec, 0xef65296f, 0xa83c48ee,
    0x43e0787e, 0x04b919ff, 0xcd52bb7c, 0x8a0bdafd, 0xee86fe79,
    0xa9df9ff8, 0x60343d7b, 0x276d5cfa, 0xa92e7473, 0xee7715f2,
    0x279cb771, 0x60c5d6f0, 0x0448f274, 0x431193f5, 0x8afa3176,
    0xcda350f7, 0xed415055, 0xaa1831d4, 0x63f39357, 0x24aaf2d6,
    0x4027d652, 0x077eb7d3, 0xce951550, 0x89cc74d1, 0x078f5c58,
    0x40d63dd9, 0x893d9f5a, 0xce64fedb, 0xaae9da5f, 0xedb0bbde,
    0x245b195d, 0x630278dc, 0x88de484c, 0xcf8729cd, 0x066c8b4e,
    0x4135eacf, 0x25b8ce4b, 0x62e1afca, 0xab0a0d49, 0xec536cc8,
    0x62104441, 0x254925c0, 0xeca28743, 0xabfbe6c2, 0xcf76c246,
    0x882fa3c7, 0x41c40144, 0x069d60c5, 0x4cfec0ce, 0x0ba7a14f,
    0xc24c03cc, 0x8515624d, 0xe19846c9, 0xa6c12748, 0x6f2a85cb,
    0x2873e44a, 0xa630ccc3, 0xe169ad42, 0x28820fc1, 0x6fdb6e40,
    0x0b564ac4, 0x4c0f2b45, 0x85e489c6, 0xc2bde847, 0x2961d8d7,
    0x6e38b956, 0xa7d31bd5, 0xe08a7a54, 0x84075ed0, 0xc35e3f51,
    0x0ab59dd2, 0x4decfc53, 0xc3afd4da, 0x84f6b55b, 0x4d1d17d8,
    0x0a447659, 0x6ec952dd, 0x2990335c, 0xe07b91df, 0xa722f05e,
    0x87c0f0fc, 0xc099917d, 0x097233fe, 0x4e2b527f, 0x2aa676fb,
    0x6dff177a, 0xa414b5f9, 0xe34dd478, 0x6d0efcf1, 0x2a579d70,
    0xe3bc3ff3, 0xa4e55e72, 0xc0687af6, 0x87311b77, 0x4edab9f4,
    0x0983d875, 0xe25fe8e5, 0xa5068964, 0x6ced2be7, 0x2bb44a66,
    0x4f396ee2, 0x08600f63, 0xc18bade0, 0x86d2cc61, 0x0891e4e8,
    0x4fc88569, 0x862327ea, 0xc17a466b, 0xa5f762ef, 0xe2ae036e,
    0x2b45a1ed, 0x6c1cc06c, 0x6a81a0a9, 0x2dd8c128, 0xe43363ab,
    0xa36a022a, 0xc7e726ae, 0x80be472f, 0x4955e5ac, 0x0e0c842d,
    0x804faca4, 0xc716cd25, 0x0efd6fa6, 0x49a40e27, 0x2d292aa3,
    0x6a704b22, 0xa39be9a1, 0xe4c28820, 0x0f1eb8b0, 0x4847d931,
    0x81ac7bb2, 0xc6f51a33, 0xa2783eb7, 0xe5215f36, 0x2ccafdb5,
    0x6b939c34, 0xe5d0b4bd, 0xa289d53c, 0x6b6277bf, 0x2c3b163e,
    0x48b632ba, 0x0fef533b, 0xc604f1b8, 0x815d9039, 0xa1bf909b,
    0xe6e6f11a, 0x2f0d5399, 0x68543218, 0x0cd9169c, 0x4b80771d,
    0x826bd59e, 0xc532b41f, 0x4b719c96, 0x0c28fd17, 0xc5c35f94,
    0x829a3e15, 0xe6171a91, 0xa14e7b10, 0x68a5d993, 0x2ffcb812,
    0xc4208882, 0x8379e903, 0x4a924b80, 0x0dcb2a01, 0x69460e85,
    0x2e1f6f04, 0xe7f4cd87, 0xa0adac06, 0x2eee848f, 0x69b7e50e,
    0xa05c478d, 0xe705260c, 0x83880288, 0xc4d16309, 0x0d3ac18a,
    0x4a63a00b},
   {0x00000000, 0x99fd819c, 0x83f8033b, 0x1a0582a7, 0xb7f30675,
    0x2e0e87e9, 0x340b054e, 0xadf684d2, 0xdfe50ce9, 0x46188d75,
    0x5c1d0fd2, 0xc5e08e4e, 0x68160a9c, 0xf1eb8b00, 0xebee09a7,
    0x7213883b, 0x0fc919d1, 0x9634984d, 0x8c311aea, 0x15cc9b76,
    0xb83a1fa4, 0x21c79e38, 0x3bc21c9f, 0xa23f9d03, 0xd02c1538,
    0x49d194a4, 0x53d41603, 0xca29979f, 0x67df134d, 0xfe2292d1,
    0xe4271076, 0x7dda91ea, 0x1f9233a2, 0x866fb23e, 0x9c6a3099,
    0x0597b105, 0xa86135d7, 0x319cb44b, 0x2b9936ec, 0xb264b770,
    0xc0773f4b, 0x598abed7, 0x438f3c70, 0xda72bdec, 0x7784393e,
    0xee79b8a2, 0xf47c3a05, 0x6d81bb99, 0x105b2a73, 0x89a6abef,
    0x93a32948, 0x0a5ea8d4, 0xa7a82c06, 0x3e55ad9a, 0x24502f3d,
    0xbdadaea1, 0xcfbe269a, 0x5643a706, 0x4c4625a1, 0xd5bba43d,
    0x784d20ef, 0xe1b0a173, 0xfbb523d4, 0x6248a248, 0x3f246744,
    0xa6d9e6d8, 0xbcdc647f, 0x2521e5e3, 0x88d76131, 0x112ae0ad,
    0x0b2f620a, 0x92d2e396, 0xe0c16bad, 0x793cea31, 0x63396896,
    0xfac4e90a, 0x57326dd8, 0xcecfec44, 0xd4ca6ee3, 0x4d37ef7f,
    0x30ed7e95, 0xa910ff09, 0xb3157dae, 0x2ae8fc32, 0x871e78e0,
    0x1ee3f97c, 0x04e67bdb, 0x9d1bfa47, 0xef08727c, 0x76f5f3e0,
    0x6cf07147, 0xf50df0db, 0x58fb7409, 0xc106f595, 0xdb037732,
    0x42fef6ae, 0x20b654e6, 0xb94bd57a, 0xa34e57dd, 0x3ab3d641,
    0x97455293, 0x0eb8d30f, 0x14bd51a8, 0x8d40d034, 0xff53580f,
    0x66aed993, 0x7cab5b34, 0xe556daa8, 0x48a05e7a, 0xd15ddfe6,
    0xcb585d41, 0x52a5dcdd, 0x2f7f4d37, 0xb682ccab, 0xac874e0c,
    0x357acf90, 0x988c4b42, 0x0171cade, 0x1b744879, 0x8289c9e5,
    0xf09a41de, 0x6967c042, 0x736242e5, 0xea9fc379, 0x476947ab,
    0xde94c637, 0xc4914490, 0x5d6cc50c, 0x7e48ce88, 0xe7b54f14,
    0xfdb0cdb3, 0x644d4c2f, 0xc9bbc8fd, 0x50464961, 0x4a43cbc6,
    0xd3be4a5a, 0xa1adc261, 0x385043fd, 0x2255c15a, 0xbba840c6,
    0x165ec414, 0x8fa34588, 0x95a6c72f, 0x0c5b46b3, 0x7181d759,
    0xe87c56c5, 0xf279d462, 0x6b8455fe, 0xc672d12c, 0x5f8f50b0,
    0x458ad217, 0xdc77538b, 0xae64dbb0, 0x37995a2c, 0x2d9cd88b,
    0xb4615917, 0x1997ddc5, 0x806a5c59, 0x9a6fdefe, 0x03925f62,
    0x61dafd2a, 0xf8277cb6, 0xe222fe11, 0x7bdf7f8d, 0xd629fb5f,
    0x4fd47ac3, 0x55d1f864, 0xcc2c79f8, 0xbe3ff1c3, 0x27c2705f,
    0x3dc7f2f8, 0xa43a7364, 0x09ccf7b6, 0x9031762a, 0x8a34f48d,
    0x13c97511, 0x6e13e4fb, 0xf7ee6567, 0xedebe7c0, 0x7416665c,
    0xd9e0e28e, 0x401d6312, 0x5a18e1b5, 0xc3e56029, 0xb1f6e812,
    0x280b698e, 0x320eeb29, 0xabf36ab5, 0x0605ee67, 0x9ff86ffb,
    0x85fded5c, 0x1c006cc0, 0x416ca9cc, 0xd8912850, 0xc294aaf7,
    0x5b692b6b, 0xf69fafb9, 0x6f622e25, 0x7567ac82, 0xec9a2d1e,
    0x9e89a525, 0x077424b9, 0x1d71a61e, 0x848c2782, 0x297aa350,
    0xb08722cc, 0xaa82a06b, 0x337f21f7, 0x4ea5b01d, 0xd7583181,
    0xcd5db326, 0x54a032ba, 0xf956b668, 0x60ab37f4, 0x7aaeb553,
    0xe35334cf, 0x9140bcf4, 0x08bd3d68, 0x12b8bfcf, 0x8b453e53,
    0x26b3ba81, 0xbf4e3b1d, 0xa54bb9ba, 0x3cb63826, 0x5efe9a6e,
    0xc7031bf2, 0xdd069955, 0x44fb18c9, 0xe90d9c1b, 0x70f01d87,
    0x6af59f20, 0xf3081ebc, 0x811b9687, 0x18e6171b, 0x02e395bc,
    0x9b1e1420, 0x36e890f2, 0xaf15116e, 0xb51093c9, 0x2ced1255,
    0x513783bf, 0xc8ca0223, 0xd2cf8084, 0x4b320118, 0xe6c485ca,
    0x7f390456, 0x653c86f1, 0xfcc1076d, 0x8ed28f56, 0x172f0eca,
    0x0d2a8c6d, 0x94d70df1, 0x39218923, 0xa0dc08bf, 0xbad98a18,
    0x23240b84},
   {0x00000000, 0xfc919d10, 0x49203a23, 0xb5b1a733, 0x92407446,
    0x6ed1e956, 0xdb604e65, 0x27f1d375, 0x9483e88f, 0x6812759f,
    0xdda3d2ac, 0x21324fbc, 0x06c39cc9, 0xfa5201d9, 0x4fe3a6ea,
    0xb3723bfa, 0x9904d11d, 0x65954c0d, 0xd024eb3e, 0x2cb5762e,
    0x0b44a55b, 0xf7d5384b, 0x42649f78, 0xbef50268, 0x0d873992,
    0xf116a482, 0x44a703b1, 0xb8369ea1, 0x9fc74dd4, 0x6356d0c4,
    0xd6e777f7, 0x2a76eae7, 0x820aa239, 0x7e9b3f29, 0xcb2a981a,
    0x37bb050a, 0x104ad67f, 0xecdb4b6f, 0x596aec5c, 0xa5fb714c,
    0x16894ab6, 0xea18d7a6, 0x5fa97095, 0xa338ed85, 0x84c93ef0,
    0x7858a3e0, 0xcde904d3, 0x317899c3, 0x1b0e7324, 0xe79fee34,
    0x522e4907, 0xaebfd417, 0x894e0762, 0x75df9a72, 0xc06e3d41,
    0x3cffa051, 0x8f8d9bab, 0x731c06bb, 0xc6ada188, 0x3a3c3c98,
    0x1dcdefed, 0xe15c72fd, 0x54edd5ce, 0xa87c48de, 0xb4164471,
    0x4887d961, 0xfd367e52, 0x01a7e342, 0x26563037, 0xdac7ad27,
    0x6f760a14, 0x93e79704, 0x2095acfe, 0xdc0431ee, 0x69b596dd,
    0x95240bcd, 0xb2d5d8b8, 0x4e4445a8, 0xfbf5e29b, 0x07647f8b,
    0x2d12956c, 0xd183087c, 0x6432af4f, 0x98a3325f, 0xbf52e12a,
    0x43c37c3a, 0xf672db09, 0x0ae34619, 0xb9917de3, 0x4500e0f3,
    0xf0b147c0, 0x0c20dad0, 0x2bd109a5, 0xd74094b5, 0x62f13386,
    0x9e60ae96, 0x361ce648, 0xca8d7b58, 0x7f3cdc6b, 0x83ad417b,
    0xa45c920e, 0x58cd0f1e, 0xed7ca82d, 0x11ed353d, 0xa29f0ec7,
    0x5e0e93d7, 0xebbf34e4, 0x172ea9f4, 0x30df7a81, 0xcc4ee791,
    0x79ff40a2, 0x856eddb2, 0xaf183755, 0x5389aa45, 0xe6380d76,
    0x1aa99066, 0x3d584313, 0xc1c9de03, 0x74787930, 0x88e9e420,
    0x3b9bdfda, 0xc70a42ca, 0x72bbe5f9, 0x8e2a78e9, 0xa9dbab9c,
    0x554a368c, 0xe0fb91bf, 0x1c6a0caf, 0xd82f88e1, 0x24be15f1,
    0x910fb2c2, 0x6d9e2fd2, 0x4a6ffca7, 0xb6fe61b7, 0x034fc684,
    0xffde5b94, 0x4cac606e, 0xb03dfd7e, 0x058c5a4d, 0xf91dc75d,
    0xdeec1428, 0x227d8938, 0x97cc2e0b, 0x6b5db31b, 0x412b59fc,
    0xbdbac4ec, 0x080b63df, 0xf49afecf, 0xd36b2dba, 0x2ffab0aa,
    0x9a4b1799, 0x66da8a89, 0xd5a8b173, 0x29392c63, 0x9c888b50,
    0x60191640, 0x47e8c535, 0xbb795825, 0x0ec8ff16, 0xf2596206,
    0x5a252ad8, 0xa6b4b7c8, 0x130510fb, 0xef948deb, 0xc8655e9e,
    0x34f4c38e, 0x814564bd, 0x7dd4f9ad, 0xcea6c257, 0x32375f47,
    0x8786f874, 0x7b176564, 0x5ce6b611, 0xa0772b01, 0x15c68c32,
    0xe9571122, 0xc321fbc5, 0x3fb066d5, 0x8a01c1e6, 0x76905cf6,
    0x51618f83, 0xadf01293, 0x1841b5a0, 0xe4d028b0, 0x57a2134a,
    0xab338e5a, 0x1e822969, 0xe213b479, 0xc5e2670c, 0x3973fa1c,
    0x8cc25d2f, 0x7053c03f, 0x6c39cc90, 0x90a85180, 0x2519f6b3,
    0xd9886ba3, 0xfe79b8d6, 0x02e825c6, 0xb75982f5, 0x4bc81fe5,
    0xf8ba241f, 0x042bb90f, 0xb19a1e3c, 0x4d0b832c, 0x6afa5059,
    0x966bcd49, 0x23da6a7a, 0xdf4bf76a, 0xf53d1d8d, 0x09ac809d,
    0xbc1d27ae, 0x408cbabe, 0x677d69cb, 0x9becf4db, 0x2e5d53e8,
    0xd2cccef8, 0x61bef502, 0x9d2f6812, 0x289ecf21, 0xd40f5231,
    0xf3fe8144, 0x0f6f1c54, 0xbadebb67, 0x464f2677, 0xee336ea9,
    0x12a2f3b9, 0xa713548a, 0x5b82c99a, 0x7c731aef, 0x80e287ff,
    0x355320cc, 0xc9c2bddc, 0x7ab08626, 0x86211b36, 0x3390bc05,
    0xcf012115, 0xe8f0f260, 0x14616f70, 0xa1d0c843, 0x5d415553,
    0x7737bfb4, 0x8ba622a4, 0x3e178597, 0xc2861887, 0xe577cbf2,
    0x19e656e2, 0xac57f1d1, 0x50c66cc1, 0xe3b4573b, 0x1f25ca2b,
    0xaa946d18, 0x5605f008, 0x71f4237d, 0x8d65be6d, 0x38d4195e,
    0xc445844e},
   {0x00000000, 0x005c11c1, 0x00b82382, 0x00e43243, 0x01704704,
    0x012c56c5, 0x01c86486, 0x01947547, 0x02e08e08, 0x02bc9fc9,
    0x0258ad8a, 0x0204bc4b, 0x0390c90c, 0x03ccd8cd, 0x0328ea8e,
    0x0374fb4f, 0x05c11c10, 0x059d0dd1, 0x05793f92, 0x05252e53,
    0x04b15b14, 0x04ed4ad5, 0x04097896, 0x04556957, 0x07219218,
    0x077d83d9, 0x0799b19a, 0x07c5a05b, 0x0651d51c, 0x060dc4dd,
    0x06e9f69e, 0x06b5e75f, 0x0b823820, 0x0bde29e1, 0x0b3a1ba2,
    0x0b660a63, 0x0af27f24, 0x0aae6ee5, 0x0a4a5ca6, 0x0a164d67,
    0x0962b628, 0x093ea7e9, 0x09da95aa, 0x0986846b, 0x0812f12c,
    0x084ee0ed, 0x08aad2ae, 0x08f6c36f, 0x0e432430, 0x0e1f35f1,
    0x0efb07b2, 0x0ea71673, 0x0f336334, 0x0f6f72f5, 0x0f8b40b6,
    0x0fd75177, 0x0ca3aa38, 0x0cffbbf9, 0x0c1b89ba, 0x0c47987b,
    0x0dd3ed3c, 0x0d8ffcfd, 0x0d6bcebe, 0x0d37df7f, 0x17047040,
    0x17586181, 0x17bc53c2, 0x17e04203, 0x16743744, 0x16282685,
    0x16cc14c6, 0x16900507, 0x15e4fe48, 0x15b8ef89, 0x155cddca,
    0x1500cc0b, 0x1494b94c, 0x14c8a88d, 0x142c9ace, 0x14708b0f,
    0x12c56c50, 0x12997d91, 0x127d4fd2, 0x12215e13, 0x13b52b54,
    0x13e93a95, 0x130d08d6, 0x13511917, 0x1025e258, 0x1079f399,
    0x109dc1da, 0x10c1d01b, 0x1155a55c, 0x1109b49d, 0x11ed86de,
    0x11b1971f, 0x1c864860, 0x1cda59a1, 0x1c3e6be2, 0x1c627a23,
    0x1df60f64, 0x1daa1ea5, 0x1d4e2ce6, 0x1d123d27, 0x1e66c668,
    0x1e3ad7a9, 0x1edee5ea, 0x1e82f42b, 0x1f16816c, 0x1f4a90ad,
    0x1faea2ee, 0x1ff2b32f, 0x19475470, 0x191b45b1, 0x19ff77f2,
    0x19a36633, 0x18371374, 0x186b02b5, 0x188f30f6, 0x18d32137,
    0x1ba7da78, 0x1bfbcbb9, 0x1b1ff9fa, 0x1b43e83b, 0x1ad79d7c,
    0x1a8b8cbd, 0x1a6fbefe, 0x1a33af3f, 0x2e08e080, 0x2e54f141,
    0x2eb0c302, 0x2eecd2c3, 0x2f78a784, 0x2f24b645, 0x2fc08406,
    0x2f9c95c7, 0x2ce86e88, 0x2cb47f49, 0x2c504d0a, 0x2c0c5ccb,
    0x2d98298c, 0x2dc4384d, 0x2d200a0e, 0x2d7c1bcf, 0x2bc9fc90,
    0x2b95ed51, 0x2b71df12, 0x2b2dced3, 0x2ab9bb94, 0x2ae5aa55,
    0x2a019816, 0x2a5d89d7, 0x29297298, 0x29756359, 0x2991511a,
    0x29cd40db, 0x2859359c, 0x2805245d, 0x28e1161e, 0x28bd07df,
    0x258ad8a0, 0x25d6c961, 0x2532fb22, 0x256eeae3, 0x24fa9fa4,
    0x24a68e65, 0x2442bc26, 0x241eade7, 0x276a56a8, 0x27364769,
    0x27d2752a, 0x278e64eb, 0x261a11ac, 0x2646006d, 0x26a2322e,
    0x26fe23ef, 0x204bc4b0, 0x2017d571, 0x20f3e732, 0x20aff6f3,
    0x213b83b4, 0x21679275, 0x2183a036, 0x21dfb1f7, 0x22ab4ab8,
    0x22f75b79, 0x2213693a, 0x224f78fb, 0x23db0dbc, 0x23871c7d,
    0x23632e3e, 0x233f3fff, 0x390c90c0, 0x39508101, 0x39b4b342,
    0x39e8a283, 0x387cd7c4, 0x3820c605, 0x38c4f446, 0x3898e587,
    0x3bec1ec8, 0x3bb00f09, 0x3b543d4a, 0x3b082c8b, 0x3a9c59cc,
    0x3ac0480d, 0x3a247a4e, 0x3a786b8f, 0x3ccd8cd0, 0x3c919d11,
    0x3c75af52, 0x3c29be93, 0x3dbdcbd4, 0x3de1da15, 0x3d05e856,
    0x3d59f997, 0x3e2d02d8, 0x3e711319, 0x3e95215a, 0x3ec9309b,
    0x3f5d45dc, 0x3f01541d, 0x3fe5665e, 0x3fb9779f, 0x328ea8e0,
    0x32d2b921, 0x32368b62, 0x326a9aa3, 0x33feefe4, 0x33a2fe25,
    0x3346cc66, 0x331adda7, 0x306e26e8, 0x30323729, 0x30d6056a,
    0x308a14ab, 0x311e61ec, 0x3142702d, 0x31a6426e, 0x31fa53af,
    0x374fb4f0, 0x3713a531, 0x37f79772, 0x37ab86b3, 0x363ff3f4,
    0x3663e235, 0x3687d076, 0x36dbc1b7, 0x35af3af8, 0x35f32b39,
    0x3517197a, 0x354b08bb, 0x34df7dfc, 0x34836c3d, 0x34675e7e,
    0x343b4fbf}};

static const word_t crc_braid_big_table[][256] = {
   {0x00000000, 0xc1115c00, 0x8223b800, 0x4332e400, 0x04477001,
    0xc5562c01, 0x8664c801, 0x47759401, 0x088ee002, 0xc99fbc02,
    0x8aad5802, 0x4bbc0402, 0x0cc99003, 0xcdd8cc03, 0x8eea2803,
    0x4ffb7403, 0x101cc105, 0xd10d9d05, 0x923f7905, 0x532e2505,
    0x145bb104, 0xd54aed04, 0x96780904, 0x57695504, 0x18922107,
    0xd9837d07, 0x9ab19907, 0x5ba0c507, 0x1cd55106, 0xddc40d06,
    0x9ef6e906, 0x5fe7b506, 0x2038820b, 0xe129de0b, 0xa21b3a0b,
    0x630a660b, 0x247ff20a, 0xe56eae0a, 0xa65c4a0a, 0x674d160a,
    0x28b66209, 0xe9a73e09, 0xaa95da09, 0x6b848609, 0x2cf11208,
    0xede04e08, 0xaed2aa08, 0x6fc3f608, 0x3024430e, 0xf1351f0e,
    0xb207fb0e, 0x7316a70e, 0x3463330f, 0xf5726f0f, 0xb6408b0f,
    0x7751d70f, 0x38aaa30c, 0xf9bbff0c, 0xba891b0c, 0x7b98470c,
    0x3cedd30d, 0xfdfc8f0d, 0xbece6b0d, 0x7fdf370d, 0x40700417,
    0x81615817, 0xc253bc17, 0x0342e017, 0x44377416, 0x85262816,
    0xc614cc16, 0x07059016, 0x48fee415, 0x89efb815, 0xcadd5c15,
    0x0bcc0015, 0x4cb99414, 0x8da8c814, 0xce9a2c14, 0x0f8b7014,
    0x506cc512, 0x917d9912, 0xd24f7d12, 0x135e2112, 0x542bb513,
    0x953ae913, 0xd6080d13, 0x17195113, 0x58e22510, 0x99f37910,
    0xdac19d10, 0x1bd0c110, 0x5ca55511, 0x9db40911, 0xde86ed11,
    0x1f97b111, 0x6048861c, 0xa159da1c, 0xe26b3e1c, 0x237a621c,
    0x640ff61d, 0xa51eaa1d, 0xe62c4e1d, 0x273d121d, 0x68c6661e,
    0xa9d73a1e, 0xeae5de1e, 0x2bf4821e, 0x6c81161f, 0xad904a1f,
    0xeea2ae1f, 0x2fb3f21f, 0x70544719, 0xb1451b19, 0xf277ff19,
    0x3366a319, 0x74133718, 0xb5026b18, 0xf6308f18, 0x3721d318,
    0x78daa71b, 0xb9cbfb1b, 0xfaf91f1b, 0x3be8431b, 0x7c9dd71a,
    0xbd8c8b1a, 0xfebe6f1a, 0x3faf331a, 0x80e0082e, 0x41f1542e,
    0x02c3b02e, 0xc3d2ec2e, 0x84a7782f, 0x45b6242f, 0x0684c02f,
    0xc7959c2f, 0x886ee82c, 0x497fb42c, 0x0a4d502c, 0xcb5c0c2c,
    0x8c29982d, 0x4d38c42d, 0x0e0a202d, 0xcf1b7c2d, 0x90fcc92b,
    0x51ed952b, 0x12df712b, 0xd3ce2d2b, 0x94bbb92a, 0x55aae52a,
    0x1698012a, 0xd7895d2a, 0x98722929, 0x59637529, 0x1a519129,
    0xdb40cd29, 0x9c355928, 0x5d240528, 0x1e16e128, 0xdf07bd28,
    0xa0d88a25, 0x61c9d625, 0x22fb3225, 0xe3ea6e25, 0xa49ffa24,
    0x658ea624, 0x26bc4224, 0xe7ad1e24, 0xa8566a27, 0x69473627,
    0x2a75d227, 0xeb648e27, 0xac111a26, 0x6d004626, 0x2e32a226,
    0xef23fe26, 0xb0c44b20, 0x71d51720, 0x32e7f320, 0xf3f6af20,
    0xb4833b21, 0x75926721, 0x36a08321, 0xf7b1df21, 0xb84aab22,
    0x795bf722, 0x3a691322, 0xfb784f22, 0xbc0ddb23, 0x7d1c8723,
    0x3e2e6323, 0xff3f3f23, 0xc0900c39, 0x01815039, 0x42b3b439,
    0x83a2e839, 0xc4d77c38, 0x05c62038, 0x46f4c438, 0x87e59838,
    0xc81eec3b, 0x090fb03b, 0x4a3d543b, 0x8b2c083b, 0xcc599c3a,
    0x0d48c03a, 0x4e7a243a, 0x8f6b783a, 0xd08ccd3c, 0x119d913c,
    0x52af753c, 0x93be293c, 0xd4cbbd3d, 0x15dae13d, 0x56e8053d,
    0x97f9593d, 0xd8022d3e, 0x1913713e, 0x5a21953e, 0x9b30c93e,
    0xdc455d3f, 0x1d54013f, 0x5e66e53f, 0x9f77b93f, 0xe0a88e32,
    0x21b9d232, 0x628b3632, 0xa39a6a32, 0xe4effe33, 0x25fea233,
    0x66cc4633, 0xa7dd1a33, 0xe8266e30, 0x29373230, 0x6a05d630,
    0xab148a30, 0xec611e31, 0x2d704231, 0x6e42a631, 0xaf53fa31,
    0xf0b44f37, 0x31a51337, 0x7297f737, 0xb386ab37, 0xf4f33f36,
    0x35e26336, 0x76d08736, 0xb7c1db36, 0xf83aaf35, 0x392bf335,
    0x7a191735, 0xbb084b35, 0xfc7ddf34, 0x3d6c8334, 0x7e5e6734,
    0xbf4f3b34},
   {0x00000000, 0x109d91fc, 0x233a2049, 0x33a7b1b5, 0x46744092,
    0x56e9d16e, 0x654e60db, 0x75d3f127, 0x8fe88394, 0x9f751268,
    0xacd2a3dd, 0xbc4f3221, 0xc99cc306, 0xd90152fa, 0xeaa6e34f,
    0xfa3b72b3, 0x1dd10499, 0x0d4c9565, 0x3eeb24d0, 0x2e76b52c,
    0x5ba5440b, 0x4b38d5f7, 0x789f6442, 0x6802f5be, 0x9239870d,
    0x82a416f1, 0xb103a744, 0xa19e36b8, 0xd44dc79f, 0xc4d05663,
    0xf777e7d6, 0xe7ea762a, 0x39a20a82, 0x293f9b7e, 0x1a982acb,
    0x0a05bb37, 0x7fd64a10, 0x6f4bdbec, 0x5cec6a59, 0x4c71fba5,
    0xb64a8916, 0xa6d718ea, 0x9570a95f, 0x85ed38a3, 0xf03ec984,
    0xe0a35878, 0xd304e9cd, 0xc3997831, 0x24730e1b, 0x34ee9fe7,
    0x07492e52, 0x17d4bfae, 0x62074e89, 0x729adf75, 0x413d6ec0,
    0x51a0ff3c, 0xab9b8d8f, 0xbb061c73, 0x88a1adc6, 0x983c3c3a,
    0xedefcd1d, 0xfd725ce1, 0xced5ed54, 0xde487ca8, 0x714416b4,
    0x61d98748, 0x527e36fd, 0x42e3a701, 0x37305626, 0x27adc7da,
    0x140a766f, 0x0497e793, 0xfeac9520, 0xee3104dc, 0xdd96b569,
    0xcd0b2495, 0xb8d8d5b2, 0xa845444e, 0x9be2f5fb, 0x8b7f6407,
    0x6c95122d, 0x7c0883d1, 0x4faf3264, 0x5f32a398, 0x2ae152bf,
    0x3a7cc343, 0x09db72f6, 0x1946e30a, 0xe37d91b9, 0xf3e00045,
    0xc047b1f0, 0xd0da200c, 0xa509d12b, 0xb59440d7, 0x8633f162,
    0x96ae609e, 0x48e61c36, 0x587b8dca, 0x6bdc3c7f, 0x7b41ad83,
    0x0e925ca4, 0x1e0fcd58, 0x2da87ced, 0x3d35ed11, 0xc70e9fa2,
    0xd7930e5e, 0xe434bfeb, 0xf4a92e17, 0x817adf30, 0x91e74ecc,
    0xa240ff79, 0xb2dd6e85, 0x553718af, 0x45aa8953, 0x760d38e6,
    0x6690a91a, 0x1343583d, 0x03dec9c1, 0x30797874, 0x20e4e988,
    0xdadf9b3b, 0xca420ac7, 0xf9e5bb72, 0xe9782a8e, 0x9cabdba9,
    0x8c364a55, 0xbf91fbe0, 0xaf0c6a1c, 0xe1882fd8, 0xf115be24,
    0xc2b20f91, 0xd22f9e6d, 0xa7fc6f4a, 0xb761feb6, 0x84c64f03,
    0x945bdeff, 0x6e60ac4c, 0x7efd3db0, 0x4d5a8c05, 0x5dc71df9,
    0x2814ecde, 0x38897d22, 0x0b2ecc97, 0x1bb35d6b, 0xfc592b41,
    0xecc4babd, 0xdf630b08, 0xcffe9af4, 0xba2d6bd3, 0xaab0fa2f,
    0x99174b9a, 0x898ada66, 0x73b1a8d5, 0x632c3929, 0x508b889c,
    0x40161960, 0x35c5e847, 0x255879bb, 0x16ffc80e, 0x066259f2,
    0xd82a255a, 0xc8b7b4a6, 0xfb100513, 0xeb8d94ef, 0x9e5e65c8,
    0x8ec3f434, 0xbd644581, 0xadf9d47d, 0x57c2a6ce, 0x475f3732,
    0x74f88687, 0x6465177b, 0x11b6e65c, 0x012b77a0, 0x328cc615,
    0x221157e9, 0xc5fb21c3, 0xd566b03f, 0xe6c1018a, 0xf65c9076,
    0x838f6151, 0x9312f0ad, 0xa0b54118, 0xb028d0e4, 0x4a13a257,
    0x5a8e33ab, 0x6929821e, 0x79b413e2, 0x0c67e2c5, 0x1cfa7339,
    0x2f5dc28c, 0x3fc05370, 0x90cc396c, 0x8051a890, 0xb3f61925,
    0xa36b88d9, 0xd6b879fe, 0xc625e802, 0xf58259b7, 0xe51fc84b,
    0x1f24baf8, 0x0fb92b04, 0x3c1e9ab1, 0x2c830b4d, 0x5950fa6a,
    0x49cd6b96, 0x7a6ada23, 0x6af74bdf, 0x8d1d3df5, 0x9d80ac09,
    0xae271dbc, 0xbeba8c40, 0xcb697d67, 0xdbf4ec9b, 0xe8535d2e,
    0xf8ceccd2, 0x02f5be61, 0x12682f9d, 0x21cf9e28, 0x31520fd4,
    0x4481fef3, 0x541c6f0f, 0x67bbdeba, 0x77264f46, 0xa96e33ee,
    0xb9f3a212, 0x8a5413a7, 0x9ac9825b, 0xef1a737c, 0xff87e280,
    0xcc205335, 0xdcbdc2c9, 0x2686b07a, 0x361b2186, 0x05bc9033,
    0x152101cf, 0x60f2f0e8, 0x706f6114, 0x43c8d0a1, 0x5355415d,
    0xb4bf3777, 0xa422a68b, 0x9785173e, 0x871886c2, 0xf2cb77e5,
    0xe256e619, 0xd1f157ac, 0xc16cc650, 0x3b57b4e3, 0x2bca251f,
    0x186d94aa, 0x08f00556, 0x7d23f471, 0x6dbe658d, 0x5e19d438,
    0x4e8445c4},
   {0x00000000, 0x9c81fd99, 0x3b03f883, 0xa782051a, 0x7506f3b7,
    0xe9870e2e, 0x4e050b34, 0xd284f6ad, 0xe90ce5df, 0x758d1846,
    0xd20f1d5c, 0x4e8ee0c5, 0x9c0a1668, 0x008bebf1, 0xa709eeeb,
    0x3b881372, 0xd119c90f, 0x4d983496, 0xea1a318c, 0x769bcc15,
    0xa41f3ab8, 0x389ec721, 0x9f1cc23b, 0x039d3fa2, 0x38152cd0,
    0xa494d149, 0x0316d453, 0x9f9729ca, 0x4d13df67, 0xd19222fe,
    0x761027e4, 0xea91da7d, 0xa233921f, 0x3eb26f86, 0x99306a9c,
    0x05b19705, 0xd73561a8, 0x4bb49c31, 0xec36992b, 0x70b764b2,
    0x4b3f77c0, 0xd7be8a59, 0x703c8f43, 0xecbd72da, 0x3e398477,
    0xa2b879ee, 0x053a7cf4, 0x99bb816d, 0x732a5b10, 0xefaba689,
    0x4829a393, 0xd4a85e0a, 0x062ca8a7, 0x9aad553e, 0x3d2f5024,
    0xa1aeadbd, 0x9a26becf, 0x06a74356, 0xa125464c, 0x3da4bbd5,
    0xef204d78, 0x73a1b0e1, 0xd423b5fb, 0x48a24862, 0x4467243f,
    0xd8e6d9a6, 0x7f64dcbc, 0xe3e52125, 0x3161d788, 0xade02a11,
    0x0a622f0b, 0x96e3d292, 0xad6bc1e0, 0x31ea3c79, 0x96683963,
    0x0ae9c4fa, 0xd86d3257, 0x44eccfce, 0xe36ecad4, 0x7fef374d,
    0x957eed30, 0x09ff10a9, 0xae7d15b3, 0x32fce82a, 0xe0781e87,
    0x7cf9e31e, 0xdb7be604, 0x47fa1b9d, 0x7c7208ef, 0xe0f3f576,
    0x4771f06c, 0xdbf00df5, 0x0974fb58, 0x95f506c1, 0x327703db,
    0xaef6fe42, 0xe654b620, 0x7ad54bb9, 0xdd574ea3, 0x41d6b33a,
    0x93524597, 0x0fd3b80e, 0xa851bd14, 0x34d0408d, 0x0f5853ff,
    0x93d9ae66, 0x345bab7c, 0xa8da56e5, 0x7a5ea048, 0xe6df5dd1,
    0x415d58cb, 0xdddca552, 0x374d7f2f, 0xabcc82b6, 0x0c4e87ac,
    0x90cf7a35, 0x424b8c98, 0xdeca7101, 0x7948741b, 0xe5c98982,
    0xde419af0, 0x42c06769, 0xe5426273, 0x79c39fea, 0xab476947,
    0x37c694de, 0x904491c4, 0x0cc56c5d, 0x88ce487e, 0x144fb5e7,
    0xb3cdb0fd, 0x2f4c4d64, 0xfdc8bbc9, 0x61494650, 0xc6cb434a,
    0x5a4abed3, 0x61c2ada1, 0xfd435038, 0x5ac15522, 0xc640a8bb,
    0x14c45e16, 0x8845a38f, 0x2fc7a695, 0xb3465b0c, 0x59d78171,
    0xc5567ce8, 0x62d479f2, 0xfe55846b, 0x2cd172c6, 0xb0508f5f,
    0x17d28a45, 0x8b5377dc, 0xb0db64ae, 0x2c5a9937, 0x8bd89c2d,
    0x175961b4, 0xc5dd9719, 0x595c6a80, 0xfede6f9a, 0x625f9203,
    0x2afdda61, 0xb67c27f8, 0x11fe22e2, 0x8d7fdf7b, 0x5ffb29d6,
    0xc37ad44f, 0x64f8d155, 0xf8792ccc, 0xc3f13fbe, 0x5f70c227,
    0xf8f2c73d, 0x64733aa4, 0xb6f7cc09, 0x2a763190, 0x8df4348a,
    0x1175c913, 0xfbe4136e, 0x6765eef7, 0xc0e7ebed, 0x5c661674,
    0x8ee2e0d9, 0x12631d40, 0xb5e1185a, 0x2960e5c3, 0x12e8f6b1,
    0x8e690b28, 0x29eb0e32, 0xb56af3ab, 0x67ee0506, 0xfb6ff89f,
    0x5cedfd85, 0xc06c001c, 0xcca96c41, 0x502891d8, 0xf7aa94c2,
    0x6b2b695b, 0xb9af9ff6, 0x252e626f, 0x82ac6775, 0x1e2d9aec,
    0x25a5899e, 0xb9247407, 0x1ea6711d, 0x82278c84, 0x50a37a29,
    0xcc2287b0, 0x6ba082aa, 0xf7217f33, 0x1db0a54e, 0x813158d7,
    0x26b35dcd, 0xba32a054, 0x68b656f9, 0xf437ab60, 0x53b5ae7a,
    0xcf3453e3, 0xf4bc4091, 0x683dbd08, 0xcfbfb812, 0x533e458b,
    0x81bab326, 0x1d3b4ebf, 0xbab94ba5, 0x2638b63c, 0x6e9afe5e,
    0xf21b03c7, 0x559906dd, 0xc918fb44, 0x1b9c0de9, 0x871df070,
    0x209ff56a, 0xbc1e08f3, 0x87961b81, 0x1b17e618, 0xbc95e302,
    0x20141e9b, 0xf290e836, 0x6e1115af, 0xc99310b5, 0x5512ed2c,
    0xbf833751, 0x2302cac8, 0x8480cfd2, 0x1801324b, 0xca85c4e6,
    0x5604397f, 0xf1863c65, 0x6d07c1fc, 0x568fd28e, 0xca0e2f17,
    0x6d8c2a0d, 0xf10dd794, 0x23892139, 0xbf08dca0, 0x188ad9ba,
    0x840b2423},
   {0x00000000, 0x81615947, 0x02c3b28e, 0x83a2ebc9, 0x078666ad,
    0x86e73fea, 0x0545d423, 0x84248d64, 0x0d0cceea, 0x8c6d97ad,
    0x0fcf7c64, 0x8eae2523, 0x0a8aa847, 0x8bebf100, 0x08491ac9,
    0x8928438e, 0x19189f65, 0x9879c622, 0x1bdb2deb, 0x9aba74ac,
    0x1e9ef9c8, 0x9fffa08f, 0x1c5d4b46, 0x9d3c1201, 0x1414518f,
    0x957508c8, 0x16d7e301, 0x97b6ba46, 0x13923722, 0x92f36e65,
    0x115185ac, 0x9030dceb, 0x32303ecb, 0xb351678c, 0x30f38c45,
    0xb192d502, 0x35b65866, 0xb4d70121, 0x3775eae8, 0xb614b3af,
    0x3f3cf021, 0xbe5da966, 0x3dff42af, 0xbc9e1be8, 0x38ba968c,
    0xb9dbcfcb, 0x3a792402, 0xbb187d45, 0x2b28a1ae, 0xaa49f8e9,
    0x29eb1320, 0xa88a4a67, 0x2caec703, 0xadcf9e44, 0x2e6d758d,
    0xaf0c2cca, 0x26246f44, 0xa7453603, 0x24e7ddca, 0xa586848d,
    0x21a209e9, 0xa0c350ae, 0x2361bb67, 0xa200e220, 0x67607f26,
    0xe6012661, 0x65a3cda8, 0xe4c294ef, 0x60e6198b, 0xe18740cc,
    0x6225ab05, 0xe344f242, 0x6a6cb1cc, 0xeb0de88b, 0x68af0342,
    0xe9ce5a05, 0x6dead761, 0xec8b8e26, 0x6f2965ef, 0xee483ca8,
    0x7e78e043, 0xff19b904, 0x7cbb52cd, 0xfdda0b8a, 0x79fe86ee,
    0xf89fdfa9, 0x7b3d3460, 0xfa5c6d27, 0x73742ea9, 0xf21577ee,
    0x71b79c27, 0xf0d6c560, 0x74f24804, 0xf5931143, 0x7631fa8a,
    0xf750a3cd, 0x555041ed, 0xd43118aa, 0x5793f363, 0xd6f2aa24,
    0x52d62740, 0xd3b77e07, 0x501595ce, 0xd174cc89, 0x585c8f07,
    0xd93dd640, 0x5a9f3d89, 0xdbfe64ce, 0x5fdae9aa, 0xdebbb0ed,
    0x5d195b24, 0xdc780263, 0x4c48de88, 0xcd2987cf, 0x4e8b6c06,
    0xcfea3541, 0x4bceb825, 0xcaafe162, 0x490d0aab, 0xc86c53ec,
    0x41441062, 0xc0254925, 0x4387a2ec, 0xc2e6fbab, 0x46c276cf,
    0xc7a32f88, 0x4401c441, 0xc5609d06, 0xcec0fe4c, 0x4fa1a70b,
    0xcc034cc2, 0x4d621585, 0xc94698e1, 0x4827c1a6, 0xcb852a6f,
    0x4ae47328, 0xc3cc30a6, 0x42ad69e1, 0xc10f8228, 0x406edb6f,
    0xc44a560b, 0x452b0f4c, 0xc689e485, 0x47e8bdc2, 0xd7d86129,
    0x56b9386e, 0xd51bd3a7, 0x547a8ae0, 0xd05e0784, 0x513f5ec3,
    0xd29db50a, 0x53fcec4d, 0xdad4afc3, 0x5bb5f684, 0xd8171d4d,
    0x5976440a, 0xdd52c96e, 0x5c339029, 0xdf917be0, 0x5ef022a7,
    0xfcf0c087, 0x7d9199c0, 0xfe337209, 0x7f522b4e, 0xfb76a62a,
    0x7a17ff6d, 0xf9b514a4, 0x78d44de3, 0xf1fc0e6d, 0x709d572a,
    0xf33fbce3, 0x725ee5a4, 0xf67a68c0, 0x771b3187, 0xf4b9da4e,
    0x75d88309, 0xe5e85fe2, 0x648906a5, 0xe72bed6c, 0x664ab42b,
    0xe26e394f, 0x630f6008, 0xe0ad8bc1, 0x61ccd286, 0xe8e49108,
    0x6985c84f, 0xea272386, 0x6b467ac1, 0xef62f7a5, 0x6e03aee2,
    0xeda1452b, 0x6cc01c6c, 0xa9a0816a, 0x28c1d82d, 0xab6333e4,
    0x2a026aa3, 0xae26e7c7, 0x2f47be80, 0xace55549, 0x2d840c0e,
    0xa4ac4f80, 0x25cd16c7, 0xa66ffd0e, 0x270ea449, 0xa32a292d,
    0x224b706a, 0xa1e99ba3, 0x2088c2e4, 0xb0b81e0f, 0x31d94748,
    0xb27bac81, 0x331af5c6, 0xb73e78a2, 0x365f21e5, 0xb5fdca2c,
    0x349c936b, 0xbdb4d0e5, 0x3cd589a2, 0xbf77626b, 0x3e163b2c,
    0xba32b648, 0x3b53ef0f, 0xb8f104c6, 0x39905d81, 0x9b90bfa1,
    0x1af1e6e6, 0x99530d2f, 0x18325468, 0x9c16d90c, 0x1d77804b,
    0x9ed56b82, 0x1fb432c5, 0x969c714b, 0x17fd280c, 0x945fc3c5,
    0x153e9a82, 0x911a17e6, 0x107b4ea1, 0x93d9a568, 0x12b8fc2f,
    0x828820c4, 0x03e97983, 0x804b924a, 0x012acb0d, 0x850e4669,
    0x046f1f2e, 0x87cdf4e7, 0x06acada0, 0x8f84ee2e, 0x0ee5b769,
    0x8d475ca0, 0x0c2605e7, 0x88028883, 0x0963d1c4, 0x8ac13a0d,
    0x0ba0634a}};

#endif

#endif

#endif

static const crc_t x2n_table[] = {
    0x40000000, 0x20000000, 0x08000000, 0x00800000, 0x00008000,
    0xd8018001, 0xf8818001, 0xf0810001, 0x28008000, 0xd0818001,
    0xf8010001, 0x28800000, 0x08808000, 0xd8810001, 0x20808000,
    0xd0010001, 0x20000000, 0x08000000, 0x00800000, 0x00008000,
    0xd8018001, 0xf8818001, 0xf0810001, 0x28008000, 0xd0818001,
    0xf8010001, 0x28800000, 0x08808000, 0xd8810001, 0x20808000,
    0xd0010001, 0x20000000};
