<h1 align="center">AtomicGo | schedule</h1>

<p align="center">
<img src="https://img.shields.io/endpoint?url=https%3A%2F%2Fatomicgo.dev%2Fapi%2Fshields%2Fschedule&style=flat-square" alt="Downloads">

<a href="https://github.com/atomicgo/schedule/releases">
<img src="https://img.shields.io/github/v/release/atomicgo/schedule?style=flat-square" alt="Latest Release">
</a>

<a href="https://codecov.io/gh/atomicgo/schedule" target="_blank">
<img src="https://img.shields.io/github/actions/workflow/status/atomicgo/schedule/go.yml?style=flat-square" alt="Tests">
</a>

<a href="https://codecov.io/gh/atomicgo/schedule" target="_blank">
<img src="https://img.shields.io/codecov/c/gh/atomicgo/schedule?color=magenta&logo=codecov&style=flat-square" alt="Coverage">
</a>

<a href="https://codecov.io/gh/atomicgo/schedule">
<!-- unittestcount:start --><img src="https://img.shields.io/badge/Unit_Tests-0-magenta?style=flat-square" alt="Unit test count"><!-- unittestcount:end -->
</a>

<a href="https://opensource.org/licenses/MIT" target="_blank">
<img src="https://img.shields.io/badge/License-MIT-yellow.svg?style=flat-square" alt="License: MIT">
</a>
  
<a href="https://goreportcard.com/report/github.com/atomicgo/schedule" target="_blank">
<img src="https://goreportcard.com/badge/github.com/atomicgo/schedule?style=flat-square" alt="Go report">
</a>   

</p>

---

<p align="center">
<strong><a href="https://pkg.go.dev/atomicgo.dev/schedule#section-documentation" target="_blank">Documentation</a></strong>
|
<strong><a href="https://github.com/atomicgo/atomicgo/blob/main/CONTRIBUTING.md" target="_blank">Contributing</a></strong>
|
<strong><a href="https://github.com/atomicgo/atomicgo/blob/main/CODE_OF_CONDUCT.md" target="_blank">Code of Conduct</a></strong>
</p>

---

<p align="center">
  <img src="https://raw.githubusercontent.com/atomicgo/atomicgo/main/assets/header.png" alt="AtomicGo">
</p>

<p align="center">
<table>
<tbody>
</tbody>
</table>
</p>
<h3  align="center"><pre>go get atomicgo.dev/schedule</pre></h3>
<p align="center">
<table>
<tbody>
</tbody>
</table>
</p>

<!-- gomarkdoc:embed:start -->

<!-- Code generated by gomarkdoc. DO NOT EDIT -->

# schedule

```go
import "atomicgo.dev/schedule"
```

Package schedule provides a simple scheduler for Go.

It can run a function at a given time, in a given duration, or repeatedly at a given interval.

## Index

- [type Task](<#Task>)
  - [func After\(d time.Duration, task func\(\)\) \*Task](<#After>)
  - [func At\(t time.Time, task func\(\)\) \*Task](<#At>)
  - [func Every\(interval time.Duration, task func\(\) bool\) \*Task](<#Every>)
  - [func \(s \*Task\) ExecutesIn\(\) time.Duration](<#Task.ExecutesIn>)
  - [func \(s \*Task\) IsActive\(\) bool](<#Task.IsActive>)
  - [func \(s \*Task\) NextExecutionTime\(\) time.Time](<#Task.NextExecutionTime>)
  - [func \(s \*Task\) StartedAt\(\) time.Time](<#Task.StartedAt>)
  - [func \(s \*Task\) Stop\(\)](<#Task.Stop>)
  - [func \(s \*Task\) Wait\(\)](<#Task.Wait>)


<a name="Task"></a>
## type [Task](<https://github.com/atomicgo/schedule/blob/main/schedule.go#L6-L10>)

Task holds information about the running task and can be used to stop running tasks.

```go
type Task struct {
    // contains filtered or unexported fields
}
```

<a name="After"></a>
### func [After](<https://github.com/atomicgo/schedule/blob/main/schedule.go#L58>)

```go
func After(d time.Duration, task func()) *Task
```

After executes the task after the given duration. The function is non\-blocking. If you want to wait for the task to be executed, use the Task.Wait method.

<details><summary>Example</summary>
<p>



```go
package main

import (
	"fmt"
	"time"

	"atomicgo.dev/schedule"
)

func main() {
	task := schedule.After(5*time.Second, func() {
		fmt.Println("5 seconds are over!")
	})

	fmt.Println("Some stuff happening...")

	task.Wait()
}
```

</p>
</details>

<a name="At"></a>
### func [At](<https://github.com/atomicgo/schedule/blob/main/schedule.go#L77>)

```go
func At(t time.Time, task func()) *Task
```

At executes the task at the given time. The function is non\-blocking. If you want to wait for the task to be executed, use the Task.Wait method.

<details><summary>Example</summary>
<p>



```go
package main

import (
	"fmt"
	"time"

	"atomicgo.dev/schedule"
)

func main() {
	task := schedule.At(time.Now().Add(5*time.Second), func() {
		fmt.Println("5 seconds are over!")
	})

	fmt.Println("Some stuff happening...")

	task.Wait()
}
```

</p>
</details>

<a name="Every"></a>
### func [Every](<https://github.com/atomicgo/schedule/blob/main/schedule.go#L96>)

```go
func Every(interval time.Duration, task func() bool) *Task
```

Every executes the task in the given interval, as long as the task function returns true. The function is non\-blocking. If you want to wait for the task to be executed, use the Task.Wait method.

<details><summary>Example</summary>
<p>



```go
package main

import (
	"fmt"
	"time"

	"atomicgo.dev/schedule"
)

func main() {
	task := schedule.Every(time.Second, func() bool {
		fmt.Println("1 second is over!")
		return true // return false to stop the task
	})

	fmt.Println("Some stuff happening...")

	time.Sleep(10 * time.Second)

	task.Stop()
}
```

</p>
</details>

<a name="Task.ExecutesIn"></a>
### func \(\*Task\) [ExecutesIn](<https://github.com/atomicgo/schedule/blob/main/schedule.go#L31>)

```go
func (s *Task) ExecutesIn() time.Duration
```

ExecutesIn returns the duration until the next execution.

<a name="Task.IsActive"></a>
### func \(\*Task\) [IsActive](<https://github.com/atomicgo/schedule/blob/main/schedule.go#L36>)

```go
func (s *Task) IsActive() bool
```

IsActive returns true if the scheduler is active.

<a name="Task.NextExecutionTime"></a>
### func \(\*Task\) [NextExecutionTime](<https://github.com/atomicgo/schedule/blob/main/schedule.go#L26>)

```go
func (s *Task) NextExecutionTime() time.Time
```

NextExecutionTime returns the time when the next execution will happen.

<a name="Task.StartedAt"></a>
### func \(\*Task\) [StartedAt](<https://github.com/atomicgo/schedule/blob/main/schedule.go#L21>)

```go
func (s *Task) StartedAt() time.Time
```

StartedAt returns the time when the scheduler was started.

<a name="Task.Stop"></a>
### func \(\*Task\) [Stop](<https://github.com/atomicgo/schedule/blob/main/schedule.go#L52>)

```go
func (s *Task) Stop()
```

Stop stops the scheduler.

<a name="Task.Wait"></a>
### func \(\*Task\) [Wait](<https://github.com/atomicgo/schedule/blob/main/schedule.go#L47>)

```go
func (s *Task) Wait()
```

Wait blocks until the scheduler is stopped. After and At will stop automatically after the task is executed.

Generated by [gomarkdoc](<https://github.com/princjef/gomarkdoc>)


<!-- gomarkdoc:embed:end -->

---

> [AtomicGo.dev](https://atomicgo.dev) &nbsp;&middot;&nbsp;
> with ❤️ by [@MarvinJWendt](https://github.com/MarvinJWendt) |
> [MarvinJWendt.com](https://marvinjwendt.com)
