//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cflocaleidentifier?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
pub type CFLocaleIdentifier = CFString;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cflocalekey?language=objc)
// NS_TYPED_ENUM
pub type CFLocaleKey = CFString;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cflocale?language=objc)
///
/// This is toll-free bridged with `NSLocale`.
#[doc(alias = "CFLocaleRef")]
#[repr(C)]
pub struct CFLocale {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFLocale {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFLocale"> for CFLocale {}
);

unsafe impl ConcreteType for CFLocale {
    #[doc(alias = "CFLocaleGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFLocaleGetTypeID() -> CFTypeID;
        }
        unsafe { CFLocaleGetTypeID() }
    }
}

impl CFLocale {
    #[doc(alias = "CFLocaleGetSystem")]
    #[inline]
    pub fn system() -> Option<CFRetained<CFLocale>> {
        extern "C-unwind" {
            fn CFLocaleGetSystem() -> Option<NonNull<CFLocale>>;
        }
        let ret = unsafe { CFLocaleGetSystem() };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFLocaleCopyCurrent")]
    #[inline]
    pub fn current() -> Option<CFRetained<CFLocale>> {
        extern "C-unwind" {
            fn CFLocaleCopyCurrent() -> Option<NonNull<CFLocale>>;
        }
        let ret = unsafe { CFLocaleCopyCurrent() };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFLocaleCopyAvailableLocaleIdentifiers")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub fn available_locale_identifiers() -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFLocaleCopyAvailableLocaleIdentifiers() -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFLocaleCopyAvailableLocaleIdentifiers() };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFLocaleCopyISOLanguageCodes")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub fn iso_language_codes() -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFLocaleCopyISOLanguageCodes() -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFLocaleCopyISOLanguageCodes() };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFLocaleCopyISOCountryCodes")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub fn iso_country_codes() -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFLocaleCopyISOCountryCodes() -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFLocaleCopyISOCountryCodes() };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFLocaleCopyISOCurrencyCodes")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub fn iso_currency_codes() -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFLocaleCopyISOCurrencyCodes() -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFLocaleCopyISOCurrencyCodes() };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFLocaleCopyCommonISOCurrencyCodes")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub fn common_iso_currency_codes() -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFLocaleCopyCommonISOCurrencyCodes() -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFLocaleCopyCommonISOCurrencyCodes() };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFLocaleCopyPreferredLanguages")]
    #[cfg(feature = "CFArray")]
    #[inline]
    pub fn preferred_languages() -> Option<CFRetained<CFArray>> {
        extern "C-unwind" {
            fn CFLocaleCopyPreferredLanguages() -> Option<NonNull<CFArray>>;
        }
        let ret = unsafe { CFLocaleCopyPreferredLanguages() };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFLocaleCreateCanonicalLanguageIdentifierFromString")]
    #[inline]
    pub fn new_canonical_language_identifier_from_string(
        allocator: Option<&CFAllocator>,
        locale_identifier: Option<&CFString>,
    ) -> Option<CFRetained<CFLocaleIdentifier>> {
        extern "C-unwind" {
            fn CFLocaleCreateCanonicalLanguageIdentifierFromString(
                allocator: Option<&CFAllocator>,
                locale_identifier: Option<&CFString>,
            ) -> Option<NonNull<CFLocaleIdentifier>>;
        }
        let ret = unsafe {
            CFLocaleCreateCanonicalLanguageIdentifierFromString(allocator, locale_identifier)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFLocaleCreateCanonicalLocaleIdentifierFromString")]
    #[inline]
    pub fn new_canonical_locale_identifier_from_string(
        allocator: Option<&CFAllocator>,
        locale_identifier: Option<&CFString>,
    ) -> Option<CFRetained<CFLocaleIdentifier>> {
        extern "C-unwind" {
            fn CFLocaleCreateCanonicalLocaleIdentifierFromString(
                allocator: Option<&CFAllocator>,
                locale_identifier: Option<&CFString>,
            ) -> Option<NonNull<CFLocaleIdentifier>>;
        }
        let ret = unsafe {
            CFLocaleCreateCanonicalLocaleIdentifierFromString(allocator, locale_identifier)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFLocaleCreateCanonicalLocaleIdentifierFromScriptManagerCodes")]
    #[inline]
    pub fn new_canonical_locale_identifier_from_script_manager_codes(
        allocator: Option<&CFAllocator>,
        lcode: LangCode,
        rcode: RegionCode,
    ) -> Option<CFRetained<CFLocaleIdentifier>> {
        extern "C-unwind" {
            fn CFLocaleCreateCanonicalLocaleIdentifierFromScriptManagerCodes(
                allocator: Option<&CFAllocator>,
                lcode: LangCode,
                rcode: RegionCode,
            ) -> Option<NonNull<CFLocaleIdentifier>>;
        }
        let ret = unsafe {
            CFLocaleCreateCanonicalLocaleIdentifierFromScriptManagerCodes(allocator, lcode, rcode)
        };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFLocaleCreateLocaleIdentifierFromWindowsLocaleCode")]
    #[inline]
    pub fn new_locale_identifier_from_windows_locale_code(
        allocator: Option<&CFAllocator>,
        lcid: u32,
    ) -> Option<CFRetained<CFLocaleIdentifier>> {
        extern "C-unwind" {
            fn CFLocaleCreateLocaleIdentifierFromWindowsLocaleCode(
                allocator: Option<&CFAllocator>,
                lcid: u32,
            ) -> Option<NonNull<CFLocaleIdentifier>>;
        }
        let ret = unsafe { CFLocaleCreateLocaleIdentifierFromWindowsLocaleCode(allocator, lcid) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFLocaleGetWindowsLocaleCodeFromLocaleIdentifier")]
    #[inline]
    pub fn windows_locale_code_from_locale_identifier(
        locale_identifier: Option<&CFLocaleIdentifier>,
    ) -> u32 {
        extern "C-unwind" {
            fn CFLocaleGetWindowsLocaleCodeFromLocaleIdentifier(
                locale_identifier: Option<&CFLocaleIdentifier>,
            ) -> u32;
        }
        unsafe { CFLocaleGetWindowsLocaleCodeFromLocaleIdentifier(locale_identifier) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cflocalelanguagedirection?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFLocaleLanguageDirection(pub CFIndex);
impl CFLocaleLanguageDirection {
    #[doc(alias = "kCFLocaleLanguageDirectionUnknown")]
    pub const Unknown: Self = Self(0);
    #[doc(alias = "kCFLocaleLanguageDirectionLeftToRight")]
    pub const LeftToRight: Self = Self(1);
    #[doc(alias = "kCFLocaleLanguageDirectionRightToLeft")]
    pub const RightToLeft: Self = Self(2);
    #[doc(alias = "kCFLocaleLanguageDirectionTopToBottom")]
    pub const TopToBottom: Self = Self(3);
    #[doc(alias = "kCFLocaleLanguageDirectionBottomToTop")]
    pub const BottomToTop: Self = Self(4);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFLocaleLanguageDirection {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFLocaleLanguageDirection {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CFLocale {
    #[doc(alias = "CFLocaleGetLanguageCharacterDirection")]
    #[inline]
    pub fn language_character_direction(
        iso_lang_code: Option<&CFString>,
    ) -> CFLocaleLanguageDirection {
        extern "C-unwind" {
            fn CFLocaleGetLanguageCharacterDirection(
                iso_lang_code: Option<&CFString>,
            ) -> CFLocaleLanguageDirection;
        }
        unsafe { CFLocaleGetLanguageCharacterDirection(iso_lang_code) }
    }

    #[doc(alias = "CFLocaleGetLanguageLineDirection")]
    #[inline]
    pub fn language_line_direction(iso_lang_code: Option<&CFString>) -> CFLocaleLanguageDirection {
        extern "C-unwind" {
            fn CFLocaleGetLanguageLineDirection(
                iso_lang_code: Option<&CFString>,
            ) -> CFLocaleLanguageDirection;
        }
        unsafe { CFLocaleGetLanguageLineDirection(iso_lang_code) }
    }

    #[doc(alias = "CFLocaleCreateComponentsFromLocaleIdentifier")]
    #[cfg(feature = "CFDictionary")]
    #[inline]
    pub fn new_components_from_locale_identifier(
        allocator: Option<&CFAllocator>,
        locale_id: Option<&CFLocaleIdentifier>,
    ) -> Option<CFRetained<CFDictionary>> {
        extern "C-unwind" {
            fn CFLocaleCreateComponentsFromLocaleIdentifier(
                allocator: Option<&CFAllocator>,
                locale_id: Option<&CFLocaleIdentifier>,
            ) -> Option<NonNull<CFDictionary>>;
        }
        let ret = unsafe { CFLocaleCreateComponentsFromLocaleIdentifier(allocator, locale_id) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// - `allocator` might not allow `None`.
    /// - `dictionary` generics must be of the correct type.
    /// - `dictionary` might not allow `None`.
    #[doc(alias = "CFLocaleCreateLocaleIdentifierFromComponents")]
    #[cfg(feature = "CFDictionary")]
    #[inline]
    pub unsafe fn new_locale_identifier_from_components(
        allocator: Option<&CFAllocator>,
        dictionary: Option<&CFDictionary>,
    ) -> Option<CFRetained<CFLocaleIdentifier>> {
        extern "C-unwind" {
            fn CFLocaleCreateLocaleIdentifierFromComponents(
                allocator: Option<&CFAllocator>,
                dictionary: Option<&CFDictionary>,
            ) -> Option<NonNull<CFLocaleIdentifier>>;
        }
        let ret = unsafe { CFLocaleCreateLocaleIdentifierFromComponents(allocator, dictionary) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFLocaleCreate")]
    #[inline]
    pub fn new(
        allocator: Option<&CFAllocator>,
        locale_identifier: Option<&CFLocaleIdentifier>,
    ) -> Option<CFRetained<CFLocale>> {
        extern "C-unwind" {
            fn CFLocaleCreate(
                allocator: Option<&CFAllocator>,
                locale_identifier: Option<&CFLocaleIdentifier>,
            ) -> Option<NonNull<CFLocale>>;
        }
        let ret = unsafe { CFLocaleCreate(allocator, locale_identifier) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFLocaleCreateCopy")]
    #[inline]
    pub fn new_copy(
        allocator: Option<&CFAllocator>,
        locale: Option<&CFLocale>,
    ) -> Option<CFRetained<CFLocale>> {
        extern "C-unwind" {
            fn CFLocaleCreateCopy(
                allocator: Option<&CFAllocator>,
                locale: Option<&CFLocale>,
            ) -> Option<NonNull<CFLocale>>;
        }
        let ret = unsafe { CFLocaleCreateCopy(allocator, locale) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFLocaleGetIdentifier")]
    #[inline]
    pub fn identifier(&self) -> Option<CFRetained<CFLocaleIdentifier>> {
        extern "C-unwind" {
            fn CFLocaleGetIdentifier(locale: &CFLocale) -> Option<NonNull<CFLocaleIdentifier>>;
        }
        let ret = unsafe { CFLocaleGetIdentifier(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFLocaleGetValue")]
    #[inline]
    pub fn value(&self, key: Option<&CFLocaleKey>) -> Option<CFRetained<CFType>> {
        extern "C-unwind" {
            fn CFLocaleGetValue(
                locale: &CFLocale,
                key: Option<&CFLocaleKey>,
            ) -> Option<NonNull<CFType>>;
        }
        let ret = unsafe { CFLocaleGetValue(self, key) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFLocaleCopyDisplayNameForPropertyValue")]
    #[inline]
    pub fn display_name_for_property_value(
        &self,
        key: Option<&CFLocaleKey>,
        value: Option<&CFString>,
    ) -> Option<CFRetained<CFString>> {
        extern "C-unwind" {
            fn CFLocaleCopyDisplayNameForPropertyValue(
                display_locale: &CFLocale,
                key: Option<&CFLocaleKey>,
                value: Option<&CFString>,
            ) -> Option<NonNull<CFString>>;
        }
        let ret = unsafe { CFLocaleCopyDisplayNameForPropertyValue(self, key, value) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecurrentlocaledidchangenotification?language=objc)
    #[cfg(feature = "CFNotificationCenter")]
    pub static kCFLocaleCurrentLocaleDidChangeNotification: Option<&'static CFNotificationName>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocaleidentifier?language=objc)
    pub static kCFLocaleIdentifier: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalelanguagecode?language=objc)
    pub static kCFLocaleLanguageCode: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecountrycode?language=objc)
    pub static kCFLocaleCountryCode: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalescriptcode?language=objc)
    pub static kCFLocaleScriptCode: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalevariantcode?language=objc)
    pub static kCFLocaleVariantCode: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocaleexemplarcharacterset?language=objc)
    pub static kCFLocaleExemplarCharacterSet: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecalendaridentifier?language=objc)
    pub static kCFLocaleCalendarIdentifier: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecalendar?language=objc)
    pub static kCFLocaleCalendar: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecollationidentifier?language=objc)
    pub static kCFLocaleCollationIdentifier: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocaleusesmetricsystem?language=objc)
    pub static kCFLocaleUsesMetricSystem: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalemeasurementsystem?language=objc)
    pub static kCFLocaleMeasurementSystem: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocaledecimalseparator?language=objc)
    pub static kCFLocaleDecimalSeparator: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalegroupingseparator?language=objc)
    pub static kCFLocaleGroupingSeparator: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecurrencysymbol?language=objc)
    pub static kCFLocaleCurrencySymbol: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecurrencycode?language=objc)
    pub static kCFLocaleCurrencyCode: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalecollatoridentifier?language=objc)
    pub static kCFLocaleCollatorIdentifier: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalequotationbegindelimiterkey?language=objc)
    pub static kCFLocaleQuotationBeginDelimiterKey: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalequotationenddelimiterkey?language=objc)
    pub static kCFLocaleQuotationEndDelimiterKey: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalealternatequotationbegindelimiterkey?language=objc)
    pub static kCFLocaleAlternateQuotationBeginDelimiterKey: Option<&'static CFLocaleKey>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcflocalealternatequotationenddelimiterkey?language=objc)
    pub static kCFLocaleAlternateQuotationEndDelimiterKey: Option<&'static CFLocaleKey>;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfcalendaridentifier?language=objc)
// NS_TYPED_ENUM
pub type CFCalendarIdentifier = CFString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfgregoriancalendar?language=objc)
    pub static kCFGregorianCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbuddhistcalendar?language=objc)
    pub static kCFBuddhistCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfchinesecalendar?language=objc)
    pub static kCFChineseCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfhebrewcalendar?language=objc)
    pub static kCFHebrewCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfislamiccalendar?language=objc)
    pub static kCFIslamicCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfislamiccivilcalendar?language=objc)
    pub static kCFIslamicCivilCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfjapanesecalendar?language=objc)
    pub static kCFJapaneseCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfrepublicofchinacalendar?language=objc)
    pub static kCFRepublicOfChinaCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfpersiancalendar?language=objc)
    pub static kCFPersianCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfindiancalendar?language=objc)
    pub static kCFIndianCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfiso8601calendar?language=objc)
    pub static kCFISO8601Calendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfislamictabularcalendar?language=objc)
    pub static kCFIslamicTabularCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfislamicummalquracalendar?language=objc)
    pub static kCFIslamicUmmAlQuraCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfbanglacalendar?language=objc)
    pub static kCFBanglaCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfgujaraticalendar?language=objc)
    pub static kCFGujaratiCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfkannadacalendar?language=objc)
    pub static kCFKannadaCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfmalayalamcalendar?language=objc)
    pub static kCFMalayalamCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfmarathicalendar?language=objc)
    pub static kCFMarathiCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfodiacalendar?language=objc)
    pub static kCFOdiaCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcftamilcalendar?language=objc)
    pub static kCFTamilCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcftelugucalendar?language=objc)
    pub static kCFTeluguCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfvikramcalendar?language=objc)
    pub static kCFVikramCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfdangicalendar?language=objc)
    pub static kCFDangiCalendar: Option<&'static CFCalendarIdentifier>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfvietnamesecalendar?language=objc)
    pub static kCFVietnameseCalendar: Option<&'static CFCalendarIdentifier>;
}

#[deprecated = "renamed to `CFLocale::system`"]
#[inline]
pub extern "C-unwind" fn CFLocaleGetSystem() -> Option<CFRetained<CFLocale>> {
    extern "C-unwind" {
        fn CFLocaleGetSystem() -> Option<NonNull<CFLocale>>;
    }
    let ret = unsafe { CFLocaleGetSystem() };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFLocale::current`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCopyCurrent() -> Option<CFRetained<CFLocale>> {
    extern "C-unwind" {
        fn CFLocaleCopyCurrent() -> Option<NonNull<CFLocale>>;
    }
    let ret = unsafe { CFLocaleCopyCurrent() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFLocale::available_locale_identifiers`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCopyAvailableLocaleIdentifiers() -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFLocaleCopyAvailableLocaleIdentifiers() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFLocaleCopyAvailableLocaleIdentifiers() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFLocale::iso_language_codes`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCopyISOLanguageCodes() -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFLocaleCopyISOLanguageCodes() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFLocaleCopyISOLanguageCodes() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFLocale::iso_country_codes`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCopyISOCountryCodes() -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFLocaleCopyISOCountryCodes() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFLocaleCopyISOCountryCodes() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFLocale::iso_currency_codes`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCopyISOCurrencyCodes() -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFLocaleCopyISOCurrencyCodes() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFLocaleCopyISOCurrencyCodes() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFLocale::common_iso_currency_codes`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCopyCommonISOCurrencyCodes() -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFLocaleCopyCommonISOCurrencyCodes() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFLocaleCopyCommonISOCurrencyCodes() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFArray")]
#[deprecated = "renamed to `CFLocale::preferred_languages`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCopyPreferredLanguages() -> Option<CFRetained<CFArray>> {
    extern "C-unwind" {
        fn CFLocaleCopyPreferredLanguages() -> Option<NonNull<CFArray>>;
    }
    let ret = unsafe { CFLocaleCopyPreferredLanguages() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFLocale::new_canonical_language_identifier_from_string`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCreateCanonicalLanguageIdentifierFromString(
    allocator: Option<&CFAllocator>,
    locale_identifier: Option<&CFString>,
) -> Option<CFRetained<CFLocaleIdentifier>> {
    extern "C-unwind" {
        fn CFLocaleCreateCanonicalLanguageIdentifierFromString(
            allocator: Option<&CFAllocator>,
            locale_identifier: Option<&CFString>,
        ) -> Option<NonNull<CFLocaleIdentifier>>;
    }
    let ret = unsafe {
        CFLocaleCreateCanonicalLanguageIdentifierFromString(allocator, locale_identifier)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFLocale::new_canonical_locale_identifier_from_string`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCreateCanonicalLocaleIdentifierFromString(
    allocator: Option<&CFAllocator>,
    locale_identifier: Option<&CFString>,
) -> Option<CFRetained<CFLocaleIdentifier>> {
    extern "C-unwind" {
        fn CFLocaleCreateCanonicalLocaleIdentifierFromString(
            allocator: Option<&CFAllocator>,
            locale_identifier: Option<&CFString>,
        ) -> Option<NonNull<CFLocaleIdentifier>>;
    }
    let ret =
        unsafe { CFLocaleCreateCanonicalLocaleIdentifierFromString(allocator, locale_identifier) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFLocale::new_canonical_locale_identifier_from_script_manager_codes`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCreateCanonicalLocaleIdentifierFromScriptManagerCodes(
    allocator: Option<&CFAllocator>,
    lcode: LangCode,
    rcode: RegionCode,
) -> Option<CFRetained<CFLocaleIdentifier>> {
    extern "C-unwind" {
        fn CFLocaleCreateCanonicalLocaleIdentifierFromScriptManagerCodes(
            allocator: Option<&CFAllocator>,
            lcode: LangCode,
            rcode: RegionCode,
        ) -> Option<NonNull<CFLocaleIdentifier>>;
    }
    let ret = unsafe {
        CFLocaleCreateCanonicalLocaleIdentifierFromScriptManagerCodes(allocator, lcode, rcode)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFLocale::new_locale_identifier_from_windows_locale_code`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCreateLocaleIdentifierFromWindowsLocaleCode(
    allocator: Option<&CFAllocator>,
    lcid: u32,
) -> Option<CFRetained<CFLocaleIdentifier>> {
    extern "C-unwind" {
        fn CFLocaleCreateLocaleIdentifierFromWindowsLocaleCode(
            allocator: Option<&CFAllocator>,
            lcid: u32,
        ) -> Option<NonNull<CFLocaleIdentifier>>;
    }
    let ret = unsafe { CFLocaleCreateLocaleIdentifierFromWindowsLocaleCode(allocator, lcid) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFLocale::windows_locale_code_from_locale_identifier`"]
#[inline]
pub extern "C-unwind" fn CFLocaleGetWindowsLocaleCodeFromLocaleIdentifier(
    locale_identifier: Option<&CFLocaleIdentifier>,
) -> u32 {
    extern "C-unwind" {
        fn CFLocaleGetWindowsLocaleCodeFromLocaleIdentifier(
            locale_identifier: Option<&CFLocaleIdentifier>,
        ) -> u32;
    }
    unsafe { CFLocaleGetWindowsLocaleCodeFromLocaleIdentifier(locale_identifier) }
}

#[deprecated = "renamed to `CFLocale::language_character_direction`"]
#[inline]
pub extern "C-unwind" fn CFLocaleGetLanguageCharacterDirection(
    iso_lang_code: Option<&CFString>,
) -> CFLocaleLanguageDirection {
    extern "C-unwind" {
        fn CFLocaleGetLanguageCharacterDirection(
            iso_lang_code: Option<&CFString>,
        ) -> CFLocaleLanguageDirection;
    }
    unsafe { CFLocaleGetLanguageCharacterDirection(iso_lang_code) }
}

#[deprecated = "renamed to `CFLocale::language_line_direction`"]
#[inline]
pub extern "C-unwind" fn CFLocaleGetLanguageLineDirection(
    iso_lang_code: Option<&CFString>,
) -> CFLocaleLanguageDirection {
    extern "C-unwind" {
        fn CFLocaleGetLanguageLineDirection(
            iso_lang_code: Option<&CFString>,
        ) -> CFLocaleLanguageDirection;
    }
    unsafe { CFLocaleGetLanguageLineDirection(iso_lang_code) }
}

#[cfg(feature = "CFDictionary")]
#[deprecated = "renamed to `CFLocale::new_components_from_locale_identifier`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCreateComponentsFromLocaleIdentifier(
    allocator: Option<&CFAllocator>,
    locale_id: Option<&CFLocaleIdentifier>,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CFLocaleCreateComponentsFromLocaleIdentifier(
            allocator: Option<&CFAllocator>,
            locale_id: Option<&CFLocaleIdentifier>,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CFLocaleCreateComponentsFromLocaleIdentifier(allocator, locale_id) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFDictionary")]
#[deprecated = "renamed to `CFLocale::new_locale_identifier_from_components`"]
#[inline]
pub unsafe extern "C-unwind" fn CFLocaleCreateLocaleIdentifierFromComponents(
    allocator: Option<&CFAllocator>,
    dictionary: Option<&CFDictionary>,
) -> Option<CFRetained<CFLocaleIdentifier>> {
    extern "C-unwind" {
        fn CFLocaleCreateLocaleIdentifierFromComponents(
            allocator: Option<&CFAllocator>,
            dictionary: Option<&CFDictionary>,
        ) -> Option<NonNull<CFLocaleIdentifier>>;
    }
    let ret = unsafe { CFLocaleCreateLocaleIdentifierFromComponents(allocator, dictionary) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFLocale::new`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCreate(
    allocator: Option<&CFAllocator>,
    locale_identifier: Option<&CFLocaleIdentifier>,
) -> Option<CFRetained<CFLocale>> {
    extern "C-unwind" {
        fn CFLocaleCreate(
            allocator: Option<&CFAllocator>,
            locale_identifier: Option<&CFLocaleIdentifier>,
        ) -> Option<NonNull<CFLocale>>;
    }
    let ret = unsafe { CFLocaleCreate(allocator, locale_identifier) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFLocale::new_copy`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCreateCopy(
    allocator: Option<&CFAllocator>,
    locale: Option<&CFLocale>,
) -> Option<CFRetained<CFLocale>> {
    extern "C-unwind" {
        fn CFLocaleCreateCopy(
            allocator: Option<&CFAllocator>,
            locale: Option<&CFLocale>,
        ) -> Option<NonNull<CFLocale>>;
    }
    let ret = unsafe { CFLocaleCreateCopy(allocator, locale) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[deprecated = "renamed to `CFLocale::identifier`"]
#[inline]
pub extern "C-unwind" fn CFLocaleGetIdentifier(
    locale: &CFLocale,
) -> Option<CFRetained<CFLocaleIdentifier>> {
    extern "C-unwind" {
        fn CFLocaleGetIdentifier(locale: &CFLocale) -> Option<NonNull<CFLocaleIdentifier>>;
    }
    let ret = unsafe { CFLocaleGetIdentifier(locale) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFLocale::value`"]
#[inline]
pub extern "C-unwind" fn CFLocaleGetValue(
    locale: &CFLocale,
    key: Option<&CFLocaleKey>,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CFLocaleGetValue(
            locale: &CFLocale,
            key: Option<&CFLocaleKey>,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe { CFLocaleGetValue(locale, key) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[deprecated = "renamed to `CFLocale::display_name_for_property_value`"]
#[inline]
pub extern "C-unwind" fn CFLocaleCopyDisplayNameForPropertyValue(
    display_locale: &CFLocale,
    key: Option<&CFLocaleKey>,
    value: Option<&CFString>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFLocaleCopyDisplayNameForPropertyValue(
            display_locale: &CFLocale,
            key: Option<&CFLocaleKey>,
            value: Option<&CFString>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFLocaleCopyDisplayNameForPropertyValue(display_locale, key, value) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}
