## RabbitMQ 3.7.24

RabbitMQ `3.7.24` is a maintenance release.
RabbitMQ `3.7.x` series is supported [through March 2020](https://www.rabbitmq.com/versions.html).

### Erlang/OTP Compatibility Notes

Per the new Erlang version support policy in effect starting with January 2019,
this release [**no longer supports Erlang/OTP 20.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release **and upgrading Erlang to 21.x or later** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Bug Fixes

 * Autoheal could fail to finish if one of its state transitions initiated by a remote node timed out.

   Contributed by @tomyouyou.

   GitHub issue: [rabbitmq/rabbitmq-server#2209](https://github.com/rabbitmq/rabbitmq-server/pull/2209)

 * Reduced scheduled GC activity in connection socket writer to one run per 1 GiB of data transferred,
   with an option to change the value or disable scheduled run entirely. More frequent binary heap GC runs seem
   unneccesary on Erlang 22.

   Contributed by Aleksander Nycz.

   GitHub issue: [rabbitmq/rabbitmq-common#343](https://github.com/rabbitmq/rabbitmq-common/pull/343)

 * The node now can recover even if virtual host recovery terms file was corrupted.

   Contributed by @tomyouyou.

   GitHub issue: [rabbitmq/rabbitmq-server#2195](https://github.com/rabbitmq/rabbitmq-server/pull/2195)

 * Better error reporting in an edge case with classic queue leader replica election.

   Contributed by Ayanda Dube.

   GitHub issue: [rabbitmq/rabbitmq-common#355](https://github.com/rabbitmq/rabbitmq-common/pull/355)

 * Fixed an incorrect return value in the internal queue data store module.

   Contributed by Sergey Loguntsov.

   GitHub issue: [rabbitmq/rabbitmq-server#2221](https://github.com/rabbitmq/rabbitmq-server/pull/2221)

 * Syslog client is now started even when Syslog logging is configured only for some log sinks.

   GitHub issue: [rabbitmq/rabbitmq-server#2044](https://github.com/rabbitmq/rabbitmq-server/issues/2044)

#### Enhancements

 * RabbitMQ nodes will now gracefully shutdown when receiving a `SIGTERM` or `SIGQUIT` signals.
   Previously the runtime would invoke a default handler that terminates the VM giving
   RabbitMQ no chance to execute its shutdown steps.

   In addition, `SIGUSER1` and `SIGUSR2` signals are ignored.

   GitHub issue: [rabbitmq/rabbitmq-server#2222](https://github.com/rabbitmq/rabbitmq-server/issues/2222)

 * Some proxy protocol errors are now logged at debug level. This reduces log noise in environments
   where TCP load balancers and proxies perform health checks by opening a TCP connection but never sending
   any data.

   GitHub issue: [rabbitmq/rabbitmq-server#2204](https://github.com/rabbitmq/rabbitmq-server/pull/2204)


### Management and Management Agent Plugins

### Enhancements

 * A new `POST /login` endpoint can be used by custom management UI login forms to authenticate the user
   and set the cookie.

   GitHub issue: [rabbitmq/rabbitmq-management#764](https://github.com/rabbitmq/rabbitmq-management/issues/764)

 * Warning about a missing `handle.exe` in `PATH` on Windows is now only logged every few minutes.

   GitHub issue: [rabbitmq/rabbitmq-management-agent#90](https://github.com/rabbitmq/rabbitmq-management-agent/issues/90)



## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.7.24.tar.xz`.
