/* automatically generated by rust-bindgen 0.69.4 */

pub const MYSQL_AUTODETECT_CHARSET_NAME: &[u8; 5] = b"auto\0";
pub const MYSQL_ERRMSG_SIZE: u32 = 512;
pub const MYSQL_STMT_HEADER: u32 = 4;
pub const MYSQL_LONG_DATA_HEADER: u32 = 6;
pub const MYSQL_CLIENT_reserved1: u32 = 0;
pub const MYSQL_CLIENT_reserved2: u32 = 1;
pub const MYSQL_CLIENT_AUTHENTICATION_PLUGIN: u32 = 2;
pub const MYSQL_CLIENT_TRACE_PLUGIN: u32 = 3;
pub const MYSQL_CLIENT_AUTHENTICATION_PLUGIN_INTERFACE_VERSION: u32 = 512;
pub const MYSQL_CLIENT_TRACE_PLUGIN_INTERFACE_VERSION: u32 = 512;
pub const MYSQL_CLIENT_MAX_PLUGINS: u32 = 4;
pub const MYSQL_CLIENT_PLUGIN_AUTHOR_ORACLE: &[u8; 19] = b"Oracle Corporation\0";
pub const MYSQL_USERNAME_LENGTH: u32 = 96;
pub const MYSQL_SERVER_VERSION: &[u8; 7] = b"8.0.35\0";
pub const MYSQL_BASE_VERSION: &[u8; 11] = b"mysqld-8.0\0";
pub const MYSQL_SERVER_SUFFIX_DEF: &[u8; 1] = b"\0";
pub const MYSQL_VERSION_ID: u32 = 80035;
pub const MYSQL_VERSION_STABILITY: &[u8; 4] = b"LTS\0";
pub const MYSQL_PORT: u32 = 3306;
pub const MYSQL_ADMIN_PORT: u32 = 33062;
pub const MYSQL_PORT_DEFAULT: u32 = 0;
pub const MYSQL_UNIX_ADDR: &[u8; 16] = b"/tmp/mysql.sock\0";
pub const MYSQL_CONFIG_NAME: &[u8; 3] = b"my\0";
pub const MYSQL_PERSIST_CONFIG_NAME: &[u8; 12] = b"mysqld-auto\0";
pub const MYSQL_COMPILATION_COMMENT: &[u8; 20] = b"Source distribution\0";
pub const MYSQL_COMPILATION_COMMENT_SERVER: &[u8; 20] = b"Source distribution\0";
pub const MYSQL_RPL_GTID: u32 = 65536;
pub const MYSQL_RPL_SKIP_HEARTBEAT: u32 = 131072;
pub const MYSQL_NO_DATA: u32 = 100;
pub const MYSQL_DATA_TRUNCATED: u32 = 101;
pub type __va_list = __builtin_va_list;
pub type my_socket = ::std::os::raw::c_int;
#[repr(u32)]
#[non_exhaustive]
#[doc = "Column types for MySQL"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_field_types {
    MYSQL_TYPE_DECIMAL = 0,
    MYSQL_TYPE_TINY = 1,
    MYSQL_TYPE_SHORT = 2,
    MYSQL_TYPE_LONG = 3,
    MYSQL_TYPE_FLOAT = 4,
    MYSQL_TYPE_DOUBLE = 5,
    MYSQL_TYPE_NULL = 6,
    MYSQL_TYPE_TIMESTAMP = 7,
    MYSQL_TYPE_LONGLONG = 8,
    MYSQL_TYPE_INT24 = 9,
    MYSQL_TYPE_DATE = 10,
    MYSQL_TYPE_TIME = 11,
    MYSQL_TYPE_DATETIME = 12,
    MYSQL_TYPE_YEAR = 13,
    #[doc = "< Internal to MySQL. Not used in protocol"]
    MYSQL_TYPE_NEWDATE = 14,
    MYSQL_TYPE_VARCHAR = 15,
    MYSQL_TYPE_BIT = 16,
    MYSQL_TYPE_TIMESTAMP2 = 17,
    #[doc = "< Internal to MySQL. Not used in protocol"]
    MYSQL_TYPE_DATETIME2 = 18,
    #[doc = "< Internal to MySQL. Not used in protocol"]
    MYSQL_TYPE_TIME2 = 19,
    #[doc = "< Used for replication only"]
    MYSQL_TYPE_TYPED_ARRAY = 20,
    MYSQL_TYPE_INVALID = 243,
    #[doc = "< Currently just a placeholder"]
    MYSQL_TYPE_BOOL = 244,
    MYSQL_TYPE_JSON = 245,
    MYSQL_TYPE_NEWDECIMAL = 246,
    MYSQL_TYPE_ENUM = 247,
    MYSQL_TYPE_SET = 248,
    MYSQL_TYPE_TINY_BLOB = 249,
    MYSQL_TYPE_MEDIUM_BLOB = 250,
    MYSQL_TYPE_LONG_BLOB = 251,
    MYSQL_TYPE_BLOB = 252,
    MYSQL_TYPE_VAR_STRING = 253,
    MYSQL_TYPE_STRING = 254,
    MYSQL_TYPE_GEOMETRY = 255,
}
#[doc = "@file include/my_list.h"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct LIST {
    pub prev: *mut LIST,
    pub next: *mut LIST,
    pub data: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_LIST() {
    const UNINIT: ::std::mem::MaybeUninit<LIST> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<LIST>(),
        24usize,
        concat!("Size of: ", stringify!(LIST))
    );
    assert_eq!(
        ::std::mem::align_of::<LIST>(),
        8usize,
        concat!("Alignment of ", stringify!(LIST))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).prev) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(LIST),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(LIST),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(LIST),
            "::",
            stringify!(data)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_compression_algorithm {
    MYSQL_UNCOMPRESSED = 1,
    MYSQL_ZLIB = 2,
    MYSQL_ZSTD = 3,
    MYSQL_INVALID = 4,
}
#[doc = "Compress context information. relating to zlib compression."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mysql_zlib_compress_context {
    #[doc = "Compression level to use in zlib compression."]
    pub compression_level: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_mysql_zlib_compress_context() {
    const UNINIT: ::std::mem::MaybeUninit<mysql_zlib_compress_context> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<mysql_zlib_compress_context>(),
        4usize,
        concat!("Size of: ", stringify!(mysql_zlib_compress_context))
    );
    assert_eq!(
        ::std::mem::align_of::<mysql_zlib_compress_context>(),
        4usize,
        concat!("Alignment of ", stringify!(mysql_zlib_compress_context))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compression_level) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mysql_zlib_compress_context),
            "::",
            stringify!(compression_level)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_CCtx_s {
    _unused: [u8; 0],
}
pub type ZSTD_CCtx = ZSTD_CCtx_s;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ZSTD_DCtx_s {
    _unused: [u8; 0],
}
pub type ZSTD_DCtx = ZSTD_DCtx_s;
#[doc = "Compress context information relating to zstd compression."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mysql_zstd_compress_context {
    #[doc = "Pointer to compressor context."]
    pub cctx: *mut ZSTD_CCtx,
    #[doc = "Pointer to decompressor context."]
    pub dctx: *mut ZSTD_DCtx,
    #[doc = "Compression level to use in zstd compression."]
    pub compression_level: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_mysql_zstd_compress_context() {
    const UNINIT: ::std::mem::MaybeUninit<mysql_zstd_compress_context> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<mysql_zstd_compress_context>(),
        24usize,
        concat!("Size of: ", stringify!(mysql_zstd_compress_context))
    );
    assert_eq!(
        ::std::mem::align_of::<mysql_zstd_compress_context>(),
        8usize,
        concat!("Alignment of ", stringify!(mysql_zstd_compress_context))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).cctx) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mysql_zstd_compress_context),
            "::",
            stringify!(cctx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dctx) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mysql_zstd_compress_context),
            "::",
            stringify!(dctx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compression_level) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(mysql_zstd_compress_context),
            "::",
            stringify!(compression_level)
        )
    );
}
#[doc = "Compression context information.\nIt encapsulate the context information based on compression method and\npresents a generic struct."]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct mysql_compress_context {
    #[doc = "< Compression algorithm name."]
    pub algorithm: enum_compression_algorithm,
    pub u: mysql_compress_context__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union mysql_compress_context__bindgen_ty_1 {
    #[doc = "< Context information of zlib."]
    pub zlib_ctx: mysql_zlib_compress_context,
    #[doc = "< Context information of zstd."]
    pub zstd_ctx: mysql_zstd_compress_context,
}
#[test]
fn bindgen_test_layout_mysql_compress_context__bindgen_ty_1() {
    const UNINIT: ::std::mem::MaybeUninit<mysql_compress_context__bindgen_ty_1> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<mysql_compress_context__bindgen_ty_1>(),
        24usize,
        concat!(
            "Size of: ",
            stringify!(mysql_compress_context__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<mysql_compress_context__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(mysql_compress_context__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).zlib_ctx) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mysql_compress_context__bindgen_ty_1),
            "::",
            stringify!(zlib_ctx)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).zstd_ctx) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mysql_compress_context__bindgen_ty_1),
            "::",
            stringify!(zstd_ctx)
        )
    );
}
#[test]
fn bindgen_test_layout_mysql_compress_context() {
    const UNINIT: ::std::mem::MaybeUninit<mysql_compress_context> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<mysql_compress_context>(),
        32usize,
        concat!("Size of: ", stringify!(mysql_compress_context))
    );
    assert_eq!(
        ::std::mem::align_of::<mysql_compress_context>(),
        8usize,
        concat!("Alignment of ", stringify!(mysql_compress_context))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).algorithm) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mysql_compress_context),
            "::",
            stringify!(algorithm)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).u) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(mysql_compress_context),
            "::",
            stringify!(u)
        )
    );
}
extern "C" {
    #[doc = "Get default compression level corresponding to a given compression method.\n\n@param algorithm Compression Method. Possible values are zlib or zstd.\n\n@return an unsigned int representing default compression level.\n6 is the default compression level for zlib and 3 is the\ndefault compression level for zstd."]
    pub fn mysql_default_compression_level(
        algorithm: enum_compression_algorithm,
    ) -> ::std::os::raw::c_uint;
}
extern "C" {
    #[doc = "Initialize a compress context object to be associated with a NET object.\n\n@param cmp_ctx Pointer to compression context.\n@param algorithm Compression algorithm.\n@param compression_level Compression level corresponding to the compression\nalgorithm."]
    pub fn mysql_compress_context_init(
        cmp_ctx: *mut mysql_compress_context,
        algorithm: enum_compression_algorithm,
        compression_level: ::std::os::raw::c_uint,
    );
}
extern "C" {
    #[doc = "Deinitialize the compression context allocated.\n\n@param mysql_compress_ctx Pointer to Compression context."]
    pub fn mysql_compress_context_deinit(mysql_compress_ctx: *mut mysql_compress_context);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Vio {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct NET {
    pub vio: *mut Vio,
    pub buff: *mut ::std::os::raw::c_uchar,
    pub buff_end: *mut ::std::os::raw::c_uchar,
    pub write_pos: *mut ::std::os::raw::c_uchar,
    pub read_pos: *mut ::std::os::raw::c_uchar,
    pub fd: my_socket,
    #[doc = "Set if we are doing several queries in one\ncommand ( as in LOAD TABLE ... FROM MASTER ),\nand do not want to confuse the client with OK at the wrong time"]
    pub remain_in_buf: ::std::os::raw::c_ulong,
    #[doc = "Set if we are doing several queries in one\ncommand ( as in LOAD TABLE ... FROM MASTER ),\nand do not want to confuse the client with OK at the wrong time"]
    pub length: ::std::os::raw::c_ulong,
    #[doc = "Set if we are doing several queries in one\ncommand ( as in LOAD TABLE ... FROM MASTER ),\nand do not want to confuse the client with OK at the wrong time"]
    pub buf_length: ::std::os::raw::c_ulong,
    #[doc = "Set if we are doing several queries in one\ncommand ( as in LOAD TABLE ... FROM MASTER ),\nand do not want to confuse the client with OK at the wrong time"]
    pub where_b: ::std::os::raw::c_ulong,
    pub max_packet: ::std::os::raw::c_ulong,
    pub max_packet_size: ::std::os::raw::c_ulong,
    pub pkt_nr: ::std::os::raw::c_uint,
    pub compress_pkt_nr: ::std::os::raw::c_uint,
    pub write_timeout: ::std::os::raw::c_uint,
    pub read_timeout: ::std::os::raw::c_uint,
    pub retry_count: ::std::os::raw::c_uint,
    pub fcntl: ::std::os::raw::c_int,
    pub return_status: *mut ::std::os::raw::c_uint,
    pub reading_or_writing: ::std::os::raw::c_uchar,
    pub save_char: ::std::os::raw::c_uchar,
    pub compress: bool,
    pub last_errno: ::std::os::raw::c_uint,
    pub error: ::std::os::raw::c_uchar,
    #[doc = " Client library error message buffer. Actually belongs to struct MYSQL."]
    pub last_error: [::std::os::raw::c_char; 512usize],
    #[doc = " Client library sqlstate buffer. Set along with the error message."]
    pub sqlstate: [::std::os::raw::c_char; 6usize],
    #[doc = "Extension pointer, for the caller private use.\nAny program linking with the networking library can use this pointer,\nwhich is handy when private connection specific data needs to be\nmaintained.\nThe mysqld server process uses this pointer internally,\nto maintain the server internal instrumentation for the connection."]
    pub extension: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_NET() {
    const UNINIT: ::std::mem::MaybeUninit<NET> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<NET>(),
        664usize,
        concat!("Size of: ", stringify!(NET))
    );
    assert_eq!(
        ::std::mem::align_of::<NET>(),
        8usize,
        concat!("Alignment of ", stringify!(NET))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).vio) as usize - ptr as usize },
        0usize,
        concat!("Offset of field: ", stringify!(NET), "::", stringify!(vio))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buff) as usize - ptr as usize },
        8usize,
        concat!("Offset of field: ", stringify!(NET), "::", stringify!(buff))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buff_end) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(buff_end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_pos) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(write_pos)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read_pos) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(read_pos)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fd) as usize - ptr as usize },
        40usize,
        concat!("Offset of field: ", stringify!(NET), "::", stringify!(fd))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).remain_in_buf) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(remain_in_buf)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).length) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buf_length) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(buf_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).where_b) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(where_b)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_packet) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(max_packet)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_packet_size) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(max_packet_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pkt_nr) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(pkt_nr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compress_pkt_nr) as usize - ptr as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(compress_pkt_nr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_timeout) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(write_timeout)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read_timeout) as usize - ptr as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(read_timeout)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).retry_count) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(retry_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fcntl) as usize - ptr as usize },
        116usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(fcntl)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).return_status) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(return_status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reading_or_writing) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(reading_or_writing)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).save_char) as usize - ptr as usize },
        129usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(save_char)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compress) as usize - ptr as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(compress)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_errno) as usize - ptr as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(last_errno)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).error) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(error)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_error) as usize - ptr as usize },
        137usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(last_error)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sqlstate) as usize - ptr as usize },
        649usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(sqlstate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extension) as usize - ptr as usize },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(NET),
            "::",
            stringify!(extension)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[doc = "We want levels to be in growing order of hardness (because we use number\ncomparisons).\n\n@note ::SHUTDOWN_DEFAULT does not respect the growing property, but it's ok."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_enum_shutdown_level {
    SHUTDOWN_DEFAULT = 0,
    #[doc = " Wait for existing connections to finish"]
    SHUTDOWN_WAIT_CONNECTIONS = 1,
    #[doc = " Wait for existing transactons to finish"]
    SHUTDOWN_WAIT_TRANSACTIONS = 2,
    #[doc = " Wait for existing updates to finish (=> no partial MyISAM update)"]
    SHUTDOWN_WAIT_UPDATES = 8,
    #[doc = " Flush InnoDB buffers and other storage engines' buffers"]
    SHUTDOWN_WAIT_ALL_BUFFERS = 16,
    #[doc = " Don't flush InnoDB buffers, flush other storage engines' buffers"]
    SHUTDOWN_WAIT_CRITICAL_BUFFERS = 17,
    #[doc = " Query level of the KILL command"]
    KILL_QUERY = 254,
    #[doc = " Connection level of the KILL command"]
    KILL_CONNECTION = 255,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " @}"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_resultset_metadata {
    #[doc = " No metadata will be sent."]
    RESULTSET_METADATA_NONE = 0,
    #[doc = " The server will send all metadata."]
    RESULTSET_METADATA_FULL = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = " options for ::mysql_options()"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_mysql_set_option {
    MYSQL_OPTION_MULTI_STATEMENTS_ON = 0,
    MYSQL_OPTION_MULTI_STATEMENTS_OFF = 1,
}
#[repr(u32)]
#[non_exhaustive]
#[doc = "Type of state change information that the server can include in the Ok\npacket.\n\n@note\n- session_state_type shouldn't go past 255 (i.e. 1-byte boundary).\n- Modify the definition of ::SESSION_TRACK_END when a new member is added."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_session_state_type {
    #[doc = "< Session system variables"]
    SESSION_TRACK_SYSTEM_VARIABLES = 0,
    #[doc = "< Current schema"]
    SESSION_TRACK_SCHEMA = 1,
    #[doc = "< track session state changes"]
    SESSION_TRACK_STATE_CHANGE = 2,
    #[doc = "< See also: session_track_gtids"]
    SESSION_TRACK_GTIDS = 3,
    #[doc = "< Transaction chistics"]
    SESSION_TRACK_TRANSACTION_CHARACTERISTICS = 4,
    #[doc = "< Transaction state"]
    SESSION_TRACK_TRANSACTION_STATE = 5,
}
extern "C" {
    pub fn mysql_errno_to_sqlstate(
        mysql_errno: ::std::os::raw::c_uint,
    ) -> *const ::std::os::raw::c_char;
}
pub type va_list = __va_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_client_plugin {
    pub type_: ::std::os::raw::c_int,
    pub interface_version: ::std::os::raw::c_uint,
    pub name: *const ::std::os::raw::c_char,
    pub author: *const ::std::os::raw::c_char,
    pub desc: *const ::std::os::raw::c_char,
    pub version: [::std::os::raw::c_uint; 3usize],
    pub license: *const ::std::os::raw::c_char,
    pub mysql_api: *mut ::std::os::raw::c_void,
    pub init: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_char,
            arg2: usize,
            arg3: ::std::os::raw::c_int,
            arg4: va_list,
        ) -> ::std::os::raw::c_int,
    >,
    pub deinit: ::std::option::Option<unsafe extern "C" fn() -> ::std::os::raw::c_int>,
    pub options: ::std::option::Option<
        unsafe extern "C" fn(
            option: *const ::std::os::raw::c_char,
            arg1: *const ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub get_options: ::std::option::Option<
        unsafe extern "C" fn(
            option: *const ::std::os::raw::c_char,
            arg1: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
}
#[test]
fn bindgen_test_layout_st_mysql_client_plugin() {
    const UNINIT: ::std::mem::MaybeUninit<st_mysql_client_plugin> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<st_mysql_client_plugin>(),
        96usize,
        concat!("Size of: ", stringify!(st_mysql_client_plugin))
    );
    assert_eq!(
        ::std::mem::align_of::<st_mysql_client_plugin>(),
        8usize,
        concat!("Alignment of ", stringify!(st_mysql_client_plugin))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_client_plugin),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).interface_version) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_client_plugin),
            "::",
            stringify!(interface_version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_client_plugin),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).author) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_client_plugin),
            "::",
            stringify!(author)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).desc) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_client_plugin),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).version) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_client_plugin),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).license) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_client_plugin),
            "::",
            stringify!(license)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mysql_api) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_client_plugin),
            "::",
            stringify!(mysql_api)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).init) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_client_plugin),
            "::",
            stringify!(init)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).deinit) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_client_plugin),
            "::",
            stringify!(deinit)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).options) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_client_plugin),
            "::",
            stringify!(options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).get_options) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_client_plugin),
            "::",
            stringify!(get_options)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_PLUGIN_VIO_INFO {
    pub protocol: MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1,
    #[doc = "< it's set, if the protocol is SOCKET or TCP"]
    pub socket: ::std::os::raw::c_int,
}
pub const MYSQL_PLUGIN_VIO_INFO_MYSQL_VIO_INVALID: MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1 =
    MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1::MYSQL_VIO_INVALID;
pub const MYSQL_PLUGIN_VIO_INFO_MYSQL_VIO_TCP: MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1 =
    MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1::MYSQL_VIO_TCP;
pub const MYSQL_PLUGIN_VIO_INFO_MYSQL_VIO_SOCKET: MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1 =
    MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1::MYSQL_VIO_SOCKET;
pub const MYSQL_PLUGIN_VIO_INFO_MYSQL_VIO_PIPE: MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1 =
    MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1::MYSQL_VIO_PIPE;
pub const MYSQL_PLUGIN_VIO_INFO_MYSQL_VIO_MEMORY: MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1 =
    MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1::MYSQL_VIO_MEMORY;
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum MYSQL_PLUGIN_VIO_INFO__bindgen_ty_1 {
    MYSQL_VIO_INVALID = 0,
    MYSQL_VIO_TCP = 1,
    MYSQL_VIO_SOCKET = 2,
    MYSQL_VIO_PIPE = 3,
    MYSQL_VIO_MEMORY = 4,
}
#[test]
fn bindgen_test_layout_MYSQL_PLUGIN_VIO_INFO() {
    const UNINIT: ::std::mem::MaybeUninit<MYSQL_PLUGIN_VIO_INFO> =
        ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<MYSQL_PLUGIN_VIO_INFO>(),
        8usize,
        concat!("Size of: ", stringify!(MYSQL_PLUGIN_VIO_INFO))
    );
    assert_eq!(
        ::std::mem::align_of::<MYSQL_PLUGIN_VIO_INFO>(),
        4usize,
        concat!("Alignment of ", stringify!(MYSQL_PLUGIN_VIO_INFO))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).protocol) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_PLUGIN_VIO_INFO),
            "::",
            stringify!(protocol)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).socket) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_PLUGIN_VIO_INFO),
            "::",
            stringify!(socket)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum net_async_status {
    NET_ASYNC_COMPLETE = 0,
    NET_ASYNC_NOT_READY = 1,
    NET_ASYNC_ERROR = 2,
    NET_ASYNC_COMPLETE_NO_MORE_RESULTS = 3,
}
#[doc = "Provides plugin access to communication channel"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_PLUGIN_VIO {
    #[doc = "Plugin provides a pointer reference and this function sets it to the\ncontents of any incoming packet. Returns the packet length, or -1 if\nthe plugin should terminate."]
    pub read_packet: ::std::option::Option<
        unsafe extern "C" fn(
            vio: *mut MYSQL_PLUGIN_VIO,
            buf: *mut *mut ::std::os::raw::c_uchar,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "Plugin provides a buffer with data and the length and this\nfunction sends it as a packet. Returns 0 on success, 1 on failure."]
    pub write_packet: ::std::option::Option<
        unsafe extern "C" fn(
            vio: *mut MYSQL_PLUGIN_VIO,
            packet: *const ::std::os::raw::c_uchar,
            packet_len: ::std::os::raw::c_int,
        ) -> ::std::os::raw::c_int,
    >,
    #[doc = "Fills in a MYSQL_PLUGIN_VIO_INFO structure, providing the information\nabout the connection."]
    pub info: ::std::option::Option<
        unsafe extern "C" fn(vio: *mut MYSQL_PLUGIN_VIO, info: *mut MYSQL_PLUGIN_VIO_INFO),
    >,
    #[doc = "Non blocking version of read_packet. This function points buf to starting\nposition of incoming packet. When this function returns NET_ASYNC_NOT_READY\nplugin should call this function again until all incoming packets are read.\nIf return code is NET_ASYNC_COMPLETE, plugin can do further processing of\nread packets."]
    pub read_packet_nonblocking: ::std::option::Option<
        unsafe extern "C" fn(
            vio: *mut MYSQL_PLUGIN_VIO,
            buf: *mut *mut ::std::os::raw::c_uchar,
            result: *mut ::std::os::raw::c_int,
        ) -> net_async_status,
    >,
    #[doc = "Non blocking version of write_packet. Sends data available in pkt of length\npkt_len to server in asynchronous way."]
    pub write_packet_nonblocking: ::std::option::Option<
        unsafe extern "C" fn(
            vio: *mut MYSQL_PLUGIN_VIO,
            pkt: *const ::std::os::raw::c_uchar,
            pkt_len: ::std::os::raw::c_int,
            result: *mut ::std::os::raw::c_int,
        ) -> net_async_status,
    >,
}
#[test]
fn bindgen_test_layout_MYSQL_PLUGIN_VIO() {
    const UNINIT: ::std::mem::MaybeUninit<MYSQL_PLUGIN_VIO> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<MYSQL_PLUGIN_VIO>(),
        40usize,
        concat!("Size of: ", stringify!(MYSQL_PLUGIN_VIO))
    );
    assert_eq!(
        ::std::mem::align_of::<MYSQL_PLUGIN_VIO>(),
        8usize,
        concat!("Alignment of ", stringify!(MYSQL_PLUGIN_VIO))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read_packet) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_PLUGIN_VIO),
            "::",
            stringify!(read_packet)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_packet) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_PLUGIN_VIO),
            "::",
            stringify!(write_packet)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).info) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_PLUGIN_VIO),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read_packet_nonblocking) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_PLUGIN_VIO),
            "::",
            stringify!(read_packet_nonblocking)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_packet_nonblocking) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_PLUGIN_VIO),
            "::",
            stringify!(write_packet_nonblocking)
        )
    );
}
extern "C" {
    #[doc = "loads a plugin and initializes it\n\n@param mysql  MYSQL structure.\n@param name   a name of the plugin to load\n@param type   type of plugin that should be loaded, -1 to disable type check\n@param argc   number of arguments to pass to the plugin initialization\nfunction\n@param ...    arguments for the plugin initialization function\n\n@retval\na pointer to the loaded plugin, or NULL in case of a failure"]
    pub fn mysql_load_plugin(
        mysql: *mut MYSQL,
        name: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_int,
        argc: ::std::os::raw::c_int,
        ...
    ) -> *mut st_mysql_client_plugin;
}
extern "C" {
    #[doc = "loads a plugin and initializes it, taking va_list as an argument\n\nThis is the same as mysql_load_plugin, but take va_list instead of\na list of arguments.\n\n@param mysql  MYSQL structure.\n@param name   a name of the plugin to load\n@param type   type of plugin that should be loaded, -1 to disable type check\n@param argc   number of arguments to pass to the plugin initialization\nfunction\n@param args   arguments for the plugin initialization function\n\n@retval\na pointer to the loaded plugin, or NULL in case of a failure"]
    pub fn mysql_load_plugin_v(
        mysql: *mut MYSQL,
        name: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_int,
        argc: ::std::os::raw::c_int,
        args: va_list,
    ) -> *mut st_mysql_client_plugin;
}
extern "C" {
    #[doc = "finds an already loaded plugin by name, or loads it, if necessary\n\n@param mysql  MYSQL structure.\n@param name   a name of the plugin to load\n@param type   type of plugin that should be loaded\n\n@retval\na pointer to the plugin, or NULL in case of a failure"]
    pub fn mysql_client_find_plugin(
        mysql: *mut MYSQL,
        name: *const ::std::os::raw::c_char,
        type_: ::std::os::raw::c_int,
    ) -> *mut st_mysql_client_plugin;
}
extern "C" {
    #[doc = "adds a plugin structure to the list of loaded plugins\n\nThis is useful if an application has the necessary functionality\n(for example, a special load data handler) statically linked into\nthe application binary. It can use this function to register the plugin\ndirectly, avoiding the need to factor it out into a shared object.\n\n@param mysql  MYSQL structure. It is only used for error reporting\n@param plugin an st_mysql_client_plugin structure to register\n\n@retval\na pointer to the plugin, or NULL in case of a failure"]
    pub fn mysql_client_register_plugin(
        mysql: *mut MYSQL,
        plugin: *mut st_mysql_client_plugin,
    ) -> *mut st_mysql_client_plugin;
}
extern "C" {
    #[doc = "set plugin options\n\nCan be used to set extra options and affect behavior for a plugin.\nThis function may be called multiple times to set several options\n\n@param plugin an st_mysql_client_plugin structure\n@param option a string which specifies the option to set\n@param value  value for the option.\n\n@retval 0 on success, 1 in case of failure"]
    pub fn mysql_plugin_options(
        plugin: *mut st_mysql_client_plugin,
        option: *const ::std::os::raw::c_char,
        value: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "get plugin options\n\nCan be used to get options from a plugin.\nThis function may be called multiple times to get several options\n\n@param plugin an st_mysql_client_plugin structure\n@param option a string which specifies the option to get\n@param[out] value  value for the option.\n\n@retval 0 on success, 1 in case of failure"]
    pub fn mysql_plugin_get_option(
        plugin: *mut st_mysql_client_plugin,
        option: *const ::std::os::raw::c_char,
        value: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
#[repr(i32)]
#[non_exhaustive]
#[doc = "@file include/mysql_time.h\nTime declarations shared between the server and client API:\nyou should not add anything to this header unless it's used\n(and hence should be visible) in mysql.h.\nIf you're looking for a place to add new time-related declaration,\nit's most likely my_time.h. See also \"C API Handling of Date\nand Time Values\" chapter in documentation."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_mysql_timestamp_type {
    MYSQL_TIMESTAMP_NONE = -2,
    MYSQL_TIMESTAMP_ERROR = -1,
    #[doc = " Stores year, month and day components."]
    MYSQL_TIMESTAMP_DATE = 0,
    #[doc = "Stores all date and time components.\nValue is in UTC for `TIMESTAMP` type.\nValue is in local time zone for `DATETIME` type."]
    MYSQL_TIMESTAMP_DATETIME = 1,
    #[doc = " Stores hour, minute, second and microsecond."]
    MYSQL_TIMESTAMP_TIME = 2,
    #[doc = "A temporary type for `DATETIME` or `TIMESTAMP` types equipped with time\nzone information. After the time zone information is reconciled, the type is\nconverted to MYSQL_TIMESTAMP_DATETIME."]
    MYSQL_TIMESTAMP_DATETIME_TZ = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_TIME {
    pub year: ::std::os::raw::c_uint,
    pub month: ::std::os::raw::c_uint,
    pub day: ::std::os::raw::c_uint,
    pub hour: ::std::os::raw::c_uint,
    pub minute: ::std::os::raw::c_uint,
    pub second: ::std::os::raw::c_uint,
    #[doc = "< microseconds"]
    pub second_part: ::std::os::raw::c_ulong,
    pub neg: bool,
    pub time_type: enum_mysql_timestamp_type,
    #[doc = " The time zone displacement, specified in seconds."]
    pub time_zone_displacement: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_MYSQL_TIME() {
    const UNINIT: ::std::mem::MaybeUninit<MYSQL_TIME> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<MYSQL_TIME>(),
        48usize,
        concat!("Size of: ", stringify!(MYSQL_TIME))
    );
    assert_eq!(
        ::std::mem::align_of::<MYSQL_TIME>(),
        8usize,
        concat!("Alignment of ", stringify!(MYSQL_TIME))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).year) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_TIME),
            "::",
            stringify!(year)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).month) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_TIME),
            "::",
            stringify!(month)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).day) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_TIME),
            "::",
            stringify!(day)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).hour) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_TIME),
            "::",
            stringify!(hour)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).minute) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_TIME),
            "::",
            stringify!(minute)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).second) as usize - ptr as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_TIME),
            "::",
            stringify!(second)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).second_part) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_TIME),
            "::",
            stringify!(second_part)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).neg) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_TIME),
            "::",
            stringify!(neg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).time_type) as usize - ptr as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_TIME),
            "::",
            stringify!(time_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).time_zone_displacement) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_TIME),
            "::",
            stringify!(time_zone_displacement)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_FIELD {
    pub name: *mut ::std::os::raw::c_char,
    pub org_name: *mut ::std::os::raw::c_char,
    pub table: *mut ::std::os::raw::c_char,
    pub org_table: *mut ::std::os::raw::c_char,
    pub db: *mut ::std::os::raw::c_char,
    pub catalog: *mut ::std::os::raw::c_char,
    pub def: *mut ::std::os::raw::c_char,
    pub length: ::std::os::raw::c_ulong,
    pub max_length: ::std::os::raw::c_ulong,
    pub name_length: ::std::os::raw::c_uint,
    pub org_name_length: ::std::os::raw::c_uint,
    pub table_length: ::std::os::raw::c_uint,
    pub org_table_length: ::std::os::raw::c_uint,
    pub db_length: ::std::os::raw::c_uint,
    pub catalog_length: ::std::os::raw::c_uint,
    pub def_length: ::std::os::raw::c_uint,
    pub flags: ::std::os::raw::c_uint,
    pub decimals: ::std::os::raw::c_uint,
    pub charsetnr: ::std::os::raw::c_uint,
    pub type_: enum_field_types,
    pub extension: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_MYSQL_FIELD() {
    const UNINIT: ::std::mem::MaybeUninit<MYSQL_FIELD> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<MYSQL_FIELD>(),
        128usize,
        concat!("Size of: ", stringify!(MYSQL_FIELD))
    );
    assert_eq!(
        ::std::mem::align_of::<MYSQL_FIELD>(),
        8usize,
        concat!("Alignment of ", stringify!(MYSQL_FIELD))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).org_name) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(org_name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).table) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(table)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).org_table) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(org_table)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).db) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(db)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).catalog) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(catalog)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).def) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(def)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).length) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_length) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(max_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name_length) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(name_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).org_name_length) as usize - ptr as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(org_name_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).table_length) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(table_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).org_table_length) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(org_table_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).db_length) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(db_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).catalog_length) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(catalog_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).def_length) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(def_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).decimals) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(decimals)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).charsetnr) as usize - ptr as usize },
        108usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(charsetnr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).type_) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extension) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_FIELD),
            "::",
            stringify!(extension)
        )
    );
}
pub type MYSQL_ROW = *mut *mut ::std::os::raw::c_char;
pub type MYSQL_FIELD_OFFSET = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_ROWS {
    pub next: *mut MYSQL_ROWS,
    pub data: MYSQL_ROW,
    pub length: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout_MYSQL_ROWS() {
    const UNINIT: ::std::mem::MaybeUninit<MYSQL_ROWS> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<MYSQL_ROWS>(),
        24usize,
        concat!("Size of: ", stringify!(MYSQL_ROWS))
    );
    assert_eq!(
        ::std::mem::align_of::<MYSQL_ROWS>(),
        8usize,
        concat!("Alignment of ", stringify!(MYSQL_ROWS))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).next) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_ROWS),
            "::",
            stringify!(next)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_ROWS),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).length) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_ROWS),
            "::",
            stringify!(length)
        )
    );
}
pub type MYSQL_ROW_OFFSET = *mut MYSQL_ROWS;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MEM_ROOT {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_DATA {
    pub data: *mut MYSQL_ROWS,
    pub alloc: *mut MEM_ROOT,
    pub rows: u64,
    pub fields: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_MYSQL_DATA() {
    const UNINIT: ::std::mem::MaybeUninit<MYSQL_DATA> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<MYSQL_DATA>(),
        32usize,
        concat!("Size of: ", stringify!(MYSQL_DATA))
    );
    assert_eq!(
        ::std::mem::align_of::<MYSQL_DATA>(),
        8usize,
        concat!("Alignment of ", stringify!(MYSQL_DATA))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_DATA),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).alloc) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_DATA),
            "::",
            stringify!(alloc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).rows) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_DATA),
            "::",
            stringify!(rows)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fields) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_DATA),
            "::",
            stringify!(fields)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_option {
    MYSQL_OPT_CONNECT_TIMEOUT = 0,
    MYSQL_OPT_COMPRESS = 1,
    MYSQL_OPT_NAMED_PIPE = 2,
    MYSQL_INIT_COMMAND = 3,
    MYSQL_READ_DEFAULT_FILE = 4,
    MYSQL_READ_DEFAULT_GROUP = 5,
    MYSQL_SET_CHARSET_DIR = 6,
    MYSQL_SET_CHARSET_NAME = 7,
    MYSQL_OPT_LOCAL_INFILE = 8,
    MYSQL_OPT_PROTOCOL = 9,
    MYSQL_SHARED_MEMORY_BASE_NAME = 10,
    MYSQL_OPT_READ_TIMEOUT = 11,
    MYSQL_OPT_WRITE_TIMEOUT = 12,
    MYSQL_OPT_USE_RESULT = 13,
    MYSQL_REPORT_DATA_TRUNCATION = 14,
    MYSQL_OPT_RECONNECT = 15,
    MYSQL_PLUGIN_DIR = 16,
    MYSQL_DEFAULT_AUTH = 17,
    MYSQL_OPT_BIND = 18,
    MYSQL_OPT_SSL_KEY = 19,
    MYSQL_OPT_SSL_CERT = 20,
    MYSQL_OPT_SSL_CA = 21,
    MYSQL_OPT_SSL_CAPATH = 22,
    MYSQL_OPT_SSL_CIPHER = 23,
    MYSQL_OPT_SSL_CRL = 24,
    MYSQL_OPT_SSL_CRLPATH = 25,
    MYSQL_OPT_CONNECT_ATTR_RESET = 26,
    MYSQL_OPT_CONNECT_ATTR_ADD = 27,
    MYSQL_OPT_CONNECT_ATTR_DELETE = 28,
    MYSQL_SERVER_PUBLIC_KEY = 29,
    MYSQL_ENABLE_CLEARTEXT_PLUGIN = 30,
    MYSQL_OPT_CAN_HANDLE_EXPIRED_PASSWORDS = 31,
    MYSQL_OPT_MAX_ALLOWED_PACKET = 32,
    MYSQL_OPT_NET_BUFFER_LENGTH = 33,
    MYSQL_OPT_TLS_VERSION = 34,
    MYSQL_OPT_SSL_MODE = 35,
    MYSQL_OPT_GET_SERVER_PUBLIC_KEY = 36,
    MYSQL_OPT_RETRY_COUNT = 37,
    MYSQL_OPT_OPTIONAL_RESULTSET_METADATA = 38,
    MYSQL_OPT_SSL_FIPS_MODE = 39,
    MYSQL_OPT_TLS_CIPHERSUITES = 40,
    MYSQL_OPT_COMPRESSION_ALGORITHMS = 41,
    MYSQL_OPT_ZSTD_COMPRESSION_LEVEL = 42,
    MYSQL_OPT_LOAD_DATA_LOCAL_DIR = 43,
    MYSQL_OPT_USER_PASSWORD = 44,
    MYSQL_OPT_SSL_SESSION_DATA = 45,
}
#[doc = "@todo remove the \"extension\", move st_mysql_options completely\nout of mysql.h"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_options_extention {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct st_mysql_options {
    pub connect_timeout: ::std::os::raw::c_uint,
    pub read_timeout: ::std::os::raw::c_uint,
    pub write_timeout: ::std::os::raw::c_uint,
    pub port: ::std::os::raw::c_uint,
    pub protocol: ::std::os::raw::c_uint,
    pub client_flag: ::std::os::raw::c_ulong,
    pub host: *mut ::std::os::raw::c_char,
    pub user: *mut ::std::os::raw::c_char,
    pub password: *mut ::std::os::raw::c_char,
    pub unix_socket: *mut ::std::os::raw::c_char,
    pub db: *mut ::std::os::raw::c_char,
    pub init_commands: *mut Init_commands_array,
    pub my_cnf_file: *mut ::std::os::raw::c_char,
    pub my_cnf_group: *mut ::std::os::raw::c_char,
    pub charset_dir: *mut ::std::os::raw::c_char,
    pub charset_name: *mut ::std::os::raw::c_char,
    pub ssl_key: *mut ::std::os::raw::c_char,
    pub ssl_cert: *mut ::std::os::raw::c_char,
    pub ssl_ca: *mut ::std::os::raw::c_char,
    pub ssl_capath: *mut ::std::os::raw::c_char,
    pub ssl_cipher: *mut ::std::os::raw::c_char,
    pub shared_memory_base_name: *mut ::std::os::raw::c_char,
    pub max_allowed_packet: ::std::os::raw::c_ulong,
    pub compress: bool,
    pub named_pipe: bool,
    #[doc = "The local address to bind when connecting to remote server."]
    pub bind_address: *mut ::std::os::raw::c_char,
    pub report_data_truncation: bool,
    pub local_infile_init: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut *mut ::std::os::raw::c_void,
            arg2: *const ::std::os::raw::c_char,
            arg3: *mut ::std::os::raw::c_void,
        ) -> ::std::os::raw::c_int,
    >,
    pub local_infile_read: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_uint,
        ) -> ::std::os::raw::c_int,
    >,
    pub local_infile_end:
        ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub local_infile_error: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: *mut ::std::os::raw::c_char,
            arg3: ::std::os::raw::c_uint,
        ) -> ::std::os::raw::c_int,
    >,
    pub local_infile_userdata: *mut ::std::os::raw::c_void,
    pub extension: *mut st_mysql_options_extention,
}
#[test]
fn bindgen_test_layout_st_mysql_options() {
    const UNINIT: ::std::mem::MaybeUninit<st_mysql_options> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<st_mysql_options>(),
        240usize,
        concat!("Size of: ", stringify!(st_mysql_options))
    );
    assert_eq!(
        ::std::mem::align_of::<st_mysql_options>(),
        8usize,
        concat!("Alignment of ", stringify!(st_mysql_options))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).connect_timeout) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(connect_timeout)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read_timeout) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(read_timeout)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).write_timeout) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(write_timeout)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).port) as usize - ptr as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).protocol) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(protocol)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).client_flag) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(client_flag)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).host) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(host)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).user) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(user)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).password) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(password)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unix_socket) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(unix_socket)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).db) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(db)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).init_commands) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(init_commands)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).my_cnf_file) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(my_cnf_file)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).my_cnf_group) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(my_cnf_group)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).charset_dir) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(charset_dir)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).charset_name) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(charset_name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ssl_key) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(ssl_key)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ssl_cert) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(ssl_cert)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ssl_ca) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(ssl_ca)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ssl_capath) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(ssl_capath)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).ssl_cipher) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(ssl_cipher)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).shared_memory_base_name) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(shared_memory_base_name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).max_allowed_packet) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(max_allowed_packet)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).compress) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(compress)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).named_pipe) as usize - ptr as usize },
        169usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(named_pipe)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_address) as usize - ptr as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(bind_address)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).report_data_truncation) as usize - ptr as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(report_data_truncation)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).local_infile_init) as usize - ptr as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(local_infile_init)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).local_infile_read) as usize - ptr as usize },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(local_infile_read)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).local_infile_end) as usize - ptr as usize },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(local_infile_end)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).local_infile_error) as usize - ptr as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(local_infile_error)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).local_infile_userdata) as usize - ptr as usize },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(local_infile_userdata)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extension) as usize - ptr as usize },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(st_mysql_options),
            "::",
            stringify!(extension)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_status {
    MYSQL_STATUS_READY = 0,
    MYSQL_STATUS_GET_RESULT = 1,
    MYSQL_STATUS_USE_RESULT = 2,
    MYSQL_STATUS_STATEMENT_GET_RESULT = 3,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_protocol_type {
    MYSQL_PROTOCOL_DEFAULT = 0,
    MYSQL_PROTOCOL_TCP = 1,
    MYSQL_PROTOCOL_SOCKET = 2,
    MYSQL_PROTOCOL_PIPE = 3,
    MYSQL_PROTOCOL_MEMORY = 4,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_ssl_mode {
    SSL_MODE_DISABLED = 1,
    SSL_MODE_PREFERRED = 2,
    SSL_MODE_REQUIRED = 3,
    SSL_MODE_VERIFY_CA = 4,
    SSL_MODE_VERIFY_IDENTITY = 5,
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum mysql_ssl_fips_mode {
    SSL_FIPS_MODE_OFF = 0,
    SSL_FIPS_MODE_ON = 1,
    SSL_FIPS_MODE_STRICT = 2,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct character_set {
    pub number: ::std::os::raw::c_uint,
    pub state: ::std::os::raw::c_uint,
    pub csname: *const ::std::os::raw::c_char,
    pub name: *const ::std::os::raw::c_char,
    pub comment: *const ::std::os::raw::c_char,
    pub dir: *const ::std::os::raw::c_char,
    pub mbminlen: ::std::os::raw::c_uint,
    pub mbmaxlen: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_character_set() {
    const UNINIT: ::std::mem::MaybeUninit<character_set> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<character_set>(),
        48usize,
        concat!("Size of: ", stringify!(character_set))
    );
    assert_eq!(
        ::std::mem::align_of::<character_set>(),
        8usize,
        concat!("Alignment of ", stringify!(character_set))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).number) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(character_set),
            "::",
            stringify!(number)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(character_set),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).csname) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(character_set),
            "::",
            stringify!(csname)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).name) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(character_set),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).comment) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(character_set),
            "::",
            stringify!(comment)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).dir) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(character_set),
            "::",
            stringify!(dir)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mbminlen) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(character_set),
            "::",
            stringify!(mbminlen)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mbmaxlen) as usize - ptr as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(character_set),
            "::",
            stringify!(mbmaxlen)
        )
    );
}
pub type MY_CHARSET_INFO = character_set;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_METHODS {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL {
    pub net: NET,
    pub connector_fd: *mut ::std::os::raw::c_uchar,
    pub host: *mut ::std::os::raw::c_char,
    pub user: *mut ::std::os::raw::c_char,
    pub passwd: *mut ::std::os::raw::c_char,
    pub unix_socket: *mut ::std::os::raw::c_char,
    pub server_version: *mut ::std::os::raw::c_char,
    pub host_info: *mut ::std::os::raw::c_char,
    pub info: *mut ::std::os::raw::c_char,
    pub db: *mut ::std::os::raw::c_char,
    pub charset: *mut CHARSET_INFO,
    pub fields: *mut MYSQL_FIELD,
    pub field_alloc: *mut MEM_ROOT,
    pub affected_rows: u64,
    pub insert_id: u64,
    pub extra_info: u64,
    pub thread_id: ::std::os::raw::c_ulong,
    pub packet_length: ::std::os::raw::c_ulong,
    pub port: ::std::os::raw::c_uint,
    pub client_flag: ::std::os::raw::c_ulong,
    pub server_capabilities: ::std::os::raw::c_ulong,
    pub protocol_version: ::std::os::raw::c_uint,
    pub field_count: ::std::os::raw::c_uint,
    pub server_status: ::std::os::raw::c_uint,
    pub server_language: ::std::os::raw::c_uint,
    pub warning_count: ::std::os::raw::c_uint,
    pub options: st_mysql_options,
    pub status: mysql_status,
    pub resultset_metadata: enum_resultset_metadata,
    pub free_me: bool,
    pub reconnect: bool,
    pub scramble: [::std::os::raw::c_char; 21usize],
    pub stmts: *mut LIST,
    pub methods: *const MYSQL_METHODS,
    pub thd: *mut ::std::os::raw::c_void,
    pub unbuffered_fetch_owner: *mut bool,
    pub extension: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_MYSQL() {
    const UNINIT: ::std::mem::MaybeUninit<MYSQL> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<MYSQL>(),
        1160usize,
        concat!("Size of: ", stringify!(MYSQL))
    );
    assert_eq!(
        ::std::mem::align_of::<MYSQL>(),
        8usize,
        concat!("Alignment of ", stringify!(MYSQL))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).net) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(net)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).connector_fd) as usize - ptr as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(connector_fd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).host) as usize - ptr as usize },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(host)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).user) as usize - ptr as usize },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(user)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).passwd) as usize - ptr as usize },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(passwd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unix_socket) as usize - ptr as usize },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(unix_socket)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).server_version) as usize - ptr as usize },
        704usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(server_version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).host_info) as usize - ptr as usize },
        712usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(host_info)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).info) as usize - ptr as usize },
        720usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(info)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).db) as usize - ptr as usize },
        728usize,
        concat!("Offset of field: ", stringify!(MYSQL), "::", stringify!(db))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).charset) as usize - ptr as usize },
        736usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(charset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fields) as usize - ptr as usize },
        744usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(fields)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field_alloc) as usize - ptr as usize },
        752usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(field_alloc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).affected_rows) as usize - ptr as usize },
        760usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(affected_rows)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).insert_id) as usize - ptr as usize },
        768usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(insert_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extra_info) as usize - ptr as usize },
        776usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(extra_info)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).thread_id) as usize - ptr as usize },
        784usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(thread_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).packet_length) as usize - ptr as usize },
        792usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(packet_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).port) as usize - ptr as usize },
        800usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(port)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).client_flag) as usize - ptr as usize },
        808usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(client_flag)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).server_capabilities) as usize - ptr as usize },
        816usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(server_capabilities)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).protocol_version) as usize - ptr as usize },
        824usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(protocol_version)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field_count) as usize - ptr as usize },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(field_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).server_status) as usize - ptr as usize },
        832usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(server_status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).server_language) as usize - ptr as usize },
        836usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(server_language)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).warning_count) as usize - ptr as usize },
        840usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(warning_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).options) as usize - ptr as usize },
        848usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(options)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).status) as usize - ptr as usize },
        1088usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).resultset_metadata) as usize - ptr as usize },
        1092usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(resultset_metadata)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).free_me) as usize - ptr as usize },
        1096usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(free_me)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).reconnect) as usize - ptr as usize },
        1097usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(reconnect)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).scramble) as usize - ptr as usize },
        1098usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(scramble)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stmts) as usize - ptr as usize },
        1120usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(stmts)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).methods) as usize - ptr as usize },
        1128usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(methods)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).thd) as usize - ptr as usize },
        1136usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(thd)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unbuffered_fetch_owner) as usize - ptr as usize },
        1144usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(unbuffered_fetch_owner)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extension) as usize - ptr as usize },
        1152usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL),
            "::",
            stringify!(extension)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_RES {
    pub row_count: u64,
    pub fields: *mut MYSQL_FIELD,
    pub data: *mut MYSQL_DATA,
    pub data_cursor: *mut MYSQL_ROWS,
    pub lengths: *mut ::std::os::raw::c_ulong,
    pub handle: *mut MYSQL,
    pub methods: *const MYSQL_METHODS,
    pub row: MYSQL_ROW,
    pub current_row: MYSQL_ROW,
    pub field_alloc: *mut MEM_ROOT,
    pub field_count: ::std::os::raw::c_uint,
    pub current_field: ::std::os::raw::c_uint,
    pub eof: bool,
    pub unbuffered_fetch_cancelled: bool,
    pub metadata: enum_resultset_metadata,
    pub extension: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_MYSQL_RES() {
    const UNINIT: ::std::mem::MaybeUninit<MYSQL_RES> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<MYSQL_RES>(),
        104usize,
        concat!("Size of: ", stringify!(MYSQL_RES))
    );
    assert_eq!(
        ::std::mem::align_of::<MYSQL_RES>(),
        8usize,
        concat!("Alignment of ", stringify!(MYSQL_RES))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).row_count) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(row_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fields) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(fields)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_cursor) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(data_cursor)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).lengths) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(lengths)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).handle) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).methods) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(methods)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).row) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(row)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).current_row) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(current_row)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field_alloc) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(field_alloc)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field_count) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(field_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).current_field) as usize - ptr as usize },
        84usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(current_field)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).eof) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(eof)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unbuffered_fetch_cancelled) as usize - ptr as usize },
        89usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(unbuffered_fetch_cancelled)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).metadata) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(metadata)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extension) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RES),
            "::",
            stringify!(extension)
        )
    );
}
#[doc = "Struct for information about a replication stream.\n\n@sa mysql_binlog_open()\n@sa mysql_binlog_fetch()\n@sa mysql_binlog_close()"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_RPL {
    pub file_name_length: usize,
    #[doc = " Length of the 'file_name' or 0"]
    pub file_name: *const ::std::os::raw::c_char,
    #[doc = " Filename of the binary log to read"]
    pub start_position: u64,
    #[doc = " Position in the binary log to"]
    pub server_id: ::std::os::raw::c_uint,
    #[doc = " Server ID to use when identifying"]
    pub flags: ::std::os::raw::c_uint,
    #[doc = " Size of gtid set data"]
    pub gtid_set_encoded_size: usize,
    pub fix_gtid_set: ::std::option::Option<
        unsafe extern "C" fn(rpl: *mut MYSQL_RPL, packet_gtid_set: *mut ::std::os::raw::c_uchar),
    >,
    pub gtid_set_arg: *mut ::std::os::raw::c_void,
    #[doc = " GTID set data or an argument for"]
    pub size: ::std::os::raw::c_ulong,
    #[doc = " Size of the packet returned by"]
    pub buffer: *const ::std::os::raw::c_uchar,
}
#[test]
fn bindgen_test_layout_MYSQL_RPL() {
    const UNINIT: ::std::mem::MaybeUninit<MYSQL_RPL> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<MYSQL_RPL>(),
        72usize,
        concat!("Size of: ", stringify!(MYSQL_RPL))
    );
    assert_eq!(
        ::std::mem::align_of::<MYSQL_RPL>(),
        8usize,
        concat!("Alignment of ", stringify!(MYSQL_RPL))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).file_name_length) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RPL),
            "::",
            stringify!(file_name_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).file_name) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RPL),
            "::",
            stringify!(file_name)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).start_position) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RPL),
            "::",
            stringify!(start_position)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).server_id) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RPL),
            "::",
            stringify!(server_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RPL),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gtid_set_encoded_size) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RPL),
            "::",
            stringify!(gtid_set_encoded_size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fix_gtid_set) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RPL),
            "::",
            stringify!(fix_gtid_set)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).gtid_set_arg) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RPL),
            "::",
            stringify!(gtid_set_arg)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).size) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RPL),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buffer) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_RPL),
            "::",
            stringify!(buffer)
        )
    );
}
extern "C" {
    pub fn mysql_server_init(
        argc: ::std::os::raw::c_int,
        argv: *mut *mut ::std::os::raw::c_char,
        groups: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_server_end();
}
extern "C" {
    pub fn mysql_thread_init() -> bool;
}
extern "C" {
    pub fn mysql_thread_end();
}
extern "C" {
    pub fn mysql_num_rows(res: *mut MYSQL_RES) -> u64;
}
extern "C" {
    pub fn mysql_num_fields(res: *mut MYSQL_RES) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn mysql_eof(res: *mut MYSQL_RES) -> bool;
}
extern "C" {
    pub fn mysql_fetch_field_direct(
        res: *mut MYSQL_RES,
        fieldnr: ::std::os::raw::c_uint,
    ) -> *mut MYSQL_FIELD;
}
extern "C" {
    pub fn mysql_fetch_fields(res: *mut MYSQL_RES) -> *mut MYSQL_FIELD;
}
extern "C" {
    pub fn mysql_row_tell(res: *mut MYSQL_RES) -> MYSQL_ROW_OFFSET;
}
extern "C" {
    pub fn mysql_field_tell(res: *mut MYSQL_RES) -> MYSQL_FIELD_OFFSET;
}
extern "C" {
    pub fn mysql_result_metadata(result: *mut MYSQL_RES) -> enum_resultset_metadata;
}
extern "C" {
    pub fn mysql_field_count(mysql: *mut MYSQL) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn mysql_affected_rows(mysql: *mut MYSQL) -> u64;
}
extern "C" {
    pub fn mysql_insert_id(mysql: *mut MYSQL) -> u64;
}
extern "C" {
    pub fn mysql_errno(mysql: *mut MYSQL) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn mysql_error(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn mysql_sqlstate(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn mysql_warning_count(mysql: *mut MYSQL) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn mysql_info(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn mysql_thread_id(mysql: *mut MYSQL) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn mysql_character_set_name(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn mysql_set_character_set(
        mysql: *mut MYSQL,
        csname: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_init(mysql: *mut MYSQL) -> *mut MYSQL;
}
extern "C" {
    pub fn mysql_ssl_set(
        mysql: *mut MYSQL,
        key: *const ::std::os::raw::c_char,
        cert: *const ::std::os::raw::c_char,
        ca: *const ::std::os::raw::c_char,
        capath: *const ::std::os::raw::c_char,
        cipher: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn mysql_get_ssl_cipher(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn mysql_get_ssl_session_reused(mysql: *mut MYSQL) -> bool;
}
extern "C" {
    pub fn mysql_get_ssl_session_data(
        mysql: *mut MYSQL,
        n_ticket: ::std::os::raw::c_uint,
        out_len: *mut ::std::os::raw::c_uint,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn mysql_free_ssl_session_data(
        mysql: *mut MYSQL,
        data: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn mysql_change_user(
        mysql: *mut MYSQL,
        user: *const ::std::os::raw::c_char,
        passwd: *const ::std::os::raw::c_char,
        db: *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn mysql_real_connect(
        mysql: *mut MYSQL,
        host: *const ::std::os::raw::c_char,
        user: *const ::std::os::raw::c_char,
        passwd: *const ::std::os::raw::c_char,
        db: *const ::std::os::raw::c_char,
        port: ::std::os::raw::c_uint,
        unix_socket: *const ::std::os::raw::c_char,
        clientflag: ::std::os::raw::c_ulong,
    ) -> *mut MYSQL;
}
extern "C" {
    pub fn mysql_select_db(
        mysql: *mut MYSQL,
        db: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_query(
        mysql: *mut MYSQL,
        q: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_send_query(
        mysql: *mut MYSQL,
        q: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_real_query(
        mysql: *mut MYSQL,
        q: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_store_result(mysql: *mut MYSQL) -> *mut MYSQL_RES;
}
extern "C" {
    pub fn mysql_use_result(mysql: *mut MYSQL) -> *mut MYSQL_RES;
}
extern "C" {
    pub fn mysql_real_connect_nonblocking(
        mysql: *mut MYSQL,
        host: *const ::std::os::raw::c_char,
        user: *const ::std::os::raw::c_char,
        passwd: *const ::std::os::raw::c_char,
        db: *const ::std::os::raw::c_char,
        port: ::std::os::raw::c_uint,
        unix_socket: *const ::std::os::raw::c_char,
        clientflag: ::std::os::raw::c_ulong,
    ) -> net_async_status;
}
extern "C" {
    pub fn mysql_send_query_nonblocking(
        mysql: *mut MYSQL,
        query: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> net_async_status;
}
extern "C" {
    pub fn mysql_real_query_nonblocking(
        mysql: *mut MYSQL,
        query: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> net_async_status;
}
extern "C" {
    pub fn mysql_store_result_nonblocking(
        mysql: *mut MYSQL,
        result: *mut *mut MYSQL_RES,
    ) -> net_async_status;
}
extern "C" {
    pub fn mysql_next_result_nonblocking(mysql: *mut MYSQL) -> net_async_status;
}
extern "C" {
    pub fn mysql_select_db_nonblocking(
        mysql: *mut MYSQL,
        db: *const ::std::os::raw::c_char,
        error: *mut bool,
    ) -> net_async_status;
}
extern "C" {
    pub fn mysql_get_character_set_info(mysql: *mut MYSQL, charset: *mut MY_CHARSET_INFO);
}
extern "C" {
    pub fn mysql_session_track_get_first(
        mysql: *mut MYSQL,
        type_: enum_session_state_type,
        data: *mut *const ::std::os::raw::c_char,
        length: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_session_track_get_next(
        mysql: *mut MYSQL,
        type_: enum_session_state_type,
        data: *mut *const ::std::os::raw::c_char,
        length: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_set_local_infile_handler(
        mysql: *mut MYSQL,
        local_infile_init: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_char,
                arg3: *mut ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
        local_infile_read: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_uint,
            ) -> ::std::os::raw::c_int,
        >,
        local_infile_end: ::std::option::Option<
            unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void),
        >,
        local_infile_error: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *mut ::std::os::raw::c_char,
                arg3: ::std::os::raw::c_uint,
            ) -> ::std::os::raw::c_int,
        >,
        arg1: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn mysql_set_local_infile_default(mysql: *mut MYSQL);
}
extern "C" {
    pub fn mysql_shutdown(
        mysql: *mut MYSQL,
        shutdown_level: mysql_enum_shutdown_level,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_dump_debug_info(mysql: *mut MYSQL) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_refresh(
        mysql: *mut MYSQL,
        refresh_options: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_kill(mysql: *mut MYSQL, pid: ::std::os::raw::c_ulong) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_set_server_option(
        mysql: *mut MYSQL,
        option: enum_mysql_set_option,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_ping(mysql: *mut MYSQL) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_stat(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn mysql_get_server_info(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn mysql_get_client_info() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn mysql_get_client_version() -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn mysql_get_host_info(mysql: *mut MYSQL) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn mysql_get_server_version(mysql: *mut MYSQL) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn mysql_get_proto_info(mysql: *mut MYSQL) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn mysql_list_dbs(mysql: *mut MYSQL, wild: *const ::std::os::raw::c_char)
        -> *mut MYSQL_RES;
}
extern "C" {
    pub fn mysql_list_tables(
        mysql: *mut MYSQL,
        wild: *const ::std::os::raw::c_char,
    ) -> *mut MYSQL_RES;
}
extern "C" {
    pub fn mysql_list_processes(mysql: *mut MYSQL) -> *mut MYSQL_RES;
}
extern "C" {
    pub fn mysql_options(
        mysql: *mut MYSQL,
        option: mysql_option,
        arg: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_options4(
        mysql: *mut MYSQL,
        option: mysql_option,
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_get_option(
        mysql: *mut MYSQL,
        option: mysql_option,
        arg: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_free_result(result: *mut MYSQL_RES);
}
extern "C" {
    pub fn mysql_free_result_nonblocking(result: *mut MYSQL_RES) -> net_async_status;
}
extern "C" {
    pub fn mysql_data_seek(result: *mut MYSQL_RES, offset: u64);
}
extern "C" {
    pub fn mysql_row_seek(result: *mut MYSQL_RES, offset: MYSQL_ROW_OFFSET) -> MYSQL_ROW_OFFSET;
}
extern "C" {
    pub fn mysql_field_seek(
        result: *mut MYSQL_RES,
        offset: MYSQL_FIELD_OFFSET,
    ) -> MYSQL_FIELD_OFFSET;
}
extern "C" {
    pub fn mysql_fetch_row(result: *mut MYSQL_RES) -> MYSQL_ROW;
}
extern "C" {
    pub fn mysql_fetch_row_nonblocking(
        res: *mut MYSQL_RES,
        row: *mut MYSQL_ROW,
    ) -> net_async_status;
}
extern "C" {
    pub fn mysql_fetch_lengths(result: *mut MYSQL_RES) -> *mut ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn mysql_fetch_field(result: *mut MYSQL_RES) -> *mut MYSQL_FIELD;
}
extern "C" {
    pub fn mysql_list_fields(
        mysql: *mut MYSQL,
        table: *const ::std::os::raw::c_char,
        wild: *const ::std::os::raw::c_char,
    ) -> *mut MYSQL_RES;
}
extern "C" {
    pub fn mysql_escape_string(
        to: *mut ::std::os::raw::c_char,
        from: *const ::std::os::raw::c_char,
        from_length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn mysql_hex_string(
        to: *mut ::std::os::raw::c_char,
        from: *const ::std::os::raw::c_char,
        from_length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn mysql_real_escape_string(
        mysql: *mut MYSQL,
        to: *mut ::std::os::raw::c_char,
        from: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn mysql_real_escape_string_quote(
        mysql: *mut MYSQL,
        to: *mut ::std::os::raw::c_char,
        from: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
        quote: ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn mysql_debug(debug: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn mysql_thread_safe() -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn mysql_read_query_result(mysql: *mut MYSQL) -> bool;
}
extern "C" {
    pub fn mysql_reset_connection(mysql: *mut MYSQL) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_binlog_open(mysql: *mut MYSQL, rpl: *mut MYSQL_RPL) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_binlog_fetch(mysql: *mut MYSQL, rpl: *mut MYSQL_RPL) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_binlog_close(mysql: *mut MYSQL, rpl: *mut MYSQL_RPL);
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_mysql_stmt_state {
    MYSQL_STMT_INIT_DONE = 1,
    MYSQL_STMT_PREPARE_DONE = 2,
    MYSQL_STMT_EXECUTE_DONE = 3,
    MYSQL_STMT_FETCH_DONE = 4,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_BIND {
    pub length: *mut ::std::os::raw::c_ulong,
    pub is_null: *mut bool,
    pub buffer: *mut ::std::os::raw::c_void,
    pub error: *mut bool,
    pub row_ptr: *mut ::std::os::raw::c_uchar,
    pub store_param_func:
        ::std::option::Option<unsafe extern "C" fn(net: *mut NET, param: *mut MYSQL_BIND)>,
    pub fetch_result: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut MYSQL_BIND,
            arg2: *mut MYSQL_FIELD,
            row: *mut *mut ::std::os::raw::c_uchar,
        ),
    >,
    pub skip_result: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut MYSQL_BIND,
            arg2: *mut MYSQL_FIELD,
            row: *mut *mut ::std::os::raw::c_uchar,
        ),
    >,
    pub buffer_length: ::std::os::raw::c_ulong,
    pub offset: ::std::os::raw::c_ulong,
    pub length_value: ::std::os::raw::c_ulong,
    pub param_number: ::std::os::raw::c_uint,
    pub pack_length: ::std::os::raw::c_uint,
    pub buffer_type: enum_field_types,
    pub error_value: bool,
    pub is_unsigned: bool,
    pub long_data_used: bool,
    pub is_null_value: bool,
    pub extension: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_MYSQL_BIND() {
    const UNINIT: ::std::mem::MaybeUninit<MYSQL_BIND> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<MYSQL_BIND>(),
        112usize,
        concat!("Size of: ", stringify!(MYSQL_BIND))
    );
    assert_eq!(
        ::std::mem::align_of::<MYSQL_BIND>(),
        8usize,
        concat!("Alignment of ", stringify!(MYSQL_BIND))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).length) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_null) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(is_null)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buffer) as usize - ptr as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(buffer)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).error) as usize - ptr as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(error)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).row_ptr) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(row_ptr)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).store_param_func) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(store_param_func)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fetch_result) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(fetch_result)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).skip_result) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(skip_result)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buffer_length) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(buffer_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).offset) as usize - ptr as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).length_value) as usize - ptr as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(length_value)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).param_number) as usize - ptr as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(param_number)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).pack_length) as usize - ptr as usize },
        92usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(pack_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).buffer_type) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(buffer_type)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).error_value) as usize - ptr as usize },
        100usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(error_value)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_unsigned) as usize - ptr as usize },
        101usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(is_unsigned)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).long_data_used) as usize - ptr as usize },
        102usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(long_data_used)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).is_null_value) as usize - ptr as usize },
        103usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(is_null_value)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extension) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_BIND),
            "::",
            stringify!(extension)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_STMT_EXT {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct MYSQL_STMT {
    pub mem_root: *mut MEM_ROOT,
    pub list: LIST,
    pub mysql: *mut MYSQL,
    pub params: *mut MYSQL_BIND,
    pub bind: *mut MYSQL_BIND,
    pub fields: *mut MYSQL_FIELD,
    pub result: MYSQL_DATA,
    pub data_cursor: *mut MYSQL_ROWS,
    pub read_row_func: ::std::option::Option<
        unsafe extern "C" fn(
            stmt: *mut MYSQL_STMT,
            row: *mut *mut ::std::os::raw::c_uchar,
        ) -> ::std::os::raw::c_int,
    >,
    pub affected_rows: u64,
    pub insert_id: u64,
    pub stmt_id: ::std::os::raw::c_ulong,
    pub flags: ::std::os::raw::c_ulong,
    pub prefetch_rows: ::std::os::raw::c_ulong,
    pub server_status: ::std::os::raw::c_uint,
    pub last_errno: ::std::os::raw::c_uint,
    pub param_count: ::std::os::raw::c_uint,
    pub field_count: ::std::os::raw::c_uint,
    pub state: enum_mysql_stmt_state,
    pub last_error: [::std::os::raw::c_char; 512usize],
    pub sqlstate: [::std::os::raw::c_char; 6usize],
    pub send_types_to_server: bool,
    pub bind_param_done: bool,
    pub bind_result_done: ::std::os::raw::c_uchar,
    pub unbuffered_fetch_cancelled: bool,
    pub update_max_length: bool,
    pub extension: *mut MYSQL_STMT_EXT,
}
#[test]
fn bindgen_test_layout_MYSQL_STMT() {
    const UNINIT: ::std::mem::MaybeUninit<MYSQL_STMT> = ::std::mem::MaybeUninit::uninit();
    let ptr = UNINIT.as_ptr();
    assert_eq!(
        ::std::mem::size_of::<MYSQL_STMT>(),
        704usize,
        concat!("Size of: ", stringify!(MYSQL_STMT))
    );
    assert_eq!(
        ::std::mem::align_of::<MYSQL_STMT>(),
        8usize,
        concat!("Alignment of ", stringify!(MYSQL_STMT))
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mem_root) as usize - ptr as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(mem_root)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).list) as usize - ptr as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(list)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).mysql) as usize - ptr as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(mysql)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).params) as usize - ptr as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(params)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind) as usize - ptr as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(bind)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).fields) as usize - ptr as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(fields)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).result) as usize - ptr as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(result)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).data_cursor) as usize - ptr as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(data_cursor)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).read_row_func) as usize - ptr as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(read_row_func)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).affected_rows) as usize - ptr as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(affected_rows)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).insert_id) as usize - ptr as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(insert_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).stmt_id) as usize - ptr as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(stmt_id)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).flags) as usize - ptr as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(flags)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).prefetch_rows) as usize - ptr as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(prefetch_rows)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).server_status) as usize - ptr as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(server_status)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_errno) as usize - ptr as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(last_errno)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).param_count) as usize - ptr as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(param_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).field_count) as usize - ptr as usize },
        164usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(field_count)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).state) as usize - ptr as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(state)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).last_error) as usize - ptr as usize },
        172usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(last_error)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).sqlstate) as usize - ptr as usize },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(sqlstate)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).send_types_to_server) as usize - ptr as usize },
        690usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(send_types_to_server)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_param_done) as usize - ptr as usize },
        691usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(bind_param_done)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).bind_result_done) as usize - ptr as usize },
        692usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(bind_result_done)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).unbuffered_fetch_cancelled) as usize - ptr as usize },
        693usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(unbuffered_fetch_cancelled)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).update_max_length) as usize - ptr as usize },
        694usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(update_max_length)
        )
    );
    assert_eq!(
        unsafe { ::std::ptr::addr_of!((*ptr).extension) as usize - ptr as usize },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(MYSQL_STMT),
            "::",
            stringify!(extension)
        )
    );
}
#[repr(u32)]
#[non_exhaustive]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum enum_stmt_attr_type {
    STMT_ATTR_UPDATE_MAX_LENGTH = 0,
    STMT_ATTR_CURSOR_TYPE = 1,
    STMT_ATTR_PREFETCH_ROWS = 2,
}
extern "C" {
    pub fn mysql_bind_param(
        mysql: *mut MYSQL,
        n_params: ::std::os::raw::c_uint,
        binds: *mut MYSQL_BIND,
        names: *mut *const ::std::os::raw::c_char,
    ) -> bool;
}
extern "C" {
    pub fn mysql_stmt_init(mysql: *mut MYSQL) -> *mut MYSQL_STMT;
}
extern "C" {
    pub fn mysql_stmt_prepare(
        stmt: *mut MYSQL_STMT,
        query: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_stmt_execute(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_stmt_fetch(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_stmt_fetch_column(
        stmt: *mut MYSQL_STMT,
        bind_arg: *mut MYSQL_BIND,
        column: ::std::os::raw::c_uint,
        offset: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_stmt_store_result(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_stmt_param_count(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn mysql_stmt_attr_set(
        stmt: *mut MYSQL_STMT,
        attr_type: enum_stmt_attr_type,
        attr: *const ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn mysql_stmt_attr_get(
        stmt: *mut MYSQL_STMT,
        attr_type: enum_stmt_attr_type,
        attr: *mut ::std::os::raw::c_void,
    ) -> bool;
}
extern "C" {
    pub fn mysql_stmt_bind_param(stmt: *mut MYSQL_STMT, bnd: *mut MYSQL_BIND) -> bool;
}
extern "C" {
    pub fn mysql_stmt_bind_result(stmt: *mut MYSQL_STMT, bnd: *mut MYSQL_BIND) -> bool;
}
extern "C" {
    pub fn mysql_stmt_close(stmt: *mut MYSQL_STMT) -> bool;
}
extern "C" {
    pub fn mysql_stmt_reset(stmt: *mut MYSQL_STMT) -> bool;
}
extern "C" {
    pub fn mysql_stmt_free_result(stmt: *mut MYSQL_STMT) -> bool;
}
extern "C" {
    pub fn mysql_stmt_send_long_data(
        stmt: *mut MYSQL_STMT,
        param_number: ::std::os::raw::c_uint,
        data: *const ::std::os::raw::c_char,
        length: ::std::os::raw::c_ulong,
    ) -> bool;
}
extern "C" {
    pub fn mysql_stmt_result_metadata(stmt: *mut MYSQL_STMT) -> *mut MYSQL_RES;
}
extern "C" {
    pub fn mysql_stmt_param_metadata(stmt: *mut MYSQL_STMT) -> *mut MYSQL_RES;
}
extern "C" {
    pub fn mysql_stmt_errno(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn mysql_stmt_error(stmt: *mut MYSQL_STMT) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn mysql_stmt_sqlstate(stmt: *mut MYSQL_STMT) -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn mysql_stmt_row_seek(stmt: *mut MYSQL_STMT, offset: MYSQL_ROW_OFFSET)
        -> MYSQL_ROW_OFFSET;
}
extern "C" {
    pub fn mysql_stmt_row_tell(stmt: *mut MYSQL_STMT) -> MYSQL_ROW_OFFSET;
}
extern "C" {
    pub fn mysql_stmt_data_seek(stmt: *mut MYSQL_STMT, offset: u64);
}
extern "C" {
    pub fn mysql_stmt_num_rows(stmt: *mut MYSQL_STMT) -> u64;
}
extern "C" {
    pub fn mysql_stmt_affected_rows(stmt: *mut MYSQL_STMT) -> u64;
}
extern "C" {
    pub fn mysql_stmt_insert_id(stmt: *mut MYSQL_STMT) -> u64;
}
extern "C" {
    pub fn mysql_stmt_field_count(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn mysql_commit(mysql: *mut MYSQL) -> bool;
}
extern "C" {
    pub fn mysql_rollback(mysql: *mut MYSQL) -> bool;
}
extern "C" {
    pub fn mysql_autocommit(mysql: *mut MYSQL, auto_mode: bool) -> bool;
}
extern "C" {
    pub fn mysql_more_results(mysql: *mut MYSQL) -> bool;
}
extern "C" {
    pub fn mysql_next_result(mysql: *mut MYSQL) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_stmt_next_result(stmt: *mut MYSQL_STMT) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mysql_close(sock: *mut MYSQL);
}
extern "C" {
    pub fn mysql_reset_server_public_key();
}
extern "C" {
    pub fn mysql_real_connect_dns_srv(
        mysql: *mut MYSQL,
        dns_srv_name: *const ::std::os::raw::c_char,
        user: *const ::std::os::raw::c_char,
        passwd: *const ::std::os::raw::c_char,
        db: *const ::std::os::raw::c_char,
        client_flag: ::std::os::raw::c_ulong,
    ) -> *mut MYSQL;
}
pub type __builtin_va_list = *mut ::std::os::raw::c_char;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct Init_commands_array {
    pub _address: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CHARSET_INFO {
    pub _address: u8,
}
