/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache license, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the license for the specific language governing permissions and
 * limitations under the license.
 */

package org.apache.logging.log4j.core.appender.rolling.action;

import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

/**
 * Test helper class.
 */
public class CountingCondition implements PathCondition {

    private final boolean accept;
    private int acceptCount;
    private int beforeFileTreeWalkCount;

    public CountingCondition(final boolean accept) {
        this.accept = accept;
    }

    @Override
    public boolean accept(final Path baseDir, final Path path, final BasicFileAttributes attrs) {
        acceptCount++;
        return accept;
    }

    @Override
    public void beforeFileTreeWalk() {
        beforeFileTreeWalkCount++;
    }

    /**
     * @return the acceptCount
     */
    public int getAcceptCount() {
        return acceptCount;
    }

    /**
     * @return the beforeFileTreeWalkCount
     */
    public int getBeforeFileTreeWalkCount() {
        return beforeFileTreeWalkCount;
    }
}
