/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.txt.UGraphicTxt;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;

public class ComponentTextGroupingBody
extends AbstractComponentText {
    private final ComponentType type;
    private final List<? extends CharSequence> stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextGroupingBody(ComponentType type, List<? extends CharSequence> stringsToDisplay, FileFormat fileFormat) {
        this.type = type;
        this.stringsToDisplay = stringsToDisplay;
        this.fileFormat = fileFormat;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        int height = (int)dimensionToUse.getHeight();
        if (this.fileFormat == FileFormat.UTXT) {
            charArea.drawVLine('\u2551', 0, 0, height);
            charArea.drawVLine('\u2551', width - 1, 0, height);
            charArea.drawHLine('\u2550', height - 1, 1, width - 1, '\u2502', '\u256a');
            charArea.drawChar('\u2560', 0, height - 1);
            charArea.drawChar('\u2563', width - 1, height - 1);
        } else {
            charArea.drawVLine('!', 0, 0, height);
            charArea.drawVLine('!', width - 1, 0, height);
            charArea.drawHLine('~', height - 1, 1, width - 1);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return 1.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return 1.0;
    }
}

