/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.endpoints.internal;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.endpoints.DynamoDbEndpointParams;
import software.amazon.awssdk.services.dynamodb.endpoints.DynamoDbEndpointProvider;
import software.amazon.awssdk.services.dynamodb.endpoints.internal.RuleArn;
import software.amazon.awssdk.services.dynamodb.endpoints.internal.RulePartition;
import software.amazon.awssdk.services.dynamodb.endpoints.internal.RuleResult;
import software.amazon.awssdk.services.dynamodb.endpoints.internal.RulesFunctions;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.uri.SdkUri;

@SdkInternalApi
public final class DefaultDynamoDbEndpointProvider
implements DynamoDbEndpointProvider {
    @Override
    public CompletableFuture<Endpoint> resolveEndpoint(DynamoDbEndpointParams params) {
        Validate.notNull((Object)params.useDualStack(), (String)"Parameter 'UseDualStack' must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)params.useFips(), (String)"Parameter 'UseFIPS' must not be null", (Object[])new Object[0]);
        try {
            Region region = params.region();
            String regionId = region == null ? null : region.id();
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule0(params, regionId);
            if (result.canContinue()) {
                throw SdkClientException.create((String)"Rule engine did not reach an error or endpoint result");
            }
            if (result.isError()) {
                String errorMsg = result.error();
                if (errorMsg.contains("Invalid ARN") && errorMsg.contains(":s3:::")) {
                    errorMsg = errorMsg + ". Use the bucket name instead of simple bucket ARNs in GetBucketLocationRequest.";
                }
                throw SdkClientException.create((String)errorMsg);
            }
            return CompletableFuture.completedFuture(result.endpoint());
        }
        catch (Exception error) {
            return CompletableFutureUtils.failedFuture((Throwable)error);
        }
    }

    private static RuleResult endpointRule0(DynamoDbEndpointParams params, String region) {
        RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule1(params);
        if (result.isResolved()) {
            return result;
        }
        result = DefaultDynamoDbEndpointProvider.endpointRule5(params, region);
        if (result.isResolved()) {
            return result;
        }
        return RuleResult.error("Invalid Configuration: Missing Region");
    }

    private static RuleResult endpointRule1(DynamoDbEndpointParams params) {
        if (params.endpoint() != null) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and custom endpoint are not supported");
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: Dualstack and custom endpoint are not supported");
            }
            return RuleResult.endpoint(Endpoint.builder().url(SdkUri.getInstance().create(params.endpoint())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule5(DynamoDbEndpointParams params, String region) {
        if (region != null) {
            return DefaultDynamoDbEndpointProvider.endpointRule6(params, region);
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule6(DynamoDbEndpointParams params, String region) {
        RulePartition partitionResult = RulesFunctions.awsPartition(region);
        if (partitionResult != null) {
            RuleArn parsedArn;
            String firstArn;
            RuleArn parsedArn2;
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule7(params, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule11(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule17(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule27(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            if (params.accountIdEndpointMode() != null && !"disabled".equals(params.accountIdEndpointMode()) && "aws".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.resourceArn() != null && (parsedArn2 = RulesFunctions.awsParseArn(params.resourceArn())) != null && "dynamodb".equals(parsedArn2.service()) && RulesFunctions.isValidHostLabel(parsedArn2.region(), false) && RulesFunctions.stringEquals(parsedArn2.region(), region) && RulesFunctions.isValidHostLabel(parsedArn2.accountId(), false)) {
                return RuleResult.endpoint(Endpoint.builder().url(SdkUri.getInstance().create("https://" + parsedArn2.accountId() + ".ddb." + region + "." + partitionResult.dnsSuffix())).build());
            }
            if (params.accountIdEndpointMode() != null && !"disabled".equals(params.accountIdEndpointMode()) && "aws".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.resourceArnList() != null && (firstArn = RulesFunctions.listAccess(params.resourceArnList(), 0)) != null && (parsedArn = RulesFunctions.awsParseArn(firstArn)) != null && "dynamodb".equals(parsedArn.service()) && RulesFunctions.isValidHostLabel(parsedArn.region(), false) && RulesFunctions.stringEquals(parsedArn.region(), region) && RulesFunctions.isValidHostLabel(parsedArn.accountId(), false)) {
                return RuleResult.endpoint(Endpoint.builder().url(SdkUri.getInstance().create("https://" + parsedArn.accountId() + ".ddb." + region + "." + partitionResult.dnsSuffix())).build());
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule37(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule41(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(SdkUri.getInstance().create("https://dynamodb." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule7(DynamoDbEndpointParams params, String region) {
        if ("local".equals(region)) {
            if (params.useFips().booleanValue()) {
                return RuleResult.error("Invalid Configuration: FIPS and local endpoint are not supported");
            }
            if (params.useDualStack().booleanValue()) {
                return RuleResult.error("Invalid Configuration: Dualstack and local endpoint are not supported");
            }
            return RuleResult.endpoint(Endpoint.builder().url(SdkUri.getInstance().create("http://localhost:8000")).putAttribute(AwsEndpointAttribute.AUTH_SCHEMES, Arrays.asList(SigV4AuthScheme.builder().signingName("dynamodb").signingRegion("us-east-1").build())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule11(DynamoDbEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue() && params.useDualStack().booleanValue()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule12(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS and DualStack are enabled, but this partition does not support one or both");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule12(DynamoDbEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS() && partitionResult.supportsDualStack()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule13(params);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(SdkUri.getInstance().create("https://dynamodb-fips." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule13(DynamoDbEndpointParams params) {
        if (params.accountIdEndpointMode() != null && "required".equals(params.accountIdEndpointMode())) {
            return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule17(DynamoDbEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useFips().booleanValue()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule18(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("FIPS is enabled but this partition does not support FIPS");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule18(DynamoDbEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsFIPS()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule19(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            result = DefaultDynamoDbEndpointProvider.endpointRule23(params);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(SdkUri.getInstance().create("https://dynamodb-fips." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule19(DynamoDbEndpointParams params, RulePartition partitionResult, String region) {
        if ("aws-us-gov".equals(partitionResult.name())) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule20(params);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(SdkUri.getInstance().create("https://dynamodb." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule20(DynamoDbEndpointParams params) {
        if (params.accountIdEndpointMode() != null && "required".equals(params.accountIdEndpointMode())) {
            return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule23(DynamoDbEndpointParams params) {
        if (params.accountIdEndpointMode() != null && "required".equals(params.accountIdEndpointMode())) {
            return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule27(DynamoDbEndpointParams params, RulePartition partitionResult, String region) {
        if (params.useDualStack().booleanValue()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule28(params, partitionResult, region);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("DualStack is enabled but this partition does not support DualStack");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule28(DynamoDbEndpointParams params, RulePartition partitionResult, String region) {
        if (partitionResult.supportsDualStack()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule29(params);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.endpoint(Endpoint.builder().url(SdkUri.getInstance().create("https://dynamodb." + region + "." + partitionResult.dualStackDnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule29(DynamoDbEndpointParams params) {
        if (params.accountIdEndpointMode() != null && "required".equals(params.accountIdEndpointMode())) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule30(params);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule30(DynamoDbEndpointParams params) {
        if (!params.useFips().booleanValue()) {
            return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required and DualStack is enabled, but DualStack account endpoints are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule37(DynamoDbEndpointParams params, RulePartition partitionResult, String region) {
        if (params.accountIdEndpointMode() != null && !"disabled".equals(params.accountIdEndpointMode()) && "aws".equals(partitionResult.name()) && !params.useFips().booleanValue() && !params.useDualStack().booleanValue() && params.accountId() != null) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule38(params, region, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Credentials-sourced account ID parameter is invalid");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule38(DynamoDbEndpointParams params, String region, RulePartition partitionResult) {
        if (RulesFunctions.isValidHostLabel(params.accountId(), false)) {
            return RuleResult.endpoint(Endpoint.builder().url(SdkUri.getInstance().create("https://" + params.accountId() + ".ddb." + region + "." + partitionResult.dnsSuffix())).build());
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule41(DynamoDbEndpointParams params, RulePartition partitionResult) {
        if (params.accountIdEndpointMode() != null && "required".equals(params.accountIdEndpointMode())) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule42(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required and FIPS is enabled, but FIPS account endpoints are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule42(DynamoDbEndpointParams params, RulePartition partitionResult) {
        if (!params.useFips().booleanValue()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule43(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required and DualStack is enabled, but DualStack account endpoints are not supported");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule43(DynamoDbEndpointParams params, RulePartition partitionResult) {
        if (!params.useDualStack().booleanValue()) {
            RuleResult result = DefaultDynamoDbEndpointProvider.endpointRule44(params, partitionResult);
            if (result.isResolved()) {
                return result;
            }
            return RuleResult.error("Invalid Configuration: AccountIdEndpointMode is required but account endpoints are not supported in this partition");
        }
        return RuleResult.carryOn();
    }

    private static RuleResult endpointRule44(DynamoDbEndpointParams params, RulePartition partitionResult) {
        if ("aws".equals(partitionResult.name())) {
            return RuleResult.error("AccountIdEndpointMode is required but no AccountID was provided or able to be loaded");
        }
        return RuleResult.carryOn();
    }

    public boolean equals(Object rhs) {
        return rhs != null && this.getClass().equals(rhs.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

