/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;

public abstract class SingleMetricAggregateBase
extends AggregateBase {
    @Nullable
    private final Double value;
    @Nullable
    private final String valueAsString;

    protected SingleMetricAggregateBase(AbstractBuilder<?> builder) {
        super(builder);
        this.value = ((AbstractBuilder)builder).value;
        this.valueAsString = ((AbstractBuilder)builder).valueAsString;
    }

    @Nullable
    public final Double value() {
        return this.value;
    }

    @Nullable
    public final String valueAsString() {
        return this.valueAsString;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.value != null) {
            generator.writeKey("value");
            generator.write(this.value.doubleValue());
        }
        if (this.valueAsString != null) {
            generator.writeKey("value_as_string");
            generator.write(this.valueAsString);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSingleMetricAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        SingleMetricAggregateBase.setupAggregateBaseDeserializer(op);
        op.add(AbstractBuilder::value, JsonpDeserializer.doubleDeserializer(), "value");
        op.add(AbstractBuilder::valueAsString, JsonpDeserializer.stringDeserializer(), "value_as_string");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.value);
        result = 31 * result + Objects.hashCode(this.valueAsString);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleMetricAggregateBase other = (SingleMetricAggregateBase)o;
        return Objects.equals(this.value, other.value) && Objects.equals(this.valueAsString, other.valueAsString);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregateBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Double value;
        @Nullable
        private String valueAsString;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(SingleMetricAggregateBase o) {
            super(o);
            this.value = o.value;
            this.valueAsString = o.valueAsString;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            super(o);
            this.value = o.value;
            this.valueAsString = o.valueAsString;
        }

        @Nonnull
        public final BuilderT value(@Nullable Double value) {
            this.value = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT valueAsString(@Nullable String value) {
            this.valueAsString = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

