/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.mappingtransformer;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.model.MLModelConfig;
import org.opensearch.ml.common.model.RemoteModelConfig;
import org.opensearch.ml.common.model.TextEmbeddingModelConfig;
import org.opensearch.neuralsearch.constants.SemanticInfoFieldConstants;
import org.opensearch.neuralsearch.mappingtransformer.SemanticMappingTransformer;
import org.opensearch.neuralsearch.mappingtransformer.TextEmbeddingInfo;

public class SemanticInfoConfigBuilder {
    private final NamedXContentRegistry xContentRegistry;
    private String embeddingFieldType;
    private String spaceType;
    private String knnMethodName = "hnsw";
    private Integer embeddingDimension;
    private Boolean chunkingEnabled;
    private String semanticFieldSearchAnalyzer;
    private Map<String, Object> denseEmbeddingConfig;
    private boolean sparseEncodingConfigDefined;
    private static final List<String> UNSUPPORTED_DENSE_EMBEDDING_CONFIG = List.of("dimension", "data_type", "space_type");

    public SemanticInfoConfigBuilder(@reactor.util.annotation.NonNull NamedXContentRegistry xContentRegistry) {
        this.xContentRegistry = xContentRegistry;
    }

    public Map<String, Object> build() {
        this.validate();
        Map<String, Object> embeddingFieldConfig = switch (this.embeddingFieldType) {
            case "knn_vector" -> this.buildKnnFieldConfig();
            case "rank_features" -> this.buildRankFeaturesFieldConfig();
            default -> throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot build the semantic info config because the embedding field type %s is not supported.", this.embeddingFieldType));
        };
        if (Boolean.TRUE.equals(this.chunkingEnabled)) {
            Map<String, Map<String, Map<String, Object>>> chunksConfig = Map.of("type", "nested", "properties", Map.of("text", Map.of("type", "text"), "embedding", embeddingFieldConfig));
            return Map.of("properties", Map.of("chunks", chunksConfig, "model", SemanticInfoFieldConstants.DEFAULT_MODEL_CONFIG));
        }
        return Map.of("properties", Map.of("embedding", embeddingFieldConfig, "model", SemanticInfoFieldConstants.DEFAULT_MODEL_CONFIG));
    }

    private void validate() {
        if ("knn_vector".equals(this.embeddingFieldType)) {
            this.validateSearchAnalyzerNotDefined();
            this.validateSparseEncodingConfigNotDefined();
        }
        if ("rank_features".equals(this.embeddingFieldType)) {
            this.validateDenseEmbeddingConfigNotDefined();
        }
    }

    private void validateSparseEncodingConfigNotDefined() {
        if (this.sparseEncodingConfigDefined) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot build the semantic info config because the dense(text embedding) model cannot support %s.", "sparse_encoding_config"));
        }
    }

    private void validateDenseEmbeddingConfigNotDefined() {
        if (this.denseEmbeddingConfig != null && "rank_features".equals(this.embeddingFieldType)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot build the semantic info config because %s is not supported by the sparse model.", "dense_embedding_config"));
        }
    }

    private void validateSearchAnalyzerNotDefined() {
        if (this.semanticFieldSearchAnalyzer != null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot build the semantic info config because the dense(text embedding) model cannot support %s", "semantic_field_search_analyzer"));
        }
    }

    private Map<String, Object> buildKnnFieldConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("type", "knn_vector");
        config.put("dimension", this.embeddingDimension);
        HashMap<String, String> methodConfig = new HashMap<String, String>();
        if (this.denseEmbeddingConfig != null) {
            this.validateDenseEmbeddingConfig(this.denseEmbeddingConfig);
            config.putAll(this.denseEmbeddingConfig);
            Object methodConfigObj = this.denseEmbeddingConfig.get("method");
            if (methodConfigObj != null) {
                if (methodConfigObj instanceof Map) {
                    Map methodConfigMap = (Map)methodConfigObj;
                    methodConfig.putAll(methodConfigMap);
                } else {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot build the semantic info config because %s must be a Map when provided.", "method"));
                }
            }
        }
        methodConfig.putIfAbsent("name", this.knnMethodName);
        methodConfig.put("space_type", this.spaceType);
        config.put("method", methodConfig);
        return config;
    }

    private void validateDenseEmbeddingConfig(@reactor.util.annotation.NonNull Map<String, Object> denseEmbeddingConfig) {
        Map methodConfigMap;
        Object object;
        UNSUPPORTED_DENSE_EMBEDDING_CONFIG.forEach(name -> {
            if (denseEmbeddingConfig.get(name) != null) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot configure %s in %s in the semantic field.", name, "dense_embedding_config"));
            }
        });
        if (denseEmbeddingConfig.get("method") != null && (object = denseEmbeddingConfig.get("method")) instanceof Map && (methodConfigMap = (Map)object).get("space_type") != null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Cannot configure %s in %s in the semantic field.", "space_type", "dense_embedding_config"));
        }
    }

    private Map<String, Object> buildRankFeaturesFieldConfig() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("type", "rank_features");
        return config;
    }

    public SemanticInfoConfigBuilder mlModel(@reactor.util.annotation.NonNull MLModel mlModel, @reactor.util.annotation.NonNull String modelId) {
        switch (mlModel.getAlgorithm()) {
            case TEXT_EMBEDDING: {
                this.extractInfoForTextEmbeddingModel(mlModel, modelId, false);
                break;
            }
            case SPARSE_ENCODING: 
            case SPARSE_TOKENIZE: {
                this.extractInfoForSparseModel();
                break;
            }
            case REMOTE: {
                this.extractInfoForRemoteModel(mlModel, modelId);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "The algorithm %s of the model %s is not supported in the semantic field. Supported algorithms: [%s].", mlModel.getAlgorithm().name(), modelId, String.join((CharSequence)",", SemanticMappingTransformer.SUPPORTED_MODEL_ALGORITHMS)));
            }
        }
        return this;
    }

    private void extractInfoForTextEmbeddingModel(@reactor.util.annotation.NonNull MLModel mlModel, @reactor.util.annotation.NonNull String modelId, boolean isRemote) {
        this.embeddingFieldType = "knn_vector";
        TextEmbeddingInfo textEmbeddingInfo = isRemote ? this.extractInfoForRemoteTextEmbeddingModel(mlModel.getModelConfig(), modelId) : this.extractInfoForLocalTextEmbeddingModel(mlModel.getModelConfig(), modelId);
        this.validateAndSetTextEmbeddingInfo(textEmbeddingInfo, modelId);
    }

    private void validateAndSetTextEmbeddingInfo(@reactor.util.annotation.NonNull TextEmbeddingInfo textEmbeddingInfo, @reactor.util.annotation.NonNull String modelId) {
        if (textEmbeddingInfo.getEmbeddingDimension() == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Model %s is a text embedding model, but the embedding dimension is not defined in the model config.", modelId));
        }
        this.embeddingDimension = textEmbeddingInfo.getEmbeddingDimension();
        if (textEmbeddingInfo.getAdditionalConfig() == null || !(textEmbeddingInfo.getAdditionalConfig().get("space_type") instanceof String)) {
            throw this.createInvalidSpaceTypeException(modelId);
        }
        this.spaceType = (String)textEmbeddingInfo.getAdditionalConfig().get("space_type");
    }

    private TextEmbeddingInfo extractInfoForLocalTextEmbeddingModel(MLModelConfig modelConfig, @reactor.util.annotation.NonNull String modelId) {
        if (modelConfig instanceof TextEmbeddingModelConfig) {
            TextEmbeddingModelConfig textEmbeddingModelConfig = (TextEmbeddingModelConfig)modelConfig;
            return new TextEmbeddingInfo(textEmbeddingModelConfig.getEmbeddingDimension(), textEmbeddingModelConfig.getAdditionalConfig());
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Model %s is a local text embedding model, but model_config is a %s rather than a TextEmbeddingModelConfig.", modelId, modelConfig.getClass().getName()));
    }

    private TextEmbeddingInfo extractInfoForRemoteTextEmbeddingModel(MLModelConfig modelConfig, @reactor.util.annotation.NonNull String modelId) {
        if (modelConfig instanceof RemoteModelConfig) {
            RemoteModelConfig remoteModelConfig = (RemoteModelConfig)modelConfig;
            return new TextEmbeddingInfo(remoteModelConfig.getEmbeddingDimension(), remoteModelConfig.getAdditionalConfig());
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Model %s is marked as remote text embedding model, but model_config is a %s rather than a RemoteModelConfig.", modelId, modelConfig.getClass().getName()));
    }

    private IllegalArgumentException createInvalidSpaceTypeException(@reactor.util.annotation.NonNull String modelId) {
        return new IllegalArgumentException(String.format(Locale.ROOT, "space_type is not defined or not a string in the additional_config of the model %s.", modelId));
    }

    private void extractInfoForSparseModel() {
        this.embeddingFieldType = "rank_features";
    }

    private void extractInfoForRemoteModel(@reactor.util.annotation.NonNull MLModel mlModel, @reactor.util.annotation.NonNull String modelId) {
        FunctionName modelTypeFunctionName;
        MLModelConfig mlModelConfig = mlModel.getModelConfig();
        if (mlModelConfig == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Model config is null for the remote model %s.", modelId));
        }
        String modelType = mlModel.getModelConfig().getModelType();
        try {
            modelTypeFunctionName = FunctionName.from((String)modelType);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(this.getUnsupportedRemoteModelError(modelType, modelId));
        }
        switch (modelTypeFunctionName) {
            case TEXT_EMBEDDING: {
                this.extractInfoForTextEmbeddingModel(mlModel, modelId, true);
                break;
            }
            case SPARSE_ENCODING: 
            case SPARSE_TOKENIZE: {
                this.extractInfoForSparseModel();
                break;
            }
            default: {
                throw new IllegalArgumentException(this.getUnsupportedRemoteModelError(modelType, modelId));
            }
        }
    }

    private String getUnsupportedRemoteModelError(String modelType, @NonNull String modelId) {
        Objects.requireNonNull(modelId, "modelId is marked non-null but is null");
        return String.format(Locale.ROOT, "The model type %s of the model %s is not supported in the semantic field. Supported remote model types: [%s]", modelType, modelId, String.join((CharSequence)",", SemanticMappingTransformer.SUPPORTED_REMOTE_MODEL_TYPES));
    }

    public SemanticInfoConfigBuilder chunkingEnabled(Boolean chunkingEnabled) {
        this.chunkingEnabled = chunkingEnabled;
        return this;
    }

    public SemanticInfoConfigBuilder semanticFieldSearchAnalyzer(String semanticFieldSearchAnalyzer) {
        this.semanticFieldSearchAnalyzer = semanticFieldSearchAnalyzer;
        return this;
    }

    public SemanticInfoConfigBuilder denseEmbeddingConfig(Map<String, Object> denseEmbeddingConfig) {
        this.denseEmbeddingConfig = denseEmbeddingConfig;
        return this;
    }

    public SemanticInfoConfigBuilder sparseEncodingConfigDefined(boolean sparseEncodingConfigDefined) {
        this.sparseEncodingConfigDefined = sparseEncodingConfigDefined;
        return this;
    }
}

