/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.cluster.stats.FieldTypes;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CharFilterTypes
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, CharFilterTypes> {
    @Nonnull
    private final List<FieldTypes> analyzerTypes;
    @Nonnull
    private final List<FieldTypes> builtInAnalyzers;
    @Nonnull
    private final List<FieldTypes> builtInCharFilters;
    @Nonnull
    private final List<FieldTypes> builtInFilters;
    @Nonnull
    private final List<FieldTypes> builtInTokenizers;
    @Nonnull
    private final List<FieldTypes> charFilterTypes;
    @Nonnull
    private final List<FieldTypes> filterTypes;
    @Nonnull
    private final List<FieldTypes> tokenizerTypes;
    public static final JsonpDeserializer<CharFilterTypes> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CharFilterTypes::setupCharFilterTypesDeserializer);

    private CharFilterTypes(Builder builder) {
        this.analyzerTypes = ApiTypeHelper.unmodifiableRequired(builder.analyzerTypes, (Object)this, "analyzerTypes");
        this.builtInAnalyzers = ApiTypeHelper.unmodifiableRequired(builder.builtInAnalyzers, (Object)this, "builtInAnalyzers");
        this.builtInCharFilters = ApiTypeHelper.unmodifiableRequired(builder.builtInCharFilters, (Object)this, "builtInCharFilters");
        this.builtInFilters = ApiTypeHelper.unmodifiableRequired(builder.builtInFilters, (Object)this, "builtInFilters");
        this.builtInTokenizers = ApiTypeHelper.unmodifiableRequired(builder.builtInTokenizers, (Object)this, "builtInTokenizers");
        this.charFilterTypes = ApiTypeHelper.unmodifiableRequired(builder.charFilterTypes, (Object)this, "charFilterTypes");
        this.filterTypes = ApiTypeHelper.unmodifiableRequired(builder.filterTypes, (Object)this, "filterTypes");
        this.tokenizerTypes = ApiTypeHelper.unmodifiableRequired(builder.tokenizerTypes, (Object)this, "tokenizerTypes");
    }

    public static CharFilterTypes of(Function<Builder, ObjectBuilder<CharFilterTypes>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final List<FieldTypes> analyzerTypes() {
        return this.analyzerTypes;
    }

    @Nonnull
    public final List<FieldTypes> builtInAnalyzers() {
        return this.builtInAnalyzers;
    }

    @Nonnull
    public final List<FieldTypes> builtInCharFilters() {
        return this.builtInCharFilters;
    }

    @Nonnull
    public final List<FieldTypes> builtInFilters() {
        return this.builtInFilters;
    }

    @Nonnull
    public final List<FieldTypes> builtInTokenizers() {
        return this.builtInTokenizers;
    }

    @Nonnull
    public final List<FieldTypes> charFilterTypes() {
        return this.charFilterTypes;
    }

    @Nonnull
    public final List<FieldTypes> filterTypes() {
        return this.filterTypes;
    }

    @Nonnull
    public final List<FieldTypes> tokenizerTypes() {
        return this.tokenizerTypes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("analyzer_types");
        generator.writeStartArray();
        for (FieldTypes item0 : this.analyzerTypes) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("built_in_analyzers");
        generator.writeStartArray();
        for (FieldTypes item0 : this.builtInAnalyzers) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("built_in_char_filters");
        generator.writeStartArray();
        for (FieldTypes item0 : this.builtInCharFilters) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("built_in_filters");
        generator.writeStartArray();
        for (FieldTypes item0 : this.builtInFilters) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("built_in_tokenizers");
        generator.writeStartArray();
        for (FieldTypes item0 : this.builtInTokenizers) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("char_filter_types");
        generator.writeStartArray();
        for (FieldTypes item0 : this.charFilterTypes) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("filter_types");
        generator.writeStartArray();
        for (FieldTypes item0 : this.filterTypes) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("tokenizer_types");
        generator.writeStartArray();
        for (FieldTypes item0 : this.tokenizerTypes) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCharFilterTypesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analyzerTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "analyzer_types");
        op.add(Builder::builtInAnalyzers, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "built_in_analyzers");
        op.add(Builder::builtInCharFilters, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "built_in_char_filters");
        op.add(Builder::builtInFilters, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "built_in_filters");
        op.add(Builder::builtInTokenizers, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "built_in_tokenizers");
        op.add(Builder::charFilterTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "char_filter_types");
        op.add(Builder::filterTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "filter_types");
        op.add(Builder::tokenizerTypes, JsonpDeserializer.arrayDeserializer(FieldTypes._DESERIALIZER), "tokenizer_types");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.analyzerTypes.hashCode();
        result = 31 * result + this.builtInAnalyzers.hashCode();
        result = 31 * result + this.builtInCharFilters.hashCode();
        result = 31 * result + this.builtInFilters.hashCode();
        result = 31 * result + this.builtInTokenizers.hashCode();
        result = 31 * result + this.charFilterTypes.hashCode();
        result = 31 * result + this.filterTypes.hashCode();
        result = 31 * result + this.tokenizerTypes.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharFilterTypes other = (CharFilterTypes)o;
        return this.analyzerTypes.equals(other.analyzerTypes) && this.builtInAnalyzers.equals(other.builtInAnalyzers) && this.builtInCharFilters.equals(other.builtInCharFilters) && this.builtInFilters.equals(other.builtInFilters) && this.builtInTokenizers.equals(other.builtInTokenizers) && this.charFilterTypes.equals(other.charFilterTypes) && this.filterTypes.equals(other.filterTypes) && this.tokenizerTypes.equals(other.tokenizerTypes);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, CharFilterTypes> {
        private List<FieldTypes> analyzerTypes;
        private List<FieldTypes> builtInAnalyzers;
        private List<FieldTypes> builtInCharFilters;
        private List<FieldTypes> builtInFilters;
        private List<FieldTypes> builtInTokenizers;
        private List<FieldTypes> charFilterTypes;
        private List<FieldTypes> filterTypes;
        private List<FieldTypes> tokenizerTypes;

        public Builder() {
        }

        private Builder(CharFilterTypes o) {
            this.analyzerTypes = Builder._listCopy(o.analyzerTypes);
            this.builtInAnalyzers = Builder._listCopy(o.builtInAnalyzers);
            this.builtInCharFilters = Builder._listCopy(o.builtInCharFilters);
            this.builtInFilters = Builder._listCopy(o.builtInFilters);
            this.builtInTokenizers = Builder._listCopy(o.builtInTokenizers);
            this.charFilterTypes = Builder._listCopy(o.charFilterTypes);
            this.filterTypes = Builder._listCopy(o.filterTypes);
            this.tokenizerTypes = Builder._listCopy(o.tokenizerTypes);
        }

        private Builder(Builder o) {
            this.analyzerTypes = Builder._listCopy(o.analyzerTypes);
            this.builtInAnalyzers = Builder._listCopy(o.builtInAnalyzers);
            this.builtInCharFilters = Builder._listCopy(o.builtInCharFilters);
            this.builtInFilters = Builder._listCopy(o.builtInFilters);
            this.builtInTokenizers = Builder._listCopy(o.builtInTokenizers);
            this.charFilterTypes = Builder._listCopy(o.charFilterTypes);
            this.filterTypes = Builder._listCopy(o.filterTypes);
            this.tokenizerTypes = Builder._listCopy(o.tokenizerTypes);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder analyzerTypes(List<FieldTypes> list) {
            this.analyzerTypes = Builder._listAddAll(this.analyzerTypes, list);
            return this;
        }

        @Nonnull
        public final Builder analyzerTypes(FieldTypes value, FieldTypes ... values) {
            this.analyzerTypes = Builder._listAdd(this.analyzerTypes, value, values);
            return this;
        }

        @Nonnull
        public final Builder analyzerTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.analyzerTypes(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        @Nonnull
        public final Builder builtInAnalyzers(List<FieldTypes> list) {
            this.builtInAnalyzers = Builder._listAddAll(this.builtInAnalyzers, list);
            return this;
        }

        @Nonnull
        public final Builder builtInAnalyzers(FieldTypes value, FieldTypes ... values) {
            this.builtInAnalyzers = Builder._listAdd(this.builtInAnalyzers, value, values);
            return this;
        }

        @Nonnull
        public final Builder builtInAnalyzers(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.builtInAnalyzers(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        @Nonnull
        public final Builder builtInCharFilters(List<FieldTypes> list) {
            this.builtInCharFilters = Builder._listAddAll(this.builtInCharFilters, list);
            return this;
        }

        @Nonnull
        public final Builder builtInCharFilters(FieldTypes value, FieldTypes ... values) {
            this.builtInCharFilters = Builder._listAdd(this.builtInCharFilters, value, values);
            return this;
        }

        @Nonnull
        public final Builder builtInCharFilters(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.builtInCharFilters(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        @Nonnull
        public final Builder builtInFilters(List<FieldTypes> list) {
            this.builtInFilters = Builder._listAddAll(this.builtInFilters, list);
            return this;
        }

        @Nonnull
        public final Builder builtInFilters(FieldTypes value, FieldTypes ... values) {
            this.builtInFilters = Builder._listAdd(this.builtInFilters, value, values);
            return this;
        }

        @Nonnull
        public final Builder builtInFilters(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.builtInFilters(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        @Nonnull
        public final Builder builtInTokenizers(List<FieldTypes> list) {
            this.builtInTokenizers = Builder._listAddAll(this.builtInTokenizers, list);
            return this;
        }

        @Nonnull
        public final Builder builtInTokenizers(FieldTypes value, FieldTypes ... values) {
            this.builtInTokenizers = Builder._listAdd(this.builtInTokenizers, value, values);
            return this;
        }

        @Nonnull
        public final Builder builtInTokenizers(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.builtInTokenizers(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        @Nonnull
        public final Builder charFilterTypes(List<FieldTypes> list) {
            this.charFilterTypes = Builder._listAddAll(this.charFilterTypes, list);
            return this;
        }

        @Nonnull
        public final Builder charFilterTypes(FieldTypes value, FieldTypes ... values) {
            this.charFilterTypes = Builder._listAdd(this.charFilterTypes, value, values);
            return this;
        }

        @Nonnull
        public final Builder charFilterTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.charFilterTypes(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        @Nonnull
        public final Builder filterTypes(List<FieldTypes> list) {
            this.filterTypes = Builder._listAddAll(this.filterTypes, list);
            return this;
        }

        @Nonnull
        public final Builder filterTypes(FieldTypes value, FieldTypes ... values) {
            this.filterTypes = Builder._listAdd(this.filterTypes, value, values);
            return this;
        }

        @Nonnull
        public final Builder filterTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.filterTypes(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        @Nonnull
        public final Builder tokenizerTypes(List<FieldTypes> list) {
            this.tokenizerTypes = Builder._listAddAll(this.tokenizerTypes, list);
            return this;
        }

        @Nonnull
        public final Builder tokenizerTypes(FieldTypes value, FieldTypes ... values) {
            this.tokenizerTypes = Builder._listAdd(this.tokenizerTypes, value, values);
            return this;
        }

        @Nonnull
        public final Builder tokenizerTypes(Function<FieldTypes.Builder, ObjectBuilder<FieldTypes>> fn) {
            return this.tokenizerTypes(fn.apply(new FieldTypes.Builder()).build(), new FieldTypes[0]);
        }

        @Override
        @Nonnull
        public CharFilterTypes build() {
            this._checkSingleUse();
            return new CharFilterTypes(this);
        }
    }
}

