"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FORECAST_NODE_API = exports.FORECAST_BASE_NODE_API_PATH = exports.BASE_NODE_API_PATH = exports.ALERTING_NODE_API = exports.AD_NODE_API = void 0;
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

const BASE_NODE_API_PATH = exports.BASE_NODE_API_PATH = '/api/anomaly_detectors';
const AD_NODE_API = exports.AD_NODE_API = Object.freeze({
  _SEARCH: `${BASE_NODE_API_PATH}/_search`,
  _INDICES: `${BASE_NODE_API_PATH}/_indices`,
  _ALIASES: `${BASE_NODE_API_PATH}/_aliases`,
  _MAPPINGS: `${BASE_NODE_API_PATH}/_mappings`,
  DETECTOR: `${BASE_NODE_API_PATH}/detectors`,
  CREATE_INDEX: `${BASE_NODE_API_PATH}/create_index`,
  BULK: `${BASE_NODE_API_PATH}/bulk`,
  DELETE_INDEX: `${BASE_NODE_API_PATH}/delete_index`,
  CREATE_SAMPLE_DATA: `${BASE_NODE_API_PATH}/create_sample_data`,
  GET_CLUSTERS_INFO: `${BASE_NODE_API_PATH}/_remote/info`,
  GET_INDICES_AND_ALIASES: `${BASE_NODE_API_PATH}/_indices_and_aliases`
});
const ALERTING_NODE_API = exports.ALERTING_NODE_API = Object.freeze({
  _SEARCH: `${BASE_NODE_API_PATH}/monitors/_search`,
  ALERTS: `${BASE_NODE_API_PATH}/monitors/alerts`,
  MONITORS: `${BASE_NODE_API_PATH}/monitors`
});
const FORECAST_BASE_NODE_API_PATH = exports.FORECAST_BASE_NODE_API_PATH = '/api/forecasting';
const FORECAST_NODE_API = exports.FORECAST_NODE_API = Object.freeze({
  _SEARCH: `${FORECAST_BASE_NODE_API_PATH}/_search`,
  _INDICES: `${FORECAST_BASE_NODE_API_PATH}/_indices`,
  _ALIASES: `${FORECAST_BASE_NODE_API_PATH}/_aliases`,
  _MAPPINGS: `${FORECAST_BASE_NODE_API_PATH}/_mappings`,
  FORECASTER: `${FORECAST_BASE_NODE_API_PATH}/forecasters`,
  CREATE_INDEX: `${FORECAST_BASE_NODE_API_PATH}/create_index`,
  BULK: `${FORECAST_BASE_NODE_API_PATH}/bulk`,
  DELETE_INDEX: `${FORECAST_BASE_NODE_API_PATH}/delete_index`,
  CREATE_SAMPLE_DATA: `${FORECAST_BASE_NODE_API_PATH}/create_sample_data`,
  GET_CLUSTERS_INFO: `${FORECAST_BASE_NODE_API_PATH}/_remote/info`,
  GET_INDICES_AND_ALIASES: `${FORECAST_BASE_NODE_API_PATH}/_indices_and_aliases`
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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