/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.blobstore.stream.write;

import java.io.IOException;
import java.util.Map;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.common.Nullable;
import org.opensearch.common.StreamContext;
import org.opensearch.common.blobstore.stream.write.StreamContextSupplier;
import org.opensearch.common.blobstore.stream.write.WritePriority;

public class WriteContext {
    private final String fileName;
    private final StreamContextSupplier streamContextSupplier;
    private final long fileSize;
    private final boolean failIfAlreadyExists;
    private final WritePriority writePriority;
    private final CheckedConsumer<Boolean, IOException> uploadFinalizer;
    private final boolean doRemoteDataIntegrityCheck;
    private final Long expectedChecksum;
    private final Map<String, String> metadata;

    private WriteContext(String fileName, StreamContextSupplier streamContextSupplier, long fileSize, boolean failIfAlreadyExists, WritePriority writePriority, CheckedConsumer<Boolean, IOException> uploadFinalizer, boolean doRemoteDataIntegrityCheck, @Nullable Long expectedChecksum, @Nullable Map<String, String> metadata) {
        this.fileName = fileName;
        this.streamContextSupplier = streamContextSupplier;
        this.fileSize = fileSize;
        this.failIfAlreadyExists = failIfAlreadyExists;
        this.writePriority = writePriority;
        this.uploadFinalizer = uploadFinalizer;
        this.doRemoteDataIntegrityCheck = doRemoteDataIntegrityCheck;
        this.expectedChecksum = expectedChecksum;
        this.metadata = metadata;
    }

    protected WriteContext(WriteContext writeContext) {
        this.fileName = writeContext.fileName;
        this.streamContextSupplier = writeContext.streamContextSupplier;
        this.fileSize = writeContext.fileSize;
        this.failIfAlreadyExists = writeContext.failIfAlreadyExists;
        this.writePriority = writeContext.writePriority;
        this.uploadFinalizer = writeContext.uploadFinalizer;
        this.doRemoteDataIntegrityCheck = writeContext.doRemoteDataIntegrityCheck;
        this.expectedChecksum = writeContext.expectedChecksum;
        this.metadata = writeContext.metadata;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isFailIfAlreadyExists() {
        return this.failIfAlreadyExists;
    }

    public StreamContext getStreamProvider(long partSize) {
        return this.streamContextSupplier.supplyStreamContext(partSize);
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public WritePriority getWritePriority() {
        return this.writePriority;
    }

    public CheckedConsumer<Boolean, IOException> getUploadFinalizer() {
        return this.uploadFinalizer;
    }

    public boolean doRemoteDataIntegrityCheck() {
        return this.doRemoteDataIntegrityCheck;
    }

    public Long getExpectedChecksum() {
        return this.expectedChecksum;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Builder {
        private String fileName;
        private StreamContextSupplier streamContextSupplier;
        private long fileSize;
        private boolean failIfAlreadyExists;
        private WritePriority writePriority;
        private CheckedConsumer<Boolean, IOException> uploadFinalizer;
        private boolean doRemoteDataIntegrityCheck;
        private Long expectedChecksum;
        private Map<String, String> metadata;

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public Builder streamContextSupplier(StreamContextSupplier streamContextSupplier) {
            this.streamContextSupplier = streamContextSupplier;
            return this;
        }

        public Builder fileSize(long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public Builder writePriority(WritePriority writePriority) {
            this.writePriority = writePriority;
            return this;
        }

        public Builder failIfAlreadyExists(boolean failIfAlreadyExists) {
            this.failIfAlreadyExists = failIfAlreadyExists;
            return this;
        }

        public Builder uploadFinalizer(CheckedConsumer<Boolean, IOException> uploadFinalizer) {
            this.uploadFinalizer = uploadFinalizer;
            return this;
        }

        public Builder doRemoteDataIntegrityCheck(boolean doRemoteDataIntegrityCheck) {
            this.doRemoteDataIntegrityCheck = doRemoteDataIntegrityCheck;
            return this;
        }

        public Builder expectedChecksum(Long expectedChecksum) {
            this.expectedChecksum = expectedChecksum;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public WriteContext build() {
            return new WriteContext(this.fileName, this.streamContextSupplier, this.fileSize, this.failIfAlreadyExists, this.writePriority, this.uploadFinalizer, this.doRemoteDataIntegrityCheck, this.expectedChecksum, this.metadata);
        }
    }
}

