/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.grants;

import java.util.Set;
import org.keycloak.authentication.authenticators.client.AbstractBaseJWTValidator;
import org.keycloak.authentication.authenticators.client.ClientAssertionState;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.JWTAuthorizationGrantValidationContext;
import org.keycloak.representations.JsonWebToken;

public class JWTAuthorizationGrantValidator
extends AbstractBaseJWTValidator
implements JWTAuthorizationGrantValidationContext {
    private final String scope;
    private Set<String> restrictedScopes;

    public static JWTAuthorizationGrantValidator createValidator(KeycloakSession session, ClientModel client, String assertion, String scope) {
        if (assertion == null) {
            throw new RuntimeException("Missing parameter:assertion");
        }
        try {
            JWSInput jws = new JWSInput(assertion);
            JsonWebToken jwt = (JsonWebToken)jws.readJsonContent(JsonWebToken.class);
            ClientAssertionState clientAssertionState = new ClientAssertionState("urn:ietf:params:oauth:grant-type:jwt-bearer", assertion, jws, jwt);
            clientAssertionState.setClient(client);
            return new JWTAuthorizationGrantValidator(session, scope, clientAssertionState);
        }
        catch (JWSInputException e) {
            throw new RuntimeException("The provided assertion is not a valid JWT");
        }
    }

    private JWTAuthorizationGrantValidator(KeycloakSession session, String scope, ClientAssertionState clientAssertionState) {
        super(session, clientAssertionState);
        this.scope = scope;
    }

    public void validateClient() {
        String val;
        if (this.clientAssertionState.getClient().isPublicClient()) {
            this.failureCallback("Public client not allowed to use authorization grant");
        }
        if (!Boolean.parseBoolean(val = this.clientAssertionState.getClient().getAttribute("oauth2.jwt.authorization.grant.enabled"))) {
            throw new RuntimeException("JWT Authorization Grant is not supported for the requested client");
        }
    }

    public void validateIssuer() {
        if (this.getJWT().getIssuer() == null) {
            this.failureCallback("Missing claim: iss");
        }
    }

    public void validateSubject() {
        if (this.getJWT().getSubject() == null) {
            this.failureCallback("Missing claim: sub");
        }
    }

    public JsonWebToken getJWT() {
        return this.clientAssertionState.getToken();
    }

    public String getAssertion() {
        return this.clientAssertionState.getClientAssertion();
    }

    public String getScopeParam() {
        return this.scope;
    }

    public Set<String> getRestrictedScopes() {
        return this.restrictedScopes;
    }

    public void setRestrictedScopes(Set<String> restrictedScopes) {
        this.restrictedScopes = restrictedScopes;
    }

    @Override
    protected void failureCallback(String errorDescription) {
        throw new RuntimeException(errorDescription);
    }
}

