/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client.impl;

import io.grpc.MethodDescriptor;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.grpc.client.GrpcClientOptions;
import io.vertx.grpc.client.GrpcClientRequest;
import io.vertx.grpc.client.impl.GrpcClientRequestImpl;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.ServiceMethod;
import io.vertx.grpc.common.ServiceName;
import io.vertx.grpcio.client.GrpcIoClient;

public class GrpcClientImpl
implements GrpcIoClient {
    private final Vertx vertx;
    private HttpClient client;
    private final long maxMessageSize;

    public GrpcClientImpl(Vertx vertx, GrpcClientOptions options) {
        HttpClientOptions transportOptions = options.getTransportOptions();
        transportOptions = transportOptions == null ? new HttpClientOptions().setHttp2ClearTextUpgrade(false) : new HttpClientOptions(transportOptions);
        transportOptions.setProtocolVersion(HttpVersion.HTTP_2);
        this.vertx = vertx;
        this.client = vertx.createHttpClient(transportOptions);
        this.maxMessageSize = options.getMaxMessageSize();
    }

    @Override
    public Future<GrpcClientRequest<Buffer, Buffer>> request(SocketAddress server) {
        RequestOptions options = new RequestOptions().setMethod(HttpMethod.POST).setServer(server);
        return this.client.request(options).map(request -> new GrpcClientRequestImpl((HttpClientRequest)request, this.maxMessageSize, GrpcMessageEncoder.IDENTITY, GrpcMessageDecoder.IDENTITY));
    }

    @Override
    public <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(SocketAddress server, MethodDescriptor<Req, Resp> service) {
        GrpcMessageDecoder messageDecoder = GrpcMessageDecoder.unmarshaller((MethodDescriptor.Marshaller)service.getResponseMarshaller());
        GrpcMessageEncoder messageEncoder = GrpcMessageEncoder.marshaller((MethodDescriptor.Marshaller)service.getRequestMarshaller());
        return this.request(server, ServiceMethod.client((ServiceName)ServiceName.create((String)service.getServiceName()), (String)service.getBareMethodName(), (GrpcMessageEncoder)messageEncoder, (GrpcMessageDecoder)messageDecoder));
    }

    @Override
    public <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(SocketAddress server, ServiceMethod<Resp, Req> method) {
        return this.request(new RequestOptions().setMethod(HttpMethod.POST).setServer(server), method);
    }

    private <Req, Resp> Future<GrpcClientRequest<Req, Resp>> request(RequestOptions options, ServiceMethod<Resp, Req> method) {
        GrpcMessageDecoder messageDecoder = method.decoder();
        GrpcMessageEncoder messageEncoder = method.encoder();
        return this.client.request(options).map(request -> {
            GrpcClientRequestImpl call = new GrpcClientRequestImpl((HttpClientRequest)request, this.maxMessageSize, messageEncoder, messageDecoder);
            call.fullMethodName(method.fullMethodName());
            return call;
        });
    }

    @Override
    public Future<Void> close() {
        return this.client.close();
    }
}

