/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.util;

import jakarta.persistence.LockModeType;
import org.hibernate.LockMode;
import org.hibernate.internal.util.LockModeConverter;

public final class LockModeTypeHelper {
    private LockModeTypeHelper() {
    }

    public static LockModeType getLockModeType(LockMode lockMode) {
        return LockModeConverter.convertToLockModeType(lockMode);
    }

    public static LockMode getLockMode(LockModeType lockModeType) {
        return LockModeConverter.convertToLockMode(lockModeType);
    }

    public static LockMode interpretLockMode(Object value) {
        if (value == null) {
            return LockMode.NONE;
        }
        if (value instanceof LockMode) {
            LockMode lockMode = (LockMode)((Object)value);
            return lockMode;
        }
        if (value instanceof LockModeType) {
            LockModeType lockModeType = (LockModeType)value;
            return LockModeTypeHelper.getLockMode(lockModeType);
        }
        if (value instanceof String) {
            String string = (String)value;
            return LockMode.fromExternalForm(string);
        }
        throw new IllegalArgumentException("Could not interpret '" + value.getClass().getName() + "' as a LockMode");
    }
}

