/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.XtalSymmetry;
import org.jmol.api.JmolAdapter;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.util.Vibration;

public class FSGOutputReader
extends AtomSetCollectionReader {
    private static final float fsgPrecision = 1.0E-4f;
    private short[] elementNumbers;
    private boolean spinOnly;
    private boolean convertToABC = true;
    private Map<String, Object> json;
    private String configuration;
    private boolean isCoplanar;
    private boolean isCollinear;
    private int firstTranslation;
    private String spinFrame;
    private String fullName;
    private static final int DEFAULT_PRECISION = 5;
    private P3 p2 = new P3();
    private P3 p1 = new P3();

    @Override
    public void initializeReader() throws Exception {
        super.initializeReader();
        this.convertToABC = false;
        this.spinOnly = this.checkFilterKey("SPINONLY");
        boolean bl = this.checkNearAtoms = !this.checkFilterKey("NOSPECIAL");
        if (!this.filteredPrecision) {
            this.precision = 5;
            this.filteredPrecision = true;
        }
        System.out.println("FSGOutput using precision " + this.precision);
        String symbols = this.getFilterWithCase("elements=");
        if (symbols != null) {
            String[] s = PT.split(symbols.replace(',', ' '), " ");
            this.elementNumbers = new short[s.length];
            int i = s.length;
            while (--i >= 0) {
                this.elementNumbers[i] = (short)JmolAdapter.getElementNumber(s[i]);
            }
        }
        SB sb = new SB();
        try {
            while (this.rd() != null) {
                sb.append(this.line);
            }
            this.json = this.vwr.parseJSONMap(sb.toString());
            this.processJSON();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.continuing = false;
    }

    private void processJSON() {
        this.getHeaderInfo();
        Lst<Object> info = FSGOutputReader.getList(this.json, "G0_std_Cell");
        this.getCellInfo(this.getListItem(info, 0));
        this.configuration = (String)this.json.get("Configuration");
        this.isCoplanar = "Coplanar".equals(this.configuration);
        this.isCollinear = "Collinear".equals(this.configuration);
        this.addMoreUnitCellInfo("configuration=" + this.configuration);
        this.readAllOperators(FSGOutputReader.getList(this.json, "G0_std_operations"));
        String[] symbols = this.getSymbols((Map)this.json.get("AtomTypeDict"));
        this.readAtomsAndMoments(info, symbols);
    }

    private String[] getSymbols(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        String[] symbols = new String[map.size() + 1];
        for (Map.Entry<String, Object> e : map.entrySet()) {
            symbols[Integer.parseInt((String)e.getKey())] = (String)e.getValue();
        }
        return symbols;
    }

    private Lst<Object> getListItem(Lst<Object> info, int i) {
        return (Lst)info.get(i);
    }

    private static Lst<Object> getList(Map<String, Object> json, String key) {
        return (Lst)json.get(key);
    }

    private void getHeaderInfo() {
        this.fullName = (String)this.json.get("SSG_international_symbol");
        this.setSpaceGroupName(this.fixName(this.fullName));
    }

    private String fixName(String name) {
        int pt;
        System.out.println("FSGOutput " + name);
        while ((pt = name.indexOf("\\frac{")) >= 0) {
            int pt2 = name.indexOf("{", pt + 7);
            int pt3 = name.indexOf("}", pt2 + 1);
            name = name.substring(0, pt) + "(" + name.substring(pt + 5, pt2) + "/" + name.substring(pt2, pt3) + ")" + name.substring(pt3);
        }
        name = PT.rep(name, "\\pi", "\u03c0");
        name = PT.rep(name, "\\enspace", " ");
        name = PT.rep(name, "\\infty", "\u221e");
        name = PT.rep(name, "\\\\^", "^");
        name = PT.replaceAllCharacters(name, "{}", "");
        return name;
    }

    private void getCellInfo(Lst<Object> list) {
        this.setFractionalCoordinates(true);
        for (int i = 0; i < 3; ++i) {
            P3 v = FSGOutputReader.getPoint(this.getListItem(list, i));
            this.addExplicitLatticeVector(i, new float[]{v.x, v.y, v.z}, 0);
        }
    }

    private static P3 getPoint(Lst<Object> item) {
        return P3.new3(FSGOutputReader.getValue(item, 0), FSGOutputReader.getValue(item, 1), FSGOutputReader.getValue(item, 2));
    }

    private static float getValue(Lst<Object> item, int i) {
        return ((Number)item.get(i)).floatValue();
    }

    private void readAllOperators(Lst<Object> info) {
        int n = info.size();
        int nops = 0;
        for (int i = 0; i < n; ++i) {
            Lst op = (Lst)info.get(i);
            M4 mspin = this.readMatrix(this.getListItem(op, 0), null);
            M4 mop = this.readMatrix(this.getListItem(op, 1), this.getListItem(op, 2));
            String s = SymmetryOperation.getTransformXYZ(mop) + SymmetryOperation.getSpinString(mspin, true, true) + (this.isCoplanar ? "+" : "");
            int iop = this.setSymmetryOperator(s);
            if (Logger.debugging) {
                System.out.println("FSGOutput op[" + (i + 1) + "]=" + s + (iop < 0 ? " SKIPPED" : ""));
            }
            if (iop < 0) continue;
            boolean isTranslation = SymmetryOperation.isTranslation(mop);
            if (this.firstTranslation == 0 && isTranslation) {
                this.firstTranslation = nops;
            }
            ++nops;
        }
        if (this.firstTranslation == 0) {
            this.firstTranslation = nops;
        }
        System.out.println("FSGOutput G0_operationCount(initial)=" + n);
    }

    private M4 readMatrix(Lst<Object> rot, Lst<Object> trans) {
        if (rot == null) {
            return null;
        }
        M3 r = new M3();
        for (int i = 0; i < 3; ++i) {
            r.setRowV(i, FSGOutputReader.getPoint(this.getListItem(rot, i)));
        }
        P3 t = trans == null ? new P3() : FSGOutputReader.getPoint(trans);
        return M4.newMV(r, t);
    }

    private void readAtomsAndMoments(Lst<Object> info, String[] symbols) {
        Lst<Object> atoms = this.getListItem(info, 1);
        Lst<Object> ids = this.getListItem(info, 2);
        Lst<Object> moments = this.getListItem(info, 3);
        int n = atoms.size();
        for (int i = 0; i < n; ++i) {
            P3 xyz = FSGOutputReader.getPoint(this.getListItem(atoms, i));
            int id = (int)FSGOutputReader.getValue(ids, i);
            Atom a = new Atom();
            a.setT(xyz);
            this.setAtomCoord(a);
            P3 moment = FSGOutputReader.getPoint(this.getListItem(moments, i));
            float mag = moment.length();
            if (mag > 0.0f) {
                if (Logger.debugging) {
                    System.out.println("FGSOutput moment " + i + " " + moment + " " + mag);
                }
                Vibration v = new Vibration();
                v.setType(-2);
                v.setT(moment);
                v.magMoment = mag;
                a.vib = v;
                System.out.println("FSGOutput atom/spin " + i + " " + a.vib + " " + mag);
            } else if (this.spinOnly) continue;
            if (symbols != null) {
                a.elementSymbol = symbols[id];
            } else {
                a.elementNumber = this.elementNumbers != null && id <= this.elementNumbers.length ? this.elementNumbers[id - 1] : (short)(id + 2);
            }
            this.asc.addAtom(a);
        }
    }

    @Override
    protected void warnSkippingOperation(String xyz) {
    }

    @Override
    public void doPreSymmetry(boolean doApplySymmetry) throws Exception {
        XtalSymmetry.FileSymmetry fs = this.asc.getSymmetry();
        BS bs = BSUtil.newBitSet2(0, this.asc.ac);
        int i = 0;
        this.symmetry.setPrecision(1.0E-4f);
        while ((i = this.excludeAtoms(i, bs, fs)) >= 0) {
        }
        int n = 0;
        int j = bs.nextSetBit(0);
        while (j >= 0) {
            this.asc.atoms[j].atomSite = n++;
            j = bs.nextSetBit(j + 1);
        }
        this.filterFsgAtoms(bs);
        this.preSymmetrySetMoments();
        System.out.println("FSGOutputReader using atoms " + bs);
        Lst<String> lst = fs.setSpinList(this.configuration);
        if (lst != null) {
            this.asc.setCurrentModelInfo("spinList", lst);
            this.appendLoadNote(lst.size() + " spin operations -- see _M.spinList and atom.spin");
        }
        System.out.println("FSGOutput operationCount=" + fs.getSpaceGroupOperationCount());
        Map<String, Object> info = this.getSCIFInfo(fs, lst);
        this.asc.setCurrentModelInfo("scifInfo", info);
        this.asc.setCurrentModelInfo("spinFrame", this.spinFrame);
    }

    private void preSymmetrySetMoments() {
        float a = this.symmetry.getUnitCellInfoType(0);
        float b = this.symmetry.getUnitCellInfoType(1);
        float c = this.symmetry.getUnitCellInfoType(2);
        int i = this.asc.ac;
        while (--i >= 0) {
            Vibration v = (Vibration)this.asc.atoms[i].vib;
            if (v == null) continue;
            this.spinCartesianToFractional(v, a, b, c);
        }
    }

    private void spinCartesianToFractional(Vibration v, double a, double b, double c) {
        P3 p = P3.newP(v);
        this.symmetry.toFractional(v, true);
        v.x = (float)((double)v.x * a);
        v.y = (float)((double)v.y * b);
        v.z = (float)((double)v.z * c);
        v.setV0();
        v.setT(p);
    }

    private void filterFsgAtoms(BS bs) {
        int p = 0;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            this.asc.atoms[p] = this.asc.atoms[i];
            this.asc.atoms[p].index = p;
            ++p;
            i = bs.nextSetBit(i + 1);
        }
        this.asc.atomSetAtomCounts[0] = this.asc.ac = bs.cardinality();
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.asc.setNoAutoBond();
        this.applySymmetryAndSetTrajectory();
        this.addJmolScript("vectors on;vectors 0.15;");
        this.vibsFractional = true;
        int n = this.asc.getXSymmetry().setMagneticMoments(true);
        this.asc.getXSymmetry().getSymmetry().setPrecision(1.0E-4f);
        this.appendLoadNote(n + " magnetic moments - use VECTORS ON/OFF or VECTOR MAX x.x or SELECT VXYZ>0");
    }

    private Map<String, Object> getSCIFInfo(XtalSymmetry.FileSymmetry fs, Lst<String> spinList) {
        Hashtable<String, Object> m = new Hashtable<String, Object>();
        try {
            System.out.println("FSGOutput SSG_international_symbol=" + this.fullName);
            FSGOutputReader.mput(m, "SSG_international_symbol", this.fullName);
            System.out.println("FSGOutput simpleName=" + this.sgName);
            FSGOutputReader.mput(m, "simpleName", this.sgName);
            Integer msgNum = (Integer)this.json.get("MSG_num");
            System.out.println("FSGOutput MSG_num=" + msgNum);
            FSGOutputReader.mput(m, "MSG_num", msgNum);
            System.out.println("FSGOutput Configuration=" + this.configuration);
            FSGOutputReader.mput(m, "configuration", this.configuration);
            String gSymbol = (String)this.json.get("G_symbol");
            System.out.println("FSGOutput G_symbol=" + gSymbol);
            FSGOutputReader.mput(m, "G_Symbol", gSymbol);
            String g0Symbol = (String)this.json.get("G0_symbol");
            System.out.println("FSGOutput G0=" + g0Symbol);
            FSGOutputReader.mput(m, "G0_Symbol", g0Symbol);
            int pt = g0Symbol.indexOf(40);
            int g0ItaNo = Integer.parseInt(g0Symbol.substring(pt + 1, g0Symbol.length() - 1));
            String g0HMName = g0Symbol.substring(0, pt).trim();
            FSGOutputReader.mput(m, "G0_ItaNo", g0ItaNo);
            FSGOutputReader.mput(m, "G0_HMName", g0HMName);
            String l0Symbol = (String)this.json.get("L0_symbol");
            System.out.println("FSGOutput L0=" + l0Symbol);
            FSGOutputReader.mput(m, "L0_Symbol", l0Symbol);
            pt = l0Symbol.indexOf(40);
            int l0ItaNo = Integer.parseInt(l0Symbol.substring(pt + 1, l0Symbol.length() - 1));
            int ik = (Integer)this.json.get("ik");
            String fsgID = "" + l0ItaNo + "." + g0ItaNo + "." + ik + ".?";
            this.appendLoadNote("FSG ID " + fsgID);
            FSGOutputReader.mput(m, "fsgID", fsgID);
            System.out.println("fsgID=" + fsgID);
            boolean isPrimitive = g0HMName.charAt(0) == 'P';
            FSGOutputReader.mput(m, "G0_isPrimitive", isPrimitive);
            FSGOutputReader.mput(m, "G0_atomCount", this.asc.ac);
            System.out.println("FSGOutput G0_atomCount=" + this.asc.ac);
            Lst<Object> r0 = FSGOutputReader.getList(this.json, "transformation_matrix_ini_G0");
            Lst<Object> t0 = FSGOutputReader.getList(this.json, "origin_shift_ini_G0");
            M4 m2g0 = this.readMatrix(r0, t0);
            String abcm = SymmetryOperation.getTransformABC(m2g0, false);
            FSGOutputReader.mput(m, "msgTransform", abcm);
            this.asc.setCurrentModelInfo("unitcell_msg", abcm);
            this.symmetry.setUnitCellFromParams(this.unitCellParams, true, 1.0E-4f);
            this.spinFrame = this.calculateSpinFrame(this.readMatrix(FSGOutputReader.getList(this.json, "transformation_matrix_spin_cartesian_lattice_G0"), null));
            System.out.println("FSGOutput G0 spinFrame=" + this.spinFrame);
            this.addMoreUnitCellInfo("spinFrame=" + this.spinFrame);
            this.asc.setCurrentModelInfo("unitcell_spin", this.spinFrame);
            Lst<P3> spinLattice = fs.getLatticeCentering();
            Lst<String> lattice = SymmetryOperation.getLatticeCenteringStrings(fs.getSymmetryOperations());
            if (!lattice.isEmpty()) {
                lattice.add(0, "x,y,z(u,v,w)");
                FSGOutputReader.mput(m, "G0_spinLattice", lattice);
            }
            String abc = FSGOutputReader.calculateChildTransform(spinLattice);
            FSGOutputReader.mput(m, "childTransform", abc);
            System.out.println("FSGOutput G0_childTransform=" + abc);
            Lst<String> ops = new Lst<String>();
            SymmetryOperation[] symops = fs.getSymmetryOperations();
            for (int i = 0; i < this.firstTranslation; ++i) {
                ops.addLast(symops[i].getXyz(false));
            }
            if (spinList != null) {
                FSGOutputReader.mput(m, "G0_spinList", spinList);
                Hashtable<String, Integer> mapSpinToID = new Hashtable<String, Integer>();
                Lst<String> scifList = null;
                int[] scifListTimeRev = new int[spinList.size()];
                String newSpinFrame = this.convertToABC ? "a,b,c" : this.spinFrame;
                scifList = new Lst<String>();
                M4 msf = null;
                M4 msfInv = null;
                if (!this.spinFrame.equals(newSpinFrame)) {
                    msf = (M4)SymmetryOperation.staticConvertOperation(this.spinFrame, null, null);
                    msf.transpose();
                    msfInv = M4.newM4(msf);
                    msfInv.invert();
                }
                int n = spinList.size();
                for (int i = 0; i < n; ++i) {
                    int timeReversal;
                    String fsgOp = (String)spinList.get(i);
                    mapSpinToID.put(fsgOp, i);
                    M4 m4 = (M4)this.symmetry.convertTransform(fsgOp, null);
                    if (msf != null) {
                        m4.mul2(m4, msfInv);
                        m4.mul2(msf, m4);
                    }
                    String s = SymmetryOperation.getTransformUVW(m4);
                    System.out.println(s + "\t <- " + fsgOp);
                    scifList.addLast(s);
                    scifListTimeRev[i] = timeReversal = Math.round(m4.determinant3());
                }
                FSGOutputReader.mput(m, "spinFrame", newSpinFrame);
                FSGOutputReader.mput(m, "SCIF_spinList", scifList);
                FSGOutputReader.mput(m, "SCIF_spinListTR", scifListTimeRev);
                ops = this.setSCIFSpinLists(m, mapSpinToID, ops, this.firstTranslation, "G0_operationURefs");
                this.setSCIFSpinLists(m, mapSpinToID, lattice, lattice.size(), "G0_spinLatticeURefs");
            }
            FSGOutputReader.mput(m, "G0_operations", ops);
            FSGOutputReader.mput(m, "G0_operationCount", ops.size());
            System.out.println("FSGOutput G0_operationCount(w/o translations)=" + ops.size());
        }
        catch (Exception e) {
            FSGOutputReader.mput(m, "exception", e.toString());
            e.printStackTrace();
        }
        return m;
    }

    private int excludeAtoms(int i0, BS bs, XtalSymmetry.FileSymmetry fs) {
        int i = bs.nextSetBit(i0 + 1);
        while (i >= 0) {
            if (this.findSymop(i0, i, fs)) {
                bs.clear(i);
            }
            i = bs.nextSetBit(i + 1);
        }
        return bs.nextSetBit(i0 + 1);
    }

    private boolean findSymop(int i1, int i2, XtalSymmetry.FileSymmetry fs) {
        Atom a = this.asc.atoms[i1];
        Atom b = this.asc.atoms[i2];
        if (a.elementNumber != b.elementNumber) {
            return false;
        }
        this.p2.setP(b);
        this.symmetry.unitize(this.p2);
        this.symmetry.toCartesian(this.p2, true);
        SymmetryOperation[] ops = fs.getSymmetryOperations();
        int nops = fs.getSpaceGroupOperationCount();
        for (int i = 1; i < nops; ++i) {
            this.p1.setP(a);
            ops[i].rotTrans(this.p1);
            this.symmetry.unitize(this.p1);
            this.symmetry.toCartesian(this.p1, true);
            if (!((double)this.p1.distanceSquared(this.p2) < 0.01)) continue;
            return true;
        }
        return false;
    }

    private Lst<String> setSCIFSpinLists(Map<String, Object> m, Map<String, Integer> mapSpinToID, Lst<String> ops, int len, String key) {
        Lst<Integer> lst = new Lst<Integer>();
        Lst<String> lstOpsIncluded = new Lst<String>();
        int n = len;
        for (int i = 0; i < n; ++i) {
            String o = (String)ops.get(i);
            int pt = o.indexOf("(");
            String uvw = o.substring(pt + 1, o.indexOf(41, pt + 1));
            Integer ipt = mapSpinToID.get(uvw);
            lst.addLast(ipt);
            lstOpsIncluded.addLast(o);
        }
        int[] val = new int[lst.size()];
        int i = val.length;
        while (--i >= 0) {
            val[i] = (Integer)lst.get(i);
        }
        m.put(key, val);
        return lstOpsIncluded;
    }

    private static void mput(Map<String, Object> m, String key, Object val) {
        if (val != null) {
            m.put(key, val);
        }
    }

    private static String calculateChildTransform(Lst<P3> spinLattice) {
        if (spinLattice == null || spinLattice.isEmpty()) {
            return "a,b,c";
        }
        float minx = 1.0f;
        float miny = 1.0f;
        float minz = 1.0f;
        int i = spinLattice.size();
        while (--i >= 0) {
            P3 c = (P3)spinLattice.get(i);
            if (c.x > 0.0f && c.x < minx) {
                minx = c.x;
            }
            if (c.y > 0.0f && c.y < miny) {
                miny = c.y;
            }
            if (!(c.z > 0.0f) || !(c.z < minz)) continue;
            minz = c.z;
        }
        return (minx > 0.0f && minx < 1.0f ? "" + Math.round(1.0f / minx) : "") + "a," + (miny > 0.0f && miny < 1.0f ? "" + Math.round(1.0f / miny) : "") + "b," + (minz > 0.0f && minz < 1.0f ? "" + Math.round(1.0f / minz) : "") + "c";
    }

    private String calculateSpinFrame(M4 m4) {
        if (m4 == null) {
            m4 = new M4();
            P3 a1 = P3.new3(1.0f, 0.0f, 0.0f);
            P3 a2 = P3.new3(0.0f, 1.0f, 0.0f);
            P3 a3 = P3.new3(0.0f, 0.0f, 1.0f);
            this.symmetry.toFractional(a1, true);
            this.symmetry.toFractional(a2, true);
            this.symmetry.toFractional(a3, true);
            float d = a1.length();
            a1.normalize();
            a2.scale(1.0f / d);
            a3.scale(1.0f / d);
            m4.setColumn4(0, a1.x, a1.y, a1.z, 0.0f);
            m4.setColumn4(1, a2.x, a2.y, a2.z, 0.0f);
            m4.setColumn4(2, a3.x, a3.y, a3.z, 0.0f);
        } else {
            m4.invert();
        }
        return SymmetryOperation.getTransformABC(m4, false);
    }
}

