/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class RemoveExtraClosingTagIntentionAction
implements LocalQuickFix,
IntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = XmlAnalysisBundle.message((String)"xml.quickfix.remove.extra.closing.tag", (Object[])new Object[0]);
        if (string == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        PsiElement psiElement;
        if (project == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(2);
        }
        return (psiElement = psiFile.findElementAt(editor.getCaretModel().getOffset())) instanceof XmlToken && (psiElement.getParent() instanceof XmlTag || psiElement.getParent() instanceof PsiErrorElement);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(3);
        }
        RemoveExtraClosingTagIntentionAction.doFix(Objects.requireNonNull(psiFile.findElementAt(editor.getCaretModel().getOffset())).getParent());
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void doFix(@NotNull PsiElement tagElement) throws IncorrectOperationException {
        if (tagElement == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(4);
        }
        if (tagElement instanceof PsiErrorElement) {
            Collection outers = PsiTreeUtil.findChildrenOfType((PsiElement)tagElement, OuterLanguageElement.class);
            String replacement = StringUtil.join((Collection)outers, PsiElement::getText, (String)"");
            Document document = RemoveExtraClosingTagIntentionAction.getDocument(tagElement);
            if (document != null && !replacement.isEmpty()) {
                TextRange range = tagElement.getTextRange();
                document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replacement);
            } else {
                tagElement.delete();
            }
        } else {
            Document document;
            ASTNode endTagStart;
            ASTNode astNode = tagElement.getNode();
            if (astNode != null && (endTagStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(astNode)) != null && (document = RemoveExtraClosingTagIntentionAction.getDocument(tagElement)) != null) {
                document.deleteString(endTagStart.getStartOffset(), tagElement.getLastChild().getTextRange().getEndOffset());
            }
        }
    }

    private static Document getDocument(@NotNull PsiElement tagElement) {
        if (tagElement == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(5);
        }
        return tagElement.getContainingFile().getViewProvider().getDocument();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        if (project == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            RemoveExtraClosingTagIntentionAction.$$$reportNull$$$0(7);
        }
        if (!((element = descriptor.getPsiElement()) instanceof XmlToken)) {
            return;
        }
        RemoveExtraClosingTagIntentionAction.doFix(element.getParent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/htmlInspections/RemoveExtraClosingTagIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doFix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

