/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.PropertyDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.PropertyGetterDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.VariableDescriptorWithInitializerImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtPureElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.resolve.AnnotationResolver;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatedPropertyResolver;
import org.jetbrains.kotlin.resolve.DescriptorFactory;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.LateinitModifierApplicabilityChecker;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.VariableTypeAndInitializerResolver;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceSession;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.util.UnderscoreUtilKt;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingFacade;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J2\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ \u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u00172\u0006\u0010$\u001a\u00020\u0019H\u0002J0\u0010%\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u000200H\u0002J/\u00101\u001a\u0002022\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010&\u001a\u00020'2\b\u00103\u001a\u0004\u0018\u0001042\u0006\u0010,\u001a\u00020-H\u0000\u00a2\u0006\u0002\b5J\u0014\u00106\u001a\u00020!*\u0002072\u0006\u0010,\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/resolve/LocalVariableResolver;", "", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "annotationResolver", "Lorg/jetbrains/kotlin/resolve/AnnotationResolver;", "variableTypeAndInitializerResolver", "Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver;", "delegatedPropertyResolver", "Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "<init>", "(Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/resolve/AnnotationResolver;Lorg/jetbrains/kotlin/resolve/VariableTypeAndInitializerResolver;Lorg/jetbrains/kotlin/resolve/DelegatedPropertyResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;)V", "process", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "typingContext", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingFacade;", "checkLocalVariableDeclaration", "", "context", "descriptor", "ktProperty", "resolveLocalVariableDescriptor", "variable", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "inferenceSession", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "initializeWithDefaultGetterSetter", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/PropertyDescriptorImpl;", "resolveLocalVariableDescriptorWithType", "Lorg/jetbrains/kotlin/descriptors/impl/LocalVariableDescriptor;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolveLocalVariableDescriptorWithType$frontend", "updateAccessorFlagsFromResolvedCallForDelegatedProperty", "Lorg/jetbrains/kotlin/descriptors/VariableAccessorDescriptor;", "frontend"})
public final class LocalVariableResolver {
    @NotNull
    private final ModifiersChecker modifiersChecker;
    @NotNull
    private final IdentifierChecker identifierChecker;
    @NotNull
    private final DataFlowAnalyzer dataFlowAnalyzer;
    @NotNull
    private final AnnotationResolver annotationResolver;
    @NotNull
    private final VariableTypeAndInitializerResolver variableTypeAndInitializerResolver;
    @NotNull
    private final DelegatedPropertyResolver delegatedPropertyResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;

    public LocalVariableResolver(@NotNull ModifiersChecker modifiersChecker, @NotNull IdentifierChecker identifierChecker, @NotNull DataFlowAnalyzer dataFlowAnalyzer, @NotNull AnnotationResolver annotationResolver, @NotNull VariableTypeAndInitializerResolver variableTypeAndInitializerResolver, @NotNull DelegatedPropertyResolver delegatedPropertyResolver, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkNotNullParameter((Object)modifiersChecker, (String)"modifiersChecker");
        Intrinsics.checkNotNullParameter((Object)identifierChecker, (String)"identifierChecker");
        Intrinsics.checkNotNullParameter((Object)dataFlowAnalyzer, (String)"dataFlowAnalyzer");
        Intrinsics.checkNotNullParameter((Object)annotationResolver, (String)"annotationResolver");
        Intrinsics.checkNotNullParameter((Object)variableTypeAndInitializerResolver, (String)"variableTypeAndInitializerResolver");
        Intrinsics.checkNotNullParameter((Object)delegatedPropertyResolver, (String)"delegatedPropertyResolver");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)dataFlowValueFactory, (String)"dataFlowValueFactory");
        this.modifiersChecker = modifiersChecker;
        this.identifierChecker = identifierChecker;
        this.dataFlowAnalyzer = dataFlowAnalyzer;
        this.annotationResolver = annotationResolver;
        this.variableTypeAndInitializerResolver = variableTypeAndInitializerResolver;
        this.delegatedPropertyResolver = delegatedPropertyResolver;
        this.languageVersionSettings = languageVersionSettings;
        this.dataFlowValueFactory = dataFlowValueFactory;
    }

    @NotNull
    public final Pair<KotlinTypeInfo, VariableDescriptor> process(@NotNull KtProperty property2, @NotNull ExpressionTypingContext typingContext, @NotNull LexicalScope scope, @NotNull ExpressionTypingFacade facade) {
        KtPropertyAccessor setter;
        KtPropertyAccessor getter;
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)typingContext, (String)"typingContext");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        Object Context2 = ((ExpressionTypingContext)typingContext.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceScope(scope);
        Intrinsics.checkNotNullExpressionValue(Context2, (String)"replaceScope(...)");
        ExpressionTypingContext context = (ExpressionTypingContext)Context2;
        KtTypeReference receiverTypeRef = property2.getReceiverTypeReference();
        if (receiverTypeRef != null) {
            context.trace.report(Errors.LOCAL_EXTENSION_PROPERTY.on((KtTypeReference)((PsiElement)receiverTypeRef)));
        }
        if ((getter = property2.getGetter()) != null) {
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter)));
        }
        if ((setter = property2.getSetter()) != null) {
            context.trace.report(Errors.LOCAL_VARIABLE_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter)));
        }
        KtVariableDeclaration ktVariableDeclaration = (KtVariableDeclaration)property2;
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo, (String)"dataFlowInfo");
        InferenceSession inferenceSession = context.inferenceSession;
        Intrinsics.checkNotNullExpressionValue((Object)inferenceSession, (String)"inferenceSession");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        VariableDescriptor propertyDescriptor = this.resolveLocalVariableDescriptor(scope, ktVariableDeclaration, dataFlowInfo, inferenceSession, bindingTrace);
        KtExpression delegateExpression = property2.getDelegateExpression();
        if (delegateExpression != null) {
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.LocalDelegatedProperties)) {
                BindingTrace bindingTrace2 = context.trace;
                KtPropertyDelegate ktPropertyDelegate = property2.getDelegate();
                Intrinsics.checkNotNull((Object)ktPropertyDelegate);
                bindingTrace2.report(Errors.UNSUPPORTED_FEATURE.on((PsiElement)ktPropertyDelegate, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)LanguageFeature.LocalDelegatedProperties, (Object)this.languageVersionSettings)));
            }
            if (propertyDescriptor instanceof VariableDescriptorWithAccessors) {
                DataFlowInfo dataFlowInfo2 = typingContext.dataFlowInfo;
                Intrinsics.checkNotNullExpressionValue((Object)dataFlowInfo2, (String)"dataFlowInfo");
                VariableDescriptorWithAccessors variableDescriptorWithAccessors = (VariableDescriptorWithAccessors)propertyDescriptor;
                LexicalScope lexicalScope = typingContext.scope;
                Intrinsics.checkNotNullExpressionValue((Object)lexicalScope, (String)"scope");
                InferenceSession inferenceSession2 = typingContext.inferenceSession;
                Intrinsics.checkNotNullExpressionValue((Object)inferenceSession2, (String)"inferenceSession");
                BindingTrace bindingTrace3 = typingContext.trace;
                Intrinsics.checkNotNullExpressionValue((Object)bindingTrace3, (String)"trace");
                this.delegatedPropertyResolver.resolvePropertyDelegate(dataFlowInfo2, property2, variableDescriptorWithAccessors, delegateExpression, lexicalScope, inferenceSession2, bindingTrace3);
                VariableAccessorDescriptor variableAccessorDescriptor = ((VariableDescriptorWithAccessors)propertyDescriptor).getGetter();
                if (variableAccessorDescriptor != null) {
                    BindingTrace bindingTrace4 = typingContext.trace;
                    Intrinsics.checkNotNullExpressionValue((Object)bindingTrace4, (String)"trace");
                    this.updateAccessorFlagsFromResolvedCallForDelegatedProperty(variableAccessorDescriptor, bindingTrace4);
                }
                VariableAccessorDescriptor variableAccessorDescriptor2 = ((VariableDescriptorWithAccessors)propertyDescriptor).getSetter();
                if (variableAccessorDescriptor2 != null) {
                    BindingTrace bindingTrace5 = typingContext.trace;
                    Intrinsics.checkNotNullExpressionValue((Object)bindingTrace5, (String)"trace");
                    this.updateAccessorFlagsFromResolvedCallForDelegatedProperty(variableAccessorDescriptor2, bindingTrace5);
                }
            }
        }
        KtExpression initializer = property2.getInitializer();
        KotlinTypeInfo typeInfo = null;
        if (initializer != null) {
            KotlinType kotlinType = propertyDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            KotlinType outType = kotlinType;
            KotlinTypeInfo kotlinTypeInfo = facade.getTypeInfo(initializer, (ExpressionTypingContext)context.replaceExpectedType(outType));
            Intrinsics.checkNotNullExpressionValue((Object)kotlinTypeInfo, (String)"getTypeInfo(...)");
            typeInfo = kotlinTypeInfo;
            DataFlowInfo dataFlowInfo3 = typeInfo.getDataFlowInfo();
            KotlinType type = typeInfo.getType();
            if (type != null) {
                DataFlowValue initializerDataFlowValue = this.dataFlowValueFactory.createDataFlowValue(initializer, type, context);
                if (!propertyDescriptor.isVar() && initializerDataFlowValue.getCanBeBound()) {
                    context.trace.record(BindingContext.BOUND_INITIALIZER_VALUE, propertyDescriptor, initializerDataFlowValue);
                }
                if (property2.getTypeReference() == null) {
                    BindingContext bindingContext = context.trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
                    DataFlowValue variableDataFlowValue = this.dataFlowValueFactory.createDataFlowValueForProperty(property2, propertyDescriptor, bindingContext, DescriptorUtils.getContainingModuleOrNull(scope.getOwnerDescriptor()));
                    typeInfo = typeInfo.replaceDataFlowInfo(dataFlowInfo3.assign(variableDataFlowValue, initializerDataFlowValue, this.languageVersionSettings));
                }
            }
        } else {
            typeInfo = TypeInfoFactoryKt.noTypeInfo(context);
        }
        this.checkLocalVariableDeclaration(context, propertyDescriptor, property2);
        return new Pair((Object)typeInfo.replaceType(this.dataFlowAnalyzer.checkStatementType((KtExpression)property2, context)), (Object)propertyDescriptor);
    }

    private final void checkLocalVariableDeclaration(ExpressionTypingContext context, VariableDescriptor descriptor, KtProperty ktProperty) {
        ExpressionTypingUtils.checkVariableShadowing(context.scope, context.trace, descriptor);
        this.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration((KtDeclaration)ktProperty, descriptor);
        KtDeclaration ktDeclaration = (KtDeclaration)ktProperty;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"trace");
        this.identifierChecker.checkDeclaration(ktDeclaration, bindingTrace);
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace2, (String)"trace");
        LateinitModifierApplicabilityChecker.INSTANCE.checkLateinitModifierApplicability(bindingTrace2, (KtCallableDeclaration)ktProperty, descriptor);
    }

    private final VariableDescriptor resolveLocalVariableDescriptor(LexicalScope scope, KtVariableDeclaration variable, DataFlowInfo dataFlowInfo, InferenceSession inferenceSession, BindingTrace trace) {
        DeclarationDescriptor containingDeclaration = scope.getOwnerDescriptor();
        VariableDescriptorWithInitializerImpl result = null;
        KotlinType type = null;
        if (KtPsiUtil.isScriptDeclaration((KtDeclaration)((KtDeclaration)variable))) {
            PropertyDescriptorImpl propertyDescriptorImpl = PropertyDescriptorImpl.create(containingDeclaration, this.annotationResolver.resolveAnnotationsWithArguments(scope, variable.getModifierList(), trace), Modality.FINAL, DescriptorVisibilities.INTERNAL, variable.isVar(), KtPsiUtil.safeName((String)variable.getName()), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement((KtPureElement)variable), false, false, false, false, false, variable instanceof KtProperty && ((KtProperty)variable).hasDelegate());
            Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptorImpl, (String)"create(...)");
            PropertyDescriptorImpl propertyDescriptor = propertyDescriptorImpl;
            type = this.variableTypeAndInitializerResolver.resolveType(propertyDescriptor, scope, variable, dataFlowInfo, inferenceSession, trace, true);
            Intrinsics.checkNotNull((Object)containingDeclaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ScriptDescriptor");
            ReceiverParameterDescriptor receiverParameterDescriptor = ((ScriptDescriptor)containingDeclaration).getThisAsReceiverParameter();
            Intrinsics.checkNotNullExpressionValue((Object)receiverParameterDescriptor, (String)"getThisAsReceiverParameter(...)");
            ReceiverParameterDescriptor receiverParameter = receiverParameterDescriptor;
            propertyDescriptor.setType(type, CollectionsKt.emptyList(), receiverParameter, null, CollectionsKt.emptyList());
            this.initializeWithDefaultGetterSetter(propertyDescriptor);
            trace.record(BindingContext.VARIABLE, variable, propertyDescriptor);
            result = propertyDescriptor;
        } else {
            LocalVariableDescriptor variableDescriptor = this.resolveLocalVariableDescriptorWithType$frontend(scope, variable, null, trace);
            type = this.variableTypeAndInitializerResolver.resolveType(variableDescriptor, scope, variable, dataFlowInfo, inferenceSession, trace, true);
            variableDescriptor.setOutType(type);
            result = variableDescriptor;
        }
        if (inferenceSession instanceof BuilderInferenceSession) {
            ((BuilderInferenceSession)inferenceSession).addExpression((KtExpression)variable);
        }
        this.variableTypeAndInitializerResolver.setConstantForVariableIfNeeded(result, scope, variable, dataFlowInfo, type, inferenceSession, trace);
        ForceResolveUtil.forceResolveAllContents(type.getAnnotations());
        return result;
    }

    private final void initializeWithDefaultGetterSetter(PropertyDescriptorImpl propertyDescriptor) {
        PropertySetterDescriptor setter;
        PropertyGetterDescriptorImpl getter = propertyDescriptor.getGetter();
        if (getter == null && !DescriptorVisibilities.isPrivate(propertyDescriptor.getVisibility())) {
            getter = DescriptorFactory.createDefaultGetter(propertyDescriptor, Annotations.Companion.getEMPTY());
            getter.initialize(propertyDescriptor.getType());
        }
        if ((setter = propertyDescriptor.getSetter()) == null && propertyDescriptor.isVar()) {
            setter = DescriptorFactory.createDefaultSetter(propertyDescriptor, Annotations.Companion.getEMPTY(), Annotations.Companion.getEMPTY());
        }
        propertyDescriptor.initialize(getter, setter);
    }

    @NotNull
    public final LocalVariableDescriptor resolveLocalVariableDescriptorWithType$frontend(@NotNull LexicalScope scope, @NotNull KtVariableDeclaration variable, @Nullable KotlinType type, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        boolean hasDelegate = variable instanceof KtProperty && ((KtProperty)variable).hasDelegate();
        boolean hasLateinit = variable.hasModifier(KtTokens.LATEINIT_KEYWORD);
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(scope.getOwnerDescriptor(), this.annotationResolver.resolveAnnotationsWithArguments(scope, variable.getModifierList(), trace), UnderscoreUtilKt.isSingleUnderscore((KtNamedDeclaration)variable) ? Name.special((String)"<underscore local var>") : KtPsiUtil.safeName((String)variable.getName()), type, variable.isVar(), hasDelegate, hasLateinit, KotlinSourceElementKt.toSourceElement((KtPureElement)variable));
        trace.record(BindingContext.VARIABLE, variable, variableDescriptor);
        return variableDescriptor;
    }

    private final void updateAccessorFlagsFromResolvedCallForDelegatedProperty(VariableAccessorDescriptor $this$updateAccessorFlagsFromResolvedCallForDelegatedProperty, BindingTrace trace) {
        if ($this$updateAccessorFlagsFromResolvedCallForDelegatedProperty instanceof FunctionDescriptorImpl) {
            FunctionDescriptor resultingDescriptor;
            ResolvedCall resolvedCall2 = (ResolvedCall)trace.getBindingContext().get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, $this$updateAccessorFlagsFromResolvedCallForDelegatedProperty);
            FunctionDescriptor functionDescriptor = resultingDescriptor = resolvedCall2 != null ? (FunctionDescriptor)resolvedCall2.getResultingDescriptor() : null;
            if (resultingDescriptor != null) {
                ((FunctionDescriptorImpl)((Object)$this$updateAccessorFlagsFromResolvedCallForDelegatedProperty)).setSuspend(resultingDescriptor.isSuspend());
            }
        }
    }
}

