/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.util.DefaultLanguageService;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public interface LanguageUtilities {
    public static Set<LanguageCompilerSpecPair> getAllPairsForLanguages(Set<LanguageID> languageIDs) throws LanguageNotFoundException {
        LinkedHashSet<LanguageCompilerSpecPair> result = new LinkedHashSet<LanguageCompilerSpecPair>();
        LanguageService langServ = DefaultLanguageService.getLanguageService();
        for (LanguageID lid : languageIDs) {
            Language l = langServ.getLanguage(lid);
            for (CompilerSpecDescription csd : l.getCompatibleCompilerSpecDescriptions()) {
                result.add(new LanguageCompilerSpecPair(lid, csd.getCompilerSpecID()));
            }
        }
        return result;
    }

    public static Set<LanguageCompilerSpecPair> getAllPairsForLanguage(LanguageID language) throws LanguageNotFoundException {
        return LanguageUtilities.getAllPairsForLanguages(Collections.singleton(language));
    }
}

