/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.colorizer;

import ghidra.app.plugin.core.colorizer.ColorizingService;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import java.awt.Color;

class SetColorCommand
implements Command<DomainObject> {
    private final Color color;
    private final AddressSetView set;
    private final ColorizingService colorizingService;

    SetColorCommand(Color color, ColorizingService colorizingService, Program program, Address address) {
        this.color = color;
        this.colorizingService = colorizingService;
        AddressSet newSet = new AddressSet();
        newSet.add(address);
        this.set = newSet;
    }

    SetColorCommand(Color color, ColorizingService colorizingService, AddressSetView set) {
        this.color = color;
        this.set = set;
        this.colorizingService = colorizingService;
    }

    public boolean applyTo(DomainObject obj) {
        this.colorizingService.setBackgroundColor(this.set, this.color);
        return true;
    }

    public String getStatusMsg() {
        return null;
    }

    public String getName() {
        return "Set Background Color";
    }
}

