/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractLabelMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DirectSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.DisassembleableAddressSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.FunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestableSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestingSymbolApplier;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.regex.Matcher;

public class LabelSymbolApplier
extends MsSymbolApplier
implements DirectSymbolApplier,
NestableSymbolApplier,
DisassembleableAddressSymbolApplier {
    private AbstractLabelMsSymbol symbol;

    public LabelSymbolApplier(DefaultPdbApplicator applicator, AbstractLabelMsSymbol symbol) {
        super(applicator);
        this.symbol = symbol;
    }

    @Override
    public void apply(MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        String label = this.symbol.getName();
        Address symbolAddress = this.applicator.getAddress(this.symbol);
        if (this.applicator.isInvalidAddress(symbolAddress, label)) {
            return;
        }
        if (this.hasFunctionIndication()) {
            this.applyFunction(symbolAddress, label, this.applicator.getCancelOnlyWrappingMonitor());
        } else {
            this.applicator.createSymbol(symbolAddress, label, false);
        }
    }

    @Override
    public Address getAddressForDisassembly() {
        return this.applicator.getAddress(this.symbol);
    }

    @Override
    public void applyTo(NestingSymbolApplier applyToApplier, MsSymbolIterator iter) throws PdbException, CancelledException {
        FunctionSymbolApplier functionSymbolApplier;
        Function f;
        this.getValidatedSymbol(iter, true);
        String label = this.getLabel();
        if (label == null) {
            return;
        }
        Address symbolAddress = this.applicator.getAddress(this.symbol);
        if (this.applicator.isInvalidAddress(symbolAddress, label)) {
            return;
        }
        if (applyToApplier instanceof FunctionSymbolApplier && (f = (functionSymbolApplier = (FunctionSymbolApplier)applyToApplier).getFunction()) != null && !f.getName().equals(label)) {
            label = NamespaceUtils.getNamespaceQualifiedName((Namespace)f, (String)label, (boolean)true);
        }
        this.applicator.createSymbol(symbolAddress, label, false);
    }

    private boolean hasFunctionIndication() {
        return this.symbol.getFlags().hasFunctionIndication();
    }

    private boolean isNonReturning() {
        return this.symbol.getFlags().doesNotReturn();
    }

    private boolean hasCustomCallingConvention() {
        return this.symbol.getFlags().hasCustomCallingConvention();
    }

    private boolean applyFunction(Address address, String name, TaskMonitor monitor) {
        this.applicator.createSymbol(address, name, false);
        Function function = this.applicator.getExistingOrCreateOneByteFunction(address);
        if (function == null) {
            return false;
        }
        if (!function.isThunk() && function.getSignatureSource().isLowerPriorityThan(SourceType.IMPORTED)) {
            function.setNoReturn(this.isNonReturning());
            if (this.hasCustomCallingConvention()) {
                // empty if block
            }
        }
        return true;
    }

    private String getLabel() {
        if (!this.applicator.getPdbApplicatorOptions().applyInstructionLabels()) {
            return null;
        }
        String label = this.symbol.getName();
        Matcher m = this.applicator.getPdbApplicatorOptions().excludeInstructionLabelsPattern().matcher(label);
        if (m.find()) {
            return null;
        }
        return label;
    }

    private AbstractLabelMsSymbol getValidatedSymbol(MsSymbolIterator iter, boolean iterate) {
        AbstractMsSymbol abstractSymbol;
        AbstractMsSymbol abstractMsSymbol = abstractSymbol = iterate ? iter.next() : iter.peek();
        if (!(abstractSymbol instanceof AbstractLabelMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        AbstractLabelMsSymbol labelSymbol = (AbstractLabelMsSymbol)abstractSymbol;
        return labelSymbol;
    }
}

