/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.view.swing.map.outline.BlockPanel;
import org.freeplane.view.swing.map.outline.BreadcrumbMode;
import org.freeplane.view.swing.map.outline.BreadcrumbPanel;
import org.freeplane.view.swing.map.outline.NodeButton;
import org.freeplane.view.swing.map.outline.OutlineController;
import org.freeplane.view.swing.map.outline.OutlineGeometry;
import org.freeplane.view.swing.map.outline.OutlineSelection;
import org.freeplane.view.swing.map.outline.ScrollableTreePanel;
import org.freeplane.view.swing.map.outline.TreeNode;

final class SelectionPainter {
    private SelectionPainter() {
    }

    static void paintForBlockPanel(BlockPanel panel, ScrollableTreePanel parentPanel, OutlineSelection selection, Graphics g) {
        if (panel == null || parentPanel == null || selection == null || g == null) {
            return;
        }
        for (Component comp : panel.getComponents()) {
            boolean allowBreadcrumbOverlap;
            NodeButton btn;
            TreeNode node;
            if (!(comp instanceof NodeButton) || (node = (btn = (NodeButton)comp).getNode()) == null || !selection.isSelected(node) || !(allowBreadcrumbOverlap = parentPanel.isSelectionDrivenBreadcrumbMode()) && parentPanel.isNodeInBreadcrumbArea(node)) continue;
            SelectionPainter.paintSelection(g, panel, btn);
        }
    }

    private static void paintSelection(Graphics g, Component panel, Component btn) {
        g.setColor(ResourceController.getResourceController().getColorProperty("standardselectednoderectanglecolor"));
        ((Graphics2D)g).setStroke(new BasicStroke(3.0f));
        int y1 = Math.max(0, btn.getY() + 2);
        int y2 = Math.min(panel.getHeight() - 1, btn.getY() + OutlineGeometry.getInstance().rowHeight - 1);
        if (btn.hasFocus()) {
            int x1 = btn.getX();
            g.drawRoundRect(x1, y1, btn.getWidth(), y2 - y1, 5, 5);
        } else {
            g.drawLine(0, y1, panel.getWidth(), y1);
            g.drawLine(0, y2, panel.getWidth(), y2);
        }
    }

    static void paintForBreadcrumbPanel(BreadcrumbPanel panel, OutlineController controller, OutlineSelection selection, Graphics g) {
        if (panel == null || controller == null || selection == null || g == null) {
            return;
        }
        if (controller.getBreadcrumbMode() == BreadcrumbMode.FOLLOW_SELECTED_ITEM) {
            return;
        }
        for (Component comp : panel.getComponents()) {
            NodeButton btn;
            TreeNode node;
            if (!(comp instanceof NodeButton) || (node = (btn = (NodeButton)comp).getNode()) == null || !selection.isSelected(node)) continue;
            SelectionPainter.paintSelection(g, panel, btn);
        }
    }
}

