/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_7_2;

import java.util.List;
import org.virtualbox_7_2.Helper;
import org.virtualbox_7_2.IEventSource;
import org.virtualbox_7_2.IUnknown;
import org.virtualbox_7_2.ObjectRefManager;
import org.virtualbox_7_2.ProcessInputFlag;
import org.virtualbox_7_2.ProcessStatus;
import org.virtualbox_7_2.ProcessWaitForFlag;
import org.virtualbox_7_2.ProcessWaitResult;
import org.virtualbox_7_2.VBoxException;
import org.virtualbox_7_2.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_7_2.jaxws.RuntimeFaultMsg;
import org.virtualbox_7_2.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IProcess
extends IUnknown {
    public IProcess(String string, ObjectRefManager objectRefManager, VboxPortType vboxPortType) {
        super(string, objectRefManager, vboxPortType);
    }

    public List<String> getArguments() {
        try {
            List<String> list = this.port.iProcessGetArguments(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<String> getEnvironment() {
        try {
            List<String> list = this.port.iProcessGetEnvironment(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IEventSource getEventSource() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iProcessGetEventSource(this.obj);
            IEventSource iEventSource = string.length() > 0 ? new IEventSource(string, this.getObjMgr(), this.port) : null;
            return iEventSource;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public String getExecutablePath() {
        try {
            String string = this.port.iProcessGetExecutablePath(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Integer getExitCode() {
        try {
            Integer n = this.port.iProcessGetExitCode(this.obj);
            return n;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getName() {
        try {
            String string = this.port.iProcessGetName(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getPID() {
        try {
            Long l = this.port.iProcessGetPID(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public ProcessStatus getStatus() {
        try {
            org.virtualbox_7_2.jaxws.ProcessStatus processStatus = this.port.iProcessGetStatus(this.obj);
            return ProcessStatus.fromValue(processStatus.value());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public static IProcess queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new IProcess(iUnknown.getWrapped(), iUnknown.getObjMgr(), iUnknown.getRemoteWSPort());
    }

    public ProcessWaitResult waitFor(Long l, Long l2) {
        try {
            org.virtualbox_7_2.jaxws.ProcessWaitResult processWaitResult = this.port.iProcessWaitFor(this.obj, l, l2);
            return ProcessWaitResult.fromValue(processWaitResult.value());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public ProcessWaitResult waitForArray(List<ProcessWaitForFlag> list, Long l) {
        try {
            org.virtualbox_7_2.jaxws.ProcessWaitResult processWaitResult = this.port.iProcessWaitForArray(this.obj, Helper.convertEnums(ProcessWaitForFlag.class, org.virtualbox_7_2.jaxws.ProcessWaitForFlag.class, list), l);
            return ProcessWaitResult.fromValue(processWaitResult.value());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public byte[] read(Long l, Long l2, Long l3) {
        try {
            String string = this.port.iProcessRead(this.obj, l, l2, l3);
            return Helper.decodeBase64(string);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long write(Long l, Long l2, byte[] byArray, Long l3) {
        try {
            Long l4 = this.port.iProcessWrite(this.obj, l, l2, Helper.encodeBase64(byArray), l3);
            return l4;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long writeArray(Long l, List<ProcessInputFlag> list, byte[] byArray, Long l2) {
        try {
            Long l3 = this.port.iProcessWriteArray(this.obj, l, Helper.convertEnums(ProcessInputFlag.class, org.virtualbox_7_2.jaxws.ProcessInputFlag.class, list), Helper.encodeBase64(byArray), l2);
            return l3;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void terminate() {
        try {
            this.port.iProcessTerminate(this.obj);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }
}

