# ActorStats
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-3)</span>

Provides functions that expose statistics about the current actor. All
methods will return '0' if the runtime used the program wasn't compiled with
runtime statistics turned on.


```pony
primitive val ActorStats
```

## Constructors

### create
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-3)</span>


```pony
new val create()
: ActorStats val^
```

#### Returns

* [ActorStats](runtime_info-ActorStats.md) val^

---

## Public Functions

### heap_mem_allocated
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-10)</span>


Returns the memory currently allocated by objects on the current actor's heap


```pony
fun box heap_mem_allocated(
  auth: ActorStatsAuth val)
: USize val
```
#### Parameters

*   auth: [ActorStatsAuth](runtime_info-ActorStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### heap_mem_used
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-18)</span>


Returns the memory currently used by objects on the current actor's heap


```pony
fun box heap_mem_used(
  auth: ActorStatsAuth val)
: USize val
```
#### Parameters

*   auth: [ActorStatsAuth](runtime_info-ActorStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### heap_num_allocated
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-26)</span>


Returns the number of objects currently on the current actor's heap


```pony
fun box heap_num_allocated(
  auth: ActorStatsAuth val)
: USize val
```
#### Parameters

*   auth: [ActorStatsAuth](runtime_info-ActorStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### heap_realloc_counter
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-34)</span>


Returns the number of heap re-allocations made on the current actor's heap during
the lifetime of the actor


```pony
fun box heap_realloc_counter(
  auth: ActorStatsAuth val)
: USize val
```
#### Parameters

*   auth: [ActorStatsAuth](runtime_info-ActorStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### heap_alloc_counter
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-43)</span>


Returns the number of heap allocations made on the current actor's heap during
the lifetime of the actor


```pony
fun box heap_alloc_counter(
  auth: ActorStatsAuth val)
: USize val
```
#### Parameters

*   auth: [ActorStatsAuth](runtime_info-ActorStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### heap_free_counter
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-52)</span>


Returns the number of heap allocations freed on the current actor's heap during
the lifetime of the actor


```pony
fun box heap_free_counter(
  auth: ActorStatsAuth val)
: USize val
```
#### Parameters

*   auth: [ActorStatsAuth](runtime_info-ActorStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### heap_gc_counter
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-61)</span>


Returns the number of times the current actor's heap has been garbage collected


```pony
fun box heap_gc_counter(
  auth: ActorStatsAuth val)
: USize val
```
#### Parameters

*   auth: [ActorStatsAuth](runtime_info-ActorStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### system_cpu
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-69)</span>


Returns the amount of cpu the current actor has used to process system messages


```pony
fun box system_cpu(
  auth: ActorStatsAuth val)
: USize val
```
#### Parameters

*   auth: [ActorStatsAuth](runtime_info-ActorStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### app_cpu
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-77)</span>


Returns the amount of cpu the current actor has used to process app messages


```pony
fun box app_cpu(
  auth: ActorStatsAuth val)
: USize val
```
#### Parameters

*   auth: [ActorStatsAuth](runtime_info-ActorStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### gc_mark_cpu
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-85)</span>


Returns the amount of cpu the current actor has used for mark phase to garbage collect its heap


```pony
fun box gc_mark_cpu(
  auth: ActorStatsAuth val)
: USize val
```
#### Parameters

*   auth: [ActorStatsAuth](runtime_info-ActorStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### gc_sweep_cpu
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-93)</span>


Returns the amount of cpu the current actor has used for sweep phase to garbage collect its heap


```pony
fun box gc_sweep_cpu(
  auth: ActorStatsAuth val)
: USize val
```
#### Parameters

*   auth: [ActorStatsAuth](runtime_info-ActorStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### messages_sent_counter
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-101)</span>


Returns the number of messages the current actor has sent


```pony
fun box messages_sent_counter(
  auth: ActorStatsAuth val)
: USize val
```
#### Parameters

*   auth: [ActorStatsAuth](runtime_info-ActorStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### system_messages_processed_counter
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-109)</span>


Returns the number of system messages the current actor has processed


```pony
fun box system_messages_processed_counter(
  auth: ActorStatsAuth val)
: USize val
```
#### Parameters

*   auth: [ActorStatsAuth](runtime_info-ActorStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### app_messages_processed_counter
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-117)</span>


Returns the number of app messages the current actor has processed


```pony
fun box app_messages_processed_counter(
  auth: ActorStatsAuth val)
: USize val
```
#### Parameters

*   auth: [ActorStatsAuth](runtime_info-ActorStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### eq
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-10)</span>


```pony
fun box eq(
  that: ActorStats val)
: Bool val
```
#### Parameters

*   that: [ActorStats](runtime_info-ActorStats.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/runtime_info/actor_stats.md#L-0-10)</span>


```pony
fun box ne(
  that: ActorStats val)
: Bool val
```
#### Parameters

*   that: [ActorStats](runtime_info-ActorStats.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

