/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.ubrex;

import com.plantuml.ubrex.Capture;
import java.util.List;

public class ChallengeResult {
    private final int fullCaptureLength;
    private final int onlyNameLength;
    private final Capture capture;
    private final Capture nonMergeableCapture;

    public String toString() {
        return "fullCaptureLength=" + this.fullCaptureLength + " onlyNameLength=" + this.onlyNameLength + " " + this.capture;
    }

    public ChallengeResult(int result) {
        this(result, Capture.EMPTY);
    }

    public ChallengeResult(int fullCaptureLength, Capture capture) {
        this.fullCaptureLength = fullCaptureLength;
        this.onlyNameLength = fullCaptureLength;
        this.capture = capture;
        this.nonMergeableCapture = Capture.EMPTY;
    }

    private ChallengeResult(int onlyNameLength, int fullCaptureLength, Capture capture, Capture nonMergeableCapture) {
        this.onlyNameLength = onlyNameLength;
        this.fullCaptureLength = fullCaptureLength;
        this.capture = capture;
        this.nonMergeableCapture = nonMergeableCapture;
    }

    public ChallengeResult withNameLength(int onlyNameLength, Capture nonMergeableCapture) {
        return new ChallengeResult(onlyNameLength, this.fullCaptureLength, this.capture, nonMergeableCapture);
    }

    public int getFullCaptureLength() {
        return this.fullCaptureLength;
    }

    public List<String> findValuesByKey(String path) {
        return this.capture.findValuesByKey(path);
    }

    public List<String> getKeysToBeRefactored() {
        return this.capture.getKeysToBeRefactored();
    }

    public Capture getCapture() {
        return this.capture;
    }

    public int getOnlyNameLength() {
        return this.onlyNameLength;
    }

    public Capture getNonMergeableCapture() {
        return this.nonMergeableCapture;
    }
}

