/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.Identifiable;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.NestedCollection;
import io.jsonwebtoken.lang.Strings;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class NestedIdentifiableCollection<E extends Identifiable, P>
implements NestedCollection<E, P> {
    private final P PARENT;
    private final Map<String, E> VALUES;

    private static <K, V> Map<K, V> nullSafe(Map<K, V> m) {
        return m == null ? Collections.emptyMap() : m;
    }

    public NestedIdentifiableCollection(P parent, Map<String, ? extends E> seed) {
        this.PARENT = Assert.notNull(parent, (String)"parent cannot be null.");
        this.VALUES = new LinkedHashMap<String, E>(NestedIdentifiableCollection.nullSafe(seed));
    }

    protected final String assertId(E i) {
        Assert.notNull(i, (String)"Identifiable instance cannot be null.");
        String id = i.getId();
        if (!Strings.hasText((String)id)) {
            String msg = i.getClass() + " getId() cannot be null or empty.";
            throw new IllegalArgumentException(msg);
        }
        return id;
    }

    private boolean doAdd(E e) {
        String id = this.assertId(e);
        this.VALUES.put(id, e);
        return true;
    }

    public NestedCollection<E, P> add(E e) {
        if (e != null) {
            this.doAdd(e);
            this.changed();
        }
        return this;
    }

    public NestedCollection<E, P> remove(E e) {
        String id;
        Identifiable previous;
        if (e != null && (previous = (Identifiable)this.VALUES.remove(id = this.assertId(e))) != null) {
            this.changed();
        }
        return this;
    }

    public NestedCollection<E, P> clear() {
        if (!Collections.isEmpty(this.VALUES)) {
            this.VALUES.clear();
            this.changed();
        }
        return this;
    }

    public NestedCollection<E, P> add(Collection<? extends E> c) {
        boolean changed = false;
        for (Identifiable element : Collections.nullSafe(c)) {
            changed = this.doAdd(element) || changed;
        }
        if (changed) {
            this.changed();
        }
        return this;
    }

    public P and() {
        return this.PARENT;
    }

    protected void changed() {
    }

    protected final Map<String, E> getValues() {
        return Collections.immutable(this.VALUES);
    }
}

