/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.ExternallyTaggedUnion;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.AggregateBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

public abstract class SingleBucketAggregateBase
extends AggregateBase {
    @Nonnull
    private final Map<String, Aggregate> aggregations;
    private final long docCount;

    protected SingleBucketAggregateBase(AbstractBuilder<?> builder) {
        super(builder);
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.docCount = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).docCount, this, "docCount");
    }

    @Nonnull
    public final Map<String, Aggregate> aggregations() {
        return this.aggregations;
    }

    public final long docCount() {
        return this.docCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        ExternallyTaggedUnion.serializeTypedKeysInner(this.aggregations, generator, mapper);
        generator.writeKey("doc_count");
        generator.write(this.docCount);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSingleBucketAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        SingleBucketAggregateBase.setupAggregateBaseDeserializer(op);
        op.add(AbstractBuilder::docCount, JsonpDeserializer.longDeserializer(), "doc_count");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (builder.aggregations == null) {
                builder.aggregations = new HashMap<String, Aggregate>();
            }
            Aggregate._TYPED_KEYS_DESERIALIZER.deserializeEntry((String)name, (JsonParser)parser, (JsonpMapper)mapper, builder.aggregations);
        });
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.aggregations);
        result = 31 * result + Long.hashCode(this.docCount);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleBucketAggregateBase other = (SingleBucketAggregateBase)o;
        return Objects.equals(this.aggregations, other.aggregations) && this.docCount == other.docCount;
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregateBase.AbstractBuilder<BuilderT> {
        private Long docCount;
        @Nullable
        protected Map<String, Aggregate> aggregations;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(SingleBucketAggregateBase o) {
            super(o);
            this.aggregations = AbstractBuilder._mapCopy(o.aggregations);
            this.docCount = o.docCount;
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            super(o);
            this.aggregations = AbstractBuilder._mapCopy(o.aggregations);
            this.docCount = o.docCount;
        }

        @Nonnull
        public final BuilderT aggregations(Map<String, Aggregate> map) {
            this.aggregations = AbstractBuilder._mapPutAll(this.aggregations, map);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT aggregations(String key, Aggregate value) {
            this.aggregations = AbstractBuilder._mapPut(this.aggregations, key, value);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT aggregations(String key, Function<Aggregate.Builder, ObjectBuilder<Aggregate>> fn) {
            return this.aggregations(key, fn.apply(new Aggregate.Builder()).build());
        }

        @Nonnull
        public final BuilderT docCount(long value) {
            this.docCount = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

