/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.response.agg;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.opensearch.common.document.DocumentField;
import org.opensearch.search.SearchHit;
import org.opensearch.search.aggregations.Aggregation;
import org.opensearch.search.aggregations.metrics.TopHits;
import org.opensearch.sql.opensearch.response.agg.MetricParser;

public class TopHitsParser
implements MetricParser {
    private final String name;
    private final boolean returnSingleValue;
    private final boolean returnMergeValue;

    public TopHitsParser(String name, boolean returnSingleValue, boolean returnMergeValue) {
        this.name = name;
        this.returnSingleValue = returnSingleValue;
        this.returnMergeValue = returnMergeValue;
    }

    @Override
    public List<Map<String, Object>> parse(Aggregation agg) {
        TopHits topHits = (TopHits)agg;
        SearchHit[] hits = topHits.getHits().getHits();
        if (hits.length == 0) {
            return Collections.singletonList(new HashMap<String, Object>(Collections.singletonMap(agg.getName(), null)));
        }
        if (this.returnSingleValue) {
            if (hits[0].getFields() == null || hits[0].getFields().isEmpty()) {
                return Collections.singletonList(new HashMap<String, Object>(Collections.singletonMap(agg.getName(), null)));
            }
            Object value = ((DocumentField)hits[0].getFields().values().iterator().next()).getValue();
            return Collections.singletonList(new HashMap<String, Object>(Collections.singletonMap(agg.getName(), value)));
        }
        if (this.returnMergeValue) {
            if (hits[0].getFields() == null || hits[0].getFields().isEmpty()) {
                return Collections.singletonList(new HashMap(Collections.singletonMap(agg.getName(), Collections.emptyList())));
            }
            return Collections.singletonList(Collections.singletonMap(agg.getName(), Arrays.stream(hits).flatMap(h -> h.getFields().values().stream()).map(DocumentField::getValue).filter(Objects::nonNull).collect(Collectors.toList())));
        }
        return Arrays.stream(hits).map(hit -> new LinkedHashMap(hit.getSourceAsMap())).toList();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopHitsParser)) {
            return false;
        }
        TopHitsParser other = (TopHitsParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.returnSingleValue != other.returnSingleValue) {
            return false;
        }
        if (this.returnMergeValue != other.returnMergeValue) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TopHitsParser;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.returnSingleValue ? 79 : 97);
        result = result * 59 + (this.returnMergeValue ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getName() {
        return this.name;
    }
}

