/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.http.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import java.util.List;
import org.opensearch.common.Booleans;
import org.opensearch.http.netty4.Netty4HttpResponse;
import org.opensearch.transport.NettyAllocator;

@ChannelHandler.Sharable
class Netty4HttpResponseCreator
extends MessageToMessageEncoder<Netty4HttpResponse> {
    private static final String DO_NOT_SPLIT = "opensearch.unsafe.do_not_split_http_responses";
    private static final boolean DO_NOT_SPLIT_HTTP_RESPONSES = Booleans.parseBoolean((String)System.getProperty("opensearch.unsafe.do_not_split_http_responses"), (boolean)false);
    private static final int SPLIT_THRESHOLD = (int)((double)NettyAllocator.suggestedMaxAllocationSize() * 0.99);

    Netty4HttpResponseCreator() {
    }

    protected void encode(ChannelHandlerContext ctx, Netty4HttpResponse msg, List<Object> out) {
        if (DO_NOT_SPLIT_HTTP_RESPONSES || msg.content().readableBytes() <= SPLIT_THRESHOLD) {
            out.add(msg.retain());
        } else {
            DefaultHttpResponse response = new DefaultHttpResponse(msg.protocolVersion(), msg.status(), msg.headers());
            out.add(response);
            ByteBuf content = msg.content();
            while (content.readableBytes() > SPLIT_THRESHOLD) {
                out.add(new DefaultHttpContent(content.readRetainedSlice(SPLIT_THRESHOLD)));
            }
            out.add(new DefaultLastHttpContent(content.readRetainedSlice(content.readableBytes())));
        }
    }
}

