/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.comparators;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FixedOrderComparator<T>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 82794675842863201L;
    private final Map<T, Integer> map = new HashMap<T, Integer>();
    private int counter;
    private boolean isLocked;
    private UnknownObjectBehavior unknownObjectBehavior = UnknownObjectBehavior.EXCEPTION;

    public FixedOrderComparator() {
    }

    public FixedOrderComparator(List<T> items) {
        for (T t2 : Objects.requireNonNull(items, "items")) {
            this.add(t2);
        }
    }

    public FixedOrderComparator(T ... items) {
        for (T item : Objects.requireNonNull(items, "items")) {
            this.add(item);
        }
    }

    public boolean add(T obj) {
        this.checkLocked();
        Integer position = this.map.put(obj, this.counter++);
        return position == null;
    }

    public boolean addAsEqual(T existingObj, T newObj) {
        this.checkLocked();
        Integer position = this.map.get(existingObj);
        if (position == null) {
            throw new IllegalArgumentException(existingObj + " not known to " + this);
        }
        Integer result = this.map.put(newObj, position);
        return result == null;
    }

    protected void checkLocked() {
        if (this.isLocked()) {
            throw new UnsupportedOperationException("Cannot modify a FixedOrderComparator after a comparison");
        }
    }

    @Override
    public int compare(T obj1, T obj2) {
        this.isLocked = true;
        Integer position1 = this.map.get(obj1);
        Integer position2 = this.map.get(obj2);
        if (position1 == null || position2 == null) {
            switch (this.unknownObjectBehavior.ordinal()) {
                case 0: {
                    return position1 == null ? (position2 == null ? 0 : -1) : 1;
                }
                case 1: {
                    return position1 == null ? (position2 == null ? 0 : 1) : -1;
                }
                case 2: {
                    T unknownObj = position1 == null ? obj1 : obj2;
                    throw new IllegalArgumentException("Attempting to compare unknown object " + unknownObj);
                }
            }
            throw new UnsupportedOperationException("Unknown unknownObjectBehavior: " + (Object)((Object)this.unknownObjectBehavior));
        }
        return position1.compareTo(position2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FixedOrderComparator other = (FixedOrderComparator)obj;
        return this.counter == other.counter && this.isLocked == other.isLocked && Objects.equals(this.map, other.map) && this.unknownObjectBehavior == other.unknownObjectBehavior;
    }

    public UnknownObjectBehavior getUnknownObjectBehavior() {
        return this.unknownObjectBehavior;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.counter, this.isLocked, this.map, this.unknownObjectBehavior});
    }

    public boolean isLocked() {
        return this.isLocked;
    }

    public void setUnknownObjectBehavior(UnknownObjectBehavior unknownObjectBehavior) {
        this.checkLocked();
        this.unknownObjectBehavior = Objects.requireNonNull(unknownObjectBehavior, "unknownObjectBehavior");
    }

    public static enum UnknownObjectBehavior {
        BEFORE,
        AFTER,
        EXCEPTION;

    }
}

