/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.jdbc;

import java.util.Arrays;
import java.util.Collections;
import org.hibernate.engine.jdbc.mutation.internal.MutationQueryOptions;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.mutation.EntityMutationTarget;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.internal.OptionalTableInsert;
import org.hibernate.sql.model.internal.OptionalTableUpdate;
import org.hibernate.sql.model.jdbc.JdbcMutationOperation;
import org.hibernate.sql.model.jdbc.OptionalTableUpdateOperation;

public class OptionalTableUpdateWithUpsertOperation
extends OptionalTableUpdateOperation {
    public OptionalTableUpdateWithUpsertOperation(EntityMutationTarget mutationTarget, OptionalTableUpdate upsert, SessionFactoryImplementor factory) {
        super(mutationTarget, upsert, factory);
    }

    @Override
    protected JdbcMutationOperation createJdbcOptionalInsert(SharedSessionContractImplementor session) {
        if (this.getTableDetails().getInsertDetails() != null && this.getTableDetails().getInsertDetails().getCustomSql() != null || !this.getValueBindings().isEmpty()) {
            return super.createJdbcOptionalInsert(session);
        }
        OptionalTableInsert tableInsert = new OptionalTableInsert(new MutatingTableReference(this.getTableDetails()), this.getMutationTarget(), CollectionHelper.combine(this.getValueBindings(), this.getKeyBindings()), Collections.emptyList(), this.getParameters(), null, Arrays.asList(((EntityPersister)this.getMutationTarget()).getIdentifierColumnNames()));
        SessionFactoryImplementor factory = session.getSessionFactory();
        return factory.getJdbcServices().getJdbcEnvironment().getSqlAstTranslatorFactory().buildModelMutationTranslator(tableInsert, factory).translate(null, MutationQueryOptions.INSTANCE);
    }

    @Override
    public String toString() {
        return "OptionalTableUpdateWithUpsertOperation(" + String.valueOf(this.getTableDetails()) + ")";
    }
}

