/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.semconv.network.internal;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.semconv.network.NetworkAttributesGetter;
import io.opentelemetry.semconv.NetworkAttributes;
import java.util.Locale;
import javax.annotation.Nullable;

public final class InternalNetworkAttributesExtractor<REQUEST, RESPONSE> {
    private final NetworkAttributesGetter<REQUEST, RESPONSE> getter;
    private final boolean captureProtocolAttributes;
    private final boolean captureLocalSocketAttributes;

    public InternalNetworkAttributesExtractor(NetworkAttributesGetter<REQUEST, RESPONSE> getter, boolean captureProtocolAttributes, boolean captureLocalSocketAttributes) {
        this.getter = getter;
        this.captureProtocolAttributes = captureProtocolAttributes;
        this.captureLocalSocketAttributes = captureLocalSocketAttributes;
    }

    public void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response) {
        String peerAddress;
        String localAddress;
        if (this.captureProtocolAttributes) {
            AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.NETWORK_TRANSPORT, InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkTransport(request, response)));
            AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.NETWORK_TYPE, InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkType(request, response)));
            AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.NETWORK_PROTOCOL_NAME, InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkProtocolName(request, response)));
            AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.NETWORK_PROTOCOL_VERSION, InternalNetworkAttributesExtractor.lowercase(this.getter.getNetworkProtocolVersion(request, response)));
        }
        if (this.captureLocalSocketAttributes && (localAddress = this.getter.getNetworkLocalAddress(request, response)) != null) {
            AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.NETWORK_LOCAL_ADDRESS, localAddress);
            Integer localPort = this.getter.getNetworkLocalPort(request, response);
            if (localPort != null && localPort > 0) {
                AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.NETWORK_LOCAL_PORT, Long.valueOf(localPort.intValue()));
            }
        }
        if ((peerAddress = this.getter.getNetworkPeerAddress(request, response)) != null) {
            AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.NETWORK_PEER_ADDRESS, peerAddress);
            Integer peerPort = this.getter.getNetworkPeerPort(request, response);
            if (peerPort != null && peerPort > 0) {
                AttributesExtractorUtil.internalSet(attributes, NetworkAttributes.NETWORK_PEER_PORT, Long.valueOf(peerPort.intValue()));
            }
        }
    }

    @Nullable
    private static String lowercase(@Nullable String str) {
        return str == null ? null : str.toLowerCase(Locale.ROOT);
    }
}

