/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.config.spi;

import org.hibernate.engine.config.spi.ConfigurationService;

public class StandardConverters {
    public static final ConfigurationService.Converter<Boolean> BOOLEAN = StandardConverters::asBoolean;
    public static final ConfigurationService.Converter<String> STRING = StandardConverters::asString;
    public static final ConfigurationService.Converter<Integer> INTEGER = StandardConverters::asInteger;

    public static Boolean asBoolean(Object value) {
        Boolean bool;
        return value instanceof Boolean ? (bool = (Boolean)value) : Boolean.valueOf(Boolean.parseBoolean(value.toString()));
    }

    public static String asString(Object value) {
        return value.toString();
    }

    public static Integer asInteger(Object value) {
        Integer n;
        if (value instanceof Number) {
            Number number = (Number)value;
            n = number.intValue();
        } else {
            n = Integer.parseInt(value.toString());
        }
        return n;
    }

    private StandardConverters() {
    }
}

