/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.type;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.UserDefinedObjectType;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.StructJdbcType;

public class OracleBaseStructJdbcType
extends StructJdbcType {
    public OracleBaseStructJdbcType() {
        this(null, null, null);
    }

    protected OracleBaseStructJdbcType(EmbeddableMappingType embeddableMappingType, String typeName, int[] orderMapping) {
        super(embeddableMappingType, typeName == null ? null : typeName.toUpperCase(Locale.ROOT), orderMapping);
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, OracleBaseStructJdbcType.this.createJdbcValue(value, options));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, OracleBaseStructJdbcType.this.createJdbcValue(value, options));
            }

            @Override
            public Object getBindValue(X value, WrapperOptions options) throws SQLException {
                return OracleBaseStructJdbcType.this.createJdbcValue(value, options);
            }
        };
    }

    @Override
    public String getExtraCreateTableInfo(JavaType<?> javaType, String columnName, String tableName, Database database) {
        UserDefinedObjectType udt = database.getDefaultNamespace().locateUserDefinedType(Identifier.toIdentifier(this.getSqlTypeName()));
        StringBuilder sb = null;
        for (Column column : udt.getColumns()) {
            JdbcMapping jdbcMapping;
            String extraCreateTableInfo;
            Type columnType = column.getValue().getType();
            if (!(columnType instanceof JdbcMapping) || (extraCreateTableInfo = (jdbcMapping = (JdbcMapping)((Object)columnType)).getJdbcType().getExtraCreateTableInfo(jdbcMapping.getJavaTypeDescriptor(), columnName + "." + column.getName(), tableName, database)).isEmpty()) continue;
            if (sb == null) {
                sb = new StringBuilder();
            } else {
                sb.append(',');
            }
            sb.append(extraCreateTableInfo);
        }
        return sb != null ? sb.toString() : "";
    }
}

