/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.impl;

import com.google.common.collect.ImmutableListMultimap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.execution.history.ImmutableWorkspaceMetadata;
import org.gradle.internal.execution.history.ImmutableWorkspaceMetadataStore;
import org.gradle.internal.execution.history.impl.OriginMetadataSerializer;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.HashCodeSerializer;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

public class DefaultImmutableWorkspaceMetadataStore
implements ImmutableWorkspaceMetadataStore {
    private static final String METADATA_FILE = "metadata.bin";
    private final HashCodeSerializer hashCodeSerializer = new HashCodeSerializer();
    private final OriginMetadataSerializer originMetadataSerializer = new OriginMetadataSerializer();

    @Override
    public Optional<ImmutableWorkspaceMetadata> loadWorkspaceMetadata(File workspace) {
        Optional<ImmutableWorkspaceMetadata> optional;
        File metadataFile = new File(workspace, METADATA_FILE);
        if (!metadataFile.exists()) {
            return Optional.empty();
        }
        KryoBackedDecoder decoder = new KryoBackedDecoder((InputStream)new FileInputStream(metadataFile));
        try {
            OriginMetadata originMetadata = this.originMetadataSerializer.read((Decoder)decoder);
            int outputCount = decoder.readSmallInt();
            ImmutableListMultimap.Builder outputPropertyHashes = ImmutableListMultimap.builder();
            for (int outputIndex = 0; outputIndex < outputCount; ++outputIndex) {
                String outputProperty = decoder.readString();
                int hashCount = decoder.readSmallInt();
                for (int hashIndex = 0; hashIndex < hashCount; ++hashIndex) {
                    HashCode hashCode = this.hashCodeSerializer.read((Decoder)decoder);
                    outputPropertyHashes.put((Object)outputProperty, (Object)hashCode);
                }
            }
            optional = Optional.of(new ImmutableWorkspaceMetadata(originMetadata, (ImmutableListMultimap<String, HashCode>)outputPropertyHashes.build()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    decoder.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Could not read workspace metadata from " + metadataFile, e);
            }
        }
        decoder.close();
        return optional;
    }

    @Override
    public void storeWorkspaceMetadata(File workspace, ImmutableWorkspaceMetadata metadata) {
        File metadataFile = new File(workspace, METADATA_FILE);
        try (KryoBackedEncoder encoder = new KryoBackedEncoder((OutputStream)new FileOutputStream(metadataFile));){
            this.originMetadataSerializer.write((Encoder)encoder, metadata.getOriginMetadata());
            ImmutableListMultimap<String, HashCode> outputPropertyHashes = metadata.getOutputPropertyHashes();
            encoder.writeSmallInt(outputPropertyHashes.keySet().size());
            for (Map.Entry entry : outputPropertyHashes.asMap().entrySet()) {
                encoder.writeString((CharSequence)entry.getKey());
                Collection hashes = (Collection)entry.getValue();
                encoder.writeSmallInt(hashes.size());
                for (HashCode hash : hashes) {
                    this.hashCodeSerializer.write((Encoder)encoder, hash);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not write workspace metadata to " + metadataFile, e);
        }
    }
}

