/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resources;

import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockContainer;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTrackedResourceLock
implements ResourceLock {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTrackedResourceLock.class);
    private final String displayName;
    private final ResourceLockCoordinationService coordinationService;
    private final ResourceLockContainer owner;

    public AbstractTrackedResourceLock(String displayName, ResourceLockCoordinationService coordinationService, ResourceLockContainer owner) {
        this.displayName = displayName;
        this.coordinationService = coordinationService;
        this.owner = owner;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getDisplayName();
    }

    @Override
    public boolean tryLock() {
        if (!this.isLockedByCurrentThread()) {
            if (this.acquireLock()) {
                LOGGER.debug("{}: acquired lock on {}", (Object)Thread.currentThread().getName(), (Object)this.displayName);
                try {
                    this.owner.lockAcquired(this);
                }
                catch (RuntimeException e) {
                    this.releaseLock();
                    throw e;
                }
                this.coordinationService.getCurrent().registerLocked(this);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void unlock() {
        if (this.isLockedByCurrentThread()) {
            this.releaseLock();
            LOGGER.debug("{}: released lock on {}", (Object)Thread.currentThread().getName(), (Object)this.displayName);
            try {
                this.owner.lockReleased(this);
            }
            finally {
                this.coordinationService.getCurrent().registerUnlocked(this);
            }
        }
    }

    @Override
    public boolean isLocked() {
        this.failIfNotInResourceLockStateChange();
        return this.doIsLocked();
    }

    @Override
    public boolean isLockedByCurrentThread() {
        this.failIfNotInResourceLockStateChange();
        return this.doIsLockedByCurrentThread();
    }

    private void failIfNotInResourceLockStateChange() {
        if (this.coordinationService.getCurrent() == null) {
            throw new IllegalStateException("No ResourceLockState is associated with this thread.");
        }
    }

    protected abstract boolean acquireLock();

    protected abstract void releaseLock();

    protected abstract boolean doIsLocked();

    protected abstract boolean doIsLockedByCurrentThread();

    @Override
    public String getDisplayName() {
        return this.displayName;
    }
}

