/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data.ISF;

import ghidra.program.model.data.AbstractComplexDataType;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.VoidDataType;

public class IsfUtilities {
    public static DataType getBaseDataType(DataType dt) {
        while (dt != null) {
            if (dt instanceof Array) {
                Array array = (Array)dt;
                dt = array.getDataType();
                continue;
            }
            if (dt instanceof Pointer) {
                Pointer pointer = (Pointer)dt;
                dt = pointer.getDataType();
                continue;
            }
            if (!(dt instanceof BitFieldDataType)) break;
            BitFieldDataType bitfieldDt = (BitFieldDataType)dt;
            dt = bitfieldDt.getBaseDataType();
        }
        return dt;
    }

    public static DataType getArrayBaseType(Array arrayDt) {
        DataType dataType = arrayDt.getDataType();
        while (dataType instanceof Array) {
            dataType = ((Array)dataType).getDataType();
        }
        return dataType;
    }

    public static DataType getPointerBaseDataType(Pointer p) {
        DataType dt = p.getDataType();
        while (dt instanceof Pointer) {
            dt = ((Pointer)dt).getDataType();
        }
        return dt;
    }

    public static String getKind(DataType dt) {
        if (dt instanceof Array) {
            return "array";
        }
        if (dt instanceof Structure) {
            return "struct";
        }
        if (dt instanceof Union) {
            return "union";
        }
        if (dt instanceof BuiltInDataType) {
            return "base";
        }
        if (dt instanceof Pointer) {
            return "pointer";
        }
        if (dt instanceof Enum) {
            return "enum";
        }
        if (dt instanceof TypeDef) {
            return "typedef";
        }
        if (dt instanceof FunctionDefinition) {
            return "function";
        }
        if (dt instanceof BitFieldDataType) {
            return "bitfield";
        }
        if (dt instanceof DefaultDataType) {
            return "base";
        }
        return "UNKNOWN";
    }

    public static String getBuiltInKind(BuiltInDataType dt) {
        if (dt instanceof AbstractIntegerDataType) {
            return dt.getName();
        }
        if (dt instanceof AbstractFloatDataType) {
            return "float";
        }
        if (dt instanceof AbstractComplexDataType) {
            return "complex";
        }
        if (dt instanceof AbstractStringDataType) {
            return "char";
        }
        if (dt instanceof PointerDataType) {
            return "pointer";
        }
        if (dt instanceof VoidDataType) {
            return "void";
        }
        if (dt instanceof Undefined) {
            return "void";
        }
        return "char";
    }

    public static boolean isBaseDataType(DataType dt) {
        if (dt instanceof AbstractIntegerDataType) {
            return true;
        }
        if (dt instanceof AbstractFloatDataType) {
            return true;
        }
        if (dt instanceof AbstractComplexDataType) {
            return true;
        }
        if (dt instanceof AbstractStringDataType) {
            return true;
        }
        if (dt instanceof Pointer) {
            return true;
        }
        if (dt instanceof VoidDataType) {
            return true;
        }
        return dt instanceof Undefined;
    }

    public static Integer getLength(DataType dt) {
        return dt.getLength();
    }

    public static String getEndianness(DataType dt) {
        return dt.getDataOrganization().isBigEndian() ? "big" : "little";
    }
}

