/*
 * Decompiled with CFR 0.152.
 */
package generic.test;

import generic.test.TestReportingException;
import generic.test.TestThread;
import java.util.Map;
import java.util.Set;

public class TestExceptionTracker {
    private String threadName;
    private Throwable t;
    private StackTraceElement[] testThreadTrace;

    public TestExceptionTracker(String threadName, Throwable t) {
        this.threadName = threadName;
        this.t = t;
        this.testThreadTrace = this.recordTestThreadState();
    }

    private StackTraceElement[] recordTestThreadState() {
        Map<Thread, StackTraceElement[]> allStackTraces = Thread.getAllStackTraces();
        Set<Map.Entry<Thread, StackTraceElement[]>> entrySet = allStackTraces.entrySet();
        for (Map.Entry<Thread, StackTraceElement[]> entry : entrySet) {
            Thread thread = entry.getKey();
            if (!TestThread.isTestThread(thread)) continue;
            StackTraceElement[] fullTrace = entry.getValue();
            StackTraceElement[] filtered = TestThread.filterTrace(fullTrace);
            return filtered;
        }
        return new StackTraceElement[0];
    }

    public Throwable getException() {
        return this.t;
    }

    public Throwable getCombinedException() {
        TestReportingException exception = new TestReportingException(this.threadName, this.t, this.testThreadTrace);
        return exception;
    }

    public void printStackTrace() {
        Throwable throwable = this.getCombinedException();
        throwable.printStackTrace();
    }

    public StackTraceElement[] getStackTrace() {
        return this.testThreadTrace;
    }

    public String getExceptionMessage() {
        String message = this.t.getMessage();
        if (message != null) {
            return message;
        }
        return this.t.getClass().getSimpleName();
    }

    public String getThreadName() {
        return this.threadName;
    }
}

