/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser;

import java.util.Arrays;
import org.jspecify.annotations.Nullable;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Entities;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.CharacterReader;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.ParseError;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.ParseErrorList;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.Token;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.TokeniserState;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.parser.TreeBuilder;

final class Tokeniser {
    private static final char[] notCharRefCharsSorted = new char[]{'\t', '\n', '\r', '\f', ' ', '<', '&'};
    static final int[] win1252Extensions = new int[]{8364, 129, 8218, 402, 8222, 8230, 8224, 8225, 710, 8240, 352, 8249, 338, 141, 381, 143, 144, 8216, 8217, 8220, 8221, 8226, 8211, 8212, 732, 8482, 353, 8250, 339, 157, 382, 376};
    private final CharacterReader reader;
    private final ParseErrorList errors;
    private TokeniserState state = TokeniserState.Data;
    private @Nullable Token emitPending = null;
    private boolean isEmitPending = false;
    private @Nullable String charsString = null;
    private final StringBuilder charsBuilder = new StringBuilder(1024);
    final StringBuilder dataBuffer = new StringBuilder(1024);
    final Token.StartTag startPending;
    final Token.EndTag endPending;
    Token.Tag tagPending;
    final Token.Character charPending = new Token.Character();
    final Token.Doctype doctypePending = new Token.Doctype();
    final Token.Comment commentPending = new Token.Comment();
    private @Nullable String lastStartTag;
    private @Nullable String lastStartCloseSeq;
    private int markupStartPos;
    private int charStartPos = 0;
    private final int[] codepointHolder = new int[1];
    private final int[] multipointHolder = new int[2];

    /*
     * WARNING - void declaration
     */
    Tokeniser(TreeBuilder treeBuilder) {
        void var1_1;
        this.startPending = new Token.StartTag(treeBuilder);
        this.tagPending = this.startPending;
        this.endPending = new Token.EndTag(treeBuilder);
        this.reader = treeBuilder.reader;
        this.errors = var1_1.parser.getErrors();
    }

    /*
     * WARNING - void declaration
     */
    final Token read() {
        while (!this.isEmitPending) {
            Tokeniser tokeniser = this;
            this.state.read(tokeniser, tokeniser.reader);
        }
        StringBuilder cb = this.charsBuilder;
        if (cb.length() != 0) {
            void var1_1;
            String str = cb.toString();
            cb.delete(0, cb.length());
            Token.Character token = this.charPending.data(str);
            this.charsString = null;
            return var1_1;
        }
        if (this.charsString != null) {
            void var2_3;
            Token.Character token = this.charPending.data(this.charsString);
            this.charsString = null;
            return var2_3;
        }
        this.isEmitPending = false;
        assert (this.emitPending != null);
        return this.emitPending;
    }

    /*
     * WARNING - void declaration
     */
    final void emit(Token token) {
        Token.EndTag endTag;
        Token.StartTag startTag;
        Validate.isFalse(this.isEmitPending);
        this.emitPending = token;
        this.isEmitPending = true;
        token.startPos(this.markupStartPos);
        token.endPos(this.reader.pos());
        this.charStartPos = -1;
        if (token.type == Token.TokenType.StartTag) {
            startTag = (Token.StartTag)token;
            this.lastStartTag = startTag.tagName;
            this.lastStartCloseSeq = null;
            return;
        }
        if (startTag.type == Token.TokenType.EndTag && (endTag = (Token.EndTag)((Object)startTag)).hasAttributes()) {
            void var1_1;
            this.error("Attributes incorrectly present on end tag [/%s]", var1_1.normalName());
        }
    }

    /*
     * WARNING - void declaration
     */
    final void emit(String str) {
        if (this.charsString == null) {
            this.charsString = str;
        } else {
            void var1_1;
            if (this.charsBuilder.length() == 0) {
                this.charsBuilder.append(this.charsString);
            }
            this.charsBuilder.append((String)var1_1);
        }
        this.charPending.startPos(this.charStartPos);
        this.charPending.endPos(this.reader.pos());
    }

    /*
     * WARNING - void declaration
     */
    final void emit(StringBuilder str) {
        if (this.charsString == null) {
            this.charsString = str.toString();
        } else {
            void var1_1;
            if (this.charsBuilder.length() == 0) {
                this.charsBuilder.append(this.charsString);
            }
            this.charsBuilder.append((CharSequence)var1_1);
        }
        this.charPending.startPos(this.charStartPos);
        this.charPending.endPos(this.reader.pos());
    }

    /*
     * WARNING - void declaration
     */
    final void emit(char c) {
        if (this.charsString == null) {
            this.charsString = String.valueOf(c);
        } else {
            void var1_1;
            if (this.charsBuilder.length() == 0) {
                this.charsBuilder.append(this.charsString);
            }
            this.charsBuilder.append((char)var1_1);
        }
        this.charPending.startPos(this.charStartPos);
        this.charPending.endPos(this.reader.pos());
    }

    /*
     * WARNING - void declaration
     */
    final void emit(int[] codepoints) {
        void var1_1;
        this.emit(new String(codepoints, 0, ((void)var1_1).length));
    }

    /*
     * WARNING - void declaration
     */
    final void transition(TokeniserState newState) {
        void var1_1;
        switch (newState) {
            case TagOpen: {
                this.markupStartPos = this.reader.pos();
                break;
            }
            case Data: {
                if (this.charStartPos != -1) break;
                this.charStartPos = this.reader.pos();
            }
        }
        this.state = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final void advanceTransition(TokeniserState newState) {
        void var1_1;
        this.transition((TokeniserState)var1_1);
        this.reader.advance();
    }

    /*
     * WARNING - void declaration
     */
    final @Nullable int[] consumeCharacterReference(@Nullable Character additionalAllowedCharacter, boolean inAttribute) {
        void var3_4;
        void var2_2;
        int numChars;
        int base;
        if (this.reader.isEmpty()) {
            return null;
        }
        if (additionalAllowedCharacter != null && additionalAllowedCharacter.charValue() == this.reader.current()) {
            return null;
        }
        if (this.reader.matchesAnySorted(notCharRefCharsSorted)) {
            return null;
        }
        int[] codeRef = this.codepointHolder;
        this.reader.mark();
        if (this.reader.matchConsume("#")) {
            boolean isHexMode = this.reader.matchConsumeIgnoreCase("X");
            String numRef = isHexMode ? this.reader.consumeHexSequence() : this.reader.consumeDigitSequence();
            if (numRef.length() == 0) {
                this.characterReferenceError("numeric reference with no numerals", new Object[0]);
                this.reader.rewindToMark();
                return null;
            }
            this.reader.unmark();
            if (!this.reader.matchConsume(";")) {
                this.characterReferenceError("missing semicolon on [&#%s]", numRef);
            }
            int charval = -1;
            try {
                base = isHexMode ? 16 : 10;
                charval = Integer.valueOf(numRef, base);
            }
            catch (NumberFormatException numberFormatException) {}
            if (charval == -1 || charval > 0x10FFFF) {
                this.characterReferenceError("character [%s] outside of valid range", charval);
                codeRef[0] = 65533;
            } else {
                if (charval >= 128 && charval < 128 + win1252Extensions.length) {
                    this.characterReferenceError("character [%s] is not a valid unicode code point", charval);
                    charval = win1252Extensions[charval - 128];
                }
                codeRef[0] = charval;
            }
            return codeRef;
        }
        String nameRef = this.reader.consumeLetterThenDigitSequence();
        boolean looksLegit = this.reader.matches(';');
        boolean bl = Entities.isBaseNamedEntity(nameRef) || Entities.isNamedEntity(nameRef) && looksLegit;
        if (!bl) {
            this.reader.rewindToMark();
            if (looksLegit) {
                this.characterReferenceError("invalid named reference [%s]", nameRef);
            }
            return null;
        }
        if (base != 0 && (this.reader.matchesLetter() || this.reader.matchesDigit() || this.reader.matchesAny('=', '-', '_'))) {
            this.reader.rewindToMark();
            return null;
        }
        this.reader.unmark();
        if (!this.reader.matchConsume(";")) {
            this.characterReferenceError("missing semicolon on [&%s]", nameRef);
        }
        if ((numChars = Entities.codepointsForName(nameRef, this.multipointHolder)) == 1) {
            void var1_1;
            codeRef[0] = this.multipointHolder[0];
            return var1_1;
        }
        if (var2_2 == 2) {
            return this.multipointHolder;
        }
        Validate.fail("Unexpected characters returned for " + (String)var3_4);
        return this.multipointHolder;
    }

    /*
     * WARNING - void declaration
     */
    final Token.Tag createTagPending(boolean start) {
        void var1_1;
        this.tagPending = var1_1 != false ? this.startPending.reset() : this.endPending.reset();
        return this.tagPending;
    }

    final void emitTagPending() {
        this.tagPending.finaliseTag();
        Tokeniser tokeniser = this;
        tokeniser.emit(tokeniser.tagPending);
    }

    final void createCommentPending() {
        this.commentPending.reset();
    }

    final void emitCommentPending() {
        Tokeniser tokeniser = this;
        tokeniser.emit(tokeniser.commentPending);
    }

    final void createBogusCommentPending() {
        this.commentPending.reset();
        this.commentPending.bogus = true;
    }

    final void createDoctypePending() {
        this.doctypePending.reset();
    }

    final void emitDoctypePending() {
        Tokeniser tokeniser = this;
        tokeniser.emit(tokeniser.doctypePending);
    }

    final void createTempBuffer() {
        Token.reset(this.dataBuffer);
    }

    final boolean isAppropriateEndTagToken() {
        return this.lastStartTag != null && this.tagPending.name().equalsIgnoreCase(this.lastStartTag);
    }

    final @Nullable String appropriateEndTagName() {
        return this.lastStartTag;
    }

    final String appropriateEndTagSeq() {
        if (this.lastStartCloseSeq == null) {
            this.lastStartCloseSeq = "</" + this.lastStartTag;
        }
        return this.lastStartCloseSeq;
    }

    /*
     * WARNING - void declaration
     */
    final void error(TokeniserState state) {
        if (this.errors.canAddError()) {
            void var1_1;
            this.errors.add(new ParseError(this.reader, "Unexpected character '%s' in input state [%s]", Character.valueOf(this.reader.current()), var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    final void eofError(TokeniserState state) {
        if (this.errors.canAddError()) {
            void var1_1;
            this.errors.add(new ParseError(this.reader, "Unexpectedly reached end of file (EOF) in input state [%s]", var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void characterReferenceError(String message, Object ... args) {
        if (this.errors.canAddError()) {
            void var2_2;
            void var1_1;
            this.errors.add(new ParseError(this.reader, String.format("Invalid character reference: " + (String)var1_1, (Object[])var2_2)));
        }
    }

    /*
     * WARNING - void declaration
     */
    final void error(String errorMsg, Object ... args) {
        if (this.errors.canAddError()) {
            void var2_2;
            void var1_1;
            this.errors.add(new ParseError(this.reader, (String)var1_1, (Object[])var2_2));
        }
    }

    static {
        Arrays.sort(notCharRefCharsSorted);
    }
}

