/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IOUtil {
    public static final int EOF = -1;

    private IOUtil() {
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be positive");
        }
        return IOUtil.copy(input, output, new byte[bufferSize]);
    }

    public static long copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int n;
        if (buffer.length == 0) {
            throw new IllegalArgumentException("Buffer must be not empty");
        }
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

