/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffprobe;

import com.github.kokorin.jaffree.ffprobe.Stream;
import com.github.kokorin.jaffree.ffprobe.TagAware;
import com.github.kokorin.jaffree.ffprobe.data.ProbeData;
import java.util.List;

public class Program
implements TagAware {
    private final ProbeData probeData;

    public Program(ProbeData probeData) {
        this.probeData = probeData;
    }

    @Override
    public ProbeData getProbeData() {
        return this.probeData;
    }

    public List<Stream> getStreams() {
        return this.probeData.getSubDataList("streams", Stream::new);
    }

    public Integer getProgramId() {
        return this.probeData.getInteger("program_id");
    }

    public Integer getProgramNum() {
        return this.probeData.getInteger("program_num");
    }

    public Integer getNbStreams() {
        return this.probeData.getInteger("nb_streams");
    }

    public Float getStartTime() {
        return this.probeData.getFloat("start_time");
    }

    public Long getStartPts() {
        return this.probeData.getLong("start_pts");
    }

    public Float getEndTime() {
        return this.probeData.getFloat("end_time");
    }

    public Long getEndPts() {
        return this.probeData.getLong("end_pts");
    }

    public Integer getPmtPid() {
        return this.probeData.getInteger("pmt_pid");
    }

    public Integer getPcrPid() {
        return this.probeData.getInteger("pcr_pid");
    }
}

