/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.duplicates.details;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.AbstractTableComparatorChooser;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.NoSuchElementException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import mediathek.config.Daten;
import mediathek.daten.DatenFilm;
import mediathek.gui.duplicates.details.DuplicateFilmDetailsTableFormat;
import mediathek.tool.ApplicationConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.sync.LockMode;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class DuplicateFilmDetailsDialog
extends JDialog {
    private static final String CONFIG_X = "duplicate_film_details_dialog.x";
    private static final String CONFIG_Y = "duplicate_film_details_dialog.y";
    private static final String CONFIG_HEIGHT = "duplicate_film_details_dialog.height";
    private static final String CONFIG_WIDTH = "duplicate_film_details_dialog.width";
    private static final Logger logger = LogManager.getLogger();
    private JTable table1;
    private JButton okButton;

    public DuplicateFilmDetailsDialog(Window owner, @NotNull DatenFilm film) {
        super(owner);
        this.initComponents();
        this.okButton.addActionListener(e -> this.dispose());
        BasicEventList duplicateList = new BasicEventList();
        SortedList sortedList = new SortedList((EventList)duplicateList);
        AdvancedTableModel model = GlazedListsSwing.eventTableModelWithThreadProxyList((EventList)sortedList, (TableFormat)new DuplicateFilmDetailsTableFormat());
        this.table1.setModel((TableModel)model);
        TableComparatorChooser.install((JTable)this.table1, (SortedList)sortedList, (Object)AbstractTableComparatorChooser.SINGLE_COLUMN);
        this.table1.getColumnModel().getColumn(0).setPreferredWidth(90);
        this.table1.getColumnModel().getColumn(1).setPreferredWidth(120);
        this.table1.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.table1.getColumnModel().getColumn(5).setPreferredWidth(400);
        this.table1.getColumnModel().getColumn(6).setPreferredWidth(400);
        String url = film.getUrlNormalQuality();
        Daten.getInstance().getListeFilme().parallelStream().filter(f -> f.getUrlNormalQuality().equals(url)).forEach(arg_0 -> ((BasicEventList)duplicateList).add(arg_0));
        this.restorePosition();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                DuplicateFilmDetailsDialog.this.savePosition();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restorePosition() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.READ);
            int x = config.getInt(CONFIG_X);
            int y = config.getInt(CONFIG_Y);
            int width = config.getInt(CONFIG_WIDTH);
            int height = config.getInt(CONFIG_HEIGHT);
            this.setSize(width, height);
            this.setLocation(x, y);
        }
        catch (NoSuchElementException e) {
            this.pack();
        }
        catch (Exception ex) {
            logger.error("Unhandled Exception", (Throwable)ex);
            this.pack();
        }
        finally {
            config.unlock(LockMode.READ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePosition() {
        Configuration config = ApplicationConfiguration.getConfiguration();
        try {
            config.lock(LockMode.WRITE);
            Dimension size = this.getSize();
            Point location = this.getLocation();
            config.setProperty(CONFIG_WIDTH, (Object)size.width);
            config.setProperty(CONFIG_HEIGHT, (Object)size.height);
            config.setProperty(CONFIG_X, (Object)location.x);
            config.setProperty(CONFIG_Y, (Object)location.y);
        }
        finally {
            config.unlock(LockMode.WRITE);
        }
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JPanel contentPanel = new JPanel();
        JScrollPane scrollPane1 = new JScrollPane();
        this.table1 = new JTable();
        JPanel buttonBar = new JPanel();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setTitle("Zusammengeh\u00f6rige Filme");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        dialogPane.setLayout(new BorderLayout());
        contentPanel.setLayout(new BorderLayout());
        this.table1.setAutoResizeMode(0);
        this.table1.setSelectionMode(0);
        this.table1.setShowHorizontalLines(false);
        this.table1.setShowVerticalLines(false);
        this.table1.setPreferredScrollableViewportSize(new Dimension(500, 150));
        scrollPane1.setViewportView(this.table1);
        contentPanel.add((Component)scrollPane1, "Center");
        dialogPane.add((Component)contentPanel, "Center");
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)buttonBar.getLayout()).columnWidths = new int[]{0, 80};
        ((GridBagLayout)buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0};
        this.okButton.setText("Schlie\u00dfen");
        buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        dialogPane.add((Component)buttonBar, "South");
        contentPane.add((Component)dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

